// chrome/browser/ui/webui/tab_search/tab_search.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/tab_search/tab_search.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/tab_search/tab_search.mojom-params-data.h"
#include "chrome/browser/ui/webui/tab_search/tab_search.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/tab_search/tab_search.mojom-import-headers.h"
#include "chrome/browser/ui/webui/tab_search/tab_search.mojom-test-utils.h"


namespace tab_search::mojom {
ProfileData::ProfileData()
    : windows(),
      tab_groups(),
      recently_closed_tabs(),
      recently_closed_tab_groups(),
      recently_closed_section_expanded() {}

ProfileData::ProfileData(
    std::vector<WindowPtr> windows_in,
    std::vector<TabGroupPtr> tab_groups_in,
    std::vector<RecentlyClosedTabPtr> recently_closed_tabs_in,
    std::vector<RecentlyClosedTabGroupPtr> recently_closed_tab_groups_in,
    bool recently_closed_section_expanded_in)
    : windows(std::move(windows_in)),
      tab_groups(std::move(tab_groups_in)),
      recently_closed_tabs(std::move(recently_closed_tabs_in)),
      recently_closed_tab_groups(std::move(recently_closed_tab_groups_in)),
      recently_closed_section_expanded(std::move(recently_closed_section_expanded_in)) {}

ProfileData::~ProfileData() = default;

void ProfileData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "windows"), this->windows,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<WindowPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_groups"), this->tab_groups,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<TabGroupPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recently_closed_tabs"), this->recently_closed_tabs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<RecentlyClosedTabPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recently_closed_tab_groups"), this->recently_closed_tab_groups,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<RecentlyClosedTabGroupPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recently_closed_section_expanded"), this->recently_closed_section_expanded,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProfileData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Window::Window()
    : active(),
      is_host_window(),
      height(),
      tabs() {}

Window::Window(
    bool active_in,
    bool is_host_window_in,
    uint32_t height_in,
    std::vector<TabPtr> tabs_in)
    : active(std::move(active_in)),
      is_host_window(std::move(is_host_window_in)),
      height(std::move(height_in)),
      tabs(std::move(tabs_in)) {}

Window::~Window() = default;

void Window::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active"), this->active,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_host_window"), this->is_host_window,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "height"), this->height,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tabs"), this->tabs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<TabPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Window::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Tab::Tab()
    : active(),
      visible(),
      alert_states(),
      index(),
      tab_id(),
      group_id(),
      pinned(),
      split(),
      title(),
      url(),
      favicon_url(),
      is_default_favicon(),
      show_icon(),
      last_active_time_ticks(),
      last_active_elapsed_text() {}

Tab::Tab(
    bool active_in,
    bool visible_in,
    std::vector<::tabs::TabAlert> alert_states_in,
    int32_t index_in,
    int32_t tab_id_in,
    const std::optional<::base::Token>& group_id_in,
    bool pinned_in,
    bool split_in,
    const std::string& title_in,
    const ::GURL& url_in,
    const std::optional<::GURL>& favicon_url_in,
    bool is_default_favicon_in,
    bool show_icon_in,
    ::base::TimeTicks last_active_time_ticks_in,
    const std::string& last_active_elapsed_text_in)
    : active(std::move(active_in)),
      visible(std::move(visible_in)),
      alert_states(std::move(alert_states_in)),
      index(std::move(index_in)),
      tab_id(std::move(tab_id_in)),
      group_id(std::move(group_id_in)),
      pinned(std::move(pinned_in)),
      split(std::move(split_in)),
      title(std::move(title_in)),
      url(std::move(url_in)),
      favicon_url(std::move(favicon_url_in)),
      is_default_favicon(std::move(is_default_favicon_in)),
      show_icon(std::move(show_icon_in)),
      last_active_time_ticks(std::move(last_active_time_ticks_in)),
      last_active_elapsed_text(std::move(last_active_elapsed_text_in)) {}

Tab::~Tab() = default;

void Tab::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active"), this->active,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible"), this->visible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alert_states"), this->alert_states,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::tabs::TabAlert>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "index"), this->index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_id"), this->tab_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::Token>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pinned"), this->pinned,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "split"), this->split,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "favicon_url"), this->favicon_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_default_favicon"), this->is_default_favicon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_icon"), this->show_icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_active_time_ticks"), this->last_active_time_ticks,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_active_elapsed_text"), this->last_active_elapsed_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Tab::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RecentlyClosedTab::RecentlyClosedTab()
    : tab_id(),
      group_id(),
      title(),
      url(),
      last_active_time(),
      last_active_elapsed_text() {}

RecentlyClosedTab::RecentlyClosedTab(
    int32_t tab_id_in,
    const std::optional<::base::Token>& group_id_in,
    const std::string& title_in,
    const ::GURL& url_in,
    ::base::Time last_active_time_in,
    const std::string& last_active_elapsed_text_in)
    : tab_id(std::move(tab_id_in)),
      group_id(std::move(group_id_in)),
      title(std::move(title_in)),
      url(std::move(url_in)),
      last_active_time(std::move(last_active_time_in)),
      last_active_elapsed_text(std::move(last_active_elapsed_text_in)) {}

RecentlyClosedTab::~RecentlyClosedTab() = default;

void RecentlyClosedTab::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_id"), this->tab_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::Token>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_active_time"), this->last_active_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_active_elapsed_text"), this->last_active_elapsed_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RecentlyClosedTab::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabGroup::TabGroup()
    : id(),
      color(),
      title() {}

TabGroup::TabGroup(
    const ::base::Token& id_in,
    ::tab_groups::TabGroupColorId color_in,
    const std::string& title_in)
    : id(std::move(id_in)),
      color(std::move(color_in)),
      title(std::move(title_in)) {}

TabGroup::~TabGroup() = default;

void TabGroup::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Token&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::tab_groups::TabGroupColorId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabGroup::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RecentlyClosedTabGroup::RecentlyClosedTabGroup()
    : session_id(),
      id(),
      color(),
      title(),
      tab_count(),
      last_active_time(),
      last_active_elapsed_text() {}

RecentlyClosedTabGroup::RecentlyClosedTabGroup(
    int32_t session_id_in,
    const ::base::Token& id_in,
    ::tab_groups::TabGroupColorId color_in,
    const std::string& title_in,
    uint32_t tab_count_in,
    ::base::Time last_active_time_in,
    const std::string& last_active_elapsed_text_in)
    : session_id(std::move(session_id_in)),
      id(std::move(id_in)),
      color(std::move(color_in)),
      title(std::move(title_in)),
      tab_count(std::move(tab_count_in)),
      last_active_time(std::move(last_active_time_in)),
      last_active_elapsed_text(std::move(last_active_elapsed_text_in)) {}

RecentlyClosedTabGroup::~RecentlyClosedTabGroup() = default;

void RecentlyClosedTabGroup::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_id"), this->session_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Token&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::tab_groups::TabGroupColorId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_count"), this->tab_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_active_time"), this->last_active_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_active_elapsed_text"), this->last_active_elapsed_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RecentlyClosedTabGroup::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SwitchToTabInfo::SwitchToTabInfo()
    : tab_id() {}

SwitchToTabInfo::SwitchToTabInfo(
    int32_t tab_id_in)
    : tab_id(std::move(tab_id_in)) {}

SwitchToTabInfo::~SwitchToTabInfo() = default;
size_t SwitchToTabInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->tab_id);
  return seed;
}

void SwitchToTabInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_id"), this->tab_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SwitchToTabInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabOrganization::TabOrganization()
    : organization_id(),
      tabs(),
      first_new_tab_index(),
      name() {}

TabOrganization::TabOrganization(
    int32_t organization_id_in,
    std::vector<TabPtr> tabs_in,
    int32_t first_new_tab_index_in,
    const ::std::u16string& name_in)
    : organization_id(std::move(organization_id_in)),
      tabs(std::move(tabs_in)),
      first_new_tab_index(std::move(first_new_tab_index_in)),
      name(std::move(name_in)) {}

TabOrganization::~TabOrganization() = default;

void TabOrganization::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "organization_id"), this->organization_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tabs"), this->tabs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<TabPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_new_tab_index"), this->first_new_tab_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabOrganization::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabOrganizationSession::TabOrganizationSession()
    : session_id(),
      state(),
      organizations(),
      error(),
      active_tab_id() {}

TabOrganizationSession::TabOrganizationSession(
    int32_t session_id_in,
    TabOrganizationState state_in,
    std::vector<TabOrganizationPtr> organizations_in,
    TabOrganizationError error_in,
    int32_t active_tab_id_in)
    : session_id(std::move(session_id_in)),
      state(std::move(state_in)),
      organizations(std::move(organizations_in)),
      error(std::move(error_in)),
      active_tab_id(std::move(active_tab_id_in)) {}

TabOrganizationSession::~TabOrganizationSession() = default;

void TabOrganizationSession::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_id"), this->session_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TabOrganizationState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "organizations"), this->organizations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<TabOrganizationPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error"), this->error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TabOrganizationError>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active_tab_id"), this->active_tab_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabOrganizationSession::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabUpdateInfo::TabUpdateInfo()
    : in_active_window(),
      in_host_window(),
      tab() {}

TabUpdateInfo::TabUpdateInfo(
    bool in_active_window_in,
    bool in_host_window_in,
    TabPtr tab_in)
    : in_active_window(std::move(in_active_window_in)),
      in_host_window(std::move(in_host_window_in)),
      tab(std::move(tab_in)) {}

TabUpdateInfo::~TabUpdateInfo() = default;

void TabUpdateInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "in_active_window"), this->in_active_window,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "in_host_window"), this->in_host_window,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab"), this->tab,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TabPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabUpdateInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabsRemovedInfo::TabsRemovedInfo()
    : tab_ids(),
      recently_closed_tabs() {}

TabsRemovedInfo::TabsRemovedInfo(
    std::vector<int32_t> tab_ids_in,
    std::vector<RecentlyClosedTabPtr> recently_closed_tabs_in)
    : tab_ids(std::move(tab_ids_in)),
      recently_closed_tabs(std::move(recently_closed_tabs_in)) {}

TabsRemovedInfo::~TabsRemovedInfo() = default;

void TabsRemovedInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tab_ids"), this->tab_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "recently_closed_tabs"), this->recently_closed_tabs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<RecentlyClosedTabPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabsRemovedInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UnusedTabInfo::UnusedTabInfo()
    : stale_tabs(),
      duplicate_tabs() {}

UnusedTabInfo::UnusedTabInfo(
    std::vector<TabPtr> stale_tabs_in,
    base::flat_map<std::string, std::vector<TabPtr>> duplicate_tabs_in)
    : stale_tabs(std::move(stale_tabs_in)),
      duplicate_tabs(std::move(duplicate_tabs_in)) {}

UnusedTabInfo::~UnusedTabInfo() = default;

void UnusedTabInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stale_tabs"), this->stale_tabs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<TabPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duplicate_tabs"), this->duplicate_tabs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type base::flat_map<std::string, std::vector<TabPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UnusedTabInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive tab_search::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply tab_search::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0e884c45;  // IPCStableHash for tab_search::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::tab_search::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::tab_search::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::tab_search::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kCloseTab: {
      return &PageHandler::CloseTab_Sym::IPCStableHash;
    }
    case messages::PageHandler::kCloseWebUiTab: {
      return &PageHandler::CloseWebUiTab_Sym::IPCStableHash;
    }
    case messages::PageHandler::kDeclutterTabs: {
      return &PageHandler::DeclutterTabs_Sym::IPCStableHash;
    }
    case messages::PageHandler::kAcceptTabOrganization: {
      return &PageHandler::AcceptTabOrganization_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRejectTabOrganization: {
      return &PageHandler::RejectTabOrganization_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRenameTabOrganization: {
      return &PageHandler::RenameTabOrganization_Sym::IPCStableHash;
    }
    case messages::PageHandler::kExcludeFromStaleTabs: {
      return &PageHandler::ExcludeFromStaleTabs_Sym::IPCStableHash;
    }
    case messages::PageHandler::kExcludeFromDuplicateTabs: {
      return &PageHandler::ExcludeFromDuplicateTabs_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetProfileData: {
      return &PageHandler::GetProfileData_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetUnusedTabs: {
      return &PageHandler::GetUnusedTabs_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetTabSearchSection: {
      return &PageHandler::GetTabSearchSection_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetTabOrganizationFeature: {
      return &PageHandler::GetTabOrganizationFeature_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetTabOrganizationSession: {
      return &PageHandler::GetTabOrganizationSession_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetTabOrganizationModelStrategy: {
      return &PageHandler::GetTabOrganizationModelStrategy_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetIsSplit: {
      return &PageHandler::GetIsSplit_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSwitchToTab: {
      return &PageHandler::SwitchToTab_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenRecentlyClosedEntry: {
      return &PageHandler::OpenRecentlyClosedEntry_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRequestTabOrganization: {
      return &PageHandler::RequestTabOrganization_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRemoveTabFromOrganization: {
      return &PageHandler::RemoveTabFromOrganization_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRejectSession: {
      return &PageHandler::RejectSession_Sym::IPCStableHash;
    }
    case messages::PageHandler::kReplaceActiveSplitTab: {
      return &PageHandler::ReplaceActiveSplitTab_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRestartSession: {
      return &PageHandler::RestartSession_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSaveRecentlyClosedExpandedPref: {
      return &PageHandler::SaveRecentlyClosedExpandedPref_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetOrganizationFeature: {
      return &PageHandler::SetOrganizationFeature_Sym::IPCStableHash;
    }
    case messages::PageHandler::kStartTabGroupTutorial: {
      return &PageHandler::StartTabGroupTutorial_Sym::IPCStableHash;
    }
    case messages::PageHandler::kTriggerFeedback: {
      return &PageHandler::TriggerFeedback_Sym::IPCStableHash;
    }
    case messages::PageHandler::kTriggerSignIn: {
      return &PageHandler::TriggerSignIn_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenHelpPage: {
      return &PageHandler::OpenHelpPage_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetTabOrganizationModelStrategy: {
      return &PageHandler::SetTabOrganizationModelStrategy_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetTabOrganizationUserInstruction: {
      return &PageHandler::SetTabOrganizationUserInstruction_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetUserFeedback: {
      return &PageHandler::SetUserFeedback_Sym::IPCStableHash;
    }
    case messages::PageHandler::kNotifyOrganizationUIReadyToShow: {
      return &PageHandler::NotifyOrganizationUIReadyToShow_Sym::IPCStableHash;
    }
    case messages::PageHandler::kNotifySearchUIReadyToShow: {
      return &PageHandler::NotifySearchUIReadyToShow_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kCloseTab:
            return "Receive tab_search::mojom::PageHandler::CloseTab";
      case messages::PageHandler::kCloseWebUiTab:
            return "Receive tab_search::mojom::PageHandler::CloseWebUiTab";
      case messages::PageHandler::kDeclutterTabs:
            return "Receive tab_search::mojom::PageHandler::DeclutterTabs";
      case messages::PageHandler::kAcceptTabOrganization:
            return "Receive tab_search::mojom::PageHandler::AcceptTabOrganization";
      case messages::PageHandler::kRejectTabOrganization:
            return "Receive tab_search::mojom::PageHandler::RejectTabOrganization";
      case messages::PageHandler::kRenameTabOrganization:
            return "Receive tab_search::mojom::PageHandler::RenameTabOrganization";
      case messages::PageHandler::kExcludeFromStaleTabs:
            return "Receive tab_search::mojom::PageHandler::ExcludeFromStaleTabs";
      case messages::PageHandler::kExcludeFromDuplicateTabs:
            return "Receive tab_search::mojom::PageHandler::ExcludeFromDuplicateTabs";
      case messages::PageHandler::kGetProfileData:
            return "Receive tab_search::mojom::PageHandler::GetProfileData";
      case messages::PageHandler::kGetUnusedTabs:
            return "Receive tab_search::mojom::PageHandler::GetUnusedTabs";
      case messages::PageHandler::kGetTabSearchSection:
            return "Receive tab_search::mojom::PageHandler::GetTabSearchSection";
      case messages::PageHandler::kGetTabOrganizationFeature:
            return "Receive tab_search::mojom::PageHandler::GetTabOrganizationFeature";
      case messages::PageHandler::kGetTabOrganizationSession:
            return "Receive tab_search::mojom::PageHandler::GetTabOrganizationSession";
      case messages::PageHandler::kGetTabOrganizationModelStrategy:
            return "Receive tab_search::mojom::PageHandler::GetTabOrganizationModelStrategy";
      case messages::PageHandler::kGetIsSplit:
            return "Receive tab_search::mojom::PageHandler::GetIsSplit";
      case messages::PageHandler::kSwitchToTab:
            return "Receive tab_search::mojom::PageHandler::SwitchToTab";
      case messages::PageHandler::kOpenRecentlyClosedEntry:
            return "Receive tab_search::mojom::PageHandler::OpenRecentlyClosedEntry";
      case messages::PageHandler::kRequestTabOrganization:
            return "Receive tab_search::mojom::PageHandler::RequestTabOrganization";
      case messages::PageHandler::kRemoveTabFromOrganization:
            return "Receive tab_search::mojom::PageHandler::RemoveTabFromOrganization";
      case messages::PageHandler::kRejectSession:
            return "Receive tab_search::mojom::PageHandler::RejectSession";
      case messages::PageHandler::kReplaceActiveSplitTab:
            return "Receive tab_search::mojom::PageHandler::ReplaceActiveSplitTab";
      case messages::PageHandler::kRestartSession:
            return "Receive tab_search::mojom::PageHandler::RestartSession";
      case messages::PageHandler::kSaveRecentlyClosedExpandedPref:
            return "Receive tab_search::mojom::PageHandler::SaveRecentlyClosedExpandedPref";
      case messages::PageHandler::kSetOrganizationFeature:
            return "Receive tab_search::mojom::PageHandler::SetOrganizationFeature";
      case messages::PageHandler::kStartTabGroupTutorial:
            return "Receive tab_search::mojom::PageHandler::StartTabGroupTutorial";
      case messages::PageHandler::kTriggerFeedback:
            return "Receive tab_search::mojom::PageHandler::TriggerFeedback";
      case messages::PageHandler::kTriggerSignIn:
            return "Receive tab_search::mojom::PageHandler::TriggerSignIn";
      case messages::PageHandler::kOpenHelpPage:
            return "Receive tab_search::mojom::PageHandler::OpenHelpPage";
      case messages::PageHandler::kSetTabOrganizationModelStrategy:
            return "Receive tab_search::mojom::PageHandler::SetTabOrganizationModelStrategy";
      case messages::PageHandler::kSetTabOrganizationUserInstruction:
            return "Receive tab_search::mojom::PageHandler::SetTabOrganizationUserInstruction";
      case messages::PageHandler::kSetUserFeedback:
            return "Receive tab_search::mojom::PageHandler::SetUserFeedback";
      case messages::PageHandler::kNotifyOrganizationUIReadyToShow:
            return "Receive tab_search::mojom::PageHandler::NotifyOrganizationUIReadyToShow";
      case messages::PageHandler::kNotifySearchUIReadyToShow:
            return "Receive tab_search::mojom::PageHandler::NotifySearchUIReadyToShow";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kCloseTab:
            return "Receive reply tab_search::mojom::PageHandler::CloseTab";
      case messages::PageHandler::kCloseWebUiTab:
            return "Receive reply tab_search::mojom::PageHandler::CloseWebUiTab";
      case messages::PageHandler::kDeclutterTabs:
            return "Receive reply tab_search::mojom::PageHandler::DeclutterTabs";
      case messages::PageHandler::kAcceptTabOrganization:
            return "Receive reply tab_search::mojom::PageHandler::AcceptTabOrganization";
      case messages::PageHandler::kRejectTabOrganization:
            return "Receive reply tab_search::mojom::PageHandler::RejectTabOrganization";
      case messages::PageHandler::kRenameTabOrganization:
            return "Receive reply tab_search::mojom::PageHandler::RenameTabOrganization";
      case messages::PageHandler::kExcludeFromStaleTabs:
            return "Receive reply tab_search::mojom::PageHandler::ExcludeFromStaleTabs";
      case messages::PageHandler::kExcludeFromDuplicateTabs:
            return "Receive reply tab_search::mojom::PageHandler::ExcludeFromDuplicateTabs";
      case messages::PageHandler::kGetProfileData:
            return "Receive reply tab_search::mojom::PageHandler::GetProfileData";
      case messages::PageHandler::kGetUnusedTabs:
            return "Receive reply tab_search::mojom::PageHandler::GetUnusedTabs";
      case messages::PageHandler::kGetTabSearchSection:
            return "Receive reply tab_search::mojom::PageHandler::GetTabSearchSection";
      case messages::PageHandler::kGetTabOrganizationFeature:
            return "Receive reply tab_search::mojom::PageHandler::GetTabOrganizationFeature";
      case messages::PageHandler::kGetTabOrganizationSession:
            return "Receive reply tab_search::mojom::PageHandler::GetTabOrganizationSession";
      case messages::PageHandler::kGetTabOrganizationModelStrategy:
            return "Receive reply tab_search::mojom::PageHandler::GetTabOrganizationModelStrategy";
      case messages::PageHandler::kGetIsSplit:
            return "Receive reply tab_search::mojom::PageHandler::GetIsSplit";
      case messages::PageHandler::kSwitchToTab:
            return "Receive reply tab_search::mojom::PageHandler::SwitchToTab";
      case messages::PageHandler::kOpenRecentlyClosedEntry:
            return "Receive reply tab_search::mojom::PageHandler::OpenRecentlyClosedEntry";
      case messages::PageHandler::kRequestTabOrganization:
            return "Receive reply tab_search::mojom::PageHandler::RequestTabOrganization";
      case messages::PageHandler::kRemoveTabFromOrganization:
            return "Receive reply tab_search::mojom::PageHandler::RemoveTabFromOrganization";
      case messages::PageHandler::kRejectSession:
            return "Receive reply tab_search::mojom::PageHandler::RejectSession";
      case messages::PageHandler::kReplaceActiveSplitTab:
            return "Receive reply tab_search::mojom::PageHandler::ReplaceActiveSplitTab";
      case messages::PageHandler::kRestartSession:
            return "Receive reply tab_search::mojom::PageHandler::RestartSession";
      case messages::PageHandler::kSaveRecentlyClosedExpandedPref:
            return "Receive reply tab_search::mojom::PageHandler::SaveRecentlyClosedExpandedPref";
      case messages::PageHandler::kSetOrganizationFeature:
            return "Receive reply tab_search::mojom::PageHandler::SetOrganizationFeature";
      case messages::PageHandler::kStartTabGroupTutorial:
            return "Receive reply tab_search::mojom::PageHandler::StartTabGroupTutorial";
      case messages::PageHandler::kTriggerFeedback:
            return "Receive reply tab_search::mojom::PageHandler::TriggerFeedback";
      case messages::PageHandler::kTriggerSignIn:
            return "Receive reply tab_search::mojom::PageHandler::TriggerSignIn";
      case messages::PageHandler::kOpenHelpPage:
            return "Receive reply tab_search::mojom::PageHandler::OpenHelpPage";
      case messages::PageHandler::kSetTabOrganizationModelStrategy:
            return "Receive reply tab_search::mojom::PageHandler::SetTabOrganizationModelStrategy";
      case messages::PageHandler::kSetTabOrganizationUserInstruction:
            return "Receive reply tab_search::mojom::PageHandler::SetTabOrganizationUserInstruction";
      case messages::PageHandler::kSetUserFeedback:
            return "Receive reply tab_search::mojom::PageHandler::SetUserFeedback";
      case messages::PageHandler::kNotifyOrganizationUIReadyToShow:
            return "Receive reply tab_search::mojom::PageHandler::NotifyOrganizationUIReadyToShow";
      case messages::PageHandler::kNotifySearchUIReadyToShow:
            return "Receive reply tab_search::mojom::PageHandler::NotifySearchUIReadyToShow";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::CloseTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xea3ca260;  // IPCStableHash for tab_search::mojom::PageHandler::CloseTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::CloseWebUiTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x23fc6211;  // IPCStableHash for tab_search::mojom::PageHandler::CloseWebUiTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::DeclutterTabs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe11074a8;  // IPCStableHash for tab_search::mojom::PageHandler::DeclutterTabs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::AcceptTabOrganization_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x094ab6f9;  // IPCStableHash for tab_search::mojom::PageHandler::AcceptTabOrganization
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RejectTabOrganization_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbc0d9044;  // IPCStableHash for tab_search::mojom::PageHandler::RejectTabOrganization
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RenameTabOrganization_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x064b035d;  // IPCStableHash for tab_search::mojom::PageHandler::RenameTabOrganization
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ExcludeFromStaleTabs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd1780bba;  // IPCStableHash for tab_search::mojom::PageHandler::ExcludeFromStaleTabs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ExcludeFromDuplicateTabs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8e581c76;  // IPCStableHash for tab_search::mojom::PageHandler::ExcludeFromDuplicateTabs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetProfileData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x20a9d2af;  // IPCStableHash for tab_search::mojom::PageHandler::GetProfileData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetUnusedTabs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5a1dcae8;  // IPCStableHash for tab_search::mojom::PageHandler::GetUnusedTabs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetTabSearchSection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa24ee1c0;  // IPCStableHash for tab_search::mojom::PageHandler::GetTabSearchSection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetTabOrganizationFeature_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x85a1c958;  // IPCStableHash for tab_search::mojom::PageHandler::GetTabOrganizationFeature
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetTabOrganizationSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8d832e1c;  // IPCStableHash for tab_search::mojom::PageHandler::GetTabOrganizationSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetTabOrganizationModelStrategy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1235d6b1;  // IPCStableHash for tab_search::mojom::PageHandler::GetTabOrganizationModelStrategy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetIsSplit_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x38d77cc4;  // IPCStableHash for tab_search::mojom::PageHandler::GetIsSplit
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SwitchToTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfd09a99b;  // IPCStableHash for tab_search::mojom::PageHandler::SwitchToTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenRecentlyClosedEntry_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5dca5bcc;  // IPCStableHash for tab_search::mojom::PageHandler::OpenRecentlyClosedEntry
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RequestTabOrganization_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x366ef871;  // IPCStableHash for tab_search::mojom::PageHandler::RequestTabOrganization
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RemoveTabFromOrganization_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3ae3b870;  // IPCStableHash for tab_search::mojom::PageHandler::RemoveTabFromOrganization
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RejectSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4d6ed26e;  // IPCStableHash for tab_search::mojom::PageHandler::RejectSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ReplaceActiveSplitTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x28f579c4;  // IPCStableHash for tab_search::mojom::PageHandler::ReplaceActiveSplitTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RestartSession_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x07673ffd;  // IPCStableHash for tab_search::mojom::PageHandler::RestartSession
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SaveRecentlyClosedExpandedPref_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xae32fece;  // IPCStableHash for tab_search::mojom::PageHandler::SaveRecentlyClosedExpandedPref
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetOrganizationFeature_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x506ba29e;  // IPCStableHash for tab_search::mojom::PageHandler::SetOrganizationFeature
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::StartTabGroupTutorial_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7209afcf;  // IPCStableHash for tab_search::mojom::PageHandler::StartTabGroupTutorial
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::TriggerFeedback_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa97541a8;  // IPCStableHash for tab_search::mojom::PageHandler::TriggerFeedback
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::TriggerSignIn_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc3574e53;  // IPCStableHash for tab_search::mojom::PageHandler::TriggerSignIn
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenHelpPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb291019f;  // IPCStableHash for tab_search::mojom::PageHandler::OpenHelpPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetTabOrganizationModelStrategy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x571ec030;  // IPCStableHash for tab_search::mojom::PageHandler::SetTabOrganizationModelStrategy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetTabOrganizationUserInstruction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x97b7c133;  // IPCStableHash for tab_search::mojom::PageHandler::SetTabOrganizationUserInstruction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetUserFeedback_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0596804c;  // IPCStableHash for tab_search::mojom::PageHandler::SetUserFeedback
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::NotifyOrganizationUIReadyToShow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xecabf54e;  // IPCStableHash for tab_search::mojom::PageHandler::NotifyOrganizationUIReadyToShow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::NotifySearchUIReadyToShow_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe8ac5e98;  // IPCStableHash for tab_search::mojom::PageHandler::NotifySearchUIReadyToShow
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_GetProfileData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetProfileData_ForwardToCallback(
      PageHandler::GetProfileDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetProfileData_ForwardToCallback(const PageHandler_GetProfileData_ForwardToCallback&) = delete;
  PageHandler_GetProfileData_ForwardToCallback& operator=(const PageHandler_GetProfileData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetProfileDataCallback callback_;
};

class PageHandler_GetUnusedTabs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetUnusedTabs_ForwardToCallback(
      PageHandler::GetUnusedTabsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetUnusedTabs_ForwardToCallback(const PageHandler_GetUnusedTabs_ForwardToCallback&) = delete;
  PageHandler_GetUnusedTabs_ForwardToCallback& operator=(const PageHandler_GetUnusedTabs_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetUnusedTabsCallback callback_;
};

class PageHandler_GetTabSearchSection_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetTabSearchSection_ForwardToCallback(
      PageHandler::GetTabSearchSectionCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetTabSearchSection_ForwardToCallback(const PageHandler_GetTabSearchSection_ForwardToCallback&) = delete;
  PageHandler_GetTabSearchSection_ForwardToCallback& operator=(const PageHandler_GetTabSearchSection_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetTabSearchSectionCallback callback_;
};

class PageHandler_GetTabOrganizationFeature_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetTabOrganizationFeature_ForwardToCallback(
      PageHandler::GetTabOrganizationFeatureCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetTabOrganizationFeature_ForwardToCallback(const PageHandler_GetTabOrganizationFeature_ForwardToCallback&) = delete;
  PageHandler_GetTabOrganizationFeature_ForwardToCallback& operator=(const PageHandler_GetTabOrganizationFeature_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetTabOrganizationFeatureCallback callback_;
};

class PageHandler_GetTabOrganizationSession_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetTabOrganizationSession_ForwardToCallback(
      PageHandler::GetTabOrganizationSessionCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetTabOrganizationSession_ForwardToCallback(const PageHandler_GetTabOrganizationSession_ForwardToCallback&) = delete;
  PageHandler_GetTabOrganizationSession_ForwardToCallback& operator=(const PageHandler_GetTabOrganizationSession_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetTabOrganizationSessionCallback callback_;
};

class PageHandler_GetTabOrganizationModelStrategy_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetTabOrganizationModelStrategy_ForwardToCallback(
      PageHandler::GetTabOrganizationModelStrategyCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetTabOrganizationModelStrategy_ForwardToCallback(const PageHandler_GetTabOrganizationModelStrategy_ForwardToCallback&) = delete;
  PageHandler_GetTabOrganizationModelStrategy_ForwardToCallback& operator=(const PageHandler_GetTabOrganizationModelStrategy_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetTabOrganizationModelStrategyCallback callback_;
};

class PageHandler_GetIsSplit_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetIsSplit_ForwardToCallback(
      PageHandler::GetIsSplitCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetIsSplit_ForwardToCallback(const PageHandler_GetIsSplit_ForwardToCallback&) = delete;
  PageHandler_GetIsSplit_ForwardToCallback& operator=(const PageHandler_GetIsSplit_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetIsSplitCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::CloseTab(
    int32_t in_tab_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::CloseTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kCloseTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_CloseTab_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("CloseTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::CloseWebUiTab(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_search::mojom::PageHandler::CloseWebUiTab");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kCloseWebUiTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_CloseWebUiTab_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("CloseWebUiTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::DeclutterTabs(
    const std::vector<int32_t>& in_tab_ids, const std::vector<::GURL>& in_urls) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::DeclutterTabs", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_ids"), in_tab_ids,
                        "<value of type const std::vector<int32_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("urls"), in_urls,
                        "<value of type const std::vector<::GURL>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDeclutterTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_DeclutterTabs_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tab_ids)::BaseType>
      tab_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& tab_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
    in_tab_ids,
    tab_ids_fragment,
    &tab_ids_validate_params);

  params->tab_ids.Set(
      tab_ids_fragment.is_null() ? nullptr : tab_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tab_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tab_ids in PageHandler.DeclutterTabs request");
  mojo::internal::MessageFragment<
      typename decltype(params->urls)::BaseType>
      urls_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
    in_urls,
    urls_fragment,
    &urls_validate_params);

  params->urls.Set(
      urls_fragment.is_null() ? nullptr : urls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->urls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null urls in PageHandler.DeclutterTabs request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DeclutterTabs");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::AcceptTabOrganization(
    int32_t in_session_id, int32_t in_organization_id, std::vector<TabPtr> in_tabs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::AcceptTabOrganization", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("organization_id"), in_organization_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tabs"), in_tabs,
                        "<value of type std::vector<TabPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kAcceptTabOrganization), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_AcceptTabOrganization_Params_Data> params(
          message);
  params.Allocate();

  params->session_id = in_session_id;

  params->organization_id = in_organization_id;
  mojo::internal::MessageFragment<
      typename decltype(params->tabs)::BaseType>
      tabs_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& tabs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::tab_search::mojom::TabDataView>>(
    in_tabs,
    tabs_fragment,
    &tabs_validate_params);

  params->tabs.Set(
      tabs_fragment.is_null() ? nullptr : tabs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tabs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tabs in PageHandler.AcceptTabOrganization request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("AcceptTabOrganization");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RejectTabOrganization(
    int32_t in_session_id, int32_t in_organization_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::RejectTabOrganization", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("organization_id"), in_organization_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRejectTabOrganization), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_RejectTabOrganization_Params_Data> params(
          message);
  params.Allocate();

  params->session_id = in_session_id;

  params->organization_id = in_organization_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RejectTabOrganization");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RenameTabOrganization(
    int32_t in_session_id, int32_t in_organization_id, const ::std::u16string& in_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::RenameTabOrganization", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("organization_id"), in_organization_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRenameTabOrganization), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_RenameTabOrganization_Params_Data> params(
          message);
  params.Allocate();

  params->session_id = in_session_id;

  params->organization_id = in_organization_id;
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in PageHandler.RenameTabOrganization request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RenameTabOrganization");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ExcludeFromStaleTabs(
    int32_t in_tab_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::ExcludeFromStaleTabs", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kExcludeFromStaleTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_ExcludeFromStaleTabs_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ExcludeFromStaleTabs");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ExcludeFromDuplicateTabs(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::ExcludeFromDuplicateTabs", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kExcludeFromDuplicateTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_ExcludeFromDuplicateTabs_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in PageHandler.ExcludeFromDuplicateTabs request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ExcludeFromDuplicateTabs");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::GetProfileData(
    GetProfileDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_search::mojom::PageHandler::GetProfileData");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetProfileData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_GetProfileData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetProfileData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetProfileData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetUnusedTabs(
    GetUnusedTabsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_search::mojom::PageHandler::GetUnusedTabs");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetUnusedTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_GetUnusedTabs_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetUnusedTabs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetUnusedTabs_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetTabSearchSection(
    GetTabSearchSectionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_search::mojom::PageHandler::GetTabSearchSection");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabSearchSection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_GetTabSearchSection_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabSearchSection");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetTabSearchSection_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetTabOrganizationFeature(
    GetTabOrganizationFeatureCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_search::mojom::PageHandler::GetTabOrganizationFeature");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabOrganizationFeature), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_GetTabOrganizationFeature_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabOrganizationFeature");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetTabOrganizationFeature_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetTabOrganizationSession(
    GetTabOrganizationSessionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_search::mojom::PageHandler::GetTabOrganizationSession");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabOrganizationSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_GetTabOrganizationSession_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabOrganizationSession");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetTabOrganizationSession_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetTabOrganizationModelStrategy(
    GetTabOrganizationModelStrategyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_search::mojom::PageHandler::GetTabOrganizationModelStrategy");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabOrganizationModelStrategy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_GetTabOrganizationModelStrategy_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabOrganizationModelStrategy");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetTabOrganizationModelStrategy_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetIsSplit(
    GetIsSplitCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_search::mojom::PageHandler::GetIsSplit");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetIsSplit), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_GetIsSplit_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetIsSplit");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetIsSplit_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::SwitchToTab(
    SwitchToTabInfoPtr in_switch_to_tab_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::SwitchToTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("switch_to_tab_info"), in_switch_to_tab_info,
                        "<value of type SwitchToTabInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSwitchToTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_SwitchToTab_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->switch_to_tab_info)::BaseType> switch_to_tab_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::tab_search::mojom::SwitchToTabInfoDataView>(
    in_switch_to_tab_info,
    switch_to_tab_info_fragment);

  params->switch_to_tab_info.Set(
      switch_to_tab_info_fragment.is_null() ? nullptr : switch_to_tab_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->switch_to_tab_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null switch_to_tab_info in PageHandler.SwitchToTab request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SwitchToTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OpenRecentlyClosedEntry(
    int32_t in_session_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::OpenRecentlyClosedEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenRecentlyClosedEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_OpenRecentlyClosedEntry_Params_Data> params(
          message);
  params.Allocate();

  params->session_id = in_session_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenRecentlyClosedEntry");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RequestTabOrganization(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_search::mojom::PageHandler::RequestTabOrganization");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRequestTabOrganization), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_RequestTabOrganization_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RequestTabOrganization");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RemoveTabFromOrganization(
    int32_t in_session_id, int32_t in_organization_id, TabPtr in_tab) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::RemoveTabFromOrganization", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("organization_id"), in_organization_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab"), in_tab,
                        "<value of type TabPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRemoveTabFromOrganization), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_RemoveTabFromOrganization_Params_Data> params(
          message);
  params.Allocate();

  params->session_id = in_session_id;

  params->organization_id = in_organization_id;
  mojo::internal::MessageFragment<
      typename decltype(params->tab)::BaseType> tab_fragment(
          params.message());
  
  mojo::internal::Serialize<::tab_search::mojom::TabDataView>(
    in_tab,
    tab_fragment);

  params->tab.Set(
      tab_fragment.is_null() ? nullptr : tab_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tab.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tab in PageHandler.RemoveTabFromOrganization request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RemoveTabFromOrganization");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RejectSession(
    int32_t in_session_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::RejectSession", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRejectSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_RejectSession_Params_Data> params(
          message);
  params.Allocate();

  params->session_id = in_session_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RejectSession");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ReplaceActiveSplitTab(
    int32_t in_replacement_tab_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::ReplaceActiveSplitTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("replacement_tab_id"), in_replacement_tab_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kReplaceActiveSplitTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_ReplaceActiveSplitTab_Params_Data> params(
          message);
  params.Allocate();

  params->replacement_tab_id = in_replacement_tab_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ReplaceActiveSplitTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RestartSession(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_search::mojom::PageHandler::RestartSession");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRestartSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_RestartSession_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RestartSession");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SaveRecentlyClosedExpandedPref(
    bool in_expanded) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::SaveRecentlyClosedExpandedPref", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expanded"), in_expanded,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSaveRecentlyClosedExpandedPref), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_SaveRecentlyClosedExpandedPref_Params_Data> params(
          message);
  params.Allocate();

  params->expanded = in_expanded;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SaveRecentlyClosedExpandedPref");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetOrganizationFeature(
    TabOrganizationFeature in_feature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::SetOrganizationFeature", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature"), in_feature,
                        "<value of type TabOrganizationFeature>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetOrganizationFeature), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_SetOrganizationFeature_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::tab_search::mojom::TabOrganizationFeature>(
    in_feature,
    &params->feature);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetOrganizationFeature");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::StartTabGroupTutorial(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_search::mojom::PageHandler::StartTabGroupTutorial");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kStartTabGroupTutorial), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_StartTabGroupTutorial_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("StartTabGroupTutorial");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::TriggerFeedback(
    int32_t in_session_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::TriggerFeedback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kTriggerFeedback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_TriggerFeedback_Params_Data> params(
          message);
  params.Allocate();

  params->session_id = in_session_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("TriggerFeedback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::TriggerSignIn(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_search::mojom::PageHandler::TriggerSignIn");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kTriggerSignIn), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_TriggerSignIn_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("TriggerSignIn");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OpenHelpPage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_search::mojom::PageHandler::OpenHelpPage");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenHelpPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_OpenHelpPage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenHelpPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetTabOrganizationModelStrategy(
    TabOrganizationModelStrategy in_strategy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::SetTabOrganizationModelStrategy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("strategy"), in_strategy,
                        "<value of type TabOrganizationModelStrategy>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetTabOrganizationModelStrategy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_SetTabOrganizationModelStrategy_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::tab_search::mojom::TabOrganizationModelStrategy>(
    in_strategy,
    &params->strategy);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetTabOrganizationModelStrategy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetTabOrganizationUserInstruction(
    const std::string& in_user_instruction) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::SetTabOrganizationUserInstruction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_instruction"), in_user_instruction,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetTabOrganizationUserInstruction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_SetTabOrganizationUserInstruction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->user_instruction)::BaseType> user_instruction_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_user_instruction,
    user_instruction_fragment);

  params->user_instruction.Set(
      user_instruction_fragment.is_null() ? nullptr : user_instruction_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->user_instruction.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null user_instruction in PageHandler.SetTabOrganizationUserInstruction request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetTabOrganizationUserInstruction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetUserFeedback(
    int32_t in_session_id, UserFeedback in_feedback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::PageHandler::SetUserFeedback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feedback"), in_feedback,
                        "<value of type UserFeedback>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetUserFeedback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_SetUserFeedback_Params_Data> params(
          message);
  params.Allocate();

  params->session_id = in_session_id;

  
  mojo::internal::Serialize<::tab_search::mojom::UserFeedback>(
    in_feedback,
    &params->feedback);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetUserFeedback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::NotifyOrganizationUIReadyToShow(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_search::mojom::PageHandler::NotifyOrganizationUIReadyToShow");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kNotifyOrganizationUIReadyToShow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_NotifyOrganizationUIReadyToShow_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("NotifyOrganizationUIReadyToShow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::NotifySearchUIReadyToShow(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_search::mojom::PageHandler::NotifySearchUIReadyToShow");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kNotifySearchUIReadyToShow), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_NotifySearchUIReadyToShow_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("NotifySearchUIReadyToShow");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageHandler_GetProfileData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetProfileDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetProfileData_ProxyToResponder> proxy(
        new PageHandler_GetProfileData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetProfileData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetProfileData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetProfileData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetProfileDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ProfileDataPtr in_profile_data);
};

bool PageHandler_GetProfileData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetProfileData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetProfileData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.8
  bool success = true;
  ProfileDataPtr p_profile_data{};
  PageHandler_GetProfileData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadProfileData(&p_profile_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_profile_data));
  }
  return true;
}

void PageHandler_GetProfileData_ProxyToResponder::Run(
    ProfileDataPtr in_profile_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tab_search::mojom::PageHandler::GetProfileData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profile_data"), in_profile_data,
                        "<value of type ProfileDataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetProfileData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_GetProfileData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->profile_data)::BaseType> profile_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::tab_search::mojom::ProfileDataDataView>(
    in_profile_data,
    profile_data_fragment);

  params->profile_data.Set(
      profile_data_fragment.is_null() ? nullptr : profile_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->profile_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null profile_data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetProfileData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetUnusedTabs_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetUnusedTabsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetUnusedTabs_ProxyToResponder> proxy(
        new PageHandler_GetUnusedTabs_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetUnusedTabs_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetUnusedTabs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetUnusedTabs_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetUnusedTabsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      UnusedTabInfoPtr in_tabs);
};

bool PageHandler_GetUnusedTabs_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetUnusedTabs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetUnusedTabs_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.9
  bool success = true;
  UnusedTabInfoPtr p_tabs{};
  PageHandler_GetUnusedTabs_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTabs(&p_tabs))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_tabs));
  }
  return true;
}

void PageHandler_GetUnusedTabs_ProxyToResponder::Run(
    UnusedTabInfoPtr in_tabs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tab_search::mojom::PageHandler::GetUnusedTabs", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tabs"), in_tabs,
                        "<value of type UnusedTabInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetUnusedTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_GetUnusedTabs_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tabs)::BaseType> tabs_fragment(
          params.message());
  
  mojo::internal::Serialize<::tab_search::mojom::UnusedTabInfoDataView>(
    in_tabs,
    tabs_fragment);

  params->tabs.Set(
      tabs_fragment.is_null() ? nullptr : tabs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tabs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tabs in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetUnusedTabs");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetTabSearchSection_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetTabSearchSectionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetTabSearchSection_ProxyToResponder> proxy(
        new PageHandler_GetTabSearchSection_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetTabSearchSection_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetTabSearchSection_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetTabSearchSection_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetTabSearchSectionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      TabSearchSection in_section);
};

bool PageHandler_GetTabSearchSection_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetTabSearchSection_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetTabSearchSection_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.10
  bool success = true;
  TabSearchSection p_section{};
  PageHandler_GetTabSearchSection_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSection(&p_section))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_section));
  }
  return true;
}

void PageHandler_GetTabSearchSection_ProxyToResponder::Run(
    TabSearchSection in_section) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tab_search::mojom::PageHandler::GetTabSearchSection", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("section"), in_section,
                        "<value of type TabSearchSection>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabSearchSection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_GetTabSearchSection_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::tab_search::mojom::TabSearchSection>(
    in_section,
    &params->section);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabSearchSection");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetTabOrganizationFeature_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetTabOrganizationFeatureCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetTabOrganizationFeature_ProxyToResponder> proxy(
        new PageHandler_GetTabOrganizationFeature_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetTabOrganizationFeature_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetTabOrganizationFeature_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetTabOrganizationFeature_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetTabOrganizationFeatureCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      TabOrganizationFeature in_feature);
};

bool PageHandler_GetTabOrganizationFeature_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetTabOrganizationFeature_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetTabOrganizationFeature_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.11
  bool success = true;
  TabOrganizationFeature p_feature{};
  PageHandler_GetTabOrganizationFeature_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadFeature(&p_feature))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_feature));
  }
  return true;
}

void PageHandler_GetTabOrganizationFeature_ProxyToResponder::Run(
    TabOrganizationFeature in_feature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tab_search::mojom::PageHandler::GetTabOrganizationFeature", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature"), in_feature,
                        "<value of type TabOrganizationFeature>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabOrganizationFeature), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_GetTabOrganizationFeature_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::tab_search::mojom::TabOrganizationFeature>(
    in_feature,
    &params->feature);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabOrganizationFeature");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetTabOrganizationSession_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetTabOrganizationSessionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetTabOrganizationSession_ProxyToResponder> proxy(
        new PageHandler_GetTabOrganizationSession_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetTabOrganizationSession_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetTabOrganizationSession_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetTabOrganizationSession_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetTabOrganizationSessionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      TabOrganizationSessionPtr in_session);
};

bool PageHandler_GetTabOrganizationSession_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetTabOrganizationSession_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetTabOrganizationSession_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.12
  bool success = true;
  TabOrganizationSessionPtr p_session{};
  PageHandler_GetTabOrganizationSession_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadSession(&p_session))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_session));
  }
  return true;
}

void PageHandler_GetTabOrganizationSession_ProxyToResponder::Run(
    TabOrganizationSessionPtr in_session) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tab_search::mojom::PageHandler::GetTabOrganizationSession", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type TabOrganizationSessionPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabOrganizationSession), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_GetTabOrganizationSession_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session)::BaseType> session_fragment(
          params.message());
  
  mojo::internal::Serialize<::tab_search::mojom::TabOrganizationSessionDataView>(
    in_session,
    session_fragment);

  params->session.Set(
      session_fragment.is_null() ? nullptr : session_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabOrganizationSession");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetTabOrganizationModelStrategy_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetTabOrganizationModelStrategyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetTabOrganizationModelStrategy_ProxyToResponder> proxy(
        new PageHandler_GetTabOrganizationModelStrategy_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetTabOrganizationModelStrategy_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetTabOrganizationModelStrategy_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetTabOrganizationModelStrategy_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetTabOrganizationModelStrategyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      TabOrganizationModelStrategy in_strategy);
};

bool PageHandler_GetTabOrganizationModelStrategy_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetTabOrganizationModelStrategy_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetTabOrganizationModelStrategy_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.13
  bool success = true;
  TabOrganizationModelStrategy p_strategy{};
  PageHandler_GetTabOrganizationModelStrategy_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStrategy(&p_strategy))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_strategy));
  }
  return true;
}

void PageHandler_GetTabOrganizationModelStrategy_ProxyToResponder::Run(
    TabOrganizationModelStrategy in_strategy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tab_search::mojom::PageHandler::GetTabOrganizationModelStrategy", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("strategy"), in_strategy,
                        "<value of type TabOrganizationModelStrategy>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabOrganizationModelStrategy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_GetTabOrganizationModelStrategy_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::tab_search::mojom::TabOrganizationModelStrategy>(
    in_strategy,
    &params->strategy);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabOrganizationModelStrategy");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetIsSplit_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetIsSplitCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetIsSplit_ProxyToResponder> proxy(
        new PageHandler_GetIsSplit_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetIsSplit_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetIsSplit_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetIsSplit_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetIsSplitCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_split);
};

bool PageHandler_GetIsSplit_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetIsSplit_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetIsSplit_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.14
  bool success = true;
  bool p_is_split{};
  PageHandler_GetIsSplit_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_split = input_data_view.is_split();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_is_split));
  }
  return true;
}

void PageHandler_GetIsSplit_ProxyToResponder::Run(
    bool in_is_split) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tab_search::mojom::PageHandler::GetIsSplit", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_split"), in_is_split,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetIsSplit), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::PageHandler_GetIsSplit_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->is_split = in_is_split;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetIsSplit");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kCloseTab: {
      DCHECK(message->is_serialized());
      internal::PageHandler_CloseTab_Params_Data* params =
          reinterpret_cast<internal::PageHandler_CloseTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      int32_t p_tab_id{};
      PageHandler_CloseTab_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseTab(        
        std::move(p_tab_id));
      return true;
    }
    case messages::PageHandler::kCloseWebUiTab: {
      DCHECK(message->is_serialized());
      internal::PageHandler_CloseWebUiTab_Params_Data* params =
          reinterpret_cast<internal::PageHandler_CloseWebUiTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      PageHandler_CloseWebUiTab_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseWebUiTab(        );
      return true;
    }
    case messages::PageHandler::kDeclutterTabs: {
      DCHECK(message->is_serialized());
      internal::PageHandler_DeclutterTabs_Params_Data* params =
          reinterpret_cast<internal::PageHandler_DeclutterTabs_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      std::vector<int32_t> p_tab_ids{};
      std::vector<::GURL> p_urls{};
      PageHandler_DeclutterTabs_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTabIds(&p_tab_ids))
        success = false;
      if (success && !input_data_view.ReadUrls(&p_urls))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeclutterTabs(        
        std::move(p_tab_ids), 
        std::move(p_urls));
      return true;
    }
    case messages::PageHandler::kAcceptTabOrganization: {
      DCHECK(message->is_serialized());
      internal::PageHandler_AcceptTabOrganization_Params_Data* params =
          reinterpret_cast<internal::PageHandler_AcceptTabOrganization_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      int32_t p_session_id{};
      int32_t p_organization_id{};
      std::vector<TabPtr> p_tabs{};
      PageHandler_AcceptTabOrganization_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_session_id = input_data_view.session_id();
      if (success)
        p_organization_id = input_data_view.organization_id();
      if (success && !input_data_view.ReadTabs(&p_tabs))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AcceptTabOrganization(        
        std::move(p_session_id), 
        std::move(p_organization_id), 
        std::move(p_tabs));
      return true;
    }
    case messages::PageHandler::kRejectTabOrganization: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RejectTabOrganization_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RejectTabOrganization_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      int32_t p_session_id{};
      int32_t p_organization_id{};
      PageHandler_RejectTabOrganization_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_session_id = input_data_view.session_id();
      if (success)
        p_organization_id = input_data_view.organization_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RejectTabOrganization(        
        std::move(p_session_id), 
        std::move(p_organization_id));
      return true;
    }
    case messages::PageHandler::kRenameTabOrganization: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RenameTabOrganization_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RenameTabOrganization_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      int32_t p_session_id{};
      int32_t p_organization_id{};
      ::std::u16string p_name{};
      PageHandler_RenameTabOrganization_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_session_id = input_data_view.session_id();
      if (success)
        p_organization_id = input_data_view.organization_id();
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenameTabOrganization(        
        std::move(p_session_id), 
        std::move(p_organization_id), 
        std::move(p_name));
      return true;
    }
    case messages::PageHandler::kExcludeFromStaleTabs: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ExcludeFromStaleTabs_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ExcludeFromStaleTabs_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      int32_t p_tab_id{};
      PageHandler_ExcludeFromStaleTabs_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExcludeFromStaleTabs(        
        std::move(p_tab_id));
      return true;
    }
    case messages::PageHandler::kExcludeFromDuplicateTabs: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ExcludeFromDuplicateTabs_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ExcludeFromDuplicateTabs_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      ::GURL p_url{};
      PageHandler_ExcludeFromDuplicateTabs_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExcludeFromDuplicateTabs(        
        std::move(p_url));
      return true;
    }
    case messages::PageHandler::kGetProfileData: {
      break;
    }
    case messages::PageHandler::kGetUnusedTabs: {
      break;
    }
    case messages::PageHandler::kGetTabSearchSection: {
      break;
    }
    case messages::PageHandler::kGetTabOrganizationFeature: {
      break;
    }
    case messages::PageHandler::kGetTabOrganizationSession: {
      break;
    }
    case messages::PageHandler::kGetTabOrganizationModelStrategy: {
      break;
    }
    case messages::PageHandler::kGetIsSplit: {
      break;
    }
    case messages::PageHandler::kSwitchToTab: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SwitchToTab_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SwitchToTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.15
      bool success = true;
      SwitchToTabInfoPtr p_switch_to_tab_info{};
      PageHandler_SwitchToTab_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSwitchToTabInfo(&p_switch_to_tab_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SwitchToTab(        
        std::move(p_switch_to_tab_info));
      return true;
    }
    case messages::PageHandler::kOpenRecentlyClosedEntry: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenRecentlyClosedEntry_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenRecentlyClosedEntry_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.16
      bool success = true;
      int32_t p_session_id{};
      PageHandler_OpenRecentlyClosedEntry_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_session_id = input_data_view.session_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenRecentlyClosedEntry(        
        std::move(p_session_id));
      return true;
    }
    case messages::PageHandler::kRequestTabOrganization: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RequestTabOrganization_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RequestTabOrganization_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.17
      bool success = true;
      PageHandler_RequestTabOrganization_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestTabOrganization(        );
      return true;
    }
    case messages::PageHandler::kRemoveTabFromOrganization: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RemoveTabFromOrganization_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RemoveTabFromOrganization_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.18
      bool success = true;
      int32_t p_session_id{};
      int32_t p_organization_id{};
      TabPtr p_tab{};
      PageHandler_RemoveTabFromOrganization_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_session_id = input_data_view.session_id();
      if (success)
        p_organization_id = input_data_view.organization_id();
      if (success && !input_data_view.ReadTab(&p_tab))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveTabFromOrganization(        
        std::move(p_session_id), 
        std::move(p_organization_id), 
        std::move(p_tab));
      return true;
    }
    case messages::PageHandler::kRejectSession: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RejectSession_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RejectSession_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.19
      bool success = true;
      int32_t p_session_id{};
      PageHandler_RejectSession_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_session_id = input_data_view.session_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RejectSession(        
        std::move(p_session_id));
      return true;
    }
    case messages::PageHandler::kReplaceActiveSplitTab: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ReplaceActiveSplitTab_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ReplaceActiveSplitTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.20
      bool success = true;
      int32_t p_replacement_tab_id{};
      PageHandler_ReplaceActiveSplitTab_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_replacement_tab_id = input_data_view.replacement_tab_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReplaceActiveSplitTab(        
        std::move(p_replacement_tab_id));
      return true;
    }
    case messages::PageHandler::kRestartSession: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RestartSession_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RestartSession_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.21
      bool success = true;
      PageHandler_RestartSession_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RestartSession(        );
      return true;
    }
    case messages::PageHandler::kSaveRecentlyClosedExpandedPref: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SaveRecentlyClosedExpandedPref_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SaveRecentlyClosedExpandedPref_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.22
      bool success = true;
      bool p_expanded{};
      PageHandler_SaveRecentlyClosedExpandedPref_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_expanded = input_data_view.expanded();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SaveRecentlyClosedExpandedPref(        
        std::move(p_expanded));
      return true;
    }
    case messages::PageHandler::kSetOrganizationFeature: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetOrganizationFeature_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetOrganizationFeature_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.23
      bool success = true;
      TabOrganizationFeature p_feature{};
      PageHandler_SetOrganizationFeature_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeature(&p_feature))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOrganizationFeature(        
        std::move(p_feature));
      return true;
    }
    case messages::PageHandler::kStartTabGroupTutorial: {
      DCHECK(message->is_serialized());
      internal::PageHandler_StartTabGroupTutorial_Params_Data* params =
          reinterpret_cast<internal::PageHandler_StartTabGroupTutorial_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.24
      bool success = true;
      PageHandler_StartTabGroupTutorial_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartTabGroupTutorial(        );
      return true;
    }
    case messages::PageHandler::kTriggerFeedback: {
      DCHECK(message->is_serialized());
      internal::PageHandler_TriggerFeedback_Params_Data* params =
          reinterpret_cast<internal::PageHandler_TriggerFeedback_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.25
      bool success = true;
      int32_t p_session_id{};
      PageHandler_TriggerFeedback_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_session_id = input_data_view.session_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TriggerFeedback(        
        std::move(p_session_id));
      return true;
    }
    case messages::PageHandler::kTriggerSignIn: {
      DCHECK(message->is_serialized());
      internal::PageHandler_TriggerSignIn_Params_Data* params =
          reinterpret_cast<internal::PageHandler_TriggerSignIn_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.26
      bool success = true;
      PageHandler_TriggerSignIn_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TriggerSignIn(        );
      return true;
    }
    case messages::PageHandler::kOpenHelpPage: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenHelpPage_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenHelpPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.27
      bool success = true;
      PageHandler_OpenHelpPage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenHelpPage(        );
      return true;
    }
    case messages::PageHandler::kSetTabOrganizationModelStrategy: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetTabOrganizationModelStrategy_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetTabOrganizationModelStrategy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.28
      bool success = true;
      TabOrganizationModelStrategy p_strategy{};
      PageHandler_SetTabOrganizationModelStrategy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStrategy(&p_strategy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTabOrganizationModelStrategy(        
        std::move(p_strategy));
      return true;
    }
    case messages::PageHandler::kSetTabOrganizationUserInstruction: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetTabOrganizationUserInstruction_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetTabOrganizationUserInstruction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.29
      bool success = true;
      std::string p_user_instruction{};
      PageHandler_SetTabOrganizationUserInstruction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUserInstruction(&p_user_instruction))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 29, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTabOrganizationUserInstruction(        
        std::move(p_user_instruction));
      return true;
    }
    case messages::PageHandler::kSetUserFeedback: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetUserFeedback_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetUserFeedback_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.30
      bool success = true;
      int32_t p_session_id{};
      UserFeedback p_feedback{};
      PageHandler_SetUserFeedback_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_session_id = input_data_view.session_id();
      if (success && !input_data_view.ReadFeedback(&p_feedback))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 30, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUserFeedback(        
        std::move(p_session_id), 
        std::move(p_feedback));
      return true;
    }
    case messages::PageHandler::kNotifyOrganizationUIReadyToShow: {
      DCHECK(message->is_serialized());
      internal::PageHandler_NotifyOrganizationUIReadyToShow_Params_Data* params =
          reinterpret_cast<internal::PageHandler_NotifyOrganizationUIReadyToShow_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.31
      bool success = true;
      PageHandler_NotifyOrganizationUIReadyToShow_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 31, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyOrganizationUIReadyToShow(        );
      return true;
    }
    case messages::PageHandler::kNotifySearchUIReadyToShow: {
      DCHECK(message->is_serialized());
      internal::PageHandler_NotifySearchUIReadyToShow_Params_Data* params =
          reinterpret_cast<internal::PageHandler_NotifySearchUIReadyToShow_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.32
      bool success = true;
      PageHandler_NotifySearchUIReadyToShow_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 32, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifySearchUIReadyToShow(        );
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kCloseTab: {
      break;
    }
    case messages::PageHandler::kCloseWebUiTab: {
      break;
    }
    case messages::PageHandler::kDeclutterTabs: {
      break;
    }
    case messages::PageHandler::kAcceptTabOrganization: {
      break;
    }
    case messages::PageHandler::kRejectTabOrganization: {
      break;
    }
    case messages::PageHandler::kRenameTabOrganization: {
      break;
    }
    case messages::PageHandler::kExcludeFromStaleTabs: {
      break;
    }
    case messages::PageHandler::kExcludeFromDuplicateTabs: {
      break;
    }
    case messages::PageHandler::kGetProfileData: {
      internal::PageHandler_GetProfileData_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetProfileData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.8
      bool success = true;
      PageHandler_GetProfileData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      auto callback =
          PageHandler_GetProfileData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProfileData(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetUnusedTabs: {
      internal::PageHandler_GetUnusedTabs_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetUnusedTabs_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.9
      bool success = true;
      PageHandler_GetUnusedTabs_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      auto callback =
          PageHandler_GetUnusedTabs_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetUnusedTabs(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetTabSearchSection: {
      internal::PageHandler_GetTabSearchSection_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetTabSearchSection_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.10
      bool success = true;
      PageHandler_GetTabSearchSection_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 10, false);
        return false;
      }
      auto callback =
          PageHandler_GetTabSearchSection_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTabSearchSection(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetTabOrganizationFeature: {
      internal::PageHandler_GetTabOrganizationFeature_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetTabOrganizationFeature_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.11
      bool success = true;
      PageHandler_GetTabOrganizationFeature_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 11, false);
        return false;
      }
      auto callback =
          PageHandler_GetTabOrganizationFeature_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTabOrganizationFeature(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetTabOrganizationSession: {
      internal::PageHandler_GetTabOrganizationSession_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetTabOrganizationSession_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.12
      bool success = true;
      PageHandler_GetTabOrganizationSession_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 12, false);
        return false;
      }
      auto callback =
          PageHandler_GetTabOrganizationSession_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTabOrganizationSession(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetTabOrganizationModelStrategy: {
      internal::PageHandler_GetTabOrganizationModelStrategy_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetTabOrganizationModelStrategy_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.13
      bool success = true;
      PageHandler_GetTabOrganizationModelStrategy_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 13, false);
        return false;
      }
      auto callback =
          PageHandler_GetTabOrganizationModelStrategy_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTabOrganizationModelStrategy(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetIsSplit: {
      internal::PageHandler_GetIsSplit_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetIsSplit_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.14
      bool success = true;
      PageHandler_GetIsSplit_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 14, false);
        return false;
      }
      auto callback =
          PageHandler_GetIsSplit_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetIsSplit(std::move(callback));
      return true;
    }
    case messages::PageHandler::kSwitchToTab: {
      break;
    }
    case messages::PageHandler::kOpenRecentlyClosedEntry: {
      break;
    }
    case messages::PageHandler::kRequestTabOrganization: {
      break;
    }
    case messages::PageHandler::kRemoveTabFromOrganization: {
      break;
    }
    case messages::PageHandler::kRejectSession: {
      break;
    }
    case messages::PageHandler::kReplaceActiveSplitTab: {
      break;
    }
    case messages::PageHandler::kRestartSession: {
      break;
    }
    case messages::PageHandler::kSaveRecentlyClosedExpandedPref: {
      break;
    }
    case messages::PageHandler::kSetOrganizationFeature: {
      break;
    }
    case messages::PageHandler::kStartTabGroupTutorial: {
      break;
    }
    case messages::PageHandler::kTriggerFeedback: {
      break;
    }
    case messages::PageHandler::kTriggerSignIn: {
      break;
    }
    case messages::PageHandler::kOpenHelpPage: {
      break;
    }
    case messages::PageHandler::kSetTabOrganizationModelStrategy: {
      break;
    }
    case messages::PageHandler::kSetTabOrganizationUserInstruction: {
      break;
    }
    case messages::PageHandler::kSetUserFeedback: {
      break;
    }
    case messages::PageHandler::kNotifyOrganizationUIReadyToShow: {
      break;
    }
    case messages::PageHandler::kNotifySearchUIReadyToShow: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_CloseTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_CloseWebUiTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_DeclutterTabs_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_AcceptTabOrganization_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RejectTabOrganization_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RenameTabOrganization_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ExcludeFromStaleTabs_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ExcludeFromDuplicateTabs_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_GetProfileData_Params_Data::Validate,
     &internal::PageHandler_GetProfileData_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetUnusedTabs_Params_Data::Validate,
     &internal::PageHandler_GetUnusedTabs_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetTabSearchSection_Params_Data::Validate,
     &internal::PageHandler_GetTabSearchSection_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetTabOrganizationFeature_Params_Data::Validate,
     &internal::PageHandler_GetTabOrganizationFeature_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetTabOrganizationSession_Params_Data::Validate,
     &internal::PageHandler_GetTabOrganizationSession_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetTabOrganizationModelStrategy_Params_Data::Validate,
     &internal::PageHandler_GetTabOrganizationModelStrategy_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetIsSplit_Params_Data::Validate,
     &internal::PageHandler_GetIsSplit_ResponseParams_Data::Validate},
    { &internal::PageHandler_SwitchToTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OpenRecentlyClosedEntry_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RequestTabOrganization_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RemoveTabFromOrganization_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RejectSession_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ReplaceActiveSplitTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RestartSession_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SaveRecentlyClosedExpandedPref_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetOrganizationFeature_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_StartTabGroupTutorial_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_TriggerFeedback_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_TriggerSignIn_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OpenHelpPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetTabOrganizationModelStrategy_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetTabOrganizationUserInstruction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetUserFeedback_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_NotifyOrganizationUIReadyToShow_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_NotifySearchUIReadyToShow_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::tab_search::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::tab_search::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kTabOrganizationSessionUpdated: {
      return &Page::TabOrganizationSessionUpdated_Sym::IPCStableHash;
    }
    case messages::Page::kTabOrganizationModelStrategyUpdated: {
      return &Page::TabOrganizationModelStrategyUpdated_Sym::IPCStableHash;
    }
    case messages::Page::kHostWindowChanged: {
      return &Page::HostWindowChanged_Sym::IPCStableHash;
    }
    case messages::Page::kTabsChanged: {
      return &Page::TabsChanged_Sym::IPCStableHash;
    }
    case messages::Page::kTabUpdated: {
      return &Page::TabUpdated_Sym::IPCStableHash;
    }
    case messages::Page::kTabsRemoved: {
      return &Page::TabsRemoved_Sym::IPCStableHash;
    }
    case messages::Page::kTabSearchSectionChanged: {
      return &Page::TabSearchSectionChanged_Sym::IPCStableHash;
    }
    case messages::Page::kTabOrganizationFeatureChanged: {
      return &Page::TabOrganizationFeatureChanged_Sym::IPCStableHash;
    }
    case messages::Page::kShowFREChanged: {
      return &Page::ShowFREChanged_Sym::IPCStableHash;
    }
    case messages::Page::kTabOrganizationEnabledChanged: {
      return &Page::TabOrganizationEnabledChanged_Sym::IPCStableHash;
    }
    case messages::Page::kUnusedTabsChanged: {
      return &Page::UnusedTabsChanged_Sym::IPCStableHash;
    }
    case messages::Page::kTabUnsplit: {
      return &Page::TabUnsplit_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kTabOrganizationSessionUpdated:
            return "Receive tab_search::mojom::Page::TabOrganizationSessionUpdated";
      case messages::Page::kTabOrganizationModelStrategyUpdated:
            return "Receive tab_search::mojom::Page::TabOrganizationModelStrategyUpdated";
      case messages::Page::kHostWindowChanged:
            return "Receive tab_search::mojom::Page::HostWindowChanged";
      case messages::Page::kTabsChanged:
            return "Receive tab_search::mojom::Page::TabsChanged";
      case messages::Page::kTabUpdated:
            return "Receive tab_search::mojom::Page::TabUpdated";
      case messages::Page::kTabsRemoved:
            return "Receive tab_search::mojom::Page::TabsRemoved";
      case messages::Page::kTabSearchSectionChanged:
            return "Receive tab_search::mojom::Page::TabSearchSectionChanged";
      case messages::Page::kTabOrganizationFeatureChanged:
            return "Receive tab_search::mojom::Page::TabOrganizationFeatureChanged";
      case messages::Page::kShowFREChanged:
            return "Receive tab_search::mojom::Page::ShowFREChanged";
      case messages::Page::kTabOrganizationEnabledChanged:
            return "Receive tab_search::mojom::Page::TabOrganizationEnabledChanged";
      case messages::Page::kUnusedTabsChanged:
            return "Receive tab_search::mojom::Page::UnusedTabsChanged";
      case messages::Page::kTabUnsplit:
            return "Receive tab_search::mojom::Page::TabUnsplit";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kTabOrganizationSessionUpdated:
            return "Receive reply tab_search::mojom::Page::TabOrganizationSessionUpdated";
      case messages::Page::kTabOrganizationModelStrategyUpdated:
            return "Receive reply tab_search::mojom::Page::TabOrganizationModelStrategyUpdated";
      case messages::Page::kHostWindowChanged:
            return "Receive reply tab_search::mojom::Page::HostWindowChanged";
      case messages::Page::kTabsChanged:
            return "Receive reply tab_search::mojom::Page::TabsChanged";
      case messages::Page::kTabUpdated:
            return "Receive reply tab_search::mojom::Page::TabUpdated";
      case messages::Page::kTabsRemoved:
            return "Receive reply tab_search::mojom::Page::TabsRemoved";
      case messages::Page::kTabSearchSectionChanged:
            return "Receive reply tab_search::mojom::Page::TabSearchSectionChanged";
      case messages::Page::kTabOrganizationFeatureChanged:
            return "Receive reply tab_search::mojom::Page::TabOrganizationFeatureChanged";
      case messages::Page::kShowFREChanged:
            return "Receive reply tab_search::mojom::Page::ShowFREChanged";
      case messages::Page::kTabOrganizationEnabledChanged:
            return "Receive reply tab_search::mojom::Page::TabOrganizationEnabledChanged";
      case messages::Page::kUnusedTabsChanged:
            return "Receive reply tab_search::mojom::Page::UnusedTabsChanged";
      case messages::Page::kTabUnsplit:
            return "Receive reply tab_search::mojom::Page::TabUnsplit";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::TabOrganizationSessionUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6725ef6b;  // IPCStableHash for tab_search::mojom::Page::TabOrganizationSessionUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabOrganizationModelStrategyUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9bdd4d90;  // IPCStableHash for tab_search::mojom::Page::TabOrganizationModelStrategyUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::HostWindowChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc2eda860;  // IPCStableHash for tab_search::mojom::Page::HostWindowChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5dccc1d2;  // IPCStableHash for tab_search::mojom::Page::TabsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdaf5ea77;  // IPCStableHash for tab_search::mojom::Page::TabUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabsRemoved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x90ae8378;  // IPCStableHash for tab_search::mojom::Page::TabsRemoved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabSearchSectionChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3e991a6b;  // IPCStableHash for tab_search::mojom::Page::TabSearchSectionChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabOrganizationFeatureChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x528b7c02;  // IPCStableHash for tab_search::mojom::Page::TabOrganizationFeatureChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::ShowFREChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4350caae;  // IPCStableHash for tab_search::mojom::Page::ShowFREChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabOrganizationEnabledChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6b0c1de6;  // IPCStableHash for tab_search::mojom::Page::TabOrganizationEnabledChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::UnusedTabsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x39349466;  // IPCStableHash for tab_search::mojom::Page::UnusedTabsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabUnsplit_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1e7d59b1;  // IPCStableHash for tab_search::mojom::Page::TabUnsplit
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::TabOrganizationSessionUpdated(
    TabOrganizationSessionPtr in_session) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::Page::TabOrganizationSessionUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session"), in_session,
                        "<value of type TabOrganizationSessionPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabOrganizationSessionUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::Page_TabOrganizationSessionUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session)::BaseType> session_fragment(
          params.message());
  
  mojo::internal::Serialize<::tab_search::mojom::TabOrganizationSessionDataView>(
    in_session,
    session_fragment);

  params->session.Set(
      session_fragment.is_null() ? nullptr : session_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session in Page.TabOrganizationSessionUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabOrganizationSessionUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabOrganizationModelStrategyUpdated(
    TabOrganizationModelStrategy in_strategy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::Page::TabOrganizationModelStrategyUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("strategy"), in_strategy,
                        "<value of type TabOrganizationModelStrategy>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabOrganizationModelStrategyUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::Page_TabOrganizationModelStrategyUpdated_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::tab_search::mojom::TabOrganizationModelStrategy>(
    in_strategy,
    &params->strategy);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabOrganizationModelStrategyUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::HostWindowChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_search::mojom::Page::HostWindowChanged");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kHostWindowChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::Page_HostWindowChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("HostWindowChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabsChanged(
    ProfileDataPtr in_profile_tabs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::Page::TabsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("profile_tabs"), in_profile_tabs,
                        "<value of type ProfileDataPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::Page_TabsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->profile_tabs)::BaseType> profile_tabs_fragment(
          params.message());
  
  mojo::internal::Serialize<::tab_search::mojom::ProfileDataDataView>(
    in_profile_tabs,
    profile_tabs_fragment);

  params->profile_tabs.Set(
      profile_tabs_fragment.is_null() ? nullptr : profile_tabs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->profile_tabs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null profile_tabs in Page.TabsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabUpdated(
    TabUpdateInfoPtr in_tabUpdateInfo) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::Page::TabUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tabUpdateInfo"), in_tabUpdateInfo,
                        "<value of type TabUpdateInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::Page_TabUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tabUpdateInfo)::BaseType> tabUpdateInfo_fragment(
          params.message());
  
  mojo::internal::Serialize<::tab_search::mojom::TabUpdateInfoDataView>(
    in_tabUpdateInfo,
    tabUpdateInfo_fragment);

  params->tabUpdateInfo.Set(
      tabUpdateInfo_fragment.is_null() ? nullptr : tabUpdateInfo_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tabUpdateInfo.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tabUpdateInfo in Page.TabUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabsRemoved(
    TabsRemovedInfoPtr in_tabsRemovedInfo) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::Page::TabsRemoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tabsRemovedInfo"), in_tabsRemovedInfo,
                        "<value of type TabsRemovedInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabsRemoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::Page_TabsRemoved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tabsRemovedInfo)::BaseType> tabsRemovedInfo_fragment(
          params.message());
  
  mojo::internal::Serialize<::tab_search::mojom::TabsRemovedInfoDataView>(
    in_tabsRemovedInfo,
    tabsRemovedInfo_fragment);

  params->tabsRemovedInfo.Set(
      tabsRemovedInfo_fragment.is_null() ? nullptr : tabsRemovedInfo_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tabsRemovedInfo.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tabsRemovedInfo in Page.TabsRemoved request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabsRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabSearchSectionChanged(
    TabSearchSection in_section) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::Page::TabSearchSectionChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("section"), in_section,
                        "<value of type TabSearchSection>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabSearchSectionChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::Page_TabSearchSectionChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::tab_search::mojom::TabSearchSection>(
    in_section,
    &params->section);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabSearchSectionChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabOrganizationFeatureChanged(
    TabOrganizationFeature in_feature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::Page::TabOrganizationFeatureChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature"), in_feature,
                        "<value of type TabOrganizationFeature>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabOrganizationFeatureChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::Page_TabOrganizationFeatureChanged_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::tab_search::mojom::TabOrganizationFeature>(
    in_feature,
    &params->feature);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabOrganizationFeatureChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::ShowFREChanged(
    bool in_show) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::Page::ShowFREChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("show"), in_show,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kShowFREChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::Page_ShowFREChanged_Params_Data> params(
          message);
  params.Allocate();

  params->show = in_show;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("ShowFREChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabOrganizationEnabledChanged(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::Page::TabOrganizationEnabledChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabOrganizationEnabledChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::Page_TabOrganizationEnabledChanged_Params_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabOrganizationEnabledChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::UnusedTabsChanged(
    UnusedTabInfoPtr in_tabs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_search::mojom::Page::UnusedTabsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tabs"), in_tabs,
                        "<value of type UnusedTabInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kUnusedTabsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::Page_UnusedTabsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tabs)::BaseType> tabs_fragment(
          params.message());
  
  mojo::internal::Serialize<::tab_search::mojom::UnusedTabInfoDataView>(
    in_tabs,
    tabs_fragment);

  params->tabs.Set(
      tabs_fragment.is_null() ? nullptr : tabs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tabs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tabs in Page.UnusedTabsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("UnusedTabsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabUnsplit(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_search::mojom::Page::TabUnsplit");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabUnsplit), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_search::mojom::internal::Page_TabUnsplit_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabUnsplit");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kTabOrganizationSessionUpdated: {
      DCHECK(message->is_serialized());
      internal::Page_TabOrganizationSessionUpdated_Params_Data* params =
          reinterpret_cast<internal::Page_TabOrganizationSessionUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      TabOrganizationSessionPtr p_session{};
      Page_TabOrganizationSessionUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSession(&p_session))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabOrganizationSessionUpdated(        
        std::move(p_session));
      return true;
    }
    case messages::Page::kTabOrganizationModelStrategyUpdated: {
      DCHECK(message->is_serialized());
      internal::Page_TabOrganizationModelStrategyUpdated_Params_Data* params =
          reinterpret_cast<internal::Page_TabOrganizationModelStrategyUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      TabOrganizationModelStrategy p_strategy{};
      Page_TabOrganizationModelStrategyUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStrategy(&p_strategy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabOrganizationModelStrategyUpdated(        
        std::move(p_strategy));
      return true;
    }
    case messages::Page::kHostWindowChanged: {
      DCHECK(message->is_serialized());
      internal::Page_HostWindowChanged_Params_Data* params =
          reinterpret_cast<internal::Page_HostWindowChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.2
      bool success = true;
      Page_HostWindowChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HostWindowChanged(        );
      return true;
    }
    case messages::Page::kTabsChanged: {
      DCHECK(message->is_serialized());
      internal::Page_TabsChanged_Params_Data* params =
          reinterpret_cast<internal::Page_TabsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.3
      bool success = true;
      ProfileDataPtr p_profile_tabs{};
      Page_TabsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProfileTabs(&p_profile_tabs))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabsChanged(        
        std::move(p_profile_tabs));
      return true;
    }
    case messages::Page::kTabUpdated: {
      DCHECK(message->is_serialized());
      internal::Page_TabUpdated_Params_Data* params =
          reinterpret_cast<internal::Page_TabUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.4
      bool success = true;
      TabUpdateInfoPtr p_tabUpdateInfo{};
      Page_TabUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTabUpdateInfo(&p_tabUpdateInfo))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabUpdated(        
        std::move(p_tabUpdateInfo));
      return true;
    }
    case messages::Page::kTabsRemoved: {
      DCHECK(message->is_serialized());
      internal::Page_TabsRemoved_Params_Data* params =
          reinterpret_cast<internal::Page_TabsRemoved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.5
      bool success = true;
      TabsRemovedInfoPtr p_tabsRemovedInfo{};
      Page_TabsRemoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTabsRemovedInfo(&p_tabsRemovedInfo))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabsRemoved(        
        std::move(p_tabsRemovedInfo));
      return true;
    }
    case messages::Page::kTabSearchSectionChanged: {
      DCHECK(message->is_serialized());
      internal::Page_TabSearchSectionChanged_Params_Data* params =
          reinterpret_cast<internal::Page_TabSearchSectionChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.6
      bool success = true;
      TabSearchSection p_section{};
      Page_TabSearchSectionChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSection(&p_section))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabSearchSectionChanged(        
        std::move(p_section));
      return true;
    }
    case messages::Page::kTabOrganizationFeatureChanged: {
      DCHECK(message->is_serialized());
      internal::Page_TabOrganizationFeatureChanged_Params_Data* params =
          reinterpret_cast<internal::Page_TabOrganizationFeatureChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.7
      bool success = true;
      TabOrganizationFeature p_feature{};
      Page_TabOrganizationFeatureChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeature(&p_feature))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabOrganizationFeatureChanged(        
        std::move(p_feature));
      return true;
    }
    case messages::Page::kShowFREChanged: {
      DCHECK(message->is_serialized());
      internal::Page_ShowFREChanged_Params_Data* params =
          reinterpret_cast<internal::Page_ShowFREChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.8
      bool success = true;
      bool p_show{};
      Page_ShowFREChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_show = input_data_view.show();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowFREChanged(        
        std::move(p_show));
      return true;
    }
    case messages::Page::kTabOrganizationEnabledChanged: {
      DCHECK(message->is_serialized());
      internal::Page_TabOrganizationEnabledChanged_Params_Data* params =
          reinterpret_cast<internal::Page_TabOrganizationEnabledChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.9
      bool success = true;
      bool p_enabled{};
      Page_TabOrganizationEnabledChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabOrganizationEnabledChanged(        
        std::move(p_enabled));
      return true;
    }
    case messages::Page::kUnusedTabsChanged: {
      DCHECK(message->is_serialized());
      internal::Page_UnusedTabsChanged_Params_Data* params =
          reinterpret_cast<internal::Page_UnusedTabsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.10
      bool success = true;
      UnusedTabInfoPtr p_tabs{};
      Page_UnusedTabsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTabs(&p_tabs))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnusedTabsChanged(        
        std::move(p_tabs));
      return true;
    }
    case messages::Page::kTabUnsplit: {
      DCHECK(message->is_serialized());
      internal::Page_TabUnsplit_Params_Data* params =
          reinterpret_cast<internal::Page_TabUnsplit_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.11
      bool success = true;
      Page_TabUnsplit_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabUnsplit(        );
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kTabOrganizationSessionUpdated: {
      break;
    }
    case messages::Page::kTabOrganizationModelStrategyUpdated: {
      break;
    }
    case messages::Page::kHostWindowChanged: {
      break;
    }
    case messages::Page::kTabsChanged: {
      break;
    }
    case messages::Page::kTabUpdated: {
      break;
    }
    case messages::Page::kTabsRemoved: {
      break;
    }
    case messages::Page::kTabSearchSectionChanged: {
      break;
    }
    case messages::Page::kTabOrganizationFeatureChanged: {
      break;
    }
    case messages::Page::kShowFREChanged: {
      break;
    }
    case messages::Page::kTabOrganizationEnabledChanged: {
      break;
    }
    case messages::Page::kUnusedTabsChanged: {
      break;
    }
    case messages::Page::kTabUnsplit: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_TabOrganizationSessionUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabOrganizationModelStrategyUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_HostWindowChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabsChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabsRemoved_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabSearchSectionChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabOrganizationFeatureChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_ShowFREChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabOrganizationEnabledChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_UnusedTabsChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabUnsplit_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::tab_search::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // tab_search::mojom


namespace mojo {


// static
bool StructTraits<::tab_search::mojom::ProfileData::DataView, ::tab_search::mojom::ProfileDataPtr>::Read(
    ::tab_search::mojom::ProfileData::DataView input,
    ::tab_search::mojom::ProfileDataPtr* output) {
  bool success = true;
  ::tab_search::mojom::ProfileDataPtr result(::tab_search::mojom::ProfileData::New());
  
      if (success && !input.ReadWindows(&result->windows))
        success = false;
      if (success && !input.ReadTabGroups(&result->tab_groups))
        success = false;
      if (success && !input.ReadRecentlyClosedTabs(&result->recently_closed_tabs))
        success = false;
      if (success && !input.ReadRecentlyClosedTabGroups(&result->recently_closed_tab_groups))
        success = false;
      if (success)
        result->recently_closed_section_expanded = input.recently_closed_section_expanded();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_search::mojom::Window::DataView, ::tab_search::mojom::WindowPtr>::Read(
    ::tab_search::mojom::Window::DataView input,
    ::tab_search::mojom::WindowPtr* output) {
  bool success = true;
  ::tab_search::mojom::WindowPtr result(::tab_search::mojom::Window::New());
  
      if (success)
        result->active = input.active();
      if (success)
        result->is_host_window = input.is_host_window();
      if (success)
        result->height = input.height();
      if (success && !input.ReadTabs(&result->tabs))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_search::mojom::Tab::DataView, ::tab_search::mojom::TabPtr>::Read(
    ::tab_search::mojom::Tab::DataView input,
    ::tab_search::mojom::TabPtr* output) {
  bool success = true;
  ::tab_search::mojom::TabPtr result(::tab_search::mojom::Tab::New());
  
      if (success)
        result->active = input.active();
      if (success)
        result->visible = input.visible();
      if (success && !input.ReadAlertStates(&result->alert_states))
        success = false;
      if (success)
        result->index = input.index();
      if (success)
        result->tab_id = input.tab_id();
      if (success && !input.ReadGroupId(&result->group_id))
        success = false;
      if (success)
        result->pinned = input.pinned();
      if (success)
        result->split = input.split();
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadFaviconUrl(&result->favicon_url))
        success = false;
      if (success)
        result->is_default_favicon = input.is_default_favicon();
      if (success)
        result->show_icon = input.show_icon();
      if (success && !input.ReadLastActiveTimeTicks(&result->last_active_time_ticks))
        success = false;
      if (success && !input.ReadLastActiveElapsedText(&result->last_active_elapsed_text))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_search::mojom::RecentlyClosedTab::DataView, ::tab_search::mojom::RecentlyClosedTabPtr>::Read(
    ::tab_search::mojom::RecentlyClosedTab::DataView input,
    ::tab_search::mojom::RecentlyClosedTabPtr* output) {
  bool success = true;
  ::tab_search::mojom::RecentlyClosedTabPtr result(::tab_search::mojom::RecentlyClosedTab::New());
  
      if (success)
        result->tab_id = input.tab_id();
      if (success && !input.ReadGroupId(&result->group_id))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadLastActiveTime(&result->last_active_time))
        success = false;
      if (success && !input.ReadLastActiveElapsedText(&result->last_active_elapsed_text))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_search::mojom::TabGroup::DataView, ::tab_search::mojom::TabGroupPtr>::Read(
    ::tab_search::mojom::TabGroup::DataView input,
    ::tab_search::mojom::TabGroupPtr* output) {
  bool success = true;
  ::tab_search::mojom::TabGroupPtr result(::tab_search::mojom::TabGroup::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadColor(&result->color))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_search::mojom::RecentlyClosedTabGroup::DataView, ::tab_search::mojom::RecentlyClosedTabGroupPtr>::Read(
    ::tab_search::mojom::RecentlyClosedTabGroup::DataView input,
    ::tab_search::mojom::RecentlyClosedTabGroupPtr* output) {
  bool success = true;
  ::tab_search::mojom::RecentlyClosedTabGroupPtr result(::tab_search::mojom::RecentlyClosedTabGroup::New());
  
      if (success)
        result->session_id = input.session_id();
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadColor(&result->color))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success)
        result->tab_count = input.tab_count();
      if (success && !input.ReadLastActiveTime(&result->last_active_time))
        success = false;
      if (success && !input.ReadLastActiveElapsedText(&result->last_active_elapsed_text))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_search::mojom::SwitchToTabInfo::DataView, ::tab_search::mojom::SwitchToTabInfoPtr>::Read(
    ::tab_search::mojom::SwitchToTabInfo::DataView input,
    ::tab_search::mojom::SwitchToTabInfoPtr* output) {
  bool success = true;
  ::tab_search::mojom::SwitchToTabInfoPtr result(::tab_search::mojom::SwitchToTabInfo::New());
  
      if (success)
        result->tab_id = input.tab_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_search::mojom::TabOrganization::DataView, ::tab_search::mojom::TabOrganizationPtr>::Read(
    ::tab_search::mojom::TabOrganization::DataView input,
    ::tab_search::mojom::TabOrganizationPtr* output) {
  bool success = true;
  ::tab_search::mojom::TabOrganizationPtr result(::tab_search::mojom::TabOrganization::New());
  
      if (success)
        result->organization_id = input.organization_id();
      if (success && !input.ReadTabs(&result->tabs))
        success = false;
      if (success)
        result->first_new_tab_index = input.first_new_tab_index();
      if (success && !input.ReadName(&result->name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_search::mojom::TabOrganizationSession::DataView, ::tab_search::mojom::TabOrganizationSessionPtr>::Read(
    ::tab_search::mojom::TabOrganizationSession::DataView input,
    ::tab_search::mojom::TabOrganizationSessionPtr* output) {
  bool success = true;
  ::tab_search::mojom::TabOrganizationSessionPtr result(::tab_search::mojom::TabOrganizationSession::New());
  
      if (success)
        result->session_id = input.session_id();
      if (success && !input.ReadState(&result->state))
        success = false;
      if (success && !input.ReadOrganizations(&result->organizations))
        success = false;
      if (success && !input.ReadError(&result->error))
        success = false;
      if (success)
        result->active_tab_id = input.active_tab_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_search::mojom::TabUpdateInfo::DataView, ::tab_search::mojom::TabUpdateInfoPtr>::Read(
    ::tab_search::mojom::TabUpdateInfo::DataView input,
    ::tab_search::mojom::TabUpdateInfoPtr* output) {
  bool success = true;
  ::tab_search::mojom::TabUpdateInfoPtr result(::tab_search::mojom::TabUpdateInfo::New());
  
      if (success)
        result->in_active_window = input.in_active_window();
      if (success)
        result->in_host_window = input.in_host_window();
      if (success && !input.ReadTab(&result->tab))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_search::mojom::TabsRemovedInfo::DataView, ::tab_search::mojom::TabsRemovedInfoPtr>::Read(
    ::tab_search::mojom::TabsRemovedInfo::DataView input,
    ::tab_search::mojom::TabsRemovedInfoPtr* output) {
  bool success = true;
  ::tab_search::mojom::TabsRemovedInfoPtr result(::tab_search::mojom::TabsRemovedInfo::New());
  
      if (success && !input.ReadTabIds(&result->tab_ids))
        success = false;
      if (success && !input.ReadRecentlyClosedTabs(&result->recently_closed_tabs))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_search::mojom::UnusedTabInfo::DataView, ::tab_search::mojom::UnusedTabInfoPtr>::Read(
    ::tab_search::mojom::UnusedTabInfo::DataView input,
    ::tab_search::mojom::UnusedTabInfoPtr* output) {
  bool success = true;
  ::tab_search::mojom::UnusedTabInfoPtr result(::tab_search::mojom::UnusedTabInfo::New());
  
      if (success && !input.ReadStaleTabs(&result->stale_tabs))
        success = false;
      if (success && !input.ReadDuplicateTabs(&result->duplicate_tabs))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace tab_search::mojom {


void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::CloseTab(int32_t tab_id) {
  GetForwardingInterface()->CloseTab(
    std::move(tab_id)
    );
}
void PageHandlerInterceptorForTesting::CloseWebUiTab() {
  GetForwardingInterface()->CloseWebUiTab();
}
void PageHandlerInterceptorForTesting::DeclutterTabs(const std::vector<int32_t>& tab_ids, const std::vector<::GURL>& urls) {
  GetForwardingInterface()->DeclutterTabs(
    std::move(tab_ids)
    , 
    std::move(urls)
    );
}
void PageHandlerInterceptorForTesting::AcceptTabOrganization(int32_t session_id, int32_t organization_id, std::vector<TabPtr> tabs) {
  GetForwardingInterface()->AcceptTabOrganization(
    std::move(session_id)
    , 
    std::move(organization_id)
    , 
    std::move(tabs)
    );
}
void PageHandlerInterceptorForTesting::RejectTabOrganization(int32_t session_id, int32_t organization_id) {
  GetForwardingInterface()->RejectTabOrganization(
    std::move(session_id)
    , 
    std::move(organization_id)
    );
}
void PageHandlerInterceptorForTesting::RenameTabOrganization(int32_t session_id, int32_t organization_id, const ::std::u16string& name) {
  GetForwardingInterface()->RenameTabOrganization(
    std::move(session_id)
    , 
    std::move(organization_id)
    , 
    std::move(name)
    );
}
void PageHandlerInterceptorForTesting::ExcludeFromStaleTabs(int32_t tab_id) {
  GetForwardingInterface()->ExcludeFromStaleTabs(
    std::move(tab_id)
    );
}
void PageHandlerInterceptorForTesting::ExcludeFromDuplicateTabs(const ::GURL& url) {
  GetForwardingInterface()->ExcludeFromDuplicateTabs(
    std::move(url)
    );
}
void PageHandlerInterceptorForTesting::GetProfileData(GetProfileDataCallback callback) {
  GetForwardingInterface()->GetProfileData(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetUnusedTabs(GetUnusedTabsCallback callback) {
  GetForwardingInterface()->GetUnusedTabs(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetTabSearchSection(GetTabSearchSectionCallback callback) {
  GetForwardingInterface()->GetTabSearchSection(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetTabOrganizationFeature(GetTabOrganizationFeatureCallback callback) {
  GetForwardingInterface()->GetTabOrganizationFeature(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetTabOrganizationSession(GetTabOrganizationSessionCallback callback) {
  GetForwardingInterface()->GetTabOrganizationSession(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetTabOrganizationModelStrategy(GetTabOrganizationModelStrategyCallback callback) {
  GetForwardingInterface()->GetTabOrganizationModelStrategy(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetIsSplit(GetIsSplitCallback callback) {
  GetForwardingInterface()->GetIsSplit(std::move(callback));
}
void PageHandlerInterceptorForTesting::SwitchToTab(SwitchToTabInfoPtr switch_to_tab_info) {
  GetForwardingInterface()->SwitchToTab(
    std::move(switch_to_tab_info)
    );
}
void PageHandlerInterceptorForTesting::OpenRecentlyClosedEntry(int32_t session_id) {
  GetForwardingInterface()->OpenRecentlyClosedEntry(
    std::move(session_id)
    );
}
void PageHandlerInterceptorForTesting::RequestTabOrganization() {
  GetForwardingInterface()->RequestTabOrganization();
}
void PageHandlerInterceptorForTesting::RemoveTabFromOrganization(int32_t session_id, int32_t organization_id, TabPtr tab) {
  GetForwardingInterface()->RemoveTabFromOrganization(
    std::move(session_id)
    , 
    std::move(organization_id)
    , 
    std::move(tab)
    );
}
void PageHandlerInterceptorForTesting::RejectSession(int32_t session_id) {
  GetForwardingInterface()->RejectSession(
    std::move(session_id)
    );
}
void PageHandlerInterceptorForTesting::ReplaceActiveSplitTab(int32_t replacement_tab_id) {
  GetForwardingInterface()->ReplaceActiveSplitTab(
    std::move(replacement_tab_id)
    );
}
void PageHandlerInterceptorForTesting::RestartSession() {
  GetForwardingInterface()->RestartSession();
}
void PageHandlerInterceptorForTesting::SaveRecentlyClosedExpandedPref(bool expanded) {
  GetForwardingInterface()->SaveRecentlyClosedExpandedPref(
    std::move(expanded)
    );
}
void PageHandlerInterceptorForTesting::SetOrganizationFeature(TabOrganizationFeature feature) {
  GetForwardingInterface()->SetOrganizationFeature(
    std::move(feature)
    );
}
void PageHandlerInterceptorForTesting::StartTabGroupTutorial() {
  GetForwardingInterface()->StartTabGroupTutorial();
}
void PageHandlerInterceptorForTesting::TriggerFeedback(int32_t session_id) {
  GetForwardingInterface()->TriggerFeedback(
    std::move(session_id)
    );
}
void PageHandlerInterceptorForTesting::TriggerSignIn() {
  GetForwardingInterface()->TriggerSignIn();
}
void PageHandlerInterceptorForTesting::OpenHelpPage() {
  GetForwardingInterface()->OpenHelpPage();
}
void PageHandlerInterceptorForTesting::SetTabOrganizationModelStrategy(TabOrganizationModelStrategy strategy) {
  GetForwardingInterface()->SetTabOrganizationModelStrategy(
    std::move(strategy)
    );
}
void PageHandlerInterceptorForTesting::SetTabOrganizationUserInstruction(const std::string& user_instruction) {
  GetForwardingInterface()->SetTabOrganizationUserInstruction(
    std::move(user_instruction)
    );
}
void PageHandlerInterceptorForTesting::SetUserFeedback(int32_t session_id, UserFeedback feedback) {
  GetForwardingInterface()->SetUserFeedback(
    std::move(session_id)
    , 
    std::move(feedback)
    );
}
void PageHandlerInterceptorForTesting::NotifyOrganizationUIReadyToShow() {
  GetForwardingInterface()->NotifyOrganizationUIReadyToShow();
}
void PageHandlerInterceptorForTesting::NotifySearchUIReadyToShow() {
  GetForwardingInterface()->NotifySearchUIReadyToShow();
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::GetProfileData(
    ProfileDataPtr* out_profile_data) {
  base::RunLoop loop;
  proxy_->GetProfileData(
      base::BindOnce(
          [](base::RunLoop* loop,
             ProfileDataPtr* out_profile_data
,
             ProfileDataPtr profile_data) {*out_profile_data = std::move(profile_data);
            loop->Quit();
          },
          &loop,
          out_profile_data));
  loop.Run();
}

ProfileDataPtr PageHandlerAsyncWaiter::GetProfileData(
    ) {
  ProfileDataPtr async_wait_result;
  GetProfileData(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetUnusedTabs(
    UnusedTabInfoPtr* out_tabs) {
  base::RunLoop loop;
  proxy_->GetUnusedTabs(
      base::BindOnce(
          [](base::RunLoop* loop,
             UnusedTabInfoPtr* out_tabs
,
             UnusedTabInfoPtr tabs) {*out_tabs = std::move(tabs);
            loop->Quit();
          },
          &loop,
          out_tabs));
  loop.Run();
}

UnusedTabInfoPtr PageHandlerAsyncWaiter::GetUnusedTabs(
    ) {
  UnusedTabInfoPtr async_wait_result;
  GetUnusedTabs(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetTabSearchSection(
    TabSearchSection* out_section) {
  base::RunLoop loop;
  proxy_->GetTabSearchSection(
      base::BindOnce(
          [](base::RunLoop* loop,
             TabSearchSection* out_section
,
             TabSearchSection section) {*out_section = std::move(section);
            loop->Quit();
          },
          &loop,
          out_section));
  loop.Run();
}

TabSearchSection PageHandlerAsyncWaiter::GetTabSearchSection(
    ) {
  TabSearchSection async_wait_result;
  GetTabSearchSection(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetTabOrganizationFeature(
    TabOrganizationFeature* out_feature) {
  base::RunLoop loop;
  proxy_->GetTabOrganizationFeature(
      base::BindOnce(
          [](base::RunLoop* loop,
             TabOrganizationFeature* out_feature
,
             TabOrganizationFeature feature) {*out_feature = std::move(feature);
            loop->Quit();
          },
          &loop,
          out_feature));
  loop.Run();
}

TabOrganizationFeature PageHandlerAsyncWaiter::GetTabOrganizationFeature(
    ) {
  TabOrganizationFeature async_wait_result;
  GetTabOrganizationFeature(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetTabOrganizationSession(
    TabOrganizationSessionPtr* out_session) {
  base::RunLoop loop;
  proxy_->GetTabOrganizationSession(
      base::BindOnce(
          [](base::RunLoop* loop,
             TabOrganizationSessionPtr* out_session
,
             TabOrganizationSessionPtr session) {*out_session = std::move(session);
            loop->Quit();
          },
          &loop,
          out_session));
  loop.Run();
}

TabOrganizationSessionPtr PageHandlerAsyncWaiter::GetTabOrganizationSession(
    ) {
  TabOrganizationSessionPtr async_wait_result;
  GetTabOrganizationSession(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetTabOrganizationModelStrategy(
    TabOrganizationModelStrategy* out_strategy) {
  base::RunLoop loop;
  proxy_->GetTabOrganizationModelStrategy(
      base::BindOnce(
          [](base::RunLoop* loop,
             TabOrganizationModelStrategy* out_strategy
,
             TabOrganizationModelStrategy strategy) {*out_strategy = std::move(strategy);
            loop->Quit();
          },
          &loop,
          out_strategy));
  loop.Run();
}

TabOrganizationModelStrategy PageHandlerAsyncWaiter::GetTabOrganizationModelStrategy(
    ) {
  TabOrganizationModelStrategy async_wait_result;
  GetTabOrganizationModelStrategy(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetIsSplit(
    bool* out_is_split) {
  base::RunLoop loop;
  proxy_->GetIsSplit(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_split
,
             bool is_split) {*out_is_split = std::move(is_split);
            loop->Quit();
          },
          &loop,
          out_is_split));
  loop.Run();
}

bool PageHandlerAsyncWaiter::GetIsSplit(
    ) {
  bool async_wait_result;
  GetIsSplit(&async_wait_result);
  return async_wait_result;
}




void PageInterceptorForTesting::TabOrganizationSessionUpdated(TabOrganizationSessionPtr session) {
  GetForwardingInterface()->TabOrganizationSessionUpdated(
    std::move(session)
    );
}
void PageInterceptorForTesting::TabOrganizationModelStrategyUpdated(TabOrganizationModelStrategy strategy) {
  GetForwardingInterface()->TabOrganizationModelStrategyUpdated(
    std::move(strategy)
    );
}
void PageInterceptorForTesting::HostWindowChanged() {
  GetForwardingInterface()->HostWindowChanged();
}
void PageInterceptorForTesting::TabsChanged(ProfileDataPtr profile_tabs) {
  GetForwardingInterface()->TabsChanged(
    std::move(profile_tabs)
    );
}
void PageInterceptorForTesting::TabUpdated(TabUpdateInfoPtr tabUpdateInfo) {
  GetForwardingInterface()->TabUpdated(
    std::move(tabUpdateInfo)
    );
}
void PageInterceptorForTesting::TabsRemoved(TabsRemovedInfoPtr tabsRemovedInfo) {
  GetForwardingInterface()->TabsRemoved(
    std::move(tabsRemovedInfo)
    );
}
void PageInterceptorForTesting::TabSearchSectionChanged(TabSearchSection section) {
  GetForwardingInterface()->TabSearchSectionChanged(
    std::move(section)
    );
}
void PageInterceptorForTesting::TabOrganizationFeatureChanged(TabOrganizationFeature feature) {
  GetForwardingInterface()->TabOrganizationFeatureChanged(
    std::move(feature)
    );
}
void PageInterceptorForTesting::ShowFREChanged(bool show) {
  GetForwardingInterface()->ShowFREChanged(
    std::move(show)
    );
}
void PageInterceptorForTesting::TabOrganizationEnabledChanged(bool enabled) {
  GetForwardingInterface()->TabOrganizationEnabledChanged(
    std::move(enabled)
    );
}
void PageInterceptorForTesting::UnusedTabsChanged(UnusedTabInfoPtr tabs) {
  GetForwardingInterface()->UnusedTabsChanged(
    std::move(tabs)
    );
}
void PageInterceptorForTesting::TabUnsplit() {
  GetForwardingInterface()->TabUnsplit();
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // tab_search::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif