// chrome/browser/ui/webui/suggest_internals/suggest_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SUGGEST_INTERNALS_SUGGEST_INTERNALS_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_SUGGEST_INTERNALS_SUGGEST_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/suggest_internals/suggest_internals.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/suggest_internals/suggest_internals.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/suggest_internals/suggest_internals.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "url/mojom/url.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace suggest_internals::mojom {

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "suggest_internals.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetPageMinVersion = 0,
    kHardcodeResponseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HardcodeResponse_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void SetPage(::mojo::PendingRemote<Page> page) = 0;

  using HardcodeResponseCallback = base::OnceCallback<void(RequestPtr)>;
  using HardcodeResponseMojoCallback = base::OnceCallback<void(RequestPtr)>;

  virtual void HardcodeResponse(const std::string& response, ::base::TimeDelta delay, HardcodeResponseCallback callback) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "suggest_internals.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnRequestCreatedMinVersion = 0,
    kOnRequestStartedMinVersion = 0,
    kOnRequestCompletedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnRequestCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnRequestStarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnRequestCompleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void OnRequestCreated(RequestPtr request) = 0;

  virtual void OnRequestStarted(RequestPtr request) = 0;

  virtual void OnRequestCompleted(RequestPtr request) = 0;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetPage(::mojo::PendingRemote<Page> page) final;
  
  void HardcodeResponse(const std::string& response, ::base::TimeDelta delay, HardcodeResponseCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnRequestCreated(RequestPtr request) final;
  
  void OnRequestStarted(RequestPtr request) final;
  
  void OnRequestCompleted(RequestPtr request) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  Request {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Request, T>::value>;
  using DataView = RequestDataView;
  using Data_ = internal::Request_Data;

  template <typename... Args>
  static RequestPtr New(Args&&... args) {
    return RequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RequestPtr From(const U& u) {
    return mojo::TypeConverter<RequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Request>::Convert(*this);
  }


  Request();

  Request(
      const ::base::UnguessableToken& id,
      const ::GURL& url,
      const base::flat_map<std::string, std::string>& data,
      RequestStatus status,
      ::base::Time start_time,
      ::base::Time end_time,
      const std::string& response);


  ~Request();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RequestPtr>
  RequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Request::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Request::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Request::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Request::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Request::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Request::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Request_UnserializedMessageContext<
            UserType, Request::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Request::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Request::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Request_UnserializedMessageContext<
            UserType, Request::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Request::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::UnguessableToken id;
  
  ::GURL url;
  
  base::flat_map<std::string, std::string> data;
  
  RequestStatus status;
  
  ::base::Time start_time;
  
  ::base::Time end_time;
  
  std::string response;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Request::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Request::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Request::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Request::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RequestPtr Request::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(url),
      mojo::Clone(data),
      mojo::Clone(status),
      mojo::Clone(start_time),
      mojo::Clone(end_time),
      mojo::Clone(response)
  );
}

template <typename T, Request::EnableIfSame<T>*>
bool Request::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  if (!mojo::Equals(this->start_time, other_struct.start_time))
    return false;
  if (!mojo::Equals(this->end_time, other_struct.end_time))
    return false;
  if (!mojo::Equals(this->response, other_struct.response))
    return false;
  return true;
}

template <typename T, Request::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  if (lhs.start_time < rhs.start_time)
    return true;
  if (rhs.start_time < lhs.start_time)
    return false;
  if (lhs.end_time < rhs.end_time)
    return true;
  if (rhs.end_time < lhs.end_time)
    return false;
  if (lhs.response < rhs.response)
    return true;
  if (rhs.response < lhs.response)
    return false;
  return false;
}


}  // suggest_internals::mojom

namespace mojo {


template <>
struct  StructTraits<::suggest_internals::mojom::Request::DataView,
                                         ::suggest_internals::mojom::RequestPtr> {
  static bool IsNull(const ::suggest_internals::mojom::RequestPtr& input) { return !input; }
  static void SetToNull(::suggest_internals::mojom::RequestPtr* output) { output->reset(); }

  static const decltype(::suggest_internals::mojom::Request::id)& id(
      const ::suggest_internals::mojom::RequestPtr& input) {
    return input->id;
  }

  static const decltype(::suggest_internals::mojom::Request::url)& url(
      const ::suggest_internals::mojom::RequestPtr& input) {
    return input->url;
  }

  static const decltype(::suggest_internals::mojom::Request::data)& data(
      const ::suggest_internals::mojom::RequestPtr& input) {
    return input->data;
  }

  static decltype(::suggest_internals::mojom::Request::status) status(
      const ::suggest_internals::mojom::RequestPtr& input) {
    return input->status;
  }

  static const decltype(::suggest_internals::mojom::Request::start_time)& start_time(
      const ::suggest_internals::mojom::RequestPtr& input) {
    return input->start_time;
  }

  static const decltype(::suggest_internals::mojom::Request::end_time)& end_time(
      const ::suggest_internals::mojom::RequestPtr& input) {
    return input->end_time;
  }

  static const decltype(::suggest_internals::mojom::Request::response)& response(
      const ::suggest_internals::mojom::RequestPtr& input) {
    return input->response;
  }

  static bool Read(::suggest_internals::mojom::Request::DataView input, ::suggest_internals::mojom::RequestPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_SUGGEST_INTERNALS_SUGGEST_INTERNALS_MOJOM_H_