// chrome/browser/ui/webui/signin/batch_upload/batch_upload.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/signin/batch_upload/batch_upload.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/signin/batch_upload/batch_upload.mojom-params-data.h"
#include "chrome/browser/ui/webui/signin/batch_upload/batch_upload.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/signin/batch_upload/batch_upload.mojom-import-headers.h"
#include "chrome/browser/ui/webui/signin/batch_upload/batch_upload.mojom-test-utils.h"


namespace batch_upload::mojom {
DataItem::DataItem()
    : id(),
      icon_url(),
      title(),
      subtitle() {}

DataItem::DataItem(
    int32_t id_in,
    const std::string& icon_url_in,
    const std::string& title_in,
    const std::string& subtitle_in)
    : id(std::move(id_in)),
      icon_url(std::move(icon_url_in)),
      title(std::move(title_in)),
      subtitle(std::move(subtitle_in)) {}

DataItem::~DataItem() = default;
size_t DataItem::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  seed = mojo::internal::Hash(seed, this->icon_url);
  seed = mojo::internal::Hash(seed, this->title);
  seed = mojo::internal::Hash(seed, this->subtitle);
  return seed;
}

void DataItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon_url"), this->icon_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subtitle"), this->subtitle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DataItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataContainer::DataContainer()
    : section_title(),
      data_items(),
      is_theme() {}

DataContainer::DataContainer(
    const std::string& section_title_in,
    std::vector<DataItemPtr> data_items_in,
    bool is_theme_in)
    : section_title(std::move(section_title_in)),
      data_items(std::move(data_items_in)),
      is_theme(std::move(is_theme_in)) {}

DataContainer::~DataContainer() = default;

void DataContainer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "section_title"), this->section_title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_items"), this->data_items,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<DataItemPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_theme"), this->is_theme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DataContainer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BatchUploadAccountInfo::BatchUploadAccountInfo()
    : email(),
      data_picture_url() {}

BatchUploadAccountInfo::BatchUploadAccountInfo(
    const std::string& email_in,
    const std::string& data_picture_url_in)
    : email(std::move(email_in)),
      data_picture_url(std::move(data_picture_url_in)) {}

BatchUploadAccountInfo::~BatchUploadAccountInfo() = default;
size_t BatchUploadAccountInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->email);
  seed = mojo::internal::Hash(seed, this->data_picture_url);
  return seed;
}

void BatchUploadAccountInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "email"), this->email,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_picture_url"), this->data_picture_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BatchUploadAccountInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BatchUploadData::BatchUploadData()
    : account_info(),
      dialog_subtitle(),
      data_containers() {}

BatchUploadData::BatchUploadData(
    BatchUploadAccountInfoPtr account_info_in,
    const std::string& dialog_subtitle_in,
    std::vector<DataContainerPtr> data_containers_in)
    : account_info(std::move(account_info_in)),
      dialog_subtitle(std::move(dialog_subtitle_in)),
      data_containers(std::move(data_containers_in)) {}

BatchUploadData::~BatchUploadData() = default;

void BatchUploadData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "account_info"), this->account_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BatchUploadAccountInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dialog_subtitle"), this->dialog_subtitle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_containers"), this->data_containers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<DataContainerPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BatchUploadData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreateBatchUploadHandler: {
      return &PageHandlerFactory::CreateBatchUploadHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreateBatchUploadHandler:
            return "Receive batch_upload::mojom::PageHandlerFactory::CreateBatchUploadHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreateBatchUploadHandler:
            return "Receive reply batch_upload::mojom::PageHandlerFactory::CreateBatchUploadHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreateBatchUploadHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x650b7844;  // IPCStableHash for batch_upload::mojom::PageHandlerFactory::CreateBatchUploadHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreateBatchUploadHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send batch_upload::mojom::PageHandlerFactory::CreateBatchUploadHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreateBatchUploadHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::batch_upload::mojom::internal::PageHandlerFactory_CreateBatchUploadHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::batch_upload::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreateBatchUploadHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::batch_upload::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreateBatchUploadHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreateBatchUploadHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreateBatchUploadHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreateBatchUploadHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreateBatchUploadHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreateBatchUploadHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateBatchUploadHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreateBatchUploadHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreateBatchUploadHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::batch_upload::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kUpdateViewHeight: {
      return &PageHandler::UpdateViewHeight_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSaveToAccount: {
      return &PageHandler::SaveToAccount_Sym::IPCStableHash;
    }
    case messages::PageHandler::kClose: {
      return &PageHandler::Close_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kUpdateViewHeight:
            return "Receive batch_upload::mojom::PageHandler::UpdateViewHeight";
      case messages::PageHandler::kSaveToAccount:
            return "Receive batch_upload::mojom::PageHandler::SaveToAccount";
      case messages::PageHandler::kClose:
            return "Receive batch_upload::mojom::PageHandler::Close";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kUpdateViewHeight:
            return "Receive reply batch_upload::mojom::PageHandler::UpdateViewHeight";
      case messages::PageHandler::kSaveToAccount:
            return "Receive reply batch_upload::mojom::PageHandler::SaveToAccount";
      case messages::PageHandler::kClose:
            return "Receive reply batch_upload::mojom::PageHandler::Close";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::UpdateViewHeight_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5eb2d46c;  // IPCStableHash for batch_upload::mojom::PageHandler::UpdateViewHeight
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SaveToAccount_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc4977ef8;  // IPCStableHash for batch_upload::mojom::PageHandler::SaveToAccount
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Close_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdec82a17;  // IPCStableHash for batch_upload::mojom::PageHandler::Close
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::UpdateViewHeight(
    uint32_t in_height) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send batch_upload::mojom::PageHandler::UpdateViewHeight", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("height"), in_height,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUpdateViewHeight), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::batch_upload::mojom::internal::PageHandler_UpdateViewHeight_Params_Data> params(
          message);
  params.Allocate();

  params->height = in_height;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UpdateViewHeight");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SaveToAccount(
    const std::vector<std::vector<int32_t>>& in_idsToMove) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send batch_upload::mojom::PageHandler::SaveToAccount", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("idsToMove"), in_idsToMove,
                        "<value of type const std::vector<std::vector<int32_t>>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSaveToAccount), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::batch_upload::mojom::internal::PageHandler_SaveToAccount_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->idsToMove)::BaseType>
      idsToMove_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& idsToMove_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<int32_t>>>(
    in_idsToMove,
    idsToMove_fragment,
    &idsToMove_validate_params);

  params->idsToMove.Set(
      idsToMove_fragment.is_null() ? nullptr : idsToMove_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->idsToMove.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null idsToMove in PageHandler.SaveToAccount request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SaveToAccount");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Close(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send batch_upload::mojom::PageHandler::Close");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::batch_upload::mojom::internal::PageHandler_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Close");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kUpdateViewHeight: {
      DCHECK(message->is_serialized());
      internal::PageHandler_UpdateViewHeight_Params_Data* params =
          reinterpret_cast<internal::PageHandler_UpdateViewHeight_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      uint32_t p_height{};
      PageHandler_UpdateViewHeight_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_height = input_data_view.height();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateViewHeight(        
        std::move(p_height));
      return true;
    }
    case messages::PageHandler::kSaveToAccount: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SaveToAccount_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SaveToAccount_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      std::vector<std::vector<int32_t>> p_idsToMove{};
      PageHandler_SaveToAccount_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIdsToMove(&p_idsToMove))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SaveToAccount(        
        std::move(p_idsToMove));
      return true;
    }
    case messages::PageHandler::kClose: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Close_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Close_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      PageHandler_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(        );
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kUpdateViewHeight: {
      break;
    }
    case messages::PageHandler::kSaveToAccount: {
      break;
    }
    case messages::PageHandler::kClose: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_UpdateViewHeight_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SaveToAccount_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Close_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::batch_upload::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kSendBatchUploadData: {
      return &Page::SendBatchUploadData_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kSendBatchUploadData:
            return "Receive batch_upload::mojom::Page::SendBatchUploadData";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kSendBatchUploadData:
            return "Receive reply batch_upload::mojom::Page::SendBatchUploadData";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::SendBatchUploadData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfcff6f35;  // IPCStableHash for batch_upload::mojom::Page::SendBatchUploadData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::SendBatchUploadData(
    BatchUploadDataPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send batch_upload::mojom::Page::SendBatchUploadData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type BatchUploadDataPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSendBatchUploadData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::batch_upload::mojom::internal::Page_SendBatchUploadData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::batch_upload::mojom::BatchUploadDataDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in Page.SendBatchUploadData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SendBatchUploadData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kSendBatchUploadData: {
      DCHECK(message->is_serialized());
      internal::Page_SendBatchUploadData_Params_Data* params =
          reinterpret_cast<internal::Page_SendBatchUploadData_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      BatchUploadDataPtr p_data{};
      Page_SendBatchUploadData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendBatchUploadData(        
        std::move(p_data));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kSendBatchUploadData: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_SendBatchUploadData_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::batch_upload::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // batch_upload::mojom


namespace mojo {


// static
bool StructTraits<::batch_upload::mojom::DataItem::DataView, ::batch_upload::mojom::DataItemPtr>::Read(
    ::batch_upload::mojom::DataItem::DataView input,
    ::batch_upload::mojom::DataItemPtr* output) {
  bool success = true;
  ::batch_upload::mojom::DataItemPtr result(::batch_upload::mojom::DataItem::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadIconUrl(&result->icon_url))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadSubtitle(&result->subtitle))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::batch_upload::mojom::DataContainer::DataView, ::batch_upload::mojom::DataContainerPtr>::Read(
    ::batch_upload::mojom::DataContainer::DataView input,
    ::batch_upload::mojom::DataContainerPtr* output) {
  bool success = true;
  ::batch_upload::mojom::DataContainerPtr result(::batch_upload::mojom::DataContainer::New());
  
      if (success && !input.ReadSectionTitle(&result->section_title))
        success = false;
      if (success && !input.ReadDataItems(&result->data_items))
        success = false;
      if (success)
        result->is_theme = input.is_theme();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::batch_upload::mojom::BatchUploadAccountInfo::DataView, ::batch_upload::mojom::BatchUploadAccountInfoPtr>::Read(
    ::batch_upload::mojom::BatchUploadAccountInfo::DataView input,
    ::batch_upload::mojom::BatchUploadAccountInfoPtr* output) {
  bool success = true;
  ::batch_upload::mojom::BatchUploadAccountInfoPtr result(::batch_upload::mojom::BatchUploadAccountInfo::New());
  
      if (success && !input.ReadEmail(&result->email))
        success = false;
      if (success && !input.ReadDataPictureUrl(&result->data_picture_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::batch_upload::mojom::BatchUploadData::DataView, ::batch_upload::mojom::BatchUploadDataPtr>::Read(
    ::batch_upload::mojom::BatchUploadData::DataView input,
    ::batch_upload::mojom::BatchUploadDataPtr* output) {
  bool success = true;
  ::batch_upload::mojom::BatchUploadDataPtr result(::batch_upload::mojom::BatchUploadData::New());
  
      if (success && !input.ReadAccountInfo(&result->account_info))
        success = false;
      if (success && !input.ReadDialogSubtitle(&result->dialog_subtitle))
        success = false;
      if (success && !input.ReadDataContainers(&result->data_containers))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace batch_upload::mojom {


void PageHandlerFactoryInterceptorForTesting::CreateBatchUploadHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreateBatchUploadHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::UpdateViewHeight(uint32_t height) {
  GetForwardingInterface()->UpdateViewHeight(
    std::move(height)
    );
}
void PageHandlerInterceptorForTesting::SaveToAccount(const std::vector<std::vector<int32_t>>& idsToMove) {
  GetForwardingInterface()->SaveToAccount(
    std::move(idsToMove)
    );
}
void PageHandlerInterceptorForTesting::Close() {
  GetForwardingInterface()->Close();
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;





void PageInterceptorForTesting::SendBatchUploadData(BatchUploadDataPtr data) {
  GetForwardingInterface()->SendBatchUploadData(
    std::move(data)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // batch_upload::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif