// chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_READING_LIST_READING_LIST_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_READING_LIST_READING_LIST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-shared-internal.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-data-view.h"




namespace std {

template <>
struct hash<::reading_list::mojom::CurrentPageActionButtonState>
    : public mojo::internal::EnumHashImpl<::reading_list::mojom::CurrentPageActionButtonState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::reading_list::mojom::CurrentPageActionButtonState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::reading_list::mojom::CurrentPageActionButtonState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::reading_list::mojom::CurrentPageActionButtonState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::reading_list::mojom::ReadLaterEntriesByStatusDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::reading_list::mojom::ReadLaterEntriesByStatusDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::reading_list::mojom::internal::ReadLaterEntriesByStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::unread_entries(input)) in_unread_entries = Traits::unread_entries(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->unread_entries)::BaseType>
        unread_entries_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& unread_entries_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::reading_list::mojom::ReadLaterEntryDataView>>(
      in_unread_entries,
      unread_entries_fragment,
      &unread_entries_validate_params);

    fragment->unread_entries.Set(
        unread_entries_fragment.is_null() ? nullptr : unread_entries_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->unread_entries.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null unread_entries in ReadLaterEntriesByStatus struct");

    decltype(Traits::read_entries(input)) in_read_entries = Traits::read_entries(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->read_entries)::BaseType>
        read_entries_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& read_entries_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::reading_list::mojom::ReadLaterEntryDataView>>(
      in_read_entries,
      read_entries_fragment,
      &read_entries_validate_params);

    fragment->read_entries.Set(
        read_entries_fragment.is_null() ? nullptr : read_entries_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->read_entries.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null read_entries in ReadLaterEntriesByStatus struct");
  }

  static bool Deserialize(::reading_list::mojom::internal::ReadLaterEntriesByStatus_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::reading_list::mojom::ReadLaterEntriesByStatusDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::reading_list::mojom::ReadLaterEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::reading_list::mojom::ReadLaterEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::reading_list::mojom::internal::ReadLaterEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in ReadLaterEntry struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in ReadLaterEntry struct");

    decltype(Traits::display_url(input)) in_display_url = Traits::display_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_url)::BaseType> display_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_url,
      display_url_fragment);

    fragment->display_url.Set(
        display_url_fragment.is_null() ? nullptr : display_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_url in ReadLaterEntry struct");

    fragment->update_time = Traits::update_time(input);

    fragment->read = Traits::read(input);

    decltype(Traits::display_time_since_update(input)) in_display_time_since_update = Traits::display_time_since_update(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_time_since_update)::BaseType> display_time_since_update_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_time_since_update,
      display_time_since_update_fragment);

    fragment->display_time_since_update.Set(
        display_time_since_update_fragment.is_null() ? nullptr : display_time_since_update_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_time_since_update.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_time_since_update in ReadLaterEntry struct");
  }

  static bool Deserialize(::reading_list::mojom::internal::ReadLaterEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::reading_list::mojom::ReadLaterEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::reading_list::mojom::WindowDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::reading_list::mojom::WindowDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::reading_list::mojom::internal::Window_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->active = Traits::active(input);

    fragment->height = Traits::height(input);
  }

  static bool Deserialize(::reading_list::mojom::internal::Window_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::reading_list::mojom::WindowDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace reading_list::mojom {

inline void ReadLaterEntriesByStatusDataView::GetUnreadEntriesDataView(
    mojo::ArrayDataView<ReadLaterEntryDataView>* output) {
  auto pointer = data_->unread_entries.Get();
  *output = mojo::ArrayDataView<ReadLaterEntryDataView>(pointer, message_);
}
inline void ReadLaterEntriesByStatusDataView::GetReadEntriesDataView(
    mojo::ArrayDataView<ReadLaterEntryDataView>* output) {
  auto pointer = data_->read_entries.Get();
  *output = mojo::ArrayDataView<ReadLaterEntryDataView>(pointer, message_);
}


inline void ReadLaterEntryDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ReadLaterEntryDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ReadLaterEntryDataView::GetDisplayUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ReadLaterEntryDataView::GetDisplayTimeSinceUpdateDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_time_since_update.Get();
  *output = mojo::StringDataView(pointer, message_);
}





}  // reading_list::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::reading_list::mojom::CurrentPageActionButtonState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::reading_list::mojom::CurrentPageActionButtonState value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_READING_LIST_READING_LIST_MOJOM_SHARED_H_