// chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom-params-data.h"
namespace side_panel {
namespace customize_chrome {
namespace mojom {

NOINLINE static const char* ActionIdToStringHelper(ActionId value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ActionId::kShowBookmarks:
      return "kShowBookmarks";
    case ActionId::kShowHistoryCluster:
      return "kShowHistoryCluster";
    case ActionId::kShowReadAnything:
      return "kShowReadAnything";
    case ActionId::kShowReadingList:
      return "kShowReadingList";
    case ActionId::kShowLensOverlay:
      return "kShowLensOverlay";
    case ActionId::kShowSearchCompanion:
      return "kShowSearchCompanion";
    case ActionId::kHome:
      return "kHome";
    case ActionId::kForward:
      return "kForward";
    case ActionId::kNewIncognitoWindow:
      return "kNewIncognitoWindow";
    case ActionId::kShowPasswordManager:
      return "kShowPasswordManager";
    case ActionId::kShowPaymentMethods:
      return "kShowPaymentMethods";
    case ActionId::kShowAddresses:
      return "kShowAddresses";
    case ActionId::kShowDownloads:
      return "kShowDownloads";
    case ActionId::kClearBrowsingData:
      return "kClearBrowsingData";
    case ActionId::kPrint:
      return "kPrint";
    case ActionId::kShowTranslate:
      return "kShowTranslate";
    case ActionId::kSendTabToSelf:
      return "kSendTabToSelf";
    case ActionId::kQrCodeGenerator:
      return "kQrCodeGenerator";
    case ActionId::kRouteMedia:
      return "kRouteMedia";
    case ActionId::kTaskManager:
      return "kTaskManager";
    case ActionId::kDevTools:
      return "kDevTools";
    case ActionId::kShowChromeLabs:
      return "kShowChromeLabs";
    case ActionId::kCopyLink:
      return "kCopyLink";
    case ActionId::kTabSearch:
      return "kTabSearch";
    case ActionId::kSplitTab:
      return "kSplitTab";
    default:
      return nullptr;
  }
}

std::string ActionIdToString(ActionId value) {
  const char *str = ActionIdToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ActionId value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ActionId value) {
  return os << ActionIdToString(value);
}

NOINLINE static const char* CategoryIdToStringHelper(CategoryId value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CategoryId::kNavigation:
      return "kNavigation";
    case CategoryId::kYourChrome:
      return "kYourChrome";
    case CategoryId::kTools:
      return "kTools";
    default:
      return nullptr;
  }
}

std::string CategoryIdToString(CategoryId value) {
  const char *str = CategoryIdToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CategoryId value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CategoryId value) {
  return os << CategoryIdToString(value);
}

namespace internal {


// static
bool Action_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Action_Data* object =
      static_cast<const Action_Data*>(data);


  if (!::side_panel::customize_chrome::mojom::internal::ActionId_Data
        ::Validate(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }


  if (!::side_panel::customize_chrome::mojom::internal::CategoryId_Data
        ::Validate(object->category, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->icon_url, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->icon_url, validation_context))
    return false;

  return true;
}

Action_Data::Action_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Category_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Category_Data* object =
      static_cast<const Category_Data*>(data);


  if (!::side_panel::customize_chrome::mojom::internal::CategoryId_Data
        ::Validate(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  return true;
}

Category_Data::Category_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_Params_Data* object =
      static_cast<const CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_Params_Data::CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeToolbarHandler_ListActions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeToolbarHandler_ListActions_Params_Data* object =
      static_cast<const CustomizeToolbarHandler_ListActions_Params_Data*>(data);

  return true;
}

CustomizeToolbarHandler_ListActions_Params_Data::CustomizeToolbarHandler_ListActions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeToolbarHandler_ListActions_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeToolbarHandler_ListActions_ResponseParams_Data* object =
      static_cast<const CustomizeToolbarHandler_ListActions_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->actions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& actions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->actions, validation_context,
                                         &actions_validate_params)) {
    return false;
  }

  return true;
}

CustomizeToolbarHandler_ListActions_ResponseParams_Data::CustomizeToolbarHandler_ListActions_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeToolbarHandler_ListCategories_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeToolbarHandler_ListCategories_Params_Data* object =
      static_cast<const CustomizeToolbarHandler_ListCategories_Params_Data*>(data);

  return true;
}

CustomizeToolbarHandler_ListCategories_Params_Data::CustomizeToolbarHandler_ListCategories_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeToolbarHandler_ListCategories_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeToolbarHandler_ListCategories_ResponseParams_Data* object =
      static_cast<const CustomizeToolbarHandler_ListCategories_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->categories, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& categories_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->categories, validation_context,
                                         &categories_validate_params)) {
    return false;
  }

  return true;
}

CustomizeToolbarHandler_ListCategories_ResponseParams_Data::CustomizeToolbarHandler_ListCategories_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeToolbarHandler_PinAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeToolbarHandler_PinAction_Params_Data* object =
      static_cast<const CustomizeToolbarHandler_PinAction_Params_Data*>(data);


  if (!::side_panel::customize_chrome::mojom::internal::ActionId_Data
        ::Validate(object->action_id, validation_context))
    return false;

  return true;
}

CustomizeToolbarHandler_PinAction_Params_Data::CustomizeToolbarHandler_PinAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeToolbarHandler_GetIsCustomized_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeToolbarHandler_GetIsCustomized_Params_Data* object =
      static_cast<const CustomizeToolbarHandler_GetIsCustomized_Params_Data*>(data);

  return true;
}

CustomizeToolbarHandler_GetIsCustomized_Params_Data::CustomizeToolbarHandler_GetIsCustomized_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeToolbarHandler_GetIsCustomized_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeToolbarHandler_GetIsCustomized_ResponseParams_Data* object =
      static_cast<const CustomizeToolbarHandler_GetIsCustomized_ResponseParams_Data*>(data);

  return true;
}

CustomizeToolbarHandler_GetIsCustomized_ResponseParams_Data::CustomizeToolbarHandler_GetIsCustomized_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeToolbarHandler_ResetToDefault_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeToolbarHandler_ResetToDefault_Params_Data* object =
      static_cast<const CustomizeToolbarHandler_ResetToDefault_Params_Data*>(data);

  return true;
}

CustomizeToolbarHandler_ResetToDefault_Params_Data::CustomizeToolbarHandler_ResetToDefault_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeToolbarClient_SetActionPinned_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeToolbarClient_SetActionPinned_Params_Data* object =
      static_cast<const CustomizeToolbarClient_SetActionPinned_Params_Data*>(data);


  if (!::side_panel::customize_chrome::mojom::internal::ActionId_Data
        ::Validate(object->action_id, validation_context))
    return false;

  return true;
}

CustomizeToolbarClient_SetActionPinned_Params_Data::CustomizeToolbarClient_SetActionPinned_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeToolbarClient_NotifyActionsUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeToolbarClient_NotifyActionsUpdated_Params_Data* object =
      static_cast<const CustomizeToolbarClient_NotifyActionsUpdated_Params_Data*>(data);

  return true;
}

CustomizeToolbarClient_NotifyActionsUpdated_Params_Data::CustomizeToolbarClient_NotifyActionsUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace customize_chrome
}  // namespace side_panel

namespace perfetto {

// static
void TraceFormatTraits<::side_panel::customize_chrome::mojom::ActionId>::WriteIntoTrace(
   perfetto::TracedValue context, ::side_panel::customize_chrome::mojom::ActionId value) {
  return std::move(context).WriteString(::side_panel::customize_chrome::mojom::ActionIdToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::side_panel::customize_chrome::mojom::CategoryId>::WriteIntoTrace(
   perfetto::TracedValue context, ::side_panel::customize_chrome::mojom::CategoryId value) {
  return std::move(context).WriteString(::side_panel::customize_chrome::mojom::CategoryIdToString(value));
}

} // namespace perfetto