// chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom-params-data.h"
#include "chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom-import-headers.h"
#include "chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom-test-utils.h"


namespace side_panel::mojom {
BookmarksTreeNode::BookmarksTreeNode()
    : id(),
      parent_id(),
      index(),
      title(),
      url(),
      children(),
      date_added(),
      date_last_used(),
      unmodifiable() {}

BookmarksTreeNode::BookmarksTreeNode(
    const std::string& id_in,
    const std::string& parent_id_in,
    uint32_t index_in,
    const std::string& title_in,
    const std::optional<std::string>& url_in,
    std::optional<std::vector<BookmarksTreeNodePtr>> children_in,
    std::optional<double> date_added_in,
    std::optional<double> date_last_used_in,
    bool unmodifiable_in)
    : id(std::move(id_in)),
      parent_id(std::move(parent_id_in)),
      index(std::move(index_in)),
      title(std::move(title_in)),
      url(std::move(url_in)),
      children(std::move(children_in)),
      date_added(std::move(date_added_in)),
      date_last_used(std::move(date_last_used_in)),
      unmodifiable(std::move(unmodifiable_in)) {}

BookmarksTreeNode::~BookmarksTreeNode() = default;

void BookmarksTreeNode::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "parent_id"), this->parent_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "index"), this->index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "children"), this->children,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<std::vector<BookmarksTreeNodePtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "date_added"), this->date_added,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<double>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "date_last_used"), this->date_last_used,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<double>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unmodifiable"), this->unmodifiable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BookmarksTreeNode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

BookmarksPageHandlerFactory::IPCStableHashFunction BookmarksPageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BookmarksPageHandlerFactory>(message.name())) {
    case messages::BookmarksPageHandlerFactory::kCreateBookmarksPageHandler: {
      return &BookmarksPageHandlerFactory::CreateBookmarksPageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BookmarksPageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BookmarksPageHandlerFactory>(message.name())) {
      case messages::BookmarksPageHandlerFactory::kCreateBookmarksPageHandler:
            return "Receive side_panel::mojom::BookmarksPageHandlerFactory::CreateBookmarksPageHandler";
    }
  } else {
    switch (static_cast<messages::BookmarksPageHandlerFactory>(message.name())) {
      case messages::BookmarksPageHandlerFactory::kCreateBookmarksPageHandler:
            return "Receive reply side_panel::mojom::BookmarksPageHandlerFactory::CreateBookmarksPageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BookmarksPageHandlerFactory::CreateBookmarksPageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71b51244;  // IPCStableHash for side_panel::mojom::BookmarksPageHandlerFactory::CreateBookmarksPageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

BookmarksPageHandlerFactoryProxy::BookmarksPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BookmarksPageHandlerFactoryProxy::CreateBookmarksPageHandler(
    ::mojo::PendingRemote<BookmarksPage> in_page, ::mojo::PendingReceiver<BookmarksPageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandlerFactory::CreateBookmarksPageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<BookmarksPage>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<BookmarksPageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandlerFactory::kCreateBookmarksPageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandlerFactory_CreateBookmarksPageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::side_panel::mojom::BookmarksPageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in BookmarksPageHandlerFactory.CreateBookmarksPageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::side_panel::mojom::BookmarksPageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in BookmarksPageHandlerFactory.CreateBookmarksPageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandlerFactory::Name_);
  message.set_method_name("CreateBookmarksPageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool BookmarksPageHandlerFactoryStubDispatch::Accept(
    BookmarksPageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BookmarksPageHandlerFactory>(message->header()->name)) {
    case messages::BookmarksPageHandlerFactory::kCreateBookmarksPageHandler: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandlerFactory_CreateBookmarksPageHandler_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandlerFactory_CreateBookmarksPageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<BookmarksPage> p_page{};
      ::mojo::PendingReceiver<BookmarksPageHandler> p_handler{};
      BookmarksPageHandlerFactory_CreateBookmarksPageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateBookmarksPageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool BookmarksPageHandlerFactoryStubDispatch::AcceptWithResponder(
    BookmarksPageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BookmarksPageHandlerFactory>(message->header()->name)) {
    case messages::BookmarksPageHandlerFactory::kCreateBookmarksPageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBookmarksPageHandlerFactoryValidationInfo[] = {
    { &internal::BookmarksPageHandlerFactory_CreateBookmarksPageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool BookmarksPageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::side_panel::mojom::BookmarksPageHandlerFactory::Name_,
    kBookmarksPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

BookmarksPageHandler::IPCStableHashFunction BookmarksPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BookmarksPageHandler>(message.name())) {
    case messages::BookmarksPageHandler::kBookmarkCurrentTabInFolder: {
      return &BookmarksPageHandler::BookmarkCurrentTabInFolder_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kCreateFolder: {
      return &BookmarksPageHandler::CreateFolder_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kDropBookmarks: {
      return &BookmarksPageHandler::DropBookmarks_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kExecuteEditCommand: {
      return &BookmarksPageHandler::ExecuteEditCommand_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kExecuteMoveCommand: {
      return &BookmarksPageHandler::ExecuteMoveCommand_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kExecuteOpenInNewTabCommand: {
      return &BookmarksPageHandler::ExecuteOpenInNewTabCommand_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kExecuteOpenInNewWindowCommand: {
      return &BookmarksPageHandler::ExecuteOpenInNewWindowCommand_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kExecuteOpenInIncognitoWindowCommand: {
      return &BookmarksPageHandler::ExecuteOpenInIncognitoWindowCommand_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kExecuteOpenInNewTabGroupCommand: {
      return &BookmarksPageHandler::ExecuteOpenInNewTabGroupCommand_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kExecuteOpenInSplitViewCommand: {
      return &BookmarksPageHandler::ExecuteOpenInSplitViewCommand_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kExecuteAddToBookmarksBarCommand: {
      return &BookmarksPageHandler::ExecuteAddToBookmarksBarCommand_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kExecuteRemoveFromBookmarksBarCommand: {
      return &BookmarksPageHandler::ExecuteRemoveFromBookmarksBarCommand_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kExecuteDeleteCommand: {
      return &BookmarksPageHandler::ExecuteDeleteCommand_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kOpenBookmark: {
      return &BookmarksPageHandler::OpenBookmark_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kUndo: {
      return &BookmarksPageHandler::Undo_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kRenameBookmark: {
      return &BookmarksPageHandler::RenameBookmark_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kMoveBookmark: {
      return &BookmarksPageHandler::MoveBookmark_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kRemoveBookmarks: {
      return &BookmarksPageHandler::RemoveBookmarks_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kSetSortOrder: {
      return &BookmarksPageHandler::SetSortOrder_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kSetViewType: {
      return &BookmarksPageHandler::SetViewType_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kShowContextMenu: {
      return &BookmarksPageHandler::ShowContextMenu_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kShowUI: {
      return &BookmarksPageHandler::ShowUI_Sym::IPCStableHash;
    }
    case messages::BookmarksPageHandler::kGetAllBookmarks: {
      return &BookmarksPageHandler::GetAllBookmarks_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BookmarksPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BookmarksPageHandler>(message.name())) {
      case messages::BookmarksPageHandler::kBookmarkCurrentTabInFolder:
            return "Receive side_panel::mojom::BookmarksPageHandler::BookmarkCurrentTabInFolder";
      case messages::BookmarksPageHandler::kCreateFolder:
            return "Receive side_panel::mojom::BookmarksPageHandler::CreateFolder";
      case messages::BookmarksPageHandler::kDropBookmarks:
            return "Receive side_panel::mojom::BookmarksPageHandler::DropBookmarks";
      case messages::BookmarksPageHandler::kExecuteEditCommand:
            return "Receive side_panel::mojom::BookmarksPageHandler::ExecuteEditCommand";
      case messages::BookmarksPageHandler::kExecuteMoveCommand:
            return "Receive side_panel::mojom::BookmarksPageHandler::ExecuteMoveCommand";
      case messages::BookmarksPageHandler::kExecuteOpenInNewTabCommand:
            return "Receive side_panel::mojom::BookmarksPageHandler::ExecuteOpenInNewTabCommand";
      case messages::BookmarksPageHandler::kExecuteOpenInNewWindowCommand:
            return "Receive side_panel::mojom::BookmarksPageHandler::ExecuteOpenInNewWindowCommand";
      case messages::BookmarksPageHandler::kExecuteOpenInIncognitoWindowCommand:
            return "Receive side_panel::mojom::BookmarksPageHandler::ExecuteOpenInIncognitoWindowCommand";
      case messages::BookmarksPageHandler::kExecuteOpenInNewTabGroupCommand:
            return "Receive side_panel::mojom::BookmarksPageHandler::ExecuteOpenInNewTabGroupCommand";
      case messages::BookmarksPageHandler::kExecuteOpenInSplitViewCommand:
            return "Receive side_panel::mojom::BookmarksPageHandler::ExecuteOpenInSplitViewCommand";
      case messages::BookmarksPageHandler::kExecuteAddToBookmarksBarCommand:
            return "Receive side_panel::mojom::BookmarksPageHandler::ExecuteAddToBookmarksBarCommand";
      case messages::BookmarksPageHandler::kExecuteRemoveFromBookmarksBarCommand:
            return "Receive side_panel::mojom::BookmarksPageHandler::ExecuteRemoveFromBookmarksBarCommand";
      case messages::BookmarksPageHandler::kExecuteDeleteCommand:
            return "Receive side_panel::mojom::BookmarksPageHandler::ExecuteDeleteCommand";
      case messages::BookmarksPageHandler::kOpenBookmark:
            return "Receive side_panel::mojom::BookmarksPageHandler::OpenBookmark";
      case messages::BookmarksPageHandler::kUndo:
            return "Receive side_panel::mojom::BookmarksPageHandler::Undo";
      case messages::BookmarksPageHandler::kRenameBookmark:
            return "Receive side_panel::mojom::BookmarksPageHandler::RenameBookmark";
      case messages::BookmarksPageHandler::kMoveBookmark:
            return "Receive side_panel::mojom::BookmarksPageHandler::MoveBookmark";
      case messages::BookmarksPageHandler::kRemoveBookmarks:
            return "Receive side_panel::mojom::BookmarksPageHandler::RemoveBookmarks";
      case messages::BookmarksPageHandler::kSetSortOrder:
            return "Receive side_panel::mojom::BookmarksPageHandler::SetSortOrder";
      case messages::BookmarksPageHandler::kSetViewType:
            return "Receive side_panel::mojom::BookmarksPageHandler::SetViewType";
      case messages::BookmarksPageHandler::kShowContextMenu:
            return "Receive side_panel::mojom::BookmarksPageHandler::ShowContextMenu";
      case messages::BookmarksPageHandler::kShowUI:
            return "Receive side_panel::mojom::BookmarksPageHandler::ShowUI";
      case messages::BookmarksPageHandler::kGetAllBookmarks:
            return "Receive side_panel::mojom::BookmarksPageHandler::GetAllBookmarks";
    }
  } else {
    switch (static_cast<messages::BookmarksPageHandler>(message.name())) {
      case messages::BookmarksPageHandler::kBookmarkCurrentTabInFolder:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::BookmarkCurrentTabInFolder";
      case messages::BookmarksPageHandler::kCreateFolder:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::CreateFolder";
      case messages::BookmarksPageHandler::kDropBookmarks:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::DropBookmarks";
      case messages::BookmarksPageHandler::kExecuteEditCommand:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::ExecuteEditCommand";
      case messages::BookmarksPageHandler::kExecuteMoveCommand:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::ExecuteMoveCommand";
      case messages::BookmarksPageHandler::kExecuteOpenInNewTabCommand:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::ExecuteOpenInNewTabCommand";
      case messages::BookmarksPageHandler::kExecuteOpenInNewWindowCommand:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::ExecuteOpenInNewWindowCommand";
      case messages::BookmarksPageHandler::kExecuteOpenInIncognitoWindowCommand:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::ExecuteOpenInIncognitoWindowCommand";
      case messages::BookmarksPageHandler::kExecuteOpenInNewTabGroupCommand:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::ExecuteOpenInNewTabGroupCommand";
      case messages::BookmarksPageHandler::kExecuteOpenInSplitViewCommand:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::ExecuteOpenInSplitViewCommand";
      case messages::BookmarksPageHandler::kExecuteAddToBookmarksBarCommand:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::ExecuteAddToBookmarksBarCommand";
      case messages::BookmarksPageHandler::kExecuteRemoveFromBookmarksBarCommand:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::ExecuteRemoveFromBookmarksBarCommand";
      case messages::BookmarksPageHandler::kExecuteDeleteCommand:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::ExecuteDeleteCommand";
      case messages::BookmarksPageHandler::kOpenBookmark:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::OpenBookmark";
      case messages::BookmarksPageHandler::kUndo:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::Undo";
      case messages::BookmarksPageHandler::kRenameBookmark:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::RenameBookmark";
      case messages::BookmarksPageHandler::kMoveBookmark:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::MoveBookmark";
      case messages::BookmarksPageHandler::kRemoveBookmarks:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::RemoveBookmarks";
      case messages::BookmarksPageHandler::kSetSortOrder:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::SetSortOrder";
      case messages::BookmarksPageHandler::kSetViewType:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::SetViewType";
      case messages::BookmarksPageHandler::kShowContextMenu:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::ShowContextMenu";
      case messages::BookmarksPageHandler::kShowUI:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::ShowUI";
      case messages::BookmarksPageHandler::kGetAllBookmarks:
            return "Receive reply side_panel::mojom::BookmarksPageHandler::GetAllBookmarks";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BookmarksPageHandler::BookmarkCurrentTabInFolder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x08831b64;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::BookmarkCurrentTabInFolder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::CreateFolder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9cc9533a;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::CreateFolder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::DropBookmarks_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x682617aa;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::DropBookmarks
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::ExecuteEditCommand_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0b6d3889;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::ExecuteEditCommand
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::ExecuteMoveCommand_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1c1992f0;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::ExecuteMoveCommand
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::ExecuteOpenInNewTabCommand_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfd5962c6;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::ExecuteOpenInNewTabCommand
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::ExecuteOpenInNewWindowCommand_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4f5e3945;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::ExecuteOpenInNewWindowCommand
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::ExecuteOpenInIncognitoWindowCommand_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7543b2fc;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::ExecuteOpenInIncognitoWindowCommand
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::ExecuteOpenInNewTabGroupCommand_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfb2f31e5;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::ExecuteOpenInNewTabGroupCommand
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::ExecuteOpenInSplitViewCommand_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1d931590;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::ExecuteOpenInSplitViewCommand
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::ExecuteAddToBookmarksBarCommand_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4000452d;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::ExecuteAddToBookmarksBarCommand
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::ExecuteRemoveFromBookmarksBarCommand_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf3a7d361;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::ExecuteRemoveFromBookmarksBarCommand
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::ExecuteDeleteCommand_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x988bc0be;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::ExecuteDeleteCommand
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::OpenBookmark_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x31cdf350;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::OpenBookmark
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::Undo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xab362e97;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::Undo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::RenameBookmark_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1f415cd1;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::RenameBookmark
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::MoveBookmark_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5ded7e30;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::MoveBookmark
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::RemoveBookmarks_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x98ab3f8b;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::RemoveBookmarks
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::SetSortOrder_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfa261610;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::SetSortOrder
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::SetViewType_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x39d9d659;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::SetViewType
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::ShowContextMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdfc6330d;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::ShowContextMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::ShowUI_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7630c65a;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::ShowUI
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPageHandler::GetAllBookmarks_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3aeea741;  // IPCStableHash for side_panel::mojom::BookmarksPageHandler::GetAllBookmarks
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BookmarksPageHandler_CreateFolder_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BookmarksPageHandler_CreateFolder_ForwardToCallback(
      BookmarksPageHandler::CreateFolderCallback callback
      ) : callback_(std::move(callback)) {
  }

  BookmarksPageHandler_CreateFolder_ForwardToCallback(const BookmarksPageHandler_CreateFolder_ForwardToCallback&) = delete;
  BookmarksPageHandler_CreateFolder_ForwardToCallback& operator=(const BookmarksPageHandler_CreateFolder_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BookmarksPageHandler::CreateFolderCallback callback_;
};

class BookmarksPageHandler_DropBookmarks_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BookmarksPageHandler_DropBookmarks_ForwardToCallback(
      BookmarksPageHandler::DropBookmarksCallback callback
      ) : callback_(std::move(callback)) {
  }

  BookmarksPageHandler_DropBookmarks_ForwardToCallback(const BookmarksPageHandler_DropBookmarks_ForwardToCallback&) = delete;
  BookmarksPageHandler_DropBookmarks_ForwardToCallback& operator=(const BookmarksPageHandler_DropBookmarks_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BookmarksPageHandler::DropBookmarksCallback callback_;
};

class BookmarksPageHandler_RemoveBookmarks_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BookmarksPageHandler_RemoveBookmarks_ForwardToCallback(
      BookmarksPageHandler::RemoveBookmarksCallback callback
      ) : callback_(std::move(callback)) {
  }

  BookmarksPageHandler_RemoveBookmarks_ForwardToCallback(const BookmarksPageHandler_RemoveBookmarks_ForwardToCallback&) = delete;
  BookmarksPageHandler_RemoveBookmarks_ForwardToCallback& operator=(const BookmarksPageHandler_RemoveBookmarks_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BookmarksPageHandler::RemoveBookmarksCallback callback_;
};

class BookmarksPageHandler_GetAllBookmarks_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BookmarksPageHandler_GetAllBookmarks_ForwardToCallback(
      BookmarksPageHandler::GetAllBookmarksCallback callback
      ) : callback_(std::move(callback)) {
  }

  BookmarksPageHandler_GetAllBookmarks_ForwardToCallback(const BookmarksPageHandler_GetAllBookmarks_ForwardToCallback&) = delete;
  BookmarksPageHandler_GetAllBookmarks_ForwardToCallback& operator=(const BookmarksPageHandler_GetAllBookmarks_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BookmarksPageHandler::GetAllBookmarksCallback callback_;
};

BookmarksPageHandlerProxy::BookmarksPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BookmarksPageHandlerProxy::BookmarkCurrentTabInFolder(
    const std::string& in_folder_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::BookmarkCurrentTabInFolder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("folder_id"), in_folder_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kBookmarkCurrentTabInFolder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_BookmarkCurrentTabInFolder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->folder_id)::BaseType> folder_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_folder_id,
    folder_id_fragment);

  params->folder_id.Set(
      folder_id_fragment.is_null() ? nullptr : folder_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->folder_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null folder_id in BookmarksPageHandler.BookmarkCurrentTabInFolder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("BookmarkCurrentTabInFolder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::CreateFolder(
    const std::string& in_folder_id, const std::string& in_title, CreateFolderCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::CreateFolder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("folder_id"), in_folder_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("title"), in_title,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kCreateFolder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_CreateFolder_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->folder_id)::BaseType> folder_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_folder_id,
    folder_id_fragment);

  params->folder_id.Set(
      folder_id_fragment.is_null() ? nullptr : folder_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->folder_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null folder_id in BookmarksPageHandler.CreateFolder request");
  mojo::internal::MessageFragment<
      typename decltype(params->title)::BaseType> title_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_title,
    title_fragment);

  params->title.Set(
      title_fragment.is_null() ? nullptr : title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null title in BookmarksPageHandler.CreateFolder request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("CreateFolder");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BookmarksPageHandler_CreateFolder_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BookmarksPageHandlerProxy::DropBookmarks(
    const std::string& in_folder_id, DropBookmarksCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::DropBookmarks", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("folder_id"), in_folder_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kDropBookmarks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_DropBookmarks_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->folder_id)::BaseType> folder_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_folder_id,
    folder_id_fragment);

  params->folder_id.Set(
      folder_id_fragment.is_null() ? nullptr : folder_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->folder_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null folder_id in BookmarksPageHandler.DropBookmarks request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("DropBookmarks");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BookmarksPageHandler_DropBookmarks_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BookmarksPageHandlerProxy::ExecuteEditCommand(
    const std::vector<int64_t>& in_node_ids, ActionSource in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::ExecuteEditCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_ids"), in_node_ids,
                        "<value of type const std::vector<int64_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ActionSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kExecuteEditCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_ExecuteEditCommand_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->node_ids)::BaseType>
      node_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
    in_node_ids,
    node_ids_fragment,
    &node_ids_validate_params);

  params->node_ids.Set(
      node_ids_fragment.is_null() ? nullptr : node_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->node_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null node_ids in BookmarksPageHandler.ExecuteEditCommand request");

  
  mojo::internal::Serialize<::side_panel::mojom::ActionSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("ExecuteEditCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::ExecuteMoveCommand(
    const std::vector<int64_t>& in_node_ids, ActionSource in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::ExecuteMoveCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_ids"), in_node_ids,
                        "<value of type const std::vector<int64_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ActionSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kExecuteMoveCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_ExecuteMoveCommand_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->node_ids)::BaseType>
      node_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
    in_node_ids,
    node_ids_fragment,
    &node_ids_validate_params);

  params->node_ids.Set(
      node_ids_fragment.is_null() ? nullptr : node_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->node_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null node_ids in BookmarksPageHandler.ExecuteMoveCommand request");

  
  mojo::internal::Serialize<::side_panel::mojom::ActionSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("ExecuteMoveCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::ExecuteOpenInNewTabCommand(
    const std::vector<std::string>& in_side_panel_ids, ActionSource in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::ExecuteOpenInNewTabCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("side_panel_ids"), in_side_panel_ids,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ActionSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kExecuteOpenInNewTabCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_ExecuteOpenInNewTabCommand_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->side_panel_ids)::BaseType>
      side_panel_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& side_panel_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_side_panel_ids,
    side_panel_ids_fragment,
    &side_panel_ids_validate_params);

  params->side_panel_ids.Set(
      side_panel_ids_fragment.is_null() ? nullptr : side_panel_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->side_panel_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null side_panel_ids in BookmarksPageHandler.ExecuteOpenInNewTabCommand request");

  
  mojo::internal::Serialize<::side_panel::mojom::ActionSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("ExecuteOpenInNewTabCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::ExecuteOpenInNewWindowCommand(
    const std::vector<std::string>& in_side_panel_ids, ActionSource in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::ExecuteOpenInNewWindowCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("side_panel_ids"), in_side_panel_ids,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ActionSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kExecuteOpenInNewWindowCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_ExecuteOpenInNewWindowCommand_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->side_panel_ids)::BaseType>
      side_panel_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& side_panel_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_side_panel_ids,
    side_panel_ids_fragment,
    &side_panel_ids_validate_params);

  params->side_panel_ids.Set(
      side_panel_ids_fragment.is_null() ? nullptr : side_panel_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->side_panel_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null side_panel_ids in BookmarksPageHandler.ExecuteOpenInNewWindowCommand request");

  
  mojo::internal::Serialize<::side_panel::mojom::ActionSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("ExecuteOpenInNewWindowCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::ExecuteOpenInIncognitoWindowCommand(
    const std::vector<std::string>& in_side_panel_ids, ActionSource in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::ExecuteOpenInIncognitoWindowCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("side_panel_ids"), in_side_panel_ids,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ActionSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kExecuteOpenInIncognitoWindowCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->side_panel_ids)::BaseType>
      side_panel_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& side_panel_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_side_panel_ids,
    side_panel_ids_fragment,
    &side_panel_ids_validate_params);

  params->side_panel_ids.Set(
      side_panel_ids_fragment.is_null() ? nullptr : side_panel_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->side_panel_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null side_panel_ids in BookmarksPageHandler.ExecuteOpenInIncognitoWindowCommand request");

  
  mojo::internal::Serialize<::side_panel::mojom::ActionSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("ExecuteOpenInIncognitoWindowCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::ExecuteOpenInNewTabGroupCommand(
    const std::vector<std::string>& in_side_panel_ids, ActionSource in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::ExecuteOpenInNewTabGroupCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("side_panel_ids"), in_side_panel_ids,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ActionSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kExecuteOpenInNewTabGroupCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->side_panel_ids)::BaseType>
      side_panel_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& side_panel_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_side_panel_ids,
    side_panel_ids_fragment,
    &side_panel_ids_validate_params);

  params->side_panel_ids.Set(
      side_panel_ids_fragment.is_null() ? nullptr : side_panel_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->side_panel_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null side_panel_ids in BookmarksPageHandler.ExecuteOpenInNewTabGroupCommand request");

  
  mojo::internal::Serialize<::side_panel::mojom::ActionSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("ExecuteOpenInNewTabGroupCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::ExecuteOpenInSplitViewCommand(
    const std::vector<int64_t>& in_node_ids, ActionSource in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::ExecuteOpenInSplitViewCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_ids"), in_node_ids,
                        "<value of type const std::vector<int64_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ActionSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kExecuteOpenInSplitViewCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_ExecuteOpenInSplitViewCommand_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->node_ids)::BaseType>
      node_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
    in_node_ids,
    node_ids_fragment,
    &node_ids_validate_params);

  params->node_ids.Set(
      node_ids_fragment.is_null() ? nullptr : node_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->node_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null node_ids in BookmarksPageHandler.ExecuteOpenInSplitViewCommand request");

  
  mojo::internal::Serialize<::side_panel::mojom::ActionSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("ExecuteOpenInSplitViewCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::ExecuteAddToBookmarksBarCommand(
    int64_t in_node_id, ActionSource in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::ExecuteAddToBookmarksBarCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_id"), in_node_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ActionSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kExecuteAddToBookmarksBarCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_Params_Data> params(
          message);
  params.Allocate();

  params->node_id = in_node_id;

  
  mojo::internal::Serialize<::side_panel::mojom::ActionSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("ExecuteAddToBookmarksBarCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::ExecuteRemoveFromBookmarksBarCommand(
    int64_t in_node_id, ActionSource in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::ExecuteRemoveFromBookmarksBarCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_id"), in_node_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ActionSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kExecuteRemoveFromBookmarksBarCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_Params_Data> params(
          message);
  params.Allocate();

  params->node_id = in_node_id;

  
  mojo::internal::Serialize<::side_panel::mojom::ActionSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("ExecuteRemoveFromBookmarksBarCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::ExecuteDeleteCommand(
    const std::vector<int64_t>& in_node_ids, ActionSource in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::ExecuteDeleteCommand", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_ids"), in_node_ids,
                        "<value of type const std::vector<int64_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ActionSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kExecuteDeleteCommand), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_ExecuteDeleteCommand_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->node_ids)::BaseType>
      node_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
    in_node_ids,
    node_ids_fragment,
    &node_ids_validate_params);

  params->node_ids.Set(
      node_ids_fragment.is_null() ? nullptr : node_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->node_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null node_ids in BookmarksPageHandler.ExecuteDeleteCommand request");

  
  mojo::internal::Serialize<::side_panel::mojom::ActionSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("ExecuteDeleteCommand");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::OpenBookmark(
    int64_t in_node_id, int32_t in_parent_folder_depth, ::ui::mojom::ClickModifiersPtr in_click_modifiers, ActionSource in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::OpenBookmark", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_id"), in_node_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parent_folder_depth"), in_parent_folder_depth,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("click_modifiers"), in_click_modifiers,
                        "<value of type ::ui::mojom::ClickModifiersPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ActionSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kOpenBookmark), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_OpenBookmark_Params_Data> params(
          message);
  params.Allocate();

  params->node_id = in_node_id;

  params->parent_folder_depth = in_parent_folder_depth;
  mojo::internal::MessageFragment<
      typename decltype(params->click_modifiers)::BaseType> click_modifiers_fragment(
          params.message());
  
  mojo::internal::Serialize<::ui::mojom::ClickModifiersDataView>(
    in_click_modifiers,
    click_modifiers_fragment);

  params->click_modifiers.Set(
      click_modifiers_fragment.is_null() ? nullptr : click_modifiers_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->click_modifiers.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null click_modifiers in BookmarksPageHandler.OpenBookmark request");

  
  mojo::internal::Serialize<::side_panel::mojom::ActionSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("OpenBookmark");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::Undo(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::BookmarksPageHandler::Undo");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kUndo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_Undo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("Undo");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::RenameBookmark(
    int64_t in_node_id, const std::string& in_new_title) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::RenameBookmark", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_id"), in_node_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_title"), in_new_title,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kRenameBookmark), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_RenameBookmark_Params_Data> params(
          message);
  params.Allocate();

  params->node_id = in_node_id;
  mojo::internal::MessageFragment<
      typename decltype(params->new_title)::BaseType> new_title_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_new_title,
    new_title_fragment);

  params->new_title.Set(
      new_title_fragment.is_null() ? nullptr : new_title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_title in BookmarksPageHandler.RenameBookmark request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("RenameBookmark");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::MoveBookmark(
    int64_t in_node_id, const std::string& in_folder_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::MoveBookmark", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_id"), in_node_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("folder_id"), in_folder_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kMoveBookmark), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_MoveBookmark_Params_Data> params(
          message);
  params.Allocate();

  params->node_id = in_node_id;
  mojo::internal::MessageFragment<
      typename decltype(params->folder_id)::BaseType> folder_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_folder_id,
    folder_id_fragment);

  params->folder_id.Set(
      folder_id_fragment.is_null() ? nullptr : folder_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->folder_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null folder_id in BookmarksPageHandler.MoveBookmark request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("MoveBookmark");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::RemoveBookmarks(
    const std::vector<int64_t>& in_node_ids, RemoveBookmarksCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::RemoveBookmarks", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_ids"), in_node_ids,
                        "<value of type const std::vector<int64_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kRemoveBookmarks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_RemoveBookmarks_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->node_ids)::BaseType>
      node_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
    in_node_ids,
    node_ids_fragment,
    &node_ids_validate_params);

  params->node_ids.Set(
      node_ids_fragment.is_null() ? nullptr : node_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->node_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null node_ids in BookmarksPageHandler.RemoveBookmarks request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("RemoveBookmarks");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BookmarksPageHandler_RemoveBookmarks_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BookmarksPageHandlerProxy::SetSortOrder(
    SortOrder in_sort_order) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::SetSortOrder", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sort_order"), in_sort_order,
                        "<value of type SortOrder>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kSetSortOrder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_SetSortOrder_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::side_panel::mojom::SortOrder>(
    in_sort_order,
    &params->sort_order);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("SetSortOrder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::SetViewType(
    ViewType in_view_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::SetViewType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_type"), in_view_type,
                        "<value of type ViewType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kSetViewType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_SetViewType_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::side_panel::mojom::ViewType>(
    in_view_type,
    &params->view_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("SetViewType");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::ShowContextMenu(
    const std::string& in_id, const ::gfx::Point& in_point, ActionSource in_source) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPageHandler::ShowContextMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point"), in_point,
                        "<value of type const ::gfx::Point&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ActionSource>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kShowContextMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_ShowContextMenu_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in BookmarksPageHandler.ShowContextMenu request");
  mojo::internal::MessageFragment<
      typename decltype(params->point)::BaseType> point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_point,
    point_fragment);

  params->point.Set(
      point_fragment.is_null() ? nullptr : point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null point in BookmarksPageHandler.ShowContextMenu request");

  
  mojo::internal::Serialize<::side_panel::mojom::ActionSource>(
    in_source,
    &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("ShowContextMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::ShowUI(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::BookmarksPageHandler::ShowUI");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kShowUI), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_ShowUI_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("ShowUI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageHandlerProxy::GetAllBookmarks(
    GetAllBookmarksCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::mojom::BookmarksPageHandler::GetAllBookmarks");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kGetAllBookmarks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_GetAllBookmarks_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("GetAllBookmarks");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BookmarksPageHandler_GetAllBookmarks_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BookmarksPageHandler_CreateFolder_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BookmarksPageHandler::CreateFolderCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BookmarksPageHandler_CreateFolder_ProxyToResponder> proxy(
        new BookmarksPageHandler_CreateFolder_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BookmarksPageHandler_CreateFolder_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BookmarksPageHandler_CreateFolder_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BookmarksPageHandler_CreateFolder_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BookmarksPageHandler::CreateFolderCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_new_folder_id);
};

bool BookmarksPageHandler_CreateFolder_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BookmarksPageHandler_CreateFolder_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BookmarksPageHandler_CreateFolder_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BookmarksPageHandler.1
  bool success = true;
  std::string p_new_folder_id{};
  BookmarksPageHandler_CreateFolder_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadNewFolderId(&p_new_folder_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BookmarksPageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_new_folder_id));
  }
  return true;
}

void BookmarksPageHandler_CreateFolder_ProxyToResponder::Run(
    const std::string& in_new_folder_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply side_panel::mojom::BookmarksPageHandler::CreateFolder", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_folder_id"), in_new_folder_id,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kCreateFolder), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_CreateFolder_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->new_folder_id)::BaseType> new_folder_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_new_folder_id,
    new_folder_id_fragment);

  params->new_folder_id.Set(
      new_folder_id_fragment.is_null() ? nullptr : new_folder_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_folder_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_folder_id in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("CreateFolder");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BookmarksPageHandler_DropBookmarks_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BookmarksPageHandler::DropBookmarksCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BookmarksPageHandler_DropBookmarks_ProxyToResponder> proxy(
        new BookmarksPageHandler_DropBookmarks_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BookmarksPageHandler_DropBookmarks_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BookmarksPageHandler_DropBookmarks_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BookmarksPageHandler_DropBookmarks_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BookmarksPageHandler::DropBookmarksCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool BookmarksPageHandler_DropBookmarks_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BookmarksPageHandler_DropBookmarks_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BookmarksPageHandler_DropBookmarks_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BookmarksPageHandler.2
  bool success = true;
  BookmarksPageHandler_DropBookmarks_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BookmarksPageHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void BookmarksPageHandler_DropBookmarks_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply side_panel::mojom::BookmarksPageHandler::DropBookmarks");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kDropBookmarks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_DropBookmarks_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("DropBookmarks");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BookmarksPageHandler_RemoveBookmarks_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BookmarksPageHandler::RemoveBookmarksCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BookmarksPageHandler_RemoveBookmarks_ProxyToResponder> proxy(
        new BookmarksPageHandler_RemoveBookmarks_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BookmarksPageHandler_RemoveBookmarks_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BookmarksPageHandler_RemoveBookmarks_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BookmarksPageHandler_RemoveBookmarks_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BookmarksPageHandler::RemoveBookmarksCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool BookmarksPageHandler_RemoveBookmarks_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BookmarksPageHandler_RemoveBookmarks_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BookmarksPageHandler_RemoveBookmarks_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BookmarksPageHandler.17
  bool success = true;
  BookmarksPageHandler_RemoveBookmarks_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BookmarksPageHandler::Name_, 17, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void BookmarksPageHandler_RemoveBookmarks_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply side_panel::mojom::BookmarksPageHandler::RemoveBookmarks");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kRemoveBookmarks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_RemoveBookmarks_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("RemoveBookmarks");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BookmarksPageHandler_GetAllBookmarks_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BookmarksPageHandler::GetAllBookmarksCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BookmarksPageHandler_GetAllBookmarks_ProxyToResponder> proxy(
        new BookmarksPageHandler_GetAllBookmarks_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BookmarksPageHandler_GetAllBookmarks_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BookmarksPageHandler_GetAllBookmarks_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BookmarksPageHandler_GetAllBookmarks_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BookmarksPageHandler::GetAllBookmarksCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<BookmarksTreeNodePtr> in_nodes);
};

bool BookmarksPageHandler_GetAllBookmarks_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BookmarksPageHandler_GetAllBookmarks_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BookmarksPageHandler_GetAllBookmarks_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BookmarksPageHandler.22
  bool success = true;
  std::vector<BookmarksTreeNodePtr> p_nodes{};
  BookmarksPageHandler_GetAllBookmarks_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadNodes(&p_nodes))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BookmarksPageHandler::Name_, 22, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_nodes));
  }
  return true;
}

void BookmarksPageHandler_GetAllBookmarks_ProxyToResponder::Run(
    std::vector<BookmarksTreeNodePtr> in_nodes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply side_panel::mojom::BookmarksPageHandler::GetAllBookmarks", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("nodes"), in_nodes,
                        "<value of type std::vector<BookmarksTreeNodePtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPageHandler::kGetAllBookmarks), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPageHandler_GetAllBookmarks_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->nodes)::BaseType>
      nodes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& nodes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::side_panel::mojom::BookmarksTreeNodeDataView>>(
    in_nodes,
    nodes_fragment,
    &nodes_validate_params);

  params->nodes.Set(
      nodes_fragment.is_null() ? nullptr : nodes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->nodes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null nodes in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPageHandler::Name_);
  message.set_method_name("GetAllBookmarks");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BookmarksPageHandlerStubDispatch::Accept(
    BookmarksPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BookmarksPageHandler>(message->header()->name)) {
    case messages::BookmarksPageHandler::kBookmarkCurrentTabInFolder: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_BookmarkCurrentTabInFolder_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_BookmarkCurrentTabInFolder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.0
      bool success = true;
      std::string p_folder_id{};
      BookmarksPageHandler_BookmarkCurrentTabInFolder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFolderId(&p_folder_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BookmarkCurrentTabInFolder(        
        std::move(p_folder_id));
      return true;
    }
    case messages::BookmarksPageHandler::kCreateFolder: {
      break;
    }
    case messages::BookmarksPageHandler::kDropBookmarks: {
      break;
    }
    case messages::BookmarksPageHandler::kExecuteEditCommand: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_ExecuteEditCommand_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_ExecuteEditCommand_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.3
      bool success = true;
      std::vector<int64_t> p_node_ids{};
      ActionSource p_source{};
      BookmarksPageHandler_ExecuteEditCommand_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNodeIds(&p_node_ids))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteEditCommand(        
        std::move(p_node_ids), 
        std::move(p_source));
      return true;
    }
    case messages::BookmarksPageHandler::kExecuteMoveCommand: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_ExecuteMoveCommand_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_ExecuteMoveCommand_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.4
      bool success = true;
      std::vector<int64_t> p_node_ids{};
      ActionSource p_source{};
      BookmarksPageHandler_ExecuteMoveCommand_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNodeIds(&p_node_ids))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteMoveCommand(        
        std::move(p_node_ids), 
        std::move(p_source));
      return true;
    }
    case messages::BookmarksPageHandler::kExecuteOpenInNewTabCommand: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_ExecuteOpenInNewTabCommand_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_ExecuteOpenInNewTabCommand_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.5
      bool success = true;
      std::vector<std::string> p_side_panel_ids{};
      ActionSource p_source{};
      BookmarksPageHandler_ExecuteOpenInNewTabCommand_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSidePanelIds(&p_side_panel_ids))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteOpenInNewTabCommand(        
        std::move(p_side_panel_ids), 
        std::move(p_source));
      return true;
    }
    case messages::BookmarksPageHandler::kExecuteOpenInNewWindowCommand: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_ExecuteOpenInNewWindowCommand_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_ExecuteOpenInNewWindowCommand_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.6
      bool success = true;
      std::vector<std::string> p_side_panel_ids{};
      ActionSource p_source{};
      BookmarksPageHandler_ExecuteOpenInNewWindowCommand_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSidePanelIds(&p_side_panel_ids))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteOpenInNewWindowCommand(        
        std::move(p_side_panel_ids), 
        std::move(p_source));
      return true;
    }
    case messages::BookmarksPageHandler::kExecuteOpenInIncognitoWindowCommand: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.7
      bool success = true;
      std::vector<std::string> p_side_panel_ids{};
      ActionSource p_source{};
      BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSidePanelIds(&p_side_panel_ids))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteOpenInIncognitoWindowCommand(        
        std::move(p_side_panel_ids), 
        std::move(p_source));
      return true;
    }
    case messages::BookmarksPageHandler::kExecuteOpenInNewTabGroupCommand: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.8
      bool success = true;
      std::vector<std::string> p_side_panel_ids{};
      ActionSource p_source{};
      BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSidePanelIds(&p_side_panel_ids))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteOpenInNewTabGroupCommand(        
        std::move(p_side_panel_ids), 
        std::move(p_source));
      return true;
    }
    case messages::BookmarksPageHandler::kExecuteOpenInSplitViewCommand: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_ExecuteOpenInSplitViewCommand_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_ExecuteOpenInSplitViewCommand_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.9
      bool success = true;
      std::vector<int64_t> p_node_ids{};
      ActionSource p_source{};
      BookmarksPageHandler_ExecuteOpenInSplitViewCommand_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNodeIds(&p_node_ids))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteOpenInSplitViewCommand(        
        std::move(p_node_ids), 
        std::move(p_source));
      return true;
    }
    case messages::BookmarksPageHandler::kExecuteAddToBookmarksBarCommand: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.10
      bool success = true;
      int64_t p_node_id{};
      ActionSource p_source{};
      BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_node_id = input_data_view.node_id();
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteAddToBookmarksBarCommand(        
        std::move(p_node_id), 
        std::move(p_source));
      return true;
    }
    case messages::BookmarksPageHandler::kExecuteRemoveFromBookmarksBarCommand: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.11
      bool success = true;
      int64_t p_node_id{};
      ActionSource p_source{};
      BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_node_id = input_data_view.node_id();
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteRemoveFromBookmarksBarCommand(        
        std::move(p_node_id), 
        std::move(p_source));
      return true;
    }
    case messages::BookmarksPageHandler::kExecuteDeleteCommand: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_ExecuteDeleteCommand_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_ExecuteDeleteCommand_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.12
      bool success = true;
      std::vector<int64_t> p_node_ids{};
      ActionSource p_source{};
      BookmarksPageHandler_ExecuteDeleteCommand_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNodeIds(&p_node_ids))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExecuteDeleteCommand(        
        std::move(p_node_ids), 
        std::move(p_source));
      return true;
    }
    case messages::BookmarksPageHandler::kOpenBookmark: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_OpenBookmark_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_OpenBookmark_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.13
      bool success = true;
      int64_t p_node_id{};
      int32_t p_parent_folder_depth{};
      ::ui::mojom::ClickModifiersPtr p_click_modifiers{};
      ActionSource p_source{};
      BookmarksPageHandler_OpenBookmark_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_node_id = input_data_view.node_id();
      if (success)
        p_parent_folder_depth = input_data_view.parent_folder_depth();
      if (success && !input_data_view.ReadClickModifiers(&p_click_modifiers))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenBookmark(        
        std::move(p_node_id), 
        std::move(p_parent_folder_depth), 
        std::move(p_click_modifiers), 
        std::move(p_source));
      return true;
    }
    case messages::BookmarksPageHandler::kUndo: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_Undo_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_Undo_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.14
      bool success = true;
      BookmarksPageHandler_Undo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Undo(        );
      return true;
    }
    case messages::BookmarksPageHandler::kRenameBookmark: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_RenameBookmark_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_RenameBookmark_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.15
      bool success = true;
      int64_t p_node_id{};
      std::string p_new_title{};
      BookmarksPageHandler_RenameBookmark_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_node_id = input_data_view.node_id();
      if (success && !input_data_view.ReadNewTitle(&p_new_title))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenameBookmark(        
        std::move(p_node_id), 
        std::move(p_new_title));
      return true;
    }
    case messages::BookmarksPageHandler::kMoveBookmark: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_MoveBookmark_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_MoveBookmark_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.16
      bool success = true;
      int64_t p_node_id{};
      std::string p_folder_id{};
      BookmarksPageHandler_MoveBookmark_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_node_id = input_data_view.node_id();
      if (success && !input_data_view.ReadFolderId(&p_folder_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MoveBookmark(        
        std::move(p_node_id), 
        std::move(p_folder_id));
      return true;
    }
    case messages::BookmarksPageHandler::kRemoveBookmarks: {
      break;
    }
    case messages::BookmarksPageHandler::kSetSortOrder: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_SetSortOrder_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_SetSortOrder_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.18
      bool success = true;
      SortOrder p_sort_order{};
      BookmarksPageHandler_SetSortOrder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSortOrder(&p_sort_order))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSortOrder(        
        std::move(p_sort_order));
      return true;
    }
    case messages::BookmarksPageHandler::kSetViewType: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_SetViewType_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_SetViewType_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.19
      bool success = true;
      ViewType p_view_type{};
      BookmarksPageHandler_SetViewType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadViewType(&p_view_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetViewType(        
        std::move(p_view_type));
      return true;
    }
    case messages::BookmarksPageHandler::kShowContextMenu: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_ShowContextMenu_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_ShowContextMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.20
      bool success = true;
      std::string p_id{};
      ::gfx::Point p_point{};
      ActionSource p_source{};
      BookmarksPageHandler_ShowContextMenu_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowContextMenu(        
        std::move(p_id), 
        std::move(p_point), 
        std::move(p_source));
      return true;
    }
    case messages::BookmarksPageHandler::kShowUI: {
      DCHECK(message->is_serialized());
      internal::BookmarksPageHandler_ShowUI_Params_Data* params =
          reinterpret_cast<internal::BookmarksPageHandler_ShowUI_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPageHandler.21
      bool success = true;
      BookmarksPageHandler_ShowUI_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowUI(        );
      return true;
    }
    case messages::BookmarksPageHandler::kGetAllBookmarks: {
      break;
    }
  }
  return false;
}

// static
bool BookmarksPageHandlerStubDispatch::AcceptWithResponder(
    BookmarksPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BookmarksPageHandler>(message->header()->name)) {
    case messages::BookmarksPageHandler::kBookmarkCurrentTabInFolder: {
      break;
    }
    case messages::BookmarksPageHandler::kCreateFolder: {
      internal::BookmarksPageHandler_CreateFolder_Params_Data* params =
          reinterpret_cast<
              internal::BookmarksPageHandler_CreateFolder_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BookmarksPageHandler.1
      bool success = true;
      std::string p_folder_id{};
      std::string p_title{};
      BookmarksPageHandler_CreateFolder_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFolderId(&p_folder_id))
        success = false;
      if (success && !input_data_view.ReadTitle(&p_title))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          BookmarksPageHandler_CreateFolder_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateFolder(        
        std::move(p_folder_id), 
        std::move(p_title), std::move(callback));
      return true;
    }
    case messages::BookmarksPageHandler::kDropBookmarks: {
      internal::BookmarksPageHandler_DropBookmarks_Params_Data* params =
          reinterpret_cast<
              internal::BookmarksPageHandler_DropBookmarks_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BookmarksPageHandler.2
      bool success = true;
      std::string p_folder_id{};
      BookmarksPageHandler_DropBookmarks_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFolderId(&p_folder_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          BookmarksPageHandler_DropBookmarks_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DropBookmarks(        
        std::move(p_folder_id), std::move(callback));
      return true;
    }
    case messages::BookmarksPageHandler::kExecuteEditCommand: {
      break;
    }
    case messages::BookmarksPageHandler::kExecuteMoveCommand: {
      break;
    }
    case messages::BookmarksPageHandler::kExecuteOpenInNewTabCommand: {
      break;
    }
    case messages::BookmarksPageHandler::kExecuteOpenInNewWindowCommand: {
      break;
    }
    case messages::BookmarksPageHandler::kExecuteOpenInIncognitoWindowCommand: {
      break;
    }
    case messages::BookmarksPageHandler::kExecuteOpenInNewTabGroupCommand: {
      break;
    }
    case messages::BookmarksPageHandler::kExecuteOpenInSplitViewCommand: {
      break;
    }
    case messages::BookmarksPageHandler::kExecuteAddToBookmarksBarCommand: {
      break;
    }
    case messages::BookmarksPageHandler::kExecuteRemoveFromBookmarksBarCommand: {
      break;
    }
    case messages::BookmarksPageHandler::kExecuteDeleteCommand: {
      break;
    }
    case messages::BookmarksPageHandler::kOpenBookmark: {
      break;
    }
    case messages::BookmarksPageHandler::kUndo: {
      break;
    }
    case messages::BookmarksPageHandler::kRenameBookmark: {
      break;
    }
    case messages::BookmarksPageHandler::kMoveBookmark: {
      break;
    }
    case messages::BookmarksPageHandler::kRemoveBookmarks: {
      internal::BookmarksPageHandler_RemoveBookmarks_Params_Data* params =
          reinterpret_cast<
              internal::BookmarksPageHandler_RemoveBookmarks_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BookmarksPageHandler.17
      bool success = true;
      std::vector<int64_t> p_node_ids{};
      BookmarksPageHandler_RemoveBookmarks_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNodeIds(&p_node_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 17, false);
        return false;
      }
      auto callback =
          BookmarksPageHandler_RemoveBookmarks_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveBookmarks(        
        std::move(p_node_ids), std::move(callback));
      return true;
    }
    case messages::BookmarksPageHandler::kSetSortOrder: {
      break;
    }
    case messages::BookmarksPageHandler::kSetViewType: {
      break;
    }
    case messages::BookmarksPageHandler::kShowContextMenu: {
      break;
    }
    case messages::BookmarksPageHandler::kShowUI: {
      break;
    }
    case messages::BookmarksPageHandler::kGetAllBookmarks: {
      internal::BookmarksPageHandler_GetAllBookmarks_Params_Data* params =
          reinterpret_cast<
              internal::BookmarksPageHandler_GetAllBookmarks_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BookmarksPageHandler.22
      bool success = true;
      BookmarksPageHandler_GetAllBookmarks_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPageHandler::Name_, 22, false);
        return false;
      }
      auto callback =
          BookmarksPageHandler_GetAllBookmarks_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllBookmarks(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBookmarksPageHandlerValidationInfo[] = {
    { &internal::BookmarksPageHandler_BookmarkCurrentTabInFolder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_CreateFolder_Params_Data::Validate,
     &internal::BookmarksPageHandler_CreateFolder_ResponseParams_Data::Validate},
    { &internal::BookmarksPageHandler_DropBookmarks_Params_Data::Validate,
     &internal::BookmarksPageHandler_DropBookmarks_ResponseParams_Data::Validate},
    { &internal::BookmarksPageHandler_ExecuteEditCommand_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_ExecuteMoveCommand_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_ExecuteOpenInNewTabCommand_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_ExecuteOpenInNewWindowCommand_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_ExecuteOpenInSplitViewCommand_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_ExecuteDeleteCommand_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_OpenBookmark_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_Undo_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_RenameBookmark_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_MoveBookmark_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_RemoveBookmarks_Params_Data::Validate,
     &internal::BookmarksPageHandler_RemoveBookmarks_ResponseParams_Data::Validate},
    { &internal::BookmarksPageHandler_SetSortOrder_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_SetViewType_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_ShowContextMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_ShowUI_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPageHandler_GetAllBookmarks_Params_Data::Validate,
     &internal::BookmarksPageHandler_GetAllBookmarks_ResponseParams_Data::Validate},
};

bool BookmarksPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::side_panel::mojom::BookmarksPageHandler::Name_,
    kBookmarksPageHandlerValidationInfo);
}

bool BookmarksPageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::side_panel::mojom::BookmarksPageHandler::Name_,
    kBookmarksPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

BookmarksPage::IPCStableHashFunction BookmarksPage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BookmarksPage>(message.name())) {
    case messages::BookmarksPage::kOnBookmarkNodeAdded: {
      return &BookmarksPage::OnBookmarkNodeAdded_Sym::IPCStableHash;
    }
    case messages::BookmarksPage::kOnBookmarkNodesRemoved: {
      return &BookmarksPage::OnBookmarkNodesRemoved_Sym::IPCStableHash;
    }
    case messages::BookmarksPage::kOnBookmarkParentFolderChildrenReordered: {
      return &BookmarksPage::OnBookmarkParentFolderChildrenReordered_Sym::IPCStableHash;
    }
    case messages::BookmarksPage::kOnBookmarkNodeMoved: {
      return &BookmarksPage::OnBookmarkNodeMoved_Sym::IPCStableHash;
    }
    case messages::BookmarksPage::kOnBookmarkNodeChanged: {
      return &BookmarksPage::OnBookmarkNodeChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BookmarksPage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BookmarksPage>(message.name())) {
      case messages::BookmarksPage::kOnBookmarkNodeAdded:
            return "Receive side_panel::mojom::BookmarksPage::OnBookmarkNodeAdded";
      case messages::BookmarksPage::kOnBookmarkNodesRemoved:
            return "Receive side_panel::mojom::BookmarksPage::OnBookmarkNodesRemoved";
      case messages::BookmarksPage::kOnBookmarkParentFolderChildrenReordered:
            return "Receive side_panel::mojom::BookmarksPage::OnBookmarkParentFolderChildrenReordered";
      case messages::BookmarksPage::kOnBookmarkNodeMoved:
            return "Receive side_panel::mojom::BookmarksPage::OnBookmarkNodeMoved";
      case messages::BookmarksPage::kOnBookmarkNodeChanged:
            return "Receive side_panel::mojom::BookmarksPage::OnBookmarkNodeChanged";
    }
  } else {
    switch (static_cast<messages::BookmarksPage>(message.name())) {
      case messages::BookmarksPage::kOnBookmarkNodeAdded:
            return "Receive reply side_panel::mojom::BookmarksPage::OnBookmarkNodeAdded";
      case messages::BookmarksPage::kOnBookmarkNodesRemoved:
            return "Receive reply side_panel::mojom::BookmarksPage::OnBookmarkNodesRemoved";
      case messages::BookmarksPage::kOnBookmarkParentFolderChildrenReordered:
            return "Receive reply side_panel::mojom::BookmarksPage::OnBookmarkParentFolderChildrenReordered";
      case messages::BookmarksPage::kOnBookmarkNodeMoved:
            return "Receive reply side_panel::mojom::BookmarksPage::OnBookmarkNodeMoved";
      case messages::BookmarksPage::kOnBookmarkNodeChanged:
            return "Receive reply side_panel::mojom::BookmarksPage::OnBookmarkNodeChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BookmarksPage::OnBookmarkNodeAdded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x97a00081;  // IPCStableHash for side_panel::mojom::BookmarksPage::OnBookmarkNodeAdded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPage::OnBookmarkNodesRemoved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x16af190a;  // IPCStableHash for side_panel::mojom::BookmarksPage::OnBookmarkNodesRemoved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPage::OnBookmarkParentFolderChildrenReordered_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd777d34f;  // IPCStableHash for side_panel::mojom::BookmarksPage::OnBookmarkParentFolderChildrenReordered
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPage::OnBookmarkNodeMoved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1bb1d541;  // IPCStableHash for side_panel::mojom::BookmarksPage::OnBookmarkNodeMoved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BookmarksPage::OnBookmarkNodeChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x47c3382a;  // IPCStableHash for side_panel::mojom::BookmarksPage::OnBookmarkNodeChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

BookmarksPageProxy::BookmarksPageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BookmarksPageProxy::OnBookmarkNodeAdded(
    BookmarksTreeNodePtr in_node) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPage::OnBookmarkNodeAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node"), in_node,
                        "<value of type BookmarksTreeNodePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPage::kOnBookmarkNodeAdded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPage_OnBookmarkNodeAdded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->node)::BaseType> node_fragment(
          params.message());
  
  mojo::internal::Serialize<::side_panel::mojom::BookmarksTreeNodeDataView>(
    in_node,
    node_fragment);

  params->node.Set(
      node_fragment.is_null() ? nullptr : node_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->node.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null node in BookmarksPage.OnBookmarkNodeAdded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPage::Name_);
  message.set_method_name("OnBookmarkNodeAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageProxy::OnBookmarkNodesRemoved(
    const std::vector<std::string>& in_node_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPage::OnBookmarkNodesRemoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("node_ids"), in_node_ids,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPage::kOnBookmarkNodesRemoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPage_OnBookmarkNodesRemoved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->node_ids)::BaseType>
      node_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_node_ids,
    node_ids_fragment,
    &node_ids_validate_params);

  params->node_ids.Set(
      node_ids_fragment.is_null() ? nullptr : node_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->node_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null node_ids in BookmarksPage.OnBookmarkNodesRemoved request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPage::Name_);
  message.set_method_name("OnBookmarkNodesRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageProxy::OnBookmarkParentFolderChildrenReordered(
    const std::string& in_folder_id, const std::vector<std::string>& in_children_ordered_ids) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPage::OnBookmarkParentFolderChildrenReordered", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("folder_id"), in_folder_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("children_ordered_ids"), in_children_ordered_ids,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPage::kOnBookmarkParentFolderChildrenReordered), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPage_OnBookmarkParentFolderChildrenReordered_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->folder_id)::BaseType> folder_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_folder_id,
    folder_id_fragment);

  params->folder_id.Set(
      folder_id_fragment.is_null() ? nullptr : folder_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->folder_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null folder_id in BookmarksPage.OnBookmarkParentFolderChildrenReordered request");
  mojo::internal::MessageFragment<
      typename decltype(params->children_ordered_ids)::BaseType>
      children_ordered_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& children_ordered_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_children_ordered_ids,
    children_ordered_ids_fragment,
    &children_ordered_ids_validate_params);

  params->children_ordered_ids.Set(
      children_ordered_ids_fragment.is_null() ? nullptr : children_ordered_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->children_ordered_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null children_ordered_ids in BookmarksPage.OnBookmarkParentFolderChildrenReordered request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPage::Name_);
  message.set_method_name("OnBookmarkParentFolderChildrenReordered");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageProxy::OnBookmarkNodeMoved(
    const std::string& in_old_parent_index, uint32_t in_old_node_index, const std::string& in_new_parent_index, uint32_t in_new_node_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPage::OnBookmarkNodeMoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_parent_index"), in_old_parent_index,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_node_index"), in_old_node_index,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_parent_index"), in_new_parent_index,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_node_index"), in_new_node_index,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPage::kOnBookmarkNodeMoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPage_OnBookmarkNodeMoved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->old_parent_index)::BaseType> old_parent_index_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_old_parent_index,
    old_parent_index_fragment);

  params->old_parent_index.Set(
      old_parent_index_fragment.is_null() ? nullptr : old_parent_index_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->old_parent_index.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null old_parent_index in BookmarksPage.OnBookmarkNodeMoved request");

  params->old_node_index = in_old_node_index;
  mojo::internal::MessageFragment<
      typename decltype(params->new_parent_index)::BaseType> new_parent_index_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_new_parent_index,
    new_parent_index_fragment);

  params->new_parent_index.Set(
      new_parent_index_fragment.is_null() ? nullptr : new_parent_index_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_parent_index.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_parent_index in BookmarksPage.OnBookmarkNodeMoved request");

  params->new_node_index = in_new_node_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPage::Name_);
  message.set_method_name("OnBookmarkNodeMoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BookmarksPageProxy::OnBookmarkNodeChanged(
    const std::string& in_id, const std::string& in_new_title, const std::string& in_new_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::mojom::BookmarksPage::OnBookmarkNodeChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_title"), in_new_title,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_url"), in_new_url,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BookmarksPage::kOnBookmarkNodeChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::mojom::internal::BookmarksPage_OnBookmarkNodeChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in BookmarksPage.OnBookmarkNodeChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_title)::BaseType> new_title_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_new_title,
    new_title_fragment);

  params->new_title.Set(
      new_title_fragment.is_null() ? nullptr : new_title_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_title.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_title in BookmarksPage.OnBookmarkNodeChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_url)::BaseType> new_url_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_new_url,
    new_url_fragment);

  params->new_url.Set(
      new_url_fragment.is_null() ? nullptr : new_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_url in BookmarksPage.OnBookmarkNodeChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BookmarksPage::Name_);
  message.set_method_name("OnBookmarkNodeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool BookmarksPageStubDispatch::Accept(
    BookmarksPage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BookmarksPage>(message->header()->name)) {
    case messages::BookmarksPage::kOnBookmarkNodeAdded: {
      DCHECK(message->is_serialized());
      internal::BookmarksPage_OnBookmarkNodeAdded_Params_Data* params =
          reinterpret_cast<internal::BookmarksPage_OnBookmarkNodeAdded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPage.0
      bool success = true;
      BookmarksTreeNodePtr p_node{};
      BookmarksPage_OnBookmarkNodeAdded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNode(&p_node))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPage::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBookmarkNodeAdded(        
        std::move(p_node));
      return true;
    }
    case messages::BookmarksPage::kOnBookmarkNodesRemoved: {
      DCHECK(message->is_serialized());
      internal::BookmarksPage_OnBookmarkNodesRemoved_Params_Data* params =
          reinterpret_cast<internal::BookmarksPage_OnBookmarkNodesRemoved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPage.1
      bool success = true;
      std::vector<std::string> p_node_ids{};
      BookmarksPage_OnBookmarkNodesRemoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNodeIds(&p_node_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPage::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBookmarkNodesRemoved(        
        std::move(p_node_ids));
      return true;
    }
    case messages::BookmarksPage::kOnBookmarkParentFolderChildrenReordered: {
      DCHECK(message->is_serialized());
      internal::BookmarksPage_OnBookmarkParentFolderChildrenReordered_Params_Data* params =
          reinterpret_cast<internal::BookmarksPage_OnBookmarkParentFolderChildrenReordered_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPage.2
      bool success = true;
      std::string p_folder_id{};
      std::vector<std::string> p_children_ordered_ids{};
      BookmarksPage_OnBookmarkParentFolderChildrenReordered_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFolderId(&p_folder_id))
        success = false;
      if (success && !input_data_view.ReadChildrenOrderedIds(&p_children_ordered_ids))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPage::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBookmarkParentFolderChildrenReordered(        
        std::move(p_folder_id), 
        std::move(p_children_ordered_ids));
      return true;
    }
    case messages::BookmarksPage::kOnBookmarkNodeMoved: {
      DCHECK(message->is_serialized());
      internal::BookmarksPage_OnBookmarkNodeMoved_Params_Data* params =
          reinterpret_cast<internal::BookmarksPage_OnBookmarkNodeMoved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPage.3
      bool success = true;
      std::string p_old_parent_index{};
      uint32_t p_old_node_index{};
      std::string p_new_parent_index{};
      uint32_t p_new_node_index{};
      BookmarksPage_OnBookmarkNodeMoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOldParentIndex(&p_old_parent_index))
        success = false;
      if (success)
        p_old_node_index = input_data_view.old_node_index();
      if (success && !input_data_view.ReadNewParentIndex(&p_new_parent_index))
        success = false;
      if (success)
        p_new_node_index = input_data_view.new_node_index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPage::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBookmarkNodeMoved(        
        std::move(p_old_parent_index), 
        std::move(p_old_node_index), 
        std::move(p_new_parent_index), 
        std::move(p_new_node_index));
      return true;
    }
    case messages::BookmarksPage::kOnBookmarkNodeChanged: {
      DCHECK(message->is_serialized());
      internal::BookmarksPage_OnBookmarkNodeChanged_Params_Data* params =
          reinterpret_cast<internal::BookmarksPage_OnBookmarkNodeChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BookmarksPage.4
      bool success = true;
      std::string p_id{};
      std::string p_new_title{};
      std::string p_new_url{};
      BookmarksPage_OnBookmarkNodeChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadNewTitle(&p_new_title))
        success = false;
      if (success && !input_data_view.ReadNewUrl(&p_new_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BookmarksPage::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBookmarkNodeChanged(        
        std::move(p_id), 
        std::move(p_new_title), 
        std::move(p_new_url));
      return true;
    }
  }
  return false;
}

// static
bool BookmarksPageStubDispatch::AcceptWithResponder(
    BookmarksPage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BookmarksPage>(message->header()->name)) {
    case messages::BookmarksPage::kOnBookmarkNodeAdded: {
      break;
    }
    case messages::BookmarksPage::kOnBookmarkNodesRemoved: {
      break;
    }
    case messages::BookmarksPage::kOnBookmarkParentFolderChildrenReordered: {
      break;
    }
    case messages::BookmarksPage::kOnBookmarkNodeMoved: {
      break;
    }
    case messages::BookmarksPage::kOnBookmarkNodeChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBookmarksPageValidationInfo[] = {
    { &internal::BookmarksPage_OnBookmarkNodeAdded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPage_OnBookmarkNodesRemoved_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPage_OnBookmarkParentFolderChildrenReordered_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPage_OnBookmarkNodeMoved_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BookmarksPage_OnBookmarkNodeChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool BookmarksPageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::side_panel::mojom::BookmarksPage::Name_,
    kBookmarksPageValidationInfo);
}



}  // side_panel::mojom


namespace mojo {


// static
bool StructTraits<::side_panel::mojom::BookmarksTreeNode::DataView, ::side_panel::mojom::BookmarksTreeNodePtr>::Read(
    ::side_panel::mojom::BookmarksTreeNode::DataView input,
    ::side_panel::mojom::BookmarksTreeNodePtr* output) {
  bool success = true;
  ::side_panel::mojom::BookmarksTreeNodePtr result(::side_panel::mojom::BookmarksTreeNode::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadParentId(&result->parent_id))
        success = false;
      if (success)
        result->index = input.index();
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadChildren(&result->children))
        success = false;
      if (success) {
        result->date_added = input.date_added();
      }
      if (success) {
        result->date_last_used = input.date_last_used();
      }
      if (success)
        result->unmodifiable = input.unmodifiable();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace side_panel::mojom {


void BookmarksPageHandlerFactoryInterceptorForTesting::CreateBookmarksPageHandler(::mojo::PendingRemote<BookmarksPage> page, ::mojo::PendingReceiver<BookmarksPageHandler> handler) {
  GetForwardingInterface()->CreateBookmarksPageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
BookmarksPageHandlerFactoryAsyncWaiter::BookmarksPageHandlerFactoryAsyncWaiter(
    BookmarksPageHandlerFactory* proxy) : proxy_(proxy) {}

BookmarksPageHandlerFactoryAsyncWaiter::~BookmarksPageHandlerFactoryAsyncWaiter() = default;





void BookmarksPageHandlerInterceptorForTesting::BookmarkCurrentTabInFolder(const std::string& folder_id) {
  GetForwardingInterface()->BookmarkCurrentTabInFolder(
    std::move(folder_id)
    );
}
void BookmarksPageHandlerInterceptorForTesting::CreateFolder(const std::string& folder_id, const std::string& title, CreateFolderCallback callback) {
  GetForwardingInterface()->CreateFolder(
    std::move(folder_id)
    , 
    std::move(title)
    , std::move(callback));
}
void BookmarksPageHandlerInterceptorForTesting::DropBookmarks(const std::string& folder_id, DropBookmarksCallback callback) {
  GetForwardingInterface()->DropBookmarks(
    std::move(folder_id)
    , std::move(callback));
}
void BookmarksPageHandlerInterceptorForTesting::ExecuteEditCommand(const std::vector<int64_t>& node_ids, ActionSource source) {
  GetForwardingInterface()->ExecuteEditCommand(
    std::move(node_ids)
    , 
    std::move(source)
    );
}
void BookmarksPageHandlerInterceptorForTesting::ExecuteMoveCommand(const std::vector<int64_t>& node_ids, ActionSource source) {
  GetForwardingInterface()->ExecuteMoveCommand(
    std::move(node_ids)
    , 
    std::move(source)
    );
}
void BookmarksPageHandlerInterceptorForTesting::ExecuteOpenInNewTabCommand(const std::vector<std::string>& side_panel_ids, ActionSource source) {
  GetForwardingInterface()->ExecuteOpenInNewTabCommand(
    std::move(side_panel_ids)
    , 
    std::move(source)
    );
}
void BookmarksPageHandlerInterceptorForTesting::ExecuteOpenInNewWindowCommand(const std::vector<std::string>& side_panel_ids, ActionSource source) {
  GetForwardingInterface()->ExecuteOpenInNewWindowCommand(
    std::move(side_panel_ids)
    , 
    std::move(source)
    );
}
void BookmarksPageHandlerInterceptorForTesting::ExecuteOpenInIncognitoWindowCommand(const std::vector<std::string>& side_panel_ids, ActionSource source) {
  GetForwardingInterface()->ExecuteOpenInIncognitoWindowCommand(
    std::move(side_panel_ids)
    , 
    std::move(source)
    );
}
void BookmarksPageHandlerInterceptorForTesting::ExecuteOpenInNewTabGroupCommand(const std::vector<std::string>& side_panel_ids, ActionSource source) {
  GetForwardingInterface()->ExecuteOpenInNewTabGroupCommand(
    std::move(side_panel_ids)
    , 
    std::move(source)
    );
}
void BookmarksPageHandlerInterceptorForTesting::ExecuteOpenInSplitViewCommand(const std::vector<int64_t>& node_ids, ActionSource source) {
  GetForwardingInterface()->ExecuteOpenInSplitViewCommand(
    std::move(node_ids)
    , 
    std::move(source)
    );
}
void BookmarksPageHandlerInterceptorForTesting::ExecuteAddToBookmarksBarCommand(int64_t node_id, ActionSource source) {
  GetForwardingInterface()->ExecuteAddToBookmarksBarCommand(
    std::move(node_id)
    , 
    std::move(source)
    );
}
void BookmarksPageHandlerInterceptorForTesting::ExecuteRemoveFromBookmarksBarCommand(int64_t node_id, ActionSource source) {
  GetForwardingInterface()->ExecuteRemoveFromBookmarksBarCommand(
    std::move(node_id)
    , 
    std::move(source)
    );
}
void BookmarksPageHandlerInterceptorForTesting::ExecuteDeleteCommand(const std::vector<int64_t>& node_ids, ActionSource source) {
  GetForwardingInterface()->ExecuteDeleteCommand(
    std::move(node_ids)
    , 
    std::move(source)
    );
}
void BookmarksPageHandlerInterceptorForTesting::OpenBookmark(int64_t node_id, int32_t parent_folder_depth, ::ui::mojom::ClickModifiersPtr click_modifiers, ActionSource source) {
  GetForwardingInterface()->OpenBookmark(
    std::move(node_id)
    , 
    std::move(parent_folder_depth)
    , 
    std::move(click_modifiers)
    , 
    std::move(source)
    );
}
void BookmarksPageHandlerInterceptorForTesting::Undo() {
  GetForwardingInterface()->Undo();
}
void BookmarksPageHandlerInterceptorForTesting::RenameBookmark(int64_t node_id, const std::string& new_title) {
  GetForwardingInterface()->RenameBookmark(
    std::move(node_id)
    , 
    std::move(new_title)
    );
}
void BookmarksPageHandlerInterceptorForTesting::MoveBookmark(int64_t node_id, const std::string& folder_id) {
  GetForwardingInterface()->MoveBookmark(
    std::move(node_id)
    , 
    std::move(folder_id)
    );
}
void BookmarksPageHandlerInterceptorForTesting::RemoveBookmarks(const std::vector<int64_t>& node_ids, RemoveBookmarksCallback callback) {
  GetForwardingInterface()->RemoveBookmarks(
    std::move(node_ids)
    , std::move(callback));
}
void BookmarksPageHandlerInterceptorForTesting::SetSortOrder(SortOrder sort_order) {
  GetForwardingInterface()->SetSortOrder(
    std::move(sort_order)
    );
}
void BookmarksPageHandlerInterceptorForTesting::SetViewType(ViewType view_type) {
  GetForwardingInterface()->SetViewType(
    std::move(view_type)
    );
}
void BookmarksPageHandlerInterceptorForTesting::ShowContextMenu(const std::string& id, const ::gfx::Point& point, ActionSource source) {
  GetForwardingInterface()->ShowContextMenu(
    std::move(id)
    , 
    std::move(point)
    , 
    std::move(source)
    );
}
void BookmarksPageHandlerInterceptorForTesting::ShowUI() {
  GetForwardingInterface()->ShowUI();
}
void BookmarksPageHandlerInterceptorForTesting::GetAllBookmarks(GetAllBookmarksCallback callback) {
  GetForwardingInterface()->GetAllBookmarks(std::move(callback));
}
BookmarksPageHandlerAsyncWaiter::BookmarksPageHandlerAsyncWaiter(
    BookmarksPageHandler* proxy) : proxy_(proxy) {}

BookmarksPageHandlerAsyncWaiter::~BookmarksPageHandlerAsyncWaiter() = default;


void BookmarksPageHandlerAsyncWaiter::CreateFolder(
    const std::string& folder_id, const std::string& title, std::string* out_new_folder_id) {
  base::RunLoop loop;
  proxy_->CreateFolder(
      std::move(folder_id),
      std::move(title),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_new_folder_id
,
             const std::string& new_folder_id) {*out_new_folder_id = std::move(new_folder_id);
            loop->Quit();
          },
          &loop,
          out_new_folder_id));
  loop.Run();
}

std::string BookmarksPageHandlerAsyncWaiter::CreateFolder(
    const std::string& folder_id, const std::string& title) {
  std::string async_wait_result;
  CreateFolder(std::move(folder_id),std::move(title),&async_wait_result);
  return async_wait_result;
}

void BookmarksPageHandlerAsyncWaiter::DropBookmarks(
    const std::string& folder_id) {
  base::RunLoop loop;
  proxy_->DropBookmarks(
      std::move(folder_id),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void BookmarksPageHandlerAsyncWaiter::RemoveBookmarks(
    const std::vector<int64_t>& node_ids) {
  base::RunLoop loop;
  proxy_->RemoveBookmarks(
      std::move(node_ids),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void BookmarksPageHandlerAsyncWaiter::GetAllBookmarks(
    std::vector<BookmarksTreeNodePtr>* out_nodes) {
  base::RunLoop loop;
  proxy_->GetAllBookmarks(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<BookmarksTreeNodePtr>* out_nodes
,
             std::vector<BookmarksTreeNodePtr> nodes) {*out_nodes = std::move(nodes);
            loop->Quit();
          },
          &loop,
          out_nodes));
  loop.Run();
}

std::vector<BookmarksTreeNodePtr> BookmarksPageHandlerAsyncWaiter::GetAllBookmarks(
    ) {
  std::vector<BookmarksTreeNodePtr> async_wait_result;
  GetAllBookmarks(&async_wait_result);
  return async_wait_result;
}




void BookmarksPageInterceptorForTesting::OnBookmarkNodeAdded(BookmarksTreeNodePtr node) {
  GetForwardingInterface()->OnBookmarkNodeAdded(
    std::move(node)
    );
}
void BookmarksPageInterceptorForTesting::OnBookmarkNodesRemoved(const std::vector<std::string>& node_ids) {
  GetForwardingInterface()->OnBookmarkNodesRemoved(
    std::move(node_ids)
    );
}
void BookmarksPageInterceptorForTesting::OnBookmarkParentFolderChildrenReordered(const std::string& folder_id, const std::vector<std::string>& children_ordered_ids) {
  GetForwardingInterface()->OnBookmarkParentFolderChildrenReordered(
    std::move(folder_id)
    , 
    std::move(children_ordered_ids)
    );
}
void BookmarksPageInterceptorForTesting::OnBookmarkNodeMoved(const std::string& old_parent_index, uint32_t old_node_index, const std::string& new_parent_index, uint32_t new_node_index) {
  GetForwardingInterface()->OnBookmarkNodeMoved(
    std::move(old_parent_index)
    , 
    std::move(old_node_index)
    , 
    std::move(new_parent_index)
    , 
    std::move(new_node_index)
    );
}
void BookmarksPageInterceptorForTesting::OnBookmarkNodeChanged(const std::string& id, const std::string& new_title, const std::string& new_url) {
  GetForwardingInterface()->OnBookmarkNodeChanged(
    std::move(id)
    , 
    std::move(new_title)
    , 
    std::move(new_url)
    );
}
BookmarksPageAsyncWaiter::BookmarksPageAsyncWaiter(
    BookmarksPage* proxy) : proxy_(proxy) {}

BookmarksPageAsyncWaiter::~BookmarksPageAsyncWaiter() = default;







}  // side_panel::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif