// chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom-params-data.h"
namespace side_panel {
namespace mojom {

NOINLINE static const char* ActionSourceToStringHelper(ActionSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ActionSource::kBookmark:
      return "kBookmark";
    case ActionSource::kPriceTracking:
      return "kPriceTracking";
    default:
      return nullptr;
  }
}

std::string ActionSourceToString(ActionSource value) {
  const char *str = ActionSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ActionSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ActionSource value) {
  return os << ActionSourceToString(value);
}

NOINLINE static const char* SortOrderToStringHelper(SortOrder value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SortOrder::kNewest:
      return "kNewest";
    case SortOrder::kOldest:
      return "kOldest";
    case SortOrder::kLastOpened:
      return "kLastOpened";
    case SortOrder::kAlphabetical:
      return "kAlphabetical";
    case SortOrder::kReverseAlphabetical:
      return "kReverseAlphabetical";
    case SortOrder::kCount:
      return "kCount";
    default:
      return nullptr;
  }
}

std::string SortOrderToString(SortOrder value) {
  const char *str = SortOrderToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SortOrder value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SortOrder value) {
  return os << SortOrderToString(value);
}

NOINLINE static const char* ViewTypeToStringHelper(ViewType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ViewType::kCompact:
      return "kCompact";
    case ViewType::kExpanded:
      return "kExpanded";
    case ViewType::kCount:
      return "kCount";
    default:
      return nullptr;
  }
}

std::string ViewTypeToString(ViewType value) {
  const char *str = ViewTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ViewType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ViewType value) {
  return os << ViewTypeToString(value);
}

namespace internal {


// static
bool BookmarksTreeNode_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksTreeNode_Data* object =
      static_cast<const BookmarksTreeNode_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parent_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& parent_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->parent_id, validation_context,
                                         &parent_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url, validation_context,
                                         &url_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->children, validation_context,
                                         &children_validate_params)) {
    return false;
  }

  return true;
}

BookmarksTreeNode_Data::BookmarksTreeNode_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandlerFactory_CreateBookmarksPageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandlerFactory_CreateBookmarksPageHandler_Params_Data* object =
      static_cast<const BookmarksPageHandlerFactory_CreateBookmarksPageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

BookmarksPageHandlerFactory_CreateBookmarksPageHandler_Params_Data::BookmarksPageHandlerFactory_CreateBookmarksPageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_BookmarkCurrentTabInFolder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_BookmarkCurrentTabInFolder_Params_Data* object =
      static_cast<const BookmarksPageHandler_BookmarkCurrentTabInFolder_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->folder_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& folder_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->folder_id, validation_context,
                                         &folder_id_validate_params)) {
    return false;
  }

  return true;
}

BookmarksPageHandler_BookmarkCurrentTabInFolder_Params_Data::BookmarksPageHandler_BookmarkCurrentTabInFolder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_CreateFolder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_CreateFolder_Params_Data* object =
      static_cast<const BookmarksPageHandler_CreateFolder_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->folder_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& folder_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->folder_id, validation_context,
                                         &folder_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  return true;
}

BookmarksPageHandler_CreateFolder_Params_Data::BookmarksPageHandler_CreateFolder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_CreateFolder_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_CreateFolder_ResponseParams_Data* object =
      static_cast<const BookmarksPageHandler_CreateFolder_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_folder_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& new_folder_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->new_folder_id, validation_context,
                                         &new_folder_id_validate_params)) {
    return false;
  }

  return true;
}

BookmarksPageHandler_CreateFolder_ResponseParams_Data::BookmarksPageHandler_CreateFolder_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_DropBookmarks_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_DropBookmarks_Params_Data* object =
      static_cast<const BookmarksPageHandler_DropBookmarks_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->folder_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& folder_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->folder_id, validation_context,
                                         &folder_id_validate_params)) {
    return false;
  }

  return true;
}

BookmarksPageHandler_DropBookmarks_Params_Data::BookmarksPageHandler_DropBookmarks_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_DropBookmarks_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_DropBookmarks_ResponseParams_Data* object =
      static_cast<const BookmarksPageHandler_DropBookmarks_ResponseParams_Data*>(data);

  return true;
}

BookmarksPageHandler_DropBookmarks_ResponseParams_Data::BookmarksPageHandler_DropBookmarks_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_ExecuteEditCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_ExecuteEditCommand_Params_Data* object =
      static_cast<const BookmarksPageHandler_ExecuteEditCommand_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->node_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->node_ids, validation_context,
                                         &node_ids_validate_params)) {
    return false;
  }


  if (!::side_panel::mojom::internal::ActionSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

BookmarksPageHandler_ExecuteEditCommand_Params_Data::BookmarksPageHandler_ExecuteEditCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_ExecuteMoveCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_ExecuteMoveCommand_Params_Data* object =
      static_cast<const BookmarksPageHandler_ExecuteMoveCommand_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->node_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->node_ids, validation_context,
                                         &node_ids_validate_params)) {
    return false;
  }


  if (!::side_panel::mojom::internal::ActionSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

BookmarksPageHandler_ExecuteMoveCommand_Params_Data::BookmarksPageHandler_ExecuteMoveCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_ExecuteOpenInNewTabCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_ExecuteOpenInNewTabCommand_Params_Data* object =
      static_cast<const BookmarksPageHandler_ExecuteOpenInNewTabCommand_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->side_panel_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& side_panel_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->side_panel_ids, validation_context,
                                         &side_panel_ids_validate_params)) {
    return false;
  }


  if (!::side_panel::mojom::internal::ActionSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

BookmarksPageHandler_ExecuteOpenInNewTabCommand_Params_Data::BookmarksPageHandler_ExecuteOpenInNewTabCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_ExecuteOpenInNewWindowCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_ExecuteOpenInNewWindowCommand_Params_Data* object =
      static_cast<const BookmarksPageHandler_ExecuteOpenInNewWindowCommand_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->side_panel_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& side_panel_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->side_panel_ids, validation_context,
                                         &side_panel_ids_validate_params)) {
    return false;
  }


  if (!::side_panel::mojom::internal::ActionSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

BookmarksPageHandler_ExecuteOpenInNewWindowCommand_Params_Data::BookmarksPageHandler_ExecuteOpenInNewWindowCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_Params_Data* object =
      static_cast<const BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->side_panel_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& side_panel_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->side_panel_ids, validation_context,
                                         &side_panel_ids_validate_params)) {
    return false;
  }


  if (!::side_panel::mojom::internal::ActionSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_Params_Data::BookmarksPageHandler_ExecuteOpenInIncognitoWindowCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_Params_Data* object =
      static_cast<const BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->side_panel_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& side_panel_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->side_panel_ids, validation_context,
                                         &side_panel_ids_validate_params)) {
    return false;
  }


  if (!::side_panel::mojom::internal::ActionSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_Params_Data::BookmarksPageHandler_ExecuteOpenInNewTabGroupCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_ExecuteOpenInSplitViewCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_ExecuteOpenInSplitViewCommand_Params_Data* object =
      static_cast<const BookmarksPageHandler_ExecuteOpenInSplitViewCommand_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->node_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->node_ids, validation_context,
                                         &node_ids_validate_params)) {
    return false;
  }


  if (!::side_panel::mojom::internal::ActionSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

BookmarksPageHandler_ExecuteOpenInSplitViewCommand_Params_Data::BookmarksPageHandler_ExecuteOpenInSplitViewCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_Params_Data* object =
      static_cast<const BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_Params_Data*>(data);


  if (!::side_panel::mojom::internal::ActionSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_Params_Data::BookmarksPageHandler_ExecuteAddToBookmarksBarCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_Params_Data* object =
      static_cast<const BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_Params_Data*>(data);


  if (!::side_panel::mojom::internal::ActionSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_Params_Data::BookmarksPageHandler_ExecuteRemoveFromBookmarksBarCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_ExecuteDeleteCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_ExecuteDeleteCommand_Params_Data* object =
      static_cast<const BookmarksPageHandler_ExecuteDeleteCommand_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->node_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->node_ids, validation_context,
                                         &node_ids_validate_params)) {
    return false;
  }


  if (!::side_panel::mojom::internal::ActionSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

BookmarksPageHandler_ExecuteDeleteCommand_Params_Data::BookmarksPageHandler_ExecuteDeleteCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_OpenBookmark_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_OpenBookmark_Params_Data* object =
      static_cast<const BookmarksPageHandler_OpenBookmark_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->click_modifiers, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->click_modifiers, validation_context))
    return false;


  if (!::side_panel::mojom::internal::ActionSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

BookmarksPageHandler_OpenBookmark_Params_Data::BookmarksPageHandler_OpenBookmark_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_Undo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_Undo_Params_Data* object =
      static_cast<const BookmarksPageHandler_Undo_Params_Data*>(data);

  return true;
}

BookmarksPageHandler_Undo_Params_Data::BookmarksPageHandler_Undo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_RenameBookmark_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_RenameBookmark_Params_Data* object =
      static_cast<const BookmarksPageHandler_RenameBookmark_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_title, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& new_title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->new_title, validation_context,
                                         &new_title_validate_params)) {
    return false;
  }

  return true;
}

BookmarksPageHandler_RenameBookmark_Params_Data::BookmarksPageHandler_RenameBookmark_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_MoveBookmark_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_MoveBookmark_Params_Data* object =
      static_cast<const BookmarksPageHandler_MoveBookmark_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->folder_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& folder_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->folder_id, validation_context,
                                         &folder_id_validate_params)) {
    return false;
  }

  return true;
}

BookmarksPageHandler_MoveBookmark_Params_Data::BookmarksPageHandler_MoveBookmark_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_RemoveBookmarks_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_RemoveBookmarks_Params_Data* object =
      static_cast<const BookmarksPageHandler_RemoveBookmarks_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->node_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->node_ids, validation_context,
                                         &node_ids_validate_params)) {
    return false;
  }

  return true;
}

BookmarksPageHandler_RemoveBookmarks_Params_Data::BookmarksPageHandler_RemoveBookmarks_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_RemoveBookmarks_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_RemoveBookmarks_ResponseParams_Data* object =
      static_cast<const BookmarksPageHandler_RemoveBookmarks_ResponseParams_Data*>(data);

  return true;
}

BookmarksPageHandler_RemoveBookmarks_ResponseParams_Data::BookmarksPageHandler_RemoveBookmarks_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_SetSortOrder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_SetSortOrder_Params_Data* object =
      static_cast<const BookmarksPageHandler_SetSortOrder_Params_Data*>(data);


  if (!::side_panel::mojom::internal::SortOrder_Data
        ::Validate(object->sort_order, validation_context))
    return false;

  return true;
}

BookmarksPageHandler_SetSortOrder_Params_Data::BookmarksPageHandler_SetSortOrder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_SetViewType_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_SetViewType_Params_Data* object =
      static_cast<const BookmarksPageHandler_SetViewType_Params_Data*>(data);


  if (!::side_panel::mojom::internal::ViewType_Data
        ::Validate(object->view_type, validation_context))
    return false;

  return true;
}

BookmarksPageHandler_SetViewType_Params_Data::BookmarksPageHandler_SetViewType_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_ShowContextMenu_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_ShowContextMenu_Params_Data* object =
      static_cast<const BookmarksPageHandler_ShowContextMenu_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->point, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->point, validation_context))
    return false;


  if (!::side_panel::mojom::internal::ActionSource_Data
        ::Validate(object->source, validation_context))
    return false;

  return true;
}

BookmarksPageHandler_ShowContextMenu_Params_Data::BookmarksPageHandler_ShowContextMenu_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_ShowUI_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_ShowUI_Params_Data* object =
      static_cast<const BookmarksPageHandler_ShowUI_Params_Data*>(data);

  return true;
}

BookmarksPageHandler_ShowUI_Params_Data::BookmarksPageHandler_ShowUI_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_GetAllBookmarks_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_GetAllBookmarks_Params_Data* object =
      static_cast<const BookmarksPageHandler_GetAllBookmarks_Params_Data*>(data);

  return true;
}

BookmarksPageHandler_GetAllBookmarks_Params_Data::BookmarksPageHandler_GetAllBookmarks_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPageHandler_GetAllBookmarks_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPageHandler_GetAllBookmarks_ResponseParams_Data* object =
      static_cast<const BookmarksPageHandler_GetAllBookmarks_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->nodes, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& nodes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->nodes, validation_context,
                                         &nodes_validate_params)) {
    return false;
  }

  return true;
}

BookmarksPageHandler_GetAllBookmarks_ResponseParams_Data::BookmarksPageHandler_GetAllBookmarks_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPage_OnBookmarkNodeAdded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPage_OnBookmarkNodeAdded_Params_Data* object =
      static_cast<const BookmarksPage_OnBookmarkNodeAdded_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->node, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->node, validation_context))
    return false;

  return true;
}

BookmarksPage_OnBookmarkNodeAdded_Params_Data::BookmarksPage_OnBookmarkNodeAdded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPage_OnBookmarkNodesRemoved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPage_OnBookmarkNodesRemoved_Params_Data* object =
      static_cast<const BookmarksPage_OnBookmarkNodesRemoved_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->node_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& node_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->node_ids, validation_context,
                                         &node_ids_validate_params)) {
    return false;
  }

  return true;
}

BookmarksPage_OnBookmarkNodesRemoved_Params_Data::BookmarksPage_OnBookmarkNodesRemoved_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPage_OnBookmarkParentFolderChildrenReordered_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPage_OnBookmarkParentFolderChildrenReordered_Params_Data* object =
      static_cast<const BookmarksPage_OnBookmarkParentFolderChildrenReordered_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->folder_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& folder_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->folder_id, validation_context,
                                         &folder_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->children_ordered_ids, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& children_ordered_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->children_ordered_ids, validation_context,
                                         &children_ordered_ids_validate_params)) {
    return false;
  }

  return true;
}

BookmarksPage_OnBookmarkParentFolderChildrenReordered_Params_Data::BookmarksPage_OnBookmarkParentFolderChildrenReordered_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPage_OnBookmarkNodeMoved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPage_OnBookmarkNodeMoved_Params_Data* object =
      static_cast<const BookmarksPage_OnBookmarkNodeMoved_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->old_parent_index, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& old_parent_index_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->old_parent_index, validation_context,
                                         &old_parent_index_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_parent_index, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& new_parent_index_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->new_parent_index, validation_context,
                                         &new_parent_index_validate_params)) {
    return false;
  }

  return true;
}

BookmarksPage_OnBookmarkNodeMoved_Params_Data::BookmarksPage_OnBookmarkNodeMoved_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BookmarksPage_OnBookmarkNodeChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BookmarksPage_OnBookmarkNodeChanged_Params_Data* object =
      static_cast<const BookmarksPage_OnBookmarkNodeChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_title, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& new_title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->new_title, validation_context,
                                         &new_title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_url, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& new_url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->new_url, validation_context,
                                         &new_url_validate_params)) {
    return false;
  }

  return true;
}

BookmarksPage_OnBookmarkNodeChanged_Params_Data::BookmarksPage_OnBookmarkNodeChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace side_panel

namespace perfetto {

// static
void TraceFormatTraits<::side_panel::mojom::ActionSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::side_panel::mojom::ActionSource value) {
  return std::move(context).WriteString(::side_panel::mojom::ActionSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::side_panel::mojom::SortOrder>::WriteIntoTrace(
   perfetto::TracedValue context, ::side_panel::mojom::SortOrder value) {
  return std::move(context).WriteString(::side_panel::mojom::SortOrderToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::side_panel::mojom::ViewType>::WriteIntoTrace(
   perfetto::TracedValue context, ::side_panel::mojom::ViewType value) {
  return std::move(context).WriteString(::side_panel::mojom::ViewTypeToString(value));
}

} // namespace perfetto