// chrome/browser/ui/webui/segmentation_internals/segmentation_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SEGMENTATION_INTERNALS_SEGMENTATION_INTERNALS_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_SEGMENTATION_INTERNALS_SEGMENTATION_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/segmentation_internals/segmentation_internals.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/segmentation_internals/segmentation_internals.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::segmentation_internals::mojom::ServiceStatusDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::segmentation_internals::mojom::ServiceStatusDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::segmentation_internals::mojom::internal::ServiceStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->is_initialized = Traits::is_initialized(input);

    fragment->intialization_status = Traits::intialization_status(input);
  }

  static bool Deserialize(::segmentation_internals::mojom::internal::ServiceStatus_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::segmentation_internals::mojom::ServiceStatusDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::segmentation_internals::mojom::SegmentInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::segmentation_internals::mojom::SegmentInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::segmentation_internals::mojom::internal::SegmentInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::segment_name(input)) in_segment_name = Traits::segment_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->segment_name)::BaseType> segment_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_segment_name,
      segment_name_fragment);

    fragment->segment_name.Set(
        segment_name_fragment.is_null() ? nullptr : segment_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->segment_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null segment_name in SegmentInfo struct");

    fragment->segment_id = Traits::segment_id(input);

    decltype(Traits::segment_data(input)) in_segment_data = Traits::segment_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->segment_data)::BaseType> segment_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_segment_data,
      segment_data_fragment);

    fragment->segment_data.Set(
        segment_data_fragment.is_null() ? nullptr : segment_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->segment_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null segment_data in SegmentInfo struct");

    fragment->can_execute_segment = Traits::can_execute_segment(input);

    decltype(Traits::prediction_result(input)) in_prediction_result = Traits::prediction_result(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prediction_result)::BaseType> prediction_result_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_prediction_result,
      prediction_result_fragment);

    fragment->prediction_result.Set(
        prediction_result_fragment.is_null() ? nullptr : prediction_result_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->prediction_result.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null prediction_result in SegmentInfo struct");

    decltype(Traits::prediction_timestamp(input)) in_prediction_timestamp = Traits::prediction_timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prediction_timestamp)::BaseType> prediction_timestamp_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_prediction_timestamp,
      prediction_timestamp_fragment);

    fragment->prediction_timestamp.Set(
        prediction_timestamp_fragment.is_null() ? nullptr : prediction_timestamp_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->prediction_timestamp.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null prediction_timestamp in SegmentInfo struct");
  }

  static bool Deserialize(::segmentation_internals::mojom::internal::SegmentInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::segmentation_internals::mojom::SegmentInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::segmentation_internals::mojom::ClientInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::segmentation_internals::mojom::ClientInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::segmentation_internals::mojom::internal::ClientInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::segmentation_key(input)) in_segmentation_key = Traits::segmentation_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->segmentation_key)::BaseType> segmentation_key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_segmentation_key,
      segmentation_key_fragment);

    fragment->segmentation_key.Set(
        segmentation_key_fragment.is_null() ? nullptr : segmentation_key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->segmentation_key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null segmentation_key in ClientInfo struct");

    decltype(Traits::selected_segment(input)) in_selected_segment = Traits::selected_segment(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selected_segment)::BaseType> selected_segment_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_selected_segment,
      selected_segment_fragment);

    fragment->selected_segment.Set(
        selected_segment_fragment.is_null() ? nullptr : selected_segment_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->selected_segment.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null selected_segment in ClientInfo struct");

    decltype(Traits::segment_info(input)) in_segment_info = Traits::segment_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->segment_info)::BaseType>
        segment_info_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& segment_info_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::segmentation_internals::mojom::SegmentInfoDataView>>(
      in_segment_info,
      segment_info_fragment,
      &segment_info_validate_params);

    fragment->segment_info.Set(
        segment_info_fragment.is_null() ? nullptr : segment_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->segment_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null segment_info in ClientInfo struct");
  }

  static bool Deserialize(::segmentation_internals::mojom::internal::ClientInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::segmentation_internals::mojom::ClientInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace segmentation_internals::mojom {



inline void SegmentInfoDataView::GetSegmentNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->segment_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SegmentInfoDataView::GetSegmentDataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->segment_data.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SegmentInfoDataView::GetPredictionResultDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->prediction_result.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SegmentInfoDataView::GetPredictionTimestampDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->prediction_timestamp.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void ClientInfoDataView::GetSegmentationKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->segmentation_key.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ClientInfoDataView::GetSelectedSegmentDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->selected_segment.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ClientInfoDataView::GetSegmentInfoDataView(
    mojo::ArrayDataView<SegmentInfoDataView>* output) {
  auto pointer = data_->segment_info.Get();
  *output = mojo::ArrayDataView<SegmentInfoDataView>(pointer, message_);
}



}  // segmentation_internals::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CHROME_BROWSER_UI_WEBUI_SEGMENTATION_INTERNALS_SEGMENTATION_INTERNALS_MOJOM_SHARED_H_