// chrome/browser/ui/webui/privacy_sandbox/base_dialog.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_BASE_DIALOG_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_BASE_DIALOG_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/privacy_sandbox/base_dialog.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/privacy_sandbox/base_dialog.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/privacy_sandbox/base_dialog.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/values.mojom-forward.h"
#include "chrome/browser/privacy_sandbox/notice/notice.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace privacy_sandbox::dialog::mojom {

class BaseDialogPageHandlerFactoryProxy;

template <typename ImplRefTraits>
class BaseDialogPageHandlerFactoryStub;

class BaseDialogPageHandlerFactoryRequestValidator;


class BaseDialogPageHandlerFactory
    : public BaseDialogPageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "privacy_sandbox.dialog.mojom.BaseDialogPageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BaseDialogPageHandlerFactoryInterfaceBase;
  using Proxy_ = BaseDialogPageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = BaseDialogPageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = BaseDialogPageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BaseDialogPageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<BaseDialogPage> page, ::mojo::PendingReceiver<BaseDialogPageHandler> receiver) = 0;
};

class BaseDialogPageHandlerProxy;

template <typename ImplRefTraits>
class BaseDialogPageHandlerStub;

class BaseDialogPageHandlerRequestValidator;


class BaseDialogPageHandler
    : public BaseDialogPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "privacy_sandbox.dialog.mojom.BaseDialogPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BaseDialogPageHandlerInterfaceBase;
  using Proxy_ = BaseDialogPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = BaseDialogPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = BaseDialogPageHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kResizeDialogMinVersion = 0,
    kShowDialogMinVersion = 0,
    kEventOccurredMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ResizeDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EventOccurred_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BaseDialogPageHandler() = default;

  virtual void ResizeDialog(uint32_t height) = 0;

  virtual void ShowDialog() = 0;

  virtual void EventOccurred(::privacy_sandbox::notice::mojom::PrivacySandboxNotice notice, ::privacy_sandbox::notice::mojom::PrivacySandboxNoticeEvent event) = 0;
};

class BaseDialogPageProxy;

template <typename ImplRefTraits>
class BaseDialogPageStub;

class BaseDialogPageRequestValidator;


class BaseDialogPage
    : public BaseDialogPageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "privacy_sandbox.dialog.mojom.BaseDialogPage";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BaseDialogPageInterfaceBase;
  using Proxy_ = BaseDialogPageProxy;

  template <typename ImplRefTraits>
  using Stub_ = BaseDialogPageStub<ImplRefTraits>;

  using RequestValidator_ = BaseDialogPageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kNavigateToNextStepMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct NavigateToNextStep_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BaseDialogPage() = default;

  virtual void NavigateToNextStep(::privacy_sandbox::notice::mojom::PrivacySandboxNotice next_step) = 0;
};



class  BaseDialogPageHandlerFactoryProxy
    : public BaseDialogPageHandlerFactory {
 public:
  using InterfaceType = BaseDialogPageHandlerFactory;

  explicit BaseDialogPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<BaseDialogPage> page, ::mojo::PendingReceiver<BaseDialogPageHandler> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  BaseDialogPageHandlerProxy
    : public BaseDialogPageHandler {
 public:
  using InterfaceType = BaseDialogPageHandler;

  explicit BaseDialogPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ResizeDialog(uint32_t height) final;
  
  void ShowDialog() final;
  
  void EventOccurred(::privacy_sandbox::notice::mojom::PrivacySandboxNotice notice, ::privacy_sandbox::notice::mojom::PrivacySandboxNoticeEvent event) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  BaseDialogPageProxy
    : public BaseDialogPage {
 public:
  using InterfaceType = BaseDialogPage;

  explicit BaseDialogPageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void NavigateToNextStep(::privacy_sandbox::notice::mojom::PrivacySandboxNotice next_step) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  BaseDialogPageHandlerFactoryStubDispatch {
 public:
  static bool Accept(BaseDialogPageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BaseDialogPageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BaseDialogPageHandlerFactory>>
class BaseDialogPageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BaseDialogPageHandlerFactoryStub() = default;
  ~BaseDialogPageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BaseDialogPageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BaseDialogPageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BaseDialogPageHandlerStubDispatch {
 public:
  static bool Accept(BaseDialogPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BaseDialogPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BaseDialogPageHandler>>
class BaseDialogPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BaseDialogPageHandlerStub() = default;
  ~BaseDialogPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BaseDialogPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BaseDialogPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BaseDialogPageStubDispatch {
 public:
  static bool Accept(BaseDialogPage* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BaseDialogPage* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BaseDialogPage>>
class BaseDialogPageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BaseDialogPageStub() = default;
  ~BaseDialogPageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BaseDialogPageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BaseDialogPageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BaseDialogPageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BaseDialogPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BaseDialogPageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // privacy_sandbox::dialog::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_BASE_DIALOG_MOJOM_H_