// chrome/browser/ui/webui/on_device_internals/on_device_internals_page.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_ON_DEVICE_INTERNALS_ON_DEVICE_INTERNALS_PAGE_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_ON_DEVICE_INTERNALS_ON_DEVICE_INTERNALS_PAGE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/on_device_internals/on_device_internals_page.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/on_device_internals/on_device_internals_page.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/on_device_internals/on_device_internals_page.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/on_device_model/public/mojom/on_device_model.mojom.h"
#include "services/on_device_model/public/mojom/on_device_model_service.mojom.h"
#include "skia/public/mojom/bitmap.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace on_device_internals::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "on_device_internals.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "on_device_internals.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kLoadModelMinVersion = 0,
    kLoadPlatformModelMinVersion = 0,
    kGetDeviceAndPerformanceInfoMinVersion = 0,
    kGetDefaultModelPathMinVersion = 0,
    kGetPageDataMinVersion = 0,
    kSetFeatureRecentlyUsedStateMinVersion = 0,
    kDecodeBitmapMinVersion = 0,
    kResetModelCrashCountMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct LoadModel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LoadPlatformModel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDeviceAndPerformanceInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDefaultModelPath_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetPageData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetFeatureRecentlyUsedState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DecodeBitmap_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResetModelCrashCount_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  using LoadModelCallback = base::OnceCallback<void(::on_device_model::mojom::LoadModelResult, const ::on_device_model::Capabilities&)>;
  using LoadModelMojoCallback = base::OnceCallback<void(::on_device_model::mojom::LoadModelResult, const ::on_device_model::Capabilities&)>;

  virtual void LoadModel(const ::base::FilePath& model_path, ::ml::ModelPerformanceHint performance_hint, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, LoadModelCallback callback) = 0;

  using LoadPlatformModelCallback = base::OnceCallback<void(::on_device_model::mojom::LoadModelResult)>;
  using LoadPlatformModelMojoCallback = base::OnceCallback<void(::on_device_model::mojom::LoadModelResult)>;

  virtual void LoadPlatformModel(const ::base::FilePath& model_path, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, LoadPlatformModelCallback callback) = 0;

  using GetDeviceAndPerformanceInfoCallback = base::OnceCallback<void(::on_device_model::mojom::DevicePerformanceInfoPtr, ::on_device_model::mojom::DeviceInfoPtr)>;
  using GetDeviceAndPerformanceInfoMojoCallback = base::OnceCallback<void(::on_device_model::mojom::DevicePerformanceInfoPtr, ::on_device_model::mojom::DeviceInfoPtr)>;

  virtual void GetDeviceAndPerformanceInfo(GetDeviceAndPerformanceInfoCallback callback) = 0;

  using GetDefaultModelPathCallback = base::OnceCallback<void(const std::optional<::base::FilePath>&)>;
  using GetDefaultModelPathMojoCallback = base::OnceCallback<void(const std::optional<::base::FilePath>&)>;

  virtual void GetDefaultModelPath(GetDefaultModelPathCallback callback) = 0;

  using GetPageDataCallback = base::OnceCallback<void(PageDataPtr)>;
  using GetPageDataMojoCallback = base::OnceCallback<void(PageDataPtr)>;

  virtual void GetPageData(GetPageDataCallback callback) = 0;

  virtual void SetFeatureRecentlyUsedState(int32_t feature_key, bool is_recently_used) = 0;

  using DecodeBitmapCallback = base::OnceCallback<void(const ::SkBitmap&)>;
  using DecodeBitmapMojoCallback = base::OnceCallback<void(const ::SkBitmap&)>;

  virtual void DecodeBitmap(::mojo_base::BigBuffer image_buffer, DecodeBitmapCallback callback) = 0;

  virtual void ResetModelCrashCount() = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "on_device_internals.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnLogMessageAddedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnLogMessageAdded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void OnLogMessageAdded(::base::Time event_time, const std::string& source_file, int64_t source_line, const std::string& message) = 0;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void LoadModel(const ::base::FilePath& model_path, ::ml::ModelPerformanceHint performance_hint, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, LoadModelCallback callback) final;
  
  void LoadPlatformModel(const ::base::FilePath& model_path, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, LoadPlatformModelCallback callback) final;
  
  void GetDeviceAndPerformanceInfo(GetDeviceAndPerformanceInfoCallback callback) final;
  
  void GetDefaultModelPath(GetDefaultModelPathCallback callback) final;
  
  void GetPageData(GetPageDataCallback callback) final;
  
  void SetFeatureRecentlyUsedState(int32_t feature_key, bool is_recently_used) final;
  
  void DecodeBitmap(::mojo_base::BigBuffer image_buffer, DecodeBitmapCallback callback) final;
  
  void ResetModelCrashCount() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnLogMessageAdded(::base::Time event_time, const std::string& source_file, int64_t source_line, const std::string& message) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  SupplementaryModelInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SupplementaryModelInfo, T>::value>;
  using DataView = SupplementaryModelInfoDataView;
  using Data_ = internal::SupplementaryModelInfo_Data;

  template <typename... Args>
  static SupplementaryModelInfoPtr New(Args&&... args) {
    return SupplementaryModelInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SupplementaryModelInfoPtr From(const U& u) {
    return mojo::TypeConverter<SupplementaryModelInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SupplementaryModelInfo>::Convert(*this);
  }


  SupplementaryModelInfo();

  SupplementaryModelInfo(
      const std::string& supp_model_name,
      bool is_ready);


  ~SupplementaryModelInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SupplementaryModelInfoPtr>
  SupplementaryModelInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SupplementaryModelInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SupplementaryModelInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SupplementaryModelInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupplementaryModelInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupplementaryModelInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SupplementaryModelInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SupplementaryModelInfo_UnserializedMessageContext<
            UserType, SupplementaryModelInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SupplementaryModelInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SupplementaryModelInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SupplementaryModelInfo_UnserializedMessageContext<
            UserType, SupplementaryModelInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SupplementaryModelInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string supp_model_name;
  
  bool is_ready;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SupplementaryModelInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SupplementaryModelInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SupplementaryModelInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SupplementaryModelInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FeatureAdaptationInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FeatureAdaptationInfo, T>::value>;
  using DataView = FeatureAdaptationInfoDataView;
  using Data_ = internal::FeatureAdaptationInfo_Data;

  template <typename... Args>
  static FeatureAdaptationInfoPtr New(Args&&... args) {
    return FeatureAdaptationInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FeatureAdaptationInfoPtr From(const U& u) {
    return mojo::TypeConverter<FeatureAdaptationInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FeatureAdaptationInfo>::Convert(*this);
  }


  FeatureAdaptationInfo();

  FeatureAdaptationInfo(
      const std::string& feature_name,
      int32_t feature_key,
      int64_t version,
      bool is_recently_used);


  ~FeatureAdaptationInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FeatureAdaptationInfoPtr>
  FeatureAdaptationInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FeatureAdaptationInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FeatureAdaptationInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FeatureAdaptationInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FeatureAdaptationInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FeatureAdaptationInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FeatureAdaptationInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FeatureAdaptationInfo_UnserializedMessageContext<
            UserType, FeatureAdaptationInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FeatureAdaptationInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FeatureAdaptationInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FeatureAdaptationInfo_UnserializedMessageContext<
            UserType, FeatureAdaptationInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FeatureAdaptationInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string feature_name;
  
  int32_t feature_key;
  
  int64_t version;
  
  bool is_recently_used;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FeatureAdaptationInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FeatureAdaptationInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FeatureAdaptationInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FeatureAdaptationInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  PageData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PageData, T>::value>;
  using DataView = PageDataDataView;
  using Data_ = internal::PageData_Data;

  template <typename... Args>
  static PageDataPtr New(Args&&... args) {
    return PageDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PageDataPtr From(const U& u) {
    return mojo::TypeConverter<PageDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PageData>::Convert(*this);
  }


  PageData();

  PageData(
      BaseModelStatePtr base_model,
      std::vector<SupplementaryModelInfoPtr> supp_models,
      int32_t model_crash_count,
      int32_t max_model_crash_count,
      std::vector<FeatureAdaptationInfoPtr> feature_adaptations,
      ::on_device_model::mojom::DevicePerformanceInfoPtr performance_info,
      uint64_t min_vram_mb);

PageData(const PageData&) = delete;
PageData& operator=(const PageData&) = delete;

  ~PageData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PageDataPtr>
  PageDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PageData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PageData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PageData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PageData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PageData_UnserializedMessageContext<
            UserType, PageData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PageData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PageData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PageData_UnserializedMessageContext<
            UserType, PageData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PageData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  BaseModelStatePtr base_model;
  
  std::vector<SupplementaryModelInfoPtr> supp_models;
  
  int32_t model_crash_count;
  
  int32_t max_model_crash_count;
  
  std::vector<FeatureAdaptationInfoPtr> feature_adaptations;
  
  ::on_device_model::mojom::DevicePerformanceInfoPtr performance_info;
  
  uint64_t min_vram_mb;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PageData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PageData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PageData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PageData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BaseModelState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BaseModelState, T>::value>;
  using DataView = BaseModelStateDataView;
  using Data_ = internal::BaseModelState_Data;

  template <typename... Args>
  static BaseModelStatePtr New(Args&&... args) {
    return BaseModelStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BaseModelStatePtr From(const U& u) {
    return mojo::TypeConverter<BaseModelStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BaseModelState>::Convert(*this);
  }


  BaseModelState();

  BaseModelState(
      const std::string& state,
      const base::flat_map<std::string, std::string>& registration_criteria,
      BaseModelInfoPtr info);

BaseModelState(const BaseModelState&) = delete;
BaseModelState& operator=(const BaseModelState&) = delete;

  ~BaseModelState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BaseModelStatePtr>
  BaseModelStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BaseModelState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BaseModelState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BaseModelState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BaseModelState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BaseModelState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BaseModelState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BaseModelState_UnserializedMessageContext<
            UserType, BaseModelState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BaseModelState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BaseModelState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BaseModelState_UnserializedMessageContext<
            UserType, BaseModelState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BaseModelState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string state;
  
  base::flat_map<std::string, std::string> registration_criteria;
  
  BaseModelInfoPtr info;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BaseModelState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BaseModelState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BaseModelState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BaseModelState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BaseModelInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BaseModelInfo, T>::value>;
  using DataView = BaseModelInfoDataView;
  using Data_ = internal::BaseModelInfo_Data;

  template <typename... Args>
  static BaseModelInfoPtr New(Args&&... args) {
    return BaseModelInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BaseModelInfoPtr From(const U& u) {
    return mojo::TypeConverter<BaseModelInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BaseModelInfo>::Convert(*this);
  }


  BaseModelInfo();

  BaseModelInfo(
      const std::string& component_version,
      const std::string& file_path,
      uint64_t file_size,
      const std::string& name,
      const std::string& version,
      const std::string& backend_type);


  ~BaseModelInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BaseModelInfoPtr>
  BaseModelInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BaseModelInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BaseModelInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BaseModelInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BaseModelInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BaseModelInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BaseModelInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BaseModelInfo_UnserializedMessageContext<
            UserType, BaseModelInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BaseModelInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BaseModelInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BaseModelInfo_UnserializedMessageContext<
            UserType, BaseModelInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BaseModelInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string component_version;
  
  std::string file_path;
  
  uint64_t file_size;
  
  std::string name;
  
  std::string version;
  
  std::string backend_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BaseModelInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BaseModelInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BaseModelInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BaseModelInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}



template <typename StructPtrType>
PageDataPtr PageData::Clone() const {
  return New(
      mojo::Clone(base_model),
      mojo::Clone(supp_models),
      mojo::Clone(model_crash_count),
      mojo::Clone(max_model_crash_count),
      mojo::Clone(feature_adaptations),
      mojo::Clone(performance_info),
      mojo::Clone(min_vram_mb)
  );
}

template <typename T, PageData::EnableIfSame<T>*>
bool PageData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->base_model, other_struct.base_model))
    return false;
  if (!mojo::Equals(this->supp_models, other_struct.supp_models))
    return false;
  if (!mojo::Equals(this->model_crash_count, other_struct.model_crash_count))
    return false;
  if (!mojo::Equals(this->max_model_crash_count, other_struct.max_model_crash_count))
    return false;
  if (!mojo::Equals(this->feature_adaptations, other_struct.feature_adaptations))
    return false;
  if (!mojo::Equals(this->performance_info, other_struct.performance_info))
    return false;
  if (!mojo::Equals(this->min_vram_mb, other_struct.min_vram_mb))
    return false;
  return true;
}

template <typename T, PageData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.base_model < rhs.base_model)
    return true;
  if (rhs.base_model < lhs.base_model)
    return false;
  if (lhs.supp_models < rhs.supp_models)
    return true;
  if (rhs.supp_models < lhs.supp_models)
    return false;
  if (lhs.model_crash_count < rhs.model_crash_count)
    return true;
  if (rhs.model_crash_count < lhs.model_crash_count)
    return false;
  if (lhs.max_model_crash_count < rhs.max_model_crash_count)
    return true;
  if (rhs.max_model_crash_count < lhs.max_model_crash_count)
    return false;
  if (lhs.feature_adaptations < rhs.feature_adaptations)
    return true;
  if (rhs.feature_adaptations < lhs.feature_adaptations)
    return false;
  if (lhs.performance_info < rhs.performance_info)
    return true;
  if (rhs.performance_info < lhs.performance_info)
    return false;
  if (lhs.min_vram_mb < rhs.min_vram_mb)
    return true;
  if (rhs.min_vram_mb < lhs.min_vram_mb)
    return false;
  return false;
}
template <typename StructPtrType>
BaseModelStatePtr BaseModelState::Clone() const {
  return New(
      mojo::Clone(state),
      mojo::Clone(registration_criteria),
      mojo::Clone(info)
  );
}

template <typename T, BaseModelState::EnableIfSame<T>*>
bool BaseModelState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  if (!mojo::Equals(this->registration_criteria, other_struct.registration_criteria))
    return false;
  if (!mojo::Equals(this->info, other_struct.info))
    return false;
  return true;
}

template <typename T, BaseModelState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  if (lhs.registration_criteria < rhs.registration_criteria)
    return true;
  if (rhs.registration_criteria < lhs.registration_criteria)
    return false;
  if (lhs.info < rhs.info)
    return true;
  if (rhs.info < lhs.info)
    return false;
  return false;
}
template <typename StructPtrType>
BaseModelInfoPtr BaseModelInfo::Clone() const {
  return New(
      mojo::Clone(component_version),
      mojo::Clone(file_path),
      mojo::Clone(file_size),
      mojo::Clone(name),
      mojo::Clone(version),
      mojo::Clone(backend_type)
  );
}

template <typename T, BaseModelInfo::EnableIfSame<T>*>
bool BaseModelInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->component_version, other_struct.component_version))
    return false;
  if (!mojo::Equals(this->file_path, other_struct.file_path))
    return false;
  if (!mojo::Equals(this->file_size, other_struct.file_size))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->backend_type, other_struct.backend_type))
    return false;
  return true;
}

template <typename T, BaseModelInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.component_version < rhs.component_version)
    return true;
  if (rhs.component_version < lhs.component_version)
    return false;
  if (lhs.file_path < rhs.file_path)
    return true;
  if (rhs.file_path < lhs.file_path)
    return false;
  if (lhs.file_size < rhs.file_size)
    return true;
  if (rhs.file_size < lhs.file_size)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.backend_type < rhs.backend_type)
    return true;
  if (rhs.backend_type < lhs.backend_type)
    return false;
  return false;
}
template <typename StructPtrType>
SupplementaryModelInfoPtr SupplementaryModelInfo::Clone() const {
  return New(
      mojo::Clone(supp_model_name),
      mojo::Clone(is_ready)
  );
}

template <typename T, SupplementaryModelInfo::EnableIfSame<T>*>
bool SupplementaryModelInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->supp_model_name, other_struct.supp_model_name))
    return false;
  if (!mojo::Equals(this->is_ready, other_struct.is_ready))
    return false;
  return true;
}

template <typename T, SupplementaryModelInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.supp_model_name < rhs.supp_model_name)
    return true;
  if (rhs.supp_model_name < lhs.supp_model_name)
    return false;
  if (lhs.is_ready < rhs.is_ready)
    return true;
  if (rhs.is_ready < lhs.is_ready)
    return false;
  return false;
}
template <typename StructPtrType>
FeatureAdaptationInfoPtr FeatureAdaptationInfo::Clone() const {
  return New(
      mojo::Clone(feature_name),
      mojo::Clone(feature_key),
      mojo::Clone(version),
      mojo::Clone(is_recently_used)
  );
}

template <typename T, FeatureAdaptationInfo::EnableIfSame<T>*>
bool FeatureAdaptationInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->feature_name, other_struct.feature_name))
    return false;
  if (!mojo::Equals(this->feature_key, other_struct.feature_key))
    return false;
  if (!mojo::Equals(this->version, other_struct.version))
    return false;
  if (!mojo::Equals(this->is_recently_used, other_struct.is_recently_used))
    return false;
  return true;
}

template <typename T, FeatureAdaptationInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.feature_name < rhs.feature_name)
    return true;
  if (rhs.feature_name < lhs.feature_name)
    return false;
  if (lhs.feature_key < rhs.feature_key)
    return true;
  if (rhs.feature_key < lhs.feature_key)
    return false;
  if (lhs.version < rhs.version)
    return true;
  if (rhs.version < lhs.version)
    return false;
  if (lhs.is_recently_used < rhs.is_recently_used)
    return true;
  if (rhs.is_recently_used < lhs.is_recently_used)
    return false;
  return false;
}


}  // on_device_internals::mojom

namespace mojo {


template <>
struct  StructTraits<::on_device_internals::mojom::PageData::DataView,
                                         ::on_device_internals::mojom::PageDataPtr> {
  static bool IsNull(const ::on_device_internals::mojom::PageDataPtr& input) { return !input; }
  static void SetToNull(::on_device_internals::mojom::PageDataPtr* output) { output->reset(); }

  static const decltype(::on_device_internals::mojom::PageData::base_model)& base_model(
      const ::on_device_internals::mojom::PageDataPtr& input) {
    return input->base_model;
  }

  static const decltype(::on_device_internals::mojom::PageData::supp_models)& supp_models(
      const ::on_device_internals::mojom::PageDataPtr& input) {
    return input->supp_models;
  }

  static decltype(::on_device_internals::mojom::PageData::model_crash_count) model_crash_count(
      const ::on_device_internals::mojom::PageDataPtr& input) {
    return input->model_crash_count;
  }

  static decltype(::on_device_internals::mojom::PageData::max_model_crash_count) max_model_crash_count(
      const ::on_device_internals::mojom::PageDataPtr& input) {
    return input->max_model_crash_count;
  }

  static const decltype(::on_device_internals::mojom::PageData::feature_adaptations)& feature_adaptations(
      const ::on_device_internals::mojom::PageDataPtr& input) {
    return input->feature_adaptations;
  }

  static const decltype(::on_device_internals::mojom::PageData::performance_info)& performance_info(
      const ::on_device_internals::mojom::PageDataPtr& input) {
    return input->performance_info;
  }

  static decltype(::on_device_internals::mojom::PageData::min_vram_mb) min_vram_mb(
      const ::on_device_internals::mojom::PageDataPtr& input) {
    return input->min_vram_mb;
  }

  static bool Read(::on_device_internals::mojom::PageData::DataView input, ::on_device_internals::mojom::PageDataPtr* output);
};


template <>
struct  StructTraits<::on_device_internals::mojom::BaseModelState::DataView,
                                         ::on_device_internals::mojom::BaseModelStatePtr> {
  static bool IsNull(const ::on_device_internals::mojom::BaseModelStatePtr& input) { return !input; }
  static void SetToNull(::on_device_internals::mojom::BaseModelStatePtr* output) { output->reset(); }

  static const decltype(::on_device_internals::mojom::BaseModelState::state)& state(
      const ::on_device_internals::mojom::BaseModelStatePtr& input) {
    return input->state;
  }

  static const decltype(::on_device_internals::mojom::BaseModelState::registration_criteria)& registration_criteria(
      const ::on_device_internals::mojom::BaseModelStatePtr& input) {
    return input->registration_criteria;
  }

  static const decltype(::on_device_internals::mojom::BaseModelState::info)& info(
      const ::on_device_internals::mojom::BaseModelStatePtr& input) {
    return input->info;
  }

  static bool Read(::on_device_internals::mojom::BaseModelState::DataView input, ::on_device_internals::mojom::BaseModelStatePtr* output);
};


template <>
struct  StructTraits<::on_device_internals::mojom::BaseModelInfo::DataView,
                                         ::on_device_internals::mojom::BaseModelInfoPtr> {
  static bool IsNull(const ::on_device_internals::mojom::BaseModelInfoPtr& input) { return !input; }
  static void SetToNull(::on_device_internals::mojom::BaseModelInfoPtr* output) { output->reset(); }

  static const decltype(::on_device_internals::mojom::BaseModelInfo::component_version)& component_version(
      const ::on_device_internals::mojom::BaseModelInfoPtr& input) {
    return input->component_version;
  }

  static const decltype(::on_device_internals::mojom::BaseModelInfo::file_path)& file_path(
      const ::on_device_internals::mojom::BaseModelInfoPtr& input) {
    return input->file_path;
  }

  static decltype(::on_device_internals::mojom::BaseModelInfo::file_size) file_size(
      const ::on_device_internals::mojom::BaseModelInfoPtr& input) {
    return input->file_size;
  }

  static const decltype(::on_device_internals::mojom::BaseModelInfo::name)& name(
      const ::on_device_internals::mojom::BaseModelInfoPtr& input) {
    return input->name;
  }

  static const decltype(::on_device_internals::mojom::BaseModelInfo::version)& version(
      const ::on_device_internals::mojom::BaseModelInfoPtr& input) {
    return input->version;
  }

  static const decltype(::on_device_internals::mojom::BaseModelInfo::backend_type)& backend_type(
      const ::on_device_internals::mojom::BaseModelInfoPtr& input) {
    return input->backend_type;
  }

  static bool Read(::on_device_internals::mojom::BaseModelInfo::DataView input, ::on_device_internals::mojom::BaseModelInfoPtr* output);
};


template <>
struct  StructTraits<::on_device_internals::mojom::SupplementaryModelInfo::DataView,
                                         ::on_device_internals::mojom::SupplementaryModelInfoPtr> {
  static bool IsNull(const ::on_device_internals::mojom::SupplementaryModelInfoPtr& input) { return !input; }
  static void SetToNull(::on_device_internals::mojom::SupplementaryModelInfoPtr* output) { output->reset(); }

  static const decltype(::on_device_internals::mojom::SupplementaryModelInfo::supp_model_name)& supp_model_name(
      const ::on_device_internals::mojom::SupplementaryModelInfoPtr& input) {
    return input->supp_model_name;
  }

  static decltype(::on_device_internals::mojom::SupplementaryModelInfo::is_ready) is_ready(
      const ::on_device_internals::mojom::SupplementaryModelInfoPtr& input) {
    return input->is_ready;
  }

  static bool Read(::on_device_internals::mojom::SupplementaryModelInfo::DataView input, ::on_device_internals::mojom::SupplementaryModelInfoPtr* output);
};


template <>
struct  StructTraits<::on_device_internals::mojom::FeatureAdaptationInfo::DataView,
                                         ::on_device_internals::mojom::FeatureAdaptationInfoPtr> {
  static bool IsNull(const ::on_device_internals::mojom::FeatureAdaptationInfoPtr& input) { return !input; }
  static void SetToNull(::on_device_internals::mojom::FeatureAdaptationInfoPtr* output) { output->reset(); }

  static const decltype(::on_device_internals::mojom::FeatureAdaptationInfo::feature_name)& feature_name(
      const ::on_device_internals::mojom::FeatureAdaptationInfoPtr& input) {
    return input->feature_name;
  }

  static decltype(::on_device_internals::mojom::FeatureAdaptationInfo::feature_key) feature_key(
      const ::on_device_internals::mojom::FeatureAdaptationInfoPtr& input) {
    return input->feature_key;
  }

  static decltype(::on_device_internals::mojom::FeatureAdaptationInfo::version) version(
      const ::on_device_internals::mojom::FeatureAdaptationInfoPtr& input) {
    return input->version;
  }

  static decltype(::on_device_internals::mojom::FeatureAdaptationInfo::is_recently_used) is_recently_used(
      const ::on_device_internals::mojom::FeatureAdaptationInfoPtr& input) {
    return input->is_recently_used;
  }

  static bool Read(::on_device_internals::mojom::FeatureAdaptationInfo::DataView input, ::on_device_internals::mojom::FeatureAdaptationInfoPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_ON_DEVICE_INTERNALS_ON_DEVICE_INTERNALS_PAGE_MOJOM_H_