// chrome/browser/ui/webui/on_device_internals/on_device_internals_page.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/on_device_internals/on_device_internals_page.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/on_device_internals/on_device_internals_page.mojom-params-data.h"
#include "chrome/browser/ui/webui/on_device_internals/on_device_internals_page.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/on_device_internals/on_device_internals_page.mojom-import-headers.h"
#include "chrome/browser/ui/webui/on_device_internals/on_device_internals_page.mojom-test-utils.h"


namespace on_device_internals::mojom {
PageData::PageData()
    : base_model(),
      supp_models(),
      model_crash_count(),
      max_model_crash_count(),
      feature_adaptations(),
      performance_info(),
      min_vram_mb() {}

PageData::PageData(
    BaseModelStatePtr base_model_in,
    std::vector<SupplementaryModelInfoPtr> supp_models_in,
    int32_t model_crash_count_in,
    int32_t max_model_crash_count_in,
    std::vector<FeatureAdaptationInfoPtr> feature_adaptations_in,
    ::on_device_model::mojom::DevicePerformanceInfoPtr performance_info_in,
    uint64_t min_vram_mb_in)
    : base_model(std::move(base_model_in)),
      supp_models(std::move(supp_models_in)),
      model_crash_count(std::move(model_crash_count_in)),
      max_model_crash_count(std::move(max_model_crash_count_in)),
      feature_adaptations(std::move(feature_adaptations_in)),
      performance_info(std::move(performance_info_in)),
      min_vram_mb(std::move(min_vram_mb_in)) {}

PageData::~PageData() = default;

void PageData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "base_model"), this->base_model,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BaseModelStatePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supp_models"), this->supp_models,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<SupplementaryModelInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "model_crash_count"), this->model_crash_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_model_crash_count"), this->max_model_crash_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feature_adaptations"), this->feature_adaptations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<FeatureAdaptationInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "performance_info"), this->performance_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::on_device_model::mojom::DevicePerformanceInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_vram_mb"), this->min_vram_mb,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PageData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BaseModelState::BaseModelState()
    : state(),
      registration_criteria(),
      info() {}

BaseModelState::BaseModelState(
    const std::string& state_in,
    const base::flat_map<std::string, std::string>& registration_criteria_in,
    BaseModelInfoPtr info_in)
    : state(std::move(state_in)),
      registration_criteria(std::move(registration_criteria_in)),
      info(std::move(info_in)) {}

BaseModelState::~BaseModelState() = default;

void BaseModelState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "registration_criteria"), this->registration_criteria,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "info"), this->info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type BaseModelInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BaseModelState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BaseModelInfo::BaseModelInfo()
    : component_version(),
      file_path(),
      file_size(),
      name(),
      version(),
      backend_type() {}

BaseModelInfo::BaseModelInfo(
    const std::string& component_version_in,
    const std::string& file_path_in,
    uint64_t file_size_in,
    const std::string& name_in,
    const std::string& version_in,
    const std::string& backend_type_in)
    : component_version(std::move(component_version_in)),
      file_path(std::move(file_path_in)),
      file_size(std::move(file_size_in)),
      name(std::move(name_in)),
      version(std::move(version_in)),
      backend_type(std::move(backend_type_in)) {}

BaseModelInfo::~BaseModelInfo() = default;
size_t BaseModelInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->component_version);
  seed = mojo::internal::Hash(seed, this->file_path);
  seed = mojo::internal::Hash(seed, this->file_size);
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->version);
  seed = mojo::internal::Hash(seed, this->backend_type);
  return seed;
}

void BaseModelInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "component_version"), this->component_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_path"), this->file_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "file_size"), this->file_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "backend_type"), this->backend_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BaseModelInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SupplementaryModelInfo::SupplementaryModelInfo()
    : supp_model_name(),
      is_ready() {}

SupplementaryModelInfo::SupplementaryModelInfo(
    const std::string& supp_model_name_in,
    bool is_ready_in)
    : supp_model_name(std::move(supp_model_name_in)),
      is_ready(std::move(is_ready_in)) {}

SupplementaryModelInfo::~SupplementaryModelInfo() = default;
size_t SupplementaryModelInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->supp_model_name);
  seed = mojo::internal::Hash(seed, this->is_ready);
  return seed;
}

void SupplementaryModelInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supp_model_name"), this->supp_model_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_ready"), this->is_ready,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SupplementaryModelInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FeatureAdaptationInfo::FeatureAdaptationInfo()
    : feature_name(),
      feature_key(),
      version(),
      is_recently_used() {}

FeatureAdaptationInfo::FeatureAdaptationInfo(
    const std::string& feature_name_in,
    int32_t feature_key_in,
    int64_t version_in,
    bool is_recently_used_in)
    : feature_name(std::move(feature_name_in)),
      feature_key(std::move(feature_key_in)),
      version(std::move(version_in)),
      is_recently_used(std::move(is_recently_used_in)) {}

FeatureAdaptationInfo::~FeatureAdaptationInfo() = default;
size_t FeatureAdaptationInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->feature_name);
  seed = mojo::internal::Hash(seed, this->feature_key);
  seed = mojo::internal::Hash(seed, this->version);
  seed = mojo::internal::Hash(seed, this->is_recently_used);
  return seed;
}

void FeatureAdaptationInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feature_name"), this->feature_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feature_key"), this->feature_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_recently_used"), this->is_recently_used,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FeatureAdaptationInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive on_device_internals::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply on_device_internals::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0f0e73f1;  // IPCStableHash for on_device_internals::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_internals::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_internals::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::on_device_internals::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::on_device_internals::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::on_device_internals::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kLoadModel: {
      return &PageHandler::LoadModel_Sym::IPCStableHash;
    }
    case messages::PageHandler::kLoadPlatformModel: {
      return &PageHandler::LoadPlatformModel_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetDeviceAndPerformanceInfo: {
      return &PageHandler::GetDeviceAndPerformanceInfo_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetDefaultModelPath: {
      return &PageHandler::GetDefaultModelPath_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetPageData: {
      return &PageHandler::GetPageData_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetFeatureRecentlyUsedState: {
      return &PageHandler::SetFeatureRecentlyUsedState_Sym::IPCStableHash;
    }
    case messages::PageHandler::kDecodeBitmap: {
      return &PageHandler::DecodeBitmap_Sym::IPCStableHash;
    }
    case messages::PageHandler::kResetModelCrashCount: {
      return &PageHandler::ResetModelCrashCount_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kLoadModel:
            return "Receive on_device_internals::mojom::PageHandler::LoadModel";
      case messages::PageHandler::kLoadPlatformModel:
            return "Receive on_device_internals::mojom::PageHandler::LoadPlatformModel";
      case messages::PageHandler::kGetDeviceAndPerformanceInfo:
            return "Receive on_device_internals::mojom::PageHandler::GetDeviceAndPerformanceInfo";
      case messages::PageHandler::kGetDefaultModelPath:
            return "Receive on_device_internals::mojom::PageHandler::GetDefaultModelPath";
      case messages::PageHandler::kGetPageData:
            return "Receive on_device_internals::mojom::PageHandler::GetPageData";
      case messages::PageHandler::kSetFeatureRecentlyUsedState:
            return "Receive on_device_internals::mojom::PageHandler::SetFeatureRecentlyUsedState";
      case messages::PageHandler::kDecodeBitmap:
            return "Receive on_device_internals::mojom::PageHandler::DecodeBitmap";
      case messages::PageHandler::kResetModelCrashCount:
            return "Receive on_device_internals::mojom::PageHandler::ResetModelCrashCount";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kLoadModel:
            return "Receive reply on_device_internals::mojom::PageHandler::LoadModel";
      case messages::PageHandler::kLoadPlatformModel:
            return "Receive reply on_device_internals::mojom::PageHandler::LoadPlatformModel";
      case messages::PageHandler::kGetDeviceAndPerformanceInfo:
            return "Receive reply on_device_internals::mojom::PageHandler::GetDeviceAndPerformanceInfo";
      case messages::PageHandler::kGetDefaultModelPath:
            return "Receive reply on_device_internals::mojom::PageHandler::GetDefaultModelPath";
      case messages::PageHandler::kGetPageData:
            return "Receive reply on_device_internals::mojom::PageHandler::GetPageData";
      case messages::PageHandler::kSetFeatureRecentlyUsedState:
            return "Receive reply on_device_internals::mojom::PageHandler::SetFeatureRecentlyUsedState";
      case messages::PageHandler::kDecodeBitmap:
            return "Receive reply on_device_internals::mojom::PageHandler::DecodeBitmap";
      case messages::PageHandler::kResetModelCrashCount:
            return "Receive reply on_device_internals::mojom::PageHandler::ResetModelCrashCount";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::LoadModel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x300cf9ce;  // IPCStableHash for on_device_internals::mojom::PageHandler::LoadModel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::LoadPlatformModel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe7972f4d;  // IPCStableHash for on_device_internals::mojom::PageHandler::LoadPlatformModel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetDeviceAndPerformanceInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3e2ed428;  // IPCStableHash for on_device_internals::mojom::PageHandler::GetDeviceAndPerformanceInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetDefaultModelPath_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeb434234;  // IPCStableHash for on_device_internals::mojom::PageHandler::GetDefaultModelPath
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetPageData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x413aeee9;  // IPCStableHash for on_device_internals::mojom::PageHandler::GetPageData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetFeatureRecentlyUsedState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2e0aed49;  // IPCStableHash for on_device_internals::mojom::PageHandler::SetFeatureRecentlyUsedState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::DecodeBitmap_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3dd2ce23;  // IPCStableHash for on_device_internals::mojom::PageHandler::DecodeBitmap
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ResetModelCrashCount_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x251222de;  // IPCStableHash for on_device_internals::mojom::PageHandler::ResetModelCrashCount
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_LoadModel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_LoadModel_ForwardToCallback(
      PageHandler::LoadModelCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_LoadModel_ForwardToCallback(const PageHandler_LoadModel_ForwardToCallback&) = delete;
  PageHandler_LoadModel_ForwardToCallback& operator=(const PageHandler_LoadModel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::LoadModelCallback callback_;
};

class PageHandler_LoadPlatformModel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_LoadPlatformModel_ForwardToCallback(
      PageHandler::LoadPlatformModelCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_LoadPlatformModel_ForwardToCallback(const PageHandler_LoadPlatformModel_ForwardToCallback&) = delete;
  PageHandler_LoadPlatformModel_ForwardToCallback& operator=(const PageHandler_LoadPlatformModel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::LoadPlatformModelCallback callback_;
};

class PageHandler_GetDeviceAndPerformanceInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetDeviceAndPerformanceInfo_ForwardToCallback(
      PageHandler::GetDeviceAndPerformanceInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetDeviceAndPerformanceInfo_ForwardToCallback(const PageHandler_GetDeviceAndPerformanceInfo_ForwardToCallback&) = delete;
  PageHandler_GetDeviceAndPerformanceInfo_ForwardToCallback& operator=(const PageHandler_GetDeviceAndPerformanceInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetDeviceAndPerformanceInfoCallback callback_;
};

class PageHandler_GetDefaultModelPath_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetDefaultModelPath_ForwardToCallback(
      PageHandler::GetDefaultModelPathCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetDefaultModelPath_ForwardToCallback(const PageHandler_GetDefaultModelPath_ForwardToCallback&) = delete;
  PageHandler_GetDefaultModelPath_ForwardToCallback& operator=(const PageHandler_GetDefaultModelPath_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetDefaultModelPathCallback callback_;
};

class PageHandler_GetPageData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetPageData_ForwardToCallback(
      PageHandler::GetPageDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetPageData_ForwardToCallback(const PageHandler_GetPageData_ForwardToCallback&) = delete;
  PageHandler_GetPageData_ForwardToCallback& operator=(const PageHandler_GetPageData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetPageDataCallback callback_;
};

class PageHandler_DecodeBitmap_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_DecodeBitmap_ForwardToCallback(
      PageHandler::DecodeBitmapCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_DecodeBitmap_ForwardToCallback(const PageHandler_DecodeBitmap_ForwardToCallback&) = delete;
  PageHandler_DecodeBitmap_ForwardToCallback& operator=(const PageHandler_DecodeBitmap_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::DecodeBitmapCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::LoadModel(
    const ::base::FilePath& in_model_path, ::ml::ModelPerformanceHint in_performance_hint, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> in_model, LoadModelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_internals::mojom::PageHandler::LoadModel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model_path"), in_model_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("performance_hint"), in_performance_hint,
                        "<value of type ::ml::ModelPerformanceHint>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model"), in_model,
                        "<value of type ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kLoadModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_internals::mojom::internal::PageHandler_LoadModel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->model_path)::BaseType> model_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_model_path,
    model_path_fragment);

  params->model_path.Set(
      model_path_fragment.is_null() ? nullptr : model_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->model_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null model_path in PageHandler.LoadModel request");

  
  mojo::internal::Serialize<::on_device_model::mojom::ModelPerformanceHint>(
    in_performance_hint,
    &params->performance_hint);

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::on_device_model::mojom::OnDeviceModelInterfaceBase>>(
    in_model,
    &params->model,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->model)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid model in PageHandler.LoadModel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("LoadModel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_LoadModel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::LoadPlatformModel(
    const ::base::FilePath& in_model_path, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> in_model, LoadPlatformModelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_internals::mojom::PageHandler::LoadPlatformModel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model_path"), in_model_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model"), in_model,
                        "<value of type ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kLoadPlatformModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_internals::mojom::internal::PageHandler_LoadPlatformModel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->model_path)::BaseType> model_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_model_path,
    model_path_fragment);

  params->model_path.Set(
      model_path_fragment.is_null() ? nullptr : model_path_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->model_path.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null model_path in PageHandler.LoadPlatformModel request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::on_device_model::mojom::OnDeviceModelInterfaceBase>>(
    in_model,
    &params->model,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->model)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid model in PageHandler.LoadPlatformModel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("LoadPlatformModel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_LoadPlatformModel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetDeviceAndPerformanceInfo(
    GetDeviceAndPerformanceInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send on_device_internals::mojom::PageHandler::GetDeviceAndPerformanceInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetDeviceAndPerformanceInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_internals::mojom::internal::PageHandler_GetDeviceAndPerformanceInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetDeviceAndPerformanceInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetDeviceAndPerformanceInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetDefaultModelPath(
    GetDefaultModelPathCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send on_device_internals::mojom::PageHandler::GetDefaultModelPath");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetDefaultModelPath), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_internals::mojom::internal::PageHandler_GetDefaultModelPath_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetDefaultModelPath");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetDefaultModelPath_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetPageData(
    GetPageDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send on_device_internals::mojom::PageHandler::GetPageData");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetPageData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_internals::mojom::internal::PageHandler_GetPageData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetPageData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetPageData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::SetFeatureRecentlyUsedState(
    int32_t in_feature_key, bool in_is_recently_used) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_internals::mojom::PageHandler::SetFeatureRecentlyUsedState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("feature_key"), in_feature_key,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_recently_used"), in_is_recently_used,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetFeatureRecentlyUsedState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_internals::mojom::internal::PageHandler_SetFeatureRecentlyUsedState_Params_Data> params(
          message);
  params.Allocate();

  params->feature_key = in_feature_key;

  params->is_recently_used = in_is_recently_used;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetFeatureRecentlyUsedState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::DecodeBitmap(
    ::mojo_base::BigBuffer in_image_buffer, DecodeBitmapCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_internals::mojom::PageHandler::DecodeBitmap", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image_buffer"), in_image_buffer,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDecodeBitmap), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_internals::mojom::internal::PageHandler_DecodeBitmap_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->image_buffer)>
      image_buffer_fragment(params.message());
  image_buffer_fragment.Claim(&params->image_buffer);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_image_buffer,
    image_buffer_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->image_buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null image_buffer in PageHandler.DecodeBitmap request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DecodeBitmap");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_DecodeBitmap_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::ResetModelCrashCount(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send on_device_internals::mojom::PageHandler::ResetModelCrashCount");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kResetModelCrashCount), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_internals::mojom::internal::PageHandler_ResetModelCrashCount_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ResetModelCrashCount");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageHandler_LoadModel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::LoadModelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_LoadModel_ProxyToResponder> proxy(
        new PageHandler_LoadModel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_LoadModel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_LoadModel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_LoadModel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::LoadModelCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::on_device_model::mojom::LoadModelResult in_result, const ::on_device_model::Capabilities& in_capabilities);
};

bool PageHandler_LoadModel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_LoadModel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_LoadModel_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.0
  bool success = true;
  ::on_device_model::mojom::LoadModelResult p_result{};
  ::on_device_model::Capabilities p_capabilities{};
  PageHandler_LoadModel_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadCapabilities(&p_capabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_capabilities));
  }
  return true;
}

void PageHandler_LoadModel_ProxyToResponder::Run(
    ::on_device_model::mojom::LoadModelResult in_result, const ::on_device_model::Capabilities& in_capabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_internals::mojom::PageHandler::LoadModel", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::on_device_model::mojom::LoadModelResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capabilities"), in_capabilities,
                        "<value of type const ::on_device_model::Capabilities&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kLoadModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_internals::mojom::internal::PageHandler_LoadModel_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::on_device_model::mojom::LoadModelResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->capabilities)::BaseType> capabilities_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::CapabilitiesDataView>(
    in_capabilities,
    capabilities_fragment);

  params->capabilities.Set(
      capabilities_fragment.is_null() ? nullptr : capabilities_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->capabilities.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null capabilities in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("LoadModel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_LoadPlatformModel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::LoadPlatformModelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_LoadPlatformModel_ProxyToResponder> proxy(
        new PageHandler_LoadPlatformModel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_LoadPlatformModel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_LoadPlatformModel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_LoadPlatformModel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::LoadPlatformModelCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::on_device_model::mojom::LoadModelResult in_result);
};

bool PageHandler_LoadPlatformModel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_LoadPlatformModel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_LoadPlatformModel_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.1
  bool success = true;
  ::on_device_model::mojom::LoadModelResult p_result{};
  PageHandler_LoadPlatformModel_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void PageHandler_LoadPlatformModel_ProxyToResponder::Run(
    ::on_device_model::mojom::LoadModelResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_internals::mojom::PageHandler::LoadPlatformModel", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::on_device_model::mojom::LoadModelResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kLoadPlatformModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_internals::mojom::internal::PageHandler_LoadPlatformModel_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::on_device_model::mojom::LoadModelResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("LoadPlatformModel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetDeviceAndPerformanceInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetDeviceAndPerformanceInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetDeviceAndPerformanceInfo_ProxyToResponder> proxy(
        new PageHandler_GetDeviceAndPerformanceInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetDeviceAndPerformanceInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetDeviceAndPerformanceInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetDeviceAndPerformanceInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetDeviceAndPerformanceInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::on_device_model::mojom::DevicePerformanceInfoPtr in_performance_info, ::on_device_model::mojom::DeviceInfoPtr in_device_info);
};

bool PageHandler_GetDeviceAndPerformanceInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetDeviceAndPerformanceInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetDeviceAndPerformanceInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.2
  bool success = true;
  ::on_device_model::mojom::DevicePerformanceInfoPtr p_performance_info{};
  ::on_device_model::mojom::DeviceInfoPtr p_device_info{};
  PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPerformanceInfo(&p_performance_info))
    success = false;
  if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_performance_info), 
std::move(p_device_info));
  }
  return true;
}

void PageHandler_GetDeviceAndPerformanceInfo_ProxyToResponder::Run(
    ::on_device_model::mojom::DevicePerformanceInfoPtr in_performance_info, ::on_device_model::mojom::DeviceInfoPtr in_device_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_internals::mojom::PageHandler::GetDeviceAndPerformanceInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("performance_info"), in_performance_info,
                        "<value of type ::on_device_model::mojom::DevicePerformanceInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_info"), in_device_info,
                        "<value of type ::on_device_model::mojom::DeviceInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetDeviceAndPerformanceInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_internals::mojom::internal::PageHandler_GetDeviceAndPerformanceInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->performance_info)::BaseType> performance_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::DevicePerformanceInfoDataView>(
    in_performance_info,
    performance_info_fragment);

  params->performance_info.Set(
      performance_info_fragment.is_null() ? nullptr : performance_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->performance_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null performance_info in ");
  mojo::internal::MessageFragment<
      typename decltype(params->device_info)::BaseType> device_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_model::mojom::DeviceInfoDataView>(
    in_device_info,
    device_info_fragment);

  params->device_info.Set(
      device_info_fragment.is_null() ? nullptr : device_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetDeviceAndPerformanceInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetDefaultModelPath_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetDefaultModelPathCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetDefaultModelPath_ProxyToResponder> proxy(
        new PageHandler_GetDefaultModelPath_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetDefaultModelPath_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetDefaultModelPath_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetDefaultModelPath_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetDefaultModelPathCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::base::FilePath>& in_model_path);
};

bool PageHandler_GetDefaultModelPath_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetDefaultModelPath_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetDefaultModelPath_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.3
  bool success = true;
  std::optional<::base::FilePath> p_model_path{};
  PageHandler_GetDefaultModelPath_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadModelPath(&p_model_path))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_model_path));
  }
  return true;
}

void PageHandler_GetDefaultModelPath_ProxyToResponder::Run(
    const std::optional<::base::FilePath>& in_model_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_internals::mojom::PageHandler::GetDefaultModelPath", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("model_path"), in_model_path,
                        "<value of type const std::optional<::base::FilePath>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetDefaultModelPath), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_internals::mojom::internal::PageHandler_GetDefaultModelPath_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->model_path)::BaseType> model_path_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
    in_model_path,
    model_path_fragment);

  params->model_path.Set(
      model_path_fragment.is_null() ? nullptr : model_path_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetDefaultModelPath");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetPageData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetPageDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetPageData_ProxyToResponder> proxy(
        new PageHandler_GetPageData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetPageData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetPageData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetPageData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetPageDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PageDataPtr in_page_data);
};

bool PageHandler_GetPageData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetPageData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetPageData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.4
  bool success = true;
  PageDataPtr p_page_data{};
  PageHandler_GetPageData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPageData(&p_page_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_page_data));
  }
  return true;
}

void PageHandler_GetPageData_ProxyToResponder::Run(
    PageDataPtr in_page_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_internals::mojom::PageHandler::GetPageData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_data"), in_page_data,
                        "<value of type PageDataPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetPageData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_internals::mojom::internal::PageHandler_GetPageData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->page_data)::BaseType> page_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::on_device_internals::mojom::PageDataDataView>(
    in_page_data,
    page_data_fragment);

  params->page_data.Set(
      page_data_fragment.is_null() ? nullptr : page_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->page_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null page_data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetPageData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_DecodeBitmap_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::DecodeBitmapCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_DecodeBitmap_ProxyToResponder> proxy(
        new PageHandler_DecodeBitmap_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_DecodeBitmap_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_DecodeBitmap_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_DecodeBitmap_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::DecodeBitmapCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::SkBitmap& in_bitmap);
};

bool PageHandler_DecodeBitmap_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_DecodeBitmap_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_DecodeBitmap_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.6
  bool success = true;
  ::SkBitmap p_bitmap{};
  PageHandler_DecodeBitmap_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBitmap(&p_bitmap))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_bitmap));
  }
  return true;
}

void PageHandler_DecodeBitmap_ProxyToResponder::Run(
    const ::SkBitmap& in_bitmap) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply on_device_internals::mojom::PageHandler::DecodeBitmap", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bitmap"), in_bitmap,
                        "<value of type const ::SkBitmap&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDecodeBitmap), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_internals::mojom::internal::PageHandler_DecodeBitmap_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bitmap)::BaseType> bitmap_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::BitmapMappedFromTrustedProcessDataView>(
    in_bitmap,
    bitmap_fragment);

  params->bitmap.Set(
      bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DecodeBitmap");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kLoadModel: {
      break;
    }
    case messages::PageHandler::kLoadPlatformModel: {
      break;
    }
    case messages::PageHandler::kGetDeviceAndPerformanceInfo: {
      break;
    }
    case messages::PageHandler::kGetDefaultModelPath: {
      break;
    }
    case messages::PageHandler::kGetPageData: {
      break;
    }
    case messages::PageHandler::kSetFeatureRecentlyUsedState: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetFeatureRecentlyUsedState_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetFeatureRecentlyUsedState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      int32_t p_feature_key{};
      bool p_is_recently_used{};
      PageHandler_SetFeatureRecentlyUsedState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_feature_key = input_data_view.feature_key();
      if (success)
        p_is_recently_used = input_data_view.is_recently_used();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFeatureRecentlyUsedState(        
        std::move(p_feature_key), 
        std::move(p_is_recently_used));
      return true;
    }
    case messages::PageHandler::kDecodeBitmap: {
      break;
    }
    case messages::PageHandler::kResetModelCrashCount: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ResetModelCrashCount_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ResetModelCrashCount_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      PageHandler_ResetModelCrashCount_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetModelCrashCount(        );
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kLoadModel: {
      internal::PageHandler_LoadModel_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_LoadModel_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      ::base::FilePath p_model_path{};
      ::ml::ModelPerformanceHint p_performance_hint{};
      ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> p_model{};
      PageHandler_LoadModel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModelPath(&p_model_path))
        success = false;
      if (success && !input_data_view.ReadPerformanceHint(&p_performance_hint))
        success = false;
      if (success) {
        p_model =
            input_data_view.TakeModel<decltype(p_model)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PageHandler_LoadModel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadModel(        
        std::move(p_model_path), 
        std::move(p_performance_hint), 
        std::move(p_model), std::move(callback));
      return true;
    }
    case messages::PageHandler::kLoadPlatformModel: {
      internal::PageHandler_LoadPlatformModel_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_LoadPlatformModel_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      ::base::FilePath p_model_path{};
      ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> p_model{};
      PageHandler_LoadPlatformModel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModelPath(&p_model_path))
        success = false;
      if (success) {
        p_model =
            input_data_view.TakeModel<decltype(p_model)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          PageHandler_LoadPlatformModel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadPlatformModel(        
        std::move(p_model_path), 
        std::move(p_model), std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetDeviceAndPerformanceInfo: {
      internal::PageHandler_GetDeviceAndPerformanceInfo_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetDeviceAndPerformanceInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      PageHandler_GetDeviceAndPerformanceInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          PageHandler_GetDeviceAndPerformanceInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDeviceAndPerformanceInfo(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetDefaultModelPath: {
      internal::PageHandler_GetDefaultModelPath_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetDefaultModelPath_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      PageHandler_GetDefaultModelPath_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          PageHandler_GetDefaultModelPath_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDefaultModelPath(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetPageData: {
      internal::PageHandler_GetPageData_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetPageData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      PageHandler_GetPageData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          PageHandler_GetPageData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPageData(std::move(callback));
      return true;
    }
    case messages::PageHandler::kSetFeatureRecentlyUsedState: {
      break;
    }
    case messages::PageHandler::kDecodeBitmap: {
      internal::PageHandler_DecodeBitmap_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_DecodeBitmap_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      ::mojo_base::BigBuffer p_image_buffer{};
      PageHandler_DecodeBitmap_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadImageBuffer(&p_image_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      auto callback =
          PageHandler_DecodeBitmap_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DecodeBitmap(        
        std::move(p_image_buffer), std::move(callback));
      return true;
    }
    case messages::PageHandler::kResetModelCrashCount: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_LoadModel_Params_Data::Validate,
     &internal::PageHandler_LoadModel_ResponseParams_Data::Validate},
    { &internal::PageHandler_LoadPlatformModel_Params_Data::Validate,
     &internal::PageHandler_LoadPlatformModel_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetDeviceAndPerformanceInfo_Params_Data::Validate,
     &internal::PageHandler_GetDeviceAndPerformanceInfo_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetDefaultModelPath_Params_Data::Validate,
     &internal::PageHandler_GetDefaultModelPath_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetPageData_Params_Data::Validate,
     &internal::PageHandler_GetPageData_ResponseParams_Data::Validate},
    { &internal::PageHandler_SetFeatureRecentlyUsedState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_DecodeBitmap_Params_Data::Validate,
     &internal::PageHandler_DecodeBitmap_ResponseParams_Data::Validate},
    { &internal::PageHandler_ResetModelCrashCount_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::on_device_internals::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::on_device_internals::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kOnLogMessageAdded: {
      return &Page::OnLogMessageAdded_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnLogMessageAdded:
            return "Receive on_device_internals::mojom::Page::OnLogMessageAdded";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnLogMessageAdded:
            return "Receive reply on_device_internals::mojom::Page::OnLogMessageAdded";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::OnLogMessageAdded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x277d5118;  // IPCStableHash for on_device_internals::mojom::Page::OnLogMessageAdded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::OnLogMessageAdded(
    ::base::Time in_event_time, const std::string& in_source_file, int64_t in_source_line, const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send on_device_internals::mojom::Page::OnLogMessageAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_time"), in_event_time,
                        "<value of type ::base::Time>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_file"), in_source_file,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_line"), in_source_line,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnLogMessageAdded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::on_device_internals::mojom::internal::Page_OnLogMessageAdded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->event_time)::BaseType> event_time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
    in_event_time,
    event_time_fragment);

  params->event_time.Set(
      event_time_fragment.is_null() ? nullptr : event_time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->event_time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null event_time in Page.OnLogMessageAdded request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_file)::BaseType> source_file_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source_file,
    source_file_fragment);

  params->source_file.Set(
      source_file_fragment.is_null() ? nullptr : source_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_file in Page.OnLogMessageAdded request");

  params->source_line = in_source_line;
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in Page.OnLogMessageAdded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnLogMessageAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnLogMessageAdded: {
      DCHECK(message->is_serialized());
      internal::Page_OnLogMessageAdded_Params_Data* params =
          reinterpret_cast<internal::Page_OnLogMessageAdded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      ::base::Time p_event_time{};
      std::string p_source_file{};
      int64_t p_source_line{};
      std::string p_message{};
      Page_OnLogMessageAdded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEventTime(&p_event_time))
        success = false;
      if (success && !input_data_view.ReadSourceFile(&p_source_file))
        success = false;
      if (success)
        p_source_line = input_data_view.source_line();
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLogMessageAdded(        
        std::move(p_event_time), 
        std::move(p_source_file), 
        std::move(p_source_line), 
        std::move(p_message));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnLogMessageAdded: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_OnLogMessageAdded_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::on_device_internals::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // on_device_internals::mojom


namespace mojo {


// static
bool StructTraits<::on_device_internals::mojom::PageData::DataView, ::on_device_internals::mojom::PageDataPtr>::Read(
    ::on_device_internals::mojom::PageData::DataView input,
    ::on_device_internals::mojom::PageDataPtr* output) {
  bool success = true;
  ::on_device_internals::mojom::PageDataPtr result(::on_device_internals::mojom::PageData::New());
  
      if (success && !input.ReadBaseModel(&result->base_model))
        success = false;
      if (success && !input.ReadSuppModels(&result->supp_models))
        success = false;
      if (success)
        result->model_crash_count = input.model_crash_count();
      if (success)
        result->max_model_crash_count = input.max_model_crash_count();
      if (success && !input.ReadFeatureAdaptations(&result->feature_adaptations))
        success = false;
      if (success && !input.ReadPerformanceInfo(&result->performance_info))
        success = false;
      if (success)
        result->min_vram_mb = input.min_vram_mb();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_internals::mojom::BaseModelState::DataView, ::on_device_internals::mojom::BaseModelStatePtr>::Read(
    ::on_device_internals::mojom::BaseModelState::DataView input,
    ::on_device_internals::mojom::BaseModelStatePtr* output) {
  bool success = true;
  ::on_device_internals::mojom::BaseModelStatePtr result(::on_device_internals::mojom::BaseModelState::New());
  
      if (success && !input.ReadState(&result->state))
        success = false;
      if (success && !input.ReadRegistrationCriteria(&result->registration_criteria))
        success = false;
      if (success && !input.ReadInfo(&result->info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_internals::mojom::BaseModelInfo::DataView, ::on_device_internals::mojom::BaseModelInfoPtr>::Read(
    ::on_device_internals::mojom::BaseModelInfo::DataView input,
    ::on_device_internals::mojom::BaseModelInfoPtr* output) {
  bool success = true;
  ::on_device_internals::mojom::BaseModelInfoPtr result(::on_device_internals::mojom::BaseModelInfo::New());
  
      if (success && !input.ReadComponentVersion(&result->component_version))
        success = false;
      if (success && !input.ReadFilePath(&result->file_path))
        success = false;
      if (success)
        result->file_size = input.file_size();
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadVersion(&result->version))
        success = false;
      if (success && !input.ReadBackendType(&result->backend_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_internals::mojom::SupplementaryModelInfo::DataView, ::on_device_internals::mojom::SupplementaryModelInfoPtr>::Read(
    ::on_device_internals::mojom::SupplementaryModelInfo::DataView input,
    ::on_device_internals::mojom::SupplementaryModelInfoPtr* output) {
  bool success = true;
  ::on_device_internals::mojom::SupplementaryModelInfoPtr result(::on_device_internals::mojom::SupplementaryModelInfo::New());
  
      if (success && !input.ReadSuppModelName(&result->supp_model_name))
        success = false;
      if (success)
        result->is_ready = input.is_ready();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::on_device_internals::mojom::FeatureAdaptationInfo::DataView, ::on_device_internals::mojom::FeatureAdaptationInfoPtr>::Read(
    ::on_device_internals::mojom::FeatureAdaptationInfo::DataView input,
    ::on_device_internals::mojom::FeatureAdaptationInfoPtr* output) {
  bool success = true;
  ::on_device_internals::mojom::FeatureAdaptationInfoPtr result(::on_device_internals::mojom::FeatureAdaptationInfo::New());
  
      if (success && !input.ReadFeatureName(&result->feature_name))
        success = false;
      if (success)
        result->feature_key = input.feature_key();
      if (success)
        result->version = input.version();
      if (success)
        result->is_recently_used = input.is_recently_used();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace on_device_internals::mojom {


void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::LoadModel(const ::base::FilePath& model_path, ::ml::ModelPerformanceHint performance_hint, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, LoadModelCallback callback) {
  GetForwardingInterface()->LoadModel(
    std::move(model_path)
    , 
    std::move(performance_hint)
    , 
    std::move(model)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::LoadPlatformModel(const ::base::FilePath& model_path, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, LoadPlatformModelCallback callback) {
  GetForwardingInterface()->LoadPlatformModel(
    std::move(model_path)
    , 
    std::move(model)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::GetDeviceAndPerformanceInfo(GetDeviceAndPerformanceInfoCallback callback) {
  GetForwardingInterface()->GetDeviceAndPerformanceInfo(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetDefaultModelPath(GetDefaultModelPathCallback callback) {
  GetForwardingInterface()->GetDefaultModelPath(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetPageData(GetPageDataCallback callback) {
  GetForwardingInterface()->GetPageData(std::move(callback));
}
void PageHandlerInterceptorForTesting::SetFeatureRecentlyUsedState(int32_t feature_key, bool is_recently_used) {
  GetForwardingInterface()->SetFeatureRecentlyUsedState(
    std::move(feature_key)
    , 
    std::move(is_recently_used)
    );
}
void PageHandlerInterceptorForTesting::DecodeBitmap(::mojo_base::BigBuffer image_buffer, DecodeBitmapCallback callback) {
  GetForwardingInterface()->DecodeBitmap(
    std::move(image_buffer)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::ResetModelCrashCount() {
  GetForwardingInterface()->ResetModelCrashCount();
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::LoadModel(
    const ::base::FilePath& model_path, ::ml::ModelPerformanceHint performance_hint, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, ::on_device_model::mojom::LoadModelResult* out_result, ::on_device_model::Capabilities* out_capabilities) {
  base::RunLoop loop;
  proxy_->LoadModel(
      std::move(model_path),
      std::move(performance_hint),
      std::move(model),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::on_device_model::mojom::LoadModelResult* out_result
,
             ::on_device_model::Capabilities* out_capabilities
,
             ::on_device_model::mojom::LoadModelResult result,
             const ::on_device_model::Capabilities& capabilities) {*out_result = std::move(result);*out_capabilities = std::move(capabilities);
            loop->Quit();
          },
          &loop,
          out_result,
          out_capabilities));
  loop.Run();
}



void PageHandlerAsyncWaiter::LoadPlatformModel(
    const ::base::FilePath& model_path, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model, ::on_device_model::mojom::LoadModelResult* out_result) {
  base::RunLoop loop;
  proxy_->LoadPlatformModel(
      std::move(model_path),
      std::move(model),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::on_device_model::mojom::LoadModelResult* out_result
,
             ::on_device_model::mojom::LoadModelResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::on_device_model::mojom::LoadModelResult PageHandlerAsyncWaiter::LoadPlatformModel(
    const ::base::FilePath& model_path, ::mojo::PendingReceiver<::on_device_model::mojom::OnDeviceModel> model) {
  ::on_device_model::mojom::LoadModelResult async_wait_result;
  LoadPlatformModel(std::move(model_path),std::move(model),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetDeviceAndPerformanceInfo(
    ::on_device_model::mojom::DevicePerformanceInfoPtr* out_performance_info, ::on_device_model::mojom::DeviceInfoPtr* out_device_info) {
  base::RunLoop loop;
  proxy_->GetDeviceAndPerformanceInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::on_device_model::mojom::DevicePerformanceInfoPtr* out_performance_info
,
             ::on_device_model::mojom::DeviceInfoPtr* out_device_info
,
             ::on_device_model::mojom::DevicePerformanceInfoPtr performance_info,
             ::on_device_model::mojom::DeviceInfoPtr device_info) {*out_performance_info = std::move(performance_info);*out_device_info = std::move(device_info);
            loop->Quit();
          },
          &loop,
          out_performance_info,
          out_device_info));
  loop.Run();
}



void PageHandlerAsyncWaiter::GetDefaultModelPath(
    std::optional<::base::FilePath>* out_model_path) {
  base::RunLoop loop;
  proxy_->GetDefaultModelPath(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::base::FilePath>* out_model_path
,
             const std::optional<::base::FilePath>& model_path) {*out_model_path = std::move(model_path);
            loop->Quit();
          },
          &loop,
          out_model_path));
  loop.Run();
}

std::optional<::base::FilePath> PageHandlerAsyncWaiter::GetDefaultModelPath(
    ) {
  std::optional<::base::FilePath> async_wait_result;
  GetDefaultModelPath(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetPageData(
    PageDataPtr* out_page_data) {
  base::RunLoop loop;
  proxy_->GetPageData(
      base::BindOnce(
          [](base::RunLoop* loop,
             PageDataPtr* out_page_data
,
             PageDataPtr page_data) {*out_page_data = std::move(page_data);
            loop->Quit();
          },
          &loop,
          out_page_data));
  loop.Run();
}

PageDataPtr PageHandlerAsyncWaiter::GetPageData(
    ) {
  PageDataPtr async_wait_result;
  GetPageData(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::DecodeBitmap(
    ::mojo_base::BigBuffer image_buffer, ::SkBitmap* out_bitmap) {
  base::RunLoop loop;
  proxy_->DecodeBitmap(
      std::move(image_buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::SkBitmap* out_bitmap
,
             const ::SkBitmap& bitmap) {*out_bitmap = std::move(bitmap);
            loop->Quit();
          },
          &loop,
          out_bitmap));
  loop.Run();
}

::SkBitmap PageHandlerAsyncWaiter::DecodeBitmap(
    ::mojo_base::BigBuffer image_buffer) {
  ::SkBitmap async_wait_result;
  DecodeBitmap(std::move(image_buffer),&async_wait_result);
  return async_wait_result;
}




void PageInterceptorForTesting::OnLogMessageAdded(::base::Time event_time, const std::string& source_file, int64_t source_line, const std::string& message) {
  GetForwardingInterface()->OnLogMessageAdded(
    std::move(event_time)
    , 
    std::move(source_file)
    , 
    std::move(source_line)
    , 
    std::move(message)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // on_device_internals::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif