// chrome/browser/ui/webui/new_tab_page/ntp_promo/ntp_promo.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/new_tab_page/ntp_promo/ntp_promo.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/new_tab_page/ntp_promo/ntp_promo.mojom-params-data.h"
#include "chrome/browser/ui/webui/new_tab_page/ntp_promo/ntp_promo.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/new_tab_page/ntp_promo/ntp_promo.mojom-import-headers.h"
#include "chrome/browser/ui/webui/new_tab_page/ntp_promo/ntp_promo.mojom-test-utils.h"


namespace ntp_promo::mojom {
PromosShown::PromosShown()
    : eligible(),
      completed() {}

PromosShown::PromosShown(
    std::vector<std::string> eligible_in,
    std::vector<std::string> completed_in)
    : eligible(std::move(eligible_in)),
      completed(std::move(completed_in)) {}

PromosShown::~PromosShown() = default;

void PromosShown::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "eligible"), this->eligible,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "completed"), this->completed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PromosShown::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Promo::Promo()
    : id(),
      icon_name(),
      body_text(),
      button_text() {}

Promo::Promo(
    const std::string& id_in,
    const std::string& icon_name_in,
    const std::string& body_text_in,
    const std::string& button_text_in)
    : id(std::move(id_in)),
      icon_name(std::move(icon_name_in)),
      body_text(std::move(body_text_in)),
      button_text(std::move(button_text_in)) {}

Promo::~Promo() = default;

void Promo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon_name"), this->icon_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body_text"), this->body_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "button_text"), this->button_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Promo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

NtpPromoHandler::IPCStableHashFunction NtpPromoHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NtpPromoHandler>(message.name())) {
    case messages::NtpPromoHandler::kRequestPromos: {
      return &NtpPromoHandler::RequestPromos_Sym::IPCStableHash;
    }
    case messages::NtpPromoHandler::kOnPromosShown: {
      return &NtpPromoHandler::OnPromosShown_Sym::IPCStableHash;
    }
    case messages::NtpPromoHandler::kOnPromoClicked: {
      return &NtpPromoHandler::OnPromoClicked_Sym::IPCStableHash;
    }
    case messages::NtpPromoHandler::kSnoozeSetupList: {
      return &NtpPromoHandler::SnoozeSetupList_Sym::IPCStableHash;
    }
    case messages::NtpPromoHandler::kUnsnoozeSetupList: {
      return &NtpPromoHandler::UnsnoozeSetupList_Sym::IPCStableHash;
    }
    case messages::NtpPromoHandler::kDisableSetupList: {
      return &NtpPromoHandler::DisableSetupList_Sym::IPCStableHash;
    }
    case messages::NtpPromoHandler::kUndisableSetupList: {
      return &NtpPromoHandler::UndisableSetupList_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NtpPromoHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NtpPromoHandler>(message.name())) {
      case messages::NtpPromoHandler::kRequestPromos:
            return "Receive ntp_promo::mojom::NtpPromoHandler::RequestPromos";
      case messages::NtpPromoHandler::kOnPromosShown:
            return "Receive ntp_promo::mojom::NtpPromoHandler::OnPromosShown";
      case messages::NtpPromoHandler::kOnPromoClicked:
            return "Receive ntp_promo::mojom::NtpPromoHandler::OnPromoClicked";
      case messages::NtpPromoHandler::kSnoozeSetupList:
            return "Receive ntp_promo::mojom::NtpPromoHandler::SnoozeSetupList";
      case messages::NtpPromoHandler::kUnsnoozeSetupList:
            return "Receive ntp_promo::mojom::NtpPromoHandler::UnsnoozeSetupList";
      case messages::NtpPromoHandler::kDisableSetupList:
            return "Receive ntp_promo::mojom::NtpPromoHandler::DisableSetupList";
      case messages::NtpPromoHandler::kUndisableSetupList:
            return "Receive ntp_promo::mojom::NtpPromoHandler::UndisableSetupList";
    }
  } else {
    switch (static_cast<messages::NtpPromoHandler>(message.name())) {
      case messages::NtpPromoHandler::kRequestPromos:
            return "Receive reply ntp_promo::mojom::NtpPromoHandler::RequestPromos";
      case messages::NtpPromoHandler::kOnPromosShown:
            return "Receive reply ntp_promo::mojom::NtpPromoHandler::OnPromosShown";
      case messages::NtpPromoHandler::kOnPromoClicked:
            return "Receive reply ntp_promo::mojom::NtpPromoHandler::OnPromoClicked";
      case messages::NtpPromoHandler::kSnoozeSetupList:
            return "Receive reply ntp_promo::mojom::NtpPromoHandler::SnoozeSetupList";
      case messages::NtpPromoHandler::kUnsnoozeSetupList:
            return "Receive reply ntp_promo::mojom::NtpPromoHandler::UnsnoozeSetupList";
      case messages::NtpPromoHandler::kDisableSetupList:
            return "Receive reply ntp_promo::mojom::NtpPromoHandler::DisableSetupList";
      case messages::NtpPromoHandler::kUndisableSetupList:
            return "Receive reply ntp_promo::mojom::NtpPromoHandler::UndisableSetupList";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NtpPromoHandler::RequestPromos_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4efe5a22;  // IPCStableHash for ntp_promo::mojom::NtpPromoHandler::RequestPromos
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NtpPromoHandler::OnPromosShown_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x55023bcb;  // IPCStableHash for ntp_promo::mojom::NtpPromoHandler::OnPromosShown
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NtpPromoHandler::OnPromoClicked_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa2abf1c0;  // IPCStableHash for ntp_promo::mojom::NtpPromoHandler::OnPromoClicked
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NtpPromoHandler::SnoozeSetupList_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb74f6137;  // IPCStableHash for ntp_promo::mojom::NtpPromoHandler::SnoozeSetupList
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NtpPromoHandler::UnsnoozeSetupList_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x55b3372e;  // IPCStableHash for ntp_promo::mojom::NtpPromoHandler::UnsnoozeSetupList
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NtpPromoHandler::DisableSetupList_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4acbed1b;  // IPCStableHash for ntp_promo::mojom::NtpPromoHandler::DisableSetupList
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NtpPromoHandler::UndisableSetupList_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbc506f1f;  // IPCStableHash for ntp_promo::mojom::NtpPromoHandler::UndisableSetupList
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NtpPromoHandlerProxy::NtpPromoHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NtpPromoHandlerProxy::RequestPromos(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ntp_promo::mojom::NtpPromoHandler::RequestPromos");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NtpPromoHandler::kRequestPromos), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp_promo::mojom::internal::NtpPromoHandler_RequestPromos_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NtpPromoHandler::Name_);
  message.set_method_name("RequestPromos");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NtpPromoHandlerProxy::OnPromosShown(
    const std::vector<std::string>& in_eligible_shown, const std::vector<std::string>& in_completed_shown) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ntp_promo::mojom::NtpPromoHandler::OnPromosShown", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("eligible_shown"), in_eligible_shown,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("completed_shown"), in_completed_shown,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NtpPromoHandler::kOnPromosShown), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp_promo::mojom::internal::NtpPromoHandler_OnPromosShown_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->eligible_shown)::BaseType>
      eligible_shown_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& eligible_shown_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_eligible_shown,
    eligible_shown_fragment,
    &eligible_shown_validate_params);

  params->eligible_shown.Set(
      eligible_shown_fragment.is_null() ? nullptr : eligible_shown_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->eligible_shown.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null eligible_shown in NtpPromoHandler.OnPromosShown request");
  mojo::internal::MessageFragment<
      typename decltype(params->completed_shown)::BaseType>
      completed_shown_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& completed_shown_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_completed_shown,
    completed_shown_fragment,
    &completed_shown_validate_params);

  params->completed_shown.Set(
      completed_shown_fragment.is_null() ? nullptr : completed_shown_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->completed_shown.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null completed_shown in NtpPromoHandler.OnPromosShown request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NtpPromoHandler::Name_);
  message.set_method_name("OnPromosShown");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NtpPromoHandlerProxy::OnPromoClicked(
    const std::string& in_promo_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ntp_promo::mojom::NtpPromoHandler::OnPromoClicked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("promo_id"), in_promo_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NtpPromoHandler::kOnPromoClicked), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp_promo::mojom::internal::NtpPromoHandler_OnPromoClicked_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->promo_id)::BaseType> promo_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_promo_id,
    promo_id_fragment);

  params->promo_id.Set(
      promo_id_fragment.is_null() ? nullptr : promo_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->promo_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null promo_id in NtpPromoHandler.OnPromoClicked request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NtpPromoHandler::Name_);
  message.set_method_name("OnPromoClicked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NtpPromoHandlerProxy::SnoozeSetupList(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ntp_promo::mojom::NtpPromoHandler::SnoozeSetupList");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NtpPromoHandler::kSnoozeSetupList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp_promo::mojom::internal::NtpPromoHandler_SnoozeSetupList_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NtpPromoHandler::Name_);
  message.set_method_name("SnoozeSetupList");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NtpPromoHandlerProxy::UnsnoozeSetupList(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ntp_promo::mojom::NtpPromoHandler::UnsnoozeSetupList");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NtpPromoHandler::kUnsnoozeSetupList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp_promo::mojom::internal::NtpPromoHandler_UnsnoozeSetupList_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NtpPromoHandler::Name_);
  message.set_method_name("UnsnoozeSetupList");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NtpPromoHandlerProxy::DisableSetupList(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ntp_promo::mojom::NtpPromoHandler::DisableSetupList");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NtpPromoHandler::kDisableSetupList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp_promo::mojom::internal::NtpPromoHandler_DisableSetupList_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NtpPromoHandler::Name_);
  message.set_method_name("DisableSetupList");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NtpPromoHandlerProxy::UndisableSetupList(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ntp_promo::mojom::NtpPromoHandler::UndisableSetupList");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NtpPromoHandler::kUndisableSetupList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp_promo::mojom::internal::NtpPromoHandler_UndisableSetupList_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NtpPromoHandler::Name_);
  message.set_method_name("UndisableSetupList");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NtpPromoHandlerStubDispatch::Accept(
    NtpPromoHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NtpPromoHandler>(message->header()->name)) {
    case messages::NtpPromoHandler::kRequestPromos: {
      DCHECK(message->is_serialized());
      internal::NtpPromoHandler_RequestPromos_Params_Data* params =
          reinterpret_cast<internal::NtpPromoHandler_RequestPromos_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NtpPromoHandler.0
      bool success = true;
      NtpPromoHandler_RequestPromos_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NtpPromoHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestPromos(        );
      return true;
    }
    case messages::NtpPromoHandler::kOnPromosShown: {
      DCHECK(message->is_serialized());
      internal::NtpPromoHandler_OnPromosShown_Params_Data* params =
          reinterpret_cast<internal::NtpPromoHandler_OnPromosShown_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NtpPromoHandler.1
      bool success = true;
      std::vector<std::string> p_eligible_shown{};
      std::vector<std::string> p_completed_shown{};
      NtpPromoHandler_OnPromosShown_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEligibleShown(&p_eligible_shown))
        success = false;
      if (success && !input_data_view.ReadCompletedShown(&p_completed_shown))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NtpPromoHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPromosShown(        
        std::move(p_eligible_shown), 
        std::move(p_completed_shown));
      return true;
    }
    case messages::NtpPromoHandler::kOnPromoClicked: {
      DCHECK(message->is_serialized());
      internal::NtpPromoHandler_OnPromoClicked_Params_Data* params =
          reinterpret_cast<internal::NtpPromoHandler_OnPromoClicked_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NtpPromoHandler.2
      bool success = true;
      std::string p_promo_id{};
      NtpPromoHandler_OnPromoClicked_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPromoId(&p_promo_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NtpPromoHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPromoClicked(        
        std::move(p_promo_id));
      return true;
    }
    case messages::NtpPromoHandler::kSnoozeSetupList: {
      DCHECK(message->is_serialized());
      internal::NtpPromoHandler_SnoozeSetupList_Params_Data* params =
          reinterpret_cast<internal::NtpPromoHandler_SnoozeSetupList_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NtpPromoHandler.3
      bool success = true;
      NtpPromoHandler_SnoozeSetupList_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NtpPromoHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SnoozeSetupList(        );
      return true;
    }
    case messages::NtpPromoHandler::kUnsnoozeSetupList: {
      DCHECK(message->is_serialized());
      internal::NtpPromoHandler_UnsnoozeSetupList_Params_Data* params =
          reinterpret_cast<internal::NtpPromoHandler_UnsnoozeSetupList_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NtpPromoHandler.4
      bool success = true;
      NtpPromoHandler_UnsnoozeSetupList_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NtpPromoHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnsnoozeSetupList(        );
      return true;
    }
    case messages::NtpPromoHandler::kDisableSetupList: {
      DCHECK(message->is_serialized());
      internal::NtpPromoHandler_DisableSetupList_Params_Data* params =
          reinterpret_cast<internal::NtpPromoHandler_DisableSetupList_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NtpPromoHandler.5
      bool success = true;
      NtpPromoHandler_DisableSetupList_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NtpPromoHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableSetupList(        );
      return true;
    }
    case messages::NtpPromoHandler::kUndisableSetupList: {
      DCHECK(message->is_serialized());
      internal::NtpPromoHandler_UndisableSetupList_Params_Data* params =
          reinterpret_cast<internal::NtpPromoHandler_UndisableSetupList_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NtpPromoHandler.6
      bool success = true;
      NtpPromoHandler_UndisableSetupList_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NtpPromoHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UndisableSetupList(        );
      return true;
    }
  }
  return false;
}

// static
bool NtpPromoHandlerStubDispatch::AcceptWithResponder(
    NtpPromoHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NtpPromoHandler>(message->header()->name)) {
    case messages::NtpPromoHandler::kRequestPromos: {
      break;
    }
    case messages::NtpPromoHandler::kOnPromosShown: {
      break;
    }
    case messages::NtpPromoHandler::kOnPromoClicked: {
      break;
    }
    case messages::NtpPromoHandler::kSnoozeSetupList: {
      break;
    }
    case messages::NtpPromoHandler::kUnsnoozeSetupList: {
      break;
    }
    case messages::NtpPromoHandler::kDisableSetupList: {
      break;
    }
    case messages::NtpPromoHandler::kUndisableSetupList: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNtpPromoHandlerValidationInfo[] = {
    { &internal::NtpPromoHandler_RequestPromos_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NtpPromoHandler_OnPromosShown_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NtpPromoHandler_OnPromoClicked_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NtpPromoHandler_SnoozeSetupList_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NtpPromoHandler_UnsnoozeSetupList_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NtpPromoHandler_DisableSetupList_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NtpPromoHandler_UndisableSetupList_Params_Data::Validate,
     nullptr /* no response */},
};

bool NtpPromoHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::ntp_promo::mojom::NtpPromoHandler::Name_,
    kNtpPromoHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

NtpPromoClient::IPCStableHashFunction NtpPromoClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NtpPromoClient>(message.name())) {
    case messages::NtpPromoClient::kSetPromos: {
      return &NtpPromoClient::SetPromos_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NtpPromoClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NtpPromoClient>(message.name())) {
      case messages::NtpPromoClient::kSetPromos:
            return "Receive ntp_promo::mojom::NtpPromoClient::SetPromos";
    }
  } else {
    switch (static_cast<messages::NtpPromoClient>(message.name())) {
      case messages::NtpPromoClient::kSetPromos:
            return "Receive reply ntp_promo::mojom::NtpPromoClient::SetPromos";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NtpPromoClient::SetPromos_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfdc72c61;  // IPCStableHash for ntp_promo::mojom::NtpPromoClient::SetPromos
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NtpPromoClientProxy::NtpPromoClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NtpPromoClientProxy::SetPromos(
    const std::vector<::user_education::NtpShowablePromo>& in_eligible, const std::vector<::user_education::NtpShowablePromo>& in_completed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ntp_promo::mojom::NtpPromoClient::SetPromos", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("eligible"), in_eligible,
                        "<value of type const std::vector<::user_education::NtpShowablePromo>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("completed"), in_completed,
                        "<value of type const std::vector<::user_education::NtpShowablePromo>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NtpPromoClient::kSetPromos), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp_promo::mojom::internal::NtpPromoClient_SetPromos_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->eligible)::BaseType>
      eligible_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& eligible_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ntp_promo::mojom::PromoDataView>>(
    in_eligible,
    eligible_fragment,
    &eligible_validate_params);

  params->eligible.Set(
      eligible_fragment.is_null() ? nullptr : eligible_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->eligible.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null eligible in NtpPromoClient.SetPromos request");
  mojo::internal::MessageFragment<
      typename decltype(params->completed)::BaseType>
      completed_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& completed_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::ntp_promo::mojom::PromoDataView>>(
    in_completed,
    completed_fragment,
    &completed_validate_params);

  params->completed.Set(
      completed_fragment.is_null() ? nullptr : completed_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->completed.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null completed in NtpPromoClient.SetPromos request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NtpPromoClient::Name_);
  message.set_method_name("SetPromos");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NtpPromoClientStubDispatch::Accept(
    NtpPromoClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NtpPromoClient>(message->header()->name)) {
    case messages::NtpPromoClient::kSetPromos: {
      DCHECK(message->is_serialized());
      internal::NtpPromoClient_SetPromos_Params_Data* params =
          reinterpret_cast<internal::NtpPromoClient_SetPromos_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NtpPromoClient.0
      bool success = true;
      std::vector<::user_education::NtpShowablePromo> p_eligible{};
      std::vector<::user_education::NtpShowablePromo> p_completed{};
      NtpPromoClient_SetPromos_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEligible(&p_eligible))
        success = false;
      if (success && !input_data_view.ReadCompleted(&p_completed))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NtpPromoClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPromos(        
        std::move(p_eligible), 
        std::move(p_completed));
      return true;
    }
  }
  return false;
}

// static
bool NtpPromoClientStubDispatch::AcceptWithResponder(
    NtpPromoClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NtpPromoClient>(message->header()->name)) {
    case messages::NtpPromoClient::kSetPromos: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNtpPromoClientValidationInfo[] = {
    { &internal::NtpPromoClient_SetPromos_Params_Data::Validate,
     nullptr /* no response */},
};

bool NtpPromoClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::ntp_promo::mojom::NtpPromoClient::Name_,
    kNtpPromoClientValidationInfo);
}

// The declaration includes the definition on other builds.

NtpPromoHandlerFactory::IPCStableHashFunction NtpPromoHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NtpPromoHandlerFactory>(message.name())) {
    case messages::NtpPromoHandlerFactory::kCreateNtpPromoHandler: {
      return &NtpPromoHandlerFactory::CreateNtpPromoHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NtpPromoHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NtpPromoHandlerFactory>(message.name())) {
      case messages::NtpPromoHandlerFactory::kCreateNtpPromoHandler:
            return "Receive ntp_promo::mojom::NtpPromoHandlerFactory::CreateNtpPromoHandler";
    }
  } else {
    switch (static_cast<messages::NtpPromoHandlerFactory>(message.name())) {
      case messages::NtpPromoHandlerFactory::kCreateNtpPromoHandler:
            return "Receive reply ntp_promo::mojom::NtpPromoHandlerFactory::CreateNtpPromoHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NtpPromoHandlerFactory::CreateNtpPromoHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x00892f7c;  // IPCStableHash for ntp_promo::mojom::NtpPromoHandlerFactory::CreateNtpPromoHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NtpPromoHandlerFactoryProxy::NtpPromoHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NtpPromoHandlerFactoryProxy::CreateNtpPromoHandler(
    ::mojo::PendingRemote<NtpPromoClient> in_client, ::mojo::PendingReceiver<NtpPromoHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ntp_promo::mojom::NtpPromoHandlerFactory::CreateNtpPromoHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<NtpPromoClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<NtpPromoHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NtpPromoHandlerFactory::kCreateNtpPromoHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ntp_promo::mojom::internal::NtpPromoHandlerFactory_CreateNtpPromoHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::ntp_promo::mojom::NtpPromoClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in NtpPromoHandlerFactory.CreateNtpPromoHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::ntp_promo::mojom::NtpPromoHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in NtpPromoHandlerFactory.CreateNtpPromoHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NtpPromoHandlerFactory::Name_);
  message.set_method_name("CreateNtpPromoHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NtpPromoHandlerFactoryStubDispatch::Accept(
    NtpPromoHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NtpPromoHandlerFactory>(message->header()->name)) {
    case messages::NtpPromoHandlerFactory::kCreateNtpPromoHandler: {
      DCHECK(message->is_serialized());
      internal::NtpPromoHandlerFactory_CreateNtpPromoHandler_Params_Data* params =
          reinterpret_cast<internal::NtpPromoHandlerFactory_CreateNtpPromoHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NtpPromoHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<NtpPromoClient> p_client{};
      ::mojo::PendingReceiver<NtpPromoHandler> p_handler{};
      NtpPromoHandlerFactory_CreateNtpPromoHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NtpPromoHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNtpPromoHandler(        
        std::move(p_client), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool NtpPromoHandlerFactoryStubDispatch::AcceptWithResponder(
    NtpPromoHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NtpPromoHandlerFactory>(message->header()->name)) {
    case messages::NtpPromoHandlerFactory::kCreateNtpPromoHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNtpPromoHandlerFactoryValidationInfo[] = {
    { &internal::NtpPromoHandlerFactory_CreateNtpPromoHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool NtpPromoHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::ntp_promo::mojom::NtpPromoHandlerFactory::Name_,
    kNtpPromoHandlerFactoryValidationInfo);
}



}  // ntp_promo::mojom


namespace mojo {


// static
bool StructTraits<::ntp_promo::mojom::PromosShown::DataView, ::ntp_promo::mojom::PromosShownPtr>::Read(
    ::ntp_promo::mojom::PromosShown::DataView input,
    ::ntp_promo::mojom::PromosShownPtr* output) {
  bool success = true;
  ::ntp_promo::mojom::PromosShownPtr result(::ntp_promo::mojom::PromosShown::New());
  
      if (success && !input.ReadEligible(&result->eligible))
        success = false;
      if (success && !input.ReadCompleted(&result->completed))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ntp_promo::mojom::Promo::DataView, ::ntp_promo::mojom::PromoPtr>::Read(
    ::ntp_promo::mojom::Promo::DataView input,
    ::ntp_promo::mojom::PromoPtr* output) {
  bool success = true;
  ::ntp_promo::mojom::PromoPtr result(::ntp_promo::mojom::Promo::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadIconName(&result->icon_name))
        success = false;
      if (success && !input.ReadBodyText(&result->body_text))
        success = false;
      if (success && !input.ReadButtonText(&result->button_text))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ntp_promo::mojom {


void NtpPromoHandlerInterceptorForTesting::RequestPromos() {
  GetForwardingInterface()->RequestPromos();
}
void NtpPromoHandlerInterceptorForTesting::OnPromosShown(const std::vector<std::string>& eligible_shown, const std::vector<std::string>& completed_shown) {
  GetForwardingInterface()->OnPromosShown(
    std::move(eligible_shown)
    , 
    std::move(completed_shown)
    );
}
void NtpPromoHandlerInterceptorForTesting::OnPromoClicked(const std::string& promo_id) {
  GetForwardingInterface()->OnPromoClicked(
    std::move(promo_id)
    );
}
void NtpPromoHandlerInterceptorForTesting::SnoozeSetupList() {
  GetForwardingInterface()->SnoozeSetupList();
}
void NtpPromoHandlerInterceptorForTesting::UnsnoozeSetupList() {
  GetForwardingInterface()->UnsnoozeSetupList();
}
void NtpPromoHandlerInterceptorForTesting::DisableSetupList() {
  GetForwardingInterface()->DisableSetupList();
}
void NtpPromoHandlerInterceptorForTesting::UndisableSetupList() {
  GetForwardingInterface()->UndisableSetupList();
}
NtpPromoHandlerAsyncWaiter::NtpPromoHandlerAsyncWaiter(
    NtpPromoHandler* proxy) : proxy_(proxy) {}

NtpPromoHandlerAsyncWaiter::~NtpPromoHandlerAsyncWaiter() = default;





void NtpPromoClientInterceptorForTesting::SetPromos(const std::vector<::user_education::NtpShowablePromo>& eligible, const std::vector<::user_education::NtpShowablePromo>& completed) {
  GetForwardingInterface()->SetPromos(
    std::move(eligible)
    , 
    std::move(completed)
    );
}
NtpPromoClientAsyncWaiter::NtpPromoClientAsyncWaiter(
    NtpPromoClient* proxy) : proxy_(proxy) {}

NtpPromoClientAsyncWaiter::~NtpPromoClientAsyncWaiter() = default;





void NtpPromoHandlerFactoryInterceptorForTesting::CreateNtpPromoHandler(::mojo::PendingRemote<NtpPromoClient> client, ::mojo::PendingReceiver<NtpPromoHandler> handler) {
  GetForwardingInterface()->CreateNtpPromoHandler(
    std::move(client)
    , 
    std::move(handler)
    );
}
NtpPromoHandlerFactoryAsyncWaiter::NtpPromoHandlerFactoryAsyncWaiter(
    NtpPromoHandlerFactory* proxy) : proxy_(proxy) {}

NtpPromoHandlerFactoryAsyncWaiter::~NtpPromoHandlerFactoryAsyncWaiter() = default;







}  // ntp_promo::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif