// chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  MicrosoftAuthUntrustedDocumentRemote as newTabPage_mojom_MicrosoftAuthUntrustedDocumentRemote
} from './ntp_microsoft_auth_shared_ui.mojom-webui.js';
import {
  TileTypeSpec as ntpTiles_mojom_TileTypeSpec,
  TileType as ntpTiles_mojom_TileType
} from './tile_type.mojom-webui.js';
import {
  MostVisitedThemeSpec as mostVisited_mojom_MostVisitedThemeSpec,
  MostVisitedTheme as mostVisited_mojom_MostVisitedTheme
} from '//resources/cr_components/most_visited/most_visited.mojom-webui.js';
import {
  SkColorSpec as skia_mojom_SkColorSpec,
  SkColor as skia_mojom_SkColor
} from '//resources/mojo/skia/public/mojom/skcolor.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const NtpBackgroundImageSourceSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum NtpBackgroundImageSource {

  MIN_VALUE = 0,
  MAX_VALUE = 6,
  kNoImage = 0,
  kFirstPartyThemeWithoutDailyRefresh = 1,
  kFirstPartyThemeWithDailyRefresh = 2,
  kThirdPartyTheme = 3,
  kUploadedImage = 4,
  kWallpaperSearch = 5,
  kWallpaperSearchInspiration = 6,
}

export const IphFeatureSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum IphFeature {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kCustomizeChrome = 0,
  kCustomizeModules = 1,
}

export const DoodleImageTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum DoodleImageType {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kAnimation = 0,
  kCta = 1,
  kStatic = 2,
}

export const DoodleShareChannelSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum DoodleShareChannel {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kFacebook = 0,
  kTwitter = 1,
  kEmail = 2,
  kLinkCopy = 3,
}

export const CustomizeDialogActionSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum CustomizeDialogAction {

  MIN_VALUE = 0,
  MAX_VALUE = 11,
  kCancelClicked = 0,
  kDoneClicked = 1,
  kOpenClicked = 2,
  kBackgroundsBackClicked = 3,
  kBackgroundsNoBackgroundSelected = 4,
  kBackgroundsCollectionOpened = 5,
  kBackgroundsRefreshToggleClicked = 6,
  kBackgroundsImageSelected = 7,
  kBackgroundsUploadFromDeviceClicked = 8,
  kShortcutsCustomLinksClicked = 9,
  kShortcutsMostVisitedClicked = 10,
  kShortcutsVisibilityToggleClicked = 11,
}

export const OptInStatusSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum OptInStatus {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kExplicitOptIn = 0,
  kImplicitOptIn = 1,
  kOptOut = 2,
}



export type PageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;

export class PageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'new_tab_page.mojom.PageHandlerFactory',
        scope);
  }
}

export interface PageHandlerFactoryInterface {
  createPageHandler(page: PageRemote, handler: PageHandlerPendingReceiver): void;
}

export class PageHandlerFactoryRemote implements PageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: PageRemote,
      handler: PageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  static get $interfaceName(): string {
    return "new_tab_page.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerFactoryRemote {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerFactoryRemote, PageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'new_tab_page.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  setMostVisitedSettings(shortcutsType: ntpTiles_mojom_TileType, shortcutsVisible: boolean): void;
  getMostVisitedSettings(): Promise<{
        shortcutsType: ntpTiles_mojom_TileType,
        shortcutsVisible: boolean, }>;
  getDoodle(): Promise<{
        doodle: (Doodle | null), }>;
  updatePromoData(): void;
  blocklistPromo(promoId: string): void;
  undoBlocklistPromo(promoId: string): void;
  onDismissModule(moduleId: string): void;
  onRestoreModule(moduleId: string): void;
  setModulesVisible(visible: boolean): void;
  setModuleDisabled(moduleId: string, disabled: boolean): void;
  updateDisabledModules(): void;
  onModulesLoadedWithData(moduleIds: string[]): void;
  onModuleUsed(moduleId: string): void;
  getModulesIdNames(): Promise<{
        data: ModuleIdName[], }>;
  setModulesOrder(moduleIds: string[]): void;
  getModulesOrder(): Promise<{
        moduleIds: string[], }>;
  updateModulesLoadable(): void;
  updateFooterVisibility(): void;
  maybeShowFeaturePromo(iphFeature: IphFeature): void;
  incrementComposeButtonShownCount(): void;
  onOneGoogleBarRendered(time: number): void;
  onPromoRendered(time: number, logUrl: (url_mojom_Url | null)): void;
  onCustomizeDialogAction(action: CustomizeDialogAction): void;
  onDoodleImageClicked(type: DoodleImageType, logUrl: (url_mojom_Url | null)): void;
  onDoodleImageRendered(type: DoodleImageType, time: number, logUrl: url_mojom_Url): Promise<{
        imageClickParams: (string | null),
        interactionLogUrl: (url_mojom_Url | null),
        shareId: (string | null), }>;
  onDoodleShared(channel: DoodleShareChannel, doodleId: string, shareId: (string | null)): void;
  onPromoLinkClicked(): void;
  onAppRendered(time: number): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setMostVisitedSettings(
      shortcutsType: ntpTiles_mojom_TileType,
      shortcutsVisible: boolean): void {
    this.proxy.sendMessage(
        0,
        PageHandler_SetMostVisitedSettings_ParamsSpec.$,
        null,
        [
          shortcutsType,
          shortcutsVisible
        ],
        false);
  }

  getMostVisitedSettings(): Promise<{
        shortcutsType: ntpTiles_mojom_TileType,
        shortcutsVisible: boolean, }> {
    return this.proxy.sendMessage(
        1,
        PageHandler_GetMostVisitedSettings_ParamsSpec.$,
        PageHandler_GetMostVisitedSettings_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getDoodle(): Promise<{
        doodle: (Doodle | null), }> {
    return this.proxy.sendMessage(
        2,
        PageHandler_GetDoodle_ParamsSpec.$,
        PageHandler_GetDoodle_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  updatePromoData(): void {
    this.proxy.sendMessage(
        3,
        PageHandler_UpdatePromoData_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  blocklistPromo(
      promoId: string): void {
    this.proxy.sendMessage(
        4,
        PageHandler_BlocklistPromo_ParamsSpec.$,
        null,
        [
          promoId
        ],
        false);
  }

  undoBlocklistPromo(
      promoId: string): void {
    this.proxy.sendMessage(
        5,
        PageHandler_UndoBlocklistPromo_ParamsSpec.$,
        null,
        [
          promoId
        ],
        false);
  }

  onDismissModule(
      moduleId: string): void {
    this.proxy.sendMessage(
        6,
        PageHandler_OnDismissModule_ParamsSpec.$,
        null,
        [
          moduleId
        ],
        false);
  }

  onRestoreModule(
      moduleId: string): void {
    this.proxy.sendMessage(
        7,
        PageHandler_OnRestoreModule_ParamsSpec.$,
        null,
        [
          moduleId
        ],
        false);
  }

  setModulesVisible(
      visible: boolean): void {
    this.proxy.sendMessage(
        8,
        PageHandler_SetModulesVisible_ParamsSpec.$,
        null,
        [
          visible
        ],
        false);
  }

  setModuleDisabled(
      moduleId: string,
      disabled: boolean): void {
    this.proxy.sendMessage(
        9,
        PageHandler_SetModuleDisabled_ParamsSpec.$,
        null,
        [
          moduleId,
          disabled
        ],
        false);
  }

  updateDisabledModules(): void {
    this.proxy.sendMessage(
        10,
        PageHandler_UpdateDisabledModules_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onModulesLoadedWithData(
      moduleIds: string[]): void {
    this.proxy.sendMessage(
        11,
        PageHandler_OnModulesLoadedWithData_ParamsSpec.$,
        null,
        [
          moduleIds
        ],
        false);
  }

  onModuleUsed(
      moduleId: string): void {
    this.proxy.sendMessage(
        12,
        PageHandler_OnModuleUsed_ParamsSpec.$,
        null,
        [
          moduleId
        ],
        false);
  }

  getModulesIdNames(): Promise<{
        data: ModuleIdName[], }> {
    return this.proxy.sendMessage(
        13,
        PageHandler_GetModulesIdNames_ParamsSpec.$,
        PageHandler_GetModulesIdNames_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  setModulesOrder(
      moduleIds: string[]): void {
    this.proxy.sendMessage(
        14,
        PageHandler_SetModulesOrder_ParamsSpec.$,
        null,
        [
          moduleIds
        ],
        false);
  }

  getModulesOrder(): Promise<{
        moduleIds: string[], }> {
    return this.proxy.sendMessage(
        15,
        PageHandler_GetModulesOrder_ParamsSpec.$,
        PageHandler_GetModulesOrder_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  updateModulesLoadable(): void {
    this.proxy.sendMessage(
        16,
        PageHandler_UpdateModulesLoadable_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  updateFooterVisibility(): void {
    this.proxy.sendMessage(
        17,
        PageHandler_UpdateFooterVisibility_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  maybeShowFeaturePromo(
      iphFeature: IphFeature): void {
    this.proxy.sendMessage(
        18,
        PageHandler_MaybeShowFeaturePromo_ParamsSpec.$,
        null,
        [
          iphFeature
        ],
        false);
  }

  incrementComposeButtonShownCount(): void {
    this.proxy.sendMessage(
        19,
        PageHandler_IncrementComposeButtonShownCount_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onOneGoogleBarRendered(
      time: number): void {
    this.proxy.sendMessage(
        20,
        PageHandler_OnOneGoogleBarRendered_ParamsSpec.$,
        null,
        [
          time
        ],
        false);
  }

  onPromoRendered(
      time: number,
      logUrl: (url_mojom_Url | null)): void {
    this.proxy.sendMessage(
        21,
        PageHandler_OnPromoRendered_ParamsSpec.$,
        null,
        [
          time,
          logUrl
        ],
        false);
  }

  onCustomizeDialogAction(
      action: CustomizeDialogAction): void {
    this.proxy.sendMessage(
        22,
        PageHandler_OnCustomizeDialogAction_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }

  onDoodleImageClicked(
      type: DoodleImageType,
      logUrl: (url_mojom_Url | null)): void {
    this.proxy.sendMessage(
        23,
        PageHandler_OnDoodleImageClicked_ParamsSpec.$,
        null,
        [
          type,
          logUrl
        ],
        false);
  }

  onDoodleImageRendered(
      type: DoodleImageType,
      time: number,
      logUrl: url_mojom_Url): Promise<{
        imageClickParams: (string | null),
        interactionLogUrl: (url_mojom_Url | null),
        shareId: (string | null), }> {
    return this.proxy.sendMessage(
        24,
        PageHandler_OnDoodleImageRendered_ParamsSpec.$,
        PageHandler_OnDoodleImageRendered_ResponseParamsSpec.$,
        [
          type,
          time,
          logUrl
        ],
        false);
  }

  onDoodleShared(
      channel: DoodleShareChannel,
      doodleId: string,
      shareId: (string | null)): void {
    this.proxy.sendMessage(
        25,
        PageHandler_OnDoodleShared_ParamsSpec.$,
        null,
        [
          channel,
          doodleId,
          shareId
        ],
        false);
  }

  onPromoLinkClicked(): void {
    this.proxy.sendMessage(
        26,
        PageHandler_OnPromoLinkClicked_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onAppRendered(
      time: number): void {
    this.proxy.sendMessage(
        27,
        PageHandler_OnAppRendered_ParamsSpec.$,
        null,
        [
          time
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_SetMostVisitedSettings_ParamsSpec.$,
        null,
        impl.setMostVisitedSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_GetMostVisitedSettings_ParamsSpec.$,
        PageHandler_GetMostVisitedSettings_ResponseParamsSpec.$,
        impl.getMostVisitedSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_GetDoodle_ParamsSpec.$,
        PageHandler_GetDoodle_ResponseParamsSpec.$,
        impl.getDoodle.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_UpdatePromoData_ParamsSpec.$,
        null,
        impl.updatePromoData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_BlocklistPromo_ParamsSpec.$,
        null,
        impl.blocklistPromo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_UndoBlocklistPromo_ParamsSpec.$,
        null,
        impl.undoBlocklistPromo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_OnDismissModule_ParamsSpec.$,
        null,
        impl.onDismissModule.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageHandler_OnRestoreModule_ParamsSpec.$,
        null,
        impl.onRestoreModule.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PageHandler_SetModulesVisible_ParamsSpec.$,
        null,
        impl.setModulesVisible.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PageHandler_SetModuleDisabled_ParamsSpec.$,
        null,
        impl.setModuleDisabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        PageHandler_UpdateDisabledModules_ParamsSpec.$,
        null,
        impl.updateDisabledModules.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        PageHandler_OnModulesLoadedWithData_ParamsSpec.$,
        null,
        impl.onModulesLoadedWithData.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        PageHandler_OnModuleUsed_ParamsSpec.$,
        null,
        impl.onModuleUsed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        PageHandler_GetModulesIdNames_ParamsSpec.$,
        PageHandler_GetModulesIdNames_ResponseParamsSpec.$,
        impl.getModulesIdNames.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        PageHandler_SetModulesOrder_ParamsSpec.$,
        null,
        impl.setModulesOrder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        PageHandler_GetModulesOrder_ParamsSpec.$,
        PageHandler_GetModulesOrder_ResponseParamsSpec.$,
        impl.getModulesOrder.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        PageHandler_UpdateModulesLoadable_ParamsSpec.$,
        null,
        impl.updateModulesLoadable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        PageHandler_UpdateFooterVisibility_ParamsSpec.$,
        null,
        impl.updateFooterVisibility.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        PageHandler_MaybeShowFeaturePromo_ParamsSpec.$,
        null,
        impl.maybeShowFeaturePromo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        PageHandler_IncrementComposeButtonShownCount_ParamsSpec.$,
        null,
        impl.incrementComposeButtonShownCount.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        PageHandler_OnOneGoogleBarRendered_ParamsSpec.$,
        null,
        impl.onOneGoogleBarRendered.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        PageHandler_OnPromoRendered_ParamsSpec.$,
        null,
        impl.onPromoRendered.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        PageHandler_OnCustomizeDialogAction_ParamsSpec.$,
        null,
        impl.onCustomizeDialogAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        PageHandler_OnDoodleImageClicked_ParamsSpec.$,
        null,
        impl.onDoodleImageClicked.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        PageHandler_OnDoodleImageRendered_ParamsSpec.$,
        PageHandler_OnDoodleImageRendered_ResponseParamsSpec.$,
        impl.onDoodleImageRendered.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        PageHandler_OnDoodleShared_ParamsSpec.$,
        null,
        impl.onDoodleShared.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        PageHandler_OnPromoLinkClicked_ParamsSpec.$,
        null,
        impl.onPromoLinkClicked.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        PageHandler_OnAppRendered_ParamsSpec.$,
        null,
        impl.onAppRendered.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "new_tab_page.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setMostVisitedSettings: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getMostVisitedSettings: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getDoodle: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updatePromoData: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  blocklistPromo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  undoBlocklistPromo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onDismissModule: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onRestoreModule: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setModulesVisible: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setModuleDisabled: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateDisabledModules: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onModulesLoadedWithData: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onModuleUsed: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getModulesIdNames: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setModulesOrder: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getModulesOrder: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateModulesLoadable: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateFooterVisibility: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  maybeShowFeaturePromo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  incrementComposeButtonShownCount: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onOneGoogleBarRendered: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onPromoRendered: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onCustomizeDialogAction: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onDoodleImageClicked: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onDoodleImageRendered: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onDoodleShared: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onPromoLinkClicked: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onAppRendered: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setMostVisitedSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_SetMostVisitedSettings_ParamsSpec.$,
        null,
        this.setMostVisitedSettings.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getMostVisitedSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_GetMostVisitedSettings_ParamsSpec.$,
        PageHandler_GetMostVisitedSettings_ResponseParamsSpec.$,
        this.getMostVisitedSettings.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getDoodle =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_GetDoodle_ParamsSpec.$,
        PageHandler_GetDoodle_ResponseParamsSpec.$,
        this.getDoodle.createReceiverHandler(true /* expectsResponse */),
        false);
    this.updatePromoData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_UpdatePromoData_ParamsSpec.$,
        null,
        this.updatePromoData.createReceiverHandler(false /* expectsResponse */),
        false);
    this.blocklistPromo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_BlocklistPromo_ParamsSpec.$,
        null,
        this.blocklistPromo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.undoBlocklistPromo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_UndoBlocklistPromo_ParamsSpec.$,
        null,
        this.undoBlocklistPromo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onDismissModule =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_OnDismissModule_ParamsSpec.$,
        null,
        this.onDismissModule.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onRestoreModule =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageHandler_OnRestoreModule_ParamsSpec.$,
        null,
        this.onRestoreModule.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setModulesVisible =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PageHandler_SetModulesVisible_ParamsSpec.$,
        null,
        this.setModulesVisible.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setModuleDisabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PageHandler_SetModuleDisabled_ParamsSpec.$,
        null,
        this.setModuleDisabled.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateDisabledModules =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        PageHandler_UpdateDisabledModules_ParamsSpec.$,
        null,
        this.updateDisabledModules.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onModulesLoadedWithData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        PageHandler_OnModulesLoadedWithData_ParamsSpec.$,
        null,
        this.onModulesLoadedWithData.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onModuleUsed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        PageHandler_OnModuleUsed_ParamsSpec.$,
        null,
        this.onModuleUsed.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getModulesIdNames =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        PageHandler_GetModulesIdNames_ParamsSpec.$,
        PageHandler_GetModulesIdNames_ResponseParamsSpec.$,
        this.getModulesIdNames.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setModulesOrder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        PageHandler_SetModulesOrder_ParamsSpec.$,
        null,
        this.setModulesOrder.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getModulesOrder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        PageHandler_GetModulesOrder_ParamsSpec.$,
        PageHandler_GetModulesOrder_ResponseParamsSpec.$,
        this.getModulesOrder.createReceiverHandler(true /* expectsResponse */),
        false);
    this.updateModulesLoadable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        PageHandler_UpdateModulesLoadable_ParamsSpec.$,
        null,
        this.updateModulesLoadable.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateFooterVisibility =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        PageHandler_UpdateFooterVisibility_ParamsSpec.$,
        null,
        this.updateFooterVisibility.createReceiverHandler(false /* expectsResponse */),
        false);
    this.maybeShowFeaturePromo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        PageHandler_MaybeShowFeaturePromo_ParamsSpec.$,
        null,
        this.maybeShowFeaturePromo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.incrementComposeButtonShownCount =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        PageHandler_IncrementComposeButtonShownCount_ParamsSpec.$,
        null,
        this.incrementComposeButtonShownCount.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onOneGoogleBarRendered =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        PageHandler_OnOneGoogleBarRendered_ParamsSpec.$,
        null,
        this.onOneGoogleBarRendered.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onPromoRendered =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        PageHandler_OnPromoRendered_ParamsSpec.$,
        null,
        this.onPromoRendered.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onCustomizeDialogAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        PageHandler_OnCustomizeDialogAction_ParamsSpec.$,
        null,
        this.onCustomizeDialogAction.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onDoodleImageClicked =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        PageHandler_OnDoodleImageClicked_ParamsSpec.$,
        null,
        this.onDoodleImageClicked.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onDoodleImageRendered =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        PageHandler_OnDoodleImageRendered_ParamsSpec.$,
        PageHandler_OnDoodleImageRendered_ResponseParamsSpec.$,
        this.onDoodleImageRendered.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onDoodleShared =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        PageHandler_OnDoodleShared_ParamsSpec.$,
        null,
        this.onDoodleShared.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onPromoLinkClicked =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        PageHandler_OnPromoLinkClicked_ParamsSpec.$,
        null,
        this.onPromoLinkClicked.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onAppRendered =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        PageHandler_OnAppRendered_ParamsSpec.$,
        null,
        this.onAppRendered.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'new_tab_page.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  setTheme(theme: Theme): void;
  setDisabledModules(all: boolean, ids: string[]): void;
  setModulesLoadable(): void;
  setPromo(promo: (Promo | null)): void;
  showWebstoreToast(): void;
  setWallpaperSearchButtonVisibility(visible: boolean): void;
  footerVisibilityUpdated(visible: boolean): void;
  connectToParentDocument(childUntrustedDocumentRemote: newTabPage_mojom_MicrosoftAuthUntrustedDocumentRemote): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setTheme(
      theme: Theme): void {
    this.proxy.sendMessage(
        0,
        Page_SetTheme_ParamsSpec.$,
        null,
        [
          theme
        ],
        false);
  }

  setDisabledModules(
      all: boolean,
      ids: string[]): void {
    this.proxy.sendMessage(
        1,
        Page_SetDisabledModules_ParamsSpec.$,
        null,
        [
          all,
          ids
        ],
        false);
  }

  setModulesLoadable(): void {
    this.proxy.sendMessage(
        2,
        Page_SetModulesLoadable_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setPromo(
      promo: (Promo | null)): void {
    this.proxy.sendMessage(
        3,
        Page_SetPromo_ParamsSpec.$,
        null,
        [
          promo
        ],
        false);
  }

  showWebstoreToast(): void {
    this.proxy.sendMessage(
        4,
        Page_ShowWebstoreToast_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setWallpaperSearchButtonVisibility(
      visible: boolean): void {
    this.proxy.sendMessage(
        5,
        Page_SetWallpaperSearchButtonVisibility_ParamsSpec.$,
        null,
        [
          visible
        ],
        false);
  }

  footerVisibilityUpdated(
      visible: boolean): void {
    this.proxy.sendMessage(
        6,
        Page_FooterVisibilityUpdated_ParamsSpec.$,
        null,
        [
          visible
        ],
        false);
  }

  connectToParentDocument(
      childUntrustedDocumentRemote: newTabPage_mojom_MicrosoftAuthUntrustedDocumentRemote): void {
    this.proxy.sendMessage(
        7,
        Page_ConnectToParentDocument_ParamsSpec.$,
        null,
        [
          childUntrustedDocumentRemote
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_SetTheme_ParamsSpec.$,
        null,
        impl.setTheme.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_SetDisabledModules_ParamsSpec.$,
        null,
        impl.setDisabledModules.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Page_SetModulesLoadable_ParamsSpec.$,
        null,
        impl.setModulesLoadable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Page_SetPromo_ParamsSpec.$,
        null,
        impl.setPromo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Page_ShowWebstoreToast_ParamsSpec.$,
        null,
        impl.showWebstoreToast.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Page_SetWallpaperSearchButtonVisibility_ParamsSpec.$,
        null,
        impl.setWallpaperSearchButtonVisibility.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        Page_FooterVisibilityUpdated_ParamsSpec.$,
        null,
        impl.footerVisibilityUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        Page_ConnectToParentDocument_ParamsSpec.$,
        null,
        impl.connectToParentDocument.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "new_tab_page.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setTheme: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setDisabledModules: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setModulesLoadable: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setPromo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showWebstoreToast: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setWallpaperSearchButtonVisibility: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  footerVisibilityUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  connectToParentDocument: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setTheme =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_SetTheme_ParamsSpec.$,
        null,
        this.setTheme.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setDisabledModules =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_SetDisabledModules_ParamsSpec.$,
        null,
        this.setDisabledModules.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setModulesLoadable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Page_SetModulesLoadable_ParamsSpec.$,
        null,
        this.setModulesLoadable.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setPromo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Page_SetPromo_ParamsSpec.$,
        null,
        this.setPromo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showWebstoreToast =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Page_ShowWebstoreToast_ParamsSpec.$,
        null,
        this.showWebstoreToast.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setWallpaperSearchButtonVisibility =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Page_SetWallpaperSearchButtonVisibility_ParamsSpec.$,
        null,
        this.setWallpaperSearchButtonVisibility.createReceiverHandler(false /* expectsResponse */),
        false);
    this.footerVisibilityUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        Page_FooterVisibilityUpdated_ParamsSpec.$,
        null,
        this.footerVisibilityUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.connectToParentDocument =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        Page_ConnectToParentDocument_ParamsSpec.$,
        null,
        this.connectToParentDocument.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const BackgroundImageSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ThemeSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ImageDoodleSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const AllModeImageDoodleSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const InteractiveDoodleSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const DoodleSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PromoImagePartSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PromoLinkPartSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PromoTextPartSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PromoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ModuleIdNameSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetMostVisitedSettings_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetMostVisitedSettings_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetMostVisitedSettings_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetDoodle_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetDoodle_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_UpdatePromoData_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_BlocklistPromo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_UndoBlocklistPromo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnDismissModule_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnRestoreModule_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetModulesVisible_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetModuleDisabled_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_UpdateDisabledModules_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnModulesLoadedWithData_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnModuleUsed_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetModulesIdNames_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetModulesIdNames_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetModulesOrder_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetModulesOrder_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetModulesOrder_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_UpdateModulesLoadable_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_UpdateFooterVisibility_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_MaybeShowFeaturePromo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_IncrementComposeButtonShownCount_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnOneGoogleBarRendered_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnPromoRendered_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnCustomizeDialogAction_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnDoodleImageClicked_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnDoodleImageRendered_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnDoodleImageRendered_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnDoodleShared_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnPromoLinkClicked_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OnAppRendered_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SetTheme_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SetDisabledModules_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SetModulesLoadable_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SetPromo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_ShowWebstoreToast_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_SetWallpaperSearchButtonVisibility_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_FooterVisibilityUpdated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_ConnectToParentDocument_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PromoPartSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface BackgroundImageMojoType {
  url: url_mojom_Url;
  url2x: (url_mojom_Url | null);
  attributionUrl: (url_mojom_Url | null);
  size: (string | null);
  repeatX: (string | null);
  repeatY: (string | null);
  positionX: (string | null);
  positionY: (string | null);
  imageSource: NtpBackgroundImageSource;
}


export type BackgroundImage = BackgroundImageMojoType;
mojo.internal.Struct<BackgroundImageMojoType>(
    BackgroundImageSpec.$,
    'BackgroundImage',
    [
      mojo.internal.StructField<BackgroundImageMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageMojoType, url_mojom_Url>(
        'url2x', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageMojoType, url_mojom_Url>(
        'attributionUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageMojoType, string>(
        'size', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageMojoType, string>(
        'repeatX', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageMojoType, string>(
        'repeatY', 40,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageMojoType, string>(
        'positionX', 48,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageMojoType, string>(
        'positionY', 56,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageMojoType, NtpBackgroundImageSource>(
        'imageSource', 64,
        0,
        NtpBackgroundImageSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 80],]);





export interface ThemeMojoType {
  textColor: skia_mojom_SkColor;
  backgroundColor: skia_mojom_SkColor;
  isBaseline: boolean;
  isCustomBackground: boolean;
  dailyRefreshEnabled: boolean;
  isDark: boolean;
  logoColor: (skia_mojom_SkColor | null);
  backgroundImageCollectionId: (string | null);
  backgroundImage: (BackgroundImage | null);
  backgroundImageAttribution1: (string | null);
  backgroundImageAttribution2: (string | null);
  backgroundImageAttributionUrl: (url_mojom_Url | null);
  mostVisited: mostVisited_mojom_MostVisitedTheme;
}


export type Theme = ThemeMojoType;
mojo.internal.Struct<ThemeMojoType>(
    ThemeSpec.$,
    'Theme',
    [
      mojo.internal.StructField<ThemeMojoType, skia_mojom_SkColor>(
        'textColor', 0,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, skia_mojom_SkColor>(
        'backgroundColor', 8,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, boolean>(
        'isBaseline', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, boolean>(
        'isCustomBackground', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, boolean>(
        'dailyRefreshEnabled', 16,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, boolean>(
        'isDark', 16,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, skia_mojom_SkColor>(
        'logoColor', 24,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, string>(
        'backgroundImageCollectionId', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, BackgroundImage>(
        'backgroundImage', 40,
        0,
        BackgroundImageSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, string>(
        'backgroundImageAttribution1', 48,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, string>(
        'backgroundImageAttribution2', 56,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, url_mojom_Url>(
        'backgroundImageAttributionUrl', 64,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, mostVisited_mojom_MostVisitedTheme>(
        'mostVisited', 72,
        0,
        mostVisited_mojom_MostVisitedThemeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 88],]);





export interface ImageDoodleMojoType {
  imageUrl: url_mojom_Url;
  animationUrl: (url_mojom_Url | null);
  width: number;
  height: number;
  backgroundColor: skia_mojom_SkColor;
  imageImpressionLogUrl: url_mojom_Url;
  animationImpressionLogUrl: (url_mojom_Url | null);
}


export type ImageDoodle = ImageDoodleMojoType;
mojo.internal.Struct<ImageDoodleMojoType>(
    ImageDoodleSpec.$,
    'ImageDoodle',
    [
      mojo.internal.StructField<ImageDoodleMojoType, url_mojom_Url>(
        'imageUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ImageDoodleMojoType, url_mojom_Url>(
        'animationUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ImageDoodleMojoType, number>(
        'width', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ImageDoodleMojoType, number>(
        'height', 20,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ImageDoodleMojoType, skia_mojom_SkColor>(
        'backgroundColor', 24,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ImageDoodleMojoType, url_mojom_Url>(
        'imageImpressionLogUrl', 32,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ImageDoodleMojoType, url_mojom_Url>(
        'animationImpressionLogUrl', 40,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface AllModeImageDoodleMojoType {
  light: ImageDoodle;
  dark: (ImageDoodle | null);
  onClickUrl: (url_mojom_Url | null);
  shareUrl: url_mojom_Url;
}


export type AllModeImageDoodle = AllModeImageDoodleMojoType;
mojo.internal.Struct<AllModeImageDoodleMojoType>(
    AllModeImageDoodleSpec.$,
    'AllModeImageDoodle',
    [
      mojo.internal.StructField<AllModeImageDoodleMojoType, ImageDoodle>(
        'light', 0,
        0,
        ImageDoodleSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AllModeImageDoodleMojoType, ImageDoodle>(
        'dark', 8,
        0,
        ImageDoodleSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AllModeImageDoodleMojoType, url_mojom_Url>(
        'onClickUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<AllModeImageDoodleMojoType, url_mojom_Url>(
        'shareUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface InteractiveDoodleMojoType {
  url: url_mojom_Url;
  width: number;
  height: number;
}


export type InteractiveDoodle = InteractiveDoodleMojoType;
mojo.internal.Struct<InteractiveDoodleMojoType>(
    InteractiveDoodleSpec.$,
    'InteractiveDoodle',
    [
      mojo.internal.StructField<InteractiveDoodleMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<InteractiveDoodleMojoType, number>(
        'width', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<InteractiveDoodleMojoType, number>(
        'height', 12,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface DoodleMojoType {
  image: (AllModeImageDoodle | null);
  interactive: (InteractiveDoodle | null);
  description: string;
}


export type Doodle = DoodleMojoType;
mojo.internal.Struct<DoodleMojoType>(
    DoodleSpec.$,
    'Doodle',
    [
      mojo.internal.StructField<DoodleMojoType, AllModeImageDoodle>(
        'image', 0,
        0,
        AllModeImageDoodleSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DoodleMojoType, InteractiveDoodle>(
        'interactive', 8,
        0,
        InteractiveDoodleSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<DoodleMojoType, string>(
        'description', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PromoImagePartMojoType {
  imageUrl: url_mojom_Url;
  target: url_mojom_Url;
}


export type PromoImagePart = PromoImagePartMojoType;
mojo.internal.Struct<PromoImagePartMojoType>(
    PromoImagePartSpec.$,
    'PromoImagePart',
    [
      mojo.internal.StructField<PromoImagePartMojoType, url_mojom_Url>(
        'imageUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PromoImagePartMojoType, url_mojom_Url>(
        'target', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PromoLinkPartMojoType {
  text: string;
  url: url_mojom_Url;
}


export type PromoLinkPart = PromoLinkPartMojoType;
mojo.internal.Struct<PromoLinkPartMojoType>(
    PromoLinkPartSpec.$,
    'PromoLinkPart',
    [
      mojo.internal.StructField<PromoLinkPartMojoType, string>(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PromoLinkPartMojoType, url_mojom_Url>(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PromoTextPartMojoType {
  text: string;
}


export type PromoTextPart = PromoTextPartMojoType;
mojo.internal.Struct<PromoTextPartMojoType>(
    PromoTextPartSpec.$,
    'PromoTextPart',
    [
      mojo.internal.StructField<PromoTextPartMojoType, string>(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PromoMojoType {
  id: (string | null);
  logUrl: (url_mojom_Url | null);
  middleSlotParts: PromoPart[];
}


export type Promo = PromoMojoType;
mojo.internal.Struct<PromoMojoType>(
    PromoSpec.$,
    'Promo',
    [
      mojo.internal.StructField<PromoMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PromoMojoType, url_mojom_Url>(
        'logUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PromoMojoType, PromoPart[]>(
        'middleSlotParts', 16,
        0,
        mojo.internal.Array(PromoPartSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface ModuleIdNameMojoType {
  id: string;
  name: string;
}


export type ModuleIdName = ModuleIdNameMojoType;
mojo.internal.Struct<ModuleIdNameMojoType>(
    ModuleIdNameSpec.$,
    'ModuleIdName',
    [
      mojo.internal.StructField<ModuleIdNameMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ModuleIdNameMojoType, string>(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: PageRemote;
  handler: PageHandlerPendingReceiver;
}


export type PageHandlerFactory_CreatePageHandler_Params = PageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<PageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandlerFactory_CreatePageHandler_ParamsMojoType, PageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_SetMostVisitedSettings_ParamsMojoType {
  shortcutsType: ntpTiles_mojom_TileType;
  shortcutsVisible: boolean;
}


export type PageHandler_SetMostVisitedSettings_Params = PageHandler_SetMostVisitedSettings_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetMostVisitedSettings_ParamsMojoType>(
    PageHandler_SetMostVisitedSettings_ParamsSpec.$,
    'PageHandler_SetMostVisitedSettings_Params',
    [
      mojo.internal.StructField<PageHandler_SetMostVisitedSettings_ParamsMojoType, ntpTiles_mojom_TileType>(
        'shortcutsType', 0,
        0,
        ntpTiles_mojom_TileTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SetMostVisitedSettings_ParamsMojoType, boolean>(
        'shortcutsVisible', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetMostVisitedSettings_ParamsMojoType {
}


export type PageHandler_GetMostVisitedSettings_Params = PageHandler_GetMostVisitedSettings_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetMostVisitedSettings_ParamsMojoType>(
    PageHandler_GetMostVisitedSettings_ParamsSpec.$,
    'PageHandler_GetMostVisitedSettings_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetMostVisitedSettings_ResponseParamsMojoType {
  shortcutsType: ntpTiles_mojom_TileType;
  shortcutsVisible: boolean;
}


export type PageHandler_GetMostVisitedSettings_ResponseParams = PageHandler_GetMostVisitedSettings_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetMostVisitedSettings_ResponseParamsMojoType>(
    PageHandler_GetMostVisitedSettings_ResponseParamsSpec.$,
    'PageHandler_GetMostVisitedSettings_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetMostVisitedSettings_ResponseParamsMojoType, ntpTiles_mojom_TileType>(
        'shortcutsType', 0,
        0,
        ntpTiles_mojom_TileTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_GetMostVisitedSettings_ResponseParamsMojoType, boolean>(
        'shortcutsVisible', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetDoodle_ParamsMojoType {
}


export type PageHandler_GetDoodle_Params = PageHandler_GetDoodle_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetDoodle_ParamsMojoType>(
    PageHandler_GetDoodle_ParamsSpec.$,
    'PageHandler_GetDoodle_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetDoodle_ResponseParamsMojoType {
  doodle: (Doodle | null);
}


export type PageHandler_GetDoodle_ResponseParams = PageHandler_GetDoodle_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetDoodle_ResponseParamsMojoType>(
    PageHandler_GetDoodle_ResponseParamsSpec.$,
    'PageHandler_GetDoodle_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetDoodle_ResponseParamsMojoType, Doodle>(
        'doodle', 0,
        0,
        DoodleSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_UpdatePromoData_ParamsMojoType {
}


export type PageHandler_UpdatePromoData_Params = PageHandler_UpdatePromoData_ParamsMojoType;
mojo.internal.Struct<PageHandler_UpdatePromoData_ParamsMojoType>(
    PageHandler_UpdatePromoData_ParamsSpec.$,
    'PageHandler_UpdatePromoData_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_BlocklistPromo_ParamsMojoType {
  promoId: string;
}


export type PageHandler_BlocklistPromo_Params = PageHandler_BlocklistPromo_ParamsMojoType;
mojo.internal.Struct<PageHandler_BlocklistPromo_ParamsMojoType>(
    PageHandler_BlocklistPromo_ParamsSpec.$,
    'PageHandler_BlocklistPromo_Params',
    [
      mojo.internal.StructField<PageHandler_BlocklistPromo_ParamsMojoType, string>(
        'promoId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_UndoBlocklistPromo_ParamsMojoType {
  promoId: string;
}


export type PageHandler_UndoBlocklistPromo_Params = PageHandler_UndoBlocklistPromo_ParamsMojoType;
mojo.internal.Struct<PageHandler_UndoBlocklistPromo_ParamsMojoType>(
    PageHandler_UndoBlocklistPromo_ParamsSpec.$,
    'PageHandler_UndoBlocklistPromo_Params',
    [
      mojo.internal.StructField<PageHandler_UndoBlocklistPromo_ParamsMojoType, string>(
        'promoId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OnDismissModule_ParamsMojoType {
  moduleId: string;
}


export type PageHandler_OnDismissModule_Params = PageHandler_OnDismissModule_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnDismissModule_ParamsMojoType>(
    PageHandler_OnDismissModule_ParamsSpec.$,
    'PageHandler_OnDismissModule_Params',
    [
      mojo.internal.StructField<PageHandler_OnDismissModule_ParamsMojoType, string>(
        'moduleId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OnRestoreModule_ParamsMojoType {
  moduleId: string;
}


export type PageHandler_OnRestoreModule_Params = PageHandler_OnRestoreModule_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnRestoreModule_ParamsMojoType>(
    PageHandler_OnRestoreModule_ParamsSpec.$,
    'PageHandler_OnRestoreModule_Params',
    [
      mojo.internal.StructField<PageHandler_OnRestoreModule_ParamsMojoType, string>(
        'moduleId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetModulesVisible_ParamsMojoType {
  visible: boolean;
}


export type PageHandler_SetModulesVisible_Params = PageHandler_SetModulesVisible_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetModulesVisible_ParamsMojoType>(
    PageHandler_SetModulesVisible_ParamsSpec.$,
    'PageHandler_SetModulesVisible_Params',
    [
      mojo.internal.StructField<PageHandler_SetModulesVisible_ParamsMojoType, boolean>(
        'visible', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetModuleDisabled_ParamsMojoType {
  moduleId: string;
  disabled: boolean;
}


export type PageHandler_SetModuleDisabled_Params = PageHandler_SetModuleDisabled_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetModuleDisabled_ParamsMojoType>(
    PageHandler_SetModuleDisabled_ParamsSpec.$,
    'PageHandler_SetModuleDisabled_Params',
    [
      mojo.internal.StructField<PageHandler_SetModuleDisabled_ParamsMojoType, string>(
        'moduleId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_SetModuleDisabled_ParamsMojoType, boolean>(
        'disabled', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_UpdateDisabledModules_ParamsMojoType {
}


export type PageHandler_UpdateDisabledModules_Params = PageHandler_UpdateDisabledModules_ParamsMojoType;
mojo.internal.Struct<PageHandler_UpdateDisabledModules_ParamsMojoType>(
    PageHandler_UpdateDisabledModules_ParamsSpec.$,
    'PageHandler_UpdateDisabledModules_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_OnModulesLoadedWithData_ParamsMojoType {
  moduleIds: string[];
}


export type PageHandler_OnModulesLoadedWithData_Params = PageHandler_OnModulesLoadedWithData_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnModulesLoadedWithData_ParamsMojoType>(
    PageHandler_OnModulesLoadedWithData_ParamsSpec.$,
    'PageHandler_OnModulesLoadedWithData_Params',
    [
      mojo.internal.StructField<PageHandler_OnModulesLoadedWithData_ParamsMojoType, string[]>(
        'moduleIds', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OnModuleUsed_ParamsMojoType {
  moduleId: string;
}


export type PageHandler_OnModuleUsed_Params = PageHandler_OnModuleUsed_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnModuleUsed_ParamsMojoType>(
    PageHandler_OnModuleUsed_ParamsSpec.$,
    'PageHandler_OnModuleUsed_Params',
    [
      mojo.internal.StructField<PageHandler_OnModuleUsed_ParamsMojoType, string>(
        'moduleId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetModulesIdNames_ParamsMojoType {
}


export type PageHandler_GetModulesIdNames_Params = PageHandler_GetModulesIdNames_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetModulesIdNames_ParamsMojoType>(
    PageHandler_GetModulesIdNames_ParamsSpec.$,
    'PageHandler_GetModulesIdNames_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetModulesIdNames_ResponseParamsMojoType {
  data: ModuleIdName[];
}


export type PageHandler_GetModulesIdNames_ResponseParams = PageHandler_GetModulesIdNames_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetModulesIdNames_ResponseParamsMojoType>(
    PageHandler_GetModulesIdNames_ResponseParamsSpec.$,
    'PageHandler_GetModulesIdNames_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetModulesIdNames_ResponseParamsMojoType, ModuleIdName[]>(
        'data', 0,
        0,
        mojo.internal.Array(ModuleIdNameSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_SetModulesOrder_ParamsMojoType {
  moduleIds: string[];
}


export type PageHandler_SetModulesOrder_Params = PageHandler_SetModulesOrder_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetModulesOrder_ParamsMojoType>(
    PageHandler_SetModulesOrder_ParamsSpec.$,
    'PageHandler_SetModulesOrder_Params',
    [
      mojo.internal.StructField<PageHandler_SetModulesOrder_ParamsMojoType, string[]>(
        'moduleIds', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetModulesOrder_ParamsMojoType {
}


export type PageHandler_GetModulesOrder_Params = PageHandler_GetModulesOrder_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetModulesOrder_ParamsMojoType>(
    PageHandler_GetModulesOrder_ParamsSpec.$,
    'PageHandler_GetModulesOrder_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetModulesOrder_ResponseParamsMojoType {
  moduleIds: string[];
}


export type PageHandler_GetModulesOrder_ResponseParams = PageHandler_GetModulesOrder_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetModulesOrder_ResponseParamsMojoType>(
    PageHandler_GetModulesOrder_ResponseParamsSpec.$,
    'PageHandler_GetModulesOrder_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetModulesOrder_ResponseParamsMojoType, string[]>(
        'moduleIds', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_UpdateModulesLoadable_ParamsMojoType {
}


export type PageHandler_UpdateModulesLoadable_Params = PageHandler_UpdateModulesLoadable_ParamsMojoType;
mojo.internal.Struct<PageHandler_UpdateModulesLoadable_ParamsMojoType>(
    PageHandler_UpdateModulesLoadable_ParamsSpec.$,
    'PageHandler_UpdateModulesLoadable_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_UpdateFooterVisibility_ParamsMojoType {
}


export type PageHandler_UpdateFooterVisibility_Params = PageHandler_UpdateFooterVisibility_ParamsMojoType;
mojo.internal.Struct<PageHandler_UpdateFooterVisibility_ParamsMojoType>(
    PageHandler_UpdateFooterVisibility_ParamsSpec.$,
    'PageHandler_UpdateFooterVisibility_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_MaybeShowFeaturePromo_ParamsMojoType {
  iphFeature: IphFeature;
}


export type PageHandler_MaybeShowFeaturePromo_Params = PageHandler_MaybeShowFeaturePromo_ParamsMojoType;
mojo.internal.Struct<PageHandler_MaybeShowFeaturePromo_ParamsMojoType>(
    PageHandler_MaybeShowFeaturePromo_ParamsSpec.$,
    'PageHandler_MaybeShowFeaturePromo_Params',
    [
      mojo.internal.StructField<PageHandler_MaybeShowFeaturePromo_ParamsMojoType, IphFeature>(
        'iphFeature', 0,
        0,
        IphFeatureSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_IncrementComposeButtonShownCount_ParamsMojoType {
}


export type PageHandler_IncrementComposeButtonShownCount_Params = PageHandler_IncrementComposeButtonShownCount_ParamsMojoType;
mojo.internal.Struct<PageHandler_IncrementComposeButtonShownCount_ParamsMojoType>(
    PageHandler_IncrementComposeButtonShownCount_ParamsSpec.$,
    'PageHandler_IncrementComposeButtonShownCount_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_OnOneGoogleBarRendered_ParamsMojoType {
  time: number;
}


export type PageHandler_OnOneGoogleBarRendered_Params = PageHandler_OnOneGoogleBarRendered_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnOneGoogleBarRendered_ParamsMojoType>(
    PageHandler_OnOneGoogleBarRendered_ParamsSpec.$,
    'PageHandler_OnOneGoogleBarRendered_Params',
    [
      mojo.internal.StructField<PageHandler_OnOneGoogleBarRendered_ParamsMojoType, number>(
        'time', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OnPromoRendered_ParamsMojoType {
  time: number;
  logUrl: (url_mojom_Url | null);
}


export type PageHandler_OnPromoRendered_Params = PageHandler_OnPromoRendered_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnPromoRendered_ParamsMojoType>(
    PageHandler_OnPromoRendered_ParamsSpec.$,
    'PageHandler_OnPromoRendered_Params',
    [
      mojo.internal.StructField<PageHandler_OnPromoRendered_ParamsMojoType, number>(
        'time', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OnPromoRendered_ParamsMojoType, url_mojom_Url>(
        'logUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_OnCustomizeDialogAction_ParamsMojoType {
  action: CustomizeDialogAction;
}


export type PageHandler_OnCustomizeDialogAction_Params = PageHandler_OnCustomizeDialogAction_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnCustomizeDialogAction_ParamsMojoType>(
    PageHandler_OnCustomizeDialogAction_ParamsSpec.$,
    'PageHandler_OnCustomizeDialogAction_Params',
    [
      mojo.internal.StructField<PageHandler_OnCustomizeDialogAction_ParamsMojoType, CustomizeDialogAction>(
        'action', 0,
        0,
        CustomizeDialogActionSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OnDoodleImageClicked_ParamsMojoType {
  type: DoodleImageType;
  logUrl: (url_mojom_Url | null);
}


export type PageHandler_OnDoodleImageClicked_Params = PageHandler_OnDoodleImageClicked_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnDoodleImageClicked_ParamsMojoType>(
    PageHandler_OnDoodleImageClicked_ParamsSpec.$,
    'PageHandler_OnDoodleImageClicked_Params',
    [
      mojo.internal.StructField<PageHandler_OnDoodleImageClicked_ParamsMojoType, DoodleImageType>(
        'type', 0,
        0,
        DoodleImageTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OnDoodleImageClicked_ParamsMojoType, url_mojom_Url>(
        'logUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_OnDoodleImageRendered_ParamsMojoType {
  type: DoodleImageType;
  time: number;
  logUrl: url_mojom_Url;
}


export type PageHandler_OnDoodleImageRendered_Params = PageHandler_OnDoodleImageRendered_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnDoodleImageRendered_ParamsMojoType>(
    PageHandler_OnDoodleImageRendered_ParamsSpec.$,
    'PageHandler_OnDoodleImageRendered_Params',
    [
      mojo.internal.StructField<PageHandler_OnDoodleImageRendered_ParamsMojoType, DoodleImageType>(
        'type', 0,
        0,
        DoodleImageTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OnDoodleImageRendered_ParamsMojoType, number>(
        'time', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OnDoodleImageRendered_ParamsMojoType, url_mojom_Url>(
        'logUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandler_OnDoodleImageRendered_ResponseParamsMojoType {
  imageClickParams: (string | null);
  interactionLogUrl: (url_mojom_Url | null);
  shareId: (string | null);
}


export type PageHandler_OnDoodleImageRendered_ResponseParams = PageHandler_OnDoodleImageRendered_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_OnDoodleImageRendered_ResponseParamsMojoType>(
    PageHandler_OnDoodleImageRendered_ResponseParamsSpec.$,
    'PageHandler_OnDoodleImageRendered_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_OnDoodleImageRendered_ResponseParamsMojoType, string>(
        'imageClickParams', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OnDoodleImageRendered_ResponseParamsMojoType, url_mojom_Url>(
        'interactionLogUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OnDoodleImageRendered_ResponseParamsMojoType, string>(
        'shareId', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandler_OnDoodleShared_ParamsMojoType {
  channel: DoodleShareChannel;
  doodleId: string;
  shareId: (string | null);
}


export type PageHandler_OnDoodleShared_Params = PageHandler_OnDoodleShared_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnDoodleShared_ParamsMojoType>(
    PageHandler_OnDoodleShared_ParamsSpec.$,
    'PageHandler_OnDoodleShared_Params',
    [
      mojo.internal.StructField<PageHandler_OnDoodleShared_ParamsMojoType, DoodleShareChannel>(
        'channel', 0,
        0,
        DoodleShareChannelSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OnDoodleShared_ParamsMojoType, string>(
        'doodleId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OnDoodleShared_ParamsMojoType, string>(
        'shareId', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandler_OnPromoLinkClicked_ParamsMojoType {
}


export type PageHandler_OnPromoLinkClicked_Params = PageHandler_OnPromoLinkClicked_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnPromoLinkClicked_ParamsMojoType>(
    PageHandler_OnPromoLinkClicked_ParamsSpec.$,
    'PageHandler_OnPromoLinkClicked_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_OnAppRendered_ParamsMojoType {
  time: number;
}


export type PageHandler_OnAppRendered_Params = PageHandler_OnAppRendered_ParamsMojoType;
mojo.internal.Struct<PageHandler_OnAppRendered_ParamsMojoType>(
    PageHandler_OnAppRendered_ParamsSpec.$,
    'PageHandler_OnAppRendered_Params',
    [
      mojo.internal.StructField<PageHandler_OnAppRendered_ParamsMojoType, number>(
        'time', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_SetTheme_ParamsMojoType {
  theme: Theme;
}


export type Page_SetTheme_Params = Page_SetTheme_ParamsMojoType;
mojo.internal.Struct<Page_SetTheme_ParamsMojoType>(
    Page_SetTheme_ParamsSpec.$,
    'Page_SetTheme_Params',
    [
      mojo.internal.StructField<Page_SetTheme_ParamsMojoType, Theme>(
        'theme', 0,
        0,
        ThemeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_SetDisabledModules_ParamsMojoType {
  all: boolean;
  ids: string[];
}


export type Page_SetDisabledModules_Params = Page_SetDisabledModules_ParamsMojoType;
mojo.internal.Struct<Page_SetDisabledModules_ParamsMojoType>(
    Page_SetDisabledModules_ParamsSpec.$,
    'Page_SetDisabledModules_Params',
    [
      mojo.internal.StructField<Page_SetDisabledModules_ParamsMojoType, boolean>(
        'all', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_SetDisabledModules_ParamsMojoType, string[]>(
        'ids', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Page_SetModulesLoadable_ParamsMojoType {
}


export type Page_SetModulesLoadable_Params = Page_SetModulesLoadable_ParamsMojoType;
mojo.internal.Struct<Page_SetModulesLoadable_ParamsMojoType>(
    Page_SetModulesLoadable_ParamsSpec.$,
    'Page_SetModulesLoadable_Params',
    [
    ],
    [[0, 8],]);





export interface Page_SetPromo_ParamsMojoType {
  promo: (Promo | null);
}


export type Page_SetPromo_Params = Page_SetPromo_ParamsMojoType;
mojo.internal.Struct<Page_SetPromo_ParamsMojoType>(
    Page_SetPromo_ParamsSpec.$,
    'Page_SetPromo_Params',
    [
      mojo.internal.StructField<Page_SetPromo_ParamsMojoType, Promo>(
        'promo', 0,
        0,
        PromoSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_ShowWebstoreToast_ParamsMojoType {
}


export type Page_ShowWebstoreToast_Params = Page_ShowWebstoreToast_ParamsMojoType;
mojo.internal.Struct<Page_ShowWebstoreToast_ParamsMojoType>(
    Page_ShowWebstoreToast_ParamsSpec.$,
    'Page_ShowWebstoreToast_Params',
    [
    ],
    [[0, 8],]);





export interface Page_SetWallpaperSearchButtonVisibility_ParamsMojoType {
  visible: boolean;
}


export type Page_SetWallpaperSearchButtonVisibility_Params = Page_SetWallpaperSearchButtonVisibility_ParamsMojoType;
mojo.internal.Struct<Page_SetWallpaperSearchButtonVisibility_ParamsMojoType>(
    Page_SetWallpaperSearchButtonVisibility_ParamsSpec.$,
    'Page_SetWallpaperSearchButtonVisibility_Params',
    [
      mojo.internal.StructField<Page_SetWallpaperSearchButtonVisibility_ParamsMojoType, boolean>(
        'visible', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_FooterVisibilityUpdated_ParamsMojoType {
  visible: boolean;
}


export type Page_FooterVisibilityUpdated_Params = Page_FooterVisibilityUpdated_ParamsMojoType;
mojo.internal.Struct<Page_FooterVisibilityUpdated_ParamsMojoType>(
    Page_FooterVisibilityUpdated_ParamsSpec.$,
    'Page_FooterVisibilityUpdated_Params',
    [
      mojo.internal.StructField<Page_FooterVisibilityUpdated_ParamsMojoType, boolean>(
        'visible', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_ConnectToParentDocument_ParamsMojoType {
  childUntrustedDocumentRemote: newTabPage_mojom_MicrosoftAuthUntrustedDocumentRemote;
}


export type Page_ConnectToParentDocument_Params = Page_ConnectToParentDocument_ParamsMojoType;
mojo.internal.Struct<Page_ConnectToParentDocument_ParamsMojoType>(
    Page_ConnectToParentDocument_ParamsSpec.$,
    'Page_ConnectToParentDocument_Params',
    [
      mojo.internal.StructField<Page_ConnectToParentDocument_ParamsMojoType, newTabPage_mojom_MicrosoftAuthUntrustedDocumentRemote>(
        'childUntrustedDocumentRemote', 0,
        0,
        mojo.internal.InterfaceProxy(newTabPage_mojom_MicrosoftAuthUntrustedDocumentRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



mojo.internal.Union(
    PromoPartSpec.$, 'PromoPart',
    {
      'image': {
        'ordinal': 0,
        'type': PromoImagePartSpec.$,
      },
      'link': {
        'ordinal': 1,
        'type': PromoLinkPartSpec.$,
      },
      'text': {
        'ordinal': 2,
        'type': PromoTextPartSpec.$,
      },
    });

export interface PromoPart {
  image?: PromoImagePart,
  link?: PromoLinkPart,
  text?: PromoTextPart,
}

export enum PromoPartFieldTags {
  IMAGE,
  LINK,
  TEXT,
}

export function whichPromoPart(u: PromoPart): PromoPartFieldTags {
  if (u.image !== null && u.image !== undefined) {
    return PromoPartFieldTags.IMAGE;
  }
  if (u.link !== null && u.link !== undefined) {
    return PromoPartFieldTags.LINK;
  }
  if (u.text !== null && u.text !== undefined) {
    return PromoPartFieldTags.TEXT;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
