// chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom-params-data.h"
namespace new_tab_page {
namespace mojom {

NOINLINE static const char* NtpBackgroundImageSourceToStringHelper(NtpBackgroundImageSource value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NtpBackgroundImageSource::kNoImage:
      return "kNoImage";
    case NtpBackgroundImageSource::kFirstPartyThemeWithoutDailyRefresh:
      return "kFirstPartyThemeWithoutDailyRefresh";
    case NtpBackgroundImageSource::kFirstPartyThemeWithDailyRefresh:
      return "kFirstPartyThemeWithDailyRefresh";
    case NtpBackgroundImageSource::kThirdPartyTheme:
      return "kThirdPartyTheme";
    case NtpBackgroundImageSource::kUploadedImage:
      return "kUploadedImage";
    case NtpBackgroundImageSource::kWallpaperSearch:
      return "kWallpaperSearch";
    case NtpBackgroundImageSource::kWallpaperSearchInspiration:
      return "kWallpaperSearchInspiration";
    default:
      return nullptr;
  }
}

std::string NtpBackgroundImageSourceToString(NtpBackgroundImageSource value) {
  const char *str = NtpBackgroundImageSourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NtpBackgroundImageSource value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NtpBackgroundImageSource value) {
  return os << NtpBackgroundImageSourceToString(value);
}

NOINLINE static const char* IphFeatureToStringHelper(IphFeature value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IphFeature::kCustomizeChrome:
      return "kCustomizeChrome";
    case IphFeature::kCustomizeModules:
      return "kCustomizeModules";
    default:
      return nullptr;
  }
}

std::string IphFeatureToString(IphFeature value) {
  const char *str = IphFeatureToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IphFeature value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IphFeature value) {
  return os << IphFeatureToString(value);
}

NOINLINE static const char* DoodleImageTypeToStringHelper(DoodleImageType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DoodleImageType::kAnimation:
      return "kAnimation";
    case DoodleImageType::kCta:
      return "kCta";
    case DoodleImageType::kStatic:
      return "kStatic";
    default:
      return nullptr;
  }
}

std::string DoodleImageTypeToString(DoodleImageType value) {
  const char *str = DoodleImageTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DoodleImageType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DoodleImageType value) {
  return os << DoodleImageTypeToString(value);
}

NOINLINE static const char* DoodleShareChannelToStringHelper(DoodleShareChannel value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DoodleShareChannel::kFacebook:
      return "kFacebook";
    case DoodleShareChannel::kTwitter:
      return "kTwitter";
    case DoodleShareChannel::kEmail:
      return "kEmail";
    case DoodleShareChannel::kLinkCopy:
      return "kLinkCopy";
    default:
      return nullptr;
  }
}

std::string DoodleShareChannelToString(DoodleShareChannel value) {
  const char *str = DoodleShareChannelToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DoodleShareChannel value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DoodleShareChannel value) {
  return os << DoodleShareChannelToString(value);
}

NOINLINE static const char* CustomizeDialogActionToStringHelper(CustomizeDialogAction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CustomizeDialogAction::kCancelClicked:
      return "kCancelClicked";
    case CustomizeDialogAction::kDoneClicked:
      return "kDoneClicked";
    case CustomizeDialogAction::kOpenClicked:
      return "kOpenClicked";
    case CustomizeDialogAction::kBackgroundsBackClicked:
      return "kBackgroundsBackClicked";
    case CustomizeDialogAction::kBackgroundsNoBackgroundSelected:
      return "kBackgroundsNoBackgroundSelected";
    case CustomizeDialogAction::kBackgroundsCollectionOpened:
      return "kBackgroundsCollectionOpened";
    case CustomizeDialogAction::kBackgroundsRefreshToggleClicked:
      return "kBackgroundsRefreshToggleClicked";
    case CustomizeDialogAction::kBackgroundsImageSelected:
      return "kBackgroundsImageSelected";
    case CustomizeDialogAction::kBackgroundsUploadFromDeviceClicked:
      return "kBackgroundsUploadFromDeviceClicked";
    case CustomizeDialogAction::kShortcutsCustomLinksClicked:
      return "kShortcutsCustomLinksClicked";
    case CustomizeDialogAction::kShortcutsMostVisitedClicked:
      return "kShortcutsMostVisitedClicked";
    case CustomizeDialogAction::kShortcutsVisibilityToggleClicked:
      return "kShortcutsVisibilityToggleClicked";
    default:
      return nullptr;
  }
}

std::string CustomizeDialogActionToString(CustomizeDialogAction value) {
  const char *str = CustomizeDialogActionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CustomizeDialogAction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CustomizeDialogAction value) {
  return os << CustomizeDialogActionToString(value);
}

NOINLINE static const char* OptInStatusToStringHelper(OptInStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case OptInStatus::kExplicitOptIn:
      return "kExplicitOptIn";
    case OptInStatus::kImplicitOptIn:
      return "kImplicitOptIn";
    case OptInStatus::kOptOut:
      return "kOptOut";
    default:
      return nullptr;
  }
}

std::string OptInStatusToString(OptInStatus value) {
  const char *str = OptInStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown OptInStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, OptInStatus value) {
  return os << OptInStatusToString(value);
}

namespace internal {
// static
bool PromoPart_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PromoPart_Data* object = static_cast<const PromoPart_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PromoPart_Tag::kImage: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_image, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_image, validation_context))
        return false;
      return true;
    }
    case PromoPart_Tag::kLink: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_link, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_link, validation_context))
        return false;
      return true;
    }
    case PromoPart_Tag::kText: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_text, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_text, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PromoPart");
      return false;
    }
  }
}


// static
bool BackgroundImage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundImage_Data* object =
      static_cast<const BackgroundImage_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->url_2x, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->attribution_url, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& size_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->size, validation_context,
                                         &size_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& repeat_x_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->repeat_x, validation_context,
                                         &repeat_x_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& repeat_y_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->repeat_y, validation_context,
                                         &repeat_y_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& position_x_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->position_x, validation_context,
                                         &position_x_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& position_y_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->position_y, validation_context,
                                         &position_y_validate_params)) {
    return false;
  }


  if (!::new_tab_page::mojom::internal::NtpBackgroundImageSource_Data
        ::Validate(object->image_source, validation_context))
    return false;

  return true;
}

BackgroundImage_Data::BackgroundImage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Theme_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Theme_Data* object =
      static_cast<const Theme_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text_color, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->text_color, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->background_color, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->background_color, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->logo_color, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& background_image_collection_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->background_image_collection_id, validation_context,
                                         &background_image_collection_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->background_image, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& background_image_attribution_1_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->background_image_attribution_1, validation_context,
                                         &background_image_attribution_1_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& background_image_attribution_2_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->background_image_attribution_2, validation_context,
                                         &background_image_attribution_2_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->background_image_attribution_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->most_visited, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->most_visited, validation_context))
    return false;

  return true;
}

Theme_Data::Theme_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ImageDoodle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ImageDoodle_Data* object =
      static_cast<const ImageDoodle_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->animation_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->background_color, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->background_color, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_impression_log_url, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_impression_log_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->animation_impression_log_url, validation_context))
    return false;

  return true;
}

ImageDoodle_Data::ImageDoodle_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AllModeImageDoodle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AllModeImageDoodle_Data* object =
      static_cast<const AllModeImageDoodle_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->light, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->light, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->dark, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->on_click_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->share_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->share_url, validation_context))
    return false;

  return true;
}

AllModeImageDoodle_Data::AllModeImageDoodle_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InteractiveDoodle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InteractiveDoodle_Data* object =
      static_cast<const InteractiveDoodle_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

InteractiveDoodle_Data::InteractiveDoodle_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Doodle_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Doodle_Data* object =
      static_cast<const Doodle_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->interactive, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  return true;
}

Doodle_Data::Doodle_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PromoImagePart_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PromoImagePart_Data* object =
      static_cast<const PromoImagePart_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->target, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->target, validation_context))
    return false;

  return true;
}

PromoImagePart_Data::PromoImagePart_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PromoLinkPart_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PromoLinkPart_Data* object =
      static_cast<const PromoLinkPart_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PromoLinkPart_Data::PromoLinkPart_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PromoTextPart_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PromoTextPart_Data* object =
      static_cast<const PromoTextPart_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  return true;
}

PromoTextPart_Data::PromoTextPart_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Promo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Promo_Data* object =
      static_cast<const Promo_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->log_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->middle_slot_parts, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& middle_slot_parts_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->middle_slot_parts, validation_context,
                                         &middle_slot_parts_validate_params)) {
    return false;
  }

  return true;
}

Promo_Data::Promo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ModuleIdName_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ModuleIdName_Data* object =
      static_cast<const ModuleIdName_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

ModuleIdName_Data::ModuleIdName_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetMostVisitedSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetMostVisitedSettings_Params_Data* object =
      static_cast<const PageHandler_SetMostVisitedSettings_Params_Data*>(data);


  if (!::ntp_tiles::mojom::internal::TileType_Data
        ::Validate(object->shortcuts_type, validation_context))
    return false;

  return true;
}

PageHandler_SetMostVisitedSettings_Params_Data::PageHandler_SetMostVisitedSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetMostVisitedSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetMostVisitedSettings_Params_Data* object =
      static_cast<const PageHandler_GetMostVisitedSettings_Params_Data*>(data);

  return true;
}

PageHandler_GetMostVisitedSettings_Params_Data::PageHandler_GetMostVisitedSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetMostVisitedSettings_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetMostVisitedSettings_ResponseParams_Data* object =
      static_cast<const PageHandler_GetMostVisitedSettings_ResponseParams_Data*>(data);


  if (!::ntp_tiles::mojom::internal::TileType_Data
        ::Validate(object->shortcuts_type, validation_context))
    return false;

  return true;
}

PageHandler_GetMostVisitedSettings_ResponseParams_Data::PageHandler_GetMostVisitedSettings_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetDoodle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetDoodle_Params_Data* object =
      static_cast<const PageHandler_GetDoodle_Params_Data*>(data);

  return true;
}

PageHandler_GetDoodle_Params_Data::PageHandler_GetDoodle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetDoodle_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetDoodle_ResponseParams_Data* object =
      static_cast<const PageHandler_GetDoodle_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->doodle, validation_context))
    return false;

  return true;
}

PageHandler_GetDoodle_ResponseParams_Data::PageHandler_GetDoodle_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_UpdatePromoData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_UpdatePromoData_Params_Data* object =
      static_cast<const PageHandler_UpdatePromoData_Params_Data*>(data);

  return true;
}

PageHandler_UpdatePromoData_Params_Data::PageHandler_UpdatePromoData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_BlocklistPromo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_BlocklistPromo_Params_Data* object =
      static_cast<const PageHandler_BlocklistPromo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->promo_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& promo_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->promo_id, validation_context,
                                         &promo_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_BlocklistPromo_Params_Data::PageHandler_BlocklistPromo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_UndoBlocklistPromo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_UndoBlocklistPromo_Params_Data* object =
      static_cast<const PageHandler_UndoBlocklistPromo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->promo_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& promo_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->promo_id, validation_context,
                                         &promo_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_UndoBlocklistPromo_Params_Data::PageHandler_UndoBlocklistPromo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnDismissModule_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnDismissModule_Params_Data* object =
      static_cast<const PageHandler_OnDismissModule_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->module_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& module_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->module_id, validation_context,
                                         &module_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_OnDismissModule_Params_Data::PageHandler_OnDismissModule_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnRestoreModule_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnRestoreModule_Params_Data* object =
      static_cast<const PageHandler_OnRestoreModule_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->module_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& module_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->module_id, validation_context,
                                         &module_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_OnRestoreModule_Params_Data::PageHandler_OnRestoreModule_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetModulesVisible_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetModulesVisible_Params_Data* object =
      static_cast<const PageHandler_SetModulesVisible_Params_Data*>(data);

  return true;
}

PageHandler_SetModulesVisible_Params_Data::PageHandler_SetModulesVisible_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetModuleDisabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetModuleDisabled_Params_Data* object =
      static_cast<const PageHandler_SetModuleDisabled_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->module_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& module_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->module_id, validation_context,
                                         &module_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_SetModuleDisabled_Params_Data::PageHandler_SetModuleDisabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_UpdateDisabledModules_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_UpdateDisabledModules_Params_Data* object =
      static_cast<const PageHandler_UpdateDisabledModules_Params_Data*>(data);

  return true;
}

PageHandler_UpdateDisabledModules_Params_Data::PageHandler_UpdateDisabledModules_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnModulesLoadedWithData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnModulesLoadedWithData_Params_Data* object =
      static_cast<const PageHandler_OnModulesLoadedWithData_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->module_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& module_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->module_ids, validation_context,
                                         &module_ids_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_OnModulesLoadedWithData_Params_Data::PageHandler_OnModulesLoadedWithData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnModuleUsed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnModuleUsed_Params_Data* object =
      static_cast<const PageHandler_OnModuleUsed_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->module_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& module_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->module_id, validation_context,
                                         &module_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_OnModuleUsed_Params_Data::PageHandler_OnModuleUsed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetModulesIdNames_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetModulesIdNames_Params_Data* object =
      static_cast<const PageHandler_GetModulesIdNames_Params_Data*>(data);

  return true;
}

PageHandler_GetModulesIdNames_Params_Data::PageHandler_GetModulesIdNames_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetModulesIdNames_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetModulesIdNames_ResponseParams_Data* object =
      static_cast<const PageHandler_GetModulesIdNames_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetModulesIdNames_ResponseParams_Data::PageHandler_GetModulesIdNames_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetModulesOrder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetModulesOrder_Params_Data* object =
      static_cast<const PageHandler_SetModulesOrder_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->module_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& module_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->module_ids, validation_context,
                                         &module_ids_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_SetModulesOrder_Params_Data::PageHandler_SetModulesOrder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetModulesOrder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetModulesOrder_Params_Data* object =
      static_cast<const PageHandler_GetModulesOrder_Params_Data*>(data);

  return true;
}

PageHandler_GetModulesOrder_Params_Data::PageHandler_GetModulesOrder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetModulesOrder_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetModulesOrder_ResponseParams_Data* object =
      static_cast<const PageHandler_GetModulesOrder_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->module_ids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& module_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->module_ids, validation_context,
                                         &module_ids_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetModulesOrder_ResponseParams_Data::PageHandler_GetModulesOrder_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_UpdateModulesLoadable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_UpdateModulesLoadable_Params_Data* object =
      static_cast<const PageHandler_UpdateModulesLoadable_Params_Data*>(data);

  return true;
}

PageHandler_UpdateModulesLoadable_Params_Data::PageHandler_UpdateModulesLoadable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_UpdateFooterVisibility_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_UpdateFooterVisibility_Params_Data* object =
      static_cast<const PageHandler_UpdateFooterVisibility_Params_Data*>(data);

  return true;
}

PageHandler_UpdateFooterVisibility_Params_Data::PageHandler_UpdateFooterVisibility_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_MaybeShowFeaturePromo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_MaybeShowFeaturePromo_Params_Data* object =
      static_cast<const PageHandler_MaybeShowFeaturePromo_Params_Data*>(data);


  if (!::new_tab_page::mojom::internal::IphFeature_Data
        ::Validate(object->iph_feature, validation_context))
    return false;

  return true;
}

PageHandler_MaybeShowFeaturePromo_Params_Data::PageHandler_MaybeShowFeaturePromo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_IncrementComposeButtonShownCount_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_IncrementComposeButtonShownCount_Params_Data* object =
      static_cast<const PageHandler_IncrementComposeButtonShownCount_Params_Data*>(data);

  return true;
}

PageHandler_IncrementComposeButtonShownCount_Params_Data::PageHandler_IncrementComposeButtonShownCount_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnOneGoogleBarRendered_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnOneGoogleBarRendered_Params_Data* object =
      static_cast<const PageHandler_OnOneGoogleBarRendered_Params_Data*>(data);

  return true;
}

PageHandler_OnOneGoogleBarRendered_Params_Data::PageHandler_OnOneGoogleBarRendered_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnPromoRendered_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnPromoRendered_Params_Data* object =
      static_cast<const PageHandler_OnPromoRendered_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->log_url, validation_context))
    return false;

  return true;
}

PageHandler_OnPromoRendered_Params_Data::PageHandler_OnPromoRendered_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnCustomizeDialogAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnCustomizeDialogAction_Params_Data* object =
      static_cast<const PageHandler_OnCustomizeDialogAction_Params_Data*>(data);


  if (!::new_tab_page::mojom::internal::CustomizeDialogAction_Data
        ::Validate(object->action, validation_context))
    return false;

  return true;
}

PageHandler_OnCustomizeDialogAction_Params_Data::PageHandler_OnCustomizeDialogAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnDoodleImageClicked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnDoodleImageClicked_Params_Data* object =
      static_cast<const PageHandler_OnDoodleImageClicked_Params_Data*>(data);


  if (!::new_tab_page::mojom::internal::DoodleImageType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->log_url, validation_context))
    return false;

  return true;
}

PageHandler_OnDoodleImageClicked_Params_Data::PageHandler_OnDoodleImageClicked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnDoodleImageRendered_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnDoodleImageRendered_Params_Data* object =
      static_cast<const PageHandler_OnDoodleImageRendered_Params_Data*>(data);


  if (!::new_tab_page::mojom::internal::DoodleImageType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->log_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->log_url, validation_context))
    return false;

  return true;
}

PageHandler_OnDoodleImageRendered_Params_Data::PageHandler_OnDoodleImageRendered_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnDoodleImageRendered_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnDoodleImageRendered_ResponseParams_Data* object =
      static_cast<const PageHandler_OnDoodleImageRendered_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& image_click_params_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->image_click_params, validation_context,
                                         &image_click_params_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->interaction_log_url, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& share_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->share_id, validation_context,
                                         &share_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_OnDoodleImageRendered_ResponseParams_Data::PageHandler_OnDoodleImageRendered_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnDoodleShared_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnDoodleShared_Params_Data* object =
      static_cast<const PageHandler_OnDoodleShared_Params_Data*>(data);


  if (!::new_tab_page::mojom::internal::DoodleShareChannel_Data
        ::Validate(object->channel, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->doodle_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& doodle_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->doodle_id, validation_context,
                                         &doodle_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& share_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->share_id, validation_context,
                                         &share_id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_OnDoodleShared_Params_Data::PageHandler_OnDoodleShared_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnPromoLinkClicked_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnPromoLinkClicked_Params_Data* object =
      static_cast<const PageHandler_OnPromoLinkClicked_Params_Data*>(data);

  return true;
}

PageHandler_OnPromoLinkClicked_Params_Data::PageHandler_OnPromoLinkClicked_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OnAppRendered_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OnAppRendered_Params_Data* object =
      static_cast<const PageHandler_OnAppRendered_Params_Data*>(data);

  return true;
}

PageHandler_OnAppRendered_Params_Data::PageHandler_OnAppRendered_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_SetTheme_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_SetTheme_Params_Data* object =
      static_cast<const Page_SetTheme_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->theme, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->theme, validation_context))
    return false;

  return true;
}

Page_SetTheme_Params_Data::Page_SetTheme_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_SetDisabledModules_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_SetDisabledModules_Params_Data* object =
      static_cast<const Page_SetDisabledModules_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ids, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->ids, validation_context,
                                         &ids_validate_params)) {
    return false;
  }

  return true;
}

Page_SetDisabledModules_Params_Data::Page_SetDisabledModules_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_SetModulesLoadable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_SetModulesLoadable_Params_Data* object =
      static_cast<const Page_SetModulesLoadable_Params_Data*>(data);

  return true;
}

Page_SetModulesLoadable_Params_Data::Page_SetModulesLoadable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_SetPromo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_SetPromo_Params_Data* object =
      static_cast<const Page_SetPromo_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->promo, validation_context))
    return false;

  return true;
}

Page_SetPromo_Params_Data::Page_SetPromo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ShowWebstoreToast_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ShowWebstoreToast_Params_Data* object =
      static_cast<const Page_ShowWebstoreToast_Params_Data*>(data);

  return true;
}

Page_ShowWebstoreToast_Params_Data::Page_ShowWebstoreToast_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_SetWallpaperSearchButtonVisibility_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_SetWallpaperSearchButtonVisibility_Params_Data* object =
      static_cast<const Page_SetWallpaperSearchButtonVisibility_Params_Data*>(data);

  return true;
}

Page_SetWallpaperSearchButtonVisibility_Params_Data::Page_SetWallpaperSearchButtonVisibility_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_FooterVisibilityUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_FooterVisibilityUpdated_Params_Data* object =
      static_cast<const Page_FooterVisibilityUpdated_Params_Data*>(data);

  return true;
}

Page_FooterVisibilityUpdated_Params_Data::Page_FooterVisibilityUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ConnectToParentDocument_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ConnectToParentDocument_Params_Data* object =
      static_cast<const Page_ConnectToParentDocument_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->child_untrusted_document_remote, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->child_untrusted_document_remote,
                                                 validation_context)) {
    return false;
  }

  return true;
}

Page_ConnectToParentDocument_Params_Data::Page_ConnectToParentDocument_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace new_tab_page

namespace perfetto {

// static
void TraceFormatTraits<::new_tab_page::mojom::NtpBackgroundImageSource>::WriteIntoTrace(
   perfetto::TracedValue context, ::new_tab_page::mojom::NtpBackgroundImageSource value) {
  return std::move(context).WriteString(::new_tab_page::mojom::NtpBackgroundImageSourceToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::new_tab_page::mojom::IphFeature>::WriteIntoTrace(
   perfetto::TracedValue context, ::new_tab_page::mojom::IphFeature value) {
  return std::move(context).WriteString(::new_tab_page::mojom::IphFeatureToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::new_tab_page::mojom::DoodleImageType>::WriteIntoTrace(
   perfetto::TracedValue context, ::new_tab_page::mojom::DoodleImageType value) {
  return std::move(context).WriteString(::new_tab_page::mojom::DoodleImageTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::new_tab_page::mojom::DoodleShareChannel>::WriteIntoTrace(
   perfetto::TracedValue context, ::new_tab_page::mojom::DoodleShareChannel value) {
  return std::move(context).WriteString(::new_tab_page::mojom::DoodleShareChannelToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::new_tab_page::mojom::CustomizeDialogAction>::WriteIntoTrace(
   perfetto::TracedValue context, ::new_tab_page::mojom::CustomizeDialogAction value) {
  return std::move(context).WriteString(::new_tab_page::mojom::CustomizeDialogActionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::new_tab_page::mojom::OptInStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::new_tab_page::mojom::OptInStatus value) {
  return std::move(context).WriteString(::new_tab_page::mojom::OptInStatusToString(value));
}

} // namespace perfetto