// chrome/browser/ui/webui/new_tab_footer/new_tab_footer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/new_tab_footer/new_tab_footer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/new_tab_footer/new_tab_footer.mojom-params-data.h"
#include "chrome/browser/ui/webui/new_tab_footer/new_tab_footer.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/new_tab_footer/new_tab_footer.mojom-import-headers.h"
#include "chrome/browser/ui/webui/new_tab_footer/new_tab_footer.mojom-test-utils.h"


namespace new_tab_footer::mojom {
ManagementNotice::ManagementNotice()
    : text(),
      custom_bitmap_data_url() {}

ManagementNotice::ManagementNotice(
    const std::string& text_in,
    const std::optional<::GURL>& custom_bitmap_data_url_in)
    : text(std::move(text_in)),
      custom_bitmap_data_url(std::move(custom_bitmap_data_url_in)) {}

ManagementNotice::~ManagementNotice() = default;

void ManagementNotice::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "custom_bitmap_data_url"), this->custom_bitmap_data_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ManagementNotice::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BackgroundAttribution::BackgroundAttribution()
    : name(),
      url() {}

BackgroundAttribution::BackgroundAttribution(
    const std::string& name_in,
    const std::optional<::GURL>& url_in)
    : name(std::move(name_in)),
      url(std::move(url_in)) {}

BackgroundAttribution::~BackgroundAttribution() = default;

void BackgroundAttribution::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool BackgroundAttribution::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

NewTabFooterHandlerFactory::IPCStableHashFunction NewTabFooterHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NewTabFooterHandlerFactory>(message.name())) {
    case messages::NewTabFooterHandlerFactory::kCreateNewTabFooterHandler: {
      return &NewTabFooterHandlerFactory::CreateNewTabFooterHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NewTabFooterHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NewTabFooterHandlerFactory>(message.name())) {
      case messages::NewTabFooterHandlerFactory::kCreateNewTabFooterHandler:
            return "Receive new_tab_footer::mojom::NewTabFooterHandlerFactory::CreateNewTabFooterHandler";
    }
  } else {
    switch (static_cast<messages::NewTabFooterHandlerFactory>(message.name())) {
      case messages::NewTabFooterHandlerFactory::kCreateNewTabFooterHandler:
            return "Receive reply new_tab_footer::mojom::NewTabFooterHandlerFactory::CreateNewTabFooterHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NewTabFooterHandlerFactory::CreateNewTabFooterHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x92fd482a;  // IPCStableHash for new_tab_footer::mojom::NewTabFooterHandlerFactory::CreateNewTabFooterHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NewTabFooterHandlerFactoryProxy::NewTabFooterHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NewTabFooterHandlerFactoryProxy::CreateNewTabFooterHandler(
    ::mojo::PendingRemote<NewTabFooterDocument> in_document, ::mojo::PendingReceiver<NewTabFooterHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_footer::mojom::NewTabFooterHandlerFactory::CreateNewTabFooterHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document"), in_document,
                        "<value of type ::mojo::PendingRemote<NewTabFooterDocument>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<NewTabFooterHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NewTabFooterHandlerFactory::kCreateNewTabFooterHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_footer::mojom::internal::NewTabFooterHandlerFactory_CreateNewTabFooterHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::new_tab_footer::mojom::NewTabFooterDocumentInterfaceBase>>(
    in_document,
    &params->document,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->document)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid document in NewTabFooterHandlerFactory.CreateNewTabFooterHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::new_tab_footer::mojom::NewTabFooterHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in NewTabFooterHandlerFactory.CreateNewTabFooterHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NewTabFooterHandlerFactory::Name_);
  message.set_method_name("CreateNewTabFooterHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NewTabFooterHandlerFactoryStubDispatch::Accept(
    NewTabFooterHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NewTabFooterHandlerFactory>(message->header()->name)) {
    case messages::NewTabFooterHandlerFactory::kCreateNewTabFooterHandler: {
      DCHECK(message->is_serialized());
      internal::NewTabFooterHandlerFactory_CreateNewTabFooterHandler_Params_Data* params =
          reinterpret_cast<internal::NewTabFooterHandlerFactory_CreateNewTabFooterHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NewTabFooterHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<NewTabFooterDocument> p_document{};
      ::mojo::PendingReceiver<NewTabFooterHandler> p_handler{};
      NewTabFooterHandlerFactory_CreateNewTabFooterHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_document =
            input_data_view.TakeDocument<decltype(p_document)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NewTabFooterHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNewTabFooterHandler(        
        std::move(p_document), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool NewTabFooterHandlerFactoryStubDispatch::AcceptWithResponder(
    NewTabFooterHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NewTabFooterHandlerFactory>(message->header()->name)) {
    case messages::NewTabFooterHandlerFactory::kCreateNewTabFooterHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNewTabFooterHandlerFactoryValidationInfo[] = {
    { &internal::NewTabFooterHandlerFactory_CreateNewTabFooterHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool NewTabFooterHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::new_tab_footer::mojom::NewTabFooterHandlerFactory::Name_,
    kNewTabFooterHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

NewTabFooterHandler::IPCStableHashFunction NewTabFooterHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NewTabFooterHandler>(message.name())) {
    case messages::NewTabFooterHandler::kUpdateNtpExtensionName: {
      return &NewTabFooterHandler::UpdateNtpExtensionName_Sym::IPCStableHash;
    }
    case messages::NewTabFooterHandler::kUpdateManagementNotice: {
      return &NewTabFooterHandler::UpdateManagementNotice_Sym::IPCStableHash;
    }
    case messages::NewTabFooterHandler::kUpdateAttachedTabState: {
      return &NewTabFooterHandler::UpdateAttachedTabState_Sym::IPCStableHash;
    }
    case messages::NewTabFooterHandler::kUpdateBackgroundAttribution: {
      return &NewTabFooterHandler::UpdateBackgroundAttribution_Sym::IPCStableHash;
    }
    case messages::NewTabFooterHandler::kOpenExtensionOptionsPageWithFallback: {
      return &NewTabFooterHandler::OpenExtensionOptionsPageWithFallback_Sym::IPCStableHash;
    }
    case messages::NewTabFooterHandler::kOpenManagementPage: {
      return &NewTabFooterHandler::OpenManagementPage_Sym::IPCStableHash;
    }
    case messages::NewTabFooterHandler::kOpenUrlInCurrentTab: {
      return &NewTabFooterHandler::OpenUrlInCurrentTab_Sym::IPCStableHash;
    }
    case messages::NewTabFooterHandler::kShowContextMenu: {
      return &NewTabFooterHandler::ShowContextMenu_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NewTabFooterHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NewTabFooterHandler>(message.name())) {
      case messages::NewTabFooterHandler::kUpdateNtpExtensionName:
            return "Receive new_tab_footer::mojom::NewTabFooterHandler::UpdateNtpExtensionName";
      case messages::NewTabFooterHandler::kUpdateManagementNotice:
            return "Receive new_tab_footer::mojom::NewTabFooterHandler::UpdateManagementNotice";
      case messages::NewTabFooterHandler::kUpdateAttachedTabState:
            return "Receive new_tab_footer::mojom::NewTabFooterHandler::UpdateAttachedTabState";
      case messages::NewTabFooterHandler::kUpdateBackgroundAttribution:
            return "Receive new_tab_footer::mojom::NewTabFooterHandler::UpdateBackgroundAttribution";
      case messages::NewTabFooterHandler::kOpenExtensionOptionsPageWithFallback:
            return "Receive new_tab_footer::mojom::NewTabFooterHandler::OpenExtensionOptionsPageWithFallback";
      case messages::NewTabFooterHandler::kOpenManagementPage:
            return "Receive new_tab_footer::mojom::NewTabFooterHandler::OpenManagementPage";
      case messages::NewTabFooterHandler::kOpenUrlInCurrentTab:
            return "Receive new_tab_footer::mojom::NewTabFooterHandler::OpenUrlInCurrentTab";
      case messages::NewTabFooterHandler::kShowContextMenu:
            return "Receive new_tab_footer::mojom::NewTabFooterHandler::ShowContextMenu";
    }
  } else {
    switch (static_cast<messages::NewTabFooterHandler>(message.name())) {
      case messages::NewTabFooterHandler::kUpdateNtpExtensionName:
            return "Receive reply new_tab_footer::mojom::NewTabFooterHandler::UpdateNtpExtensionName";
      case messages::NewTabFooterHandler::kUpdateManagementNotice:
            return "Receive reply new_tab_footer::mojom::NewTabFooterHandler::UpdateManagementNotice";
      case messages::NewTabFooterHandler::kUpdateAttachedTabState:
            return "Receive reply new_tab_footer::mojom::NewTabFooterHandler::UpdateAttachedTabState";
      case messages::NewTabFooterHandler::kUpdateBackgroundAttribution:
            return "Receive reply new_tab_footer::mojom::NewTabFooterHandler::UpdateBackgroundAttribution";
      case messages::NewTabFooterHandler::kOpenExtensionOptionsPageWithFallback:
            return "Receive reply new_tab_footer::mojom::NewTabFooterHandler::OpenExtensionOptionsPageWithFallback";
      case messages::NewTabFooterHandler::kOpenManagementPage:
            return "Receive reply new_tab_footer::mojom::NewTabFooterHandler::OpenManagementPage";
      case messages::NewTabFooterHandler::kOpenUrlInCurrentTab:
            return "Receive reply new_tab_footer::mojom::NewTabFooterHandler::OpenUrlInCurrentTab";
      case messages::NewTabFooterHandler::kShowContextMenu:
            return "Receive reply new_tab_footer::mojom::NewTabFooterHandler::ShowContextMenu";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NewTabFooterHandler::UpdateNtpExtensionName_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0e4d8195;  // IPCStableHash for new_tab_footer::mojom::NewTabFooterHandler::UpdateNtpExtensionName
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NewTabFooterHandler::UpdateManagementNotice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71903808;  // IPCStableHash for new_tab_footer::mojom::NewTabFooterHandler::UpdateManagementNotice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NewTabFooterHandler::UpdateAttachedTabState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5fb81a51;  // IPCStableHash for new_tab_footer::mojom::NewTabFooterHandler::UpdateAttachedTabState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NewTabFooterHandler::UpdateBackgroundAttribution_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7777534e;  // IPCStableHash for new_tab_footer::mojom::NewTabFooterHandler::UpdateBackgroundAttribution
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NewTabFooterHandler::OpenExtensionOptionsPageWithFallback_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6f423be2;  // IPCStableHash for new_tab_footer::mojom::NewTabFooterHandler::OpenExtensionOptionsPageWithFallback
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NewTabFooterHandler::OpenManagementPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe38c2733;  // IPCStableHash for new_tab_footer::mojom::NewTabFooterHandler::OpenManagementPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NewTabFooterHandler::OpenUrlInCurrentTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6602842b;  // IPCStableHash for new_tab_footer::mojom::NewTabFooterHandler::OpenUrlInCurrentTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NewTabFooterHandler::ShowContextMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfefc56af;  // IPCStableHash for new_tab_footer::mojom::NewTabFooterHandler::ShowContextMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NewTabFooterHandlerProxy::NewTabFooterHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NewTabFooterHandlerProxy::UpdateNtpExtensionName(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_footer::mojom::NewTabFooterHandler::UpdateNtpExtensionName");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NewTabFooterHandler::kUpdateNtpExtensionName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_footer::mojom::internal::NewTabFooterHandler_UpdateNtpExtensionName_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NewTabFooterHandler::Name_);
  message.set_method_name("UpdateNtpExtensionName");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NewTabFooterHandlerProxy::UpdateManagementNotice(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_footer::mojom::NewTabFooterHandler::UpdateManagementNotice");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NewTabFooterHandler::kUpdateManagementNotice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_footer::mojom::internal::NewTabFooterHandler_UpdateManagementNotice_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NewTabFooterHandler::Name_);
  message.set_method_name("UpdateManagementNotice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NewTabFooterHandlerProxy::UpdateAttachedTabState(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_footer::mojom::NewTabFooterHandler::UpdateAttachedTabState");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NewTabFooterHandler::kUpdateAttachedTabState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_footer::mojom::internal::NewTabFooterHandler_UpdateAttachedTabState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NewTabFooterHandler::Name_);
  message.set_method_name("UpdateAttachedTabState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NewTabFooterHandlerProxy::UpdateBackgroundAttribution(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_footer::mojom::NewTabFooterHandler::UpdateBackgroundAttribution");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NewTabFooterHandler::kUpdateBackgroundAttribution), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_footer::mojom::internal::NewTabFooterHandler_UpdateBackgroundAttribution_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NewTabFooterHandler::Name_);
  message.set_method_name("UpdateBackgroundAttribution");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NewTabFooterHandlerProxy::OpenExtensionOptionsPageWithFallback(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_footer::mojom::NewTabFooterHandler::OpenExtensionOptionsPageWithFallback");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NewTabFooterHandler::kOpenExtensionOptionsPageWithFallback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_footer::mojom::internal::NewTabFooterHandler_OpenExtensionOptionsPageWithFallback_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NewTabFooterHandler::Name_);
  message.set_method_name("OpenExtensionOptionsPageWithFallback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NewTabFooterHandlerProxy::OpenManagementPage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_footer::mojom::NewTabFooterHandler::OpenManagementPage");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NewTabFooterHandler::kOpenManagementPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_footer::mojom::internal::NewTabFooterHandler_OpenManagementPage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NewTabFooterHandler::Name_);
  message.set_method_name("OpenManagementPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NewTabFooterHandlerProxy::OpenUrlInCurrentTab(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_footer::mojom::NewTabFooterHandler::OpenUrlInCurrentTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NewTabFooterHandler::kOpenUrlInCurrentTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_footer::mojom::internal::NewTabFooterHandler_OpenUrlInCurrentTab_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in NewTabFooterHandler.OpenUrlInCurrentTab request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NewTabFooterHandler::Name_);
  message.set_method_name("OpenUrlInCurrentTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NewTabFooterHandlerProxy::ShowContextMenu(
    const ::gfx::Point& in_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_footer::mojom::NewTabFooterHandler::ShowContextMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point"), in_point,
                        "<value of type const ::gfx::Point&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NewTabFooterHandler::kShowContextMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_footer::mojom::internal::NewTabFooterHandler_ShowContextMenu_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->point)::BaseType> point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_point,
    point_fragment);

  params->point.Set(
      point_fragment.is_null() ? nullptr : point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null point in NewTabFooterHandler.ShowContextMenu request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NewTabFooterHandler::Name_);
  message.set_method_name("ShowContextMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NewTabFooterHandlerStubDispatch::Accept(
    NewTabFooterHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NewTabFooterHandler>(message->header()->name)) {
    case messages::NewTabFooterHandler::kUpdateNtpExtensionName: {
      DCHECK(message->is_serialized());
      internal::NewTabFooterHandler_UpdateNtpExtensionName_Params_Data* params =
          reinterpret_cast<internal::NewTabFooterHandler_UpdateNtpExtensionName_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NewTabFooterHandler.0
      bool success = true;
      NewTabFooterHandler_UpdateNtpExtensionName_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NewTabFooterHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateNtpExtensionName(        );
      return true;
    }
    case messages::NewTabFooterHandler::kUpdateManagementNotice: {
      DCHECK(message->is_serialized());
      internal::NewTabFooterHandler_UpdateManagementNotice_Params_Data* params =
          reinterpret_cast<internal::NewTabFooterHandler_UpdateManagementNotice_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NewTabFooterHandler.1
      bool success = true;
      NewTabFooterHandler_UpdateManagementNotice_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NewTabFooterHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateManagementNotice(        );
      return true;
    }
    case messages::NewTabFooterHandler::kUpdateAttachedTabState: {
      DCHECK(message->is_serialized());
      internal::NewTabFooterHandler_UpdateAttachedTabState_Params_Data* params =
          reinterpret_cast<internal::NewTabFooterHandler_UpdateAttachedTabState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NewTabFooterHandler.2
      bool success = true;
      NewTabFooterHandler_UpdateAttachedTabState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NewTabFooterHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateAttachedTabState(        );
      return true;
    }
    case messages::NewTabFooterHandler::kUpdateBackgroundAttribution: {
      DCHECK(message->is_serialized());
      internal::NewTabFooterHandler_UpdateBackgroundAttribution_Params_Data* params =
          reinterpret_cast<internal::NewTabFooterHandler_UpdateBackgroundAttribution_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NewTabFooterHandler.3
      bool success = true;
      NewTabFooterHandler_UpdateBackgroundAttribution_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NewTabFooterHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateBackgroundAttribution(        );
      return true;
    }
    case messages::NewTabFooterHandler::kOpenExtensionOptionsPageWithFallback: {
      DCHECK(message->is_serialized());
      internal::NewTabFooterHandler_OpenExtensionOptionsPageWithFallback_Params_Data* params =
          reinterpret_cast<internal::NewTabFooterHandler_OpenExtensionOptionsPageWithFallback_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NewTabFooterHandler.4
      bool success = true;
      NewTabFooterHandler_OpenExtensionOptionsPageWithFallback_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NewTabFooterHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenExtensionOptionsPageWithFallback(        );
      return true;
    }
    case messages::NewTabFooterHandler::kOpenManagementPage: {
      DCHECK(message->is_serialized());
      internal::NewTabFooterHandler_OpenManagementPage_Params_Data* params =
          reinterpret_cast<internal::NewTabFooterHandler_OpenManagementPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NewTabFooterHandler.5
      bool success = true;
      NewTabFooterHandler_OpenManagementPage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NewTabFooterHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenManagementPage(        );
      return true;
    }
    case messages::NewTabFooterHandler::kOpenUrlInCurrentTab: {
      DCHECK(message->is_serialized());
      internal::NewTabFooterHandler_OpenUrlInCurrentTab_Params_Data* params =
          reinterpret_cast<internal::NewTabFooterHandler_OpenUrlInCurrentTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NewTabFooterHandler.6
      bool success = true;
      ::GURL p_url{};
      NewTabFooterHandler_OpenUrlInCurrentTab_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NewTabFooterHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenUrlInCurrentTab(        
        std::move(p_url));
      return true;
    }
    case messages::NewTabFooterHandler::kShowContextMenu: {
      DCHECK(message->is_serialized());
      internal::NewTabFooterHandler_ShowContextMenu_Params_Data* params =
          reinterpret_cast<internal::NewTabFooterHandler_ShowContextMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NewTabFooterHandler.7
      bool success = true;
      ::gfx::Point p_point{};
      NewTabFooterHandler_ShowContextMenu_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NewTabFooterHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowContextMenu(        
        std::move(p_point));
      return true;
    }
  }
  return false;
}

// static
bool NewTabFooterHandlerStubDispatch::AcceptWithResponder(
    NewTabFooterHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NewTabFooterHandler>(message->header()->name)) {
    case messages::NewTabFooterHandler::kUpdateNtpExtensionName: {
      break;
    }
    case messages::NewTabFooterHandler::kUpdateManagementNotice: {
      break;
    }
    case messages::NewTabFooterHandler::kUpdateAttachedTabState: {
      break;
    }
    case messages::NewTabFooterHandler::kUpdateBackgroundAttribution: {
      break;
    }
    case messages::NewTabFooterHandler::kOpenExtensionOptionsPageWithFallback: {
      break;
    }
    case messages::NewTabFooterHandler::kOpenManagementPage: {
      break;
    }
    case messages::NewTabFooterHandler::kOpenUrlInCurrentTab: {
      break;
    }
    case messages::NewTabFooterHandler::kShowContextMenu: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNewTabFooterHandlerValidationInfo[] = {
    { &internal::NewTabFooterHandler_UpdateNtpExtensionName_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NewTabFooterHandler_UpdateManagementNotice_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NewTabFooterHandler_UpdateAttachedTabState_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NewTabFooterHandler_UpdateBackgroundAttribution_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NewTabFooterHandler_OpenExtensionOptionsPageWithFallback_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NewTabFooterHandler_OpenManagementPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NewTabFooterHandler_OpenUrlInCurrentTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NewTabFooterHandler_ShowContextMenu_Params_Data::Validate,
     nullptr /* no response */},
};

bool NewTabFooterHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::new_tab_footer::mojom::NewTabFooterHandler::Name_,
    kNewTabFooterHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

NewTabFooterDocument::IPCStableHashFunction NewTabFooterDocument::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NewTabFooterDocument>(message.name())) {
    case messages::NewTabFooterDocument::kSetNtpExtensionName: {
      return &NewTabFooterDocument::SetNtpExtensionName_Sym::IPCStableHash;
    }
    case messages::NewTabFooterDocument::kSetManagementNotice: {
      return &NewTabFooterDocument::SetManagementNotice_Sym::IPCStableHash;
    }
    case messages::NewTabFooterDocument::kAttachedTabStateUpdated: {
      return &NewTabFooterDocument::AttachedTabStateUpdated_Sym::IPCStableHash;
    }
    case messages::NewTabFooterDocument::kSetBackgroundAttribution: {
      return &NewTabFooterDocument::SetBackgroundAttribution_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NewTabFooterDocument::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NewTabFooterDocument>(message.name())) {
      case messages::NewTabFooterDocument::kSetNtpExtensionName:
            return "Receive new_tab_footer::mojom::NewTabFooterDocument::SetNtpExtensionName";
      case messages::NewTabFooterDocument::kSetManagementNotice:
            return "Receive new_tab_footer::mojom::NewTabFooterDocument::SetManagementNotice";
      case messages::NewTabFooterDocument::kAttachedTabStateUpdated:
            return "Receive new_tab_footer::mojom::NewTabFooterDocument::AttachedTabStateUpdated";
      case messages::NewTabFooterDocument::kSetBackgroundAttribution:
            return "Receive new_tab_footer::mojom::NewTabFooterDocument::SetBackgroundAttribution";
    }
  } else {
    switch (static_cast<messages::NewTabFooterDocument>(message.name())) {
      case messages::NewTabFooterDocument::kSetNtpExtensionName:
            return "Receive reply new_tab_footer::mojom::NewTabFooterDocument::SetNtpExtensionName";
      case messages::NewTabFooterDocument::kSetManagementNotice:
            return "Receive reply new_tab_footer::mojom::NewTabFooterDocument::SetManagementNotice";
      case messages::NewTabFooterDocument::kAttachedTabStateUpdated:
            return "Receive reply new_tab_footer::mojom::NewTabFooterDocument::AttachedTabStateUpdated";
      case messages::NewTabFooterDocument::kSetBackgroundAttribution:
            return "Receive reply new_tab_footer::mojom::NewTabFooterDocument::SetBackgroundAttribution";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NewTabFooterDocument::SetNtpExtensionName_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xae2da4d7;  // IPCStableHash for new_tab_footer::mojom::NewTabFooterDocument::SetNtpExtensionName
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NewTabFooterDocument::SetManagementNotice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb7061b64;  // IPCStableHash for new_tab_footer::mojom::NewTabFooterDocument::SetManagementNotice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NewTabFooterDocument::AttachedTabStateUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe7b5a092;  // IPCStableHash for new_tab_footer::mojom::NewTabFooterDocument::AttachedTabStateUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NewTabFooterDocument::SetBackgroundAttribution_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2e2a45a7;  // IPCStableHash for new_tab_footer::mojom::NewTabFooterDocument::SetBackgroundAttribution
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NewTabFooterDocumentProxy::NewTabFooterDocumentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NewTabFooterDocumentProxy::SetNtpExtensionName(
    const std::string& in_name) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_footer::mojom::NewTabFooterDocument::SetNtpExtensionName", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NewTabFooterDocument::kSetNtpExtensionName), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_footer::mojom::internal::NewTabFooterDocument_SetNtpExtensionName_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in NewTabFooterDocument.SetNtpExtensionName request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NewTabFooterDocument::Name_);
  message.set_method_name("SetNtpExtensionName");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NewTabFooterDocumentProxy::SetManagementNotice(
    ManagementNoticePtr in_notice) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_footer::mojom::NewTabFooterDocument::SetManagementNotice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notice"), in_notice,
                        "<value of type ManagementNoticePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NewTabFooterDocument::kSetManagementNotice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_footer::mojom::internal::NewTabFooterDocument_SetManagementNotice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->notice)::BaseType> notice_fragment(
          params.message());
  
  mojo::internal::Serialize<::new_tab_footer::mojom::ManagementNoticeDataView>(
    in_notice,
    notice_fragment);

  params->notice.Set(
      notice_fragment.is_null() ? nullptr : notice_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NewTabFooterDocument::Name_);
  message.set_method_name("SetManagementNotice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NewTabFooterDocumentProxy::AttachedTabStateUpdated(
    NewTabPageType in_ntp_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_footer::mojom::NewTabFooterDocument::AttachedTabStateUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ntp_type"), in_ntp_type,
                        "<value of type NewTabPageType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NewTabFooterDocument::kAttachedTabStateUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_footer::mojom::internal::NewTabFooterDocument_AttachedTabStateUpdated_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::new_tab_footer::mojom::NewTabPageType>(
    in_ntp_type,
    &params->ntp_type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NewTabFooterDocument::Name_);
  message.set_method_name("AttachedTabStateUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NewTabFooterDocumentProxy::SetBackgroundAttribution(
    BackgroundAttributionPtr in_background_image_attribution) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_footer::mojom::NewTabFooterDocument::SetBackgroundAttribution", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("background_image_attribution"), in_background_image_attribution,
                        "<value of type BackgroundAttributionPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NewTabFooterDocument::kSetBackgroundAttribution), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_footer::mojom::internal::NewTabFooterDocument_SetBackgroundAttribution_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->background_image_attribution)::BaseType> background_image_attribution_fragment(
          params.message());
  
  mojo::internal::Serialize<::new_tab_footer::mojom::BackgroundAttributionDataView>(
    in_background_image_attribution,
    background_image_attribution_fragment);

  params->background_image_attribution.Set(
      background_image_attribution_fragment.is_null() ? nullptr : background_image_attribution_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NewTabFooterDocument::Name_);
  message.set_method_name("SetBackgroundAttribution");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NewTabFooterDocumentStubDispatch::Accept(
    NewTabFooterDocument* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NewTabFooterDocument>(message->header()->name)) {
    case messages::NewTabFooterDocument::kSetNtpExtensionName: {
      DCHECK(message->is_serialized());
      internal::NewTabFooterDocument_SetNtpExtensionName_Params_Data* params =
          reinterpret_cast<internal::NewTabFooterDocument_SetNtpExtensionName_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NewTabFooterDocument.0
      bool success = true;
      std::string p_name{};
      NewTabFooterDocument_SetNtpExtensionName_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NewTabFooterDocument::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNtpExtensionName(        
        std::move(p_name));
      return true;
    }
    case messages::NewTabFooterDocument::kSetManagementNotice: {
      DCHECK(message->is_serialized());
      internal::NewTabFooterDocument_SetManagementNotice_Params_Data* params =
          reinterpret_cast<internal::NewTabFooterDocument_SetManagementNotice_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NewTabFooterDocument.1
      bool success = true;
      ManagementNoticePtr p_notice{};
      NewTabFooterDocument_SetManagementNotice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNotice(&p_notice))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NewTabFooterDocument::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetManagementNotice(        
        std::move(p_notice));
      return true;
    }
    case messages::NewTabFooterDocument::kAttachedTabStateUpdated: {
      DCHECK(message->is_serialized());
      internal::NewTabFooterDocument_AttachedTabStateUpdated_Params_Data* params =
          reinterpret_cast<internal::NewTabFooterDocument_AttachedTabStateUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NewTabFooterDocument.2
      bool success = true;
      NewTabPageType p_ntp_type{};
      NewTabFooterDocument_AttachedTabStateUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNtpType(&p_ntp_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NewTabFooterDocument::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AttachedTabStateUpdated(        
        std::move(p_ntp_type));
      return true;
    }
    case messages::NewTabFooterDocument::kSetBackgroundAttribution: {
      DCHECK(message->is_serialized());
      internal::NewTabFooterDocument_SetBackgroundAttribution_Params_Data* params =
          reinterpret_cast<internal::NewTabFooterDocument_SetBackgroundAttribution_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NewTabFooterDocument.3
      bool success = true;
      BackgroundAttributionPtr p_background_image_attribution{};
      NewTabFooterDocument_SetBackgroundAttribution_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBackgroundImageAttribution(&p_background_image_attribution))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NewTabFooterDocument::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBackgroundAttribution(        
        std::move(p_background_image_attribution));
      return true;
    }
  }
  return false;
}

// static
bool NewTabFooterDocumentStubDispatch::AcceptWithResponder(
    NewTabFooterDocument* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NewTabFooterDocument>(message->header()->name)) {
    case messages::NewTabFooterDocument::kSetNtpExtensionName: {
      break;
    }
    case messages::NewTabFooterDocument::kSetManagementNotice: {
      break;
    }
    case messages::NewTabFooterDocument::kAttachedTabStateUpdated: {
      break;
    }
    case messages::NewTabFooterDocument::kSetBackgroundAttribution: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNewTabFooterDocumentValidationInfo[] = {
    { &internal::NewTabFooterDocument_SetNtpExtensionName_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NewTabFooterDocument_SetManagementNotice_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NewTabFooterDocument_AttachedTabStateUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NewTabFooterDocument_SetBackgroundAttribution_Params_Data::Validate,
     nullptr /* no response */},
};

bool NewTabFooterDocumentRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::new_tab_footer::mojom::NewTabFooterDocument::Name_,
    kNewTabFooterDocumentValidationInfo);
}



}  // new_tab_footer::mojom


namespace mojo {


// static
bool StructTraits<::new_tab_footer::mojom::ManagementNotice::DataView, ::new_tab_footer::mojom::ManagementNoticePtr>::Read(
    ::new_tab_footer::mojom::ManagementNotice::DataView input,
    ::new_tab_footer::mojom::ManagementNoticePtr* output) {
  bool success = true;
  ::new_tab_footer::mojom::ManagementNoticePtr result(::new_tab_footer::mojom::ManagementNotice::New());
  
      if (success && !input.ReadText(&result->text))
        success = false;
      if (success && !input.ReadCustomBitmapDataUrl(&result->custom_bitmap_data_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::new_tab_footer::mojom::BackgroundAttribution::DataView, ::new_tab_footer::mojom::BackgroundAttributionPtr>::Read(
    ::new_tab_footer::mojom::BackgroundAttribution::DataView input,
    ::new_tab_footer::mojom::BackgroundAttributionPtr* output) {
  bool success = true;
  ::new_tab_footer::mojom::BackgroundAttributionPtr result(::new_tab_footer::mojom::BackgroundAttribution::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace new_tab_footer::mojom {


void NewTabFooterHandlerFactoryInterceptorForTesting::CreateNewTabFooterHandler(::mojo::PendingRemote<NewTabFooterDocument> document, ::mojo::PendingReceiver<NewTabFooterHandler> handler) {
  GetForwardingInterface()->CreateNewTabFooterHandler(
    std::move(document)
    , 
    std::move(handler)
    );
}
NewTabFooterHandlerFactoryAsyncWaiter::NewTabFooterHandlerFactoryAsyncWaiter(
    NewTabFooterHandlerFactory* proxy) : proxy_(proxy) {}

NewTabFooterHandlerFactoryAsyncWaiter::~NewTabFooterHandlerFactoryAsyncWaiter() = default;





void NewTabFooterHandlerInterceptorForTesting::UpdateNtpExtensionName() {
  GetForwardingInterface()->UpdateNtpExtensionName();
}
void NewTabFooterHandlerInterceptorForTesting::UpdateManagementNotice() {
  GetForwardingInterface()->UpdateManagementNotice();
}
void NewTabFooterHandlerInterceptorForTesting::UpdateAttachedTabState() {
  GetForwardingInterface()->UpdateAttachedTabState();
}
void NewTabFooterHandlerInterceptorForTesting::UpdateBackgroundAttribution() {
  GetForwardingInterface()->UpdateBackgroundAttribution();
}
void NewTabFooterHandlerInterceptorForTesting::OpenExtensionOptionsPageWithFallback() {
  GetForwardingInterface()->OpenExtensionOptionsPageWithFallback();
}
void NewTabFooterHandlerInterceptorForTesting::OpenManagementPage() {
  GetForwardingInterface()->OpenManagementPage();
}
void NewTabFooterHandlerInterceptorForTesting::OpenUrlInCurrentTab(const ::GURL& url) {
  GetForwardingInterface()->OpenUrlInCurrentTab(
    std::move(url)
    );
}
void NewTabFooterHandlerInterceptorForTesting::ShowContextMenu(const ::gfx::Point& point) {
  GetForwardingInterface()->ShowContextMenu(
    std::move(point)
    );
}
NewTabFooterHandlerAsyncWaiter::NewTabFooterHandlerAsyncWaiter(
    NewTabFooterHandler* proxy) : proxy_(proxy) {}

NewTabFooterHandlerAsyncWaiter::~NewTabFooterHandlerAsyncWaiter() = default;





void NewTabFooterDocumentInterceptorForTesting::SetNtpExtensionName(const std::string& name) {
  GetForwardingInterface()->SetNtpExtensionName(
    std::move(name)
    );
}
void NewTabFooterDocumentInterceptorForTesting::SetManagementNotice(ManagementNoticePtr notice) {
  GetForwardingInterface()->SetManagementNotice(
    std::move(notice)
    );
}
void NewTabFooterDocumentInterceptorForTesting::AttachedTabStateUpdated(NewTabPageType ntp_type) {
  GetForwardingInterface()->AttachedTabStateUpdated(
    std::move(ntp_type)
    );
}
void NewTabFooterDocumentInterceptorForTesting::SetBackgroundAttribution(BackgroundAttributionPtr background_image_attribution) {
  GetForwardingInterface()->SetBackgroundAttribution(
    std::move(background_image_attribution)
    );
}
NewTabFooterDocumentAsyncWaiter::NewTabFooterDocumentAsyncWaiter(
    NewTabFooterDocument* proxy) : proxy_(proxy) {}

NewTabFooterDocumentAsyncWaiter::~NewTabFooterDocumentAsyncWaiter() = default;







}  // new_tab_footer::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif