// chrome/browser/ui/webui/downloads/downloads.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_DOWNLOADS_DOWNLOADS_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_DOWNLOADS_DOWNLOADS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/downloads/downloads.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/downloads/downloads.mojom-data-view.h"




namespace std {

template <>
struct hash<::downloads::mojom::DangerType>
    : public mojo::internal::EnumHashImpl<::downloads::mojom::DangerType> {};

template <>
struct hash<::downloads::mojom::TailoredWarningType>
    : public mojo::internal::EnumHashImpl<::downloads::mojom::TailoredWarningType> {};

template <>
struct hash<::downloads::mojom::State>
    : public mojo::internal::EnumHashImpl<::downloads::mojom::State> {};

template <>
struct hash<::downloads::mojom::SafeBrowsingState>
    : public mojo::internal::EnumHashImpl<::downloads::mojom::SafeBrowsingState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::downloads::mojom::DangerType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::downloads::mojom::DangerType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::downloads::mojom::DangerType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::downloads::mojom::TailoredWarningType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::downloads::mojom::TailoredWarningType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::downloads::mojom::TailoredWarningType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::downloads::mojom::State, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::downloads::mojom::State, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::downloads::mojom::State>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::downloads::mojom::SafeBrowsingState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::downloads::mojom::SafeBrowsingState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::downloads::mojom::SafeBrowsingState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::downloads::mojom::DataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::downloads::mojom::DataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::downloads::mojom::internal::Data_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->file_externally_removed = Traits::file_externally_removed(input);

    fragment->is_dangerous = Traits::is_dangerous(input);

    fragment->is_insecure = Traits::is_insecure(input);

    fragment->is_reviewable = Traits::is_reviewable(input);

    fragment->otr = Traits::otr(input);

    fragment->resume = Traits::resume(input);

    fragment->retry = Traits::retry(input);

    fragment->percent = Traits::percent(input);

    fragment->started = Traits::started(input);

    fragment->total = Traits::total(input);

    decltype(Traits::by_ext_id(input)) in_by_ext_id = Traits::by_ext_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->by_ext_id)::BaseType> by_ext_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_by_ext_id,
      by_ext_id_fragment);

    fragment->by_ext_id.Set(
        by_ext_id_fragment.is_null() ? nullptr : by_ext_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->by_ext_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null by_ext_id in Data struct");

    decltype(Traits::by_ext_name(input)) in_by_ext_name = Traits::by_ext_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->by_ext_name)::BaseType> by_ext_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_by_ext_name,
      by_ext_name_fragment);

    fragment->by_ext_name.Set(
        by_ext_name_fragment.is_null() ? nullptr : by_ext_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->by_ext_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null by_ext_name in Data struct");

    
    mojo::internal::Serialize<::downloads::mojom::DangerType>(
      Traits::danger_type(input),
      &fragment->danger_type);

    
    mojo::internal::Serialize<::downloads::mojom::TailoredWarningType>(
      Traits::tailored_warning_type(input),
      &fragment->tailored_warning_type);

    decltype(Traits::date_string(input)) in_date_string = Traits::date_string(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->date_string)::BaseType> date_string_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_date_string,
      date_string_fragment);

    fragment->date_string.Set(
        date_string_fragment.is_null() ? nullptr : date_string_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->date_string.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null date_string in Data struct");

    decltype(Traits::file_name(input)) in_file_name = Traits::file_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_name)::BaseType> file_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_file_name,
      file_name_fragment);

    fragment->file_name.Set(
        file_name_fragment.is_null() ? nullptr : file_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->file_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file_name in Data struct");

    decltype(Traits::file_path(input)) in_file_path = Traits::file_path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_path)::BaseType> file_path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_file_path,
      file_path_fragment);

    fragment->file_path.Set(
        file_path_fragment.is_null() ? nullptr : file_path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->file_path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file_path in Data struct");

    decltype(Traits::file_url(input)) in_file_url = Traits::file_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_url)::BaseType> file_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_file_url,
      file_url_fragment);

    fragment->file_url.Set(
        file_url_fragment.is_null() ? nullptr : file_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->file_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file_url in Data struct");

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in Data struct");

    decltype(Traits::last_reason_text(input)) in_last_reason_text = Traits::last_reason_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_reason_text)::BaseType> last_reason_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_last_reason_text,
      last_reason_text_fragment);

    fragment->last_reason_text.Set(
        last_reason_text_fragment.is_null() ? nullptr : last_reason_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_reason_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_reason_text in Data struct");

    decltype(Traits::progress_status_text(input)) in_progress_status_text = Traits::progress_status_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->progress_status_text)::BaseType> progress_status_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_progress_status_text,
      progress_status_text_fragment);

    fragment->progress_status_text.Set(
        progress_status_text_fragment.is_null() ? nullptr : progress_status_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->progress_status_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null progress_status_text in Data struct");

    decltype(Traits::show_in_folder_text(input)) in_show_in_folder_text = Traits::show_in_folder_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->show_in_folder_text)::BaseType> show_in_folder_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_show_in_folder_text,
      show_in_folder_text_fragment);

    fragment->show_in_folder_text.Set(
        show_in_folder_text_fragment.is_null() ? nullptr : show_in_folder_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->show_in_folder_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null show_in_folder_text in Data struct");

    decltype(Traits::since_string(input)) in_since_string = Traits::since_string(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->since_string)::BaseType> since_string_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_since_string,
      since_string_fragment);

    fragment->since_string.Set(
        since_string_fragment.is_null() ? nullptr : since_string_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->since_string.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null since_string in Data struct");

    
    mojo::internal::Serialize<::downloads::mojom::State>(
      Traits::state(input),
      &fragment->state);

    decltype(Traits::display_initiator_origin(input)) in_display_initiator_origin = Traits::display_initiator_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_initiator_origin)::BaseType> display_initiator_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_display_initiator_origin,
      display_initiator_origin_fragment);

    fragment->display_initiator_origin.Set(
        display_initiator_origin_fragment.is_null() ? nullptr : display_initiator_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_initiator_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_initiator_origin in Data struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    decltype(Traits::display_url(input)) in_display_url = Traits::display_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_url)::BaseType> display_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_display_url,
      display_url_fragment);

    fragment->display_url.Set(
        display_url_fragment.is_null() ? nullptr : display_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_url in Data struct");

    
    mojo::internal::Serialize<::downloads::mojom::SafeBrowsingState>(
      Traits::safe_browsing_state(input),
      &fragment->safe_browsing_state);

    fragment->has_safe_browsing_verdict = Traits::has_safe_browsing_verdict(input);
  }

  static bool Deserialize(::downloads::mojom::internal::Data_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::downloads::mojom::DataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace downloads::mojom {

inline void DataDataView::GetByExtIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->by_ext_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DataDataView::GetByExtNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->by_ext_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DataDataView::GetDateStringDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->date_string.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DataDataView::GetFileNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->file_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DataDataView::GetFilePathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->file_path.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DataDataView::GetFileUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->file_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DataDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DataDataView::GetLastReasonTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->last_reason_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DataDataView::GetProgressStatusTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->progress_status_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DataDataView::GetShowInFolderTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->show_in_folder_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DataDataView::GetSinceStringDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->since_string.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DataDataView::GetDisplayInitiatorOriginDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->display_initiator_origin.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void DataDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DataDataView::GetDisplayUrlDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->display_url.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}



}  // downloads::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::downloads::mojom::DangerType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::downloads::mojom::DangerType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::downloads::mojom::TailoredWarningType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::downloads::mojom::TailoredWarningType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::downloads::mojom::State> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::downloads::mojom::State value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::downloads::mojom::SafeBrowsingState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::downloads::mojom::SafeBrowsingState value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_DOWNLOADS_DOWNLOADS_MOJOM_SHARED_H_