// chrome/browser/ui/webui/discards/site_data.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_DISCARDS_SITE_DATA_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_DISCARDS_SITE_DATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/discards/site_data.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/discards/site_data.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::discards::mojom::SiteDataFeatureDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::discards::mojom::SiteDataFeatureDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::discards::mojom::internal::SiteDataFeature_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->observation_duration = Traits::observation_duration(input);

    fragment->use_timestamp = Traits::use_timestamp(input);
  }

  static bool Deserialize(::discards::mojom::internal::SiteDataFeature_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::discards::mojom::SiteDataFeatureDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::discards::mojom::SiteDataPerformanceMeasurementDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::discards::mojom::SiteDataPerformanceMeasurementDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::discards::mojom::internal::SiteDataPerformanceMeasurement_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->avg_cpu_usage_us = Traits::avg_cpu_usage_us(input);

    fragment->avg_footprint_kb = Traits::avg_footprint_kb(input);

    fragment->avg_load_duration_us = Traits::avg_load_duration_us(input);
  }

  static bool Deserialize(::discards::mojom::internal::SiteDataPerformanceMeasurement_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::discards::mojom::SiteDataPerformanceMeasurementDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::discards::mojom::SiteDataDatabaseSizeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::discards::mojom::SiteDataDatabaseSizeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::discards::mojom::internal::SiteDataDatabaseSize_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->num_rows = Traits::num_rows(input);

    fragment->on_disk_size_kb = Traits::on_disk_size_kb(input);
  }

  static bool Deserialize(::discards::mojom::internal::SiteDataDatabaseSize_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::discards::mojom::SiteDataDatabaseSizeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::discards::mojom::SiteDataValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::discards::mojom::SiteDataValueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::discards::mojom::internal::SiteDataValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->last_loaded = Traits::last_loaded(input);

    decltype(Traits::updates_favicon_in_background(input)) in_updates_favicon_in_background = Traits::updates_favicon_in_background(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->updates_favicon_in_background)::BaseType> updates_favicon_in_background_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::discards::mojom::SiteDataFeatureDataView>(
      in_updates_favicon_in_background,
      updates_favicon_in_background_fragment);

    fragment->updates_favicon_in_background.Set(
        updates_favicon_in_background_fragment.is_null() ? nullptr : updates_favicon_in_background_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->updates_favicon_in_background.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null updates_favicon_in_background in SiteDataValue struct");

    decltype(Traits::updates_title_in_background(input)) in_updates_title_in_background = Traits::updates_title_in_background(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->updates_title_in_background)::BaseType> updates_title_in_background_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::discards::mojom::SiteDataFeatureDataView>(
      in_updates_title_in_background,
      updates_title_in_background_fragment);

    fragment->updates_title_in_background.Set(
        updates_title_in_background_fragment.is_null() ? nullptr : updates_title_in_background_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->updates_title_in_background.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null updates_title_in_background in SiteDataValue struct");

    decltype(Traits::uses_audio_in_background(input)) in_uses_audio_in_background = Traits::uses_audio_in_background(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->uses_audio_in_background)::BaseType> uses_audio_in_background_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::discards::mojom::SiteDataFeatureDataView>(
      in_uses_audio_in_background,
      uses_audio_in_background_fragment);

    fragment->uses_audio_in_background.Set(
        uses_audio_in_background_fragment.is_null() ? nullptr : uses_audio_in_background_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->uses_audio_in_background.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null uses_audio_in_background in SiteDataValue struct");

    decltype(Traits::load_time_estimates(input)) in_load_time_estimates = Traits::load_time_estimates(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->load_time_estimates)::BaseType> load_time_estimates_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::discards::mojom::SiteDataPerformanceMeasurementDataView>(
      in_load_time_estimates,
      load_time_estimates_fragment);

    fragment->load_time_estimates.Set(
        load_time_estimates_fragment.is_null() ? nullptr : load_time_estimates_fragment.data());
  }

  static bool Deserialize(::discards::mojom::internal::SiteDataValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::discards::mojom::SiteDataValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::discards::mojom::SiteDataEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::discards::mojom::SiteDataEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::discards::mojom::internal::SiteDataEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::origin(input)) in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin)::BaseType> origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_origin,
      origin_fragment);

    fragment->origin.Set(
        origin_fragment.is_null() ? nullptr : origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in SiteDataEntry struct");

    fragment->is_dirty = Traits::is_dirty(input);

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::discards::mojom::SiteDataValueDataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());
  }

  static bool Deserialize(::discards::mojom::internal::SiteDataEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::discards::mojom::SiteDataEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::discards::mojom::SiteDataArrayDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::discards::mojom::SiteDataArrayDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::discards::mojom::internal::SiteDataArray_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::db_rows(input)) in_db_rows = Traits::db_rows(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->db_rows)::BaseType>
        db_rows_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& db_rows_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::discards::mojom::SiteDataEntryDataView>>(
      in_db_rows,
      db_rows_fragment,
      &db_rows_validate_params);

    fragment->db_rows.Set(
        db_rows_fragment.is_null() ? nullptr : db_rows_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->db_rows.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null db_rows in SiteDataArray struct");
  }

  static bool Deserialize(::discards::mojom::internal::SiteDataArray_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::discards::mojom::SiteDataArrayDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace discards::mojom {







inline void SiteDataValueDataView::GetUpdatesFaviconInBackgroundDataView(
    SiteDataFeatureDataView* output) {
  auto pointer = data_->updates_favicon_in_background.Get();
  *output = SiteDataFeatureDataView(pointer, message_);
}
inline void SiteDataValueDataView::GetUpdatesTitleInBackgroundDataView(
    SiteDataFeatureDataView* output) {
  auto pointer = data_->updates_title_in_background.Get();
  *output = SiteDataFeatureDataView(pointer, message_);
}
inline void SiteDataValueDataView::GetUsesAudioInBackgroundDataView(
    SiteDataFeatureDataView* output) {
  auto pointer = data_->uses_audio_in_background.Get();
  *output = SiteDataFeatureDataView(pointer, message_);
}
inline void SiteDataValueDataView::GetLoadTimeEstimatesDataView(
    SiteDataPerformanceMeasurementDataView* output) {
  auto pointer = data_->load_time_estimates.Get();
  *output = SiteDataPerformanceMeasurementDataView(pointer, message_);
}


inline void SiteDataEntryDataView::GetOriginDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->origin.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SiteDataEntryDataView::GetValueDataView(
    SiteDataValueDataView* output) {
  auto pointer = data_->value.Get();
  *output = SiteDataValueDataView(pointer, message_);
}


inline void SiteDataArrayDataView::GetDbRowsDataView(
    mojo::ArrayDataView<SiteDataEntryDataView>* output) {
  auto pointer = data_->db_rows.Get();
  *output = mojo::ArrayDataView<SiteDataEntryDataView>(pointer, message_);
}



}  // discards::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // CHROME_BROWSER_UI_WEBUI_DISCARDS_SITE_DATA_MOJOM_SHARED_H_