// chrome/browser/ui/webui/data_sharing/data_sharing.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/data_sharing/data_sharing.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/data_sharing/data_sharing.mojom-params-data.h"
#include "chrome/browser/ui/webui/data_sharing/data_sharing.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/data_sharing/data_sharing.mojom-import-headers.h"
#include "chrome/browser/ui/webui/data_sharing/data_sharing.mojom-test-utils.h"


namespace data_sharing::mojom {
ReadGroupsParams::ReadGroupsParams()
    : params() {}

ReadGroupsParams::ReadGroupsParams(
    std::vector<ReadGroupParamsPtr> params_in)
    : params(std::move(params_in)) {}

ReadGroupsParams::~ReadGroupsParams() = default;

void ReadGroupsParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "params"), this->params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ReadGroupParamsPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReadGroupsParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ReadGroupParams::ReadGroupParams()
    : group_id(),
      consistency_token() {}

ReadGroupParams::ReadGroupParams(
    const std::string& group_id_in,
    const std::string& consistency_token_in)
    : group_id(std::move(group_id_in)),
      consistency_token(std::move(consistency_token_in)) {}

ReadGroupParams::~ReadGroupParams() = default;
size_t ReadGroupParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->group_id);
  seed = mojo::internal::Hash(seed, this->consistency_token);
  return seed;
}

void ReadGroupParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "consistency_token"), this->consistency_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReadGroupParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ReadGroupsResult::ReadGroupsResult()
    : groups(),
      status_code() {}

ReadGroupsResult::ReadGroupsResult(
    std::vector<::data_sharing::mojom::GroupDataPtr> groups_in,
    int32_t status_code_in)
    : groups(std::move(groups_in)),
      status_code(std::move(status_code_in)) {}

ReadGroupsResult::~ReadGroupsResult() = default;

void ReadGroupsResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "groups"), this->groups,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::data_sharing::mojom::GroupDataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status_code"), this->status_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReadGroupsResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ReadGroupWithTokenParam::ReadGroupWithTokenParam()
    : group_id(),
      access_token() {}

ReadGroupWithTokenParam::ReadGroupWithTokenParam(
    const std::string& group_id_in,
    const std::string& access_token_in)
    : group_id(std::move(group_id_in)),
      access_token(std::move(access_token_in)) {}

ReadGroupWithTokenParam::~ReadGroupWithTokenParam() = default;
size_t ReadGroupWithTokenParam::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->group_id);
  seed = mojo::internal::Hash(seed, this->access_token);
  return seed;
}

void ReadGroupWithTokenParam::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "access_token"), this->access_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReadGroupWithTokenParam::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ReadGroupWithTokenResult::ReadGroupWithTokenResult()
    : group(),
      status_code() {}

ReadGroupWithTokenResult::ReadGroupWithTokenResult(
    ::data_sharing::mojom::GroupDataPtr group_in,
    int32_t status_code_in)
    : group(std::move(group_in)),
      status_code(std::move(status_code_in)) {}

ReadGroupWithTokenResult::~ReadGroupWithTokenResult() = default;

void ReadGroupWithTokenResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group"), this->group,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::data_sharing::mojom::GroupDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status_code"), this->status_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReadGroupWithTokenResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SharedTab::SharedTab()
    : display_url(),
      favicon_url() {}

SharedTab::SharedTab(
    const std::string& display_url_in,
    const ::GURL& favicon_url_in)
    : display_url(std::move(display_url_in)),
      favicon_url(std::move(favicon_url_in)) {}

SharedTab::~SharedTab() = default;

void SharedTab::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_url"), this->display_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "favicon_url"), this->favicon_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedTab::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GroupPreview::GroupPreview()
    : title(),
      shared_tabs(),
      status_code() {}

GroupPreview::GroupPreview(
    const std::string& title_in,
    std::vector<SharedTabPtr> shared_tabs_in,
    ::mojo_base::mojom::AbslStatusCode status_code_in)
    : title(std::move(title_in)),
      shared_tabs(std::move(shared_tabs_in)),
      status_code(std::move(status_code_in)) {}

GroupPreview::~GroupPreview() = default;

void GroupPreview::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shared_tabs"), this->shared_tabs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<SharedTabPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status_code"), this->status_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo_base::mojom::AbslStatusCode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GroupPreview::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive data_sharing::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply data_sharing::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x04eda1f1;  // IPCStableHash for data_sharing::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_sharing::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::data_sharing::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::data_sharing::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::data_sharing::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kShowUI: {
      return &PageHandler::ShowUI_Sym::IPCStableHash;
    }
    case messages::PageHandler::kCloseUI: {
      return &PageHandler::CloseUI_Sym::IPCStableHash;
    }
    case messages::PageHandler::kApiInitComplete: {
      return &PageHandler::ApiInitComplete_Sym::IPCStableHash;
    }
    case messages::PageHandler::kMakeTabGroupShared: {
      return &PageHandler::MakeTabGroupShared_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetShareLink: {
      return &PageHandler::GetShareLink_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetTabGroupPreview: {
      return &PageHandler::GetTabGroupPreview_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOpenTabGroup: {
      return &PageHandler::OpenTabGroup_Sym::IPCStableHash;
    }
    case messages::PageHandler::kAboutToUnShareTabGroup: {
      return &PageHandler::AboutToUnShareTabGroup_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnTabGroupUnShareComplete: {
      return &PageHandler::OnTabGroupUnShareComplete_Sym::IPCStableHash;
    }
    case messages::PageHandler::kOnGroupAction: {
      return &PageHandler::OnGroupAction_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kShowUI:
            return "Receive data_sharing::mojom::PageHandler::ShowUI";
      case messages::PageHandler::kCloseUI:
            return "Receive data_sharing::mojom::PageHandler::CloseUI";
      case messages::PageHandler::kApiInitComplete:
            return "Receive data_sharing::mojom::PageHandler::ApiInitComplete";
      case messages::PageHandler::kMakeTabGroupShared:
            return "Receive data_sharing::mojom::PageHandler::MakeTabGroupShared";
      case messages::PageHandler::kGetShareLink:
            return "Receive data_sharing::mojom::PageHandler::GetShareLink";
      case messages::PageHandler::kGetTabGroupPreview:
            return "Receive data_sharing::mojom::PageHandler::GetTabGroupPreview";
      case messages::PageHandler::kOpenTabGroup:
            return "Receive data_sharing::mojom::PageHandler::OpenTabGroup";
      case messages::PageHandler::kAboutToUnShareTabGroup:
            return "Receive data_sharing::mojom::PageHandler::AboutToUnShareTabGroup";
      case messages::PageHandler::kOnTabGroupUnShareComplete:
            return "Receive data_sharing::mojom::PageHandler::OnTabGroupUnShareComplete";
      case messages::PageHandler::kOnGroupAction:
            return "Receive data_sharing::mojom::PageHandler::OnGroupAction";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kShowUI:
            return "Receive reply data_sharing::mojom::PageHandler::ShowUI";
      case messages::PageHandler::kCloseUI:
            return "Receive reply data_sharing::mojom::PageHandler::CloseUI";
      case messages::PageHandler::kApiInitComplete:
            return "Receive reply data_sharing::mojom::PageHandler::ApiInitComplete";
      case messages::PageHandler::kMakeTabGroupShared:
            return "Receive reply data_sharing::mojom::PageHandler::MakeTabGroupShared";
      case messages::PageHandler::kGetShareLink:
            return "Receive reply data_sharing::mojom::PageHandler::GetShareLink";
      case messages::PageHandler::kGetTabGroupPreview:
            return "Receive reply data_sharing::mojom::PageHandler::GetTabGroupPreview";
      case messages::PageHandler::kOpenTabGroup:
            return "Receive reply data_sharing::mojom::PageHandler::OpenTabGroup";
      case messages::PageHandler::kAboutToUnShareTabGroup:
            return "Receive reply data_sharing::mojom::PageHandler::AboutToUnShareTabGroup";
      case messages::PageHandler::kOnTabGroupUnShareComplete:
            return "Receive reply data_sharing::mojom::PageHandler::OnTabGroupUnShareComplete";
      case messages::PageHandler::kOnGroupAction:
            return "Receive reply data_sharing::mojom::PageHandler::OnGroupAction";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::ShowUI_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb2787983;  // IPCStableHash for data_sharing::mojom::PageHandler::ShowUI
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::CloseUI_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5db97727;  // IPCStableHash for data_sharing::mojom::PageHandler::CloseUI
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ApiInitComplete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa0c32516;  // IPCStableHash for data_sharing::mojom::PageHandler::ApiInitComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::MakeTabGroupShared_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8f97ad52;  // IPCStableHash for data_sharing::mojom::PageHandler::MakeTabGroupShared
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetShareLink_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa17b6926;  // IPCStableHash for data_sharing::mojom::PageHandler::GetShareLink
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetTabGroupPreview_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa23509d8;  // IPCStableHash for data_sharing::mojom::PageHandler::GetTabGroupPreview
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OpenTabGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x93740e02;  // IPCStableHash for data_sharing::mojom::PageHandler::OpenTabGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::AboutToUnShareTabGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3619c48b;  // IPCStableHash for data_sharing::mojom::PageHandler::AboutToUnShareTabGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnTabGroupUnShareComplete_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe02af5da;  // IPCStableHash for data_sharing::mojom::PageHandler::OnTabGroupUnShareComplete
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::OnGroupAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc93af688;  // IPCStableHash for data_sharing::mojom::PageHandler::OnGroupAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_MakeTabGroupShared_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_MakeTabGroupShared_ForwardToCallback(
      PageHandler::MakeTabGroupSharedCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_MakeTabGroupShared_ForwardToCallback(const PageHandler_MakeTabGroupShared_ForwardToCallback&) = delete;
  PageHandler_MakeTabGroupShared_ForwardToCallback& operator=(const PageHandler_MakeTabGroupShared_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::MakeTabGroupSharedCallback callback_;
};

class PageHandler_GetShareLink_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetShareLink_ForwardToCallback(
      PageHandler::GetShareLinkCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetShareLink_ForwardToCallback(const PageHandler_GetShareLink_ForwardToCallback&) = delete;
  PageHandler_GetShareLink_ForwardToCallback& operator=(const PageHandler_GetShareLink_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetShareLinkCallback callback_;
};

class PageHandler_GetTabGroupPreview_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetTabGroupPreview_ForwardToCallback(
      PageHandler::GetTabGroupPreviewCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetTabGroupPreview_ForwardToCallback(const PageHandler_GetTabGroupPreview_ForwardToCallback&) = delete;
  PageHandler_GetTabGroupPreview_ForwardToCallback& operator=(const PageHandler_GetTabGroupPreview_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetTabGroupPreviewCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::ShowUI(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send data_sharing::mojom::PageHandler::ShowUI");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShowUI), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::PageHandler_ShowUI_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShowUI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::CloseUI(
    int32_t in_status_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_sharing::mojom::PageHandler::CloseUI", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status_code"), in_status_code,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kCloseUI), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::PageHandler_CloseUI_Params_Data> params(
          message);
  params.Allocate();

  params->status_code = in_status_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("CloseUI");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ApiInitComplete(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send data_sharing::mojom::PageHandler::ApiInitComplete");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kApiInitComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::PageHandler_ApiInitComplete_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ApiInitComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::MakeTabGroupShared(
    const std::string& in_tab_group_id, const std::string& in_group_id, const std::string& in_access_token, MakeTabGroupSharedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_sharing::mojom::PageHandler::MakeTabGroupShared", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_group_id"), in_tab_group_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("access_token"), in_access_token,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kMakeTabGroupShared), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::PageHandler_MakeTabGroupShared_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tab_group_id)::BaseType> tab_group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_tab_group_id,
    tab_group_id_fragment);

  params->tab_group_id.Set(
      tab_group_id_fragment.is_null() ? nullptr : tab_group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tab_group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tab_group_id in PageHandler.MakeTabGroupShared request");
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in PageHandler.MakeTabGroupShared request");
  mojo::internal::MessageFragment<
      typename decltype(params->access_token)::BaseType> access_token_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_access_token,
    access_token_fragment);

  params->access_token.Set(
      access_token_fragment.is_null() ? nullptr : access_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->access_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null access_token in PageHandler.MakeTabGroupShared request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("MakeTabGroupShared");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_MakeTabGroupShared_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetShareLink(
    const std::string& in_group_id, const std::string& in_access_token, GetShareLinkCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_sharing::mojom::PageHandler::GetShareLink", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("access_token"), in_access_token,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetShareLink), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::PageHandler_GetShareLink_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in PageHandler.GetShareLink request");
  mojo::internal::MessageFragment<
      typename decltype(params->access_token)::BaseType> access_token_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_access_token,
    access_token_fragment);

  params->access_token.Set(
      access_token_fragment.is_null() ? nullptr : access_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->access_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null access_token in PageHandler.GetShareLink request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetShareLink");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetShareLink_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetTabGroupPreview(
    const std::string& in_group_id, const std::string& in_access_token, GetTabGroupPreviewCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_sharing::mojom::PageHandler::GetTabGroupPreview", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("access_token"), in_access_token,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabGroupPreview), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::PageHandler_GetTabGroupPreview_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in PageHandler.GetTabGroupPreview request");
  mojo::internal::MessageFragment<
      typename decltype(params->access_token)::BaseType> access_token_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_access_token,
    access_token_fragment);

  params->access_token.Set(
      access_token_fragment.is_null() ? nullptr : access_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->access_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null access_token in PageHandler.GetTabGroupPreview request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabGroupPreview");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetTabGroupPreview_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::OpenTabGroup(
    const std::string& in_group_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_sharing::mojom::PageHandler::OpenTabGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOpenTabGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::PageHandler_OpenTabGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in PageHandler.OpenTabGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OpenTabGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::AboutToUnShareTabGroup(
    const std::string& in_tab_group_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_sharing::mojom::PageHandler::AboutToUnShareTabGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_group_id"), in_tab_group_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kAboutToUnShareTabGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::PageHandler_AboutToUnShareTabGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tab_group_id)::BaseType> tab_group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_tab_group_id,
    tab_group_id_fragment);

  params->tab_group_id.Set(
      tab_group_id_fragment.is_null() ? nullptr : tab_group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tab_group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tab_group_id in PageHandler.AboutToUnShareTabGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("AboutToUnShareTabGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnTabGroupUnShareComplete(
    const std::string& in_tab_group_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_sharing::mojom::PageHandler::OnTabGroupUnShareComplete", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_group_id"), in_tab_group_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnTabGroupUnShareComplete), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::PageHandler_OnTabGroupUnShareComplete_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tab_group_id)::BaseType> tab_group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_tab_group_id,
    tab_group_id_fragment);

  params->tab_group_id.Set(
      tab_group_id_fragment.is_null() ? nullptr : tab_group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tab_group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tab_group_id in PageHandler.OnTabGroupUnShareComplete request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnTabGroupUnShareComplete");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::OnGroupAction(
    GroupAction in_action, GroupActionProgress in_progress) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_sharing::mojom::PageHandler::OnGroupAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type GroupAction>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("progress"), in_progress,
                        "<value of type GroupActionProgress>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kOnGroupAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::PageHandler_OnGroupAction_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::data_sharing::mojom::GroupAction>(
    in_action,
    &params->action);

  
  mojo::internal::Serialize<::data_sharing::mojom::GroupActionProgress>(
    in_progress,
    &params->progress);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("OnGroupAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageHandler_MakeTabGroupShared_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::MakeTabGroupSharedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_MakeTabGroupShared_ProxyToResponder> proxy(
        new PageHandler_MakeTabGroupShared_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_MakeTabGroupShared_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_MakeTabGroupShared_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_MakeTabGroupShared_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::MakeTabGroupSharedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::GURL>& in_url);
};

bool PageHandler_MakeTabGroupShared_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_MakeTabGroupShared_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_MakeTabGroupShared_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.3
  bool success = true;
  std::optional<::GURL> p_url{};
  PageHandler_MakeTabGroupShared_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_url));
  }
  return true;
}

void PageHandler_MakeTabGroupShared_ProxyToResponder::Run(
    const std::optional<::GURL>& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_sharing::mojom::PageHandler::MakeTabGroupShared", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const std::optional<::GURL>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kMakeTabGroupShared), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::PageHandler_MakeTabGroupShared_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("MakeTabGroupShared");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetShareLink_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetShareLinkCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetShareLink_ProxyToResponder> proxy(
        new PageHandler_GetShareLink_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetShareLink_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetShareLink_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetShareLink_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetShareLinkCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::GURL& in_url);
};

bool PageHandler_GetShareLink_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetShareLink_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetShareLink_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.4
  bool success = true;
  ::GURL p_url{};
  PageHandler_GetShareLink_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_url));
  }
  return true;
}

void PageHandler_GetShareLink_ProxyToResponder::Run(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_sharing::mojom::PageHandler::GetShareLink", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetShareLink), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::PageHandler_GetShareLink_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetShareLink");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetTabGroupPreview_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetTabGroupPreviewCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetTabGroupPreview_ProxyToResponder> proxy(
        new PageHandler_GetTabGroupPreview_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetTabGroupPreview_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetTabGroupPreview_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetTabGroupPreview_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetTabGroupPreviewCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      GroupPreviewPtr in_group_preview);
};

bool PageHandler_GetTabGroupPreview_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetTabGroupPreview_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetTabGroupPreview_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.5
  bool success = true;
  GroupPreviewPtr p_group_preview{};
  PageHandler_GetTabGroupPreview_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadGroupPreview(&p_group_preview))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_group_preview));
  }
  return true;
}

void PageHandler_GetTabGroupPreview_ProxyToResponder::Run(
    GroupPreviewPtr in_group_preview) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_sharing::mojom::PageHandler::GetTabGroupPreview", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_preview"), in_group_preview,
                        "<value of type GroupPreviewPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabGroupPreview), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::PageHandler_GetTabGroupPreview_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group_preview)::BaseType> group_preview_fragment(
          params.message());
  
  mojo::internal::Serialize<::data_sharing::mojom::GroupPreviewDataView>(
    in_group_preview,
    group_preview_fragment);

  params->group_preview.Set(
      group_preview_fragment.is_null() ? nullptr : group_preview_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_preview.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_preview in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabGroupPreview");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kShowUI: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ShowUI_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ShowUI_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      PageHandler_ShowUI_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowUI(        );
      return true;
    }
    case messages::PageHandler::kCloseUI: {
      DCHECK(message->is_serialized());
      internal::PageHandler_CloseUI_Params_Data* params =
          reinterpret_cast<internal::PageHandler_CloseUI_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      int32_t p_status_code{};
      PageHandler_CloseUI_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_status_code = input_data_view.status_code();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseUI(        
        std::move(p_status_code));
      return true;
    }
    case messages::PageHandler::kApiInitComplete: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ApiInitComplete_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ApiInitComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      PageHandler_ApiInitComplete_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApiInitComplete(        );
      return true;
    }
    case messages::PageHandler::kMakeTabGroupShared: {
      break;
    }
    case messages::PageHandler::kGetShareLink: {
      break;
    }
    case messages::PageHandler::kGetTabGroupPreview: {
      break;
    }
    case messages::PageHandler::kOpenTabGroup: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OpenTabGroup_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OpenTabGroup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      std::string p_group_id{};
      PageHandler_OpenTabGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenTabGroup(        
        std::move(p_group_id));
      return true;
    }
    case messages::PageHandler::kAboutToUnShareTabGroup: {
      DCHECK(message->is_serialized());
      internal::PageHandler_AboutToUnShareTabGroup_Params_Data* params =
          reinterpret_cast<internal::PageHandler_AboutToUnShareTabGroup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      std::string p_tab_group_id{};
      PageHandler_AboutToUnShareTabGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTabGroupId(&p_tab_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AboutToUnShareTabGroup(        
        std::move(p_tab_group_id));
      return true;
    }
    case messages::PageHandler::kOnTabGroupUnShareComplete: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnTabGroupUnShareComplete_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnTabGroupUnShareComplete_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.8
      bool success = true;
      std::string p_tab_group_id{};
      PageHandler_OnTabGroupUnShareComplete_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTabGroupId(&p_tab_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTabGroupUnShareComplete(        
        std::move(p_tab_group_id));
      return true;
    }
    case messages::PageHandler::kOnGroupAction: {
      DCHECK(message->is_serialized());
      internal::PageHandler_OnGroupAction_Params_Data* params =
          reinterpret_cast<internal::PageHandler_OnGroupAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.9
      bool success = true;
      GroupAction p_action{};
      GroupActionProgress p_progress{};
      PageHandler_OnGroupAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (success && !input_data_view.ReadProgress(&p_progress))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnGroupAction(        
        std::move(p_action), 
        std::move(p_progress));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kShowUI: {
      break;
    }
    case messages::PageHandler::kCloseUI: {
      break;
    }
    case messages::PageHandler::kApiInitComplete: {
      break;
    }
    case messages::PageHandler::kMakeTabGroupShared: {
      internal::PageHandler_MakeTabGroupShared_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_MakeTabGroupShared_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      std::string p_tab_group_id{};
      std::string p_group_id{};
      std::string p_access_token{};
      PageHandler_MakeTabGroupShared_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTabGroupId(&p_tab_group_id))
        success = false;
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (success && !input_data_view.ReadAccessToken(&p_access_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          PageHandler_MakeTabGroupShared_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MakeTabGroupShared(        
        std::move(p_tab_group_id), 
        std::move(p_group_id), 
        std::move(p_access_token), std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetShareLink: {
      internal::PageHandler_GetShareLink_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetShareLink_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      std::string p_group_id{};
      std::string p_access_token{};
      PageHandler_GetShareLink_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (success && !input_data_view.ReadAccessToken(&p_access_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          PageHandler_GetShareLink_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetShareLink(        
        std::move(p_group_id), 
        std::move(p_access_token), std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetTabGroupPreview: {
      internal::PageHandler_GetTabGroupPreview_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetTabGroupPreview_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      std::string p_group_id{};
      std::string p_access_token{};
      PageHandler_GetTabGroupPreview_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (success && !input_data_view.ReadAccessToken(&p_access_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      auto callback =
          PageHandler_GetTabGroupPreview_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTabGroupPreview(        
        std::move(p_group_id), 
        std::move(p_access_token), std::move(callback));
      return true;
    }
    case messages::PageHandler::kOpenTabGroup: {
      break;
    }
    case messages::PageHandler::kAboutToUnShareTabGroup: {
      break;
    }
    case messages::PageHandler::kOnTabGroupUnShareComplete: {
      break;
    }
    case messages::PageHandler::kOnGroupAction: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_ShowUI_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_CloseUI_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ApiInitComplete_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_MakeTabGroupShared_Params_Data::Validate,
     &internal::PageHandler_MakeTabGroupShared_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetShareLink_Params_Data::Validate,
     &internal::PageHandler_GetShareLink_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetTabGroupPreview_Params_Data::Validate,
     &internal::PageHandler_GetTabGroupPreview_ResponseParams_Data::Validate},
    { &internal::PageHandler_OpenTabGroup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_AboutToUnShareTabGroup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnTabGroupUnShareComplete_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_OnGroupAction_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::data_sharing::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::data_sharing::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kOnAccessTokenFetched: {
      return &Page::OnAccessTokenFetched_Sym::IPCStableHash;
    }
    case messages::Page::kReadGroups: {
      return &Page::ReadGroups_Sym::IPCStableHash;
    }
    case messages::Page::kReadGroupWithToken: {
      return &Page::ReadGroupWithToken_Sym::IPCStableHash;
    }
    case messages::Page::kDeleteGroup: {
      return &Page::DeleteGroup_Sym::IPCStableHash;
    }
    case messages::Page::kLeaveGroup: {
      return &Page::LeaveGroup_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnAccessTokenFetched:
            return "Receive data_sharing::mojom::Page::OnAccessTokenFetched";
      case messages::Page::kReadGroups:
            return "Receive data_sharing::mojom::Page::ReadGroups";
      case messages::Page::kReadGroupWithToken:
            return "Receive data_sharing::mojom::Page::ReadGroupWithToken";
      case messages::Page::kDeleteGroup:
            return "Receive data_sharing::mojom::Page::DeleteGroup";
      case messages::Page::kLeaveGroup:
            return "Receive data_sharing::mojom::Page::LeaveGroup";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnAccessTokenFetched:
            return "Receive reply data_sharing::mojom::Page::OnAccessTokenFetched";
      case messages::Page::kReadGroups:
            return "Receive reply data_sharing::mojom::Page::ReadGroups";
      case messages::Page::kReadGroupWithToken:
            return "Receive reply data_sharing::mojom::Page::ReadGroupWithToken";
      case messages::Page::kDeleteGroup:
            return "Receive reply data_sharing::mojom::Page::DeleteGroup";
      case messages::Page::kLeaveGroup:
            return "Receive reply data_sharing::mojom::Page::LeaveGroup";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::OnAccessTokenFetched_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x465d74c2;  // IPCStableHash for data_sharing::mojom::Page::OnAccessTokenFetched
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::ReadGroups_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd4e87f07;  // IPCStableHash for data_sharing::mojom::Page::ReadGroups
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::ReadGroupWithToken_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x29f6494f;  // IPCStableHash for data_sharing::mojom::Page::ReadGroupWithToken
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::DeleteGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6b4c3f4f;  // IPCStableHash for data_sharing::mojom::Page::DeleteGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::LeaveGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9567cb9f;  // IPCStableHash for data_sharing::mojom::Page::LeaveGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Page_ReadGroups_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Page_ReadGroups_ForwardToCallback(
      Page::ReadGroupsCallback callback
      ) : callback_(std::move(callback)) {
  }

  Page_ReadGroups_ForwardToCallback(const Page_ReadGroups_ForwardToCallback&) = delete;
  Page_ReadGroups_ForwardToCallback& operator=(const Page_ReadGroups_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Page::ReadGroupsCallback callback_;
};

class Page_ReadGroupWithToken_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Page_ReadGroupWithToken_ForwardToCallback(
      Page::ReadGroupWithTokenCallback callback
      ) : callback_(std::move(callback)) {
  }

  Page_ReadGroupWithToken_ForwardToCallback(const Page_ReadGroupWithToken_ForwardToCallback&) = delete;
  Page_ReadGroupWithToken_ForwardToCallback& operator=(const Page_ReadGroupWithToken_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Page::ReadGroupWithTokenCallback callback_;
};

class Page_DeleteGroup_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Page_DeleteGroup_ForwardToCallback(
      Page::DeleteGroupCallback callback
      ) : callback_(std::move(callback)) {
  }

  Page_DeleteGroup_ForwardToCallback(const Page_DeleteGroup_ForwardToCallback&) = delete;
  Page_DeleteGroup_ForwardToCallback& operator=(const Page_DeleteGroup_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Page::DeleteGroupCallback callback_;
};

class Page_LeaveGroup_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Page_LeaveGroup_ForwardToCallback(
      Page::LeaveGroupCallback callback
      ) : callback_(std::move(callback)) {
  }

  Page_LeaveGroup_ForwardToCallback(const Page_LeaveGroup_ForwardToCallback&) = delete;
  Page_LeaveGroup_ForwardToCallback& operator=(const Page_LeaveGroup_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Page::LeaveGroupCallback callback_;
};

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::OnAccessTokenFetched(
    const std::string& in_access_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_sharing::mojom::Page::OnAccessTokenFetched", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("access_token"), in_access_token,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnAccessTokenFetched), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::Page_OnAccessTokenFetched_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->access_token)::BaseType> access_token_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_access_token,
    access_token_fragment);

  params->access_token.Set(
      access_token_fragment.is_null() ? nullptr : access_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->access_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null access_token in Page.OnAccessTokenFetched request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnAccessTokenFetched");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::ReadGroups(
    ReadGroupsParamsPtr in_read_groups_params, ReadGroupsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_sharing::mojom::Page::ReadGroups", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("read_groups_params"), in_read_groups_params,
                        "<value of type ReadGroupsParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kReadGroups), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::Page_ReadGroups_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->read_groups_params)::BaseType> read_groups_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::data_sharing::mojom::ReadGroupsParamsDataView>(
    in_read_groups_params,
    read_groups_params_fragment);

  params->read_groups_params.Set(
      read_groups_params_fragment.is_null() ? nullptr : read_groups_params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->read_groups_params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null read_groups_params in Page.ReadGroups request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("ReadGroups");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Page_ReadGroups_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageProxy::ReadGroupWithToken(
    ReadGroupWithTokenParamPtr in_param, ReadGroupWithTokenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_sharing::mojom::Page::ReadGroupWithToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("param"), in_param,
                        "<value of type ReadGroupWithTokenParamPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kReadGroupWithToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::Page_ReadGroupWithToken_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->param)::BaseType> param_fragment(
          params.message());
  
  mojo::internal::Serialize<::data_sharing::mojom::ReadGroupWithTokenParamDataView>(
    in_param,
    param_fragment);

  params->param.Set(
      param_fragment.is_null() ? nullptr : param_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->param.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null param in Page.ReadGroupWithToken request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("ReadGroupWithToken");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Page_ReadGroupWithToken_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageProxy::DeleteGroup(
    const std::string& in_group_id, DeleteGroupCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_sharing::mojom::Page::DeleteGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kDeleteGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::Page_DeleteGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in Page.DeleteGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("DeleteGroup");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Page_DeleteGroup_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageProxy::LeaveGroup(
    const std::string& in_group_id, LeaveGroupCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_sharing::mojom::Page::LeaveGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kLeaveGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::Page_LeaveGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in Page.LeaveGroup request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("LeaveGroup");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Page_LeaveGroup_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Page_ReadGroups_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Page::ReadGroupsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Page_ReadGroups_ProxyToResponder> proxy(
        new Page_ReadGroups_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Page_ReadGroups_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Page_ReadGroups_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Page_ReadGroups_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Page::ReadGroupsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ReadGroupsResultPtr in_result);
};

bool Page_ReadGroups_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Page_ReadGroups_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Page_ReadGroups_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Page.1
  bool success = true;
  ReadGroupsResultPtr p_result{};
  Page_ReadGroups_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Page::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void Page_ReadGroups_ProxyToResponder::Run(
    ReadGroupsResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_sharing::mojom::Page::ReadGroups", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ReadGroupsResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kReadGroups), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::Page_ReadGroups_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::data_sharing::mojom::ReadGroupsResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("ReadGroups");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Page_ReadGroupWithToken_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Page::ReadGroupWithTokenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Page_ReadGroupWithToken_ProxyToResponder> proxy(
        new Page_ReadGroupWithToken_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Page_ReadGroupWithToken_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Page_ReadGroupWithToken_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Page_ReadGroupWithToken_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Page::ReadGroupWithTokenCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ReadGroupWithTokenResultPtr in_result);
};

bool Page_ReadGroupWithToken_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Page_ReadGroupWithToken_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Page_ReadGroupWithToken_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Page.2
  bool success = true;
  ReadGroupWithTokenResultPtr p_result{};
  Page_ReadGroupWithToken_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Page::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void Page_ReadGroupWithToken_ProxyToResponder::Run(
    ReadGroupWithTokenResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_sharing::mojom::Page::ReadGroupWithToken", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ReadGroupWithTokenResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kReadGroupWithToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::Page_ReadGroupWithToken_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::data_sharing::mojom::ReadGroupWithTokenResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("ReadGroupWithToken");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Page_DeleteGroup_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Page::DeleteGroupCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Page_DeleteGroup_ProxyToResponder> proxy(
        new Page_DeleteGroup_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Page_DeleteGroup_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Page_DeleteGroup_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Page_DeleteGroup_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Page::DeleteGroupCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_status_code);
};

bool Page_DeleteGroup_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Page_DeleteGroup_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Page_DeleteGroup_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Page.3
  bool success = true;
  int32_t p_status_code{};
  Page_DeleteGroup_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_status_code = input_data_view.status_code();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Page::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status_code));
  }
  return true;
}

void Page_DeleteGroup_ProxyToResponder::Run(
    int32_t in_status_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_sharing::mojom::Page::DeleteGroup", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status_code"), in_status_code,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kDeleteGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::Page_DeleteGroup_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->status_code = in_status_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("DeleteGroup");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Page_LeaveGroup_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Page::LeaveGroupCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Page_LeaveGroup_ProxyToResponder> proxy(
        new Page_LeaveGroup_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Page_LeaveGroup_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Page_LeaveGroup_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Page_LeaveGroup_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Page::LeaveGroupCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_status_code);
};

bool Page_LeaveGroup_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Page_LeaveGroup_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Page_LeaveGroup_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Page.4
  bool success = true;
  int32_t p_status_code{};
  Page_LeaveGroup_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_status_code = input_data_view.status_code();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Page::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status_code));
  }
  return true;
}

void Page_LeaveGroup_ProxyToResponder::Run(
    int32_t in_status_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_sharing::mojom::Page::LeaveGroup", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status_code"), in_status_code,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kLeaveGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_sharing::mojom::internal::Page_LeaveGroup_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->status_code = in_status_code;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("LeaveGroup");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnAccessTokenFetched: {
      DCHECK(message->is_serialized());
      internal::Page_OnAccessTokenFetched_Params_Data* params =
          reinterpret_cast<internal::Page_OnAccessTokenFetched_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      std::string p_access_token{};
      Page_OnAccessTokenFetched_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAccessToken(&p_access_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAccessTokenFetched(        
        std::move(p_access_token));
      return true;
    }
    case messages::Page::kReadGroups: {
      break;
    }
    case messages::Page::kReadGroupWithToken: {
      break;
    }
    case messages::Page::kDeleteGroup: {
      break;
    }
    case messages::Page::kLeaveGroup: {
      break;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnAccessTokenFetched: {
      break;
    }
    case messages::Page::kReadGroups: {
      internal::Page_ReadGroups_Params_Data* params =
          reinterpret_cast<
              internal::Page_ReadGroups_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      ReadGroupsParamsPtr p_read_groups_params{};
      Page_ReadGroups_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReadGroupsParams(&p_read_groups_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      auto callback =
          Page_ReadGroups_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadGroups(        
        std::move(p_read_groups_params), std::move(callback));
      return true;
    }
    case messages::Page::kReadGroupWithToken: {
      internal::Page_ReadGroupWithToken_Params_Data* params =
          reinterpret_cast<
              internal::Page_ReadGroupWithToken_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Page.2
      bool success = true;
      ReadGroupWithTokenParamPtr p_param{};
      Page_ReadGroupWithToken_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParam(&p_param))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 2, false);
        return false;
      }
      auto callback =
          Page_ReadGroupWithToken_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReadGroupWithToken(        
        std::move(p_param), std::move(callback));
      return true;
    }
    case messages::Page::kDeleteGroup: {
      internal::Page_DeleteGroup_Params_Data* params =
          reinterpret_cast<
              internal::Page_DeleteGroup_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Page.3
      bool success = true;
      std::string p_group_id{};
      Page_DeleteGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 3, false);
        return false;
      }
      auto callback =
          Page_DeleteGroup_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteGroup(        
        std::move(p_group_id), std::move(callback));
      return true;
    }
    case messages::Page::kLeaveGroup: {
      internal::Page_LeaveGroup_Params_Data* params =
          reinterpret_cast<
              internal::Page_LeaveGroup_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Page.4
      bool success = true;
      std::string p_group_id{};
      Page_LeaveGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 4, false);
        return false;
      }
      auto callback =
          Page_LeaveGroup_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LeaveGroup(        
        std::move(p_group_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_OnAccessTokenFetched_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_ReadGroups_Params_Data::Validate,
     &internal::Page_ReadGroups_ResponseParams_Data::Validate},
    { &internal::Page_ReadGroupWithToken_Params_Data::Validate,
     &internal::Page_ReadGroupWithToken_ResponseParams_Data::Validate},
    { &internal::Page_DeleteGroup_Params_Data::Validate,
     &internal::Page_DeleteGroup_ResponseParams_Data::Validate},
    { &internal::Page_LeaveGroup_Params_Data::Validate,
     &internal::Page_LeaveGroup_ResponseParams_Data::Validate},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::data_sharing::mojom::Page::Name_,
    kPageValidationInfo);
}

bool PageResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::data_sharing::mojom::Page::Name_,
    kPageValidationInfo);
}


}  // data_sharing::mojom


namespace mojo {


// static
bool StructTraits<::data_sharing::mojom::ReadGroupsParams::DataView, ::data_sharing::mojom::ReadGroupsParamsPtr>::Read(
    ::data_sharing::mojom::ReadGroupsParams::DataView input,
    ::data_sharing::mojom::ReadGroupsParamsPtr* output) {
  bool success = true;
  ::data_sharing::mojom::ReadGroupsParamsPtr result(::data_sharing::mojom::ReadGroupsParams::New());
  
      if (success && !input.ReadParams(&result->params))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::data_sharing::mojom::ReadGroupParams::DataView, ::data_sharing::mojom::ReadGroupParamsPtr>::Read(
    ::data_sharing::mojom::ReadGroupParams::DataView input,
    ::data_sharing::mojom::ReadGroupParamsPtr* output) {
  bool success = true;
  ::data_sharing::mojom::ReadGroupParamsPtr result(::data_sharing::mojom::ReadGroupParams::New());
  
      if (success && !input.ReadGroupId(&result->group_id))
        success = false;
      if (success && !input.ReadConsistencyToken(&result->consistency_token))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::data_sharing::mojom::ReadGroupsResult::DataView, ::data_sharing::mojom::ReadGroupsResultPtr>::Read(
    ::data_sharing::mojom::ReadGroupsResult::DataView input,
    ::data_sharing::mojom::ReadGroupsResultPtr* output) {
  bool success = true;
  ::data_sharing::mojom::ReadGroupsResultPtr result(::data_sharing::mojom::ReadGroupsResult::New());
  
      if (success && !input.ReadGroups(&result->groups))
        success = false;
      if (success)
        result->status_code = input.status_code();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::data_sharing::mojom::ReadGroupWithTokenParam::DataView, ::data_sharing::mojom::ReadGroupWithTokenParamPtr>::Read(
    ::data_sharing::mojom::ReadGroupWithTokenParam::DataView input,
    ::data_sharing::mojom::ReadGroupWithTokenParamPtr* output) {
  bool success = true;
  ::data_sharing::mojom::ReadGroupWithTokenParamPtr result(::data_sharing::mojom::ReadGroupWithTokenParam::New());
  
      if (success && !input.ReadGroupId(&result->group_id))
        success = false;
      if (success && !input.ReadAccessToken(&result->access_token))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::data_sharing::mojom::ReadGroupWithTokenResult::DataView, ::data_sharing::mojom::ReadGroupWithTokenResultPtr>::Read(
    ::data_sharing::mojom::ReadGroupWithTokenResult::DataView input,
    ::data_sharing::mojom::ReadGroupWithTokenResultPtr* output) {
  bool success = true;
  ::data_sharing::mojom::ReadGroupWithTokenResultPtr result(::data_sharing::mojom::ReadGroupWithTokenResult::New());
  
      if (success && !input.ReadGroup(&result->group))
        success = false;
      if (success)
        result->status_code = input.status_code();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::data_sharing::mojom::SharedTab::DataView, ::data_sharing::mojom::SharedTabPtr>::Read(
    ::data_sharing::mojom::SharedTab::DataView input,
    ::data_sharing::mojom::SharedTabPtr* output) {
  bool success = true;
  ::data_sharing::mojom::SharedTabPtr result(::data_sharing::mojom::SharedTab::New());
  
      if (success && !input.ReadDisplayUrl(&result->display_url))
        success = false;
      if (success && !input.ReadFaviconUrl(&result->favicon_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::data_sharing::mojom::GroupPreview::DataView, ::data_sharing::mojom::GroupPreviewPtr>::Read(
    ::data_sharing::mojom::GroupPreview::DataView input,
    ::data_sharing::mojom::GroupPreviewPtr* output) {
  bool success = true;
  ::data_sharing::mojom::GroupPreviewPtr result(::data_sharing::mojom::GroupPreview::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadSharedTabs(&result->shared_tabs))
        success = false;
      if (success && !input.ReadStatusCode(&result->status_code))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace data_sharing::mojom {


void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::ShowUI() {
  GetForwardingInterface()->ShowUI();
}
void PageHandlerInterceptorForTesting::CloseUI(int32_t status_code) {
  GetForwardingInterface()->CloseUI(
    std::move(status_code)
    );
}
void PageHandlerInterceptorForTesting::ApiInitComplete() {
  GetForwardingInterface()->ApiInitComplete();
}
void PageHandlerInterceptorForTesting::MakeTabGroupShared(const std::string& tab_group_id, const std::string& group_id, const std::string& access_token, MakeTabGroupSharedCallback callback) {
  GetForwardingInterface()->MakeTabGroupShared(
    std::move(tab_group_id)
    , 
    std::move(group_id)
    , 
    std::move(access_token)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::GetShareLink(const std::string& group_id, const std::string& access_token, GetShareLinkCallback callback) {
  GetForwardingInterface()->GetShareLink(
    std::move(group_id)
    , 
    std::move(access_token)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::GetTabGroupPreview(const std::string& group_id, const std::string& access_token, GetTabGroupPreviewCallback callback) {
  GetForwardingInterface()->GetTabGroupPreview(
    std::move(group_id)
    , 
    std::move(access_token)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::OpenTabGroup(const std::string& group_id) {
  GetForwardingInterface()->OpenTabGroup(
    std::move(group_id)
    );
}
void PageHandlerInterceptorForTesting::AboutToUnShareTabGroup(const std::string& tab_group_id) {
  GetForwardingInterface()->AboutToUnShareTabGroup(
    std::move(tab_group_id)
    );
}
void PageHandlerInterceptorForTesting::OnTabGroupUnShareComplete(const std::string& tab_group_id) {
  GetForwardingInterface()->OnTabGroupUnShareComplete(
    std::move(tab_group_id)
    );
}
void PageHandlerInterceptorForTesting::OnGroupAction(GroupAction action, GroupActionProgress progress) {
  GetForwardingInterface()->OnGroupAction(
    std::move(action)
    , 
    std::move(progress)
    );
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::MakeTabGroupShared(
    const std::string& tab_group_id, const std::string& group_id, const std::string& access_token, std::optional<::GURL>* out_url) {
  base::RunLoop loop;
  proxy_->MakeTabGroupShared(
      std::move(tab_group_id),
      std::move(group_id),
      std::move(access_token),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::GURL>* out_url
,
             const std::optional<::GURL>& url) {*out_url = std::move(url);
            loop->Quit();
          },
          &loop,
          out_url));
  loop.Run();
}

std::optional<::GURL> PageHandlerAsyncWaiter::MakeTabGroupShared(
    const std::string& tab_group_id, const std::string& group_id, const std::string& access_token) {
  std::optional<::GURL> async_wait_result;
  MakeTabGroupShared(std::move(tab_group_id),std::move(group_id),std::move(access_token),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetShareLink(
    const std::string& group_id, const std::string& access_token, ::GURL* out_url) {
  base::RunLoop loop;
  proxy_->GetShareLink(
      std::move(group_id),
      std::move(access_token),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::GURL* out_url
,
             const ::GURL& url) {*out_url = std::move(url);
            loop->Quit();
          },
          &loop,
          out_url));
  loop.Run();
}

::GURL PageHandlerAsyncWaiter::GetShareLink(
    const std::string& group_id, const std::string& access_token) {
  ::GURL async_wait_result;
  GetShareLink(std::move(group_id),std::move(access_token),&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetTabGroupPreview(
    const std::string& group_id, const std::string& access_token, GroupPreviewPtr* out_group_preview) {
  base::RunLoop loop;
  proxy_->GetTabGroupPreview(
      std::move(group_id),
      std::move(access_token),
      base::BindOnce(
          [](base::RunLoop* loop,
             GroupPreviewPtr* out_group_preview
,
             GroupPreviewPtr group_preview) {*out_group_preview = std::move(group_preview);
            loop->Quit();
          },
          &loop,
          out_group_preview));
  loop.Run();
}

GroupPreviewPtr PageHandlerAsyncWaiter::GetTabGroupPreview(
    const std::string& group_id, const std::string& access_token) {
  GroupPreviewPtr async_wait_result;
  GetTabGroupPreview(std::move(group_id),std::move(access_token),&async_wait_result);
  return async_wait_result;
}




void PageInterceptorForTesting::OnAccessTokenFetched(const std::string& access_token) {
  GetForwardingInterface()->OnAccessTokenFetched(
    std::move(access_token)
    );
}
void PageInterceptorForTesting::ReadGroups(ReadGroupsParamsPtr read_groups_params, ReadGroupsCallback callback) {
  GetForwardingInterface()->ReadGroups(
    std::move(read_groups_params)
    , std::move(callback));
}
void PageInterceptorForTesting::ReadGroupWithToken(ReadGroupWithTokenParamPtr param, ReadGroupWithTokenCallback callback) {
  GetForwardingInterface()->ReadGroupWithToken(
    std::move(param)
    , std::move(callback));
}
void PageInterceptorForTesting::DeleteGroup(const std::string& group_id, DeleteGroupCallback callback) {
  GetForwardingInterface()->DeleteGroup(
    std::move(group_id)
    , std::move(callback));
}
void PageInterceptorForTesting::LeaveGroup(const std::string& group_id, LeaveGroupCallback callback) {
  GetForwardingInterface()->LeaveGroup(
    std::move(group_id)
    , std::move(callback));
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;


void PageAsyncWaiter::ReadGroups(
    ReadGroupsParamsPtr read_groups_params, ReadGroupsResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->ReadGroups(
      std::move(read_groups_params),
      base::BindOnce(
          [](base::RunLoop* loop,
             ReadGroupsResultPtr* out_result
,
             ReadGroupsResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

ReadGroupsResultPtr PageAsyncWaiter::ReadGroups(
    ReadGroupsParamsPtr read_groups_params) {
  ReadGroupsResultPtr async_wait_result;
  ReadGroups(std::move(read_groups_params),&async_wait_result);
  return async_wait_result;
}

void PageAsyncWaiter::ReadGroupWithToken(
    ReadGroupWithTokenParamPtr param, ReadGroupWithTokenResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->ReadGroupWithToken(
      std::move(param),
      base::BindOnce(
          [](base::RunLoop* loop,
             ReadGroupWithTokenResultPtr* out_result
,
             ReadGroupWithTokenResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

ReadGroupWithTokenResultPtr PageAsyncWaiter::ReadGroupWithToken(
    ReadGroupWithTokenParamPtr param) {
  ReadGroupWithTokenResultPtr async_wait_result;
  ReadGroupWithToken(std::move(param),&async_wait_result);
  return async_wait_result;
}

void PageAsyncWaiter::DeleteGroup(
    const std::string& group_id, int32_t* out_status_code) {
  base::RunLoop loop;
  proxy_->DeleteGroup(
      std::move(group_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_status_code
,
             int32_t status_code) {*out_status_code = std::move(status_code);
            loop->Quit();
          },
          &loop,
          out_status_code));
  loop.Run();
}

int32_t PageAsyncWaiter::DeleteGroup(
    const std::string& group_id) {
  int32_t async_wait_result;
  DeleteGroup(std::move(group_id),&async_wait_result);
  return async_wait_result;
}

void PageAsyncWaiter::LeaveGroup(
    const std::string& group_id, int32_t* out_status_code) {
  base::RunLoop loop;
  proxy_->LeaveGroup(
      std::move(group_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_status_code
,
             int32_t status_code) {*out_status_code = std::move(status_code);
            loop->Quit();
          },
          &loop,
          out_status_code));
  loop.Run();
}

int32_t PageAsyncWaiter::LeaveGroup(
    const std::string& group_id) {
  int32_t async_wait_result;
  LeaveGroup(std::move(group_id),&async_wait_result);
  return async_wait_result;
}






}  // data_sharing::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif