// chrome/browser/ui/webui/customize_buttons/customize_buttons.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_CUSTOMIZE_BUTTONS_CUSTOMIZE_BUTTONS_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_CUSTOMIZE_BUTTONS_CUSTOMIZE_BUTTONS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/customize_buttons/customize_buttons.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/customize_buttons/customize_buttons.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/customize_buttons/customize_buttons.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace customize_buttons::mojom {

class CustomizeButtonsHandlerFactoryProxy;

template <typename ImplRefTraits>
class CustomizeButtonsHandlerFactoryStub;

class CustomizeButtonsHandlerFactoryRequestValidator;


class CustomizeButtonsHandlerFactory
    : public CustomizeButtonsHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "customize_buttons.mojom.CustomizeButtonsHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CustomizeButtonsHandlerFactoryInterfaceBase;
  using Proxy_ = CustomizeButtonsHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = CustomizeButtonsHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = CustomizeButtonsHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateCustomizeButtonsHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateCustomizeButtonsHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CustomizeButtonsHandlerFactory() = default;

  virtual void CreateCustomizeButtonsHandler(::mojo::PendingRemote<CustomizeButtonsDocument> page, ::mojo::PendingReceiver<CustomizeButtonsHandler> handler) = 0;
};

class CustomizeButtonsHandlerProxy;

template <typename ImplRefTraits>
class CustomizeButtonsHandlerStub;

class CustomizeButtonsHandlerRequestValidator;


class CustomizeButtonsHandler
    : public CustomizeButtonsHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "customize_buttons.mojom.CustomizeButtonsHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CustomizeButtonsHandlerInterfaceBase;
  using Proxy_ = CustomizeButtonsHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = CustomizeButtonsHandlerStub<ImplRefTraits>;

  using RequestValidator_ = CustomizeButtonsHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kIncrementCustomizeChromeButtonOpenCountMinVersion = 0,
    kIncrementWallpaperSearchButtonShownCountMinVersion = 0,
    kSetCustomizeChromeSidePanelVisibleMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct IncrementCustomizeChromeButtonOpenCount_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IncrementWallpaperSearchButtonShownCount_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCustomizeChromeSidePanelVisible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CustomizeButtonsHandler() = default;

  virtual void IncrementCustomizeChromeButtonOpenCount() = 0;

  virtual void IncrementWallpaperSearchButtonShownCount() = 0;

  virtual void SetCustomizeChromeSidePanelVisible(bool visible, CustomizeChromeSection section, SidePanelOpenTrigger trigger) = 0;
};

class CustomizeButtonsDocumentProxy;

template <typename ImplRefTraits>
class CustomizeButtonsDocumentStub;

class CustomizeButtonsDocumentRequestValidator;


class CustomizeButtonsDocument
    : public CustomizeButtonsDocumentInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "customize_buttons.mojom.CustomizeButtonsDocument";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CustomizeButtonsDocumentInterfaceBase;
  using Proxy_ = CustomizeButtonsDocumentProxy;

  template <typename ImplRefTraits>
  using Stub_ = CustomizeButtonsDocumentStub<ImplRefTraits>;

  using RequestValidator_ = CustomizeButtonsDocumentRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetCustomizeChromeSidePanelVisibilityMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetCustomizeChromeSidePanelVisibility_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CustomizeButtonsDocument() = default;

  virtual void SetCustomizeChromeSidePanelVisibility(bool visible) = 0;
};



class  CustomizeButtonsHandlerFactoryProxy
    : public CustomizeButtonsHandlerFactory {
 public:
  using InterfaceType = CustomizeButtonsHandlerFactory;

  explicit CustomizeButtonsHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateCustomizeButtonsHandler(::mojo::PendingRemote<CustomizeButtonsDocument> page, ::mojo::PendingReceiver<CustomizeButtonsHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CustomizeButtonsHandlerProxy
    : public CustomizeButtonsHandler {
 public:
  using InterfaceType = CustomizeButtonsHandler;

  explicit CustomizeButtonsHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void IncrementCustomizeChromeButtonOpenCount() final;
  
  void IncrementWallpaperSearchButtonShownCount() final;
  
  void SetCustomizeChromeSidePanelVisible(bool visible, CustomizeChromeSection section, SidePanelOpenTrigger trigger) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CustomizeButtonsDocumentProxy
    : public CustomizeButtonsDocument {
 public:
  using InterfaceType = CustomizeButtonsDocument;

  explicit CustomizeButtonsDocumentProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetCustomizeChromeSidePanelVisibility(bool visible) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CustomizeButtonsHandlerFactoryStubDispatch {
 public:
  static bool Accept(CustomizeButtonsHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CustomizeButtonsHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CustomizeButtonsHandlerFactory>>
class CustomizeButtonsHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CustomizeButtonsHandlerFactoryStub() = default;
  ~CustomizeButtonsHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeButtonsHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeButtonsHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CustomizeButtonsHandlerStubDispatch {
 public:
  static bool Accept(CustomizeButtonsHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CustomizeButtonsHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CustomizeButtonsHandler>>
class CustomizeButtonsHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CustomizeButtonsHandlerStub() = default;
  ~CustomizeButtonsHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeButtonsHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeButtonsHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CustomizeButtonsDocumentStubDispatch {
 public:
  static bool Accept(CustomizeButtonsDocument* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CustomizeButtonsDocument* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CustomizeButtonsDocument>>
class CustomizeButtonsDocumentStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CustomizeButtonsDocumentStub() = default;
  ~CustomizeButtonsDocumentStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeButtonsDocumentStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomizeButtonsDocumentStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CustomizeButtonsHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CustomizeButtonsHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CustomizeButtonsDocumentRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // customize_buttons::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_CUSTOMIZE_BUTTONS_CUSTOMIZE_BUTTONS_MOJOM_H_