// chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom-params-data.h"
#include "chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom-import-headers.h"
#include "chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom-test-utils.h"


namespace connectors_internals::mojom {
Int32Value::Int32Value()
    : value() {}

Int32Value::Int32Value(
    int32_t value_in)
    : value(std::move(value_in)) {}

Int32Value::~Int32Value() = default;
size_t Int32Value::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->value);
  return seed;
}

void Int32Value::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Int32Value::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
LoadedKeyInfo::LoadedKeyInfo()
    : trust_level(),
      key_type(),
      encoded_spki_hash(),
      key_upload_status(),
      has_ssl_key() {}

LoadedKeyInfo::LoadedKeyInfo(
    KeyTrustLevel trust_level_in,
    KeyType key_type_in,
    const std::string& encoded_spki_hash_in,
    KeyUploadStatusPtr key_upload_status_in,
    bool has_ssl_key_in)
    : trust_level(std::move(trust_level_in)),
      key_type(std::move(key_type_in)),
      encoded_spki_hash(std::move(encoded_spki_hash_in)),
      key_upload_status(std::move(key_upload_status_in)),
      has_ssl_key(std::move(has_ssl_key_in)) {}

LoadedKeyInfo::~LoadedKeyInfo() = default;

void LoadedKeyInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_level"), this->trust_level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type KeyTrustLevel>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_type"), this->key_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type KeyType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoded_spki_hash"), this->encoded_spki_hash,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_upload_status"), this->key_upload_status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type KeyUploadStatusPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_ssl_key"), this->has_ssl_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LoadedKeyInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
KeyInfo::KeyInfo()
    : is_key_manager_initialized(),
      loaded_key_info(),
      permanent_failure() {}

KeyInfo::KeyInfo(
    KeyManagerInitializedValue is_key_manager_initialized_in,
    LoadedKeyInfoPtr loaded_key_info_in,
    KeyManagerPermanentFailure permanent_failure_in)
    : is_key_manager_initialized(std::move(is_key_manager_initialized_in)),
      loaded_key_info(std::move(loaded_key_info_in)),
      permanent_failure(std::move(permanent_failure_in)) {}

KeyInfo::~KeyInfo() = default;

void KeyInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_key_manager_initialized"), this->is_key_manager_initialized,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type KeyManagerInitializedValue>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "loaded_key_info"), this->loaded_key_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LoadedKeyInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permanent_failure"), this->permanent_failure,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type KeyManagerPermanentFailure>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool KeyInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ConsentMetadata::ConsentMetadata()
    : can_collect_signals(),
      consent_received() {}

ConsentMetadata::ConsentMetadata(
    bool can_collect_signals_in,
    bool consent_received_in)
    : can_collect_signals(std::move(can_collect_signals_in)),
      consent_received(std::move(consent_received_in)) {}

ConsentMetadata::~ConsentMetadata() = default;
size_t ConsentMetadata::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->can_collect_signals);
  seed = mojo::internal::Hash(seed, this->consent_received);
  return seed;
}

void ConsentMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_collect_signals"), this->can_collect_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "consent_received"), this->consent_received,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ConsentMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DeviceTrustState::DeviceTrustState()
    : is_enabled(),
      policy_enabled_levels(),
      key_info(),
      signals_json(),
      consent_metadata() {}

DeviceTrustState::DeviceTrustState(
    bool is_enabled_in,
    std::vector<std::string> policy_enabled_levels_in,
    KeyInfoPtr key_info_in,
    const std::string& signals_json_in,
    ConsentMetadataPtr consent_metadata_in)
    : is_enabled(std::move(is_enabled_in)),
      policy_enabled_levels(std::move(policy_enabled_levels_in)),
      key_info(std::move(key_info_in)),
      signals_json(std::move(signals_json_in)),
      consent_metadata(std::move(consent_metadata_in)) {}

DeviceTrustState::~DeviceTrustState() = default;

void DeviceTrustState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_enabled"), this->is_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "policy_enabled_levels"), this->policy_enabled_levels,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_info"), this->key_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type KeyInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signals_json"), this->signals_json,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "consent_metadata"), this->consent_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ConsentMetadataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DeviceTrustState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CertificateMetadata::CertificateMetadata()
    : serial_number(),
      fingerprint(),
      creation_date_string(),
      expiration_date_string(),
      subject_display_name(),
      issuer_display_name() {}

CertificateMetadata::CertificateMetadata(
    const std::string& serial_number_in,
    const std::string& fingerprint_in,
    const std::string& creation_date_string_in,
    const std::string& expiration_date_string_in,
    const std::string& subject_display_name_in,
    const std::string& issuer_display_name_in)
    : serial_number(std::move(serial_number_in)),
      fingerprint(std::move(fingerprint_in)),
      creation_date_string(std::move(creation_date_string_in)),
      expiration_date_string(std::move(expiration_date_string_in)),
      subject_display_name(std::move(subject_display_name_in)),
      issuer_display_name(std::move(issuer_display_name_in)) {}

CertificateMetadata::~CertificateMetadata() = default;
size_t CertificateMetadata::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->serial_number);
  seed = mojo::internal::Hash(seed, this->fingerprint);
  seed = mojo::internal::Hash(seed, this->creation_date_string);
  seed = mojo::internal::Hash(seed, this->expiration_date_string);
  seed = mojo::internal::Hash(seed, this->subject_display_name);
  seed = mojo::internal::Hash(seed, this->issuer_display_name);
  return seed;
}

void CertificateMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "serial_number"), this->serial_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fingerprint"), this->fingerprint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "creation_date_string"), this->creation_date_string,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiration_date_string"), this->expiration_date_string,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subject_display_name"), this->subject_display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issuer_display_name"), this->issuer_display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CertificateMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ClientIdentity::ClientIdentity()
    : identity_name(),
      loaded_key_info(),
      certificate_metadata() {}

ClientIdentity::ClientIdentity(
    const std::string& identity_name_in,
    LoadedKeyInfoPtr loaded_key_info_in,
    CertificateMetadataPtr certificate_metadata_in)
    : identity_name(std::move(identity_name_in)),
      loaded_key_info(std::move(loaded_key_info_in)),
      certificate_metadata(std::move(certificate_metadata_in)) {}

ClientIdentity::~ClientIdentity() = default;

void ClientIdentity::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "identity_name"), this->identity_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "loaded_key_info"), this->loaded_key_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LoadedKeyInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "certificate_metadata"), this->certificate_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CertificateMetadataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ClientIdentity::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ClientCertificateState::ClientCertificateState()
    : policy_enabled_levels(),
      managed_profile_identity(),
      managed_browser_identity() {}

ClientCertificateState::ClientCertificateState(
    std::vector<std::string> policy_enabled_levels_in,
    ClientIdentityPtr managed_profile_identity_in,
    ClientIdentityPtr managed_browser_identity_in)
    : policy_enabled_levels(std::move(policy_enabled_levels_in)),
      managed_profile_identity(std::move(managed_profile_identity_in)),
      managed_browser_identity(std::move(managed_browser_identity_in)) {}

ClientCertificateState::~ClientCertificateState() = default;

void ClientCertificateState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "policy_enabled_levels"), this->policy_enabled_levels,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "managed_profile_identity"), this->managed_profile_identity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ClientIdentityPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "managed_browser_identity"), this->managed_browser_identity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ClientIdentityPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ClientCertificateState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SignalsReportingState::SignalsReportingState()
    : error_info(),
      status_report_enabled(),
      signals_report_enabled(),
      last_upload_attempt_timestamp(),
      last_upload_success_timestamp(),
      last_signals_upload_config(),
      can_collect_all_fields() {}

SignalsReportingState::SignalsReportingState(
    const std::optional<std::string>& error_info_in,
    bool status_report_enabled_in,
    bool signals_report_enabled_in,
    const std::string& last_upload_attempt_timestamp_in,
    const std::string& last_upload_success_timestamp_in,
    const std::string& last_signals_upload_config_in,
    bool can_collect_all_fields_in)
    : error_info(std::move(error_info_in)),
      status_report_enabled(std::move(status_report_enabled_in)),
      signals_report_enabled(std::move(signals_report_enabled_in)),
      last_upload_attempt_timestamp(std::move(last_upload_attempt_timestamp_in)),
      last_upload_success_timestamp(std::move(last_upload_success_timestamp_in)),
      last_signals_upload_config(std::move(last_signals_upload_config_in)),
      can_collect_all_fields(std::move(can_collect_all_fields_in)) {}

SignalsReportingState::~SignalsReportingState() = default;

void SignalsReportingState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_info"), this->error_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status_report_enabled"), this->status_report_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signals_report_enabled"), this->signals_report_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_upload_attempt_timestamp"), this->last_upload_attempt_timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_upload_success_timestamp"), this->last_upload_success_timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_signals_upload_config"), this->last_signals_upload_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_collect_all_fields"), this->can_collect_all_fields,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SignalsReportingState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
KeyUploadStatusPtr
KeyUploadStatus::NewSyncKeyResponseCode(
    Int32ValuePtr value) {
  return KeyUploadStatusPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSyncKeyResponseCode)>,
      std::move(value));
}

KeyUploadStatusPtr
KeyUploadStatus::NewUploadClientError(
    const std::string& value) {
  return KeyUploadStatusPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kUploadClientError)>,
      std::move(value));
}

KeyUploadStatus::KeyUploadStatus(
    std::in_place_index_t<static_cast<size_t>(Tag::kSyncKeyResponseCode)>,
    Int32ValuePtr value)
    : tag_(Tag::kSyncKeyResponseCode),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSyncKeyResponseCode)>,
            std::move(value)) {}

KeyUploadStatus::KeyUploadStatus(
    std::in_place_index_t<static_cast<size_t>(Tag::kUploadClientError)>,
    const std::string& value)
    : tag_(Tag::kUploadClientError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kUploadClientError)>,
            std::move(value)) {}
KeyUploadStatus::~KeyUploadStatus() {
  DestroyActive();
}

void KeyUploadStatus::set_sync_key_response_code(Int32ValuePtr sync_key_response_code) {
  if (tag_ == Tag::kSyncKeyResponseCode) {
    data_.sync_key_response_code = std::move(sync_key_response_code);
  } else {
    DestroyActive();
    tag_ = Tag::kSyncKeyResponseCode;
    new (&data_.sync_key_response_code) Int32ValuePtr(
        std::move(sync_key_response_code));
  }
}

void KeyUploadStatus::set_upload_client_error(const std::string& upload_client_error) {
  if (tag_ == Tag::kUploadClientError) {
    data_.upload_client_error = std::move(upload_client_error);
  } else {
    DestroyActive();
    tag_ = Tag::kUploadClientError;
    new (&data_.upload_client_error) std::string(
        std::move(upload_client_error));
  }
}


KeyUploadStatus::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSyncKeyResponseCode)>,
    Int32ValuePtr value)
    : sync_key_response_code(std::move(value)) {}

KeyUploadStatus::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kUploadClientError)>,
    const std::string& value)
    : upload_client_error(std::move(value)) {}

void KeyUploadStatus::DestroyActive() {
  switch (tag_) {

    case Tag::kSyncKeyResponseCode:
      std::destroy_at(&data_.sync_key_response_code);
      break;
    case Tag::kUploadClientError:
      std::destroy_at(&data_.upload_client_error);
      break;
  }
}
size_t KeyUploadStatus::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kSyncKeyResponseCode:
      return mojo::internal::Hash(seed, data_.sync_key_response_code);
    case Tag::kUploadClientError:
      return mojo::internal::Hash(seed, data_.upload_client_error);
    default:
      NOTREACHED();
  }
}

bool KeyUploadStatus::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kGetDeviceTrustState: {
      return &PageHandler::GetDeviceTrustState_Sym::IPCStableHash;
    }
    case messages::PageHandler::kDeleteDeviceTrustKey: {
      return &PageHandler::DeleteDeviceTrustKey_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetClientCertificateState: {
      return &PageHandler::GetClientCertificateState_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetSignalsReportingState: {
      return &PageHandler::GetSignalsReportingState_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetDeviceTrustState:
            return "Receive connectors_internals::mojom::PageHandler::GetDeviceTrustState";
      case messages::PageHandler::kDeleteDeviceTrustKey:
            return "Receive connectors_internals::mojom::PageHandler::DeleteDeviceTrustKey";
      case messages::PageHandler::kGetClientCertificateState:
            return "Receive connectors_internals::mojom::PageHandler::GetClientCertificateState";
      case messages::PageHandler::kGetSignalsReportingState:
            return "Receive connectors_internals::mojom::PageHandler::GetSignalsReportingState";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetDeviceTrustState:
            return "Receive reply connectors_internals::mojom::PageHandler::GetDeviceTrustState";
      case messages::PageHandler::kDeleteDeviceTrustKey:
            return "Receive reply connectors_internals::mojom::PageHandler::DeleteDeviceTrustKey";
      case messages::PageHandler::kGetClientCertificateState:
            return "Receive reply connectors_internals::mojom::PageHandler::GetClientCertificateState";
      case messages::PageHandler::kGetSignalsReportingState:
            return "Receive reply connectors_internals::mojom::PageHandler::GetSignalsReportingState";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::GetDeviceTrustState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa7dca53a;  // IPCStableHash for connectors_internals::mojom::PageHandler::GetDeviceTrustState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::DeleteDeviceTrustKey_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd314a8e4;  // IPCStableHash for connectors_internals::mojom::PageHandler::DeleteDeviceTrustKey
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetClientCertificateState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6dfef3b9;  // IPCStableHash for connectors_internals::mojom::PageHandler::GetClientCertificateState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetSignalsReportingState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0a3dbdae;  // IPCStableHash for connectors_internals::mojom::PageHandler::GetSignalsReportingState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_GetDeviceTrustState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetDeviceTrustState_ForwardToCallback(
      PageHandler::GetDeviceTrustStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetDeviceTrustState_ForwardToCallback(const PageHandler_GetDeviceTrustState_ForwardToCallback&) = delete;
  PageHandler_GetDeviceTrustState_ForwardToCallback& operator=(const PageHandler_GetDeviceTrustState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetDeviceTrustStateCallback callback_;
};

class PageHandler_DeleteDeviceTrustKey_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_DeleteDeviceTrustKey_ForwardToCallback(
      PageHandler::DeleteDeviceTrustKeyCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_DeleteDeviceTrustKey_ForwardToCallback(const PageHandler_DeleteDeviceTrustKey_ForwardToCallback&) = delete;
  PageHandler_DeleteDeviceTrustKey_ForwardToCallback& operator=(const PageHandler_DeleteDeviceTrustKey_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::DeleteDeviceTrustKeyCallback callback_;
};

class PageHandler_GetClientCertificateState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetClientCertificateState_ForwardToCallback(
      PageHandler::GetClientCertificateStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetClientCertificateState_ForwardToCallback(const PageHandler_GetClientCertificateState_ForwardToCallback&) = delete;
  PageHandler_GetClientCertificateState_ForwardToCallback& operator=(const PageHandler_GetClientCertificateState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetClientCertificateStateCallback callback_;
};

class PageHandler_GetSignalsReportingState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetSignalsReportingState_ForwardToCallback(
      PageHandler::GetSignalsReportingStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetSignalsReportingState_ForwardToCallback(const PageHandler_GetSignalsReportingState_ForwardToCallback&) = delete;
  PageHandler_GetSignalsReportingState_ForwardToCallback& operator=(const PageHandler_GetSignalsReportingState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetSignalsReportingStateCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::GetDeviceTrustState(
    GetDeviceTrustStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send connectors_internals::mojom::PageHandler::GetDeviceTrustState");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetDeviceTrustState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::connectors_internals::mojom::internal::PageHandler_GetDeviceTrustState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetDeviceTrustState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetDeviceTrustState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::DeleteDeviceTrustKey(
    DeleteDeviceTrustKeyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send connectors_internals::mojom::PageHandler::DeleteDeviceTrustKey");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDeleteDeviceTrustKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::connectors_internals::mojom::internal::PageHandler_DeleteDeviceTrustKey_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DeleteDeviceTrustKey");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_DeleteDeviceTrustKey_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetClientCertificateState(
    GetClientCertificateStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send connectors_internals::mojom::PageHandler::GetClientCertificateState");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetClientCertificateState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::connectors_internals::mojom::internal::PageHandler_GetClientCertificateState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetClientCertificateState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetClientCertificateState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetSignalsReportingState(
    GetSignalsReportingStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send connectors_internals::mojom::PageHandler::GetSignalsReportingState");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetSignalsReportingState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::connectors_internals::mojom::internal::PageHandler_GetSignalsReportingState_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetSignalsReportingState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetSignalsReportingState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PageHandler_GetDeviceTrustState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetDeviceTrustStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetDeviceTrustState_ProxyToResponder> proxy(
        new PageHandler_GetDeviceTrustState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetDeviceTrustState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetDeviceTrustState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetDeviceTrustState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetDeviceTrustStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      DeviceTrustStatePtr in_state);
};

bool PageHandler_GetDeviceTrustState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetDeviceTrustState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetDeviceTrustState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.0
  bool success = true;
  DeviceTrustStatePtr p_state{};
  PageHandler_GetDeviceTrustState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_state));
  }
  return true;
}

void PageHandler_GetDeviceTrustState_ProxyToResponder::Run(
    DeviceTrustStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply connectors_internals::mojom::PageHandler::GetDeviceTrustState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type DeviceTrustStatePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetDeviceTrustState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::connectors_internals::mojom::internal::PageHandler_GetDeviceTrustState_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::connectors_internals::mojom::DeviceTrustStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetDeviceTrustState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_DeleteDeviceTrustKey_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::DeleteDeviceTrustKeyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_DeleteDeviceTrustKey_ProxyToResponder> proxy(
        new PageHandler_DeleteDeviceTrustKey_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_DeleteDeviceTrustKey_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_DeleteDeviceTrustKey_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_DeleteDeviceTrustKey_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::DeleteDeviceTrustKeyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PageHandler_DeleteDeviceTrustKey_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_DeleteDeviceTrustKey_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_DeleteDeviceTrustKey_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.1
  bool success = true;
  PageHandler_DeleteDeviceTrustKey_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void PageHandler_DeleteDeviceTrustKey_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply connectors_internals::mojom::PageHandler::DeleteDeviceTrustKey");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kDeleteDeviceTrustKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::connectors_internals::mojom::internal::PageHandler_DeleteDeviceTrustKey_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("DeleteDeviceTrustKey");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetClientCertificateState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetClientCertificateStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetClientCertificateState_ProxyToResponder> proxy(
        new PageHandler_GetClientCertificateState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetClientCertificateState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetClientCertificateState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetClientCertificateState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetClientCertificateStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ClientCertificateStatePtr in_state);
};

bool PageHandler_GetClientCertificateState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetClientCertificateState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetClientCertificateState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.2
  bool success = true;
  ClientCertificateStatePtr p_state{};
  PageHandler_GetClientCertificateState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_state));
  }
  return true;
}

void PageHandler_GetClientCertificateState_ProxyToResponder::Run(
    ClientCertificateStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply connectors_internals::mojom::PageHandler::GetClientCertificateState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ClientCertificateStatePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetClientCertificateState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::connectors_internals::mojom::internal::PageHandler_GetClientCertificateState_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::connectors_internals::mojom::ClientCertificateStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetClientCertificateState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetSignalsReportingState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetSignalsReportingStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetSignalsReportingState_ProxyToResponder> proxy(
        new PageHandler_GetSignalsReportingState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetSignalsReportingState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetSignalsReportingState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetSignalsReportingState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetSignalsReportingStateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SignalsReportingStatePtr in_state);
};

bool PageHandler_GetSignalsReportingState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetSignalsReportingState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetSignalsReportingState_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.3
  bool success = true;
  SignalsReportingStatePtr p_state{};
  PageHandler_GetSignalsReportingState_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_state));
  }
  return true;
}

void PageHandler_GetSignalsReportingState_ProxyToResponder::Run(
    SignalsReportingStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply connectors_internals::mojom::PageHandler::GetSignalsReportingState", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type SignalsReportingStatePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetSignalsReportingState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::connectors_internals::mojom::internal::PageHandler_GetSignalsReportingState_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->state)::BaseType> state_fragment(
          params.message());
  
  mojo::internal::Serialize<::connectors_internals::mojom::SignalsReportingStateDataView>(
    in_state,
    state_fragment);

  params->state.Set(
      state_fragment.is_null() ? nullptr : state_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->state.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null state in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetSignalsReportingState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetDeviceTrustState: {
      break;
    }
    case messages::PageHandler::kDeleteDeviceTrustKey: {
      break;
    }
    case messages::PageHandler::kGetClientCertificateState: {
      break;
    }
    case messages::PageHandler::kGetSignalsReportingState: {
      break;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetDeviceTrustState: {
      internal::PageHandler_GetDeviceTrustState_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetDeviceTrustState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      PageHandler_GetDeviceTrustState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PageHandler_GetDeviceTrustState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDeviceTrustState(std::move(callback));
      return true;
    }
    case messages::PageHandler::kDeleteDeviceTrustKey: {
      internal::PageHandler_DeleteDeviceTrustKey_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_DeleteDeviceTrustKey_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      PageHandler_DeleteDeviceTrustKey_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          PageHandler_DeleteDeviceTrustKey_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteDeviceTrustKey(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetClientCertificateState: {
      internal::PageHandler_GetClientCertificateState_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetClientCertificateState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      PageHandler_GetClientCertificateState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          PageHandler_GetClientCertificateState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetClientCertificateState(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetSignalsReportingState: {
      internal::PageHandler_GetSignalsReportingState_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetSignalsReportingState_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      PageHandler_GetSignalsReportingState_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          PageHandler_GetSignalsReportingState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSignalsReportingState(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_GetDeviceTrustState_Params_Data::Validate,
     &internal::PageHandler_GetDeviceTrustState_ResponseParams_Data::Validate},
    { &internal::PageHandler_DeleteDeviceTrustKey_Params_Data::Validate,
     &internal::PageHandler_DeleteDeviceTrustKey_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetClientCertificateState_Params_Data::Validate,
     &internal::PageHandler_GetClientCertificateState_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetSignalsReportingState_Params_Data::Validate,
     &internal::PageHandler_GetSignalsReportingState_ResponseParams_Data::Validate},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::connectors_internals::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::connectors_internals::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}


}  // connectors_internals::mojom


namespace mojo {


// static
bool StructTraits<::connectors_internals::mojom::Int32Value::DataView, ::connectors_internals::mojom::Int32ValuePtr>::Read(
    ::connectors_internals::mojom::Int32Value::DataView input,
    ::connectors_internals::mojom::Int32ValuePtr* output) {
  bool success = true;
  ::connectors_internals::mojom::Int32ValuePtr result(::connectors_internals::mojom::Int32Value::New());
  
      if (success)
        result->value = input.value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::connectors_internals::mojom::LoadedKeyInfo::DataView, ::connectors_internals::mojom::LoadedKeyInfoPtr>::Read(
    ::connectors_internals::mojom::LoadedKeyInfo::DataView input,
    ::connectors_internals::mojom::LoadedKeyInfoPtr* output) {
  bool success = true;
  ::connectors_internals::mojom::LoadedKeyInfoPtr result(::connectors_internals::mojom::LoadedKeyInfo::New());
  
      if (success && !input.ReadTrustLevel(&result->trust_level))
        success = false;
      if (success && !input.ReadKeyType(&result->key_type))
        success = false;
      if (success && !input.ReadEncodedSpkiHash(&result->encoded_spki_hash))
        success = false;
      if (success && !input.ReadKeyUploadStatus(&result->key_upload_status))
        success = false;
      if (success)
        result->has_ssl_key = input.has_ssl_key();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::connectors_internals::mojom::KeyInfo::DataView, ::connectors_internals::mojom::KeyInfoPtr>::Read(
    ::connectors_internals::mojom::KeyInfo::DataView input,
    ::connectors_internals::mojom::KeyInfoPtr* output) {
  bool success = true;
  ::connectors_internals::mojom::KeyInfoPtr result(::connectors_internals::mojom::KeyInfo::New());
  
      if (success && !input.ReadIsKeyManagerInitialized(&result->is_key_manager_initialized))
        success = false;
      if (success && !input.ReadLoadedKeyInfo(&result->loaded_key_info))
        success = false;
      if (success && !input.ReadPermanentFailure(&result->permanent_failure))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::connectors_internals::mojom::ConsentMetadata::DataView, ::connectors_internals::mojom::ConsentMetadataPtr>::Read(
    ::connectors_internals::mojom::ConsentMetadata::DataView input,
    ::connectors_internals::mojom::ConsentMetadataPtr* output) {
  bool success = true;
  ::connectors_internals::mojom::ConsentMetadataPtr result(::connectors_internals::mojom::ConsentMetadata::New());
  
      if (success)
        result->can_collect_signals = input.can_collect_signals();
      if (success)
        result->consent_received = input.consent_received();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::connectors_internals::mojom::DeviceTrustState::DataView, ::connectors_internals::mojom::DeviceTrustStatePtr>::Read(
    ::connectors_internals::mojom::DeviceTrustState::DataView input,
    ::connectors_internals::mojom::DeviceTrustStatePtr* output) {
  bool success = true;
  ::connectors_internals::mojom::DeviceTrustStatePtr result(::connectors_internals::mojom::DeviceTrustState::New());
  
      if (success)
        result->is_enabled = input.is_enabled();
      if (success && !input.ReadPolicyEnabledLevels(&result->policy_enabled_levels))
        success = false;
      if (success && !input.ReadKeyInfo(&result->key_info))
        success = false;
      if (success && !input.ReadSignalsJson(&result->signals_json))
        success = false;
      if (success && !input.ReadConsentMetadata(&result->consent_metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::connectors_internals::mojom::CertificateMetadata::DataView, ::connectors_internals::mojom::CertificateMetadataPtr>::Read(
    ::connectors_internals::mojom::CertificateMetadata::DataView input,
    ::connectors_internals::mojom::CertificateMetadataPtr* output) {
  bool success = true;
  ::connectors_internals::mojom::CertificateMetadataPtr result(::connectors_internals::mojom::CertificateMetadata::New());
  
      if (success && !input.ReadSerialNumber(&result->serial_number))
        success = false;
      if (success && !input.ReadFingerprint(&result->fingerprint))
        success = false;
      if (success && !input.ReadCreationDateString(&result->creation_date_string))
        success = false;
      if (success && !input.ReadExpirationDateString(&result->expiration_date_string))
        success = false;
      if (success && !input.ReadSubjectDisplayName(&result->subject_display_name))
        success = false;
      if (success && !input.ReadIssuerDisplayName(&result->issuer_display_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::connectors_internals::mojom::ClientIdentity::DataView, ::connectors_internals::mojom::ClientIdentityPtr>::Read(
    ::connectors_internals::mojom::ClientIdentity::DataView input,
    ::connectors_internals::mojom::ClientIdentityPtr* output) {
  bool success = true;
  ::connectors_internals::mojom::ClientIdentityPtr result(::connectors_internals::mojom::ClientIdentity::New());
  
      if (success && !input.ReadIdentityName(&result->identity_name))
        success = false;
      if (success && !input.ReadLoadedKeyInfo(&result->loaded_key_info))
        success = false;
      if (success && !input.ReadCertificateMetadata(&result->certificate_metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::connectors_internals::mojom::ClientCertificateState::DataView, ::connectors_internals::mojom::ClientCertificateStatePtr>::Read(
    ::connectors_internals::mojom::ClientCertificateState::DataView input,
    ::connectors_internals::mojom::ClientCertificateStatePtr* output) {
  bool success = true;
  ::connectors_internals::mojom::ClientCertificateStatePtr result(::connectors_internals::mojom::ClientCertificateState::New());
  
      if (success && !input.ReadPolicyEnabledLevels(&result->policy_enabled_levels))
        success = false;
      if (success && !input.ReadManagedProfileIdentity(&result->managed_profile_identity))
        success = false;
      if (success && !input.ReadManagedBrowserIdentity(&result->managed_browser_identity))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::connectors_internals::mojom::SignalsReportingState::DataView, ::connectors_internals::mojom::SignalsReportingStatePtr>::Read(
    ::connectors_internals::mojom::SignalsReportingState::DataView input,
    ::connectors_internals::mojom::SignalsReportingStatePtr* output) {
  bool success = true;
  ::connectors_internals::mojom::SignalsReportingStatePtr result(::connectors_internals::mojom::SignalsReportingState::New());
  
      if (success && !input.ReadErrorInfo(&result->error_info))
        success = false;
      if (success)
        result->status_report_enabled = input.status_report_enabled();
      if (success)
        result->signals_report_enabled = input.signals_report_enabled();
      if (success && !input.ReadLastUploadAttemptTimestamp(&result->last_upload_attempt_timestamp))
        success = false;
      if (success && !input.ReadLastUploadSuccessTimestamp(&result->last_upload_success_timestamp))
        success = false;
      if (success && !input.ReadLastSignalsUploadConfig(&result->last_signals_upload_config))
        success = false;
      if (success)
        result->can_collect_all_fields = input.can_collect_all_fields();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::connectors_internals::mojom::KeyUploadStatus::DataView, ::connectors_internals::mojom::KeyUploadStatusPtr>::Read(
    ::connectors_internals::mojom::KeyUploadStatus::DataView input,
    ::connectors_internals::mojom::KeyUploadStatusPtr* output) {
  using UnionType = ::connectors_internals::mojom::KeyUploadStatus;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSyncKeyResponseCode: {
      ::connectors_internals::mojom::Int32ValuePtr result_sync_key_response_code{};
      if (!input.ReadSyncKeyResponseCode(&result_sync_key_response_code))
        return false;

      *output = UnionType::NewSyncKeyResponseCode(
          std::move(result_sync_key_response_code));
      break;
    }
    case Tag::kUploadClientError: {
      std::string result_upload_client_error{};
      if (!input.ReadUploadClientError(&result_upload_client_error))
        return false;

      *output = UnionType::NewUploadClientError(
          std::move(result_upload_client_error));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace connectors_internals::mojom {


void PageHandlerInterceptorForTesting::GetDeviceTrustState(GetDeviceTrustStateCallback callback) {
  GetForwardingInterface()->GetDeviceTrustState(std::move(callback));
}
void PageHandlerInterceptorForTesting::DeleteDeviceTrustKey(DeleteDeviceTrustKeyCallback callback) {
  GetForwardingInterface()->DeleteDeviceTrustKey(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetClientCertificateState(GetClientCertificateStateCallback callback) {
  GetForwardingInterface()->GetClientCertificateState(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetSignalsReportingState(GetSignalsReportingStateCallback callback) {
  GetForwardingInterface()->GetSignalsReportingState(std::move(callback));
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::GetDeviceTrustState(
    DeviceTrustStatePtr* out_state) {
  base::RunLoop loop;
  proxy_->GetDeviceTrustState(
      base::BindOnce(
          [](base::RunLoop* loop,
             DeviceTrustStatePtr* out_state
,
             DeviceTrustStatePtr state) {*out_state = std::move(state);
            loop->Quit();
          },
          &loop,
          out_state));
  loop.Run();
}

DeviceTrustStatePtr PageHandlerAsyncWaiter::GetDeviceTrustState(
    ) {
  DeviceTrustStatePtr async_wait_result;
  GetDeviceTrustState(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::DeleteDeviceTrustKey(
    ) {
  base::RunLoop loop;
  proxy_->DeleteDeviceTrustKey(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void PageHandlerAsyncWaiter::GetClientCertificateState(
    ClientCertificateStatePtr* out_state) {
  base::RunLoop loop;
  proxy_->GetClientCertificateState(
      base::BindOnce(
          [](base::RunLoop* loop,
             ClientCertificateStatePtr* out_state
,
             ClientCertificateStatePtr state) {*out_state = std::move(state);
            loop->Quit();
          },
          &loop,
          out_state));
  loop.Run();
}

ClientCertificateStatePtr PageHandlerAsyncWaiter::GetClientCertificateState(
    ) {
  ClientCertificateStatePtr async_wait_result;
  GetClientCertificateState(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetSignalsReportingState(
    SignalsReportingStatePtr* out_state) {
  base::RunLoop loop;
  proxy_->GetSignalsReportingState(
      base::BindOnce(
          [](base::RunLoop* loop,
             SignalsReportingStatePtr* out_state
,
             SignalsReportingStatePtr state) {*out_state = std::move(state);
            loop->Quit();
          },
          &loop,
          out_state));
  loop.Run();
}

SignalsReportingStatePtr PageHandlerAsyncWaiter::GetSignalsReportingState(
    ) {
  SignalsReportingStatePtr async_wait_result;
  GetSignalsReportingState(&async_wait_result);
  return async_wait_result;
}






}  // connectors_internals::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif