// chrome/browser/ui/webui/bluetooth_internals/bluetooth_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/bluetooth_internals/bluetooth_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/bluetooth_internals/bluetooth_internals.mojom-params-data.h"
#include "chrome/browser/ui/webui/bluetooth_internals/bluetooth_internals.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/bluetooth_internals/bluetooth_internals.mojom-import-headers.h"
#include "chrome/browser/ui/webui/bluetooth_internals/bluetooth_internals.mojom-test-utils.h"


namespace mojom {
// The declaration includes the definition on other builds.

DebugLogsChangeHandler::IPCStableHashFunction DebugLogsChangeHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DebugLogsChangeHandler>(message.name())) {
    case messages::DebugLogsChangeHandler::kChangeDebugLogsState: {
      return &DebugLogsChangeHandler::ChangeDebugLogsState_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DebugLogsChangeHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DebugLogsChangeHandler>(message.name())) {
      case messages::DebugLogsChangeHandler::kChangeDebugLogsState:
            return "Receive mojom::DebugLogsChangeHandler::ChangeDebugLogsState";
    }
  } else {
    switch (static_cast<messages::DebugLogsChangeHandler>(message.name())) {
      case messages::DebugLogsChangeHandler::kChangeDebugLogsState:
            return "Receive reply mojom::DebugLogsChangeHandler::ChangeDebugLogsState";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DebugLogsChangeHandler::ChangeDebugLogsState_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x99dd74b1;  // IPCStableHash for mojom::DebugLogsChangeHandler::ChangeDebugLogsState
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DebugLogsChangeHandlerProxy::DebugLogsChangeHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DebugLogsChangeHandlerProxy::ChangeDebugLogsState(
    bool in_should_debug_logs_be_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::DebugLogsChangeHandler::ChangeDebugLogsState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_debug_logs_be_enabled"), in_should_debug_logs_be_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DebugLogsChangeHandler::kChangeDebugLogsState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::DebugLogsChangeHandler_ChangeDebugLogsState_Params_Data> params(
          message);
  params.Allocate();

  params->should_debug_logs_be_enabled = in_should_debug_logs_be_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DebugLogsChangeHandler::Name_);
  message.set_method_name("ChangeDebugLogsState");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DebugLogsChangeHandlerStubDispatch::Accept(
    DebugLogsChangeHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DebugLogsChangeHandler>(message->header()->name)) {
    case messages::DebugLogsChangeHandler::kChangeDebugLogsState: {
      DCHECK(message->is_serialized());
      internal::DebugLogsChangeHandler_ChangeDebugLogsState_Params_Data* params =
          reinterpret_cast<internal::DebugLogsChangeHandler_ChangeDebugLogsState_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DebugLogsChangeHandler.0
      bool success = true;
      bool p_should_debug_logs_be_enabled{};
      DebugLogsChangeHandler_ChangeDebugLogsState_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_should_debug_logs_be_enabled = input_data_view.should_debug_logs_be_enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DebugLogsChangeHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ChangeDebugLogsState(        
        std::move(p_should_debug_logs_be_enabled));
      return true;
    }
  }
  return false;
}

// static
bool DebugLogsChangeHandlerStubDispatch::AcceptWithResponder(
    DebugLogsChangeHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DebugLogsChangeHandler>(message->header()->name)) {
    case messages::DebugLogsChangeHandler::kChangeDebugLogsState: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDebugLogsChangeHandlerValidationInfo[] = {
    { &internal::DebugLogsChangeHandler_ChangeDebugLogsState_Params_Data::Validate,
     nullptr /* no response */},
};

bool DebugLogsChangeHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::mojom::DebugLogsChangeHandler::Name_,
    kDebugLogsChangeHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

BluetoothInternalsHandler::IPCStableHashFunction BluetoothInternalsHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BluetoothInternalsHandler>(message.name())) {
    case messages::BluetoothInternalsHandler::kGetAdapter: {
      return &BluetoothInternalsHandler::GetAdapter_Sym::IPCStableHash;
    }
    case messages::BluetoothInternalsHandler::kGetDebugLogsChangeHandler: {
      return &BluetoothInternalsHandler::GetDebugLogsChangeHandler_Sym::IPCStableHash;
    }
    case messages::BluetoothInternalsHandler::kCheckSystemPermissions: {
      return &BluetoothInternalsHandler::CheckSystemPermissions_Sym::IPCStableHash;
    }
    case messages::BluetoothInternalsHandler::kRequestSystemPermissions: {
      return &BluetoothInternalsHandler::RequestSystemPermissions_Sym::IPCStableHash;
    }
    case messages::BluetoothInternalsHandler::kRequestLocationServices: {
      return &BluetoothInternalsHandler::RequestLocationServices_Sym::IPCStableHash;
    }
    case messages::BluetoothInternalsHandler::kStartBtsnoop: {
      return &BluetoothInternalsHandler::StartBtsnoop_Sym::IPCStableHash;
    }
    case messages::BluetoothInternalsHandler::kIsBtsnoopFeatureEnabled: {
      return &BluetoothInternalsHandler::IsBtsnoopFeatureEnabled_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BluetoothInternalsHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BluetoothInternalsHandler>(message.name())) {
      case messages::BluetoothInternalsHandler::kGetAdapter:
            return "Receive mojom::BluetoothInternalsHandler::GetAdapter";
      case messages::BluetoothInternalsHandler::kGetDebugLogsChangeHandler:
            return "Receive mojom::BluetoothInternalsHandler::GetDebugLogsChangeHandler";
      case messages::BluetoothInternalsHandler::kCheckSystemPermissions:
            return "Receive mojom::BluetoothInternalsHandler::CheckSystemPermissions";
      case messages::BluetoothInternalsHandler::kRequestSystemPermissions:
            return "Receive mojom::BluetoothInternalsHandler::RequestSystemPermissions";
      case messages::BluetoothInternalsHandler::kRequestLocationServices:
            return "Receive mojom::BluetoothInternalsHandler::RequestLocationServices";
      case messages::BluetoothInternalsHandler::kStartBtsnoop:
            return "Receive mojom::BluetoothInternalsHandler::StartBtsnoop";
      case messages::BluetoothInternalsHandler::kIsBtsnoopFeatureEnabled:
            return "Receive mojom::BluetoothInternalsHandler::IsBtsnoopFeatureEnabled";
    }
  } else {
    switch (static_cast<messages::BluetoothInternalsHandler>(message.name())) {
      case messages::BluetoothInternalsHandler::kGetAdapter:
            return "Receive reply mojom::BluetoothInternalsHandler::GetAdapter";
      case messages::BluetoothInternalsHandler::kGetDebugLogsChangeHandler:
            return "Receive reply mojom::BluetoothInternalsHandler::GetDebugLogsChangeHandler";
      case messages::BluetoothInternalsHandler::kCheckSystemPermissions:
            return "Receive reply mojom::BluetoothInternalsHandler::CheckSystemPermissions";
      case messages::BluetoothInternalsHandler::kRequestSystemPermissions:
            return "Receive reply mojom::BluetoothInternalsHandler::RequestSystemPermissions";
      case messages::BluetoothInternalsHandler::kRequestLocationServices:
            return "Receive reply mojom::BluetoothInternalsHandler::RequestLocationServices";
      case messages::BluetoothInternalsHandler::kStartBtsnoop:
            return "Receive reply mojom::BluetoothInternalsHandler::StartBtsnoop";
      case messages::BluetoothInternalsHandler::kIsBtsnoopFeatureEnabled:
            return "Receive reply mojom::BluetoothInternalsHandler::IsBtsnoopFeatureEnabled";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BluetoothInternalsHandler::GetAdapter_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x122366b8;  // IPCStableHash for mojom::BluetoothInternalsHandler::GetAdapter
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BluetoothInternalsHandler::GetDebugLogsChangeHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x544689de;  // IPCStableHash for mojom::BluetoothInternalsHandler::GetDebugLogsChangeHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BluetoothInternalsHandler::CheckSystemPermissions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x34e172e0;  // IPCStableHash for mojom::BluetoothInternalsHandler::CheckSystemPermissions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BluetoothInternalsHandler::RequestSystemPermissions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x14dfd7ef;  // IPCStableHash for mojom::BluetoothInternalsHandler::RequestSystemPermissions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BluetoothInternalsHandler::RequestLocationServices_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xed1eced8;  // IPCStableHash for mojom::BluetoothInternalsHandler::RequestLocationServices
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BluetoothInternalsHandler::StartBtsnoop_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xedfccab5;  // IPCStableHash for mojom::BluetoothInternalsHandler::StartBtsnoop
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BluetoothInternalsHandler::IsBtsnoopFeatureEnabled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe5b85137;  // IPCStableHash for mojom::BluetoothInternalsHandler::IsBtsnoopFeatureEnabled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BluetoothInternalsHandler_GetAdapter_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BluetoothInternalsHandler_GetAdapter_ForwardToCallback(
      BluetoothInternalsHandler::GetAdapterCallback callback
      ) : callback_(std::move(callback)) {
  }

  BluetoothInternalsHandler_GetAdapter_ForwardToCallback(const BluetoothInternalsHandler_GetAdapter_ForwardToCallback&) = delete;
  BluetoothInternalsHandler_GetAdapter_ForwardToCallback& operator=(const BluetoothInternalsHandler_GetAdapter_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BluetoothInternalsHandler::GetAdapterCallback callback_;
};

class BluetoothInternalsHandler_GetDebugLogsChangeHandler_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BluetoothInternalsHandler_GetDebugLogsChangeHandler_ForwardToCallback(
      BluetoothInternalsHandler::GetDebugLogsChangeHandlerCallback callback
      ) : callback_(std::move(callback)) {
  }

  BluetoothInternalsHandler_GetDebugLogsChangeHandler_ForwardToCallback(const BluetoothInternalsHandler_GetDebugLogsChangeHandler_ForwardToCallback&) = delete;
  BluetoothInternalsHandler_GetDebugLogsChangeHandler_ForwardToCallback& operator=(const BluetoothInternalsHandler_GetDebugLogsChangeHandler_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BluetoothInternalsHandler::GetDebugLogsChangeHandlerCallback callback_;
};

class BluetoothInternalsHandler_CheckSystemPermissions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BluetoothInternalsHandler_CheckSystemPermissions_ForwardToCallback(
      BluetoothInternalsHandler::CheckSystemPermissionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  BluetoothInternalsHandler_CheckSystemPermissions_ForwardToCallback(const BluetoothInternalsHandler_CheckSystemPermissions_ForwardToCallback&) = delete;
  BluetoothInternalsHandler_CheckSystemPermissions_ForwardToCallback& operator=(const BluetoothInternalsHandler_CheckSystemPermissions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BluetoothInternalsHandler::CheckSystemPermissionsCallback callback_;
};

class BluetoothInternalsHandler_RequestSystemPermissions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BluetoothInternalsHandler_RequestSystemPermissions_ForwardToCallback(
      BluetoothInternalsHandler::RequestSystemPermissionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  BluetoothInternalsHandler_RequestSystemPermissions_ForwardToCallback(const BluetoothInternalsHandler_RequestSystemPermissions_ForwardToCallback&) = delete;
  BluetoothInternalsHandler_RequestSystemPermissions_ForwardToCallback& operator=(const BluetoothInternalsHandler_RequestSystemPermissions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BluetoothInternalsHandler::RequestSystemPermissionsCallback callback_;
};

class BluetoothInternalsHandler_RequestLocationServices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BluetoothInternalsHandler_RequestLocationServices_ForwardToCallback(
      BluetoothInternalsHandler::RequestLocationServicesCallback callback
      ) : callback_(std::move(callback)) {
  }

  BluetoothInternalsHandler_RequestLocationServices_ForwardToCallback(const BluetoothInternalsHandler_RequestLocationServices_ForwardToCallback&) = delete;
  BluetoothInternalsHandler_RequestLocationServices_ForwardToCallback& operator=(const BluetoothInternalsHandler_RequestLocationServices_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BluetoothInternalsHandler::RequestLocationServicesCallback callback_;
};

class BluetoothInternalsHandler_StartBtsnoop_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BluetoothInternalsHandler_StartBtsnoop_ForwardToCallback(
      BluetoothInternalsHandler::StartBtsnoopCallback callback
      ) : callback_(std::move(callback)) {
  }

  BluetoothInternalsHandler_StartBtsnoop_ForwardToCallback(const BluetoothInternalsHandler_StartBtsnoop_ForwardToCallback&) = delete;
  BluetoothInternalsHandler_StartBtsnoop_ForwardToCallback& operator=(const BluetoothInternalsHandler_StartBtsnoop_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BluetoothInternalsHandler::StartBtsnoopCallback callback_;
};

class BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ForwardToCallback(
      BluetoothInternalsHandler::IsBtsnoopFeatureEnabledCallback callback
      ) : callback_(std::move(callback)) {
  }

  BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ForwardToCallback(const BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ForwardToCallback&) = delete;
  BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ForwardToCallback& operator=(const BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BluetoothInternalsHandler::IsBtsnoopFeatureEnabledCallback callback_;
};

BluetoothInternalsHandlerProxy::BluetoothInternalsHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BluetoothInternalsHandlerProxy::GetAdapter(
    GetAdapterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::BluetoothInternalsHandler::GetAdapter");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BluetoothInternalsHandler::kGetAdapter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::BluetoothInternalsHandler_GetAdapter_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BluetoothInternalsHandler::Name_);
  message.set_method_name("GetAdapter");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BluetoothInternalsHandler_GetAdapter_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BluetoothInternalsHandlerProxy::GetDebugLogsChangeHandler(
    GetDebugLogsChangeHandlerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::BluetoothInternalsHandler::GetDebugLogsChangeHandler");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BluetoothInternalsHandler::kGetDebugLogsChangeHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::BluetoothInternalsHandler_GetDebugLogsChangeHandler_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BluetoothInternalsHandler::Name_);
  message.set_method_name("GetDebugLogsChangeHandler");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BluetoothInternalsHandler_GetDebugLogsChangeHandler_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BluetoothInternalsHandlerProxy::CheckSystemPermissions(
    CheckSystemPermissionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::BluetoothInternalsHandler::CheckSystemPermissions");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BluetoothInternalsHandler::kCheckSystemPermissions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::BluetoothInternalsHandler_CheckSystemPermissions_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BluetoothInternalsHandler::Name_);
  message.set_method_name("CheckSystemPermissions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BluetoothInternalsHandler_CheckSystemPermissions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BluetoothInternalsHandlerProxy::RequestSystemPermissions(
    RequestSystemPermissionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::BluetoothInternalsHandler::RequestSystemPermissions");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BluetoothInternalsHandler::kRequestSystemPermissions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::BluetoothInternalsHandler_RequestSystemPermissions_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BluetoothInternalsHandler::Name_);
  message.set_method_name("RequestSystemPermissions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BluetoothInternalsHandler_RequestSystemPermissions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BluetoothInternalsHandlerProxy::RequestLocationServices(
    RequestLocationServicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::BluetoothInternalsHandler::RequestLocationServices");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BluetoothInternalsHandler::kRequestLocationServices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::BluetoothInternalsHandler_RequestLocationServices_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BluetoothInternalsHandler::Name_);
  message.set_method_name("RequestLocationServices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BluetoothInternalsHandler_RequestLocationServices_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BluetoothInternalsHandlerProxy::StartBtsnoop(
    StartBtsnoopCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::BluetoothInternalsHandler::StartBtsnoop");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BluetoothInternalsHandler::kStartBtsnoop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::BluetoothInternalsHandler_StartBtsnoop_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BluetoothInternalsHandler::Name_);
  message.set_method_name("StartBtsnoop");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BluetoothInternalsHandler_StartBtsnoop_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BluetoothInternalsHandlerProxy::IsBtsnoopFeatureEnabled(
    IsBtsnoopFeatureEnabledCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::BluetoothInternalsHandler::IsBtsnoopFeatureEnabled");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BluetoothInternalsHandler::kIsBtsnoopFeatureEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BluetoothInternalsHandler::Name_);
  message.set_method_name("IsBtsnoopFeatureEnabled");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BluetoothInternalsHandler_GetAdapter_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BluetoothInternalsHandler::GetAdapterCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BluetoothInternalsHandler_GetAdapter_ProxyToResponder> proxy(
        new BluetoothInternalsHandler_GetAdapter_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BluetoothInternalsHandler_GetAdapter_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BluetoothInternalsHandler_GetAdapter_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BluetoothInternalsHandler_GetAdapter_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BluetoothInternalsHandler::GetAdapterCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<::bluetooth::mojom::Adapter> in_adapter);
};

bool BluetoothInternalsHandler_GetAdapter_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BluetoothInternalsHandler_GetAdapter_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BluetoothInternalsHandler_GetAdapter_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BluetoothInternalsHandler.0
  bool success = true;
  ::mojo::PendingRemote<::bluetooth::mojom::Adapter> p_adapter{};
  BluetoothInternalsHandler_GetAdapter_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_adapter =
        input_data_view.TakeAdapter<decltype(p_adapter)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BluetoothInternalsHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_adapter));
  }
  return true;
}

void BluetoothInternalsHandler_GetAdapter_ProxyToResponder::Run(
    ::mojo::PendingRemote<::bluetooth::mojom::Adapter> in_adapter) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::BluetoothInternalsHandler::GetAdapter", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("adapter"), in_adapter,
                        "<value of type ::mojo::PendingRemote<::bluetooth::mojom::Adapter>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BluetoothInternalsHandler::kGetAdapter), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::BluetoothInternalsHandler_GetAdapter_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::bluetooth::mojom::AdapterInterfaceBase>>(
    in_adapter,
    &params->adapter,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BluetoothInternalsHandler::Name_);
  message.set_method_name("GetAdapter");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BluetoothInternalsHandler_GetDebugLogsChangeHandler_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BluetoothInternalsHandler::GetDebugLogsChangeHandlerCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BluetoothInternalsHandler_GetDebugLogsChangeHandler_ProxyToResponder> proxy(
        new BluetoothInternalsHandler_GetDebugLogsChangeHandler_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BluetoothInternalsHandler_GetDebugLogsChangeHandler_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BluetoothInternalsHandler_GetDebugLogsChangeHandler_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BluetoothInternalsHandler_GetDebugLogsChangeHandler_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BluetoothInternalsHandler::GetDebugLogsChangeHandlerCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<DebugLogsChangeHandler> in_handler, bool in_initial_toggle_value);
};

bool BluetoothInternalsHandler_GetDebugLogsChangeHandler_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BluetoothInternalsHandler_GetDebugLogsChangeHandler_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BluetoothInternalsHandler_GetDebugLogsChangeHandler_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BluetoothInternalsHandler.1
  bool success = true;
  ::mojo::PendingRemote<DebugLogsChangeHandler> p_handler{};
  bool p_initial_toggle_value{};
  BluetoothInternalsHandler_GetDebugLogsChangeHandler_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_handler =
        input_data_view.TakeHandler<decltype(p_handler)>();
  }
  if (success)
    p_initial_toggle_value = input_data_view.initial_toggle_value();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BluetoothInternalsHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_handler), 
std::move(p_initial_toggle_value));
  }
  return true;
}

void BluetoothInternalsHandler_GetDebugLogsChangeHandler_ProxyToResponder::Run(
    ::mojo::PendingRemote<DebugLogsChangeHandler> in_handler, bool in_initial_toggle_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::BluetoothInternalsHandler::GetDebugLogsChangeHandler", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingRemote<DebugLogsChangeHandler>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("initial_toggle_value"), in_initial_toggle_value,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BluetoothInternalsHandler::kGetDebugLogsChangeHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::BluetoothInternalsHandler_GetDebugLogsChangeHandler_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::mojom::DebugLogsChangeHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  params->initial_toggle_value = in_initial_toggle_value;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BluetoothInternalsHandler::Name_);
  message.set_method_name("GetDebugLogsChangeHandler");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BluetoothInternalsHandler_CheckSystemPermissions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BluetoothInternalsHandler::CheckSystemPermissionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BluetoothInternalsHandler_CheckSystemPermissions_ProxyToResponder> proxy(
        new BluetoothInternalsHandler_CheckSystemPermissions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BluetoothInternalsHandler_CheckSystemPermissions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BluetoothInternalsHandler_CheckSystemPermissions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BluetoothInternalsHandler_CheckSystemPermissions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BluetoothInternalsHandler::CheckSystemPermissionsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_need_location_permission, bool in_need_nearby_devices_permission, bool in_need_location_services, bool in_can_request_permissions);
};

bool BluetoothInternalsHandler_CheckSystemPermissions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BluetoothInternalsHandler_CheckSystemPermissions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BluetoothInternalsHandler_CheckSystemPermissions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BluetoothInternalsHandler.2
  bool success = true;
  bool p_need_location_permission{};
  bool p_need_nearby_devices_permission{};
  bool p_need_location_services{};
  bool p_can_request_permissions{};
  BluetoothInternalsHandler_CheckSystemPermissions_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_need_location_permission = input_data_view.need_location_permission();
  if (success)
    p_need_nearby_devices_permission = input_data_view.need_nearby_devices_permission();
  if (success)
    p_need_location_services = input_data_view.need_location_services();
  if (success)
    p_can_request_permissions = input_data_view.can_request_permissions();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BluetoothInternalsHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_need_location_permission), 
std::move(p_need_nearby_devices_permission), 
std::move(p_need_location_services), 
std::move(p_can_request_permissions));
  }
  return true;
}

void BluetoothInternalsHandler_CheckSystemPermissions_ProxyToResponder::Run(
    bool in_need_location_permission, bool in_need_nearby_devices_permission, bool in_need_location_services, bool in_can_request_permissions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::BluetoothInternalsHandler::CheckSystemPermissions", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("need_location_permission"), in_need_location_permission,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("need_nearby_devices_permission"), in_need_nearby_devices_permission,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("need_location_services"), in_need_location_services,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("can_request_permissions"), in_can_request_permissions,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BluetoothInternalsHandler::kCheckSystemPermissions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::BluetoothInternalsHandler_CheckSystemPermissions_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->need_location_permission = in_need_location_permission;

  params->need_nearby_devices_permission = in_need_nearby_devices_permission;

  params->need_location_services = in_need_location_services;

  params->can_request_permissions = in_can_request_permissions;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BluetoothInternalsHandler::Name_);
  message.set_method_name("CheckSystemPermissions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BluetoothInternalsHandler_RequestSystemPermissions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BluetoothInternalsHandler::RequestSystemPermissionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BluetoothInternalsHandler_RequestSystemPermissions_ProxyToResponder> proxy(
        new BluetoothInternalsHandler_RequestSystemPermissions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BluetoothInternalsHandler_RequestSystemPermissions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BluetoothInternalsHandler_RequestSystemPermissions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BluetoothInternalsHandler_RequestSystemPermissions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BluetoothInternalsHandler::RequestSystemPermissionsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool BluetoothInternalsHandler_RequestSystemPermissions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BluetoothInternalsHandler_RequestSystemPermissions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BluetoothInternalsHandler_RequestSystemPermissions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BluetoothInternalsHandler.3
  bool success = true;
  BluetoothInternalsHandler_RequestSystemPermissions_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BluetoothInternalsHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void BluetoothInternalsHandler_RequestSystemPermissions_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply mojom::BluetoothInternalsHandler::RequestSystemPermissions");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BluetoothInternalsHandler::kRequestSystemPermissions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::BluetoothInternalsHandler_RequestSystemPermissions_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BluetoothInternalsHandler::Name_);
  message.set_method_name("RequestSystemPermissions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BluetoothInternalsHandler_RequestLocationServices_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BluetoothInternalsHandler::RequestLocationServicesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BluetoothInternalsHandler_RequestLocationServices_ProxyToResponder> proxy(
        new BluetoothInternalsHandler_RequestLocationServices_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BluetoothInternalsHandler_RequestLocationServices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BluetoothInternalsHandler_RequestLocationServices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BluetoothInternalsHandler_RequestLocationServices_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BluetoothInternalsHandler::RequestLocationServicesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool BluetoothInternalsHandler_RequestLocationServices_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BluetoothInternalsHandler_RequestLocationServices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BluetoothInternalsHandler_RequestLocationServices_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BluetoothInternalsHandler.4
  bool success = true;
  BluetoothInternalsHandler_RequestLocationServices_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BluetoothInternalsHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void BluetoothInternalsHandler_RequestLocationServices_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply mojom::BluetoothInternalsHandler::RequestLocationServices");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BluetoothInternalsHandler::kRequestLocationServices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::BluetoothInternalsHandler_RequestLocationServices_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BluetoothInternalsHandler::Name_);
  message.set_method_name("RequestLocationServices");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BluetoothInternalsHandler_StartBtsnoop_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BluetoothInternalsHandler::StartBtsnoopCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BluetoothInternalsHandler_StartBtsnoop_ProxyToResponder> proxy(
        new BluetoothInternalsHandler_StartBtsnoop_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BluetoothInternalsHandler_StartBtsnoop_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BluetoothInternalsHandler_StartBtsnoop_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BluetoothInternalsHandler_StartBtsnoop_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BluetoothInternalsHandler::StartBtsnoopCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<BluetoothBtsnoop> in_btsnoop);
};

bool BluetoothInternalsHandler_StartBtsnoop_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BluetoothInternalsHandler_StartBtsnoop_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BluetoothInternalsHandler_StartBtsnoop_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BluetoothInternalsHandler.5
  bool success = true;
  ::mojo::PendingRemote<BluetoothBtsnoop> p_btsnoop{};
  BluetoothInternalsHandler_StartBtsnoop_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_btsnoop =
        input_data_view.TakeBtsnoop<decltype(p_btsnoop)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BluetoothInternalsHandler::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_btsnoop));
  }
  return true;
}

void BluetoothInternalsHandler_StartBtsnoop_ProxyToResponder::Run(
    ::mojo::PendingRemote<BluetoothBtsnoop> in_btsnoop) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::BluetoothInternalsHandler::StartBtsnoop", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("btsnoop"), in_btsnoop,
                        "<value of type ::mojo::PendingRemote<BluetoothBtsnoop>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BluetoothInternalsHandler::kStartBtsnoop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::BluetoothInternalsHandler_StartBtsnoop_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::mojom::BluetoothBtsnoopInterfaceBase>>(
    in_btsnoop,
    &params->btsnoop,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BluetoothInternalsHandler::Name_);
  message.set_method_name("StartBtsnoop");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BluetoothInternalsHandler::IsBtsnoopFeatureEnabledCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ProxyToResponder> proxy(
        new BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BluetoothInternalsHandler::IsBtsnoopFeatureEnabledCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_enabled);
};

bool BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BluetoothInternalsHandler.6
  bool success = true;
  bool p_enabled{};
  BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_enabled = input_data_view.enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BluetoothInternalsHandler::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_enabled));
  }
  return true;
}

void BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ProxyToResponder::Run(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::BluetoothInternalsHandler::IsBtsnoopFeatureEnabled", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BluetoothInternalsHandler::kIsBtsnoopFeatureEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BluetoothInternalsHandler::Name_);
  message.set_method_name("IsBtsnoopFeatureEnabled");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BluetoothInternalsHandlerStubDispatch::Accept(
    BluetoothInternalsHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BluetoothInternalsHandler>(message->header()->name)) {
    case messages::BluetoothInternalsHandler::kGetAdapter: {
      break;
    }
    case messages::BluetoothInternalsHandler::kGetDebugLogsChangeHandler: {
      break;
    }
    case messages::BluetoothInternalsHandler::kCheckSystemPermissions: {
      break;
    }
    case messages::BluetoothInternalsHandler::kRequestSystemPermissions: {
      break;
    }
    case messages::BluetoothInternalsHandler::kRequestLocationServices: {
      break;
    }
    case messages::BluetoothInternalsHandler::kStartBtsnoop: {
      break;
    }
    case messages::BluetoothInternalsHandler::kIsBtsnoopFeatureEnabled: {
      break;
    }
  }
  return false;
}

// static
bool BluetoothInternalsHandlerStubDispatch::AcceptWithResponder(
    BluetoothInternalsHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BluetoothInternalsHandler>(message->header()->name)) {
    case messages::BluetoothInternalsHandler::kGetAdapter: {
      internal::BluetoothInternalsHandler_GetAdapter_Params_Data* params =
          reinterpret_cast<
              internal::BluetoothInternalsHandler_GetAdapter_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BluetoothInternalsHandler.0
      bool success = true;
      BluetoothInternalsHandler_GetAdapter_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BluetoothInternalsHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          BluetoothInternalsHandler_GetAdapter_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAdapter(std::move(callback));
      return true;
    }
    case messages::BluetoothInternalsHandler::kGetDebugLogsChangeHandler: {
      internal::BluetoothInternalsHandler_GetDebugLogsChangeHandler_Params_Data* params =
          reinterpret_cast<
              internal::BluetoothInternalsHandler_GetDebugLogsChangeHandler_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BluetoothInternalsHandler.1
      bool success = true;
      BluetoothInternalsHandler_GetDebugLogsChangeHandler_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BluetoothInternalsHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          BluetoothInternalsHandler_GetDebugLogsChangeHandler_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDebugLogsChangeHandler(std::move(callback));
      return true;
    }
    case messages::BluetoothInternalsHandler::kCheckSystemPermissions: {
      internal::BluetoothInternalsHandler_CheckSystemPermissions_Params_Data* params =
          reinterpret_cast<
              internal::BluetoothInternalsHandler_CheckSystemPermissions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BluetoothInternalsHandler.2
      bool success = true;
      BluetoothInternalsHandler_CheckSystemPermissions_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BluetoothInternalsHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          BluetoothInternalsHandler_CheckSystemPermissions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CheckSystemPermissions(std::move(callback));
      return true;
    }
    case messages::BluetoothInternalsHandler::kRequestSystemPermissions: {
      internal::BluetoothInternalsHandler_RequestSystemPermissions_Params_Data* params =
          reinterpret_cast<
              internal::BluetoothInternalsHandler_RequestSystemPermissions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BluetoothInternalsHandler.3
      bool success = true;
      BluetoothInternalsHandler_RequestSystemPermissions_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BluetoothInternalsHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          BluetoothInternalsHandler_RequestSystemPermissions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestSystemPermissions(std::move(callback));
      return true;
    }
    case messages::BluetoothInternalsHandler::kRequestLocationServices: {
      internal::BluetoothInternalsHandler_RequestLocationServices_Params_Data* params =
          reinterpret_cast<
              internal::BluetoothInternalsHandler_RequestLocationServices_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BluetoothInternalsHandler.4
      bool success = true;
      BluetoothInternalsHandler_RequestLocationServices_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BluetoothInternalsHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          BluetoothInternalsHandler_RequestLocationServices_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestLocationServices(std::move(callback));
      return true;
    }
    case messages::BluetoothInternalsHandler::kStartBtsnoop: {
      internal::BluetoothInternalsHandler_StartBtsnoop_Params_Data* params =
          reinterpret_cast<
              internal::BluetoothInternalsHandler_StartBtsnoop_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BluetoothInternalsHandler.5
      bool success = true;
      BluetoothInternalsHandler_StartBtsnoop_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BluetoothInternalsHandler::Name_, 5, false);
        return false;
      }
      auto callback =
          BluetoothInternalsHandler_StartBtsnoop_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartBtsnoop(std::move(callback));
      return true;
    }
    case messages::BluetoothInternalsHandler::kIsBtsnoopFeatureEnabled: {
      internal::BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_Params_Data* params =
          reinterpret_cast<
              internal::BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BluetoothInternalsHandler.6
      bool success = true;
      BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BluetoothInternalsHandler::Name_, 6, false);
        return false;
      }
      auto callback =
          BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsBtsnoopFeatureEnabled(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBluetoothInternalsHandlerValidationInfo[] = {
    { &internal::BluetoothInternalsHandler_GetAdapter_Params_Data::Validate,
     &internal::BluetoothInternalsHandler_GetAdapter_ResponseParams_Data::Validate},
    { &internal::BluetoothInternalsHandler_GetDebugLogsChangeHandler_Params_Data::Validate,
     &internal::BluetoothInternalsHandler_GetDebugLogsChangeHandler_ResponseParams_Data::Validate},
    { &internal::BluetoothInternalsHandler_CheckSystemPermissions_Params_Data::Validate,
     &internal::BluetoothInternalsHandler_CheckSystemPermissions_ResponseParams_Data::Validate},
    { &internal::BluetoothInternalsHandler_RequestSystemPermissions_Params_Data::Validate,
     &internal::BluetoothInternalsHandler_RequestSystemPermissions_ResponseParams_Data::Validate},
    { &internal::BluetoothInternalsHandler_RequestLocationServices_Params_Data::Validate,
     &internal::BluetoothInternalsHandler_RequestLocationServices_ResponseParams_Data::Validate},
    { &internal::BluetoothInternalsHandler_StartBtsnoop_Params_Data::Validate,
     &internal::BluetoothInternalsHandler_StartBtsnoop_ResponseParams_Data::Validate},
    { &internal::BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_Params_Data::Validate,
     &internal::BluetoothInternalsHandler_IsBtsnoopFeatureEnabled_ResponseParams_Data::Validate},
};

bool BluetoothInternalsHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::mojom::BluetoothInternalsHandler::Name_,
    kBluetoothInternalsHandlerValidationInfo);
}

bool BluetoothInternalsHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::mojom::BluetoothInternalsHandler::Name_,
    kBluetoothInternalsHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

BluetoothBtsnoop::IPCStableHashFunction BluetoothBtsnoop::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BluetoothBtsnoop>(message.name())) {
    case messages::BluetoothBtsnoop::kStop: {
      return &BluetoothBtsnoop::Stop_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BluetoothBtsnoop::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BluetoothBtsnoop>(message.name())) {
      case messages::BluetoothBtsnoop::kStop:
            return "Receive mojom::BluetoothBtsnoop::Stop";
    }
  } else {
    switch (static_cast<messages::BluetoothBtsnoop>(message.name())) {
      case messages::BluetoothBtsnoop::kStop:
            return "Receive reply mojom::BluetoothBtsnoop::Stop";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BluetoothBtsnoop::Stop_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x159bf345;  // IPCStableHash for mojom::BluetoothBtsnoop::Stop
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BluetoothBtsnoop_Stop_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BluetoothBtsnoop_Stop_ForwardToCallback(
      BluetoothBtsnoop::StopCallback callback
      ) : callback_(std::move(callback)) {
  }

  BluetoothBtsnoop_Stop_ForwardToCallback(const BluetoothBtsnoop_Stop_ForwardToCallback&) = delete;
  BluetoothBtsnoop_Stop_ForwardToCallback& operator=(const BluetoothBtsnoop_Stop_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BluetoothBtsnoop::StopCallback callback_;
};

BluetoothBtsnoopProxy::BluetoothBtsnoopProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BluetoothBtsnoopProxy::Stop(
    StopCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::BluetoothBtsnoop::Stop");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BluetoothBtsnoop::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::BluetoothBtsnoop_Stop_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BluetoothBtsnoop::Name_);
  message.set_method_name("Stop");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BluetoothBtsnoop_Stop_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BluetoothBtsnoop_Stop_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BluetoothBtsnoop::StopCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BluetoothBtsnoop_Stop_ProxyToResponder> proxy(
        new BluetoothBtsnoop_Stop_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BluetoothBtsnoop_Stop_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BluetoothBtsnoop_Stop_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BluetoothBtsnoop_Stop_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BluetoothBtsnoop::StopCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool BluetoothBtsnoop_Stop_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BluetoothBtsnoop_Stop_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BluetoothBtsnoop_Stop_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BluetoothBtsnoop.0
  bool success = true;
  bool p_success{};
  BluetoothBtsnoop_Stop_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BluetoothBtsnoop::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void BluetoothBtsnoop_Stop_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::BluetoothBtsnoop::Stop", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BluetoothBtsnoop::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::BluetoothBtsnoop_Stop_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BluetoothBtsnoop::Name_);
  message.set_method_name("Stop");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BluetoothBtsnoopStubDispatch::Accept(
    BluetoothBtsnoop* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BluetoothBtsnoop>(message->header()->name)) {
    case messages::BluetoothBtsnoop::kStop: {
      break;
    }
  }
  return false;
}

// static
bool BluetoothBtsnoopStubDispatch::AcceptWithResponder(
    BluetoothBtsnoop* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BluetoothBtsnoop>(message->header()->name)) {
    case messages::BluetoothBtsnoop::kStop: {
      internal::BluetoothBtsnoop_Stop_Params_Data* params =
          reinterpret_cast<
              internal::BluetoothBtsnoop_Stop_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BluetoothBtsnoop.0
      bool success = true;
      BluetoothBtsnoop_Stop_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BluetoothBtsnoop::Name_, 0, false);
        return false;
      }
      auto callback =
          BluetoothBtsnoop_Stop_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBluetoothBtsnoopValidationInfo[] = {
    { &internal::BluetoothBtsnoop_Stop_Params_Data::Validate,
     &internal::BluetoothBtsnoop_Stop_ResponseParams_Data::Validate},
};

bool BluetoothBtsnoopRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::mojom::BluetoothBtsnoop::Name_,
    kBluetoothBtsnoopValidationInfo);
}

bool BluetoothBtsnoopResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::mojom::BluetoothBtsnoop::Name_,
    kBluetoothBtsnoopValidationInfo);
}


}  // mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace mojom {


void DebugLogsChangeHandlerInterceptorForTesting::ChangeDebugLogsState(bool should_debug_logs_be_enabled) {
  GetForwardingInterface()->ChangeDebugLogsState(
    std::move(should_debug_logs_be_enabled)
    );
}
DebugLogsChangeHandlerAsyncWaiter::DebugLogsChangeHandlerAsyncWaiter(
    DebugLogsChangeHandler* proxy) : proxy_(proxy) {}

DebugLogsChangeHandlerAsyncWaiter::~DebugLogsChangeHandlerAsyncWaiter() = default;





void BluetoothInternalsHandlerInterceptorForTesting::GetAdapter(GetAdapterCallback callback) {
  GetForwardingInterface()->GetAdapter(std::move(callback));
}
void BluetoothInternalsHandlerInterceptorForTesting::GetDebugLogsChangeHandler(GetDebugLogsChangeHandlerCallback callback) {
  GetForwardingInterface()->GetDebugLogsChangeHandler(std::move(callback));
}
void BluetoothInternalsHandlerInterceptorForTesting::CheckSystemPermissions(CheckSystemPermissionsCallback callback) {
  GetForwardingInterface()->CheckSystemPermissions(std::move(callback));
}
void BluetoothInternalsHandlerInterceptorForTesting::RequestSystemPermissions(RequestSystemPermissionsCallback callback) {
  GetForwardingInterface()->RequestSystemPermissions(std::move(callback));
}
void BluetoothInternalsHandlerInterceptorForTesting::RequestLocationServices(RequestLocationServicesCallback callback) {
  GetForwardingInterface()->RequestLocationServices(std::move(callback));
}
void BluetoothInternalsHandlerInterceptorForTesting::StartBtsnoop(StartBtsnoopCallback callback) {
  GetForwardingInterface()->StartBtsnoop(std::move(callback));
}
void BluetoothInternalsHandlerInterceptorForTesting::IsBtsnoopFeatureEnabled(IsBtsnoopFeatureEnabledCallback callback) {
  GetForwardingInterface()->IsBtsnoopFeatureEnabled(std::move(callback));
}
BluetoothInternalsHandlerAsyncWaiter::BluetoothInternalsHandlerAsyncWaiter(
    BluetoothInternalsHandler* proxy) : proxy_(proxy) {}

BluetoothInternalsHandlerAsyncWaiter::~BluetoothInternalsHandlerAsyncWaiter() = default;


void BluetoothInternalsHandlerAsyncWaiter::GetAdapter(
    ::mojo::PendingRemote<::bluetooth::mojom::Adapter>* out_adapter) {
  base::RunLoop loop;
  proxy_->GetAdapter(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<::bluetooth::mojom::Adapter>* out_adapter
,
             ::mojo::PendingRemote<::bluetooth::mojom::Adapter> adapter) {*out_adapter = std::move(adapter);
            loop->Quit();
          },
          &loop,
          out_adapter));
  loop.Run();
}

::mojo::PendingRemote<::bluetooth::mojom::Adapter> BluetoothInternalsHandlerAsyncWaiter::GetAdapter(
    ) {
  ::mojo::PendingRemote<::bluetooth::mojom::Adapter> async_wait_result;
  GetAdapter(&async_wait_result);
  return async_wait_result;
}

void BluetoothInternalsHandlerAsyncWaiter::GetDebugLogsChangeHandler(
    ::mojo::PendingRemote<DebugLogsChangeHandler>* out_handler, bool* out_initial_toggle_value) {
  base::RunLoop loop;
  proxy_->GetDebugLogsChangeHandler(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<DebugLogsChangeHandler>* out_handler
,
             bool* out_initial_toggle_value
,
             ::mojo::PendingRemote<DebugLogsChangeHandler> handler,
             bool initial_toggle_value) {*out_handler = std::move(handler);*out_initial_toggle_value = std::move(initial_toggle_value);
            loop->Quit();
          },
          &loop,
          out_handler,
          out_initial_toggle_value));
  loop.Run();
}



void BluetoothInternalsHandlerAsyncWaiter::CheckSystemPermissions(
    bool* out_need_location_permission, bool* out_need_nearby_devices_permission, bool* out_need_location_services, bool* out_can_request_permissions) {
  base::RunLoop loop;
  proxy_->CheckSystemPermissions(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_need_location_permission
,
             bool* out_need_nearby_devices_permission
,
             bool* out_need_location_services
,
             bool* out_can_request_permissions
,
             bool need_location_permission,
             bool need_nearby_devices_permission,
             bool need_location_services,
             bool can_request_permissions) {*out_need_location_permission = std::move(need_location_permission);*out_need_nearby_devices_permission = std::move(need_nearby_devices_permission);*out_need_location_services = std::move(need_location_services);*out_can_request_permissions = std::move(can_request_permissions);
            loop->Quit();
          },
          &loop,
          out_need_location_permission,
          out_need_nearby_devices_permission,
          out_need_location_services,
          out_can_request_permissions));
  loop.Run();
}



void BluetoothInternalsHandlerAsyncWaiter::RequestSystemPermissions(
    ) {
  base::RunLoop loop;
  proxy_->RequestSystemPermissions(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void BluetoothInternalsHandlerAsyncWaiter::RequestLocationServices(
    ) {
  base::RunLoop loop;
  proxy_->RequestLocationServices(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void BluetoothInternalsHandlerAsyncWaiter::StartBtsnoop(
    ::mojo::PendingRemote<BluetoothBtsnoop>* out_btsnoop) {
  base::RunLoop loop;
  proxy_->StartBtsnoop(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<BluetoothBtsnoop>* out_btsnoop
,
             ::mojo::PendingRemote<BluetoothBtsnoop> btsnoop) {*out_btsnoop = std::move(btsnoop);
            loop->Quit();
          },
          &loop,
          out_btsnoop));
  loop.Run();
}

::mojo::PendingRemote<BluetoothBtsnoop> BluetoothInternalsHandlerAsyncWaiter::StartBtsnoop(
    ) {
  ::mojo::PendingRemote<BluetoothBtsnoop> async_wait_result;
  StartBtsnoop(&async_wait_result);
  return async_wait_result;
}

void BluetoothInternalsHandlerAsyncWaiter::IsBtsnoopFeatureEnabled(
    bool* out_enabled) {
  base::RunLoop loop;
  proxy_->IsBtsnoopFeatureEnabled(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_enabled
,
             bool enabled) {*out_enabled = std::move(enabled);
            loop->Quit();
          },
          &loop,
          out_enabled));
  loop.Run();
}

bool BluetoothInternalsHandlerAsyncWaiter::IsBtsnoopFeatureEnabled(
    ) {
  bool async_wait_result;
  IsBtsnoopFeatureEnabled(&async_wait_result);
  return async_wait_result;
}




void BluetoothBtsnoopInterceptorForTesting::Stop(StopCallback callback) {
  GetForwardingInterface()->Stop(std::move(callback));
}
BluetoothBtsnoopAsyncWaiter::BluetoothBtsnoopAsyncWaiter(
    BluetoothBtsnoop* proxy) : proxy_(proxy) {}

BluetoothBtsnoopAsyncWaiter::~BluetoothBtsnoopAsyncWaiter() = default;


void BluetoothBtsnoopAsyncWaiter::Stop(
    bool* out_success) {
  base::RunLoop loop;
  proxy_->Stop(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool BluetoothBtsnoopAsyncWaiter::Stop(
    ) {
  bool async_wait_result;
  Stop(&async_wait_result);
  return async_wait_result;
}






}  // mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif