// chrome/browser/ui/tabs/tab_strip_api/tab_strip_experiment_api.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_EXPERIMENT_API_MOJOM_H_
#define CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_EXPERIMENT_API_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_experiment_api.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_experiment_api.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_experiment_api.mojom-forward.h"  // IWYU pragma: export
#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_data_model.mojom.h"
#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_types.mojom.h"
#include "mojo/public/mojom/base/empty.mojom.h"
#include "mojo/public/mojom/base/error.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/types/expected.h"




namespace tabs_api::mojom {

class TabStripExperimentServiceProxy;

template <typename ImplRefTraits>
class TabStripExperimentServiceStub;

class TabStripExperimentServiceRequestValidator;
class TabStripExperimentServiceResponseValidator;


class TabStripExperimentService
    : public TabStripExperimentServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "tabs_api.mojom.TabStripExperimentService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = TabStripExperimentServiceInterfaceBase;
  using Proxy_ = TabStripExperimentServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = TabStripExperimentServiceStub<ImplRefTraits>;

  using RequestValidator_ = TabStripExperimentServiceRequestValidator;
  using ResponseValidator_ = TabStripExperimentServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kUpdateTabGroupVisualMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateTabGroupVisual_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~TabStripExperimentService() = default;

  using UpdateTabGroupVisualCallback = base::OnceCallback<void(base::expected<
  ::std::monostate,
  ::mojo_base::mojom::ErrorPtr>)>;
  using UpdateTabGroupVisualResult = base::expected<
  ::std::monostate,
  ::mojo_base::mojom::ErrorPtr>;
  using UpdateTabGroupVisualMojoCallback = base::OnceCallback<void(TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr)>;

  virtual void UpdateTabGroupVisual(const ::tabs_api::NodeId& id, const ::tab_groups::TabGroupVisualData& visual_data, UpdateTabGroupVisualCallback callback) = 0;
};



class  TabStripExperimentServiceProxy
    : public TabStripExperimentService {
 public:
  using InterfaceType = TabStripExperimentService;

  explicit TabStripExperimentServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateTabGroupVisual(const ::tabs_api::NodeId& id, const ::tab_groups::TabGroupVisualData& visual_data, UpdateTabGroupVisualCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  TabStripExperimentServiceStubDispatch {
 public:
  static bool Accept(TabStripExperimentService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TabStripExperimentService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TabStripExperimentService>>
class TabStripExperimentServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TabStripExperimentServiceStub() = default;
  ~TabStripExperimentServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TabStripExperimentServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TabStripExperimentServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TabStripExperimentServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TabStripExperimentServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result {
 public:
  using DataView = TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultDataView;
  using Data_ = internal::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result_Data;
  using Tag = Data_::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result_Tag;

  template <typename... Args>
  static TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |success|.
  static TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr NewSuccess(
      const ::std::monostate& value);
  // Construct an instance holding |failure|.
  static TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr NewFailure(
      ::mojo_base::mojom::ErrorPtr value);

  template <typename U>
  static TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr From(const U& u) {
    return mojo::TypeConverter<TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result>::Convert(*this);
  }
  ~TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result(const TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result& other) = delete;
  TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result& operator=(const TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr>
  TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const ::std::monostate& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  ::std::monostate& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(const ::std::monostate& success);

  bool is_failure() const { return tag_ == Tag::kFailure; }
  const ::mojo_base::mojom::ErrorPtr& get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  ::mojo_base::mojom::ErrorPtr& get_failure() {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(::mojo_base::mojom::ErrorPtr failure);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        const ::std::monostate& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        ::mojo_base::mojom::ErrorPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::std::monostate success;
    ::mojo_base::mojom::ErrorPtr failure;
  };

  TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      const ::std::monostate& value);
  TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      ::mojo_base::mojom::ErrorPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};

template <typename UnionPtrType>
TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::Clone() const {
  switch (tag_) {
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result>::value>::type*>
bool TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
  }

  return false;
}


}  // tabs_api::mojom

namespace mojo {


template <>
struct  UnionTraits<::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::DataView,
                                        ::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr> {
  static bool IsNull(const ::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr* output) { output->reset(); }

  static ::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::Tag GetTag(const ::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr& input) {
    return input->which();
  }

  static const ::std::monostate& success(const ::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr& input) {
    return input->get_success();
  }

  static const ::mojo_base::mojom::ErrorPtr& failure(const ::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr& input) {
    return input->get_failure();
  }

  static bool Read(::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_Result::DataView input, ::tabs_api::mojom::TabStripExperimentService_UpdateTabGroupVisual_ResponseParam_ResultPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_EXPERIMENT_API_MOJOM_H_