// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{NodeIdSpec as tabsApi_mojom_NodeIdSpec}from"./tab_strip_api_types.mojom-webui.js";import{UrlSpec as url_mojom_UrlSpec}from"//resources/mojo/url/mojom/url.mojom-webui.js";export const SecurityIconSpec={$:mojo.internal.Enum()};export var SecurityIcon;(function(SecurityIcon){SecurityIcon[SecurityIcon["MIN_VALUE"]=0]="MIN_VALUE";SecurityIcon[SecurityIcon["MAX_VALUE"]=8]="MAX_VALUE";SecurityIcon[SecurityIcon["HttpChromeRefresh"]=0]="HttpChromeRefresh";SecurityIcon[SecurityIcon["SecurePageInfoChromeRefresh"]=1]="SecurePageInfoChromeRefresh";SecurityIcon[SecurityIcon["NoEncryption"]=2]="NoEncryption";SecurityIcon[SecurityIcon["NotSecureWarningChromeRefresh"]=3]="NotSecureWarningChromeRefresh";SecurityIcon[SecurityIcon["BusinessChromeRefresh"]=4]="BusinessChromeRefresh";SecurityIcon[SecurityIcon["DangerousChromeRefresh"]=5]="DangerousChromeRefresh";SecurityIcon[SecurityIcon["ProductChromeRefresh"]=6]="ProductChromeRefresh";SecurityIcon[SecurityIcon["ExtensionChromeRefresh"]=7]="ExtensionChromeRefresh";SecurityIcon[SecurityIcon["OfflinePin"]=8]="OfflinePin"})(SecurityIcon||(SecurityIcon={}));export class PageHandlerFactoryPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"webui_browser.mojom.PageHandlerFactory",scope)}}export class PageHandlerFactoryRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}createPageHandler(page,handler){this.proxy.sendMessage(0,PageHandlerFactory_CreatePageHandler_ParamsSpec.$,null,[page,handler],false)}}export class PageHandlerFactoryReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,PageHandlerFactory_CreatePageHandler_ParamsSpec.$,null,impl.createPageHandler.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class PageHandlerFactory{static get $interfaceName(){return"webui_browser.mojom.PageHandlerFactory"}static getRemote(){let remote=new PageHandlerFactoryRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PageHandlerFactoryCallbackRouter{helper_internal_;$;router_;createPageHandler;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.createPageHandler=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PageHandlerFactory_CreatePageHandler_ParamsSpec.$,null,this.createPageHandler.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class PagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"webui_browser.mojom.Page",scope)}}export class PageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}setFocusToLocationBar(isUserInitiated){this.proxy.sendMessage(0,Page_SetFocusToLocationBar_ParamsSpec.$,null,[isUserInitiated],false)}setReloadStopState(isLoading){this.proxy.sendMessage(1,Page_SetReloadStopState_ParamsSpec.$,null,[isLoading],false)}showSidePanel(guestContentsId,title){this.proxy.sendMessage(2,Page_ShowSidePanel_ParamsSpec.$,null,[guestContentsId,title],false)}closeSidePanel(){this.proxy.sendMessage(3,Page_CloseSidePanel_ParamsSpec.$,null,[],false)}}export class PageReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,Page_SetFocusToLocationBar_ParamsSpec.$,null,impl.setFocusToLocationBar.bind(impl),false);this.helper_internal_.registerHandler(1,Page_SetReloadStopState_ParamsSpec.$,null,impl.setReloadStopState.bind(impl),false);this.helper_internal_.registerHandler(2,Page_ShowSidePanel_ParamsSpec.$,null,impl.showSidePanel.bind(impl),false);this.helper_internal_.registerHandler(3,Page_CloseSidePanel_ParamsSpec.$,null,impl.closeSidePanel.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class Page{static get $interfaceName(){return"webui_browser.mojom.Page"}static getRemote(){let remote=new PageRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PageCallbackRouter{helper_internal_;$;router_;setFocusToLocationBar;setReloadStopState;showSidePanel;closeSidePanel;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.setFocusToLocationBar=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,Page_SetFocusToLocationBar_ParamsSpec.$,null,this.setFocusToLocationBar.createReceiverHandler(false),false);this.setReloadStopState=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,Page_SetReloadStopState_ParamsSpec.$,null,this.setReloadStopState.createReceiverHandler(false),false);this.showSidePanel=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,Page_ShowSidePanel_ParamsSpec.$,null,this.showSidePanel.createReceiverHandler(false),false);this.closeSidePanel=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,Page_CloseSidePanel_ParamsSpec.$,null,this.closeSidePanel.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class PageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"webui_browser.mojom.PageHandler",scope)}}export class PageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}getGuestIdForTabId(tabId,handler){return this.proxy.sendMessage(0,PageHandler_GetGuestIdForTabId_ParamsSpec.$,PageHandler_GetGuestIdForTabId_ResponseParamsSpec.$,[tabId,handler],false)}loadTabSearch(){return this.proxy.sendMessage(1,PageHandler_LoadTabSearch_ParamsSpec.$,PageHandler_LoadTabSearch_ResponseParamsSpec.$,[],false)}showTabSearchBubble(anchorName){this.proxy.sendMessage(2,PageHandler_ShowTabSearchBubble_ParamsSpec.$,null,[anchorName],false)}openAppMenu(){this.proxy.sendMessage(3,PageHandler_OpenAppMenu_ParamsSpec.$,null,[],false)}openProfileMenu(){this.proxy.sendMessage(4,PageHandler_OpenProfileMenu_ParamsSpec.$,null,[],false)}launchDevToolsForBrowser(){this.proxy.sendMessage(5,PageHandler_LaunchDevToolsForBrowser_ParamsSpec.$,null,[],false)}onSidePanelClosed(){this.proxy.sendMessage(6,PageHandler_OnSidePanelClosed_ParamsSpec.$,null,[],false)}minimize(){this.proxy.sendMessage(7,PageHandler_Minimize_ParamsSpec.$,null,[],false)}maximize(){this.proxy.sendMessage(8,PageHandler_Maximize_ParamsSpec.$,null,[],false)}restore(){this.proxy.sendMessage(9,PageHandler_Restore_ParamsSpec.$,null,[],false)}close(){this.proxy.sendMessage(10,PageHandler_Close_ParamsSpec.$,null,[],false)}}export class PageHandlerReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,PageHandler_GetGuestIdForTabId_ParamsSpec.$,PageHandler_GetGuestIdForTabId_ResponseParamsSpec.$,impl.getGuestIdForTabId.bind(impl),false);this.helper_internal_.registerHandler(1,PageHandler_LoadTabSearch_ParamsSpec.$,PageHandler_LoadTabSearch_ResponseParamsSpec.$,impl.loadTabSearch.bind(impl),false);this.helper_internal_.registerHandler(2,PageHandler_ShowTabSearchBubble_ParamsSpec.$,null,impl.showTabSearchBubble.bind(impl),false);this.helper_internal_.registerHandler(3,PageHandler_OpenAppMenu_ParamsSpec.$,null,impl.openAppMenu.bind(impl),false);this.helper_internal_.registerHandler(4,PageHandler_OpenProfileMenu_ParamsSpec.$,null,impl.openProfileMenu.bind(impl),false);this.helper_internal_.registerHandler(5,PageHandler_LaunchDevToolsForBrowser_ParamsSpec.$,null,impl.launchDevToolsForBrowser.bind(impl),false);this.helper_internal_.registerHandler(6,PageHandler_OnSidePanelClosed_ParamsSpec.$,null,impl.onSidePanelClosed.bind(impl),false);this.helper_internal_.registerHandler(7,PageHandler_Minimize_ParamsSpec.$,null,impl.minimize.bind(impl),false);this.helper_internal_.registerHandler(8,PageHandler_Maximize_ParamsSpec.$,null,impl.maximize.bind(impl),false);this.helper_internal_.registerHandler(9,PageHandler_Restore_ParamsSpec.$,null,impl.restore.bind(impl),false);this.helper_internal_.registerHandler(10,PageHandler_Close_ParamsSpec.$,null,impl.close.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class PageHandler{static get $interfaceName(){return"webui_browser.mojom.PageHandler"}static getRemote(){let remote=new PageHandlerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class PageHandlerCallbackRouter{helper_internal_;$;router_;getGuestIdForTabId;loadTabSearch;showTabSearchBubble;openAppMenu;openProfileMenu;launchDevToolsForBrowser;onSidePanelClosed;minimize;maximize;restore;close;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.getGuestIdForTabId=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,PageHandler_GetGuestIdForTabId_ParamsSpec.$,PageHandler_GetGuestIdForTabId_ResponseParamsSpec.$,this.getGuestIdForTabId.createReceiverHandler(true),false);this.loadTabSearch=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,PageHandler_LoadTabSearch_ParamsSpec.$,PageHandler_LoadTabSearch_ResponseParamsSpec.$,this.loadTabSearch.createReceiverHandler(true),false);this.showTabSearchBubble=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,PageHandler_ShowTabSearchBubble_ParamsSpec.$,null,this.showTabSearchBubble.createReceiverHandler(false),false);this.openAppMenu=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,PageHandler_OpenAppMenu_ParamsSpec.$,null,this.openAppMenu.createReceiverHandler(false),false);this.openProfileMenu=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,PageHandler_OpenProfileMenu_ParamsSpec.$,null,this.openProfileMenu.createReceiverHandler(false),false);this.launchDevToolsForBrowser=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,PageHandler_LaunchDevToolsForBrowser_ParamsSpec.$,null,this.launchDevToolsForBrowser.createReceiverHandler(false),false);this.onSidePanelClosed=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,PageHandler_OnSidePanelClosed_ParamsSpec.$,null,this.onSidePanelClosed.createReceiverHandler(false),false);this.minimize=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,PageHandler_Minimize_ParamsSpec.$,null,this.minimize.createReceiverHandler(false),false);this.maximize=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,PageHandler_Maximize_ParamsSpec.$,null,this.maximize.createReceiverHandler(false),false);this.restore=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(9,PageHandler_Restore_ParamsSpec.$,null,this.restore.createReceiverHandler(false),false);this.close=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(10,PageHandler_Close_ParamsSpec.$,null,this.close.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class GuestHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"webui_browser.mojom.GuestHandler",scope)}}export class GuestHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(GuestHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}navigate(src){this.proxy.sendMessage(0,GuestHandler_Navigate_ParamsSpec.$,null,[src],false)}canGoBack(){return this.proxy.sendMessage(1,GuestHandler_CanGoBack_ParamsSpec.$,GuestHandler_CanGoBack_ResponseParamsSpec.$,[],false)}goBack(){this.proxy.sendMessage(2,GuestHandler_GoBack_ParamsSpec.$,null,[],false)}canGoForward(){return this.proxy.sendMessage(3,GuestHandler_CanGoForward_ParamsSpec.$,GuestHandler_CanGoForward_ResponseParamsSpec.$,[],false)}goForward(){this.proxy.sendMessage(4,GuestHandler_GoForward_ParamsSpec.$,null,[],false)}reload(){this.proxy.sendMessage(5,GuestHandler_Reload_ParamsSpec.$,null,[],false)}stopLoading(){this.proxy.sendMessage(6,GuestHandler_StopLoading_ParamsSpec.$,null,[],false)}openPageInfoMenu(){this.proxy.sendMessage(7,GuestHandler_OpenPageInfoMenu_ParamsSpec.$,null,[],false)}getSecurityIcon(){return this.proxy.sendMessage(8,GuestHandler_GetSecurityIcon_ParamsSpec.$,GuestHandler_GetSecurityIcon_ResponseParamsSpec.$,[],false)}}export class GuestHandlerReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(GuestHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,GuestHandler_Navigate_ParamsSpec.$,null,impl.navigate.bind(impl),false);this.helper_internal_.registerHandler(1,GuestHandler_CanGoBack_ParamsSpec.$,GuestHandler_CanGoBack_ResponseParamsSpec.$,impl.canGoBack.bind(impl),false);this.helper_internal_.registerHandler(2,GuestHandler_GoBack_ParamsSpec.$,null,impl.goBack.bind(impl),false);this.helper_internal_.registerHandler(3,GuestHandler_CanGoForward_ParamsSpec.$,GuestHandler_CanGoForward_ResponseParamsSpec.$,impl.canGoForward.bind(impl),false);this.helper_internal_.registerHandler(4,GuestHandler_GoForward_ParamsSpec.$,null,impl.goForward.bind(impl),false);this.helper_internal_.registerHandler(5,GuestHandler_Reload_ParamsSpec.$,null,impl.reload.bind(impl),false);this.helper_internal_.registerHandler(6,GuestHandler_StopLoading_ParamsSpec.$,null,impl.stopLoading.bind(impl),false);this.helper_internal_.registerHandler(7,GuestHandler_OpenPageInfoMenu_ParamsSpec.$,null,impl.openPageInfoMenu.bind(impl),false);this.helper_internal_.registerHandler(8,GuestHandler_GetSecurityIcon_ParamsSpec.$,GuestHandler_GetSecurityIcon_ResponseParamsSpec.$,impl.getSecurityIcon.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class GuestHandler{static get $interfaceName(){return"webui_browser.mojom.GuestHandler"}static getRemote(){let remote=new GuestHandlerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class GuestHandlerCallbackRouter{helper_internal_;$;router_;navigate;canGoBack;goBack;canGoForward;goForward;reload;stopLoading;openPageInfoMenu;getSecurityIcon;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(GuestHandlerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.navigate=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,GuestHandler_Navigate_ParamsSpec.$,null,this.navigate.createReceiverHandler(false),false);this.canGoBack=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,GuestHandler_CanGoBack_ParamsSpec.$,GuestHandler_CanGoBack_ResponseParamsSpec.$,this.canGoBack.createReceiverHandler(true),false);this.goBack=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,GuestHandler_GoBack_ParamsSpec.$,null,this.goBack.createReceiverHandler(false),false);this.canGoForward=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,GuestHandler_CanGoForward_ParamsSpec.$,GuestHandler_CanGoForward_ResponseParamsSpec.$,this.canGoForward.createReceiverHandler(true),false);this.goForward=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,GuestHandler_GoForward_ParamsSpec.$,null,this.goForward.createReceiverHandler(false),false);this.reload=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,GuestHandler_Reload_ParamsSpec.$,null,this.reload.createReceiverHandler(false),false);this.stopLoading=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,GuestHandler_StopLoading_ParamsSpec.$,null,this.stopLoading.createReceiverHandler(false),false);this.openPageInfoMenu=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,GuestHandler_OpenPageInfoMenu_ParamsSpec.$,null,this.openPageInfoMenu.createReceiverHandler(false),false);this.getSecurityIcon=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,GuestHandler_GetSecurityIcon_ParamsSpec.$,GuestHandler_GetSecurityIcon_ResponseParamsSpec.$,this.getSecurityIcon.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const PageHandlerFactory_CreatePageHandler_ParamsSpec={$:{}};export const Page_SetFocusToLocationBar_ParamsSpec={$:{}};export const Page_SetReloadStopState_ParamsSpec={$:{}};export const Page_ShowSidePanel_ParamsSpec={$:{}};export const Page_CloseSidePanel_ParamsSpec={$:{}};export const PageHandler_GetGuestIdForTabId_ParamsSpec={$:{}};export const PageHandler_GetGuestIdForTabId_ResponseParamsSpec={$:{}};export const PageHandler_LoadTabSearch_ParamsSpec={$:{}};export const PageHandler_LoadTabSearch_ResponseParamsSpec={$:{}};export const PageHandler_ShowTabSearchBubble_ParamsSpec={$:{}};export const PageHandler_OpenAppMenu_ParamsSpec={$:{}};export const PageHandler_OpenProfileMenu_ParamsSpec={$:{}};export const PageHandler_LaunchDevToolsForBrowser_ParamsSpec={$:{}};export const PageHandler_OnSidePanelClosed_ParamsSpec={$:{}};export const PageHandler_Minimize_ParamsSpec={$:{}};export const PageHandler_Maximize_ParamsSpec={$:{}};export const PageHandler_Restore_ParamsSpec={$:{}};export const PageHandler_Close_ParamsSpec={$:{}};export const GuestHandler_Navigate_ParamsSpec={$:{}};export const GuestHandler_CanGoBack_ParamsSpec={$:{}};export const GuestHandler_CanGoBack_ResponseParamsSpec={$:{}};export const GuestHandler_GoBack_ParamsSpec={$:{}};export const GuestHandler_CanGoForward_ParamsSpec={$:{}};export const GuestHandler_CanGoForward_ResponseParamsSpec={$:{}};export const GuestHandler_GoForward_ParamsSpec={$:{}};export const GuestHandler_Reload_ParamsSpec={$:{}};export const GuestHandler_StopLoading_ParamsSpec={$:{}};export const GuestHandler_OpenPageInfoMenu_ParamsSpec={$:{}};export const GuestHandler_GetSecurityIcon_ParamsSpec={$:{}};export const GuestHandler_GetSecurityIcon_ResponseParamsSpec={$:{}};mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$,"PageHandlerFactory_CreatePageHandler_Params",[mojo.internal.StructField("page",0,0,mojo.internal.InterfaceProxy(PageRemote),null,false,0,undefined,undefined),mojo.internal.StructField("handler",8,0,mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(Page_SetFocusToLocationBar_ParamsSpec.$,"Page_SetFocusToLocationBar_Params",[mojo.internal.StructField("isUserInitiated",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_SetReloadStopState_ParamsSpec.$,"Page_SetReloadStopState_Params",[mojo.internal.StructField("isLoading",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_ShowSidePanel_ParamsSpec.$,"Page_ShowSidePanel_Params",[mojo.internal.StructField("guestContentsId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("title",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(Page_CloseSidePanel_ParamsSpec.$,"Page_CloseSidePanel_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetGuestIdForTabId_ParamsSpec.$,"PageHandler_GetGuestIdForTabId_Params",[mojo.internal.StructField("tabId",0,0,tabsApi_mojom_NodeIdSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("handler",8,0,mojo.internal.InterfaceRequest(GuestHandlerPendingReceiver),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_GetGuestIdForTabId_ResponseParamsSpec.$,"PageHandler_GetGuestIdForTabId_ResponseParams",[mojo.internal.StructField("guestId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_LoadTabSearch_ParamsSpec.$,"PageHandler_LoadTabSearch_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_LoadTabSearch_ResponseParamsSpec.$,"PageHandler_LoadTabSearch_ResponseParams",[mojo.internal.StructField("guestId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ShowTabSearchBubble_ParamsSpec.$,"PageHandler_ShowTabSearchBubble_Params",[mojo.internal.StructField("anchorName",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_OpenAppMenu_ParamsSpec.$,"PageHandler_OpenAppMenu_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_OpenProfileMenu_ParamsSpec.$,"PageHandler_OpenProfileMenu_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_LaunchDevToolsForBrowser_ParamsSpec.$,"PageHandler_LaunchDevToolsForBrowser_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_OnSidePanelClosed_ParamsSpec.$,"PageHandler_OnSidePanelClosed_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_Minimize_ParamsSpec.$,"PageHandler_Minimize_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_Maximize_ParamsSpec.$,"PageHandler_Maximize_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_Restore_ParamsSpec.$,"PageHandler_Restore_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_Close_ParamsSpec.$,"PageHandler_Close_Params",[],[[0,8]]);mojo.internal.Struct(GuestHandler_Navigate_ParamsSpec.$,"GuestHandler_Navigate_Params",[mojo.internal.StructField("src",0,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(GuestHandler_CanGoBack_ParamsSpec.$,"GuestHandler_CanGoBack_Params",[],[[0,8]]);mojo.internal.Struct(GuestHandler_CanGoBack_ResponseParamsSpec.$,"GuestHandler_CanGoBack_ResponseParams",[mojo.internal.StructField("canGoBack",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(GuestHandler_GoBack_ParamsSpec.$,"GuestHandler_GoBack_Params",[],[[0,8]]);mojo.internal.Struct(GuestHandler_CanGoForward_ParamsSpec.$,"GuestHandler_CanGoForward_Params",[],[[0,8]]);mojo.internal.Struct(GuestHandler_CanGoForward_ResponseParamsSpec.$,"GuestHandler_CanGoForward_ResponseParams",[mojo.internal.StructField("canGoForward",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(GuestHandler_GoForward_ParamsSpec.$,"GuestHandler_GoForward_Params",[],[[0,8]]);mojo.internal.Struct(GuestHandler_Reload_ParamsSpec.$,"GuestHandler_Reload_Params",[],[[0,8]]);mojo.internal.Struct(GuestHandler_StopLoading_ParamsSpec.$,"GuestHandler_StopLoading_Params",[],[[0,8]]);mojo.internal.Struct(GuestHandler_OpenPageInfoMenu_ParamsSpec.$,"GuestHandler_OpenPageInfoMenu_Params",[],[[0,8]]);mojo.internal.Struct(GuestHandler_GetSecurityIcon_ParamsSpec.$,"GuestHandler_GetSecurityIcon_Params",[],[[0,8]]);mojo.internal.Struct(GuestHandler_GetSecurityIcon_ResponseParamsSpec.$,"GuestHandler_GetSecurityIcon_ResponseParams",[mojo.internal.StructField("securityIcon",0,0,SecurityIconSpec.$,0,false,0,undefined,undefined)],[[0,16]]);