// chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { FilePathSpec as mojoBase_mojom_FilePathSpec } from '//resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js';
import { OriginSpec as url_mojom_OriginSpec } from '//resources/mojo/url/mojom/origin.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export class WebAppInternalsHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'mojom.WebAppInternalsHandler', scope);
    }
}
export class WebAppInternalsHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(WebAppInternalsHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getDebugInfoAsJsonString() {
        return this.proxy.sendMessage(0, WebAppInternalsHandler_GetDebugInfoAsJsonString_ParamsSpec.$, WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParamsSpec.$, [], false);
    }
    installIsolatedWebAppFromDevProxy(url) {
        return this.proxy.sendMessage(1, WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ParamsSpec.$, WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParamsSpec.$, [
            url
        ], false);
    }
    selectFileAndInstallIsolatedWebAppFromDevBundle() {
        return this.proxy.sendMessage(2, WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ParamsSpec.$, WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParamsSpec.$, [], false);
    }
    parseUpdateManifestFromUrl(updateManifestUrl) {
        return this.proxy.sendMessage(3, WebAppInternalsHandler_ParseUpdateManifestFromUrl_ParamsSpec.$, WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParamsSpec.$, [
            updateManifestUrl
        ], false);
    }
    installIsolatedWebAppFromBundleUrl(params) {
        return this.proxy.sendMessage(4, WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ParamsSpec.$, WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParamsSpec.$, [
            params
        ], false);
    }
    updateDevProxyIsolatedWebApp(appId) {
        return this.proxy.sendMessage(5, WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ParamsSpec.$, WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParamsSpec.$, [
            appId
        ], false);
    }
    selectFileAndUpdateIsolatedWebAppFromDevBundle(appId) {
        return this.proxy.sendMessage(6, WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ParamsSpec.$, WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParamsSpec.$, [
            appId
        ], false);
    }
    updateManifestInstalledIsolatedWebApp(appId) {
        return this.proxy.sendMessage(7, WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ParamsSpec.$, WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParamsSpec.$, [
            appId
        ], false);
    }
    setUpdateChannelForIsolatedWebApp(appId, updateChannel) {
        return this.proxy.sendMessage(8, WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ParamsSpec.$, WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParamsSpec.$, [
            appId,
            updateChannel
        ], false);
    }
    setPinnedVersionForIsolatedWebApp(appId, pinnedVersion) {
        return this.proxy.sendMessage(9, WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ParamsSpec.$, WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParamsSpec.$, [
            appId,
            pinnedVersion
        ], false);
    }
    resetPinnedVersionForIsolatedWebApp(appId) {
        this.proxy.sendMessage(10, WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_ParamsSpec.$, null, [
            appId
        ], false);
    }
    setAllowDowngradesForIsolatedWebApp(allowDowngrades, appId) {
        this.proxy.sendMessage(11, WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_ParamsSpec.$, null, [
            allowDowngrades,
            appId
        ], false);
    }
    searchForIsolatedWebAppUpdates() {
        return this.proxy.sendMessage(12, WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ParamsSpec.$, WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParamsSpec.$, [], false);
    }
    getIsolatedWebAppDevModeAppInfo() {
        return this.proxy.sendMessage(13, WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ParamsSpec.$, WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParamsSpec.$, [], false);
    }
    rotateKey(webBundleId, rotatedKey) {
        this.proxy.sendMessage(14, WebAppInternalsHandler_RotateKey_ParamsSpec.$, null, [
            webBundleId,
            rotatedKey
        ], false);
    }
}
;
/**
 * An object which receives request messages for the WebAppInternalsHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebAppInternalsHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WebAppInternalsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, WebAppInternalsHandler_GetDebugInfoAsJsonString_ParamsSpec.$, WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParamsSpec.$, impl.getDebugInfoAsJsonString.bind(impl), false);
        this.helper_internal_.registerHandler(1, WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ParamsSpec.$, WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParamsSpec.$, impl.installIsolatedWebAppFromDevProxy.bind(impl), false);
        this.helper_internal_.registerHandler(2, WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ParamsSpec.$, WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParamsSpec.$, impl.selectFileAndInstallIsolatedWebAppFromDevBundle.bind(impl), false);
        this.helper_internal_.registerHandler(3, WebAppInternalsHandler_ParseUpdateManifestFromUrl_ParamsSpec.$, WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParamsSpec.$, impl.parseUpdateManifestFromUrl.bind(impl), false);
        this.helper_internal_.registerHandler(4, WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ParamsSpec.$, WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParamsSpec.$, impl.installIsolatedWebAppFromBundleUrl.bind(impl), false);
        this.helper_internal_.registerHandler(5, WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ParamsSpec.$, WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParamsSpec.$, impl.updateDevProxyIsolatedWebApp.bind(impl), false);
        this.helper_internal_.registerHandler(6, WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ParamsSpec.$, WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParamsSpec.$, impl.selectFileAndUpdateIsolatedWebAppFromDevBundle.bind(impl), false);
        this.helper_internal_.registerHandler(7, WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ParamsSpec.$, WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParamsSpec.$, impl.updateManifestInstalledIsolatedWebApp.bind(impl), false);
        this.helper_internal_.registerHandler(8, WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ParamsSpec.$, WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParamsSpec.$, impl.setUpdateChannelForIsolatedWebApp.bind(impl), false);
        this.helper_internal_.registerHandler(9, WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ParamsSpec.$, WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParamsSpec.$, impl.setPinnedVersionForIsolatedWebApp.bind(impl), false);
        this.helper_internal_.registerHandler(10, WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_ParamsSpec.$, null, impl.resetPinnedVersionForIsolatedWebApp.bind(impl), false);
        this.helper_internal_.registerHandler(11, WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_ParamsSpec.$, null, impl.setAllowDowngradesForIsolatedWebApp.bind(impl), false);
        this.helper_internal_.registerHandler(12, WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ParamsSpec.$, WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParamsSpec.$, impl.searchForIsolatedWebAppUpdates.bind(impl), false);
        this.helper_internal_.registerHandler(13, WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ParamsSpec.$, WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParamsSpec.$, impl.getIsolatedWebAppDevModeAppInfo.bind(impl), false);
        this.helper_internal_.registerHandler(14, WebAppInternalsHandler_RotateKey_ParamsSpec.$, null, impl.rotateKey.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class WebAppInternalsHandler {
    static get $interfaceName() {
        return "mojom.WebAppInternalsHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new WebAppInternalsHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the WebAppInternalsHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebAppInternalsHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    getDebugInfoAsJsonString;
    installIsolatedWebAppFromDevProxy;
    selectFileAndInstallIsolatedWebAppFromDevBundle;
    parseUpdateManifestFromUrl;
    installIsolatedWebAppFromBundleUrl;
    updateDevProxyIsolatedWebApp;
    selectFileAndUpdateIsolatedWebAppFromDevBundle;
    updateManifestInstalledIsolatedWebApp;
    setUpdateChannelForIsolatedWebApp;
    setPinnedVersionForIsolatedWebApp;
    resetPinnedVersionForIsolatedWebApp;
    setAllowDowngradesForIsolatedWebApp;
    searchForIsolatedWebAppUpdates;
    getIsolatedWebAppDevModeAppInfo;
    rotateKey;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WebAppInternalsHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getDebugInfoAsJsonString =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, WebAppInternalsHandler_GetDebugInfoAsJsonString_ParamsSpec.$, WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParamsSpec.$, this.getDebugInfoAsJsonString.createReceiverHandler(true /* expectsResponse */), false);
        this.installIsolatedWebAppFromDevProxy =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ParamsSpec.$, WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParamsSpec.$, this.installIsolatedWebAppFromDevProxy.createReceiverHandler(true /* expectsResponse */), false);
        this.selectFileAndInstallIsolatedWebAppFromDevBundle =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ParamsSpec.$, WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParamsSpec.$, this.selectFileAndInstallIsolatedWebAppFromDevBundle.createReceiverHandler(true /* expectsResponse */), false);
        this.parseUpdateManifestFromUrl =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, WebAppInternalsHandler_ParseUpdateManifestFromUrl_ParamsSpec.$, WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParamsSpec.$, this.parseUpdateManifestFromUrl.createReceiverHandler(true /* expectsResponse */), false);
        this.installIsolatedWebAppFromBundleUrl =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ParamsSpec.$, WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParamsSpec.$, this.installIsolatedWebAppFromBundleUrl.createReceiverHandler(true /* expectsResponse */), false);
        this.updateDevProxyIsolatedWebApp =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ParamsSpec.$, WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParamsSpec.$, this.updateDevProxyIsolatedWebApp.createReceiverHandler(true /* expectsResponse */), false);
        this.selectFileAndUpdateIsolatedWebAppFromDevBundle =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ParamsSpec.$, WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParamsSpec.$, this.selectFileAndUpdateIsolatedWebAppFromDevBundle.createReceiverHandler(true /* expectsResponse */), false);
        this.updateManifestInstalledIsolatedWebApp =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ParamsSpec.$, WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParamsSpec.$, this.updateManifestInstalledIsolatedWebApp.createReceiverHandler(true /* expectsResponse */), false);
        this.setUpdateChannelForIsolatedWebApp =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ParamsSpec.$, WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParamsSpec.$, this.setUpdateChannelForIsolatedWebApp.createReceiverHandler(true /* expectsResponse */), false);
        this.setPinnedVersionForIsolatedWebApp =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ParamsSpec.$, WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParamsSpec.$, this.setPinnedVersionForIsolatedWebApp.createReceiverHandler(true /* expectsResponse */), false);
        this.resetPinnedVersionForIsolatedWebApp =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_ParamsSpec.$, null, this.resetPinnedVersionForIsolatedWebApp.createReceiverHandler(false /* expectsResponse */), false);
        this.setAllowDowngradesForIsolatedWebApp =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_ParamsSpec.$, null, this.setAllowDowngradesForIsolatedWebApp.createReceiverHandler(false /* expectsResponse */), false);
        this.searchForIsolatedWebAppUpdates =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ParamsSpec.$, WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParamsSpec.$, this.searchForIsolatedWebAppUpdates.createReceiverHandler(true /* expectsResponse */), false);
        this.getIsolatedWebAppDevModeAppInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ParamsSpec.$, WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParamsSpec.$, this.getIsolatedWebAppDevModeAppInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.rotateKey =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, WebAppInternalsHandler_RotateKey_ParamsSpec.$, null, this.rotateKey.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const InstallIsolatedWebAppSuccessSpec = { $: {} };
export const UpdateInfoSpec = { $: {} };
export const IwaDevModeAppInfoSpec = { $: {} };
export const VersionEntrySpec = { $: {} };
export const UpdateManifestSpec = { $: {} };
export const InstallFromBundleUrlParamsSpec = { $: {} };
export const WebAppInternalsHandler_GetDebugInfoAsJsonString_ParamsSpec = { $: {} };
export const WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParamsSpec = { $: {} };
export const WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ParamsSpec = { $: {} };
export const WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParamsSpec = { $: {} };
export const WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ParamsSpec = { $: {} };
export const WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParamsSpec = { $: {} };
export const WebAppInternalsHandler_ParseUpdateManifestFromUrl_ParamsSpec = { $: {} };
export const WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParamsSpec = { $: {} };
export const WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ParamsSpec = { $: {} };
export const WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParamsSpec = { $: {} };
export const WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ParamsSpec = { $: {} };
export const WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParamsSpec = { $: {} };
export const WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ParamsSpec = { $: {} };
export const WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParamsSpec = { $: {} };
export const WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ParamsSpec = { $: {} };
export const WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParamsSpec = { $: {} };
export const WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ParamsSpec = { $: {} };
export const WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParamsSpec = { $: {} };
export const WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ParamsSpec = { $: {} };
export const WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParamsSpec = { $: {} };
export const WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_ParamsSpec = { $: {} };
export const WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_ParamsSpec = { $: {} };
export const WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ParamsSpec = { $: {} };
export const WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParamsSpec = { $: {} };
export const WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ParamsSpec = { $: {} };
export const WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParamsSpec = { $: {} };
export const WebAppInternalsHandler_RotateKey_ParamsSpec = { $: {} };
export const InstallIsolatedWebAppResultSpec = { $: {} };
export const IwaDevModeLocationSpec = { $: {} };
export const ParseUpdateManifestFromUrlResultSpec = { $: {} };
mojo.internal.Struct(InstallIsolatedWebAppSuccessSpec.$, 'InstallIsolatedWebAppSuccess', [
    mojo.internal.StructField('webBundleId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UpdateInfoSpec.$, 'UpdateInfo', [
    mojo.internal.StructField('updateManifestUrl', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('updateChannel', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pinnedVersion', 16, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('allowDowngrades', 24, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(IwaDevModeAppInfoSpec.$, 'IwaDevModeAppInfo', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('location', 16, 0, IwaDevModeLocationSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('installedVersion', 32, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('updateInfo', 40, 0, UpdateInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(VersionEntrySpec.$, 'VersionEntry', [
    mojo.internal.StructField('version', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('webBundleUrl', 8, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(UpdateManifestSpec.$, 'UpdateManifest', [
    mojo.internal.StructField('versions', 0, 0, mojo.internal.Array(VersionEntrySpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InstallFromBundleUrlParamsSpec.$, 'InstallFromBundleUrlParams', [
    mojo.internal.StructField('webBundleUrl', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('updateInfo', 8, 0, UpdateInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebAppInternalsHandler_GetDebugInfoAsJsonString_ParamsSpec.$, 'WebAppInternalsHandler_GetDebugInfoAsJsonString_Params', [], [[0, 8],]);
mojo.internal.Struct(WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParamsSpec.$, 'WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ParamsSpec.$, 'WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_Params', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParamsSpec.$, 'WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, InstallIsolatedWebAppResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ParamsSpec.$, 'WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_Params', [], [[0, 8],]);
mojo.internal.Struct(WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParamsSpec.$, 'WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, InstallIsolatedWebAppResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebAppInternalsHandler_ParseUpdateManifestFromUrl_ParamsSpec.$, 'WebAppInternalsHandler_ParseUpdateManifestFromUrl_Params', [
    mojo.internal.StructField('updateManifestUrl', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParamsSpec.$, 'WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, ParseUpdateManifestFromUrlResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ParamsSpec.$, 'WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_Params', [
    mojo.internal.StructField('params', 0, 0, InstallFromBundleUrlParamsSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParamsSpec.$, 'WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, InstallIsolatedWebAppResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ParamsSpec.$, 'WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParamsSpec.$, 'WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ParamsSpec.$, 'WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParamsSpec.$, 'WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ParamsSpec.$, 'WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParamsSpec.$, 'WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ParamsSpec.$, 'WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('updateChannel', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParamsSpec.$, 'WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ParamsSpec.$, 'WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pinnedVersion', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParamsSpec.$, 'WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_ParamsSpec.$, 'WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_Params', [
    mojo.internal.StructField('appId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_ParamsSpec.$, 'WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_Params', [
    mojo.internal.StructField('allowDowngrades', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('appId', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ParamsSpec.$, 'WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_Params', [], [[0, 8],]);
mojo.internal.Struct(WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParamsSpec.$, 'WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ParamsSpec.$, 'WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParamsSpec.$, 'WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParams', [
    mojo.internal.StructField('apps', 0, 0, mojo.internal.Array(IwaDevModeAppInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WebAppInternalsHandler_RotateKey_ParamsSpec.$, 'WebAppInternalsHandler_RotateKey_Params', [
    mojo.internal.StructField('webBundleId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('rotatedKey', 8, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Union(InstallIsolatedWebAppResultSpec.$, 'InstallIsolatedWebAppResult', {
    'success': {
        'ordinal': 0,
        'type': InstallIsolatedWebAppSuccessSpec.$,
    },
    'error': {
        'ordinal': 1,
        'type': mojo.internal.String,
    },
});
export var InstallIsolatedWebAppResultFieldTags;
(function (InstallIsolatedWebAppResultFieldTags) {
    InstallIsolatedWebAppResultFieldTags[InstallIsolatedWebAppResultFieldTags["SUCCESS"] = 0] = "SUCCESS";
    InstallIsolatedWebAppResultFieldTags[InstallIsolatedWebAppResultFieldTags["ERROR"] = 1] = "ERROR";
})(InstallIsolatedWebAppResultFieldTags || (InstallIsolatedWebAppResultFieldTags = {}));
export function whichInstallIsolatedWebAppResult(u) {
    if (u.success !== null && u.success !== undefined) {
        return InstallIsolatedWebAppResultFieldTags.SUCCESS;
    }
    if (u.error !== null && u.error !== undefined) {
        return InstallIsolatedWebAppResultFieldTags.ERROR;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(IwaDevModeLocationSpec.$, 'IwaDevModeLocation', {
    'proxyOrigin': {
        'ordinal': 0,
        'type': url_mojom_OriginSpec.$,
    },
    'bundlePath': {
        'ordinal': 1,
        'type': mojoBase_mojom_FilePathSpec.$,
    },
});
export var IwaDevModeLocationFieldTags;
(function (IwaDevModeLocationFieldTags) {
    IwaDevModeLocationFieldTags[IwaDevModeLocationFieldTags["PROXY_ORIGIN"] = 0] = "PROXY_ORIGIN";
    IwaDevModeLocationFieldTags[IwaDevModeLocationFieldTags["BUNDLE_PATH"] = 1] = "BUNDLE_PATH";
})(IwaDevModeLocationFieldTags || (IwaDevModeLocationFieldTags = {}));
export function whichIwaDevModeLocation(u) {
    if (u.proxyOrigin !== null && u.proxyOrigin !== undefined) {
        return IwaDevModeLocationFieldTags.PROXY_ORIGIN;
    }
    if (u.bundlePath !== null && u.bundlePath !== undefined) {
        return IwaDevModeLocationFieldTags.BUNDLE_PATH;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(ParseUpdateManifestFromUrlResultSpec.$, 'ParseUpdateManifestFromUrlResult', {
    'updateManifest': {
        'ordinal': 0,
        'type': UpdateManifestSpec.$,
    },
    'error': {
        'ordinal': 1,
        'type': mojo.internal.String,
    },
});
export var ParseUpdateManifestFromUrlResultFieldTags;
(function (ParseUpdateManifestFromUrlResultFieldTags) {
    ParseUpdateManifestFromUrlResultFieldTags[ParseUpdateManifestFromUrlResultFieldTags["UPDATE_MANIFEST"] = 0] = "UPDATE_MANIFEST";
    ParseUpdateManifestFromUrlResultFieldTags[ParseUpdateManifestFromUrlResultFieldTags["ERROR"] = 1] = "ERROR";
})(ParseUpdateManifestFromUrlResultFieldTags || (ParseUpdateManifestFromUrlResultFieldTags = {}));
export function whichParseUpdateManifestFromUrlResult(u) {
    if (u.updateManifest !== null && u.updateManifest !== undefined) {
        return ParseUpdateManifestFromUrlResultFieldTags.UPDATE_MANIFEST;
    }
    if (u.error !== null && u.error !== undefined) {
        return ParseUpdateManifestFromUrlResultFieldTags.ERROR;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
