// chrome/browser/ui/webui/tab_search/tab_search.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { ColorSpec as tabGroups_mojom_ColorSpec } from './tab_group_types.mojom-webui.js';
import { TabAlertStateSpec as tabs_mojom_TabAlertStateSpec } from './tabs.mojom-webui.js';
import { String16Spec as mojoBase_mojom_String16Spec } from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import { TimeSpec as mojoBase_mojom_TimeSpec, TimeTicksSpec as mojoBase_mojom_TimeTicksSpec } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import { TokenSpec as mojoBase_mojom_TokenSpec } from '//resources/mojo/mojo/public/mojom/base/token.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const DeclutterCTREventSpec = { $: mojo.internal.Enum() };
export var DeclutterCTREvent;
(function (DeclutterCTREvent) {
    DeclutterCTREvent[DeclutterCTREvent["MIN_VALUE"] = 0] = "MIN_VALUE";
    DeclutterCTREvent[DeclutterCTREvent["MAX_VALUE"] = 1] = "MAX_VALUE";
    DeclutterCTREvent[DeclutterCTREvent["kDeclutterShown"] = 0] = "kDeclutterShown";
    DeclutterCTREvent[DeclutterCTREvent["kCloseTabsClicked"] = 1] = "kCloseTabsClicked";
})(DeclutterCTREvent || (DeclutterCTREvent = {}));
export const SelectorCTREventSpec = { $: mojo.internal.Enum() };
export var SelectorCTREvent;
(function (SelectorCTREvent) {
    SelectorCTREvent[SelectorCTREvent["MIN_VALUE"] = 0] = "MIN_VALUE";
    SelectorCTREvent[SelectorCTREvent["MAX_VALUE"] = 2] = "MAX_VALUE";
    SelectorCTREvent[SelectorCTREvent["kSelectorShown"] = 0] = "kSelectorShown";
    SelectorCTREvent[SelectorCTREvent["kAutoTabGroupsClicked"] = 1] = "kAutoTabGroupsClicked";
    SelectorCTREvent[SelectorCTREvent["kDeclutterClicked"] = 2] = "kDeclutterClicked";
})(SelectorCTREvent || (SelectorCTREvent = {}));
export const TabDeclutterEntryPointSpec = { $: mojo.internal.Enum() };
export var TabDeclutterEntryPoint;
(function (TabDeclutterEntryPoint) {
    TabDeclutterEntryPoint[TabDeclutterEntryPoint["MIN_VALUE"] = 0] = "MIN_VALUE";
    TabDeclutterEntryPoint[TabDeclutterEntryPoint["MAX_VALUE"] = 2] = "MAX_VALUE";
    TabDeclutterEntryPoint[TabDeclutterEntryPoint["kNudge"] = 0] = "kNudge";
    TabDeclutterEntryPoint[TabDeclutterEntryPoint["kAppMenu"] = 1] = "kAppMenu";
    TabDeclutterEntryPoint[TabDeclutterEntryPoint["kSelector"] = 2] = "kSelector";
})(TabDeclutterEntryPoint || (TabDeclutterEntryPoint = {}));
export const TabOrganizationStateSpec = { $: mojo.internal.Enum() };
export var TabOrganizationState;
(function (TabOrganizationState) {
    TabOrganizationState[TabOrganizationState["MIN_VALUE"] = 0] = "MIN_VALUE";
    TabOrganizationState[TabOrganizationState["MAX_VALUE"] = 4] = "MAX_VALUE";
    TabOrganizationState[TabOrganizationState["kInitializing"] = 0] = "kInitializing";
    TabOrganizationState[TabOrganizationState["kNotStarted"] = 1] = "kNotStarted";
    TabOrganizationState[TabOrganizationState["kInProgress"] = 2] = "kInProgress";
    TabOrganizationState[TabOrganizationState["kSuccess"] = 3] = "kSuccess";
    TabOrganizationState[TabOrganizationState["kFailure"] = 4] = "kFailure";
})(TabOrganizationState || (TabOrganizationState = {}));
export const TabOrganizationFeatureSpec = { $: mojo.internal.Enum() };
export var TabOrganizationFeature;
(function (TabOrganizationFeature) {
    TabOrganizationFeature[TabOrganizationFeature["MIN_VALUE"] = 0] = "MIN_VALUE";
    TabOrganizationFeature[TabOrganizationFeature["MAX_VALUE"] = 3] = "MAX_VALUE";
    TabOrganizationFeature[TabOrganizationFeature["kNone"] = 0] = "kNone";
    TabOrganizationFeature[TabOrganizationFeature["kSelector"] = 1] = "kSelector";
    TabOrganizationFeature[TabOrganizationFeature["kAutoTabGroups"] = 2] = "kAutoTabGroups";
    TabOrganizationFeature[TabOrganizationFeature["kDeclutter"] = 3] = "kDeclutter";
})(TabOrganizationFeature || (TabOrganizationFeature = {}));
export const TabOrganizationErrorSpec = { $: mojo.internal.Enum() };
export var TabOrganizationError;
(function (TabOrganizationError) {
    TabOrganizationError[TabOrganizationError["MIN_VALUE"] = 0] = "MIN_VALUE";
    TabOrganizationError[TabOrganizationError["MAX_VALUE"] = 2] = "MAX_VALUE";
    TabOrganizationError[TabOrganizationError["kNone"] = 0] = "kNone";
    TabOrganizationError[TabOrganizationError["kGrouping"] = 1] = "kGrouping";
    TabOrganizationError[TabOrganizationError["kGeneric"] = 2] = "kGeneric";
})(TabOrganizationError || (TabOrganizationError = {}));
export const TabOrganizationModelStrategySpec = { $: mojo.internal.Enum() };
export var TabOrganizationModelStrategy;
(function (TabOrganizationModelStrategy) {
    TabOrganizationModelStrategy[TabOrganizationModelStrategy["MIN_VALUE"] = 0] = "MIN_VALUE";
    TabOrganizationModelStrategy[TabOrganizationModelStrategy["MAX_VALUE"] = 2] = "MAX_VALUE";
    TabOrganizationModelStrategy[TabOrganizationModelStrategy["kTopic"] = 0] = "kTopic";
    TabOrganizationModelStrategy[TabOrganizationModelStrategy["kTask"] = 1] = "kTask";
    TabOrganizationModelStrategy[TabOrganizationModelStrategy["kDomain"] = 2] = "kDomain";
})(TabOrganizationModelStrategy || (TabOrganizationModelStrategy = {}));
export const TabSearchSectionSpec = { $: mojo.internal.Enum() };
export var TabSearchSection;
(function (TabSearchSection) {
    TabSearchSection[TabSearchSection["MIN_VALUE"] = 0] = "MIN_VALUE";
    TabSearchSection[TabSearchSection["MAX_VALUE"] = 2] = "MAX_VALUE";
    TabSearchSection[TabSearchSection["kNone"] = 0] = "kNone";
    TabSearchSection[TabSearchSection["kSearch"] = 1] = "kSearch";
    TabSearchSection[TabSearchSection["kOrganize"] = 2] = "kOrganize";
})(TabSearchSection || (TabSearchSection = {}));
export const UserFeedbackSpec = { $: mojo.internal.Enum() };
export var UserFeedback;
(function (UserFeedback) {
    UserFeedback[UserFeedback["MIN_VALUE"] = 0] = "MIN_VALUE";
    UserFeedback[UserFeedback["MAX_VALUE"] = 2] = "MAX_VALUE";
    UserFeedback[UserFeedback["kUserFeedBackUnspecified"] = 0] = "kUserFeedBackUnspecified";
    UserFeedback[UserFeedback["kUserFeedBackPositive"] = 1] = "kUserFeedBackPositive";
    UserFeedback[UserFeedback["kUserFeedBackNegative"] = 2] = "kUserFeedBackNegative";
})(UserFeedback || (UserFeedback = {}));
export class PageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'tab_search.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(page, handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            page,
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "tab_search.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createPageHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'tab_search.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    closeTab(tabId) {
        this.proxy.sendMessage(0, PageHandler_CloseTab_ParamsSpec.$, null, [
            tabId
        ], false);
    }
    closeWebUiTab() {
        this.proxy.sendMessage(1, PageHandler_CloseWebUiTab_ParamsSpec.$, null, [], false);
    }
    declutterTabs(tabIds, urls) {
        this.proxy.sendMessage(2, PageHandler_DeclutterTabs_ParamsSpec.$, null, [
            tabIds,
            urls
        ], false);
    }
    acceptTabOrganization(sessionId, organizationId, tabs) {
        this.proxy.sendMessage(3, PageHandler_AcceptTabOrganization_ParamsSpec.$, null, [
            sessionId,
            organizationId,
            tabs
        ], false);
    }
    rejectTabOrganization(sessionId, organizationId) {
        this.proxy.sendMessage(4, PageHandler_RejectTabOrganization_ParamsSpec.$, null, [
            sessionId,
            organizationId
        ], false);
    }
    renameTabOrganization(sessionId, organizationId, name) {
        this.proxy.sendMessage(5, PageHandler_RenameTabOrganization_ParamsSpec.$, null, [
            sessionId,
            organizationId,
            name
        ], false);
    }
    excludeFromStaleTabs(tabId) {
        this.proxy.sendMessage(6, PageHandler_ExcludeFromStaleTabs_ParamsSpec.$, null, [
            tabId
        ], false);
    }
    excludeFromDuplicateTabs(url) {
        this.proxy.sendMessage(7, PageHandler_ExcludeFromDuplicateTabs_ParamsSpec.$, null, [
            url
        ], false);
    }
    getProfileData() {
        return this.proxy.sendMessage(8, PageHandler_GetProfileData_ParamsSpec.$, PageHandler_GetProfileData_ResponseParamsSpec.$, [], false);
    }
    getUnusedTabs() {
        return this.proxy.sendMessage(9, PageHandler_GetUnusedTabs_ParamsSpec.$, PageHandler_GetUnusedTabs_ResponseParamsSpec.$, [], false);
    }
    getTabSearchSection() {
        return this.proxy.sendMessage(10, PageHandler_GetTabSearchSection_ParamsSpec.$, PageHandler_GetTabSearchSection_ResponseParamsSpec.$, [], false);
    }
    getTabOrganizationFeature() {
        return this.proxy.sendMessage(11, PageHandler_GetTabOrganizationFeature_ParamsSpec.$, PageHandler_GetTabOrganizationFeature_ResponseParamsSpec.$, [], false);
    }
    getTabOrganizationSession() {
        return this.proxy.sendMessage(12, PageHandler_GetTabOrganizationSession_ParamsSpec.$, PageHandler_GetTabOrganizationSession_ResponseParamsSpec.$, [], false);
    }
    getTabOrganizationModelStrategy() {
        return this.proxy.sendMessage(13, PageHandler_GetTabOrganizationModelStrategy_ParamsSpec.$, PageHandler_GetTabOrganizationModelStrategy_ResponseParamsSpec.$, [], false);
    }
    getIsSplit() {
        return this.proxy.sendMessage(14, PageHandler_GetIsSplit_ParamsSpec.$, PageHandler_GetIsSplit_ResponseParamsSpec.$, [], false);
    }
    switchToTab(switchToTabInfo) {
        this.proxy.sendMessage(15, PageHandler_SwitchToTab_ParamsSpec.$, null, [
            switchToTabInfo
        ], false);
    }
    openRecentlyClosedEntry(sessionId) {
        this.proxy.sendMessage(16, PageHandler_OpenRecentlyClosedEntry_ParamsSpec.$, null, [
            sessionId
        ], false);
    }
    requestTabOrganization() {
        this.proxy.sendMessage(17, PageHandler_RequestTabOrganization_ParamsSpec.$, null, [], false);
    }
    removeTabFromOrganization(sessionId, organizationId, tab) {
        this.proxy.sendMessage(18, PageHandler_RemoveTabFromOrganization_ParamsSpec.$, null, [
            sessionId,
            organizationId,
            tab
        ], false);
    }
    rejectSession(sessionId) {
        this.proxy.sendMessage(19, PageHandler_RejectSession_ParamsSpec.$, null, [
            sessionId
        ], false);
    }
    replaceActiveSplitTab(replacementTabId) {
        this.proxy.sendMessage(20, PageHandler_ReplaceActiveSplitTab_ParamsSpec.$, null, [
            replacementTabId
        ], false);
    }
    restartSession() {
        this.proxy.sendMessage(21, PageHandler_RestartSession_ParamsSpec.$, null, [], false);
    }
    saveRecentlyClosedExpandedPref(expanded) {
        this.proxy.sendMessage(22, PageHandler_SaveRecentlyClosedExpandedPref_ParamsSpec.$, null, [
            expanded
        ], false);
    }
    setOrganizationFeature(feature) {
        this.proxy.sendMessage(23, PageHandler_SetOrganizationFeature_ParamsSpec.$, null, [
            feature
        ], false);
    }
    startTabGroupTutorial() {
        this.proxy.sendMessage(24, PageHandler_StartTabGroupTutorial_ParamsSpec.$, null, [], false);
    }
    triggerFeedback(sessionId) {
        this.proxy.sendMessage(25, PageHandler_TriggerFeedback_ParamsSpec.$, null, [
            sessionId
        ], false);
    }
    triggerSignIn() {
        this.proxy.sendMessage(26, PageHandler_TriggerSignIn_ParamsSpec.$, null, [], false);
    }
    openHelpPage() {
        this.proxy.sendMessage(27, PageHandler_OpenHelpPage_ParamsSpec.$, null, [], false);
    }
    setTabOrganizationModelStrategy(strategy) {
        this.proxy.sendMessage(28, PageHandler_SetTabOrganizationModelStrategy_ParamsSpec.$, null, [
            strategy
        ], false);
    }
    setTabOrganizationUserInstruction(userInstruction) {
        this.proxy.sendMessage(29, PageHandler_SetTabOrganizationUserInstruction_ParamsSpec.$, null, [
            userInstruction
        ], false);
    }
    setUserFeedback(sessionId, feedback) {
        this.proxy.sendMessage(30, PageHandler_SetUserFeedback_ParamsSpec.$, null, [
            sessionId,
            feedback
        ], false);
    }
    notifyOrganizationUIReadyToShow() {
        this.proxy.sendMessage(31, PageHandler_NotifyOrganizationUIReadyToShow_ParamsSpec.$, null, [], false);
    }
    notifySearchUIReadyToShow() {
        this.proxy.sendMessage(32, PageHandler_NotifySearchUIReadyToShow_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_CloseTab_ParamsSpec.$, null, impl.closeTab.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_CloseWebUiTab_ParamsSpec.$, null, impl.closeWebUiTab.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_DeclutterTabs_ParamsSpec.$, null, impl.declutterTabs.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_AcceptTabOrganization_ParamsSpec.$, null, impl.acceptTabOrganization.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_RejectTabOrganization_ParamsSpec.$, null, impl.rejectTabOrganization.bind(impl), false);
        this.helper_internal_.registerHandler(5, PageHandler_RenameTabOrganization_ParamsSpec.$, null, impl.renameTabOrganization.bind(impl), false);
        this.helper_internal_.registerHandler(6, PageHandler_ExcludeFromStaleTabs_ParamsSpec.$, null, impl.excludeFromStaleTabs.bind(impl), false);
        this.helper_internal_.registerHandler(7, PageHandler_ExcludeFromDuplicateTabs_ParamsSpec.$, null, impl.excludeFromDuplicateTabs.bind(impl), false);
        this.helper_internal_.registerHandler(8, PageHandler_GetProfileData_ParamsSpec.$, PageHandler_GetProfileData_ResponseParamsSpec.$, impl.getProfileData.bind(impl), false);
        this.helper_internal_.registerHandler(9, PageHandler_GetUnusedTabs_ParamsSpec.$, PageHandler_GetUnusedTabs_ResponseParamsSpec.$, impl.getUnusedTabs.bind(impl), false);
        this.helper_internal_.registerHandler(10, PageHandler_GetTabSearchSection_ParamsSpec.$, PageHandler_GetTabSearchSection_ResponseParamsSpec.$, impl.getTabSearchSection.bind(impl), false);
        this.helper_internal_.registerHandler(11, PageHandler_GetTabOrganizationFeature_ParamsSpec.$, PageHandler_GetTabOrganizationFeature_ResponseParamsSpec.$, impl.getTabOrganizationFeature.bind(impl), false);
        this.helper_internal_.registerHandler(12, PageHandler_GetTabOrganizationSession_ParamsSpec.$, PageHandler_GetTabOrganizationSession_ResponseParamsSpec.$, impl.getTabOrganizationSession.bind(impl), false);
        this.helper_internal_.registerHandler(13, PageHandler_GetTabOrganizationModelStrategy_ParamsSpec.$, PageHandler_GetTabOrganizationModelStrategy_ResponseParamsSpec.$, impl.getTabOrganizationModelStrategy.bind(impl), false);
        this.helper_internal_.registerHandler(14, PageHandler_GetIsSplit_ParamsSpec.$, PageHandler_GetIsSplit_ResponseParamsSpec.$, impl.getIsSplit.bind(impl), false);
        this.helper_internal_.registerHandler(15, PageHandler_SwitchToTab_ParamsSpec.$, null, impl.switchToTab.bind(impl), false);
        this.helper_internal_.registerHandler(16, PageHandler_OpenRecentlyClosedEntry_ParamsSpec.$, null, impl.openRecentlyClosedEntry.bind(impl), false);
        this.helper_internal_.registerHandler(17, PageHandler_RequestTabOrganization_ParamsSpec.$, null, impl.requestTabOrganization.bind(impl), false);
        this.helper_internal_.registerHandler(18, PageHandler_RemoveTabFromOrganization_ParamsSpec.$, null, impl.removeTabFromOrganization.bind(impl), false);
        this.helper_internal_.registerHandler(19, PageHandler_RejectSession_ParamsSpec.$, null, impl.rejectSession.bind(impl), false);
        this.helper_internal_.registerHandler(20, PageHandler_ReplaceActiveSplitTab_ParamsSpec.$, null, impl.replaceActiveSplitTab.bind(impl), false);
        this.helper_internal_.registerHandler(21, PageHandler_RestartSession_ParamsSpec.$, null, impl.restartSession.bind(impl), false);
        this.helper_internal_.registerHandler(22, PageHandler_SaveRecentlyClosedExpandedPref_ParamsSpec.$, null, impl.saveRecentlyClosedExpandedPref.bind(impl), false);
        this.helper_internal_.registerHandler(23, PageHandler_SetOrganizationFeature_ParamsSpec.$, null, impl.setOrganizationFeature.bind(impl), false);
        this.helper_internal_.registerHandler(24, PageHandler_StartTabGroupTutorial_ParamsSpec.$, null, impl.startTabGroupTutorial.bind(impl), false);
        this.helper_internal_.registerHandler(25, PageHandler_TriggerFeedback_ParamsSpec.$, null, impl.triggerFeedback.bind(impl), false);
        this.helper_internal_.registerHandler(26, PageHandler_TriggerSignIn_ParamsSpec.$, null, impl.triggerSignIn.bind(impl), false);
        this.helper_internal_.registerHandler(27, PageHandler_OpenHelpPage_ParamsSpec.$, null, impl.openHelpPage.bind(impl), false);
        this.helper_internal_.registerHandler(28, PageHandler_SetTabOrganizationModelStrategy_ParamsSpec.$, null, impl.setTabOrganizationModelStrategy.bind(impl), false);
        this.helper_internal_.registerHandler(29, PageHandler_SetTabOrganizationUserInstruction_ParamsSpec.$, null, impl.setTabOrganizationUserInstruction.bind(impl), false);
        this.helper_internal_.registerHandler(30, PageHandler_SetUserFeedback_ParamsSpec.$, null, impl.setUserFeedback.bind(impl), false);
        this.helper_internal_.registerHandler(31, PageHandler_NotifyOrganizationUIReadyToShow_ParamsSpec.$, null, impl.notifyOrganizationUIReadyToShow.bind(impl), false);
        this.helper_internal_.registerHandler(32, PageHandler_NotifySearchUIReadyToShow_ParamsSpec.$, null, impl.notifySearchUIReadyToShow.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "tab_search.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    closeTab;
    closeWebUiTab;
    declutterTabs;
    acceptTabOrganization;
    rejectTabOrganization;
    renameTabOrganization;
    excludeFromStaleTabs;
    excludeFromDuplicateTabs;
    getProfileData;
    getUnusedTabs;
    getTabSearchSection;
    getTabOrganizationFeature;
    getTabOrganizationSession;
    getTabOrganizationModelStrategy;
    getIsSplit;
    switchToTab;
    openRecentlyClosedEntry;
    requestTabOrganization;
    removeTabFromOrganization;
    rejectSession;
    replaceActiveSplitTab;
    restartSession;
    saveRecentlyClosedExpandedPref;
    setOrganizationFeature;
    startTabGroupTutorial;
    triggerFeedback;
    triggerSignIn;
    openHelpPage;
    setTabOrganizationModelStrategy;
    setTabOrganizationUserInstruction;
    setUserFeedback;
    notifyOrganizationUIReadyToShow;
    notifySearchUIReadyToShow;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.closeTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_CloseTab_ParamsSpec.$, null, this.closeTab.createReceiverHandler(false /* expectsResponse */), false);
        this.closeWebUiTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_CloseWebUiTab_ParamsSpec.$, null, this.closeWebUiTab.createReceiverHandler(false /* expectsResponse */), false);
        this.declutterTabs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_DeclutterTabs_ParamsSpec.$, null, this.declutterTabs.createReceiverHandler(false /* expectsResponse */), false);
        this.acceptTabOrganization =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_AcceptTabOrganization_ParamsSpec.$, null, this.acceptTabOrganization.createReceiverHandler(false /* expectsResponse */), false);
        this.rejectTabOrganization =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_RejectTabOrganization_ParamsSpec.$, null, this.rejectTabOrganization.createReceiverHandler(false /* expectsResponse */), false);
        this.renameTabOrganization =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PageHandler_RenameTabOrganization_ParamsSpec.$, null, this.renameTabOrganization.createReceiverHandler(false /* expectsResponse */), false);
        this.excludeFromStaleTabs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, PageHandler_ExcludeFromStaleTabs_ParamsSpec.$, null, this.excludeFromStaleTabs.createReceiverHandler(false /* expectsResponse */), false);
        this.excludeFromDuplicateTabs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, PageHandler_ExcludeFromDuplicateTabs_ParamsSpec.$, null, this.excludeFromDuplicateTabs.createReceiverHandler(false /* expectsResponse */), false);
        this.getProfileData =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, PageHandler_GetProfileData_ParamsSpec.$, PageHandler_GetProfileData_ResponseParamsSpec.$, this.getProfileData.createReceiverHandler(true /* expectsResponse */), false);
        this.getUnusedTabs =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, PageHandler_GetUnusedTabs_ParamsSpec.$, PageHandler_GetUnusedTabs_ResponseParamsSpec.$, this.getUnusedTabs.createReceiverHandler(true /* expectsResponse */), false);
        this.getTabSearchSection =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, PageHandler_GetTabSearchSection_ParamsSpec.$, PageHandler_GetTabSearchSection_ResponseParamsSpec.$, this.getTabSearchSection.createReceiverHandler(true /* expectsResponse */), false);
        this.getTabOrganizationFeature =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, PageHandler_GetTabOrganizationFeature_ParamsSpec.$, PageHandler_GetTabOrganizationFeature_ResponseParamsSpec.$, this.getTabOrganizationFeature.createReceiverHandler(true /* expectsResponse */), false);
        this.getTabOrganizationSession =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, PageHandler_GetTabOrganizationSession_ParamsSpec.$, PageHandler_GetTabOrganizationSession_ResponseParamsSpec.$, this.getTabOrganizationSession.createReceiverHandler(true /* expectsResponse */), false);
        this.getTabOrganizationModelStrategy =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, PageHandler_GetTabOrganizationModelStrategy_ParamsSpec.$, PageHandler_GetTabOrganizationModelStrategy_ResponseParamsSpec.$, this.getTabOrganizationModelStrategy.createReceiverHandler(true /* expectsResponse */), false);
        this.getIsSplit =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, PageHandler_GetIsSplit_ParamsSpec.$, PageHandler_GetIsSplit_ResponseParamsSpec.$, this.getIsSplit.createReceiverHandler(true /* expectsResponse */), false);
        this.switchToTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, PageHandler_SwitchToTab_ParamsSpec.$, null, this.switchToTab.createReceiverHandler(false /* expectsResponse */), false);
        this.openRecentlyClosedEntry =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(16, PageHandler_OpenRecentlyClosedEntry_ParamsSpec.$, null, this.openRecentlyClosedEntry.createReceiverHandler(false /* expectsResponse */), false);
        this.requestTabOrganization =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(17, PageHandler_RequestTabOrganization_ParamsSpec.$, null, this.requestTabOrganization.createReceiverHandler(false /* expectsResponse */), false);
        this.removeTabFromOrganization =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(18, PageHandler_RemoveTabFromOrganization_ParamsSpec.$, null, this.removeTabFromOrganization.createReceiverHandler(false /* expectsResponse */), false);
        this.rejectSession =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(19, PageHandler_RejectSession_ParamsSpec.$, null, this.rejectSession.createReceiverHandler(false /* expectsResponse */), false);
        this.replaceActiveSplitTab =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(20, PageHandler_ReplaceActiveSplitTab_ParamsSpec.$, null, this.replaceActiveSplitTab.createReceiverHandler(false /* expectsResponse */), false);
        this.restartSession =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(21, PageHandler_RestartSession_ParamsSpec.$, null, this.restartSession.createReceiverHandler(false /* expectsResponse */), false);
        this.saveRecentlyClosedExpandedPref =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(22, PageHandler_SaveRecentlyClosedExpandedPref_ParamsSpec.$, null, this.saveRecentlyClosedExpandedPref.createReceiverHandler(false /* expectsResponse */), false);
        this.setOrganizationFeature =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(23, PageHandler_SetOrganizationFeature_ParamsSpec.$, null, this.setOrganizationFeature.createReceiverHandler(false /* expectsResponse */), false);
        this.startTabGroupTutorial =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(24, PageHandler_StartTabGroupTutorial_ParamsSpec.$, null, this.startTabGroupTutorial.createReceiverHandler(false /* expectsResponse */), false);
        this.triggerFeedback =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(25, PageHandler_TriggerFeedback_ParamsSpec.$, null, this.triggerFeedback.createReceiverHandler(false /* expectsResponse */), false);
        this.triggerSignIn =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(26, PageHandler_TriggerSignIn_ParamsSpec.$, null, this.triggerSignIn.createReceiverHandler(false /* expectsResponse */), false);
        this.openHelpPage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(27, PageHandler_OpenHelpPage_ParamsSpec.$, null, this.openHelpPage.createReceiverHandler(false /* expectsResponse */), false);
        this.setTabOrganizationModelStrategy =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(28, PageHandler_SetTabOrganizationModelStrategy_ParamsSpec.$, null, this.setTabOrganizationModelStrategy.createReceiverHandler(false /* expectsResponse */), false);
        this.setTabOrganizationUserInstruction =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(29, PageHandler_SetTabOrganizationUserInstruction_ParamsSpec.$, null, this.setTabOrganizationUserInstruction.createReceiverHandler(false /* expectsResponse */), false);
        this.setUserFeedback =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(30, PageHandler_SetUserFeedback_ParamsSpec.$, null, this.setUserFeedback.createReceiverHandler(false /* expectsResponse */), false);
        this.notifyOrganizationUIReadyToShow =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(31, PageHandler_NotifyOrganizationUIReadyToShow_ParamsSpec.$, null, this.notifyOrganizationUIReadyToShow.createReceiverHandler(false /* expectsResponse */), false);
        this.notifySearchUIReadyToShow =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(32, PageHandler_NotifySearchUIReadyToShow_ParamsSpec.$, null, this.notifySearchUIReadyToShow.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'tab_search.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    tabOrganizationSessionUpdated(session) {
        this.proxy.sendMessage(0, Page_TabOrganizationSessionUpdated_ParamsSpec.$, null, [
            session
        ], false);
    }
    tabOrganizationModelStrategyUpdated(strategy) {
        this.proxy.sendMessage(1, Page_TabOrganizationModelStrategyUpdated_ParamsSpec.$, null, [
            strategy
        ], false);
    }
    hostWindowChanged() {
        this.proxy.sendMessage(2, Page_HostWindowChanged_ParamsSpec.$, null, [], false);
    }
    tabsChanged(profileTabs) {
        this.proxy.sendMessage(3, Page_TabsChanged_ParamsSpec.$, null, [
            profileTabs
        ], false);
    }
    tabUpdated(tabUpdateInfo) {
        this.proxy.sendMessage(4, Page_TabUpdated_ParamsSpec.$, null, [
            tabUpdateInfo
        ], false);
    }
    tabsRemoved(tabsRemovedInfo) {
        this.proxy.sendMessage(5, Page_TabsRemoved_ParamsSpec.$, null, [
            tabsRemovedInfo
        ], false);
    }
    tabSearchSectionChanged(section) {
        this.proxy.sendMessage(6, Page_TabSearchSectionChanged_ParamsSpec.$, null, [
            section
        ], false);
    }
    tabOrganizationFeatureChanged(feature) {
        this.proxy.sendMessage(7, Page_TabOrganizationFeatureChanged_ParamsSpec.$, null, [
            feature
        ], false);
    }
    showFREChanged(show) {
        this.proxy.sendMessage(8, Page_ShowFREChanged_ParamsSpec.$, null, [
            show
        ], false);
    }
    tabOrganizationEnabledChanged(enabled) {
        this.proxy.sendMessage(9, Page_TabOrganizationEnabledChanged_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    unusedTabsChanged(tabs) {
        this.proxy.sendMessage(10, Page_UnusedTabsChanged_ParamsSpec.$, null, [
            tabs
        ], false);
    }
    tabUnsplit() {
        this.proxy.sendMessage(11, Page_TabUnsplit_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_TabOrganizationSessionUpdated_ParamsSpec.$, null, impl.tabOrganizationSessionUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(1, Page_TabOrganizationModelStrategyUpdated_ParamsSpec.$, null, impl.tabOrganizationModelStrategyUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(2, Page_HostWindowChanged_ParamsSpec.$, null, impl.hostWindowChanged.bind(impl), false);
        this.helper_internal_.registerHandler(3, Page_TabsChanged_ParamsSpec.$, null, impl.tabsChanged.bind(impl), false);
        this.helper_internal_.registerHandler(4, Page_TabUpdated_ParamsSpec.$, null, impl.tabUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(5, Page_TabsRemoved_ParamsSpec.$, null, impl.tabsRemoved.bind(impl), false);
        this.helper_internal_.registerHandler(6, Page_TabSearchSectionChanged_ParamsSpec.$, null, impl.tabSearchSectionChanged.bind(impl), false);
        this.helper_internal_.registerHandler(7, Page_TabOrganizationFeatureChanged_ParamsSpec.$, null, impl.tabOrganizationFeatureChanged.bind(impl), false);
        this.helper_internal_.registerHandler(8, Page_ShowFREChanged_ParamsSpec.$, null, impl.showFREChanged.bind(impl), false);
        this.helper_internal_.registerHandler(9, Page_TabOrganizationEnabledChanged_ParamsSpec.$, null, impl.tabOrganizationEnabledChanged.bind(impl), false);
        this.helper_internal_.registerHandler(10, Page_UnusedTabsChanged_ParamsSpec.$, null, impl.unusedTabsChanged.bind(impl), false);
        this.helper_internal_.registerHandler(11, Page_TabUnsplit_ParamsSpec.$, null, impl.tabUnsplit.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "tab_search.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    tabOrganizationSessionUpdated;
    tabOrganizationModelStrategyUpdated;
    hostWindowChanged;
    tabsChanged;
    tabUpdated;
    tabsRemoved;
    tabSearchSectionChanged;
    tabOrganizationFeatureChanged;
    showFREChanged;
    tabOrganizationEnabledChanged;
    unusedTabsChanged;
    tabUnsplit;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.tabOrganizationSessionUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_TabOrganizationSessionUpdated_ParamsSpec.$, null, this.tabOrganizationSessionUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.tabOrganizationModelStrategyUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, Page_TabOrganizationModelStrategyUpdated_ParamsSpec.$, null, this.tabOrganizationModelStrategyUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.hostWindowChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, Page_HostWindowChanged_ParamsSpec.$, null, this.hostWindowChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.tabsChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, Page_TabsChanged_ParamsSpec.$, null, this.tabsChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.tabUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, Page_TabUpdated_ParamsSpec.$, null, this.tabUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.tabsRemoved =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, Page_TabsRemoved_ParamsSpec.$, null, this.tabsRemoved.createReceiverHandler(false /* expectsResponse */), false);
        this.tabSearchSectionChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, Page_TabSearchSectionChanged_ParamsSpec.$, null, this.tabSearchSectionChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.tabOrganizationFeatureChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, Page_TabOrganizationFeatureChanged_ParamsSpec.$, null, this.tabOrganizationFeatureChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.showFREChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, Page_ShowFREChanged_ParamsSpec.$, null, this.showFREChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.tabOrganizationEnabledChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, Page_TabOrganizationEnabledChanged_ParamsSpec.$, null, this.tabOrganizationEnabledChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.unusedTabsChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, Page_UnusedTabsChanged_ParamsSpec.$, null, this.unusedTabsChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.tabUnsplit =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, Page_TabUnsplit_ParamsSpec.$, null, this.tabUnsplit.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const ProfileDataSpec = { $: {} };
export const WindowSpec = { $: {} };
export const TabSpec = { $: {} };
export const RecentlyClosedTabSpec = { $: {} };
export const TabGroupSpec = { $: {} };
export const RecentlyClosedTabGroupSpec = { $: {} };
export const SwitchToTabInfoSpec = { $: {} };
export const TabOrganizationSpec = { $: {} };
export const TabOrganizationSessionSpec = { $: {} };
export const TabUpdateInfoSpec = { $: {} };
export const TabsRemovedInfoSpec = { $: {} };
export const UnusedTabInfoSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_CloseTab_ParamsSpec = { $: {} };
export const PageHandler_CloseWebUiTab_ParamsSpec = { $: {} };
export const PageHandler_DeclutterTabs_ParamsSpec = { $: {} };
export const PageHandler_AcceptTabOrganization_ParamsSpec = { $: {} };
export const PageHandler_RejectTabOrganization_ParamsSpec = { $: {} };
export const PageHandler_RenameTabOrganization_ParamsSpec = { $: {} };
export const PageHandler_ExcludeFromStaleTabs_ParamsSpec = { $: {} };
export const PageHandler_ExcludeFromDuplicateTabs_ParamsSpec = { $: {} };
export const PageHandler_GetProfileData_ParamsSpec = { $: {} };
export const PageHandler_GetProfileData_ResponseParamsSpec = { $: {} };
export const PageHandler_GetUnusedTabs_ParamsSpec = { $: {} };
export const PageHandler_GetUnusedTabs_ResponseParamsSpec = { $: {} };
export const PageHandler_GetTabSearchSection_ParamsSpec = { $: {} };
export const PageHandler_GetTabSearchSection_ResponseParamsSpec = { $: {} };
export const PageHandler_GetTabOrganizationFeature_ParamsSpec = { $: {} };
export const PageHandler_GetTabOrganizationFeature_ResponseParamsSpec = { $: {} };
export const PageHandler_GetTabOrganizationSession_ParamsSpec = { $: {} };
export const PageHandler_GetTabOrganizationSession_ResponseParamsSpec = { $: {} };
export const PageHandler_GetTabOrganizationModelStrategy_ParamsSpec = { $: {} };
export const PageHandler_GetTabOrganizationModelStrategy_ResponseParamsSpec = { $: {} };
export const PageHandler_GetIsSplit_ParamsSpec = { $: {} };
export const PageHandler_GetIsSplit_ResponseParamsSpec = { $: {} };
export const PageHandler_SwitchToTab_ParamsSpec = { $: {} };
export const PageHandler_OpenRecentlyClosedEntry_ParamsSpec = { $: {} };
export const PageHandler_RequestTabOrganization_ParamsSpec = { $: {} };
export const PageHandler_RemoveTabFromOrganization_ParamsSpec = { $: {} };
export const PageHandler_RejectSession_ParamsSpec = { $: {} };
export const PageHandler_ReplaceActiveSplitTab_ParamsSpec = { $: {} };
export const PageHandler_RestartSession_ParamsSpec = { $: {} };
export const PageHandler_SaveRecentlyClosedExpandedPref_ParamsSpec = { $: {} };
export const PageHandler_SetOrganizationFeature_ParamsSpec = { $: {} };
export const PageHandler_StartTabGroupTutorial_ParamsSpec = { $: {} };
export const PageHandler_TriggerFeedback_ParamsSpec = { $: {} };
export const PageHandler_TriggerSignIn_ParamsSpec = { $: {} };
export const PageHandler_OpenHelpPage_ParamsSpec = { $: {} };
export const PageHandler_SetTabOrganizationModelStrategy_ParamsSpec = { $: {} };
export const PageHandler_SetTabOrganizationUserInstruction_ParamsSpec = { $: {} };
export const PageHandler_SetUserFeedback_ParamsSpec = { $: {} };
export const PageHandler_NotifyOrganizationUIReadyToShow_ParamsSpec = { $: {} };
export const PageHandler_NotifySearchUIReadyToShow_ParamsSpec = { $: {} };
export const Page_TabOrganizationSessionUpdated_ParamsSpec = { $: {} };
export const Page_TabOrganizationModelStrategyUpdated_ParamsSpec = { $: {} };
export const Page_HostWindowChanged_ParamsSpec = { $: {} };
export const Page_TabsChanged_ParamsSpec = { $: {} };
export const Page_TabUpdated_ParamsSpec = { $: {} };
export const Page_TabsRemoved_ParamsSpec = { $: {} };
export const Page_TabSearchSectionChanged_ParamsSpec = { $: {} };
export const Page_TabOrganizationFeatureChanged_ParamsSpec = { $: {} };
export const Page_ShowFREChanged_ParamsSpec = { $: {} };
export const Page_TabOrganizationEnabledChanged_ParamsSpec = { $: {} };
export const Page_UnusedTabsChanged_ParamsSpec = { $: {} };
export const Page_TabUnsplit_ParamsSpec = { $: {} };
mojo.internal.Struct(ProfileDataSpec.$, 'ProfileData', [
    mojo.internal.StructField('windows', 0, 0, mojo.internal.Array(WindowSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tabGroups', 8, 0, mojo.internal.Array(TabGroupSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('recentlyClosedTabs', 16, 0, mojo.internal.Array(RecentlyClosedTabSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('recentlyClosedTabGroups', 24, 0, mojo.internal.Array(RecentlyClosedTabGroupSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('recentlyClosedSectionExpanded', 32, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(WindowSpec.$, 'Window', [
    mojo.internal.StructField('active', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isHostWindow', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('height', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tabs', 8, 0, mojo.internal.Array(TabSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(TabSpec.$, 'Tab', [
    mojo.internal.StructField('active', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('visible', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('alertStates', 8, 0, mojo.internal.Array(tabs_mojom_TabAlertStateSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('index', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tabId', 16, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('groupId', 24, 0, mojoBase_mojom_TokenSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('pinned', 0, 2, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('split', 0, 3, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 32, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 40, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('faviconUrl', 48, 0, url_mojom_UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isDefaultFavicon', 0, 4, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('showIcon', 0, 5, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('lastActiveTimeTicks', 56, 0, mojoBase_mojom_TimeTicksSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('lastActiveElapsedText', 64, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 80],]);
mojo.internal.Struct(RecentlyClosedTabSpec.$, 'RecentlyClosedTab', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('groupId', 8, 0, mojoBase_mojom_TokenSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 24, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('lastActiveTime', 32, 0, mojoBase_mojom_TimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('lastActiveElapsedText', 40, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(TabGroupSpec.$, 'TabGroup', [
    mojo.internal.StructField('id', 0, 0, mojoBase_mojom_TokenSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('color', 8, 0, tabGroups_mojom_ColorSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(RecentlyClosedTabGroupSpec.$, 'RecentlyClosedTabGroup', [
    mojo.internal.StructField('sessionId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('id', 8, 0, mojoBase_mojom_TokenSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('color', 4, 0, tabGroups_mojom_ColorSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tabCount', 24, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('lastActiveTime', 32, 0, mojoBase_mojom_TimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('lastActiveElapsedText', 40, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(SwitchToTabInfoSpec.$, 'SwitchToTabInfo', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TabOrganizationSpec.$, 'TabOrganization', [
    mojo.internal.StructField('organizationId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tabs', 8, 0, mojo.internal.Array(TabSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('firstNewTabIndex', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 16, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(TabOrganizationSessionSpec.$, 'TabOrganizationSession', [
    mojo.internal.StructField('sessionId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('state', 4, 0, TabOrganizationStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('organizations', 8, 0, mojo.internal.Array(TabOrganizationSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('error', 16, 0, TabOrganizationErrorSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('activeTabId', 20, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(TabUpdateInfoSpec.$, 'TabUpdateInfo', [
    mojo.internal.StructField('inActiveWindow', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('inHostWindow', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tab', 8, 0, TabSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(TabsRemovedInfoSpec.$, 'TabsRemovedInfo', [
    mojo.internal.StructField('tabIds', 0, 0, mojo.internal.Array(mojo.internal.Int32, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('recentlyClosedTabs', 8, 0, mojo.internal.Array(RecentlyClosedTabSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(UnusedTabInfoSpec.$, 'UnusedTabInfo', [
    mojo.internal.StructField('staleTabs', 0, 0, mojo.internal.Array(TabSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('duplicateTabs', 8, 0, mojo.internal.Map(mojo.internal.String, mojo.internal.Array(TabSpec.$, false), false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_CloseTab_ParamsSpec.$, 'PageHandler_CloseTab_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_CloseWebUiTab_ParamsSpec.$, 'PageHandler_CloseWebUiTab_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_DeclutterTabs_ParamsSpec.$, 'PageHandler_DeclutterTabs_Params', [
    mojo.internal.StructField('tabIds', 0, 0, mojo.internal.Array(mojo.internal.Int32, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('urls', 8, 0, mojo.internal.Array(url_mojom_UrlSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_AcceptTabOrganization_ParamsSpec.$, 'PageHandler_AcceptTabOrganization_Params', [
    mojo.internal.StructField('sessionId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('organizationId', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tabs', 8, 0, mojo.internal.Array(TabSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_RejectTabOrganization_ParamsSpec.$, 'PageHandler_RejectTabOrganization_Params', [
    mojo.internal.StructField('sessionId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('organizationId', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_RenameTabOrganization_ParamsSpec.$, 'PageHandler_RenameTabOrganization_Params', [
    mojo.internal.StructField('sessionId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('organizationId', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 8, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_ExcludeFromStaleTabs_ParamsSpec.$, 'PageHandler_ExcludeFromStaleTabs_Params', [
    mojo.internal.StructField('tabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ExcludeFromDuplicateTabs_ParamsSpec.$, 'PageHandler_ExcludeFromDuplicateTabs_Params', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetProfileData_ParamsSpec.$, 'PageHandler_GetProfileData_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetProfileData_ResponseParamsSpec.$, 'PageHandler_GetProfileData_ResponseParams', [
    mojo.internal.StructField('profileData', 0, 0, ProfileDataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetUnusedTabs_ParamsSpec.$, 'PageHandler_GetUnusedTabs_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetUnusedTabs_ResponseParamsSpec.$, 'PageHandler_GetUnusedTabs_ResponseParams', [
    mojo.internal.StructField('tabs', 0, 0, UnusedTabInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetTabSearchSection_ParamsSpec.$, 'PageHandler_GetTabSearchSection_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetTabSearchSection_ResponseParamsSpec.$, 'PageHandler_GetTabSearchSection_ResponseParams', [
    mojo.internal.StructField('section', 0, 0, TabSearchSectionSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetTabOrganizationFeature_ParamsSpec.$, 'PageHandler_GetTabOrganizationFeature_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetTabOrganizationFeature_ResponseParamsSpec.$, 'PageHandler_GetTabOrganizationFeature_ResponseParams', [
    mojo.internal.StructField('feature', 0, 0, TabOrganizationFeatureSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetTabOrganizationSession_ParamsSpec.$, 'PageHandler_GetTabOrganizationSession_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetTabOrganizationSession_ResponseParamsSpec.$, 'PageHandler_GetTabOrganizationSession_ResponseParams', [
    mojo.internal.StructField('session', 0, 0, TabOrganizationSessionSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetTabOrganizationModelStrategy_ParamsSpec.$, 'PageHandler_GetTabOrganizationModelStrategy_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetTabOrganizationModelStrategy_ResponseParamsSpec.$, 'PageHandler_GetTabOrganizationModelStrategy_ResponseParams', [
    mojo.internal.StructField('strategy', 0, 0, TabOrganizationModelStrategySpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetIsSplit_ParamsSpec.$, 'PageHandler_GetIsSplit_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetIsSplit_ResponseParamsSpec.$, 'PageHandler_GetIsSplit_ResponseParams', [
    mojo.internal.StructField('isSplit', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SwitchToTab_ParamsSpec.$, 'PageHandler_SwitchToTab_Params', [
    mojo.internal.StructField('switchToTabInfo', 0, 0, SwitchToTabInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OpenRecentlyClosedEntry_ParamsSpec.$, 'PageHandler_OpenRecentlyClosedEntry_Params', [
    mojo.internal.StructField('sessionId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_RequestTabOrganization_ParamsSpec.$, 'PageHandler_RequestTabOrganization_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_RemoveTabFromOrganization_ParamsSpec.$, 'PageHandler_RemoveTabFromOrganization_Params', [
    mojo.internal.StructField('sessionId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('organizationId', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tab', 8, 0, TabSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_RejectSession_ParamsSpec.$, 'PageHandler_RejectSession_Params', [
    mojo.internal.StructField('sessionId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ReplaceActiveSplitTab_ParamsSpec.$, 'PageHandler_ReplaceActiveSplitTab_Params', [
    mojo.internal.StructField('replacementTabId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_RestartSession_ParamsSpec.$, 'PageHandler_RestartSession_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_SaveRecentlyClosedExpandedPref_ParamsSpec.$, 'PageHandler_SaveRecentlyClosedExpandedPref_Params', [
    mojo.internal.StructField('expanded', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetOrganizationFeature_ParamsSpec.$, 'PageHandler_SetOrganizationFeature_Params', [
    mojo.internal.StructField('feature', 0, 0, TabOrganizationFeatureSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_StartTabGroupTutorial_ParamsSpec.$, 'PageHandler_StartTabGroupTutorial_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_TriggerFeedback_ParamsSpec.$, 'PageHandler_TriggerFeedback_Params', [
    mojo.internal.StructField('sessionId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_TriggerSignIn_ParamsSpec.$, 'PageHandler_TriggerSignIn_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OpenHelpPage_ParamsSpec.$, 'PageHandler_OpenHelpPage_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_SetTabOrganizationModelStrategy_ParamsSpec.$, 'PageHandler_SetTabOrganizationModelStrategy_Params', [
    mojo.internal.StructField('strategy', 0, 0, TabOrganizationModelStrategySpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetTabOrganizationUserInstruction_ParamsSpec.$, 'PageHandler_SetTabOrganizationUserInstruction_Params', [
    mojo.internal.StructField('userInstruction', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetUserFeedback_ParamsSpec.$, 'PageHandler_SetUserFeedback_Params', [
    mojo.internal.StructField('sessionId', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('feedback', 4, 0, UserFeedbackSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_NotifyOrganizationUIReadyToShow_ParamsSpec.$, 'PageHandler_NotifyOrganizationUIReadyToShow_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_NotifySearchUIReadyToShow_ParamsSpec.$, 'PageHandler_NotifySearchUIReadyToShow_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_TabOrganizationSessionUpdated_ParamsSpec.$, 'Page_TabOrganizationSessionUpdated_Params', [
    mojo.internal.StructField('session', 0, 0, TabOrganizationSessionSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_TabOrganizationModelStrategyUpdated_ParamsSpec.$, 'Page_TabOrganizationModelStrategyUpdated_Params', [
    mojo.internal.StructField('strategy', 0, 0, TabOrganizationModelStrategySpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_HostWindowChanged_ParamsSpec.$, 'Page_HostWindowChanged_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_TabsChanged_ParamsSpec.$, 'Page_TabsChanged_Params', [
    mojo.internal.StructField('profileTabs', 0, 0, ProfileDataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_TabUpdated_ParamsSpec.$, 'Page_TabUpdated_Params', [
    mojo.internal.StructField('tabUpdateInfo', 0, 0, TabUpdateInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_TabsRemoved_ParamsSpec.$, 'Page_TabsRemoved_Params', [
    mojo.internal.StructField('tabsRemovedInfo', 0, 0, TabsRemovedInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_TabSearchSectionChanged_ParamsSpec.$, 'Page_TabSearchSectionChanged_Params', [
    mojo.internal.StructField('section', 0, 0, TabSearchSectionSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_TabOrganizationFeatureChanged_ParamsSpec.$, 'Page_TabOrganizationFeatureChanged_Params', [
    mojo.internal.StructField('feature', 0, 0, TabOrganizationFeatureSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_ShowFREChanged_ParamsSpec.$, 'Page_ShowFREChanged_Params', [
    mojo.internal.StructField('show', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_TabOrganizationEnabledChanged_ParamsSpec.$, 'Page_TabOrganizationEnabledChanged_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_UnusedTabsChanged_ParamsSpec.$, 'Page_UnusedTabsChanged_Params', [
    mojo.internal.StructField('tabs', 0, 0, UnusedTabInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(Page_TabUnsplit_ParamsSpec.$, 'Page_TabUnsplit_Params', [], [[0, 8],]);
