import './auto_tab_groups/auto_tab_groups_page.js';
import './declutter/declutter_page.js';
import '/strings.m.js';
import './tab_organization_selector_button.js';
import type { PropertyValues } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { DeclutterPageElement } from './declutter/declutter_page.js';
import { TabOrganizationFeature } from './tab_search.mojom-webui.js';
export interface TabOrganizationSelectorElement {
    $: {
        autoTabGroupsButton: HTMLElement;
        autoTabGroupsPage: HTMLElement;
        declutterButton: HTMLElement;
        declutterPage: DeclutterPageElement;
    };
}
export declare class TabOrganizationSelectorElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        availableHeight: {
            type: NumberConstructor;
        };
        declutterHeading_: {
            type: StringConstructor;
        };
        disableDeclutter_: {
            type: BooleanConstructor;
        };
        selectedState_: {
            type: NumberConstructor;
        };
        prevSelectedState_: {
            type: NumberConstructor;
        };
        dedupeEnabled_: {
            type: BooleanConstructor;
        };
    };
    accessor availableHeight: number;
    protected accessor selectedState_: TabOrganizationFeature;
    protected accessor prevSelectedState_: TabOrganizationFeature;
    protected accessor declutterHeading_: string;
    protected accessor disableDeclutter_: boolean;
    private apiProxy_;
    private listenerIds_;
    private visibilityChangedListener_;
    private accessor dedupeEnabled_;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    updated(changedProperties: PropertyValues<this>): void;
    maybeLogFeatureShow(): void;
    protected getVisibleFeature_(): TabOrganizationFeature;
    protected onAutoTabGroupsClick_(): void;
    protected onDeclutterClick_(): void;
    protected onBackClick_(): void;
    private updateDeclutterTabs_;
    private updateSelectedFeature_;
    private logSelectorCtrValue_;
}
declare global {
    interface HTMLElementTagNameMap {
        'tab-organization-selector': TabOrganizationSelectorElement;
    }
}
