import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/icons.html.js';
import '/strings.m.js';
import './auto_tab_groups_failure.js';
import './auto_tab_groups_in_progress.js';
import './auto_tab_groups_not_started.js';
import './auto_tab_groups_results.js';
import { CrFeedbackOption } from 'chrome://resources/cr_elements/cr_feedback_buttons/cr_feedback_buttons.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { Tab, TabOrganizationSession } from '../tab_search.mojom-webui.js';
import { TabOrganizationError, TabOrganizationModelStrategy, TabOrganizationState } from '../tab_search.mojom-webui.js';
import type { AutoTabGroupsFailureElement } from './auto_tab_groups_failure.js';
import type { AutoTabGroupsInProgressElement } from './auto_tab_groups_in_progress.js';
import type { AutoTabGroupsNotStartedElement } from './auto_tab_groups_not_started.js';
import type { AutoTabGroupsResultsElement } from './auto_tab_groups_results.js';
export interface AutoTabGroupsPageElement {
    $: {
        notStarted: AutoTabGroupsNotStartedElement;
        inProgress: AutoTabGroupsInProgressElement;
        results: AutoTabGroupsResultsElement;
        failure: AutoTabGroupsFailureElement;
    };
}
export declare class AutoTabGroupsPageElement extends CrLitElement {
    static get is(): string;
    static get properties(): {
        availableHeight: {
            type: NumberConstructor;
        };
        showBackButton: {
            type: BooleanConstructor;
        };
        state_: {
            type: NumberConstructor;
        };
        session_: {
            type: ObjectConstructor;
        };
        showFRE_: {
            type: BooleanConstructor;
        };
        modelStrategy_: {
            type: NumberConstructor;
            notify: boolean;
        };
    };
    accessor availableHeight: number;
    accessor showBackButton: boolean;
    private apiProxy_;
    private listenerIds_;
    private accessor state_;
    protected accessor session_: TabOrganizationSession | null;
    protected accessor showFRE_: boolean;
    protected accessor modelStrategy_: TabOrganizationModelStrategy;
    private documentVisibilityChangedListener_;
    private futureState_;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    focus(): void;
    private onVisible_;
    private setShowFre_;
    setSessionForTesting(session: TabOrganizationSession): void;
    private setSession_;
    private setModelStrategy_;
    private maybeSetState_;
    private setState_;
    private applyFutureState_;
    protected isState_(state: TabOrganizationState): boolean;
    protected onSignInClick_(): void;
    protected onOrganizeTabsClick_(): void;
    protected onNameChange_(event: CustomEvent<{
        organizationId: number;
        name: string;
    }>): void;
    protected onRejectClick_(event: CustomEvent<{
        organizationId: number;
    }>): void;
    protected onRejectAllGroupsClick_(): void;
    protected onBackClick_(): void;
    protected onCreateGroupClick_(event: CustomEvent<{
        organizationId: number;
        tabs: Tab[];
    }>): void;
    protected onCreateAllGroupsClick_(event: CustomEvent<{
        organizations: Array<{
            organizationId: number;
            tabs: Tab[];
        }>;
    }>): void;
    protected onCheckNow_(): void;
    protected onTipClick_(): void;
    protected onRemoveTab_(event: CustomEvent<{
        organizationId: number;
        tab: Tab;
    }>): void;
    protected onLearnMoreClick_(): void;
    protected onFeedback_(event: CustomEvent<{
        value: CrFeedbackOption;
    }>): void;
    protected onModelStrategyChange_(event: CustomEvent<{
        value: TabOrganizationModelStrategy;
    }>): void;
    protected onUserInstructionInputChange_(event: CustomEvent<{
        value: string;
    }>): void;
    protected getSessionError_(): TabOrganizationError;
    private getOrganizations_;
    private missingActiveTab_;
    protected getTitle_(): string;
    private getSuccessTitle_;
    private getFailureTitle_;
    protected getBackButtonAriaLabel_(): string;
}
declare global {
    interface HTMLElementTagNameMap {
        'auto-tab-groups-page': AutoTabGroupsPageElement;
    }
}
