// Copyright 2011 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://tab-search.top-chrome/strings.m.js";import{css,CrLitElement,html,render}from"chrome://resources/lit/v3_0/lit.rollup.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{mojo}from"chrome://resources/mojo/mojo/public/js/bindings.js";function assert(value,message){if(value){return}throw new Error("Assertion failed"+(message?`: ${message}`:""))}function assertNotReached(message="Unreachable code hit"){assert(false,message)}let instance$c=null;function getCss$a(){return instance$c||(instance$c=[...[],css`[hidden],:host([hidden]){display:none !important}`])}let instance$b=null;function getCss$9(){return instance$b||(instance$b=[...[getCss$a()],css`:host{align-items:center;display:inline-flex;justify-content:center;position:relative;vertical-align:middle;fill:var(--iron-icon-fill-color,currentcolor);stroke:var(--iron-icon-stroke-color,none);width:var(--iron-icon-width,24px);height:var(--iron-icon-height,24px)}`])}let iconsetMap=null;class IconsetMap extends EventTarget{iconsets_=new Map;static getInstance(){return iconsetMap||(iconsetMap=new IconsetMap)}static resetInstanceForTesting(instance){iconsetMap=instance}get(id){return this.iconsets_.get(id)||null}set(id,iconset){assert(!this.iconsets_.has(id),`Tried to add a second iconset with id '${id}'`);this.iconsets_.set(id,iconset);this.dispatchEvent(new CustomEvent("cr-iconset-added",{detail:id}))}}class CrIconElement extends CrLitElement{static get is(){return"cr-icon"}static get styles(){return getCss$9()}static get properties(){return{icon:{type:String}}}#icon_accessor_storage="";get icon(){return this.#icon_accessor_storage}set icon(value){this.#icon_accessor_storage=value}iconsetName_="";iconName_="";iconset_=null;updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("icon")){const[iconsetName,iconName]=this.icon.split(":");this.iconName_=iconName||"";this.iconsetName_=iconsetName||"";this.updateIcon_()}}updateIcon_(){if(this.iconName_===""&&this.iconset_){this.iconset_.removeIcon(this)}else if(this.iconsetName_){const iconsetMap=IconsetMap.getInstance();this.iconset_=iconsetMap.get(this.iconsetName_);assert(this.iconset_,`Could not find iconset for: '${this.iconsetName_}:${this.iconName_}'`);this.iconset_.applyIcon(this,this.iconName_)}}}customElements.define(CrIconElement.is,CrIconElement);class EventTracker{listeners_=[];add(target,eventType,listener,capture=false){const h={target:target,eventType:eventType,listener:listener,capture:capture};this.listeners_.push(h);target.addEventListener(eventType,listener,capture)}remove(target,eventType){this.listeners_=this.listeners_.filter((listener=>{if(listener.target===target&&(!eventType||listener.eventType===eventType)){EventTracker.removeEventListener(listener);return false}return true}))}removeAll(){this.listeners_.forEach((listener=>EventTracker.removeEventListener(listener)));this.listeners_=[]}static removeEventListener(entry){entry.target.removeEventListener(entry.eventType,entry.listener,entry.capture)}}let instance$a=null;function getCss$8(){return instance$a||(instance$a=[...[],css`:host{bottom:0;display:block;left:0;overflow:hidden;pointer-events:none;position:absolute;right:0;top:0;transform:translate3d(0,0,0)}.ripple{background-color:currentcolor;left:0;opacity:var(--paper-ripple-opacity,0.25);pointer-events:none;position:absolute;will-change:height,transform,width}.ripple,:host(.circle){border-radius:50%}`])}class CrRippleElement extends CrLitElement{static get is(){return"cr-ripple"}static get styles(){return getCss$8()}static get properties(){return{holdDown:{type:Boolean},recenters:{type:Boolean},noink:{type:Boolean}}}#holdDown_accessor_storage=false;get holdDown(){return this.#holdDown_accessor_storage}set holdDown(value){this.#holdDown_accessor_storage=value}#recenters_accessor_storage=false;get recenters(){return this.#recenters_accessor_storage}set recenters(value){this.#recenters_accessor_storage=value}#noink_accessor_storage=false;get noink(){return this.#noink_accessor_storage}set noink(value){this.#noink_accessor_storage=value}ripples_=[];eventTracker_=new EventTracker;connectedCallback(){super.connectedCallback();assert(this.parentNode);const keyEventTarget=this.parentNode.nodeType===Node.DOCUMENT_FRAGMENT_NODE?this.parentNode.host:this.parentElement;this.eventTracker_.add(keyEventTarget,"pointerdown",(e=>this.uiDownAction(e)));this.eventTracker_.add(keyEventTarget,"pointerup",(()=>this.uiUpAction()));this.eventTracker_.add(keyEventTarget,"pointerout",(()=>this.uiUpAction()));this.eventTracker_.add(keyEventTarget,"keydown",(e=>{if(e.defaultPrevented){return}if(e.key==="Enter"){this.onEnterKeydown_();return}if(e.key===" "){this.onSpaceKeydown_()}}));this.eventTracker_.add(keyEventTarget,"keyup",(e=>{if(e.defaultPrevented){return}if(e.key===" "){this.onSpaceKeyup_()}}))}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll()}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("holdDown")){this.holdDownChanged_(this.holdDown,changedProperties.get("holdDown"))}}uiDownAction(e){if(e!==undefined&&e.button!==0){return}if(!this.noink){this.downAction_(e)}}downAction_(e){if(this.ripples_.length&&this.holdDown){return}this.showRipple_(e)}clear(){this.hideRipple_();this.holdDown=false}showAndHoldDown(){this.ripples_.forEach((ripple=>{ripple.remove()}));this.ripples_=[];this.holdDown=true}showRipple_(e){return}uiUpAction(){if(!this.noink){this.upAction_()}}upAction_(){if(!this.holdDown){this.hideRipple_()}}hideRipple_(){if(this.ripples_.length===0){return}this.ripples_.forEach((function(ripple){const opacity=ripple.computedStyleMap().get("opacity");if(opacity===null){ripple.remove();return}const animation=ripple.animate({opacity:[opacity.value,0]},{duration:150,fill:"forwards"});animation.finished.then((()=>{ripple.remove()}))}));this.ripples_=[]}onEnterKeydown_(){this.uiDownAction();window.setTimeout((()=>{this.uiUpAction()}),1)}onSpaceKeydown_(){this.uiDownAction()}onSpaceKeyup_(){this.uiUpAction()}holdDownChanged_(newHoldDown,oldHoldDown){if(oldHoldDown===undefined){return}if(newHoldDown){this.downAction_()}else{this.upAction_()}}}customElements.define(CrRippleElement.is,CrRippleElement);const CrRippleMixin=superClass=>{class CrRippleMixin extends superClass{static get properties(){return{noink:{type:Boolean}}}#noink_accessor_storage=false;get noink(){return this.#noink_accessor_storage}set noink(value){this.#noink_accessor_storage=value}rippleContainer=null;ripple_=null;updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("noink")&&this.hasRipple()){assert(this.ripple_);this.ripple_.noink=this.noink}}ensureRippleOnPointerdown(){this.addEventListener("pointerdown",(()=>this.ensureRipple()),{capture:true})}ensureRipple(){if(this.hasRipple()){return}this.ripple_=this.createRipple();this.ripple_.noink=this.noink;const rippleContainer=this.rippleContainer||this.shadowRoot;assert(rippleContainer);rippleContainer.appendChild(this.ripple_)}getRipple(){this.ensureRipple();assert(this.ripple_);return this.ripple_}hasRipple(){return Boolean(this.ripple_)}createRipple(){const ripple=document.createElement("cr-ripple");ripple.id="ink";return ripple}}return CrRippleMixin};const sheet$2=new CSSStyleSheet;sheet$2.replaceSync(`html{--google-blue-50-rgb:232,240,254;--google-blue-50:rgb(var(--google-blue-50-rgb));--google-blue-100-rgb:210,227,252;--google-blue-100:rgb(var(--google-blue-100-rgb));--google-blue-200-rgb:174,203,250;--google-blue-200:rgb(var(--google-blue-200-rgb));--google-blue-300-rgb:138,180,248;--google-blue-300:rgb(var(--google-blue-300-rgb));--google-blue-400-rgb:102,157,246;--google-blue-400:rgb(var(--google-blue-400-rgb));--google-blue-500-rgb:66,133,244;--google-blue-500:rgb(var(--google-blue-500-rgb));--google-blue-600-rgb:26,115,232;--google-blue-600:rgb(var(--google-blue-600-rgb));--google-blue-700-rgb:25,103,210;--google-blue-700:rgb(var(--google-blue-700-rgb));--google-blue-800-rgb:24,90,188;--google-blue-800:rgb(var(--google-blue-800-rgb));--google-blue-900-rgb:23,78,166;--google-blue-900:rgb(var(--google-blue-900-rgb));--google-green-50-rgb:230,244,234;--google-green-50:rgb(var(--google-green-50-rgb));--google-green-200-rgb:168,218,181;--google-green-200:rgb(var(--google-green-200-rgb));--google-green-300-rgb:129,201,149;--google-green-300:rgb(var(--google-green-300-rgb));--google-green-400-rgb:91,185,116;--google-green-400:rgb(var(--google-green-400-rgb));--google-green-500-rgb:52,168,83;--google-green-500:rgb(var(--google-green-500-rgb));--google-green-600-rgb:30,142,62;--google-green-600:rgb(var(--google-green-600-rgb));--google-green-700-rgb:24,128,56;--google-green-700:rgb(var(--google-green-700-rgb));--google-green-800-rgb:19,115,51;--google-green-800:rgb(var(--google-green-800-rgb));--google-green-900-rgb:13,101,45;--google-green-900:rgb(var(--google-green-900-rgb));--google-grey-50-rgb:248,249,250;--google-grey-50:rgb(var(--google-grey-50-rgb));--google-grey-100-rgb:241,243,244;--google-grey-100:rgb(var(--google-grey-100-rgb));--google-grey-200-rgb:232,234,237;--google-grey-200:rgb(var(--google-grey-200-rgb));--google-grey-300-rgb:218,220,224;--google-grey-300:rgb(var(--google-grey-300-rgb));--google-grey-400-rgb:189,193,198;--google-grey-400:rgb(var(--google-grey-400-rgb));--google-grey-500-rgb:154,160,166;--google-grey-500:rgb(var(--google-grey-500-rgb));--google-grey-600-rgb:128,134,139;--google-grey-600:rgb(var(--google-grey-600-rgb));--google-grey-700-rgb:95,99,104;--google-grey-700:rgb(var(--google-grey-700-rgb));--google-grey-800-rgb:60,64,67;--google-grey-800:rgb(var(--google-grey-800-rgb));--google-grey-900-rgb:32,33,36;--google-grey-900:rgb(var(--google-grey-900-rgb));--google-grey-900-white-4-percent:#292a2d;--google-purple-200-rgb:215,174,251;--google-purple-200:rgb(var(--google-purple-200-rgb));--google-purple-900-rgb:104,29,168;--google-purple-900:rgb(var(--google-purple-900-rgb));--google-red-100-rgb:244,199,195;--google-red-100:rgb(var(--google-red-100-rgb));--google-red-300-rgb:242,139,130;--google-red-300:rgb(var(--google-red-300-rgb));--google-red-500-rgb:234,67,53;--google-red-500:rgb(var(--google-red-500-rgb));--google-red-600-rgb:217,48,37;--google-red-600:rgb(var(--google-red-600-rgb));--google-red-700-rgb:197,57,41;--google-red-700:rgb(var(--google-red-700-rgb));--google-yellow-50-rgb:254,247,224;--google-yellow-50:rgb(var(--google-yellow-50-rgb));--google-yellow-100-rgb:254,239,195;--google-yellow-100:rgb(var(--google-yellow-100-rgb));--google-yellow-200-rgb:253,226,147;--google-yellow-200:rgb(var(--google-yellow-200-rgb));--google-yellow-300-rgb:253,214,51;--google-yellow-300:rgb(var(--google-yellow-300-rgb));--google-yellow-400-rgb:252,201,52;--google-yellow-400:rgb(var(--google-yellow-400-rgb));--google-yellow-500-rgb:251,188,4;--google-yellow-500:rgb(var(--google-yellow-500-rgb));--google-yellow-700-rgb:240,147,0;--google-yellow-700:rgb(var(--google-yellow-700-rgb));--cr-card-background-color:white;--cr-shadow-key-color_:color-mix(in srgb,var(--cr-shadow-color) 30%,transparent);--cr-shadow-ambient-color_:color-mix(in srgb,var(--cr-shadow-color) 15%,transparent);--cr-elevation-1:var(--cr-shadow-key-color_) 0 1px 2px 0,var(--cr-shadow-ambient-color_) 0 1px 3px 1px;--cr-elevation-2:var(--cr-shadow-key-color_) 0 1px 2px 0,var(--cr-shadow-ambient-color_) 0 2px 6px 2px;--cr-elevation-3:var(--cr-shadow-key-color_) 0 1px 3px 0,var(--cr-shadow-ambient-color_) 0 4px 8px 3px;--cr-elevation-4:var(--cr-shadow-key-color_) 0 2px 3px 0,var(--cr-shadow-ambient-color_) 0 6px 10px 4px;--cr-elevation-5:var(--cr-shadow-key-color_) 0 4px 4px 0,var(--cr-shadow-ambient-color_) 0 8px 12px 6px;--cr-card-shadow:var(--cr-elevation-2);--cr-focused-item-color:var(--google-grey-300);--cr-form-field-label-color:var(--google-grey-700);--cr-hairline-rgb:0,0,0;--cr-iph-anchor-highlight-color:rgba(var(--google-blue-600-rgb),0.1);--cr-menu-background-color:white;--cr-menu-background-focus-color:var(--google-grey-400);--cr-menu-shadow:var(--cr-elevation-2);--cr-separator-color:rgba(0,0,0,.06);--cr-title-text-color:rgb(90,90,90);--cr-scrollable-border-color:var(--google-grey-300)}@media (prefers-color-scheme:dark){html{--cr-card-background-color:var(--google-grey-900-white-4-percent);--cr-focused-item-color:var(--google-grey-800);--cr-form-field-label-color:var(--dark-secondary-color);--cr-hairline-rgb:255,255,255;--cr-iph-anchor-highlight-color:rgba(var(--google-grey-100-rgb),0.1);--cr-menu-background-color:var(--google-grey-900);--cr-menu-background-focus-color:var(--google-grey-700);--cr-menu-background-sheen:rgba(255,255,255,.06);--cr-menu-shadow:rgba(0,0,0,.3) 0 1px 2px 0,rgba(0,0,0,.15) 0 3px 6px 2px;--cr-separator-color:rgba(255,255,255,.1);--cr-title-text-color:var(--cr-primary-text-color);--cr-scrollable-border-color:var(--google-grey-700)}}@media (forced-colors:active){html{--cr-focus-outline-hcm:2px solid transparent;--cr-border-hcm:2px solid transparent}}html{--cr-button-edge-spacing:12px;--cr-controlled-by-spacing:24px;--cr-default-input-max-width:264px;--cr-icon-ripple-size:36px;--cr-icon-ripple-padding:8px;--cr-icon-size:20px;--cr-icon-button-margin-start:16px;--cr-icon-ripple-margin:calc(var(--cr-icon-ripple-padding) * -1);--cr-section-min-height:48px;--cr-section-two-line-min-height:64px;--cr-section-padding:20px;--cr-section-vertical-padding:12px;--cr-section-indent-width:40px;--cr-section-indent-padding:calc(var(--cr-section-padding) + var(--cr-section-indent-width));--cr-section-vertical-margin:21px;--cr-centered-card-max-width:680px;--cr-centered-card-width-percentage:0.96;--cr-hairline:1px solid rgba(var(--cr-hairline-rgb),.14);--cr-separator-height:1px;--cr-separator-line:var(--cr-separator-height) solid var(--cr-separator-color);--cr-toolbar-overlay-animation-duration:150ms;--cr-toolbar-height:56px;--cr-container-shadow-height:6px;--cr-container-shadow-margin:calc(-1 * var(--cr-container-shadow-height));--cr-container-shadow-max-opacity:1;--cr-card-border-radius:8px;--cr-disabled-opacity:.38;--cr-form-field-bottom-spacing:16px;--cr-form-field-label-font-size:.625rem;--cr-form-field-label-height:1em;--cr-form-field-label-line-height:1}html{--cr-fallback-color-outline:rgb(116,119,117);--cr-fallback-color-primary:rgb(11,87,208);--cr-fallback-color-on-primary:rgb(255,255,255);--cr-fallback-color-primary-container:rgb(211,227,253);--cr-fallback-color-on-primary-container:rgb(4,30,73);--cr-fallback-color-secondary-container:rgb(194,231,255);--cr-fallback-color-on-secondary-container:rgb(0,29,53);--cr-fallback-color-neutral-container:rgb(242,242,242);--cr-fallback-color-neutral-outline:rgb(199,199,199);--cr-fallback-color-surface:rgb(255,255,255);--cr-fallback-color-surface1:rgb(248,250,253);--cr-fallback-color-surface2:rgb(243,246,252);--cr-fallback-color-surface3:rgb(239,243,250);--cr-fallback-color-on-surface-rgb:31,31,31;--cr-fallback-color-on-surface:rgb(var(--cr-fallback-color-on-surface-rgb));--cr-fallback-color-surface-variant:rgb(225,227,225);--cr-fallback-color-on-surface-variant:rgb(138,141,140);--cr-fallback-color-on-surface-subtle:rgb(71,71,71);--cr-fallback-color-inverse-primary:rgb(168,199,250);--cr-fallback-color-inverse-surface:rgb(48,48,48);--cr-fallback-color-inverse-on-surface:rgb(242,242,242);--cr-fallback-color-tonal-container:rgb(211,227,253);--cr-fallback-color-on-tonal-container:rgb(4,30,73);--cr-fallback-color-tonal-outline:rgb(168,199,250);--cr-fallback-color-error:rgb(179,38,30);--cr-fallback-color-divider:rgb(211,227,253);--cr-fallback-color-state-hover-on-prominent_:rgba(253,252,251,.1);--cr-fallback-color-state-on-subtle-rgb_:31,31,31;--cr-fallback-color-state-hover-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.06);--cr-fallback-color-state-ripple-neutral-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.08);--cr-fallback-color-state-ripple-primary-rgb_:124,172,248;--cr-fallback-color-state-ripple-primary_:rgba(var(--cr-fallback-color-state-ripple-primary-rgb_),0.32);--cr-fallback-color-base-container:rgb(236,239,247);--cr-fallback-color-disabled-background:rgba(var(--cr-fallback-color-on-surface-rgb),.12);--cr-fallback-color-disabled-foreground:rgba(var(--cr-fallback-color-on-surface-rgb),var(--cr-disabled-opacity));--cr-hover-background-color:var(--color-sys-state-hover,rgba(var(--cr-fallback-color-on-surface-rgb),.08));--cr-hover-on-prominent-background-color:var(--color-sys-state-hover-on-prominent,var(--cr-fallback-color-state-hover-on-prominent_));--cr-hover-on-subtle-background-color:var(--color-sys-state-hover-on-subtle,var(--cr-fallback-color-state-hover-on-subtle_));--cr-active-background-color:var(--color-sys-state-pressed,rgba(var(--cr-fallback-color-on-surface-rgb),.12));--cr-active-on-primary-background-color:var(--color-sys-state-ripple-primary,var(--cr-fallback-color-state-ripple-primary_));--cr-active-neutral-on-subtle-background-color:var(--color-sys-state-ripple-neutral-on-subtle,var(--cr-fallback-color-state-ripple-neutral-on-subtle_));--cr-focus-outline-color:var(--color-sys-state-focus-ring,var(--owl-control-accent-color,var(--cr-fallback-color-primary)));--cr-focus-outline-inverse-color:var(--color-sys-state-focus-ring-inverse,var(--cr-fallback-color-inverse-primary));--cr-primary-text-color:var(--color-primary-foreground,var(--cr-fallback-color-on-surface));--cr-secondary-text-color:var(--color-secondary-foreground,var(--cr-fallback-color-on-surface-variant));--cr-link-color:var(--color-link-foreground-default,var(--cr-fallback-color-primary));--cr-button-height:36px;--cr-shadow-color:var(--color-sys-shadow,rgb(0,0,0));--cr-checked-color:var(--color-checkbox-foreground-checked,var(--owl-control-accent-color,var(--cr-fallback-color-primary)))}@media (prefers-color-scheme:dark){html{--cr-fallback-color-outline:rgb(142,145,143);--cr-fallback-color-primary:rgb(168,199,250);--cr-fallback-color-on-primary:rgb(6,46,111);--cr-fallback-color-primary-container:rgb(8,66,160);--cr-fallback-color-on-primary-container:rgb(211,227,253);--cr-fallback-color-secondary-container:rgb(0,74,119);--cr-fallback-color-on-secondary-container:rgb(194,231,255);--cr-fallback-color-neutral-container:rgb(40,40,40);--cr-fallback-color-neutral-outline:rgb(117,117,117);--cr-fallback-color-surface:rgb(31,31,31);--cr-fallback-color-surface1:rgb(39,40,42);--cr-fallback-color-surface2:rgb(45,47,49);--cr-fallback-color-surface3:rgb(51,52,56);--cr-fallback-color-on-surface-rgb:227,227,227;--cr-fallback-color-surface-variant:rgb(68,71,70);--cr-fallback-color-on-surface-variant:rgb(158,161,160);--cr-fallback-color-on-surface-subtle:rgb(199,199,199);--cr-fallback-color-inverse-primary:rgb(11,87,208);--cr-fallback-color-inverse-surface:rgb(227,227,227);--cr-fallback-color-inverse-on-surface:rgb(31,31,31);--cr-fallback-color-tonal-container:rgb(0,74,119);--cr-fallback-color-on-tonal-container:rgb(194,231,255);--cr-fallback-color-tonal-outline:rgb(4,125,183);--cr-fallback-color-error:rgb(242,184,181);--cr-fallback-color-divider:rgb(94,94,94);--cr-fallback-color-state-hover-on-prominent_:rgba(31,31,31,.06);--cr-fallback-color-state-on-subtle-rgb_:253,252,251;--cr-fallback-color-state-hover-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.10);--cr-fallback-color-state-ripple-neutral-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.16);--cr-fallback-color-state-ripple-primary-rgb_:76,141,246;--cr-fallback-color-base-container:rgba(40,40,40,1)}}@media (forced-colors:active){html{--cr-fallback-color-disabled-background:Canvas;--cr-fallback-color-disabled-foreground:GrayText}}`);document.adoptedStyleSheets=[...document.adoptedStyleSheets,sheet$2];let instance$9=null;function getCss$7(){return instance$9||(instance$9=[...[],css`:host{--cr-icon-button-fill-color:currentColor;--cr-icon-button-icon-start-offset:0;--cr-icon-button-icon-size:20px;--cr-icon-button-size:32px;--cr-icon-button-height:var(--cr-icon-button-size);--cr-icon-button-transition:150ms ease-in-out;--cr-icon-button-width:var(--cr-icon-button-size);-webkit-tap-highlight-color:transparent;border-radius:50%;color:var(--cr-icon-button-stroke-color,var(--cr-icon-button-fill-color));cursor:pointer;display:inline-flex;flex-shrink:0;height:var(--cr-icon-button-height);margin-inline-end:var(--cr-icon-button-margin-end,var(--cr-icon-ripple-margin));margin-inline-start:var(--cr-icon-button-margin-start);outline:none;overflow:hidden;position:relative;user-select:none;vertical-align:middle;width:var(--cr-icon-button-width)}:host(:hover){background-color:var(--cr-icon-button-hover-background-color,var(--cr-hover-background-color))}:host(:focus-visible:focus){box-shadow:inset 0 0 0 2px var(--cr-icon-button-focus-outline-color,var(--cr-focus-outline-color))}@media (forced-colors:active){:host(:focus-visible:focus){outline:var(--cr-focus-outline-hcm)}}#ink{--paper-ripple-opacity:1;color:var(--cr-icon-button-active-background-color,var(--cr-active-background-color))}:host([disabled]){cursor:initial;opacity:var(--cr-disabled-opacity);pointer-events:none}:host(.no-overlap){--cr-icon-button-margin-end:0;--cr-icon-button-margin-start:0}:host-context([dir=rtl]):host(:not([suppress-rtl-flip]):not([multiple-icons_])){transform:scaleX(-1)}:host-context([dir=rtl]):host(:not([suppress-rtl-flip])[multiple-icons_]) cr-icon{transform:scaleX(-1)}:host(:not([iron-icon])) #maskedImage{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-button-icon-size);-webkit-transform:var(--cr-icon-image-transform,none);background-color:var(--cr-icon-button-fill-color);height:100%;transition:background-color var(--cr-icon-button-transition);width:100%}@media (forced-colors:active){:host(:not([iron-icon])) #maskedImage{background-color:ButtonText}}#icon{align-items:center;border-radius:4px;display:flex;height:100%;justify-content:center;padding-inline-start:var(--cr-icon-button-icon-start-offset);position:relative;width:100%}cr-icon{--iron-icon-fill-color:var(--cr-icon-button-fill-color);--iron-icon-stroke-color:var(--cr-icon-button-stroke-color,none);--iron-icon-height:var(--cr-icon-button-icon-size);--iron-icon-width:var(--cr-icon-button-icon-size);transition:fill var(--cr-icon-button-transition),stroke var(--cr-icon-button-transition)}@media (prefers-color-scheme:dark){:host{--cr-icon-button-fill-color:var(--google-grey-500)}}`])}function getHtml$3(){return html`
<div id="icon">
  <div id="maskedImage"></div>
</div>`}const CrIconbuttonElementBase=CrRippleMixin(CrLitElement);class CrIconButtonElement extends CrIconbuttonElementBase{static get is(){return"cr-icon-button"}static get styles(){return getCss$7()}render(){return getHtml$3.bind(this)()}static get properties(){return{disabled:{type:Boolean,reflect:true},ironIcon:{type:String,reflect:true},suppressRtlFlip:{type:Boolean,value:false,reflect:true},multipleIcons_:{type:Boolean,reflect:true}}}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#ironIcon_accessor_storage;get ironIcon(){return this.#ironIcon_accessor_storage}set ironIcon(value){this.#ironIcon_accessor_storage=value}#multipleIcons__accessor_storage=false;get multipleIcons_(){return this.#multipleIcons__accessor_storage}set multipleIcons_(value){this.#multipleIcons__accessor_storage=value}spaceKeyDown_=false;constructor(){super();this.addEventListener("blur",this.onBlur_.bind(this));this.addEventListener("click",this.onClick_.bind(this));this.addEventListener("keydown",this.onKeyDown_.bind(this));this.addEventListener("keyup",this.onKeyUp_.bind(this));this.ensureRippleOnPointerdown()}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("ironIcon")){const icons=(this.ironIcon||"").split(",");this.multipleIcons_=icons.length>1}}firstUpdated(){if(!this.hasAttribute("role")){this.setAttribute("role","button")}if(!this.hasAttribute("tabindex")){this.setAttribute("tabindex","0")}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("disabled")){this.setAttribute("aria-disabled",this.disabled?"true":"false");this.disabledChanged_(this.disabled,changedProperties.get("disabled"))}if(changedProperties.has("ironIcon")){this.onIronIconChanged_()}}disabledChanged_(newValue,oldValue){if(!newValue&&oldValue===undefined){return}if(this.disabled){this.blur()}this.setAttribute("tabindex",String(this.disabled?-1:0))}onBlur_(){this.spaceKeyDown_=false}onClick_(e){if(this.disabled){e.stopImmediatePropagation()}}onIronIconChanged_(){this.shadowRoot.querySelectorAll("cr-icon").forEach((el=>el.remove()));if(!this.ironIcon){return}const icons=(this.ironIcon||"").split(",");icons.forEach((async icon=>{const crIcon=document.createElement("cr-icon");crIcon.icon=icon;this.$.icon.appendChild(crIcon);await crIcon.updateComplete;crIcon.shadowRoot.querySelectorAll("svg, img").forEach((child=>child.setAttribute("role","none")))}))}onKeyDown_(e){if(e.key!==" "&&e.key!=="Enter"){return}e.preventDefault();e.stopPropagation();if(e.repeat){return}if(e.key==="Enter"){this.click()}else if(e.key===" "){this.spaceKeyDown_=true}}onKeyUp_(e){if(e.key===" "||e.key==="Enter"){e.preventDefault();e.stopPropagation()}if(this.spaceKeyDown_&&e.key===" "){this.spaceKeyDown_=false;this.click()}}}customElements.define(CrIconButtonElement.is,CrIconButtonElement);const HOVERED_STYLE="hovered";const MouseHoverableMixinLit=superClass=>{class MouseHoverableMixinLit extends superClass{firstUpdated(changedProperties){super.firstUpdated(changedProperties);this.addEventListener("pointerenter",(e=>{const hostElement=e.currentTarget;hostElement.classList.toggle(HOVERED_STYLE,e.pointerType==="mouse")}));this.addEventListener("pointerleave",(e=>{if(e.pointerType!=="mouse"){return}const hostElement=e.currentTarget;hostElement.classList.remove(HOVERED_STYLE)}))}}return MouseHoverableMixinLit};const isAndroid=/Android/.test(navigator.userAgent);const isIOS=/CriOS/.test(navigator.userAgent);function getSupportedScaleFactors(){const supportedScaleFactors=[];if(!isIOS){supportedScaleFactors.push(1)}if(!isIOS&&!isAndroid){supportedScaleFactors.push(2)}else{supportedScaleFactors.push(window.devicePixelRatio)}return supportedScaleFactors}function getUrlForCss(s){const s2=s.replace(/(\(|\)|\,|\s|\'|\"|\\)/g,"\\$1");return`url("${s2}")`}function getImageSet(path){const supportedScaleFactors=getSupportedScaleFactors();const replaceStartIndex=path.indexOf("SCALEFACTOR");if(replaceStartIndex<0){return getUrlForCss(path)}let s="";for(let i=0;i<supportedScaleFactors.length;++i){const scaleFactor=supportedScaleFactors[i];const pathWithScaleFactor=path.substr(0,replaceStartIndex)+scaleFactor+path.substr(replaceStartIndex+"scalefactor".length);s+=getUrlForCss(pathWithScaleFactor)+" "+scaleFactor+"x";if(i!==supportedScaleFactors.length-1){s+=", "}}return"image-set("+s+")"}function getBaseFaviconUrl(){const faviconUrl=new URL("chrome://favicon2/");faviconUrl.searchParams.set("size","16");faviconUrl.searchParams.set("scaleFactor","SCALEFACTORx");return faviconUrl}function getDefaultFaviconUrlParams(){return{isSyncedUrlForHistoryUi:false,remoteIconUrlForUma:"",size:16,forceLightMode:false,fallbackToHost:true,forceEmptyDefaultFavicon:false,scaleFactor:""}}function getFaviconUrl(url,optionalParams){const params=Object.assign(getDefaultFaviconUrlParams(),optionalParams);const faviconUrl=getBaseFaviconUrl();faviconUrl.searchParams.set("pageUrl",url);faviconUrl.searchParams.set("size",params.size.toString());const fallback=params.isSyncedUrlForHistoryUi?"1":"0";faviconUrl.searchParams.set("allowGoogleServerFallback",fallback);if(params.isSyncedUrlForHistoryUi){faviconUrl.searchParams.set("iconUrl",params.remoteIconUrlForUma)}if(params.forceLightMode){faviconUrl.searchParams.set("forceLightMode","true")}if(!params.fallbackToHost){faviconUrl.searchParams.set("fallbackToHost","0")}if(params.forceEmptyDefaultFavicon){faviconUrl.searchParams.set("forceEmptyDefaultFavicon","1")}if(params.scaleFactor){faviconUrl.searchParams.set("scaleFactor",params.scaleFactor)}return faviconUrl.toString()}function getFaviconForPageURL(url,isSyncedUrlForHistoryUi,remoteIconUrlForUma="",size=16,forceLightMode=false,fallbackToHost=true,forceEmptyDefaultFavicon=false,scaleFactor=""){return getImageSet(getFaviconUrl(url,{isSyncedUrlForHistoryUi:isSyncedUrlForHistoryUi,remoteIconUrlForUma:remoteIconUrlForUma,size:size,forceLightMode:forceLightMode,fallbackToHost:fallbackToHost,forceEmptyDefaultFavicon:forceEmptyDefaultFavicon,scaleFactor:scaleFactor}))}const WRAPPER_CSS_CLASS="search-highlight-wrapper";const ORIGINAL_CONTENT_CSS_CLASS="search-highlight-original-content";const HIT_CSS_CLASS="search-highlight-hit";function highlight(node,ranges){assert(ranges.length>0);const wrapper=document.createElement("span");wrapper.classList.add(WRAPPER_CSS_CLASS);assert(node.parentNode);node.parentNode.replaceChild(wrapper,node);const span=document.createElement("span");span.classList.add(ORIGINAL_CONTENT_CSS_CLASS);span.style.display="none";span.appendChild(node);wrapper.appendChild(span);const text=node.textContent;const tokens=[];for(let i=0;i<ranges.length;++i){const range=ranges[i];const prev=ranges[i-1]||{start:0,length:0};const start=prev.start+prev.length;const length=range.start-start;tokens.push(text.substr(start,length));tokens.push(text.substr(range.start,range.length))}const last=ranges.slice(-1)[0];tokens.push(text.substr(last.start+last.length));for(let i=0;i<tokens.length;++i){if(i%2===0){wrapper.appendChild(document.createTextNode(tokens[i]))}else{const hitSpan=document.createElement("span");hitSpan.classList.add(HIT_CSS_CLASS);hitSpan.style.backgroundColor="var(--search-highlight-hit-background-color, #ffeb3b)";hitSpan.style.color="var(--search-highlight-hit-color, #202124)";hitSpan.textContent=tokens[i];wrapper.appendChild(hitSpan)}}return wrapper}function highlightText(container,text,ranges){container.textContent="";const node=document.createTextNode(text);container.appendChild(node);if(ranges){highlight(node,ranges)}}function tabHasMediaAlerts(tab){return tab.alertStates.length>0}const TabAlertStateSpec={$:mojo.internal.Enum()};var TabAlertState;(function(TabAlertState){TabAlertState[TabAlertState["MIN_VALUE"]=0]="MIN_VALUE";TabAlertState[TabAlertState["MAX_VALUE"]=16]="MAX_VALUE";TabAlertState[TabAlertState["kAudioMuting"]=0]="kAudioMuting";TabAlertState[TabAlertState["kAudioRecording"]=1]="kAudioRecording";TabAlertState[TabAlertState["kAudioPlaying"]=2]="kAudioPlaying";TabAlertState[TabAlertState["kBluetoothConnected"]=3]="kBluetoothConnected";TabAlertState[TabAlertState["kBluetoothScanActive"]=4]="kBluetoothScanActive";TabAlertState[TabAlertState["kDesktopCapturing"]=5]="kDesktopCapturing";TabAlertState[TabAlertState["kActorAccessing"]=6]="kActorAccessing";TabAlertState[TabAlertState["kGlicAccessing"]=7]="kGlicAccessing";TabAlertState[TabAlertState["kGlicSharing"]=8]="kGlicSharing";TabAlertState[TabAlertState["kHidConnected"]=9]="kHidConnected";TabAlertState[TabAlertState["kMediaRecording"]=10]="kMediaRecording";TabAlertState[TabAlertState["kPipPlaying"]=11]="kPipPlaying";TabAlertState[TabAlertState["kSerialConnected"]=12]="kSerialConnected";TabAlertState[TabAlertState["kTabCapturing"]=13]="kTabCapturing";TabAlertState[TabAlertState["kUsbConnected"]=14]="kUsbConnected";TabAlertState[TabAlertState["kVideoRecording"]=15]="kVideoRecording";TabAlertState[TabAlertState["kVrPresentingInHeadset"]=16]="kVrPresentingInHeadset"})(TabAlertState||(TabAlertState={}));({$:mojo.internal.Enum()});var TabNetworkState;(function(TabNetworkState){TabNetworkState[TabNetworkState["MIN_VALUE"]=0]="MIN_VALUE";TabNetworkState[TabNetworkState["MAX_VALUE"]=3]="MAX_VALUE";TabNetworkState[TabNetworkState["kNone"]=0]="kNone";TabNetworkState[TabNetworkState["kWaiting"]=1]="kWaiting";TabNetworkState[TabNetworkState["kLoading"]=2]="kLoading";TabNetworkState[TabNetworkState["kError"]=3]="kError"})(TabNetworkState||(TabNetworkState={}));var TabItemType;(function(TabItemType){TabItemType[TabItemType["OPEN_TAB"]=1]="OPEN_TAB";TabItemType[TabItemType["RECENTLY_CLOSED_TAB"]=2]="RECENTLY_CLOSED_TAB";TabItemType[TabItemType["RECENTLY_CLOSED_TAB_GROUP"]=3]="RECENTLY_CLOSED_TAB_GROUP"})(TabItemType||(TabItemType={}));class ItemData{inActiveWindow=false;type=TabItemType.OPEN_TAB;a11yTypeText="";tabGroup;highlightRanges={}}class TabData extends ItemData{tab;hostname;constructor(tab,type,hostname){super();this.tab=tab;this.type=type;this.hostname=hostname}}class TabGroupData extends ItemData{tabGroup;constructor(tabGroup){super();this.tabGroup=tabGroup;this.type=TabItemType.RECENTLY_CLOSED_TAB_GROUP}}function tokenToString(token){return`${token.high.toString()}#${token.low.toString()}`}function tokenEquals(a,b){return a.high===b.high&&a.low===b.low}function titleAndAlertAriaLabel(tabData){const tabTitle=tabData.tab.title;if(tabData.type===TabItemType.OPEN_TAB&&tabHasMediaAlerts(tabData.tab)){const alert=tabData.tab.alertStates[0];switch(alert){case TabAlertState.kMediaRecording:return loadTimeData.getStringF("mediaRecording",tabTitle);case TabAlertState.kAudioRecording:return loadTimeData.getStringF("audioRecording",tabTitle);case TabAlertState.kVideoRecording:return loadTimeData.getStringF("videoRecording",tabTitle);case TabAlertState.kAudioPlaying:return loadTimeData.getStringF("audioPlaying",tabTitle);case TabAlertState.kAudioMuting:return loadTimeData.getStringF("audioMuting",tabTitle);default:return tabTitle}}return tabTitle}function ariaLabel(itemData){if(itemData instanceof TabGroupData&&itemData.type===TabItemType.RECENTLY_CLOSED_TAB_GROUP){const tabGroup=itemData.tabGroup;const tabCountText=loadTimeData.getStringF(tabGroup.tabCount===1?"oneTab":"tabCount",tabGroup.tabCount);return`${tabGroup.title} ${tabCountText} ${tabGroup.lastActiveElapsedText} ${itemData.a11yTypeText}`}if(itemData instanceof TabData){const tabData=itemData;const groupTitleOrEmpty=tabData.tabGroup?tabData.tabGroup.title:"";const titleAndAlerts=titleAndAlertAriaLabel(tabData);return`${titleAndAlerts} ${groupTitleOrEmpty} ${tabData.hostname} ${tabData.tab.lastActiveElapsedText} ${tabData.a11yTypeText}`}throw new Error("Invalid data provided.")}function normalizeURL(url){return url||"about:blank"}function getTitle(data){if(data.type===TabItemType.RECENTLY_CLOSED_TAB_GROUP){return undefined}return data.tab.title}function getHostname(data){if(data.type===TabItemType.RECENTLY_CLOSED_TAB_GROUP){return undefined}return data.hostname}function getTabGroupTitle(data){return data.tabGroup?.title}const sheet$1=new CSSStyleSheet;sheet$1.replaceSync(`html{--google-blue-300-rgb:123,170,247;--google-blue-300:rgb(var(--google-blue-300-rgb));--google-cyan-300-rgb:120,217,236;--google-cyan-300:rgb(var(--google-cyan-300-rgb));--google-cyan-900-rgb:0,123,131;--google-cyan-900:rgb(var(--google-cyan-900-rgb));--google-green-300-rgb:87,187,138;--google-green-300:rgb(var(--google-green-300-rgb));--google-green-600-rgb:30,142,62;--google-green-600:rgb(var(--google-green-600-rgb));--google-pink-300-rgb:255,139,203;--google-pink-300:rgb(var(--google-pink-300-rgb));--google-pink-700-rgb:208,24,132;--google-pink-700:rgb(var(--google-pink-700-rgb));--google-purple-200-rgb:215,174,251;--google-purple-200:rgb(var(--google-purple-200-rgb));--google-purple-600-rgb:147,52,230;--google-purple-600:rgb(var(--google-purple-600-rgb));--google-red-300-rgb:230,124,115;--google-red-300:rgb(var(--google-red-300-rgb));--google-yellow-300-rgb:247,203,77;--google-yellow-300:rgb(var(--google-yellow-300-rgb));--google-yellow-900-rgb:227,116,0;--google-yellow-900:rgb(var(--google-yellow-900-rgb));--google-orange-300-rgb:252,173,112;--google-orange-300:rgb(var(--google-orange-300-rgb));--google-orange-400-rgb:250,144,62;--google-orange-400:rgb(var(--google-orange-400-rgb));--tab-group-color-grey:var(--google-grey-700);--tab-group-color-blue:var(--google-blue-600);--tab-group-color-red:var(--google-red-600);--tab-group-color-yellow:var(--google-yellow-900);--tab-group-color-green:var(--google-green-600);--tab-group-color-pink:var(--google-pink-700);--tab-group-color-purple:var(--google-purple-600);--tab-group-color-cyan:var(--google-cyan-900);--tab-group-color-orange:var(--google-orange-400)}@media (prefers-color-scheme:dark){html{--tab-group-color-grey:var(--google-grey-400);--tab-group-color-blue:var(--google-blue-300);--tab-group-color-red:var(--google-red-300);--tab-group-color-yellow:var(--google-yellow-300);--tab-group-color-green:var(--google-green-300);--tab-group-color-pink:var(--google-pink-300);--tab-group-color-purple:var(--google-purple-200);--tab-group-color-cyan:var(--google-cyan-300);--tab-group-color-orange:var(--google-orange-300)}}`);document.adoptedStyleSheets=[...document.adoptedStyleSheets,sheet$1];const ColorSpec={$:mojo.internal.Enum()};var Color;(function(Color){Color[Color["MIN_VALUE"]=0]="MIN_VALUE";Color[Color["MAX_VALUE"]=8]="MAX_VALUE";Color[Color["kGrey"]=0]="kGrey";Color[Color["kBlue"]=1]="kBlue";Color[Color["kRed"]=2]="kRed";Color[Color["kYellow"]=3]="kYellow";Color[Color["kGreen"]=4]="kGreen";Color[Color["kPink"]=5]="kPink";Color[Color["kPurple"]=6]="kPurple";Color[Color["kCyan"]=7]="kCyan";Color[Color["kOrange"]=8]="kOrange"})(Color||(Color={}));const colorMap=new Map([[Color.kGrey,"grey"],[Color.kBlue,"blue"],[Color.kRed,"red"],[Color.kYellow,"yellow"],[Color.kGreen,"green"],[Color.kPink,"pink"],[Color.kPurple,"purple"],[Color.kCyan,"cyan"],[Color.kOrange,"orange"]]);function colorName(color){if(!colorMap.has(color)){throw Error("Undefined color id")}return colorMap.get(color)}const sheet=new CSSStyleSheet;sheet.replaceSync(`html{--mwb-background-color:white;--mwb-icon-button-fill-color:var(--google-grey-700);--mwb-icon-size:16px;--mwb-item-height:48px;--mwb-list-item-horizontal-margin:20px;--mwb-list-item-hover-background-color:rgba(var(--google-grey-900-rgb),0.1);--mwb-list-item-selected-background-color:rgba(var(--google-grey-900-rgb),0.14);--mwb-list-section-title-font-size:11px;--mwb-list-section-title-height:48px;--mwb-primary-text-font-size:13px;--mwb-primary-text-font-weight:normal;--mwb-scrollbar-thumb-color:var(--google-grey-300);--mwb-scrollbar-thumb-hover-color:var(--google-grey-500);--mwb-scrollbar-track-color:var(--mwb-background-color);--mwb-scrollbar-width:4px;--mwb-secondary-text-font-size:12px;--mwb-secondary-text-font-weight:normal}@media (prefers-color-scheme:dark){html{--mwb-background-color:var(--google-grey-900);--mwb-icon-button-fill-color:var(--google-grey-300);--mwb-list-item-hover-background-color:rgb(55,56,58);--mwb-list-item-selected-background-color:rgb(68,69,71);--mwb-scrollbar-thumb-color:var(--google-grey-500);--mwb-scrollbar-thumb-hover-color:var(--google-grey-300)}}`);document.adoptedStyleSheets=[...document.adoptedStyleSheets,sheet];let instance$8=null;function getCss$6(){return instance$8||(instance$8=[...[],css`a,cr-button,cr-icon-button,div{cursor:default}cr-icon-button{--cr-icon-button-icon-size:var(--mwb-icon-size);--cr-icon-button-size:calc(var(--mwb-icon-size) * 1.5)}`])}let instance$7=null;function getCss$5(){return instance$7||(instance$7=[...[],css`:host{display:none}`])}function getHtml$2(){return html`
<svg id="baseSvg" xmlns="http://www.w3.org/2000/svg"
     viewBox="0 0 ${this.size} ${this.size}"
     preserveAspectRatio="xMidYMid meet" focusable="false"
     style="pointer-events: none; display: block; width: 100%; height: 100%;">
 </svg>
<slot></slot>
`}const APPLIED_ICON_CLASS="cr-iconset-svg-icon_";class CrIconsetElement extends CrLitElement{static get is(){return"cr-iconset"}static get styles(){return getCss$5()}render(){return getHtml$2.bind(this)()}static get properties(){return{name:{type:String},size:{type:Number}}}#name_accessor_storage="";get name(){return this.#name_accessor_storage}set name(value){this.#name_accessor_storage=value}#size_accessor_storage=24;get size(){return this.#size_accessor_storage}set size(value){this.#size_accessor_storage=value}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("name")){assert(changedProperties.get("name")===undefined);IconsetMap.getInstance().set(this.name,this)}}applyIcon(element,iconName){this.removeIcon(element);const svg=this.cloneIcon_(iconName);if(svg){svg.classList.add(APPLIED_ICON_CLASS);element.shadowRoot.insertBefore(svg,element.shadowRoot.childNodes[0]);return svg}return null}createIcon(iconName){return this.cloneIcon_(iconName)}removeIcon(element){const oldSvg=element.shadowRoot.querySelector(`.${APPLIED_ICON_CLASS}`);if(oldSvg){oldSvg.remove()}}cloneIcon_(id){const sourceSvg=this.querySelector(`g[id="${id}"]`);if(!sourceSvg){return null}const svgClone=this.$.baseSvg.cloneNode(true);const content=sourceSvg.cloneNode(true);content.removeAttribute("id");const contentViewBox=content.getAttribute("viewBox");if(contentViewBox){svgClone.setAttribute("viewBox",contentViewBox)}svgClone.appendChild(content);return svgClone}}customElements.define(CrIconsetElement.is,CrIconsetElement);function isValidArray(arr){if(arr instanceof Array&&Object.isFrozen(arr)){return true}return false}function getStaticString(literal){const isStaticString=isValidArray(literal)&&!!literal.raw&&isValidArray(literal.raw)&&literal.length===literal.raw.length&&literal.length===1;assert(isStaticString,"static_types.js only allows static strings");return literal.join("")}function createTypes(_ignore,literal){return getStaticString(literal)}const rules={createHTML:createTypes,createScript:createTypes,createScriptURL:createTypes};let staticPolicy;if(window.trustedTypes){staticPolicy=window.trustedTypes.createPolicy("static-types",rules)}else{staticPolicy=rules}function getTrustedHTML(literal){return staticPolicy.createHTML("",literal)}const div=document.createElement("div");div.innerHTML=getTrustedHTML`<cr-iconset name="tab-search" size="16">
  <svg>
    <defs>
      <g id="auto-tab-groups">
        <path d="M5.2 2.8v6-.316 2.317ZM2.8 14.399c-.331 0-.612-.117-.847-.351a1.153 1.153 0 0 1-.351-.848V4H2.8v9.2H12v1.198ZM5.2 12a1.16 1.16 0 0 1-.848-.352A1.16 1.16 0 0 1 4 10.801v-8c0-.332.117-.614.352-.848a1.16 1.16 0 0 1 .847-.351h3.016c-.152.175-.29.363-.406.562a4.37 4.37 0 0 0-.309.637H5.2v8h8V8.484c.226-.09.44-.195.636-.308.2-.117.387-.254.562-.41V10.8c0 .328-.117.613-.351.847a1.153 1.153 0 0 1-.848.352Zm6.402-4c0-1.004-.352-1.855-1.051-2.55C9.855 4.75 9.004 4.397 8 4.397c1.004 0 1.855-.347 2.55-1.046.7-.696 1.052-1.547 1.052-2.551 0 1.004.347 1.855 1.046 2.55.696.7 1.547 1.047 2.551 1.047-1.004 0-1.855.352-2.55 1.051-.7.696-1.047 1.547-1.047 2.551m0 0">
        </path>
      </g>
      <g id="close">
        <path d="M13 4.00714L11.9929 3L8 6.99286L4.00714 3L3 4.00714L6.99286 8L3 11.9929L4.00714 13L8 9.00714L11.9929 13L13 11.9929L9.00714 8L13 4.00714Z">
        </path>
      </g>
      <g id="declutter">
        <path d="M9.2 14.398V13.2h2.402v1.2Zm-3.598 0V13.2H8v1.2ZM2.8 6.801H1.6V4.398h1.2Zm0 3.597H1.6V8h1.2Zm1.597 4H2.801c-.332 0-.614-.117-.848-.351a1.153 1.153 0 0 1-.351-.848v-1.597H2.8v1.597h1.597ZM7.648 9.2 9.2 7.65l1.551 1.55.852-.847L10.05 6.8 11.6 5.25l-.851-.852L9.2 5.95 7.647 4.4l-.847.851L8.35 6.8l-1.55 1.552ZM5.2 12a1.16 1.16 0 0 1-.847-.352A1.16 1.16 0 0 1 4 10.801v-8c0-.332.117-.614.352-.848a1.16 1.16 0 0 1 .847-.351h8c.332 0 .614.117.848.351.234.234.351.516.351.848v8c0 .328-.117.613-.351.847a1.153 1.153 0 0 1-.848.352Zm0-1.2h8v-8h-8Zm0-8v8Zm0 0">
        </path>
      </g>
      <g id="frame">
        <path d="M3.6 11.517a6.273 6.273 0 0 1 2.067-1.134A7.236 7.236 0 0 1 8 10c.8 0 1.578.122 2.333.367a6.117 6.117 0 0 1 2.067 1.15V3.6H3.6zM8 9.2c.667 0 1.233-.233 1.7-.7.467-.467.7-1.033.7-1.7s-.233-1.233-.7-1.7A2.314 2.314 0 0 0 8 4.4c-.667 0-1.233.233-1.7.7a2.314 2.314 0 0 0-.7 1.7c0 .667.233 1.233.7 1.7.467.467 1.033.7 1.7.7m-4.4 4.4c-.333 0-.617-.117-.85-.35a1.157 1.157 0 0 1-.35-.85V3.6c0-.333.117-.617.35-.85.233-.233.517-.35.85-.35h8.8c.333 0 .617.117.85.35.233.233.35.517.35.85v8.8c0 .333-.117.617-.35.85-.233.233-.517.35-.85.35zm.817-1.2h7.166a5.676 5.676 0 0 0-1.683-.883A5.778 5.778 0 0 0 8 11.2c-.656 0-1.289.106-1.9.317-.6.2-1.161.494-1.683.883M8 8c-.333 0-.617-.117-.85-.35a1.157 1.157 0 0 1-.35-.85c0-.333.117-.617.35-.85.233-.233.517-.35.85-.35.333 0 .617.117.85.35.233.233.35.517.35.85 0 .333-.117.617-.35.85-.233.233-.517.35-.85.35">
        </path>
      </g>
      <g id="google">
        <path d="M8 14.4a6.28 6.28 0 0 1-2.5-.5 6.42 6.42 0 0 1-2.033-1.367A6.42 6.42 0 0 1 2.1 10.5 6.279 6.279 0 0 1 1.6 8c0-.889.167-1.717.5-2.483a6.421 6.421 0 0 1 1.367-2.034A6.287 6.287 0 0 1 5.5 2.1 6.279 6.279 0 0 1 8 1.6c.8 0 1.561.144 2.283.433.734.29 1.4.7 2 1.234l-1.816 1.766a3.724 3.724 0 0 0-1.134-.7A3.599 3.599 0 0 0 8 4.083c-1.078 0-1.989.39-2.733 1.167A3.81 3.81 0 0 0 4.15 8c0 1.078.372 2 1.117 2.767.744.766 1.655 1.15 2.733 1.15.9 0 1.672-.25 2.317-.75.655-.511 1.055-1.161 1.2-1.95H8V6.833h6c.056.234.094.456.117.667.022.211.033.428.033.65 0 1.878-.567 3.389-1.7 4.533C11.317 13.828 9.833 14.4 8 14.4">
        </path>
      </g>
      <g id="plant">
        <path d="M7.4 13.6V8.65h-.15a4.933 4.933 0 0 1-1.833-.35 4.983 4.983 0 0 1-1.55-1.033 4.726 4.726 0 0 1-1.1-1.584A4.944 4.944 0 0 1 2.4 3.8V2.4h1.4c.633 0 1.239.122 1.817.367a4.748 4.748 0 0 1 1.55 1.016c.322.311.589.661.8 1.05.222.378.389.778.5 1.2a4.116 4.116 0 0 1 1.633-1.35 4.767 4.767 0 0 1 2.1-.483h1.4v1.4c0 .656-.128 1.283-.383 1.883a4.527 4.527 0 0 1-1.084 1.584 4.96 4.96 0 0 1-1.483.9 4.661 4.661 0 0 1-1.7.316H8.6V13.6zm0-6.2a4.22 4.22 0 0 0-.267-1.483 3.247 3.247 0 0 0-2.05-2.05A4.22 4.22 0 0 0 3.6 3.6c0 .511.083 1.011.25 1.5.178.478.444.894.8 1.25.356.356.772.622 1.25.8.489.167.989.25 1.5.25m1.2 1.8c.511 0 1.006-.083 1.483-.25a3.42 3.42 0 0 0 1.267-.8c.356-.356.617-.772.783-1.25.178-.489.267-.989.267-1.5-.511 0-1.011.089-1.5.267a3.267 3.267 0 0 0-1.25.783 3.419 3.419 0 0 0-.8 1.267c-.167.477-.25.972-.25 1.483">
        </path>
      </g>
      <g id="remove">
        <path d="M4.667 8.666h6.667V7.333H4.667zm3.334 6a6.492 6.492 0 0 1-2.6-.525 6.732 6.732 0 0 1-2.117-1.425A6.732 6.732 0 0 1 1.859 10.6 6.492 6.492 0 0 1 1.334 8c0-.923.175-1.79.525-2.6a6.732 6.732 0 0 1 1.425-2.117c.6-.6 1.306-1.075 2.117-1.425A6.492 6.492 0 0 1 8 1.333c.922 0 1.789.175 2.6.525.81.35 1.516.825 2.116 1.425.6.6 1.075 1.306 1.425 2.117.35.81.525 1.677.525 2.6 0 .922-.175 1.789-.525 2.6a6.732 6.732 0 0 1-1.425 2.116c-.6.6-1.305 1.075-2.116 1.425a6.492 6.492 0 0 1-2.6.525m0-1.333c1.489 0 2.75-.517 3.783-1.55s1.55-2.294 1.55-3.783c0-1.49-.517-2.75-1.55-3.784-1.033-1.033-2.294-1.55-3.783-1.55-1.49 0-2.75.517-3.784 1.55C3.184 5.25 2.667 6.511 2.667 8c0 1.489.517 2.75 1.55 3.783 1.034 1.033 2.295 1.55 3.784 1.55">
        </path>
      </g>
      <g id="search">
        <path fill-rule="evenodd" clip-rule="evenodd"
            d="M10.8619 10.2981L10.6177 10.0578C11.484 9.05905 12.0874 7.68174 12.0874 5.97468C12.0874 2.82136 9.23365 0 6.04368 0C2.85486 0 0 2.82136 0 5.97468C0 9.12687 3.45353 11.9462 6.17606 11.9482C7.77044 11.9494 9.0094 11.5085 9.98871 10.6796L10.2341 10.921V11.6156L14.6752 16L16 14.6904L11.5681 10.2981H10.8619ZM6.04422 10.2423C3.65985 10.2423 1.72676 8.33212 1.72676 5.97468C1.72676 3.61724 3.65985 1.70705 6.04422 1.70705C8.42749 1.70705 10.3606 3.61724 10.3606 5.97468C10.3606 8.33212 8.42749 10.2423 6.04422 10.2423V10.2423Z">
        </path>
      </g>
    </defs>
  </svg>
</cr-iconset>
`;const iconsets=div.querySelectorAll("cr-iconset");for(const iconset of iconsets){document.head.appendChild(iconset)}let instance$6=null;function getCss$4(){return instance$6||(instance$6=[...[getCss$6()],css`:host{--audio-icon-color:var(--color-tab-search-media-icon);--glic-active-icon-color:var(--color-tab-search-media-glic-active-icon);--media-recording-icon-color:var(--color-tab-search-media-recording-icon)}:host([size=large]){--mwb-item-height:66px}:host(:focus){outline:none}:host(:is(.hovered,.selected)) .button-container{height:auto;overflow:visible;visibility:visible;width:auto}@media (forced-colors:active){:host(:is(.hovered,.selected)){border:1px solid ActiveBorder}}.button-container{height:0;margin-inline-start:2px;overflow:hidden;width:0}.button-container.allocate-space-while-hidden{height:auto;overflow:visible;visibility:hidden;width:auto}.button-container cr-icon-button{--cr-icon-button-fill-color:var(--mwb-icon-button-fill-color)}.favicon{background-repeat:no-repeat;background-size:var(--mwb-icon-size);flex-shrink:0;height:var(--mwb-icon-size);width:var(--mwb-icon-size)}.text-container{flex-grow:1;overflow:hidden;user-select:none}#groupTitle,#primaryText,#secondaryText{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}#secondaryText{direction:rtl}#primaryText{color:var(--cr-primary-text-color);font-size:var(--mwb-primary-text-font-size);font-weight:var(--mwb-primary-text-font-weight)}#secondaryContainer{align-items:center;color:var(--cr-secondary-text-color);display:flex;font-size:var(--mwb-secondary-text-font-size);font-weight:var(--mwb-secondary-text-font-weight)}:host([size=compact]) #secondaryContainer{display:none}#primaryContainer{display:flex;gap:3px}#secondaryTimestamp{flex-shrink:0}#textAriaLabel{clip:rect(0,0,0,0);display:inline-block;position:fixed}.separator{margin-inline-end:4px;margin-inline-start:4px}cr-icon-button{--cr-icon-button-margin-end:0;--cr-icon-button-margin-start:0}.search-highlight-hit{--search-highlight-hit-background-color:none;--search-highlight-hit-color:none;font-weight:bold}#groupSvg{flex-shrink:0;height:8px;margin-inline-end:6px;width:8px}#groupDot{fill:var(--group-dot-color)}#mediaAlert[display='block']{-webkit-mask:center/contain no-repeat;flex-shrink:0;height:var(--mwb-icon-size);margin-inline-end:8px;margin-inline-start:4px;width:var(--mwb-icon-size)}#mediaAlert[class='media-recording'],#mediaAlert[class='audio-recording'],#mediaAlert[class='video-recording']{-webkit-mask-image:url(alert_indicators/tab_media_recording.svg);background-color:var(--media-recording-icon-color)}#mediaAlert[class='audio-playing']{-webkit-mask-image:url(alert_indicators/tab_audio_rounded.svg);background-color:var(--audio-icon-color)}#mediaAlert[class='audio-muting']{-webkit-mask-image:url(alert_indicators/tab_audio_muting_rounded.svg);background-color:var(--audio-icon-color)}#mediaAlert[class='glic-accessing']{-webkit-mask-image:url(alert_indicators/tab_media_glic_active.svg);background-color:var(--glic-active-icon-color)}#iconContainer{align-items:center;background:var(--tab-search-favicon-background,var(--color-list-item-url-favicon-background));border-radius:8px;display:flex;flex-shrink:0;height:40px;justify-content:center;overflow:hidden;margin-inline-end:var(--tab-search-item-icon-margin,16px);width:40px}:host([size=compact]) #iconContainer{height:24px;width:24px}:host([size=large]) #iconContainer{height:56px;width:56px}`])}function getHtml$1(){return html`<!--_html_template_start_-->
<div id="iconContainer">
  <div class="favicon" .style="background-image:${this.faviconUrl_()}"></div>
</div>
<div class="text-container" aria-hidden="true">
  <div id="primaryContainer">
    <div id="primaryText" title="${this.data.tab.title}"></div>
    <img id="mediaAlert" display="${this.mediaAlertVisibility_()}"
        class="${this.getMediaAlertImageClass_()}">
  </div>
  <div id="secondaryContainer">
    <!-- We do not leverage a dom-if element as the element highlighting logic
        may trigger before the stamping has taken place -->
    <svg id="groupSvg" viewBox="-5 -5 10 10" xmlns="http://www.w3.org/2000/svg"
        display="${this.groupSvgDisplay_()}">
      <circle id= "groupDot" cx="0" cy="0" r="4">
    </svg>
    ${this.hasTabGroupWithTitle_()?html`
      <div id="groupTitle"></div>
      <div class="separator">•</div>
    `:""}
    <div id="secondaryText" ?hidden="${this.hideUrl}"></div>
    ${!this.hideTimestamp?html`
      <div class="separator" ?hidden="${!this.data.hostname||this.hideUrl}">•
      </div>
      <div id="secondaryTimestamp">${this.data.tab.lastActiveElapsedText}</div>
    `:""}
  </div>
</div>
${this.isCloseable_()?html`
  <div class="${this.getButtonContainerStyles_()}">
    <cr-icon-button id="closeButton" role="${this.getCloseButtonRole_()}"
        aria-label="${this.ariaLabelForButton_()}"
        iron-icon="${this.closeButtonIcon}" ?noink="${!this.buttonRipples_}"
        no-ripple-on-focus @click="${this.onItemClose_}"
        title="${this.tooltipForButton_()}">
    </cr-icon-button>
  </div>
`:""}
<!--_html_template_end_-->`}function deepGet(obj,path){let value=obj;const parts=path.split(".");for(const part of parts){if(value[part]===undefined){return undefined}value=value[part]}return value}var TabSearchItemSize;(function(TabSearchItemSize){TabSearchItemSize["COMPACT"]="compact";TabSearchItemSize["MEDIUM"]="medium";TabSearchItemSize["LARGE"]="large"})(TabSearchItemSize||(TabSearchItemSize={}));const TabSearchItemBase=MouseHoverableMixinLit(CrLitElement);class TabSearchItemElement extends TabSearchItemBase{static get is(){return"tab-search-item"}static get styles(){return getCss$4()}render(){return getHtml$1.bind(this)()}static get properties(){return{data:{type:Object},buttonRipples_:{type:Boolean},hideTimestamp:{type:Boolean},hideUrl:{type:Boolean},hideCloseButton:{type:Boolean},closeButtonAriaLabel:{type:String},closeButtonTooltip:{type:String},closeButtonIcon:{type:String},size:{type:String,reflect:true}}}#data_accessor_storage=new TabData({active:false,visible:false,faviconUrl:null,groupId:null,alertStates:[],index:0,isDefaultFavicon:false,lastActiveElapsedText:"",lastActiveTimeTicks:{internalValue:BigInt(0)},pinned:false,split:false,showIcon:false,tabId:1,title:"",url:{url:""}},TabItemType.OPEN_TAB,"");get data(){return this.#data_accessor_storage}set data(value){this.#data_accessor_storage=value}#buttonRipples__accessor_storage=loadTimeData.getBoolean("useRipples");get buttonRipples_(){return this.#buttonRipples__accessor_storage}set buttonRipples_(value){this.#buttonRipples__accessor_storage=value}#hideTimestamp_accessor_storage=false;get hideTimestamp(){return this.#hideTimestamp_accessor_storage}set hideTimestamp(value){this.#hideTimestamp_accessor_storage=value}#size_accessor_storage=TabSearchItemSize.MEDIUM;get size(){return this.#size_accessor_storage}set size(value){this.#size_accessor_storage=value}#hideUrl_accessor_storage=false;get hideUrl(){return this.#hideUrl_accessor_storage}set hideUrl(value){this.#hideUrl_accessor_storage=value}#hideCloseButton_accessor_storage=false;get hideCloseButton(){return this.#hideCloseButton_accessor_storage}set hideCloseButton(value){this.#hideCloseButton_accessor_storage=value}#closeButtonIcon_accessor_storage="tab-search:close";get closeButtonIcon(){return this.#closeButtonIcon_accessor_storage}set closeButtonIcon(value){this.#closeButtonIcon_accessor_storage=value}#closeButtonAriaLabel_accessor_storage="";get closeButtonAriaLabel(){return this.#closeButtonAriaLabel_accessor_storage}set closeButtonAriaLabel(value){this.#closeButtonAriaLabel_accessor_storage=value}#closeButtonTooltip_accessor_storage="";get closeButtonTooltip(){return this.#closeButtonTooltip_accessor_storage}set closeButtonTooltip(value){this.#closeButtonTooltip_accessor_storage=value}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("data")){if(this.data.tabGroup){this.style.setProperty("--group-dot-color",`var(--tab-group-color-${colorName(this.data.tabGroup.color)})`)}if(changedProperties.has("size")){assert(Object.values(TabSearchItemSize).includes(this.size))}}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("data")){this.dataChanged_()}}isCloseable_(){return!this.hideCloseButton&&this.data.type===TabItemType.OPEN_TAB}getButtonContainerStyles_(){return"button-container"+(this.isOpenTabAndHasMediaAlert_()?" allocate-space-while-hidden":"")}getCloseButtonRole_(){return this.role==="option"?"option":"button"}onItemClose_(e){this.dispatchEvent(new CustomEvent("close"));e.stopPropagation()}faviconUrl_(){const tab=this.data.tab;return tab.faviconUrl?`url("${tab.faviconUrl.url}")`:getFaviconForPageURL(tab.isDefaultFavicon?"chrome://newtab":tab.url.url,false)}groupSvgDisplay_(){return this.data.tabGroup?"block":"none"}isOpenTabAndHasMediaAlert_(){const tabData=this.data;return tabData.type===TabItemType.OPEN_TAB&&tabHasMediaAlerts(tabData.tab)}mediaAlertVisibility_(){return this.isOpenTabAndHasMediaAlert_()?"block":"none"}getMediaAlertImageClass_(){if(!this.isOpenTabAndHasMediaAlert_()){return""}const alert=this.data.tab.alertStates[0];switch(alert){case TabAlertState.kMediaRecording:return"media-recording";case TabAlertState.kAudioRecording:return"audio-recording";case TabAlertState.kVideoRecording:return"video-recording";case TabAlertState.kAudioPlaying:return"audio-playing";case TabAlertState.kAudioMuting:return"audio-muting";case TabAlertState.kGlicAccessing:return"glic-accessing";default:return""}}hasTabGroupWithTitle_(){return!!(this.data.tabGroup&&this.data.tabGroup.title)}dataChanged_(){const data=this.data;[["tab.title",this.$.primaryText],["hostname",this.$.secondaryText],["tabGroup.title",this.shadowRoot.querySelector("#groupTitle")]].forEach((([path,element])=>{if(element){const highlightRanges=data.highlightRanges?data.highlightRanges[path]:undefined;highlightText(element,deepGet(data,path),highlightRanges)}}));const protocol=new URL(normalizeURL(data.tab.url.url)).protocol;if(protocol==="chrome:"){this.$.secondaryText.prepend(document.createTextNode("chrome://"))}}ariaLabelForButton_(){if(this.closeButtonAriaLabel){return this.closeButtonAriaLabel}return`${loadTimeData.getString("closeTab")} ${this.data.tab.title}`}tooltipForButton_(){if(this.closeButtonTooltip){return this.closeButtonTooltip}return loadTimeData.getString("closeTab")}}customElements.define(TabSearchItemElement.is,TabSearchItemElement);function getDeepActiveElement(){let a=document.activeElement;while(a&&a.shadowRoot&&a.shadowRoot.activeElement){a=a.shadowRoot.activeElement}return a}function quoteString(str){return str.replace(/([\\\.\+\*\?\[\^\]\$\(\)\{\}\=\!\<\>\|\:])/g,"\\$1")}function listenOnce(target,eventNames,callback){const eventNamesArray=Array.isArray(eventNames)?eventNames:eventNames.split(/ +/);const removeAllAndCallCallback=function(event){eventNamesArray.forEach((function(eventName){target.removeEventListener(eventName,removeAllAndCallCallback,false)}));return callback(event)};eventNamesArray.forEach((function(eventName){target.addEventListener(eventName,removeAllAndCallCallback,false)}))}let instance$5=null;function getCss$3(){return instance$5||(instance$5=[...[],css`:host{display:block;position:relative}:host([chunk-size="0"]) #container>::slotted(*){box-sizing:border-box;contain-intrinsic-size:var(--list-item-size,100px) auto;content-visibility:auto;width:100%}:host(:not([chunk-size="0"])) #container>::slotted(.chunk){box-sizing:border-box;contain-intrinsic-size:calc(var(--chunk-size) * var(--list-item-size,100px)) auto;content-visibility:auto;width:100%}`])}class CrLazyListElement extends CrLitElement{static get is(){return"cr-lazy-list"}static get styles(){return getCss$3()}render(){const host=this.listItemHost===undefined?this.getRootNode().host:this.listItemHost;if(this.chunkSize===0){render(this.items.slice(0,this.numItemsDisplayed_).map(((item,index)=>this.template(item,index))),this,{host:host})}else{const chunks=Math.ceil(this.numItemsDisplayed_/this.chunkSize);const chunkArray=new Array(chunks).fill(0);render(chunkArray.map(((_item,index)=>html`<div id="chunk-${index}" class="chunk">
                                     </div>`)),this,{host:host});for(let chunkIndex=0;chunkIndex<chunks;chunkIndex++){const start=chunkIndex*this.chunkSize;const end=Math.min(this.numItemsDisplayed_,(chunkIndex+1)*this.chunkSize);const chunk=this.querySelector(`#chunk-${chunkIndex}`);assert(chunk);render(this.items.slice(start,end).map(((item,index)=>this.template(item,start+index))),chunk,{host:host})}}return html`<div id="container"><slot id="slot"></slot></div>`}static get properties(){return{chunkSize:{type:Number,reflect:true},items:{type:Array},itemSize:{type:Number},listItemHost:{type:Object},minViewportHeight:{type:Number},scrollOffset:{type:Number},scrollTarget:{type:Object},restoreFocusElement:{type:Object},template:{type:Object},numItemsDisplayed_:{state:true,type:Number}}}#items_accessor_storage=[];get items(){return this.#items_accessor_storage}set items(value){this.#items_accessor_storage=value}#itemSize_accessor_storage=undefined;get itemSize(){return this.#itemSize_accessor_storage}set itemSize(value){this.#itemSize_accessor_storage=value}#listItemHost_accessor_storage;get listItemHost(){return this.#listItemHost_accessor_storage}set listItemHost(value){this.#listItemHost_accessor_storage=value}#minViewportHeight_accessor_storage;get minViewportHeight(){return this.#minViewportHeight_accessor_storage}set minViewportHeight(value){this.#minViewportHeight_accessor_storage=value}#scrollOffset_accessor_storage=0;get scrollOffset(){return this.#scrollOffset_accessor_storage}set scrollOffset(value){this.#scrollOffset_accessor_storage=value}#scrollTarget_accessor_storage=document.documentElement;get scrollTarget(){return this.#scrollTarget_accessor_storage}set scrollTarget(value){this.#scrollTarget_accessor_storage=value}#restoreFocusElement_accessor_storage=null;get restoreFocusElement(){return this.#restoreFocusElement_accessor_storage}set restoreFocusElement(value){this.#restoreFocusElement_accessor_storage=value}#template_accessor_storage=()=>html``;get template(){return this.#template_accessor_storage}set template(value){this.#template_accessor_storage=value}#chunkSize_accessor_storage=0;get chunkSize(){return this.#chunkSize_accessor_storage}set chunkSize(value){this.#chunkSize_accessor_storage=value}#numItemsDisplayed__accessor_storage=0;get numItemsDisplayed_(){return this.#numItemsDisplayed__accessor_storage}set numItemsDisplayed_(value){this.#numItemsDisplayed__accessor_storage=value}lastItemsLength_=0;lastRenderedHeight_=0;resizeObserver_=null;scrollListener_=()=>this.onScroll_();willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("items")){this.lastItemsLength_=this.items.length;this.numItemsDisplayed_=this.items.length===0?0:Math.min(this.numItemsDisplayed_,this.items.length)}else{assert(this.items.length===this.lastItemsLength_,"Items array changed in place; rendered result may be incorrect.")}if(changedProperties.has("itemSize")){this.style.setProperty("--list-item-size",`${this.itemSize}px`)}if(changedProperties.has("chunkSize")){this.style.setProperty("--chunk-size",`${this.chunkSize}`)}}updated(changedProperties){super.updated(changedProperties);let itemsChanged=false;if(changedProperties.has("items")||changedProperties.has("minViewportHeight")||changedProperties.has("scrollOffset")){const previous=changedProperties.get("items");if(previous!==undefined||this.items.length!==0){this.onItemsChanged_();itemsChanged=true}}if(changedProperties.has("scrollTarget")){this.addRemoveScrollTargetListeners_(changedProperties.get("scrollTarget")||null);if(this.scrollTarget&&this.items.length>0&&!itemsChanged){this.fillCurrentViewport()}}}fillCurrentViewport(){if(this.items.length===0){return Promise.resolve()}return this.update_(this.$.container.style.height==="0px")}async ensureItemRendered(index){if(index<this.numItemsDisplayed_){return this.domItems()[index]}assert(index<this.items.length);await this.updateNumItemsDisplayed_(index+1);return this.domItems()[index]}addRemoveScrollTargetListeners_(oldTarget){if(oldTarget){const target=oldTarget===document.documentElement?window:oldTarget;target.removeEventListener("scroll",this.scrollListener_);assert(this.resizeObserver_);this.resizeObserver_.disconnect()}if(this.scrollTarget){const target=this.scrollTarget===document.documentElement?window:this.scrollTarget;target.addEventListener("scroll",this.scrollListener_);this.resizeObserver_=new ResizeObserver((()=>{requestAnimationFrame((()=>{const newHeight=this.getViewHeight_();if(newHeight>0&&newHeight!==this.lastRenderedHeight_){this.fillCurrentViewport()}}))}));this.resizeObserver_.observe(this.scrollTarget)}}shouldRestoreFocus_(){if(!this.restoreFocusElement){return false}const active=getDeepActiveElement();return this.restoreFocusElement===active||!!this.restoreFocusElement.shadowRoot&&this.restoreFocusElement.shadowRoot.activeElement===active}async onItemsChanged_(){if(this.items.length>0){const restoreFocus=this.shouldRestoreFocus_();await this.update_(true);if(restoreFocus){setTimeout((()=>{if(!this.restoreFocusElement){return}this.restoreFocusElement.focus();this.fire("focus-restored-for-test")}),0)}}else{this.$.container.style.height="0px";this.fire("items-rendered");this.fire("viewport-filled")}}getScrollTop_(){return this.scrollTarget===document.documentElement?window.pageYOffset:this.scrollTarget.scrollTop}getViewHeight_(){const offsetHeight=this.scrollTarget===document.documentElement?window.innerHeight:this.scrollTarget.offsetHeight;return this.getScrollTop_()-this.scrollOffset+Math.max(this.minViewportHeight||0,offsetHeight)}async update_(forceUpdateHeight){if(!this.scrollTarget){return}const height=this.getViewHeight_();if(height<=0){return}const added=await this.fillViewHeight_(height);this.fire("items-rendered");if(added||forceUpdateHeight){await this.updateHeight_();this.fire("viewport-filled")}}async fillViewHeight_(height){this.fire("fill-height-start");this.lastRenderedHeight_=height;assert(this.items.length);const initialDomItemCount=this.domItems().length;if(initialDomItemCount===0){await this.updateNumItemsDisplayed_(1)}const itemHeight=this.domItemAverageHeight_();if(itemHeight===0){this.lastRenderedHeight_=0;return false}const desiredDomItemCount=Math.min(Math.ceil(height/itemHeight),this.items.length);if(desiredDomItemCount>this.numItemsDisplayed_){await this.updateNumItemsDisplayed_(desiredDomItemCount)}const added=initialDomItemCount!==desiredDomItemCount;if(added){this.fire("fill-height-end")}return added}async updateNumItemsDisplayed_(itemsToDisplay){this.numItemsDisplayed_=itemsToDisplay;if(this.numItemsDisplayed_>200&&this.chunkSize<2){console.warn(`cr-lazy-list: ${this.numItemsDisplayed_} list items rendered. `+"If this is expected, consider chunking mode (chunkSize > 1) "+"to improve scrolling performance.")}await this.updateComplete}domItems(){return this.chunkSize===0?this.$.slot.assignedElements():Array.from(this.querySelectorAll(".chunk > *"))}domItemAverageHeight_(){assert(this.items.length>0);const domItems=this.domItems();assert(domItems.length>0);const firstDomItem=domItems.at(0);const lastDomItem=domItems.at(-1);const lastDomItemHeight=lastDomItem.offsetHeight;if(firstDomItem===lastDomItem&&lastDomItemHeight===0){return 0}else if(this.itemSize){return this.itemSize}let totalHeight=lastDomItem.offsetTop+lastDomItemHeight;if(this.chunkSize>0){totalHeight+=lastDomItem.offsetParent.offsetTop-firstDomItem.offsetParent.offsetTop}else{totalHeight-=firstDomItem.offsetTop}return totalHeight/domItems.length}async updateHeight_(){await new Promise((resolve=>setTimeout(resolve,0)));const estScrollHeight=this.items.length>0?this.items.length*this.domItemAverageHeight_():0;this.$.container.style.height=estScrollHeight+"px"}async onScroll_(){const scrollTop=this.getScrollTop_();if(scrollTop<=0||this.numItemsDisplayed_===this.items.length){return}await this.fillCurrentViewport()}}customElements.define(CrLazyListElement.is,CrLazyListElement);let instance$4=null;function getCss$2(){return instance$4||(instance$4=[...[],css`:host{display:block;overflow-x:hidden;overflow-y:auto;position:relative}`])}const NO_SELECTION=-1;const selectorNavigationKeys=Object.freeze(["ArrowUp","ArrowDown","Home","End"]);class SelectableLazyListElement extends CrLitElement{static get is(){return"selectable-lazy-list"}static get styles(){return getCss$2()}render(){render(html`<cr-lazy-list id="list" .scrollTarget="${this}"
          .listItemHost="${this.getRootNode().host}"
          .itemSize="${this.itemSize}" .items="${this.items}"
          .minViewportHeight="${this.maxHeight}"
          .template="${this.template}"
          .restoreFocusElement="${this.selectedItem_}"
          .style="${this.getListPaddingStyle_()}"
          @keydown="${this.onKeyDown_}"
          @viewport-filled="${this.updateSelectedItem_}"
          @fill-height-start="${this.onFillHeightStart_}"
          @fill-height-end="${this.onFillHeightEnd_}">
        </cr-lazy-list>`,this,{host:this});return html`<slot></slot>`}static get properties(){return{expandedList:{type:Boolean},maxHeight:{type:Number},items:{type:Array},itemSize:{type:Number},isSelectable:{type:Object},selected:{type:Number},template:{type:Object},selectedItem_:{type:Object}}}#expandedList_accessor_storage=false;get expandedList(){return this.#expandedList_accessor_storage}set expandedList(value){this.#expandedList_accessor_storage=value}#maxHeight_accessor_storage;get maxHeight(){return this.#maxHeight_accessor_storage}set maxHeight(value){this.#maxHeight_accessor_storage=value}#items_accessor_storage=[];get items(){return this.#items_accessor_storage}set items(value){this.#items_accessor_storage=value}#itemSize_accessor_storage=100;get itemSize(){return this.#itemSize_accessor_storage}set itemSize(value){this.#itemSize_accessor_storage=value}#template_accessor_storage=()=>html``;get template(){return this.#template_accessor_storage}set template(value){this.#template_accessor_storage=value}#selected_accessor_storage=NO_SELECTION;get selected(){return this.#selected_accessor_storage}set selected(value){this.#selected_accessor_storage=value}#isSelectable_accessor_storage=_item=>true;get isSelectable(){return this.#isSelectable_accessor_storage}set isSelectable(value){this.#isSelectable_accessor_storage=value}#selectedItem__accessor_storage=null;get selectedItem_(){return this.#selectedItem__accessor_storage}set selectedItem_(value){this.#selectedItem__accessor_storage=value}firstSelectableIndex_=NO_SELECTION;lastSelectableIndex_=NO_SELECTION;viewportFillStartTime_=0;willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("items")||changedProperties.has("isSelectable")){if(this.items.length===0){this.resetSelected()}this.firstSelectableIndex_=this.getNextSelectableIndex_(-1);this.lastSelectableIndex_=this.getPreviousSelectableIndex_(this.items.length);if(this.selected>this.lastSelectableIndex_){this.selected=this.lastSelectableIndex_}}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("maxHeight")&&this.maxHeight!==0){this.style.maxHeight=`${this.maxHeight}px`}if(changedProperties.has("selected")){this.updateSelectedItem_();this.onSelectedChanged_()}}getListPaddingStyle_(){return this.expandedList?"padding-bottom: 16px":""}getNextSelectableIndex_(index){const increment=this.items.slice(index+1).findIndex((item=>this.isSelectable(item)));return increment===-1?NO_SELECTION:index+1+increment}getPreviousSelectableIndex_(index){return index<0?NO_SELECTION:this.items.slice(0,index).findLastIndex((item=>this.isSelectable(item)))}getDomItem_(index){return this.querySelector(`cr-lazy-list > *:nth-child(${index+1})`)}lazyList_(){const list=this.querySelector("cr-lazy-list");assert(list);return list}updateSelectedItem_(){if(!this.items){return}const domItem=this.selected===NO_SELECTION?null:this.getDomItem_(this.selected);if(domItem===this.selectedItem_){return}if(this.selectedItem_!==null){this.selectedItem_.classList.toggle("selected",false)}if(domItem!==null){domItem.classList.toggle("selected",true)}this.selectedItem_=domItem;this.fire("selected-change",{item:this.selectedItem_})}get selectedItem(){return this.selectedItem_}fillCurrentViewport(){return this.lazyList_().fillCurrentViewport()}async ensureAllDomItemsAvailable(){await this.lazyList_().ensureItemRendered(this.items.length-1)}async scrollIndexIntoView(index){assert(index>=this.firstSelectableIndex_&&index<=this.lastSelectableIndex_,"Index is out of range.");const newItem=await this.lazyList_().ensureItemRendered(index);newItem.scrollIntoView({behavior:"smooth",block:"nearest"})}async navigate(key,focusItem){if(key==="ArrowUp"&&this.selected===this.firstSelectableIndex_||key==="End"){await this.ensureAllDomItemsAvailable();this.selected=this.lastSelectableIndex_}else{switch(key){case"ArrowUp":this.selected=this.getPreviousSelectableIndex_(this.selected);break;case"ArrowDown":const next=this.getNextSelectableIndex_(this.selected);this.selected=next===NO_SELECTION?this.getNextSelectableIndex_(-1):next;break;case"Home":this.selected=this.firstSelectableIndex_;break;case"End":this.selected=this.lastSelectableIndex_;break}}if(focusItem){await this.updateComplete;this.selectedItem_.focus({preventScroll:true})}}onFillHeightStart_(){this.viewportFillStartTime_=performance.now()}onFillHeightEnd_(){performance.mark(`tab_search:infinite_list_view_updated:${performance.now()-this.viewportFillStartTime_}:metric_value`)}onKeyDown_(e){if(e.shiftKey){return}if(this.selected===undefined){return}if(selectorNavigationKeys.includes(e.key)){this.navigate(e.key,true);e.stopPropagation();e.preventDefault()}}async onSelectedChanged_(){if(this.selected===undefined){return}const selectedIndex=this.selected;if(selectedIndex===this.firstSelectableIndex_){this.scrollTo({top:0,behavior:"smooth"});return}if(selectedIndex===this.lastSelectableIndex_){this.selectedItem_.scrollIntoView({behavior:"smooth"});return}const previousIndex=this.getPreviousSelectableIndex_(this.selected);const previousItem=previousIndex===NO_SELECTION?null:this.getDomItem_(previousIndex);if(!!previousItem&&previousItem.offsetTop<this.scrollTop){previousItem.scrollIntoView({behavior:"smooth",block:"nearest"});return}const nextItemIndex=this.getNextSelectableIndex_(this.selected);if(nextItemIndex!==NO_SELECTION){const nextItem=await this.lazyList_().ensureItemRendered(nextItemIndex);if(nextItem.offsetTop+nextItem.offsetHeight>this.scrollTop+this.offsetHeight){nextItem.scrollIntoView({behavior:"smooth",block:"nearest"})}}}resetSelected(){this.selected=NO_SELECTION}async setSelected(index){if(index===NO_SELECTION){this.resetSelected();return}if(index!==this.selected){assert(index<=this.lastSelectableIndex_,"Selection index is out of range.");await this.lazyList_().ensureItemRendered(index);this.selected=index}}}customElements.define(SelectableLazyListElement.is,SelectableLazyListElement);let PageHandlerPendingReceiver$1=class PageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"color_change_listener.mojom.PageHandler",scope)}};let PageHandlerRemote$1=class PageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver$1,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}setPage(page){this.proxy.sendMessage(0,PageHandler_SetPage_ParamsSpec.$,null,[page],false)}};class PageHandler{static get $interfaceName(){return"color_change_listener.mojom.PageHandler"}static getRemote(){let remote=new PageHandlerRemote$1;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}let PagePendingReceiver$1=class PagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"color_change_listener.mojom.Page",scope)}};let PageRemote$1=class PageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver$1,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onColorProviderChanged(){this.proxy.sendMessage(0,Page_OnColorProviderChanged_ParamsSpec.$,null,[],false)}};let PageCallbackRouter$1=class PageCallbackRouter{helper_internal_;$;router_;onColorProviderChanged;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote$1);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onColorProviderChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,Page_OnColorProviderChanged_ParamsSpec.$,null,this.onColorProviderChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}};const PageHandler_SetPage_ParamsSpec={$:{}};const Page_OnColorProviderChanged_ParamsSpec={$:{}};mojo.internal.Struct(PageHandler_SetPage_ParamsSpec.$,"PageHandler_SetPage_Params",[mojo.internal.StructField("page",0,0,mojo.internal.InterfaceProxy(PageRemote$1),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_OnColorProviderChanged_ParamsSpec.$,"Page_OnColorProviderChanged_Params",[],[[0,8]]);let instance$3=null;class BrowserProxy{callbackRouter;constructor(){this.callbackRouter=new PageCallbackRouter$1;const pageHandlerRemote=PageHandler.getRemote();pageHandlerRemote.setPage(this.callbackRouter.$.bindNewPipeAndPassRemote())}static getInstance(){return instance$3||(instance$3=new BrowserProxy)}static setInstance(newInstance){instance$3=newInstance}}const COLORS_CSS_SELECTOR="link[href*='//theme/colors.css']";let documentInstance=null;class ColorChangeUpdater{listenerId_=null;root_;constructor(root){assert(documentInstance===null||root!==document);this.root_=root}start(){if(this.listenerId_!==null){return}this.listenerId_=BrowserProxy.getInstance().callbackRouter.onColorProviderChanged.addListener(this.onColorProviderChanged.bind(this))}async onColorProviderChanged(){await this.refreshColorsCss()}async refreshColorsCss(){const colorCssNode=this.root_.querySelector(COLORS_CSS_SELECTOR);if(!colorCssNode){return false}const href=colorCssNode.getAttribute("href");if(!href){return false}const hrefURL=new URL(href,location.href);const params=new URLSearchParams(hrefURL.search);params.set("version",(new Date).getTime().toString());const newHref=`${hrefURL.origin}${hrefURL.pathname}?${params.toString()}`;const newColorsCssLink=document.createElement("link");newColorsCssLink.setAttribute("href",newHref);newColorsCssLink.rel="stylesheet";newColorsCssLink.type="text/css";const newColorsLoaded=new Promise((resolve=>{newColorsCssLink.onload=resolve}));if(this.root_===document){document.getElementsByTagName("body")[0].appendChild(newColorsCssLink)}else{this.root_.appendChild(newColorsCssLink)}await newColorsLoaded;const oldColorCssNode=document.querySelector(COLORS_CSS_SELECTOR);if(oldColorCssNode){oldColorCssNode.remove()}return true}static forDocument(){return documentInstance||(documentInstance=new ColorChangeUpdater(document))}}function stringToMojoString16(str){const arr=[];for(let i=0;i<str.length;i++){arr.push(str.charCodeAt(i))}return{data:arr}}function mojoString16ToString(str16){const CHUNK_SIZE=8192;if(str16.data.length<CHUNK_SIZE){return String.fromCharCode(...str16.data)}let str="";for(let i=0;i<str16.data.length;i+=CHUNK_SIZE){const chunk=str16.data.slice(i,i+CHUNK_SIZE);str+=String.fromCharCode(...chunk)}return str}const BigBufferSharedMemoryRegionSpec={$:{}};const BigBufferSpec={$:{}};mojo.internal.Struct(BigBufferSharedMemoryRegionSpec.$,"BigBufferSharedMemoryRegion",[mojo.internal.StructField("bufferHandle",0,0,mojo.internal.Handle,null,false,0,undefined,undefined),mojo.internal.StructField("size",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Union(BigBufferSpec.$,"BigBuffer",{bytes:{ordinal:0,type:mojo.internal.Array(mojo.internal.Uint8,false)},sharedMemory:{ordinal:1,type:BigBufferSharedMemoryRegionSpec.$},invalidBuffer:{ordinal:2,type:mojo.internal.Bool}});var BigBufferFieldTags;(function(BigBufferFieldTags){BigBufferFieldTags[BigBufferFieldTags["BYTES"]=0]="BYTES";BigBufferFieldTags[BigBufferFieldTags["SHARED_MEMORY"]=1]="SHARED_MEMORY";BigBufferFieldTags[BigBufferFieldTags["INVALID_BUFFER"]=2]="INVALID_BUFFER"})(BigBufferFieldTags||(BigBufferFieldTags={}));const String16Spec={$:{}};const BigString16Spec={$:{}};mojo.internal.Struct(String16Spec.$,"String16",[mojo.internal.StructField("data",0,0,mojo.internal.Array(mojo.internal.Uint16,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(BigString16Spec.$,"BigString16",[mojo.internal.StructField("data",0,0,BigBufferSpec.$,null,false,0,undefined,undefined)],[[0,24]]);class JSTimeDataView{decoder_;version_;fieldSpecs_;constructor(decoder,version,fieldSpecs){this.decoder_=decoder;this.version_=version;this.fieldSpecs_=fieldSpecs}get msec(){const field=this.fieldSpecs_[0];return mojo.internal.decodeStructField(this.decoder_,field,this.version_)}}class JsTimeConverter{msec(date){return date.valueOf()}convert(view){return new Date(view.msec)}}const TimeSpec={$:{}};const JSTimeSpec={$:{}};const TimeDeltaSpec={$:{}};const TimeTicksSpec={$:{}};mojo.internal.Struct(TimeSpec.$,"Time",[mojo.internal.StructField("internalValue",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined)],[[0,16]]);const converterForJSTime=new JsTimeConverter;mojo.internal.TypemappedStruct(JSTimeSpec.$,"JSTime",JSTimeDataView,converterForJSTime,[mojo.internal.StructField("msec",0,0,mojo.internal.Double,0,false,0,undefined,(value=>converterForJSTime.msec(value)))],[[0,16]]);mojo.internal.Struct(TimeDeltaSpec.$,"TimeDelta",[mojo.internal.StructField("microseconds",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TimeTicksSpec.$,"TimeTicks",[mojo.internal.StructField("internalValue",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined)],[[0,16]]);const TokenSpec={$:{}};mojo.internal.Struct(TokenSpec.$,"Token",[mojo.internal.StructField("high",0,0,mojo.internal.Uint64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("low",8,0,mojo.internal.Uint64,BigInt(0),false,0,undefined,undefined)],[[0,24]]);const UrlSpec={$:{}};mojo.internal.Struct(UrlSpec.$,"Url",[mojo.internal.StructField("url",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);({$:mojo.internal.Enum()});var DeclutterCTREvent;(function(DeclutterCTREvent){DeclutterCTREvent[DeclutterCTREvent["MIN_VALUE"]=0]="MIN_VALUE";DeclutterCTREvent[DeclutterCTREvent["MAX_VALUE"]=1]="MAX_VALUE";DeclutterCTREvent[DeclutterCTREvent["kDeclutterShown"]=0]="kDeclutterShown";DeclutterCTREvent[DeclutterCTREvent["kCloseTabsClicked"]=1]="kCloseTabsClicked"})(DeclutterCTREvent||(DeclutterCTREvent={}));({$:mojo.internal.Enum()});var SelectorCTREvent;(function(SelectorCTREvent){SelectorCTREvent[SelectorCTREvent["MIN_VALUE"]=0]="MIN_VALUE";SelectorCTREvent[SelectorCTREvent["MAX_VALUE"]=2]="MAX_VALUE";SelectorCTREvent[SelectorCTREvent["kSelectorShown"]=0]="kSelectorShown";SelectorCTREvent[SelectorCTREvent["kAutoTabGroupsClicked"]=1]="kAutoTabGroupsClicked";SelectorCTREvent[SelectorCTREvent["kDeclutterClicked"]=2]="kDeclutterClicked"})(SelectorCTREvent||(SelectorCTREvent={}));({$:mojo.internal.Enum()});var TabDeclutterEntryPoint;(function(TabDeclutterEntryPoint){TabDeclutterEntryPoint[TabDeclutterEntryPoint["MIN_VALUE"]=0]="MIN_VALUE";TabDeclutterEntryPoint[TabDeclutterEntryPoint["MAX_VALUE"]=2]="MAX_VALUE";TabDeclutterEntryPoint[TabDeclutterEntryPoint["kNudge"]=0]="kNudge";TabDeclutterEntryPoint[TabDeclutterEntryPoint["kAppMenu"]=1]="kAppMenu";TabDeclutterEntryPoint[TabDeclutterEntryPoint["kSelector"]=2]="kSelector"})(TabDeclutterEntryPoint||(TabDeclutterEntryPoint={}));const TabOrganizationStateSpec={$:mojo.internal.Enum()};var TabOrganizationState;(function(TabOrganizationState){TabOrganizationState[TabOrganizationState["MIN_VALUE"]=0]="MIN_VALUE";TabOrganizationState[TabOrganizationState["MAX_VALUE"]=4]="MAX_VALUE";TabOrganizationState[TabOrganizationState["kInitializing"]=0]="kInitializing";TabOrganizationState[TabOrganizationState["kNotStarted"]=1]="kNotStarted";TabOrganizationState[TabOrganizationState["kInProgress"]=2]="kInProgress";TabOrganizationState[TabOrganizationState["kSuccess"]=3]="kSuccess";TabOrganizationState[TabOrganizationState["kFailure"]=4]="kFailure"})(TabOrganizationState||(TabOrganizationState={}));const TabOrganizationFeatureSpec={$:mojo.internal.Enum()};var TabOrganizationFeature;(function(TabOrganizationFeature){TabOrganizationFeature[TabOrganizationFeature["MIN_VALUE"]=0]="MIN_VALUE";TabOrganizationFeature[TabOrganizationFeature["MAX_VALUE"]=3]="MAX_VALUE";TabOrganizationFeature[TabOrganizationFeature["kNone"]=0]="kNone";TabOrganizationFeature[TabOrganizationFeature["kSelector"]=1]="kSelector";TabOrganizationFeature[TabOrganizationFeature["kAutoTabGroups"]=2]="kAutoTabGroups";TabOrganizationFeature[TabOrganizationFeature["kDeclutter"]=3]="kDeclutter"})(TabOrganizationFeature||(TabOrganizationFeature={}));const TabOrganizationErrorSpec={$:mojo.internal.Enum()};var TabOrganizationError;(function(TabOrganizationError){TabOrganizationError[TabOrganizationError["MIN_VALUE"]=0]="MIN_VALUE";TabOrganizationError[TabOrganizationError["MAX_VALUE"]=2]="MAX_VALUE";TabOrganizationError[TabOrganizationError["kNone"]=0]="kNone";TabOrganizationError[TabOrganizationError["kGrouping"]=1]="kGrouping";TabOrganizationError[TabOrganizationError["kGeneric"]=2]="kGeneric"})(TabOrganizationError||(TabOrganizationError={}));const TabOrganizationModelStrategySpec={$:mojo.internal.Enum()};var TabOrganizationModelStrategy;(function(TabOrganizationModelStrategy){TabOrganizationModelStrategy[TabOrganizationModelStrategy["MIN_VALUE"]=0]="MIN_VALUE";TabOrganizationModelStrategy[TabOrganizationModelStrategy["MAX_VALUE"]=2]="MAX_VALUE";TabOrganizationModelStrategy[TabOrganizationModelStrategy["kTopic"]=0]="kTopic";TabOrganizationModelStrategy[TabOrganizationModelStrategy["kTask"]=1]="kTask";TabOrganizationModelStrategy[TabOrganizationModelStrategy["kDomain"]=2]="kDomain"})(TabOrganizationModelStrategy||(TabOrganizationModelStrategy={}));const TabSearchSectionSpec={$:mojo.internal.Enum()};var TabSearchSection;(function(TabSearchSection){TabSearchSection[TabSearchSection["MIN_VALUE"]=0]="MIN_VALUE";TabSearchSection[TabSearchSection["MAX_VALUE"]=2]="MAX_VALUE";TabSearchSection[TabSearchSection["kNone"]=0]="kNone";TabSearchSection[TabSearchSection["kSearch"]=1]="kSearch";TabSearchSection[TabSearchSection["kOrganize"]=2]="kOrganize"})(TabSearchSection||(TabSearchSection={}));const UserFeedbackSpec={$:mojo.internal.Enum()};var UserFeedback;(function(UserFeedback){UserFeedback[UserFeedback["MIN_VALUE"]=0]="MIN_VALUE";UserFeedback[UserFeedback["MAX_VALUE"]=2]="MAX_VALUE";UserFeedback[UserFeedback["kUserFeedBackUnspecified"]=0]="kUserFeedBackUnspecified";UserFeedback[UserFeedback["kUserFeedBackPositive"]=1]="kUserFeedBackPositive";UserFeedback[UserFeedback["kUserFeedBackNegative"]=2]="kUserFeedBackNegative"})(UserFeedback||(UserFeedback={}));class PageHandlerFactoryPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"tab_search.mojom.PageHandlerFactory",scope)}}class PageHandlerFactoryRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}createPageHandler(page,handler){this.proxy.sendMessage(0,PageHandlerFactory_CreatePageHandler_ParamsSpec.$,null,[page,handler],false)}}class PageHandlerFactory{static get $interfaceName(){return"tab_search.mojom.PageHandlerFactory"}static getRemote(){let remote=new PageHandlerFactoryRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}class PageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"tab_search.mojom.PageHandler",scope)}}class PageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}closeTab(tabId){this.proxy.sendMessage(0,PageHandler_CloseTab_ParamsSpec.$,null,[tabId],false)}closeWebUiTab(){this.proxy.sendMessage(1,PageHandler_CloseWebUiTab_ParamsSpec.$,null,[],false)}declutterTabs(tabIds,urls){this.proxy.sendMessage(2,PageHandler_DeclutterTabs_ParamsSpec.$,null,[tabIds,urls],false)}acceptTabOrganization(sessionId,organizationId,tabs){this.proxy.sendMessage(3,PageHandler_AcceptTabOrganization_ParamsSpec.$,null,[sessionId,organizationId,tabs],false)}rejectTabOrganization(sessionId,organizationId){this.proxy.sendMessage(4,PageHandler_RejectTabOrganization_ParamsSpec.$,null,[sessionId,organizationId],false)}renameTabOrganization(sessionId,organizationId,name){this.proxy.sendMessage(5,PageHandler_RenameTabOrganization_ParamsSpec.$,null,[sessionId,organizationId,name],false)}excludeFromStaleTabs(tabId){this.proxy.sendMessage(6,PageHandler_ExcludeFromStaleTabs_ParamsSpec.$,null,[tabId],false)}excludeFromDuplicateTabs(url){this.proxy.sendMessage(7,PageHandler_ExcludeFromDuplicateTabs_ParamsSpec.$,null,[url],false)}getProfileData(){return this.proxy.sendMessage(8,PageHandler_GetProfileData_ParamsSpec.$,PageHandler_GetProfileData_ResponseParamsSpec.$,[],false)}getUnusedTabs(){return this.proxy.sendMessage(9,PageHandler_GetUnusedTabs_ParamsSpec.$,PageHandler_GetUnusedTabs_ResponseParamsSpec.$,[],false)}getTabSearchSection(){return this.proxy.sendMessage(10,PageHandler_GetTabSearchSection_ParamsSpec.$,PageHandler_GetTabSearchSection_ResponseParamsSpec.$,[],false)}getTabOrganizationFeature(){return this.proxy.sendMessage(11,PageHandler_GetTabOrganizationFeature_ParamsSpec.$,PageHandler_GetTabOrganizationFeature_ResponseParamsSpec.$,[],false)}getTabOrganizationSession(){return this.proxy.sendMessage(12,PageHandler_GetTabOrganizationSession_ParamsSpec.$,PageHandler_GetTabOrganizationSession_ResponseParamsSpec.$,[],false)}getTabOrganizationModelStrategy(){return this.proxy.sendMessage(13,PageHandler_GetTabOrganizationModelStrategy_ParamsSpec.$,PageHandler_GetTabOrganizationModelStrategy_ResponseParamsSpec.$,[],false)}getIsSplit(){return this.proxy.sendMessage(14,PageHandler_GetIsSplit_ParamsSpec.$,PageHandler_GetIsSplit_ResponseParamsSpec.$,[],false)}switchToTab(switchToTabInfo){this.proxy.sendMessage(15,PageHandler_SwitchToTab_ParamsSpec.$,null,[switchToTabInfo],false)}openRecentlyClosedEntry(sessionId){this.proxy.sendMessage(16,PageHandler_OpenRecentlyClosedEntry_ParamsSpec.$,null,[sessionId],false)}requestTabOrganization(){this.proxy.sendMessage(17,PageHandler_RequestTabOrganization_ParamsSpec.$,null,[],false)}removeTabFromOrganization(sessionId,organizationId,tab){this.proxy.sendMessage(18,PageHandler_RemoveTabFromOrganization_ParamsSpec.$,null,[sessionId,organizationId,tab],false)}rejectSession(sessionId){this.proxy.sendMessage(19,PageHandler_RejectSession_ParamsSpec.$,null,[sessionId],false)}replaceActiveSplitTab(replacementTabId){this.proxy.sendMessage(20,PageHandler_ReplaceActiveSplitTab_ParamsSpec.$,null,[replacementTabId],false)}restartSession(){this.proxy.sendMessage(21,PageHandler_RestartSession_ParamsSpec.$,null,[],false)}saveRecentlyClosedExpandedPref(expanded){this.proxy.sendMessage(22,PageHandler_SaveRecentlyClosedExpandedPref_ParamsSpec.$,null,[expanded],false)}setOrganizationFeature(feature){this.proxy.sendMessage(23,PageHandler_SetOrganizationFeature_ParamsSpec.$,null,[feature],false)}startTabGroupTutorial(){this.proxy.sendMessage(24,PageHandler_StartTabGroupTutorial_ParamsSpec.$,null,[],false)}triggerFeedback(sessionId){this.proxy.sendMessage(25,PageHandler_TriggerFeedback_ParamsSpec.$,null,[sessionId],false)}triggerSignIn(){this.proxy.sendMessage(26,PageHandler_TriggerSignIn_ParamsSpec.$,null,[],false)}openHelpPage(){this.proxy.sendMessage(27,PageHandler_OpenHelpPage_ParamsSpec.$,null,[],false)}setTabOrganizationModelStrategy(strategy){this.proxy.sendMessage(28,PageHandler_SetTabOrganizationModelStrategy_ParamsSpec.$,null,[strategy],false)}setTabOrganizationUserInstruction(userInstruction){this.proxy.sendMessage(29,PageHandler_SetTabOrganizationUserInstruction_ParamsSpec.$,null,[userInstruction],false)}setUserFeedback(sessionId,feedback){this.proxy.sendMessage(30,PageHandler_SetUserFeedback_ParamsSpec.$,null,[sessionId,feedback],false)}notifyOrganizationUIReadyToShow(){this.proxy.sendMessage(31,PageHandler_NotifyOrganizationUIReadyToShow_ParamsSpec.$,null,[],false)}notifySearchUIReadyToShow(){this.proxy.sendMessage(32,PageHandler_NotifySearchUIReadyToShow_ParamsSpec.$,null,[],false)}}class PagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"tab_search.mojom.Page",scope)}}class PageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}tabOrganizationSessionUpdated(session){this.proxy.sendMessage(0,Page_TabOrganizationSessionUpdated_ParamsSpec.$,null,[session],false)}tabOrganizationModelStrategyUpdated(strategy){this.proxy.sendMessage(1,Page_TabOrganizationModelStrategyUpdated_ParamsSpec.$,null,[strategy],false)}hostWindowChanged(){this.proxy.sendMessage(2,Page_HostWindowChanged_ParamsSpec.$,null,[],false)}tabsChanged(profileTabs){this.proxy.sendMessage(3,Page_TabsChanged_ParamsSpec.$,null,[profileTabs],false)}tabUpdated(tabUpdateInfo){this.proxy.sendMessage(4,Page_TabUpdated_ParamsSpec.$,null,[tabUpdateInfo],false)}tabsRemoved(tabsRemovedInfo){this.proxy.sendMessage(5,Page_TabsRemoved_ParamsSpec.$,null,[tabsRemovedInfo],false)}tabSearchSectionChanged(section){this.proxy.sendMessage(6,Page_TabSearchSectionChanged_ParamsSpec.$,null,[section],false)}tabOrganizationFeatureChanged(feature){this.proxy.sendMessage(7,Page_TabOrganizationFeatureChanged_ParamsSpec.$,null,[feature],false)}showFREChanged(show){this.proxy.sendMessage(8,Page_ShowFREChanged_ParamsSpec.$,null,[show],false)}tabOrganizationEnabledChanged(enabled){this.proxy.sendMessage(9,Page_TabOrganizationEnabledChanged_ParamsSpec.$,null,[enabled],false)}unusedTabsChanged(tabs){this.proxy.sendMessage(10,Page_UnusedTabsChanged_ParamsSpec.$,null,[tabs],false)}tabUnsplit(){this.proxy.sendMessage(11,Page_TabUnsplit_ParamsSpec.$,null,[],false)}}class PageCallbackRouter{helper_internal_;$;router_;tabOrganizationSessionUpdated;tabOrganizationModelStrategyUpdated;hostWindowChanged;tabsChanged;tabUpdated;tabsRemoved;tabSearchSectionChanged;tabOrganizationFeatureChanged;showFREChanged;tabOrganizationEnabledChanged;unusedTabsChanged;tabUnsplit;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.tabOrganizationSessionUpdated=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,Page_TabOrganizationSessionUpdated_ParamsSpec.$,null,this.tabOrganizationSessionUpdated.createReceiverHandler(false),false);this.tabOrganizationModelStrategyUpdated=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,Page_TabOrganizationModelStrategyUpdated_ParamsSpec.$,null,this.tabOrganizationModelStrategyUpdated.createReceiverHandler(false),false);this.hostWindowChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,Page_HostWindowChanged_ParamsSpec.$,null,this.hostWindowChanged.createReceiverHandler(false),false);this.tabsChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,Page_TabsChanged_ParamsSpec.$,null,this.tabsChanged.createReceiverHandler(false),false);this.tabUpdated=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,Page_TabUpdated_ParamsSpec.$,null,this.tabUpdated.createReceiverHandler(false),false);this.tabsRemoved=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,Page_TabsRemoved_ParamsSpec.$,null,this.tabsRemoved.createReceiverHandler(false),false);this.tabSearchSectionChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,Page_TabSearchSectionChanged_ParamsSpec.$,null,this.tabSearchSectionChanged.createReceiverHandler(false),false);this.tabOrganizationFeatureChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,Page_TabOrganizationFeatureChanged_ParamsSpec.$,null,this.tabOrganizationFeatureChanged.createReceiverHandler(false),false);this.showFREChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,Page_ShowFREChanged_ParamsSpec.$,null,this.showFREChanged.createReceiverHandler(false),false);this.tabOrganizationEnabledChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(9,Page_TabOrganizationEnabledChanged_ParamsSpec.$,null,this.tabOrganizationEnabledChanged.createReceiverHandler(false),false);this.unusedTabsChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(10,Page_UnusedTabsChanged_ParamsSpec.$,null,this.unusedTabsChanged.createReceiverHandler(false),false);this.tabUnsplit=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(11,Page_TabUnsplit_ParamsSpec.$,null,this.tabUnsplit.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}const ProfileDataSpec={$:{}};const WindowSpec={$:{}};const TabSpec={$:{}};const RecentlyClosedTabSpec={$:{}};const TabGroupSpec={$:{}};const RecentlyClosedTabGroupSpec={$:{}};const SwitchToTabInfoSpec={$:{}};const TabOrganizationSpec={$:{}};const TabOrganizationSessionSpec={$:{}};const TabUpdateInfoSpec={$:{}};const TabsRemovedInfoSpec={$:{}};const UnusedTabInfoSpec={$:{}};const PageHandlerFactory_CreatePageHandler_ParamsSpec={$:{}};const PageHandler_CloseTab_ParamsSpec={$:{}};const PageHandler_CloseWebUiTab_ParamsSpec={$:{}};const PageHandler_DeclutterTabs_ParamsSpec={$:{}};const PageHandler_AcceptTabOrganization_ParamsSpec={$:{}};const PageHandler_RejectTabOrganization_ParamsSpec={$:{}};const PageHandler_RenameTabOrganization_ParamsSpec={$:{}};const PageHandler_ExcludeFromStaleTabs_ParamsSpec={$:{}};const PageHandler_ExcludeFromDuplicateTabs_ParamsSpec={$:{}};const PageHandler_GetProfileData_ParamsSpec={$:{}};const PageHandler_GetProfileData_ResponseParamsSpec={$:{}};const PageHandler_GetUnusedTabs_ParamsSpec={$:{}};const PageHandler_GetUnusedTabs_ResponseParamsSpec={$:{}};const PageHandler_GetTabSearchSection_ParamsSpec={$:{}};const PageHandler_GetTabSearchSection_ResponseParamsSpec={$:{}};const PageHandler_GetTabOrganizationFeature_ParamsSpec={$:{}};const PageHandler_GetTabOrganizationFeature_ResponseParamsSpec={$:{}};const PageHandler_GetTabOrganizationSession_ParamsSpec={$:{}};const PageHandler_GetTabOrganizationSession_ResponseParamsSpec={$:{}};const PageHandler_GetTabOrganizationModelStrategy_ParamsSpec={$:{}};const PageHandler_GetTabOrganizationModelStrategy_ResponseParamsSpec={$:{}};const PageHandler_GetIsSplit_ParamsSpec={$:{}};const PageHandler_GetIsSplit_ResponseParamsSpec={$:{}};const PageHandler_SwitchToTab_ParamsSpec={$:{}};const PageHandler_OpenRecentlyClosedEntry_ParamsSpec={$:{}};const PageHandler_RequestTabOrganization_ParamsSpec={$:{}};const PageHandler_RemoveTabFromOrganization_ParamsSpec={$:{}};const PageHandler_RejectSession_ParamsSpec={$:{}};const PageHandler_ReplaceActiveSplitTab_ParamsSpec={$:{}};const PageHandler_RestartSession_ParamsSpec={$:{}};const PageHandler_SaveRecentlyClosedExpandedPref_ParamsSpec={$:{}};const PageHandler_SetOrganizationFeature_ParamsSpec={$:{}};const PageHandler_StartTabGroupTutorial_ParamsSpec={$:{}};const PageHandler_TriggerFeedback_ParamsSpec={$:{}};const PageHandler_TriggerSignIn_ParamsSpec={$:{}};const PageHandler_OpenHelpPage_ParamsSpec={$:{}};const PageHandler_SetTabOrganizationModelStrategy_ParamsSpec={$:{}};const PageHandler_SetTabOrganizationUserInstruction_ParamsSpec={$:{}};const PageHandler_SetUserFeedback_ParamsSpec={$:{}};const PageHandler_NotifyOrganizationUIReadyToShow_ParamsSpec={$:{}};const PageHandler_NotifySearchUIReadyToShow_ParamsSpec={$:{}};const Page_TabOrganizationSessionUpdated_ParamsSpec={$:{}};const Page_TabOrganizationModelStrategyUpdated_ParamsSpec={$:{}};const Page_HostWindowChanged_ParamsSpec={$:{}};const Page_TabsChanged_ParamsSpec={$:{}};const Page_TabUpdated_ParamsSpec={$:{}};const Page_TabsRemoved_ParamsSpec={$:{}};const Page_TabSearchSectionChanged_ParamsSpec={$:{}};const Page_TabOrganizationFeatureChanged_ParamsSpec={$:{}};const Page_ShowFREChanged_ParamsSpec={$:{}};const Page_TabOrganizationEnabledChanged_ParamsSpec={$:{}};const Page_UnusedTabsChanged_ParamsSpec={$:{}};const Page_TabUnsplit_ParamsSpec={$:{}};mojo.internal.Struct(ProfileDataSpec.$,"ProfileData",[mojo.internal.StructField("windows",0,0,mojo.internal.Array(WindowSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("tabGroups",8,0,mojo.internal.Array(TabGroupSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("recentlyClosedTabs",16,0,mojo.internal.Array(RecentlyClosedTabSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("recentlyClosedTabGroups",24,0,mojo.internal.Array(RecentlyClosedTabGroupSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("recentlyClosedSectionExpanded",32,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,48]]);mojo.internal.Struct(WindowSpec.$,"Window",[mojo.internal.StructField("active",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isHostWindow",0,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("height",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("tabs",8,0,mojo.internal.Array(TabSpec.$,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabSpec.$,"Tab",[mojo.internal.StructField("active",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("visible",0,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("alertStates",8,0,mojo.internal.Array(TabAlertStateSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("index",4,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("tabId",16,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("groupId",24,0,TokenSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("pinned",0,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("split",0,3,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("title",32,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("url",40,0,UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("faviconUrl",48,0,UrlSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("isDefaultFavicon",0,4,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("showIcon",0,5,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("lastActiveTimeTicks",56,0,TimeTicksSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("lastActiveElapsedText",64,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,80]]);mojo.internal.Struct(RecentlyClosedTabSpec.$,"RecentlyClosedTab",[mojo.internal.StructField("tabId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("groupId",8,0,TokenSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("title",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("url",24,0,UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("lastActiveTime",32,0,TimeSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("lastActiveElapsedText",40,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,56]]);mojo.internal.Struct(TabGroupSpec.$,"TabGroup",[mojo.internal.StructField("id",0,0,TokenSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("color",8,0,ColorSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("title",16,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(RecentlyClosedTabGroupSpec.$,"RecentlyClosedTabGroup",[mojo.internal.StructField("sessionId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("id",8,0,TokenSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("color",4,0,ColorSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("title",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("tabCount",24,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("lastActiveTime",32,0,TimeSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("lastActiveElapsedText",40,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,56]]);mojo.internal.Struct(SwitchToTabInfoSpec.$,"SwitchToTabInfo",[mojo.internal.StructField("tabId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TabOrganizationSpec.$,"TabOrganization",[mojo.internal.StructField("organizationId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("tabs",8,0,mojo.internal.Array(TabSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("firstNewTabIndex",4,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("name",16,0,String16Spec.$,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(TabOrganizationSessionSpec.$,"TabOrganizationSession",[mojo.internal.StructField("sessionId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("state",4,0,TabOrganizationStateSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("organizations",8,0,mojo.internal.Array(TabOrganizationSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("error",16,0,TabOrganizationErrorSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("activeTabId",20,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(TabUpdateInfoSpec.$,"TabUpdateInfo",[mojo.internal.StructField("inActiveWindow",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("inHostWindow",0,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("tab",8,0,TabSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TabsRemovedInfoSpec.$,"TabsRemovedInfo",[mojo.internal.StructField("tabIds",0,0,mojo.internal.Array(mojo.internal.Int32,false),null,false,0,undefined,undefined),mojo.internal.StructField("recentlyClosedTabs",8,0,mojo.internal.Array(RecentlyClosedTabSpec.$,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(UnusedTabInfoSpec.$,"UnusedTabInfo",[mojo.internal.StructField("staleTabs",0,0,mojo.internal.Array(TabSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("duplicateTabs",8,0,mojo.internal.Map(mojo.internal.String,mojo.internal.Array(TabSpec.$,false),false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$,"PageHandlerFactory_CreatePageHandler_Params",[mojo.internal.StructField("page",0,0,mojo.internal.InterfaceProxy(PageRemote),null,false,0,undefined,undefined),mojo.internal.StructField("handler",8,0,mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_CloseTab_ParamsSpec.$,"PageHandler_CloseTab_Params",[mojo.internal.StructField("tabId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_CloseWebUiTab_ParamsSpec.$,"PageHandler_CloseWebUiTab_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_DeclutterTabs_ParamsSpec.$,"PageHandler_DeclutterTabs_Params",[mojo.internal.StructField("tabIds",0,0,mojo.internal.Array(mojo.internal.Int32,false),null,false,0,undefined,undefined),mojo.internal.StructField("urls",8,0,mojo.internal.Array(UrlSpec.$,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_AcceptTabOrganization_ParamsSpec.$,"PageHandler_AcceptTabOrganization_Params",[mojo.internal.StructField("sessionId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("organizationId",4,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("tabs",8,0,mojo.internal.Array(TabSpec.$,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_RejectTabOrganization_ParamsSpec.$,"PageHandler_RejectTabOrganization_Params",[mojo.internal.StructField("sessionId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("organizationId",4,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_RenameTabOrganization_ParamsSpec.$,"PageHandler_RenameTabOrganization_Params",[mojo.internal.StructField("sessionId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("organizationId",4,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("name",8,0,String16Spec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_ExcludeFromStaleTabs_ParamsSpec.$,"PageHandler_ExcludeFromStaleTabs_Params",[mojo.internal.StructField("tabId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ExcludeFromDuplicateTabs_ParamsSpec.$,"PageHandler_ExcludeFromDuplicateTabs_Params",[mojo.internal.StructField("url",0,0,UrlSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetProfileData_ParamsSpec.$,"PageHandler_GetProfileData_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetProfileData_ResponseParamsSpec.$,"PageHandler_GetProfileData_ResponseParams",[mojo.internal.StructField("profileData",0,0,ProfileDataSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetUnusedTabs_ParamsSpec.$,"PageHandler_GetUnusedTabs_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetUnusedTabs_ResponseParamsSpec.$,"PageHandler_GetUnusedTabs_ResponseParams",[mojo.internal.StructField("tabs",0,0,UnusedTabInfoSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetTabSearchSection_ParamsSpec.$,"PageHandler_GetTabSearchSection_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetTabSearchSection_ResponseParamsSpec.$,"PageHandler_GetTabSearchSection_ResponseParams",[mojo.internal.StructField("section",0,0,TabSearchSectionSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetTabOrganizationFeature_ParamsSpec.$,"PageHandler_GetTabOrganizationFeature_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetTabOrganizationFeature_ResponseParamsSpec.$,"PageHandler_GetTabOrganizationFeature_ResponseParams",[mojo.internal.StructField("feature",0,0,TabOrganizationFeatureSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetTabOrganizationSession_ParamsSpec.$,"PageHandler_GetTabOrganizationSession_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetTabOrganizationSession_ResponseParamsSpec.$,"PageHandler_GetTabOrganizationSession_ResponseParams",[mojo.internal.StructField("session",0,0,TabOrganizationSessionSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetTabOrganizationModelStrategy_ParamsSpec.$,"PageHandler_GetTabOrganizationModelStrategy_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetTabOrganizationModelStrategy_ResponseParamsSpec.$,"PageHandler_GetTabOrganizationModelStrategy_ResponseParams",[mojo.internal.StructField("strategy",0,0,TabOrganizationModelStrategySpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_GetIsSplit_ParamsSpec.$,"PageHandler_GetIsSplit_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetIsSplit_ResponseParamsSpec.$,"PageHandler_GetIsSplit_ResponseParams",[mojo.internal.StructField("isSplit",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SwitchToTab_ParamsSpec.$,"PageHandler_SwitchToTab_Params",[mojo.internal.StructField("switchToTabInfo",0,0,SwitchToTabInfoSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_OpenRecentlyClosedEntry_ParamsSpec.$,"PageHandler_OpenRecentlyClosedEntry_Params",[mojo.internal.StructField("sessionId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_RequestTabOrganization_ParamsSpec.$,"PageHandler_RequestTabOrganization_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_RemoveTabFromOrganization_ParamsSpec.$,"PageHandler_RemoveTabFromOrganization_Params",[mojo.internal.StructField("sessionId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("organizationId",4,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("tab",8,0,TabSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_RejectSession_ParamsSpec.$,"PageHandler_RejectSession_Params",[mojo.internal.StructField("sessionId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ReplaceActiveSplitTab_ParamsSpec.$,"PageHandler_ReplaceActiveSplitTab_Params",[mojo.internal.StructField("replacementTabId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_RestartSession_ParamsSpec.$,"PageHandler_RestartSession_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_SaveRecentlyClosedExpandedPref_ParamsSpec.$,"PageHandler_SaveRecentlyClosedExpandedPref_Params",[mojo.internal.StructField("expanded",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetOrganizationFeature_ParamsSpec.$,"PageHandler_SetOrganizationFeature_Params",[mojo.internal.StructField("feature",0,0,TabOrganizationFeatureSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_StartTabGroupTutorial_ParamsSpec.$,"PageHandler_StartTabGroupTutorial_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_TriggerFeedback_ParamsSpec.$,"PageHandler_TriggerFeedback_Params",[mojo.internal.StructField("sessionId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_TriggerSignIn_ParamsSpec.$,"PageHandler_TriggerSignIn_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_OpenHelpPage_ParamsSpec.$,"PageHandler_OpenHelpPage_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_SetTabOrganizationModelStrategy_ParamsSpec.$,"PageHandler_SetTabOrganizationModelStrategy_Params",[mojo.internal.StructField("strategy",0,0,TabOrganizationModelStrategySpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetTabOrganizationUserInstruction_ParamsSpec.$,"PageHandler_SetTabOrganizationUserInstruction_Params",[mojo.internal.StructField("userInstruction",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetUserFeedback_ParamsSpec.$,"PageHandler_SetUserFeedback_Params",[mojo.internal.StructField("sessionId",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("feedback",4,0,UserFeedbackSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_NotifyOrganizationUIReadyToShow_ParamsSpec.$,"PageHandler_NotifyOrganizationUIReadyToShow_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_NotifySearchUIReadyToShow_ParamsSpec.$,"PageHandler_NotifySearchUIReadyToShow_Params",[],[[0,8]]);mojo.internal.Struct(Page_TabOrganizationSessionUpdated_ParamsSpec.$,"Page_TabOrganizationSessionUpdated_Params",[mojo.internal.StructField("session",0,0,TabOrganizationSessionSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_TabOrganizationModelStrategyUpdated_ParamsSpec.$,"Page_TabOrganizationModelStrategyUpdated_Params",[mojo.internal.StructField("strategy",0,0,TabOrganizationModelStrategySpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_HostWindowChanged_ParamsSpec.$,"Page_HostWindowChanged_Params",[],[[0,8]]);mojo.internal.Struct(Page_TabsChanged_ParamsSpec.$,"Page_TabsChanged_Params",[mojo.internal.StructField("profileTabs",0,0,ProfileDataSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_TabUpdated_ParamsSpec.$,"Page_TabUpdated_Params",[mojo.internal.StructField("tabUpdateInfo",0,0,TabUpdateInfoSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_TabsRemoved_ParamsSpec.$,"Page_TabsRemoved_Params",[mojo.internal.StructField("tabsRemovedInfo",0,0,TabsRemovedInfoSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_TabSearchSectionChanged_ParamsSpec.$,"Page_TabSearchSectionChanged_Params",[mojo.internal.StructField("section",0,0,TabSearchSectionSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_TabOrganizationFeatureChanged_ParamsSpec.$,"Page_TabOrganizationFeatureChanged_Params",[mojo.internal.StructField("feature",0,0,TabOrganizationFeatureSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_ShowFREChanged_ParamsSpec.$,"Page_ShowFREChanged_Params",[mojo.internal.StructField("show",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_TabOrganizationEnabledChanged_ParamsSpec.$,"Page_TabOrganizationEnabledChanged_Params",[mojo.internal.StructField("enabled",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_UnusedTabsChanged_ParamsSpec.$,"Page_UnusedTabsChanged_Params",[mojo.internal.StructField("tabs",0,0,UnusedTabInfoSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_TabUnsplit_ParamsSpec.$,"Page_TabUnsplit_Params",[],[[0,8]]);var RecentlyClosedItemOpenAction;(function(RecentlyClosedItemOpenAction){RecentlyClosedItemOpenAction[RecentlyClosedItemOpenAction["WITHOUT_SEARCH"]=0]="WITHOUT_SEARCH";RecentlyClosedItemOpenAction[RecentlyClosedItemOpenAction["WITH_SEARCH"]=1]="WITH_SEARCH"})(RecentlyClosedItemOpenAction||(RecentlyClosedItemOpenAction={}));class TabSearchApiProxyImpl{callbackRouter=new PageCallbackRouter;handler=new PageHandlerRemote;constructor(){const factory=PageHandlerFactory.getRemote();factory.createPageHandler(this.callbackRouter.$.bindNewPipeAndPassRemote(),this.handler.$.bindNewPipeAndPassReceiver())}closeTab(tabId){this.handler.closeTab(tabId)}closeWebUiTab(){this.handler.closeWebUiTab()}declutterTabs(tabIds,urls){this.handler.declutterTabs(tabIds,urls)}acceptTabOrganization(sessionId,organizationId,tabs){this.handler.acceptTabOrganization(sessionId,organizationId,tabs)}rejectTabOrganization(sessionId,organizationId){this.handler.rejectTabOrganization(sessionId,organizationId)}renameTabOrganization(sessionId,organizationId,name){this.handler.renameTabOrganization(sessionId,organizationId,stringToMojoString16(name))}excludeFromStaleTabs(tabId){this.handler.excludeFromStaleTabs(tabId)}excludeFromDuplicateTabs(url){this.handler.excludeFromDuplicateTabs(url)}getProfileData(){return this.handler.getProfileData()}getUnusedTabs(){return this.handler.getUnusedTabs()}getTabSearchSection(){return this.handler.getTabSearchSection()}getTabOrganizationFeature(){return this.handler.getTabOrganizationFeature()}getTabOrganizationSession(){return this.handler.getTabOrganizationSession()}getTabOrganizationModelStrategy(){return this.handler.getTabOrganizationModelStrategy()}getIsSplit(){return this.handler.getIsSplit()}openRecentlyClosedEntry(id,withSearch,isTab,index){chrome.metricsPrivate.recordEnumerationValue(isTab?"Tabs.TabSearch.WebUI.RecentlyClosedTabOpenAction":"Tabs.TabSearch.WebUI.RecentlyClosedGroupOpenAction",withSearch?RecentlyClosedItemOpenAction.WITH_SEARCH:RecentlyClosedItemOpenAction.WITHOUT_SEARCH,Object.keys(RecentlyClosedItemOpenAction).length);chrome.metricsPrivate.recordSmallCount(withSearch?"Tabs.TabSearch.WebUI.IndexOfOpenRecentlyClosedEntryInFilteredList":"Tabs.TabSearch.WebUI.IndexOfOpenRecentlyClosedEntryInUnfilteredList",index);this.handler.openRecentlyClosedEntry(id)}requestTabOrganization(){this.handler.requestTabOrganization()}rejectSession(sessionId){this.handler.rejectSession(sessionId)}restartSession(){this.handler.restartSession()}switchToTab(info){this.handler.switchToTab(info)}getCallbackRouter(){return this.callbackRouter}removeTabFromOrganization(sessionId,organizationId,tab){this.handler.removeTabFromOrganization(sessionId,organizationId,tab)}replaceActiveSplitTab(replacementSplitTabId){this.handler.replaceActiveSplitTab(replacementSplitTabId)}saveRecentlyClosedExpandedPref(expanded){this.handler.saveRecentlyClosedExpandedPref(expanded)}setOrganizationFeature(feature){this.handler.setOrganizationFeature(feature)}startTabGroupTutorial(){this.handler.startTabGroupTutorial()}triggerFeedback(sessionId){this.handler.triggerFeedback(sessionId)}triggerSignIn(){this.handler.triggerSignIn()}openHelpPage(){this.handler.openHelpPage()}setTabOrganizationModelStrategy(strategy){this.handler.setTabOrganizationModelStrategy(strategy)}setTabOrganizationUserInstruction(userInstruction){this.handler.setTabOrganizationUserInstruction(userInstruction)}setUserFeedback(sessionId,feedback){this.handler.setUserFeedback(sessionId,feedback)}notifyOrganizationUiReadyToShow(){this.handler.notifyOrganizationUIReadyToShow()}notifySearchUiReadyToShow(){this.handler.notifySearchUIReadyToShow()}static getInstance(){return instance$2||(instance$2=new TabSearchApiProxyImpl)}static setInstance(obj){instance$2=obj}}let instance$2=null;let instance$1=null;function getCss$1(){return instance$1||(instance$1=[...[],css`::-webkit-scrollbar-thumb{background-color:var(--mwb-scrollbar-thumb-color)}::-webkit-scrollbar-thumb:hover{background-color:var(--mwb-scrollbar-thumb-hover-color)}::-webkit-scrollbar-track{background-color:var(--mwb-scrollbar-track-color)}::-webkit-scrollbar{width:var(--mwb-scrollbar-width)}.mwb-list-item{align-items:center;background-color:var(--mwb-background-color);contain-intrinsic-size:var(--mwb-item-height);content-visibility:auto;display:flex;height:var(--mwb-item-height);padding:0 var(--mwb-list-item-horizontal-margin)}.mwb-list-item.hovered{background-color:var(--mwb-list-item-hover-background-color)}.mwb-list-item.selected{background-color:var(--mwb-list-item-selected-background-color)}`])}let instance=null;function getCss(){return instance||(instance=[...[getCss$1()],css`:host{display:flex;flex-direction:column;height:100vh}#header{display:flex;flex-direction:column}picture{align-items:center;align-self:center;display:flex;height:130px;justify-content:center;width:130px;margin-block-end:16px;margin-block-start:32px}#closeButton{--cr-icon-button-size:20px;--cr-icon-button-icon-size:16px;align-self:flex-end;margin:24px}.title{align-self:center;text-align:center;color:var(--cr-primary-text-color);font-size:16px;font-weight:500;line-height:24px;margin:0 16px}.body{align-self:center;color:var(--cr-primary-text-color);font-size:14px;font-weight:400;line-height:20px;margin:4px 16px;text-align:center}.tab-list:not([hidden]){display:flex;max-height:calc(100% - 92px - 4 * 16px);background:var(--color-tab-search-background);border-radius:16px;margin:16px auto;width:calc(min(100% - 2*16px,394px));padding:16px 0}.scroller{flex:1;max-height:none;display:block;overflow-x:hidden;overflow-y:auto;scrollbar-gutter:stable}.scroller::-webkit-scrollbar{width:8px}.scroller::-webkit-scrollbar-thumb{border-radius:8px}`])}function getHtml(){return html`<!--_html_template_start_-->
<div id="header">
  <cr-icon-button id="closeButton"
      iron-icon="tab-search:close"
      aria-label="$i18n{splitViewCloseButtonAriaLabel}"
      @click="${this.onClose_}">
  </cr-icon-button>
  ${this.allEligibleTabs_.length===0?html`
        <picture>
          <source media="(prefers-color-scheme: dark)"
              srcset="./split_view/images/empty_dark.svg">
          <img id="product-logo" srcset="./split_view/images/empty.svg" alt="">
        </picture>
      `:html``}
  <h1 class="title">${this.title_}</h1>
  ${this.allEligibleTabs_.length===0?html`<div class="body">$i18n{splitViewEmptyBody}</div>`:html``}
</div>
<div class="tab-list" ?hidden="${this.allEligibleTabs_.length===0}">
  <selectable-lazy-list id="splitTabsList" class="scroller"
      .items="${this.allEligibleTabs_}"
      item-size="66"
      max-height="${this.minViewportHeight_}"
      role="listbox"
      .template="${(item,index)=>html`<tab-search-item class="mwb-list-item selectable"
          hide-close-button
          hide-timestamp
          size="large"
          .data="${item}"
          data-index="${index}"
          @click="${this.onTabClick_}"
          @focus="${this.onTabFocus_}"
          @focusout="${this.onTabFocusOut_}"
          @keydown="${this.onTabKeyDown_}"
          role="option"
          aria-label="${ariaLabel(item)}"
          tabindex="0">
        </tab-search-item>`}">
  </selectable-lazy-list>
</div>
<!--_html_template_end_-->`}class SplitNewTabPageAppElement extends CrLitElement{static get is(){return"split-new-tab-page-app"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{allEligibleTabs_:{type:Array},minViewportHeight_:{type:Number}}}#allEligibleTabs__accessor_storage=[];get allEligibleTabs_(){return this.#allEligibleTabs__accessor_storage}set allEligibleTabs_(value){this.#allEligibleTabs__accessor_storage=value}#minViewportHeight__accessor_storage=0;get minViewportHeight_(){return this.#minViewportHeight__accessor_storage}set minViewportHeight_(value){this.#minViewportHeight__accessor_storage=value}title_="";apiProxy_=TabSearchApiProxyImpl.getInstance();listenerIds_=[];visibilityChangedListener_;constructor(){super();ColorChangeUpdater.forDocument().start();this.visibilityChangedListener_=()=>{if(document.visibilityState==="visible"){this.apiProxy_.getProfileData().then((({profileData:profileData})=>{this.onTabsChanged_(profileData)}))}}}connectedCallback(){super.connectedCallback();if(loadTimeData.getBoolean("splitViewEnabled")){this.apiProxy_.getIsSplit().then((({isSplit:isSplit})=>{if(!isSplit){this.redirectToNtp_()}}))}else{this.redirectToNtp_()}const callbackRouter=this.apiProxy_.getCallbackRouter();this.listenerIds_.push(callbackRouter.tabsChanged.addListener(this.onTabsChanged_.bind(this)),callbackRouter.tabUpdated.addListener(this.onTabUpdated_.bind(this)),callbackRouter.tabsRemoved.addListener(this.onTabsRemoved_.bind(this)),callbackRouter.tabUnsplit.addListener(this.redirectToNtp_.bind(this)),callbackRouter.hostWindowChanged.addListener(this.hostWindowChanged_.bind(this)));this.apiProxy_.getProfileData().then((({profileData:profileData})=>{this.onTabsChanged_(profileData)}));document.addEventListener("visibilitychange",this.visibilityChangedListener_)}disconnectedCallback(){super.disconnectedCallback();this.listenerIds_.forEach((id=>this.apiProxy_.getCallbackRouter().removeListener(id)));this.listenerIds_=[];document.removeEventListener("visibilitychange",this.visibilityChangedListener_)}onClose_(){this.apiProxy_.closeWebUiTab()}onTabClick_(e){const target=e.currentTarget;this.apiProxy_.replaceActiveSplitTab(target.data.tab.tabId)}onTabFocus_(e){const target=e.currentTarget;const index=Number(target.dataset["index"]);this.$.splitTabsList.setSelected(index)}onTabFocusOut_(_){this.$.splitTabsList.resetSelected()}onTabKeyDown_(e){if(e.key!=="Enter"&&e.key!==" "){return}this.onTabClick_(e)}onTabsChanged_(profileData){const hostWindow=profileData.windows.find((({isHostWindow:isHostWindow})=>isHostWindow));this.allEligibleTabs_=hostWindow.tabs.filter((tab=>!tab.visible&&!tab.split)).map((tab=>this.getTabData_(tab,true,TabItemType.OPEN_TAB)));this.sortTabs_();this.updateComplete.then((()=>{this.updateViewportHeight_(profileData)}))}onTabUpdated_(tabUpdateInfo){const{tab:tab,inActiveWindow:inActiveWindow,inHostWindow:inHostWindow}=tabUpdateInfo;if(!inHostWindow){return}const tabData=this.getTabData_(tab,inActiveWindow,TabItemType.OPEN_TAB);const tabIndex=this.allEligibleTabs_.findIndex((el=>el.tab.tabId===tab.tabId));if(tabIndex>=0){this.allEligibleTabs_[tabIndex]=tabData}else{this.allEligibleTabs_.push(tabData)}this.allEligibleTabs_=this.allEligibleTabs_.filter((tab=>!tab.tab.visible&&!tab.tab.split));this.sortTabs_()}onTabsRemoved_(tabsRemovedInfo){if(this.allEligibleTabs_.length===0){return}const ids=new Set(tabsRemovedInfo.tabIds);this.allEligibleTabs_=this.allEligibleTabs_.filter((tab=>!ids.has(tab.tab.tabId)));this.sortTabs_()}sortTabs_(){if(this.allEligibleTabs_.length===0){this.redirectToNtp_()}this.allEligibleTabs_.sort(((a,b)=>{const tabA=a.tab;const tabB=b.tab;if(tabHasMediaAlerts(tabA)&&!tabHasMediaAlerts(tabB)){return-1}else if(!tabHasMediaAlerts(tabA)&&tabHasMediaAlerts(tabB)){return 1}return tabB.lastActiveTimeTicks&&tabA.lastActiveTimeTicks?Number(tabB.lastActiveTimeTicks.internalValue-tabA.lastActiveTimeTicks.internalValue):0}));this.title_=this.allEligibleTabs_.length===0?loadTimeData.getString("splitViewEmptyTitle"):loadTimeData.getString("splitViewTitle")}getTabData_(tab,inActiveWindow,type){const tabData=new TabData(tab,type,new URL(normalizeURL(tab.url.url)).hostname);if(type===TabItemType.OPEN_TAB){tabData.inActiveWindow=inActiveWindow}tabData.a11yTypeText=loadTimeData.getString("a11yOpenTab");return tabData}redirectToNtp_(){window.location.replace(loadTimeData.getString("newTabPageUrl"))}hostWindowChanged_(){this.apiProxy_.getProfileData().then((({profileData:profileData})=>{this.onTabsChanged_(profileData)}))}updateViewportHeight_(profileData){const hostWindow=profileData.windows.find((({isHostWindow:isHostWindow})=>isHostWindow));this.minViewportHeight_=hostWindow?hostWindow.height-this.$.header.offsetHeight:0}}customElements.define(SplitNewTabPageAppElement.is,SplitNewTabPageAppElement);export{listenOnce as A,tokenToString as B,CrRippleMixin as C,DeclutterCTREvent as D,EventTracker as E,selectorNavigationKeys as F,ariaLabel as G,tabHasMediaAlerts as H,tokenEquals as I,getDeepActiveElement as J,SelectableLazyListElement as K,SplitNewTabPageAppElement as L,MouseHoverableMixinLit as M,NO_SELECTION as N,ItemData as O,PageCallbackRouter as P,PageRemote as Q,TabAlertState as R,SelectorCTREvent as S,TabOrganizationError as T,UserFeedback as U,getTrustedHTML as a,assert as b,assertNotReached as c,TabOrganizationModelStrategy as d,getCss$1 as e,TabData as f,getCss$a as g,TabItemType as h,TabOrganizationState as i,TabSearchApiProxyImpl as j,TabSearchItemElement as k,TabOrganizationFeature as l,mojoString16ToString as m,normalizeURL as n,TabDeclutterEntryPoint as o,TabGroupData as p,Color as q,colorName as r,highlightText as s,TimeDeltaSpec as t,quoteString as u,getTitle as v,getHostname as w,getTabGroupTitle as x,ColorChangeUpdater as y,TabSearchSection as z};