import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_page_selector/cr_page_selector.js';
import 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import './data_collectors.js';
import './issue_details.js';
import './spinner_page.js';
import './pii_selection.js';
import './data_export_done.js';
import './support_tool_shared.css.js';
import type { CrToastElement } from 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { DataCollectorsElement } from './data_collectors.js';
import type { DataExportDoneElement } from './data_export_done.js';
import type { IssueDetailsElement } from './issue_details.js';
import type { PiiSelectionElement } from './pii_selection.js';
import type { SpinnerPageElement } from './spinner_page.js';
export declare enum SupportToolPageIndex {
    ISSUE_DETAILS = 0,
    DATA_COLLECTOR_SELECTION = 1,
    SPINNER = 2,
    PII_SELECTION = 3,
    EXPORT_SPINNER = 4,
    DATA_EXPORT_DONE = 5
}
export interface DataExportResult {
    success: boolean;
    path: string;
    error: string;
}
export interface SupportToolElement {
    $: {
        issueDetails: IssueDetailsElement;
        dataCollectors: DataCollectorsElement;
        spinnerPage: SpinnerPageElement;
        piiSelection: PiiSelectionElement;
        exportSpinner: SpinnerPageElement;
        dataExportDone: DataExportDoneElement;
        errorMessageToast: CrToastElement;
    };
}
declare const SupportToolElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export declare class SupportToolElement extends SupportToolElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        selectedPage_: {
            type: typeof SupportToolPageIndex;
            value: SupportToolPageIndex;
            observer: string;
        };
        supportToolPageIndexEnum_: {
            readonly: boolean;
            type: ObjectConstructor;
            value: typeof SupportToolPageIndex;
        };
        errorMessage_: {
            type: StringConstructor;
            value: string;
        };
    };
    private errorMessage_;
    private selectedPage_;
    private browserProxy_;
    connectedCallback(): void;
    private onScreenshotReceived_;
    private onDataExportStarted_;
    private onDataCollectionCompleted_;
    private onDataCollectionCancelled_;
    private displayError_;
    private onDataExportCompleted_;
    private onDataCollectionStart_;
    private onErrorMessageToastCloseClicked_;
    private onContinueClick_;
    private onBackClick_;
    private shouldHideBackButton_;
    private shouldHideContinueButtonContainer_;
    private onSelectedPageChange_;
}
declare global {
    interface HTMLElementTagNameMap {
        'support-tool': SupportToolElement;
    }
}
export {};
