import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><!--
Copyright 2022 The Chromium Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file.
-->

<style include="md-select support-tool-shared cr-shared-style">.md-select{--md-select-text-color:var(--cr-primary-text-color);margin-bottom:5px;width:248px}#description{height:120px;width:520px}</style>

<h1 tabindex="0">$i18n{issueDetailsPageTitle}</h1>
<div class="support-tool-title">$i18n{supportCaseId}</div>
<cr-input class="support-case-id" value="{{caseId_}}"
    spellcheck="false" maxlength="20" aria-label="$i18n{supportCaseId}">
</cr-input>
<div id="email-title" class="support-tool-title" aria-hidden="true">
  $i18n{email}
</div>
<select class="md-select" value="{{selectedEmail_::change}}"
    aria-labelledby="email-title">
  <template is="dom-repeat" items="[[emails_]]">
    <option class="md-select" value="[[item]]">[[item]]</option>
  </template>
</select>
<div id="description-title" class="support-tool-title" aria-hidden="true">
  $i18n{describeIssueText}
</div>
<cr-textarea id="description" spellcheck="true"
    value="{{issueDescription_::input}}" aria-labelledby="description-title"
    placeholder="$i18n{issueDescriptionPlaceholder}">
</cr-textarea>
<!--_html_template_end_-->`;
}
