// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { sendWithPromise } from 'chrome://resources/js/cr.js';
export class BrowserProxyImpl {
    getEmailAddresses() {
        return sendWithPromise('getEmailAddresses');
    }
    getDataCollectors() {
        return sendWithPromise('getDataCollectors');
    }
    getAllDataCollectors() {
        return sendWithPromise('getAllDataCollectors');
    }
    takeScreenshot() {
        chrome.send('takeScreenshot');
    }
    startDataCollection(issueDetails, dataCollectors, screenshotBase64) {
        return sendWithPromise('startDataCollection', issueDetails, dataCollectors, screenshotBase64);
    }
    cancelDataCollection() {
        chrome.send('cancelDataCollection');
    }
    startDataExport(piiItems) {
        chrome.send('startDataExport', [piiItems]);
    }
    showExportedDataInFolder() {
        chrome.send('showExportedDataInFolder');
    }
    generateCustomizedUrl(caseId, dataCollectors) {
        return sendWithPromise('generateCustomizedUrl', caseId, dataCollectors);
    }
    generateSupportToken(dataCollectors) {
        return sendWithPromise('generateSupportToken', dataCollectors);
    }
    static getInstance() {
        return instance || (instance = new BrowserProxyImpl());
    }
    static setInstance(obj) {
        instance = obj;
    }
}
// The singleton instance_ is replaced with a test version of this wrapper
// during testing.
let instance = null;
