// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var UmaName;
(function (UmaName) {
    UmaName["NEW_PAGE"] = "Accessibility.ReadAnything.NewPage";
    UmaName["LANGUAGE"] = "Accessibility.ReadAnything.ReadAloud.Language";
    UmaName["VOICE"] = "Accessibility.ReadAnything.ReadAloud.Voice";
    UmaName["TEXT_SETTINGS_CHANGE"] = "Accessibility.ReadAnything.SettingsChange";
    UmaName["HIGHLIGHT_STATE"] = "Accessibility.ReadAnything.ReadAloud.HighlightState";
    UmaName["HIGHLIGHT_GRANULARITY"] = "Accessibility.ReadAnything.ReadAloud.HighlightGranularity";
    UmaName["VOICE_SPEED"] = "Accessibility.ReadAnything.ReadAloud.VoiceSpeed";
    UmaName["SPEECH_SETTINGS_CHANGE"] = "Accessibility.ReadAnything.ReadAloud.SettingsChange";
    UmaName["SPEECH_PLAYBACK"] = "Accessibility.ReadAnything.SpeechPlaybackSession";
    UmaName["SPEECH_ERROR"] = "Accessibility.ReadAnything.SpeechError";
})(UmaName || (UmaName = {}));
// Enum for logging when we play speech on a page.
// These values are persisted to logs. Entries should not be renumbered and
// numeric values should never be reused.
//
// LINT.IfChange(ReadAnythingNewPage)
export var ReadAnythingNewPage;
(function (ReadAnythingNewPage) {
    ReadAnythingNewPage[ReadAnythingNewPage["NEW_PAGE"] = 0] = "NEW_PAGE";
    ReadAnythingNewPage[ReadAnythingNewPage["SPEECH_PLAYED_ON_NEW_PAGE"] = 1] = "SPEECH_PLAYED_ON_NEW_PAGE";
    // Must be last.
    ReadAnythingNewPage[ReadAnythingNewPage["COUNT"] = 2] = "COUNT";
})(ReadAnythingNewPage || (ReadAnythingNewPage = {}));
// LINT.ThenChange(/tools/metrics/histograms/metadata/accessibility/enums.xml:ReadAnythingNewPage)
// Enum for logging which kind of voice is being used to read aloud.
// These values are persisted to logs. Entries should not be renumbered and
// numeric values should never be reused.
//
// LINT.IfChange(ReadAnythingVoiceType)
export var ReadAnythingVoiceType;
(function (ReadAnythingVoiceType) {
    ReadAnythingVoiceType[ReadAnythingVoiceType["NATURAL"] = 0] = "NATURAL";
    ReadAnythingVoiceType[ReadAnythingVoiceType["ESPEAK"] = 1] = "ESPEAK";
    ReadAnythingVoiceType[ReadAnythingVoiceType["CHROMEOS"] = 2] = "CHROMEOS";
    ReadAnythingVoiceType[ReadAnythingVoiceType["SYSTEM"] = 3] = "SYSTEM";
    // Must be last.
    ReadAnythingVoiceType[ReadAnythingVoiceType["COUNT"] = 4] = "COUNT";
})(ReadAnythingVoiceType || (ReadAnythingVoiceType = {}));
// LINT.ThenChange(/tools/metrics/histograms/metadata/accessibility/enums.xml:ReadAnythingReadAloudVoice2)
// Enum for logging when a text style setting is changed.
// These values are persisted to logs. Entries should not be renumbered and
// numeric values should never be reused.
//
// LINT.IfChange(ReadAnythingSettingsChange)
export var ReadAnythingSettingsChange;
(function (ReadAnythingSettingsChange) {
    ReadAnythingSettingsChange[ReadAnythingSettingsChange["FONT_CHANGE"] = 0] = "FONT_CHANGE";
    ReadAnythingSettingsChange[ReadAnythingSettingsChange["FONT_SIZE_CHANGE"] = 1] = "FONT_SIZE_CHANGE";
    ReadAnythingSettingsChange[ReadAnythingSettingsChange["THEME_CHANGE"] = 2] = "THEME_CHANGE";
    ReadAnythingSettingsChange[ReadAnythingSettingsChange["LINE_HEIGHT_CHANGE"] = 3] = "LINE_HEIGHT_CHANGE";
    ReadAnythingSettingsChange[ReadAnythingSettingsChange["LETTER_SPACING_CHANGE"] = 4] = "LETTER_SPACING_CHANGE";
    ReadAnythingSettingsChange[ReadAnythingSettingsChange["LINKS_ENABLED_CHANGE"] = 5] = "LINKS_ENABLED_CHANGE";
    ReadAnythingSettingsChange[ReadAnythingSettingsChange["IMAGES_ENABLED_CHANGE"] = 6] = "IMAGES_ENABLED_CHANGE";
    // Must be last.
    ReadAnythingSettingsChange[ReadAnythingSettingsChange["COUNT"] = 7] = "COUNT";
})(ReadAnythingSettingsChange || (ReadAnythingSettingsChange = {}));
// LINT.ThenChange(/tools/metrics/histograms/metadata/accessibility/enums.xml:ReadAnythingSettingsChange)
// Enum for logging the reading highlight state.
// These values are persisted to logs. Entries should not be renumbered and
// numeric values should never be reused.
//
// LINT.IfChange(ReadAloudHighlightState)
export var ReadAloudHighlightState;
(function (ReadAloudHighlightState) {
    ReadAloudHighlightState[ReadAloudHighlightState["HIGHLIGHT_ON"] = 0] = "HIGHLIGHT_ON";
    ReadAloudHighlightState[ReadAloudHighlightState["HIGHLIGHT_OFF"] = 1] = "HIGHLIGHT_OFF";
    // Must be last.
    ReadAloudHighlightState[ReadAloudHighlightState["COUNT"] = 2] = "COUNT";
})(ReadAloudHighlightState || (ReadAloudHighlightState = {}));
// LINT.ThenChange(/tools/metrics/histograms/metadata/accessibility/enums.xml:ReadAnythingHighlightState)
// Enum for logging the reading highlight granularity.
// These values are persisted to logs. Entries should not be renumbered and
// numeric values should never be reused.
//
// LINT.IfChange(ReadAloudHighlightGranularity)
export var ReadAloudHighlightGranularity;
(function (ReadAloudHighlightGranularity) {
    ReadAloudHighlightGranularity[ReadAloudHighlightGranularity["HIGHLIGHT_AUTO"] = 0] = "HIGHLIGHT_AUTO";
    ReadAloudHighlightGranularity[ReadAloudHighlightGranularity["HIGHLIGHT_OFF"] = 1] = "HIGHLIGHT_OFF";
    ReadAloudHighlightGranularity[ReadAloudHighlightGranularity["HIGHLIGHT_WORD"] = 2] = "HIGHLIGHT_WORD";
    ReadAloudHighlightGranularity[ReadAloudHighlightGranularity["HIGHLIGHT_PHRASE"] = 3] = "HIGHLIGHT_PHRASE";
    ReadAloudHighlightGranularity[ReadAloudHighlightGranularity["HIGHLIGHT_SENTENCE"] = 4] = "HIGHLIGHT_SENTENCE";
    // Must be last.
    ReadAloudHighlightGranularity[ReadAloudHighlightGranularity["COUNT"] = 5] = "COUNT";
})(ReadAloudHighlightGranularity || (ReadAloudHighlightGranularity = {}));
// LINT.ThenChange(/tools/metrics/histograms/metadata/accessibility/enums.xml:ReadAnythingHighlightGranularity)
// Enum for logging when a read aloud speech setting is changed.
// These values are persisted to logs. Entries should not be renumbered and
// numeric values should never be reused.
//
// LINT.IfChange(ReadAloudSettingsChange)
export var ReadAloudSettingsChange;
(function (ReadAloudSettingsChange) {
    ReadAloudSettingsChange[ReadAloudSettingsChange["VOICE_SPEED_CHANGE"] = 0] = "VOICE_SPEED_CHANGE";
    ReadAloudSettingsChange[ReadAloudSettingsChange["VOICE_NAME_CHANGE"] = 1] = "VOICE_NAME_CHANGE";
    ReadAloudSettingsChange[ReadAloudSettingsChange["HIGHLIGHT_CHANGE"] = 2] = "HIGHLIGHT_CHANGE";
    // Must be last.
    ReadAloudSettingsChange[ReadAloudSettingsChange["COUNT"] = 3] = "COUNT";
})(ReadAloudSettingsChange || (ReadAloudSettingsChange = {}));
// LINT.ThenChange(/tools/metrics/histograms/metadata/accessibility/enums.xml:ReadAnythingReadAloudSettingsChange)
// Enum for logging when a speech error event occurs.
// These values are persisted to logs. Entries should not be renumbered and
// numeric values should never be reused.
//
// LINT.IfChange(ReadAnythingSpeechError)
export var ReadAnythingSpeechError;
(function (ReadAnythingSpeechError) {
    ReadAnythingSpeechError[ReadAnythingSpeechError["TEXT_TOO_LONG"] = 0] = "TEXT_TOO_LONG";
    ReadAnythingSpeechError[ReadAnythingSpeechError["LANGUAGE_UNAVAILABLE"] = 1] = "LANGUAGE_UNAVAILABLE";
    ReadAnythingSpeechError[ReadAnythingSpeechError["VOICE_UNAVAILABE"] = 2] = "VOICE_UNAVAILABE";
    ReadAnythingSpeechError[ReadAnythingSpeechError["INVALID_ARGUMENT"] = 3] = "INVALID_ARGUMENT";
    ReadAnythingSpeechError[ReadAnythingSpeechError["SYNTHESIS_FAILED"] = 4] = "SYNTHESIS_FAILED";
    ReadAnythingSpeechError[ReadAnythingSpeechError["SYNTHESIS_UNVAILABLE"] = 5] = "SYNTHESIS_UNVAILABLE";
    ReadAnythingSpeechError[ReadAnythingSpeechError["AUDIO_BUSY"] = 6] = "AUDIO_BUSY";
    ReadAnythingSpeechError[ReadAnythingSpeechError["AUDIO_HARDWARE"] = 7] = "AUDIO_HARDWARE";
    ReadAnythingSpeechError[ReadAnythingSpeechError["NETWORK"] = 8] = "NETWORK";
    // Must be last.
    ReadAnythingSpeechError[ReadAnythingSpeechError["COUNT"] = 9] = "COUNT";
})(ReadAnythingSpeechError || (ReadAnythingSpeechError = {}));
export class MetricsBrowserProxyImpl {
    incrementMetricCount(umaName) {
        chrome.readingMode.incrementMetricCount(umaName);
    }
    recordEmptyState() {
        chrome.readingMode.logEmptyState();
    }
    recordSpeechStopSource(source) {
        chrome.readingMode.logSpeechStop(source);
    }
    recordSpeechError(error) {
        chrome.metricsPrivate.recordEnumerationValue(UmaName.SPEECH_ERROR, error, ReadAnythingSpeechError.COUNT);
    }
    recordTime(umaName, time) {
        chrome.metricsPrivate.recordTime(umaName, time);
    }
    recordNewPage() {
        chrome.metricsPrivate.recordEnumerationValue(UmaName.NEW_PAGE, ReadAnythingNewPage.NEW_PAGE, ReadAnythingNewPage.COUNT);
    }
    recordNewPageWithSpeech() {
        chrome.metricsPrivate.recordEnumerationValue(UmaName.NEW_PAGE, ReadAnythingNewPage.SPEECH_PLAYED_ON_NEW_PAGE, ReadAnythingNewPage.COUNT);
    }
    recordHighlightOn() {
        chrome.metricsPrivate.recordEnumerationValue(UmaName.HIGHLIGHT_STATE, ReadAloudHighlightState.HIGHLIGHT_ON, ReadAloudHighlightState.COUNT);
    }
    recordHighlightOff() {
        chrome.metricsPrivate.recordEnumerationValue(UmaName.HIGHLIGHT_STATE, ReadAloudHighlightState.HIGHLIGHT_OFF, ReadAloudHighlightState.COUNT);
    }
    recordHighlightGranularity(highlight) {
        chrome.metricsPrivate.recordEnumerationValue(UmaName.HIGHLIGHT_GRANULARITY, highlight, ReadAloudHighlightGranularity.COUNT);
    }
    recordVoiceType(voiceType) {
        chrome.metricsPrivate.recordEnumerationValue(UmaName.VOICE, voiceType, ReadAnythingVoiceType.COUNT);
    }
    recordLanguage(lang) {
        chrome.metricsPrivate.recordSparseValueWithHashMetricName(UmaName.LANGUAGE, lang);
    }
    recordTextSettingsChange(settingsChange) {
        chrome.metricsPrivate.recordEnumerationValue(UmaName.TEXT_SETTINGS_CHANGE, settingsChange, ReadAnythingSettingsChange.COUNT);
    }
    recordSpeechSettingsChange(settingsChange) {
        chrome.metricsPrivate.recordEnumerationValue(UmaName.SPEECH_SETTINGS_CHANGE, settingsChange, ReadAloudSettingsChange.COUNT);
    }
    recordVoiceSpeed(index) {
        chrome.metricsPrivate.recordSmallCount(UmaName.VOICE_SPEED, index);
    }
    recordSpeechPlaybackLength(time) {
        chrome.metricsPrivate.recordLongTime(UmaName.SPEECH_PLAYBACK, time);
    }
    recordExtensionState() {
        chrome.readingMode.logExtensionState();
    }
    static getInstance() {
        return instance || (instance = new MetricsBrowserProxyImpl());
    }
    static setInstance(obj) {
        instance = obj;
    }
}
let instance = null;
