// chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  TileTypeSpec as ntpTiles_mojom_TileTypeSpec,
  TileType as ntpTiles_mojom_TileType
} from './tile_type.mojom-webui.js';
import {
  TokenSpec as mojoBase_mojom_TokenSpec,
  Token as mojoBase_mojom_Token
} from '//resources/mojo/mojo/public/mojom/base/token.mojom-webui.js';
import {
  SkColorSpec as skia_mojom_SkColorSpec,
  SkColor as skia_mojom_SkColor
} from '//resources/mojo/skia/public/mojom/skcolor.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const CustomizeChromeSectionSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum CustomizeChromeSection {

  MIN_VALUE = 0,
  MAX_VALUE = 5,
  kAppearance = 0,
  kShortcuts = 1,
  kModules = 2,
  kWallpaperSearch = 3,
  kToolbar = 4,
  kFooter = 5,
}

export const ChromeWebStoreCollectionSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ChromeWebStoreCollection {

  MIN_VALUE = 0,
  MAX_VALUE = 0,
  kWritingEssentials = 0,
}

export const ChromeWebStoreCategorySpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ChromeWebStoreCategory {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kWorkflowPlanning = 0,
  kShopping = 1,
}

export const NewTabPageTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum NewTabPageType {

  MIN_VALUE = 0,
  MAX_VALUE = 6,
  kFirstPartyWebUI = 0,
  kThirdPartyWebUI = 1,
  kThirdPartyRemote = 2,
  kExtension = 3,
  kIncognito = 4,
  kGuestMode = 5,
  kNone = 6,
}



export type CustomizeChromePageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<CustomizeChromePageHandlerFactoryPendingReceiver>;

export class CustomizeChromePageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<CustomizeChromePageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<CustomizeChromePageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|CustomizeChromePageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'side_panel.mojom.CustomizeChromePageHandlerFactory',
        scope);
  }
}

export interface CustomizeChromePageHandlerFactoryInterface {
  createPageHandler(page: CustomizeChromePageRemote, handler: CustomizeChromePageHandlerPendingReceiver): void;
}

export class CustomizeChromePageHandlerFactoryRemote implements CustomizeChromePageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<CustomizeChromePageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CustomizeChromePageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|CustomizeChromePageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CustomizeChromePageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: CustomizeChromePageRemote,
      handler: CustomizeChromePageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        CustomizeChromePageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CustomizeChromePageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CustomizeChromePageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CustomizeChromePageHandlerFactoryRemote, CustomizeChromePageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CustomizeChromePageHandlerFactoryRemote, CustomizeChromePageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: CustomizeChromePageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CustomizeChromePageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CustomizeChromePageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CustomizeChromePageHandlerFactory {
  static get $interfaceName(): string {
    return "side_panel.mojom.CustomizeChromePageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): CustomizeChromePageHandlerFactoryRemote {
    let remote = new CustomizeChromePageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the CustomizeChromePageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CustomizeChromePageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CustomizeChromePageHandlerFactoryRemote, CustomizeChromePageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CustomizeChromePageHandlerFactoryRemote, CustomizeChromePageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CustomizeChromePageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CustomizeChromePageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type CustomizeChromePageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<CustomizeChromePageHandlerPendingReceiver>;

export class CustomizeChromePageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<CustomizeChromePageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<CustomizeChromePageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|CustomizeChromePageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'side_panel.mojom.CustomizeChromePageHandler',
        scope);
  }
}

export interface CustomizeChromePageHandlerInterface {
  setMostVisitedSettings(shortcutsType: ntpTiles_mojom_TileType, shortcutsVisible: boolean): void;
  updateMostVisitedSettings(): void;
  getBackgroundCollections(): Promise<{
        collections: BackgroundCollection[], }>;
  getReplacementCollectionPreviewImage(collectionId: string): Promise<{
        previewImageUrl: (url_mojom_Url | null), }>;
  getBackgroundImages(collectionId: string): Promise<{
        images: CollectionImage[], }>;
  updateModulesSettings(): void;
  updateTheme(): void;
  updateThemeEditable(isThemeEditable: boolean): void;
  setDefaultColor(): void;
  setFollowDeviceTheme(follow: boolean): void;
  removeBackgroundImage(): void;
  chooseLocalCustomBackground(): Promise<{
        success: boolean, }>;
  setBackgroundImage(attribution1: string, attribution2: string, attributionUrl: url_mojom_Url, imageUrl: url_mojom_Url, thumbnailUrl: url_mojom_Url, collectionId: string): void;
  setDailyRefreshCollectionId(collectionId: string): void;
  openChromeWebStore(): void;
  openChromeWebStoreHomePage(): void;
  openThirdPartyThemePage(themeId: string): void;
  openChromeWebStoreCategoryPage(category: ChromeWebStoreCategory): void;
  openChromeWebStoreCollectionPage(collection: ChromeWebStoreCollection): void;
  openNtpManagedByPage(): void;
  setModulesVisible(visible: boolean): void;
  setModuleDisabled(moduleId: string, disabled: boolean): void;
  updateScrollToSection(): void;
  updateAttachedTabState(): void;
  updateNtpManagedByName(): void;
  setFooterVisible(visible: boolean): void;
  updateFooterSettings(): void;
}

export class CustomizeChromePageHandlerRemote implements CustomizeChromePageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<CustomizeChromePageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CustomizeChromePageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|CustomizeChromePageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CustomizeChromePageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setMostVisitedSettings(
      shortcutsType: ntpTiles_mojom_TileType,
      shortcutsVisible: boolean): void {
    this.proxy.sendMessage(
        0,
        CustomizeChromePageHandler_SetMostVisitedSettings_ParamsSpec.$,
        null,
        [
          shortcutsType,
          shortcutsVisible
        ],
        false);
  }

  updateMostVisitedSettings(): void {
    this.proxy.sendMessage(
        1,
        CustomizeChromePageHandler_UpdateMostVisitedSettings_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  getBackgroundCollections(): Promise<{
        collections: BackgroundCollection[], }> {
    return this.proxy.sendMessage(
        2,
        CustomizeChromePageHandler_GetBackgroundCollections_ParamsSpec.$,
        CustomizeChromePageHandler_GetBackgroundCollections_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getReplacementCollectionPreviewImage(
      collectionId: string): Promise<{
        previewImageUrl: (url_mojom_Url | null), }> {
    return this.proxy.sendMessage(
        3,
        CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ParamsSpec.$,
        CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParamsSpec.$,
        [
          collectionId
        ],
        false);
  }

  getBackgroundImages(
      collectionId: string): Promise<{
        images: CollectionImage[], }> {
    return this.proxy.sendMessage(
        4,
        CustomizeChromePageHandler_GetBackgroundImages_ParamsSpec.$,
        CustomizeChromePageHandler_GetBackgroundImages_ResponseParamsSpec.$,
        [
          collectionId
        ],
        false);
  }

  updateModulesSettings(): void {
    this.proxy.sendMessage(
        5,
        CustomizeChromePageHandler_UpdateModulesSettings_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  updateTheme(): void {
    this.proxy.sendMessage(
        6,
        CustomizeChromePageHandler_UpdateTheme_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  updateThemeEditable(
      isThemeEditable: boolean): void {
    this.proxy.sendMessage(
        7,
        CustomizeChromePageHandler_UpdateThemeEditable_ParamsSpec.$,
        null,
        [
          isThemeEditable
        ],
        false);
  }

  setDefaultColor(): void {
    this.proxy.sendMessage(
        8,
        CustomizeChromePageHandler_SetDefaultColor_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setFollowDeviceTheme(
      follow: boolean): void {
    this.proxy.sendMessage(
        9,
        CustomizeChromePageHandler_SetFollowDeviceTheme_ParamsSpec.$,
        null,
        [
          follow
        ],
        false);
  }

  removeBackgroundImage(): void {
    this.proxy.sendMessage(
        10,
        CustomizeChromePageHandler_RemoveBackgroundImage_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  chooseLocalCustomBackground(): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        11,
        CustomizeChromePageHandler_ChooseLocalCustomBackground_ParamsSpec.$,
        CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  setBackgroundImage(
      attribution1: string,
      attribution2: string,
      attributionUrl: url_mojom_Url,
      imageUrl: url_mojom_Url,
      thumbnailUrl: url_mojom_Url,
      collectionId: string): void {
    this.proxy.sendMessage(
        12,
        CustomizeChromePageHandler_SetBackgroundImage_ParamsSpec.$,
        null,
        [
          attribution1,
          attribution2,
          attributionUrl,
          imageUrl,
          thumbnailUrl,
          collectionId
        ],
        false);
  }

  setDailyRefreshCollectionId(
      collectionId: string): void {
    this.proxy.sendMessage(
        13,
        CustomizeChromePageHandler_SetDailyRefreshCollectionId_ParamsSpec.$,
        null,
        [
          collectionId
        ],
        false);
  }

  openChromeWebStore(): void {
    this.proxy.sendMessage(
        14,
        CustomizeChromePageHandler_OpenChromeWebStore_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openChromeWebStoreHomePage(): void {
    this.proxy.sendMessage(
        15,
        CustomizeChromePageHandler_OpenChromeWebStoreHomePage_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  openThirdPartyThemePage(
      themeId: string): void {
    this.proxy.sendMessage(
        16,
        CustomizeChromePageHandler_OpenThirdPartyThemePage_ParamsSpec.$,
        null,
        [
          themeId
        ],
        false);
  }

  openChromeWebStoreCategoryPage(
      category: ChromeWebStoreCategory): void {
    this.proxy.sendMessage(
        17,
        CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_ParamsSpec.$,
        null,
        [
          category
        ],
        false);
  }

  openChromeWebStoreCollectionPage(
      collection: ChromeWebStoreCollection): void {
    this.proxy.sendMessage(
        18,
        CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_ParamsSpec.$,
        null,
        [
          collection
        ],
        false);
  }

  openNtpManagedByPage(): void {
    this.proxy.sendMessage(
        19,
        CustomizeChromePageHandler_OpenNtpManagedByPage_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setModulesVisible(
      visible: boolean): void {
    this.proxy.sendMessage(
        20,
        CustomizeChromePageHandler_SetModulesVisible_ParamsSpec.$,
        null,
        [
          visible
        ],
        false);
  }

  setModuleDisabled(
      moduleId: string,
      disabled: boolean): void {
    this.proxy.sendMessage(
        21,
        CustomizeChromePageHandler_SetModuleDisabled_ParamsSpec.$,
        null,
        [
          moduleId,
          disabled
        ],
        false);
  }

  updateScrollToSection(): void {
    this.proxy.sendMessage(
        22,
        CustomizeChromePageHandler_UpdateScrollToSection_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  updateAttachedTabState(): void {
    this.proxy.sendMessage(
        23,
        CustomizeChromePageHandler_UpdateAttachedTabState_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  updateNtpManagedByName(): void {
    this.proxy.sendMessage(
        24,
        CustomizeChromePageHandler_UpdateNtpManagedByName_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setFooterVisible(
      visible: boolean): void {
    this.proxy.sendMessage(
        25,
        CustomizeChromePageHandler_SetFooterVisible_ParamsSpec.$,
        null,
        [
          visible
        ],
        false);
  }

  updateFooterSettings(): void {
    this.proxy.sendMessage(
        26,
        CustomizeChromePageHandler_UpdateFooterSettings_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CustomizeChromePageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CustomizeChromePageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CustomizeChromePageHandlerRemote, CustomizeChromePageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CustomizeChromePageHandlerRemote, CustomizeChromePageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: CustomizeChromePageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CustomizeChromePageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CustomizeChromePageHandler_SetMostVisitedSettings_ParamsSpec.$,
        null,
        impl.setMostVisitedSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CustomizeChromePageHandler_UpdateMostVisitedSettings_ParamsSpec.$,
        null,
        impl.updateMostVisitedSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CustomizeChromePageHandler_GetBackgroundCollections_ParamsSpec.$,
        CustomizeChromePageHandler_GetBackgroundCollections_ResponseParamsSpec.$,
        impl.getBackgroundCollections.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ParamsSpec.$,
        CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParamsSpec.$,
        impl.getReplacementCollectionPreviewImage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        CustomizeChromePageHandler_GetBackgroundImages_ParamsSpec.$,
        CustomizeChromePageHandler_GetBackgroundImages_ResponseParamsSpec.$,
        impl.getBackgroundImages.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        CustomizeChromePageHandler_UpdateModulesSettings_ParamsSpec.$,
        null,
        impl.updateModulesSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        CustomizeChromePageHandler_UpdateTheme_ParamsSpec.$,
        null,
        impl.updateTheme.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        CustomizeChromePageHandler_UpdateThemeEditable_ParamsSpec.$,
        null,
        impl.updateThemeEditable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        CustomizeChromePageHandler_SetDefaultColor_ParamsSpec.$,
        null,
        impl.setDefaultColor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        CustomizeChromePageHandler_SetFollowDeviceTheme_ParamsSpec.$,
        null,
        impl.setFollowDeviceTheme.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        CustomizeChromePageHandler_RemoveBackgroundImage_ParamsSpec.$,
        null,
        impl.removeBackgroundImage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        CustomizeChromePageHandler_ChooseLocalCustomBackground_ParamsSpec.$,
        CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParamsSpec.$,
        impl.chooseLocalCustomBackground.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        CustomizeChromePageHandler_SetBackgroundImage_ParamsSpec.$,
        null,
        impl.setBackgroundImage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        CustomizeChromePageHandler_SetDailyRefreshCollectionId_ParamsSpec.$,
        null,
        impl.setDailyRefreshCollectionId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        CustomizeChromePageHandler_OpenChromeWebStore_ParamsSpec.$,
        null,
        impl.openChromeWebStore.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        CustomizeChromePageHandler_OpenChromeWebStoreHomePage_ParamsSpec.$,
        null,
        impl.openChromeWebStoreHomePage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        CustomizeChromePageHandler_OpenThirdPartyThemePage_ParamsSpec.$,
        null,
        impl.openThirdPartyThemePage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_ParamsSpec.$,
        null,
        impl.openChromeWebStoreCategoryPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_ParamsSpec.$,
        null,
        impl.openChromeWebStoreCollectionPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        CustomizeChromePageHandler_OpenNtpManagedByPage_ParamsSpec.$,
        null,
        impl.openNtpManagedByPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        CustomizeChromePageHandler_SetModulesVisible_ParamsSpec.$,
        null,
        impl.setModulesVisible.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        CustomizeChromePageHandler_SetModuleDisabled_ParamsSpec.$,
        null,
        impl.setModuleDisabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        CustomizeChromePageHandler_UpdateScrollToSection_ParamsSpec.$,
        null,
        impl.updateScrollToSection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        CustomizeChromePageHandler_UpdateAttachedTabState_ParamsSpec.$,
        null,
        impl.updateAttachedTabState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        CustomizeChromePageHandler_UpdateNtpManagedByName_ParamsSpec.$,
        null,
        impl.updateNtpManagedByName.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        CustomizeChromePageHandler_SetFooterVisible_ParamsSpec.$,
        null,
        impl.setFooterVisible.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        CustomizeChromePageHandler_UpdateFooterSettings_ParamsSpec.$,
        null,
        impl.updateFooterSettings.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CustomizeChromePageHandler {
  static get $interfaceName(): string {
    return "side_panel.mojom.CustomizeChromePageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): CustomizeChromePageHandlerRemote {
    let remote = new CustomizeChromePageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the CustomizeChromePageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CustomizeChromePageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CustomizeChromePageHandlerRemote, CustomizeChromePageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CustomizeChromePageHandlerRemote, CustomizeChromePageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setMostVisitedSettings: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateMostVisitedSettings: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getBackgroundCollections: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getReplacementCollectionPreviewImage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getBackgroundImages: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateModulesSettings: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateTheme: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateThemeEditable: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setDefaultColor: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setFollowDeviceTheme: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  removeBackgroundImage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  chooseLocalCustomBackground: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setBackgroundImage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setDailyRefreshCollectionId: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openChromeWebStore: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openChromeWebStoreHomePage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openThirdPartyThemePage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openChromeWebStoreCategoryPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openChromeWebStoreCollectionPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openNtpManagedByPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setModulesVisible: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setModuleDisabled: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateScrollToSection: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateAttachedTabState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateNtpManagedByName: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setFooterVisible: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateFooterSettings: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CustomizeChromePageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setMostVisitedSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CustomizeChromePageHandler_SetMostVisitedSettings_ParamsSpec.$,
        null,
        this.setMostVisitedSettings.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateMostVisitedSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CustomizeChromePageHandler_UpdateMostVisitedSettings_ParamsSpec.$,
        null,
        this.updateMostVisitedSettings.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getBackgroundCollections =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CustomizeChromePageHandler_GetBackgroundCollections_ParamsSpec.$,
        CustomizeChromePageHandler_GetBackgroundCollections_ResponseParamsSpec.$,
        this.getBackgroundCollections.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getReplacementCollectionPreviewImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ParamsSpec.$,
        CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParamsSpec.$,
        this.getReplacementCollectionPreviewImage.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getBackgroundImages =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        CustomizeChromePageHandler_GetBackgroundImages_ParamsSpec.$,
        CustomizeChromePageHandler_GetBackgroundImages_ResponseParamsSpec.$,
        this.getBackgroundImages.createReceiverHandler(true /* expectsResponse */),
        false);
    this.updateModulesSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        CustomizeChromePageHandler_UpdateModulesSettings_ParamsSpec.$,
        null,
        this.updateModulesSettings.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateTheme =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        CustomizeChromePageHandler_UpdateTheme_ParamsSpec.$,
        null,
        this.updateTheme.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateThemeEditable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        CustomizeChromePageHandler_UpdateThemeEditable_ParamsSpec.$,
        null,
        this.updateThemeEditable.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setDefaultColor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        CustomizeChromePageHandler_SetDefaultColor_ParamsSpec.$,
        null,
        this.setDefaultColor.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setFollowDeviceTheme =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        CustomizeChromePageHandler_SetFollowDeviceTheme_ParamsSpec.$,
        null,
        this.setFollowDeviceTheme.createReceiverHandler(false /* expectsResponse */),
        false);
    this.removeBackgroundImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        CustomizeChromePageHandler_RemoveBackgroundImage_ParamsSpec.$,
        null,
        this.removeBackgroundImage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.chooseLocalCustomBackground =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        CustomizeChromePageHandler_ChooseLocalCustomBackground_ParamsSpec.$,
        CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParamsSpec.$,
        this.chooseLocalCustomBackground.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setBackgroundImage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        CustomizeChromePageHandler_SetBackgroundImage_ParamsSpec.$,
        null,
        this.setBackgroundImage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setDailyRefreshCollectionId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        CustomizeChromePageHandler_SetDailyRefreshCollectionId_ParamsSpec.$,
        null,
        this.setDailyRefreshCollectionId.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openChromeWebStore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        CustomizeChromePageHandler_OpenChromeWebStore_ParamsSpec.$,
        null,
        this.openChromeWebStore.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openChromeWebStoreHomePage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        CustomizeChromePageHandler_OpenChromeWebStoreHomePage_ParamsSpec.$,
        null,
        this.openChromeWebStoreHomePage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openThirdPartyThemePage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        CustomizeChromePageHandler_OpenThirdPartyThemePage_ParamsSpec.$,
        null,
        this.openThirdPartyThemePage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openChromeWebStoreCategoryPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_ParamsSpec.$,
        null,
        this.openChromeWebStoreCategoryPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openChromeWebStoreCollectionPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_ParamsSpec.$,
        null,
        this.openChromeWebStoreCollectionPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.openNtpManagedByPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        CustomizeChromePageHandler_OpenNtpManagedByPage_ParamsSpec.$,
        null,
        this.openNtpManagedByPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setModulesVisible =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        CustomizeChromePageHandler_SetModulesVisible_ParamsSpec.$,
        null,
        this.setModulesVisible.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setModuleDisabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        CustomizeChromePageHandler_SetModuleDisabled_ParamsSpec.$,
        null,
        this.setModuleDisabled.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateScrollToSection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        CustomizeChromePageHandler_UpdateScrollToSection_ParamsSpec.$,
        null,
        this.updateScrollToSection.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateAttachedTabState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        CustomizeChromePageHandler_UpdateAttachedTabState_ParamsSpec.$,
        null,
        this.updateAttachedTabState.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateNtpManagedByName =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        CustomizeChromePageHandler_UpdateNtpManagedByName_ParamsSpec.$,
        null,
        this.updateNtpManagedByName.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setFooterVisible =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        CustomizeChromePageHandler_SetFooterVisible_ParamsSpec.$,
        null,
        this.setFooterVisible.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateFooterSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        CustomizeChromePageHandler_UpdateFooterSettings_ParamsSpec.$,
        null,
        this.updateFooterSettings.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type CustomizeChromePagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<CustomizeChromePagePendingReceiver>;

export class CustomizeChromePagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<CustomizeChromePage> {

  handle: mojo.internal.interfaceSupport.Endpoint<CustomizeChromePagePendingReceiver>;
  constructor(handle: MojoHandle|CustomizeChromePagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'side_panel.mojom.CustomizeChromePage',
        scope);
  }
}

export interface CustomizeChromePageInterface {
  setModulesSettings(modulesSettings: ModuleSettings[], managed: boolean, visible: boolean): void;
  setMostVisitedSettings(shortcutsType: ntpTiles_mojom_TileType, visible: boolean, disabledShortcuts: ntpTiles_mojom_TileType[]): void;
  setFooterSettings(visible: boolean, extensionPolicyEnabled: boolean, managementNoticeState: ManagementNoticeState): void;
  setTheme(theme: Theme): void;
  setThemeEditable(isThemeEditable: boolean): void;
  scrollToSection(section: CustomizeChromeSection): void;
  attachedTabStateUpdated(ntpType: NewTabPageType): void;
  ntpManagedByNameUpdated(name: string, description: string): void;
}

export class CustomizeChromePageRemote implements CustomizeChromePageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<CustomizeChromePagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<CustomizeChromePagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|CustomizeChromePagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CustomizeChromePagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setModulesSettings(
      modulesSettings: ModuleSettings[],
      managed: boolean,
      visible: boolean): void {
    this.proxy.sendMessage(
        0,
        CustomizeChromePage_SetModulesSettings_ParamsSpec.$,
        null,
        [
          modulesSettings,
          managed,
          visible
        ],
        false);
  }

  setMostVisitedSettings(
      shortcutsType: ntpTiles_mojom_TileType,
      visible: boolean,
      disabledShortcuts: ntpTiles_mojom_TileType[]): void {
    this.proxy.sendMessage(
        1,
        CustomizeChromePage_SetMostVisitedSettings_ParamsSpec.$,
        null,
        [
          shortcutsType,
          visible,
          disabledShortcuts
        ],
        false);
  }

  setFooterSettings(
      visible: boolean,
      extensionPolicyEnabled: boolean,
      managementNoticeState: ManagementNoticeState): void {
    this.proxy.sendMessage(
        2,
        CustomizeChromePage_SetFooterSettings_ParamsSpec.$,
        null,
        [
          visible,
          extensionPolicyEnabled,
          managementNoticeState
        ],
        false);
  }

  setTheme(
      theme: Theme): void {
    this.proxy.sendMessage(
        3,
        CustomizeChromePage_SetTheme_ParamsSpec.$,
        null,
        [
          theme
        ],
        false);
  }

  setThemeEditable(
      isThemeEditable: boolean): void {
    this.proxy.sendMessage(
        4,
        CustomizeChromePage_SetThemeEditable_ParamsSpec.$,
        null,
        [
          isThemeEditable
        ],
        false);
  }

  scrollToSection(
      section: CustomizeChromeSection): void {
    this.proxy.sendMessage(
        5,
        CustomizeChromePage_ScrollToSection_ParamsSpec.$,
        null,
        [
          section
        ],
        false);
  }

  attachedTabStateUpdated(
      ntpType: NewTabPageType): void {
    this.proxy.sendMessage(
        6,
        CustomizeChromePage_AttachedTabStateUpdated_ParamsSpec.$,
        null,
        [
          ntpType
        ],
        false);
  }

  ntpManagedByNameUpdated(
      name: string,
      description: string): void {
    this.proxy.sendMessage(
        7,
        CustomizeChromePage_NtpManagedByNameUpdated_ParamsSpec.$,
        null,
        [
          name,
          description
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CustomizeChromePage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CustomizeChromePageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CustomizeChromePageRemote, CustomizeChromePagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CustomizeChromePageRemote, CustomizeChromePagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: CustomizeChromePageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CustomizeChromePageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CustomizeChromePage_SetModulesSettings_ParamsSpec.$,
        null,
        impl.setModulesSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CustomizeChromePage_SetMostVisitedSettings_ParamsSpec.$,
        null,
        impl.setMostVisitedSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CustomizeChromePage_SetFooterSettings_ParamsSpec.$,
        null,
        impl.setFooterSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        CustomizeChromePage_SetTheme_ParamsSpec.$,
        null,
        impl.setTheme.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        CustomizeChromePage_SetThemeEditable_ParamsSpec.$,
        null,
        impl.setThemeEditable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        CustomizeChromePage_ScrollToSection_ParamsSpec.$,
        null,
        impl.scrollToSection.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        CustomizeChromePage_AttachedTabStateUpdated_ParamsSpec.$,
        null,
        impl.attachedTabStateUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        CustomizeChromePage_NtpManagedByNameUpdated_ParamsSpec.$,
        null,
        impl.ntpManagedByNameUpdated.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CustomizeChromePage {
  static get $interfaceName(): string {
    return "side_panel.mojom.CustomizeChromePage";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): CustomizeChromePageRemote {
    let remote = new CustomizeChromePageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the CustomizeChromePage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CustomizeChromePageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    CustomizeChromePageRemote, CustomizeChromePagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    CustomizeChromePageRemote, CustomizeChromePagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setModulesSettings: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setMostVisitedSettings: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setFooterSettings: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setTheme: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setThemeEditable: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  scrollToSection: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  attachedTabStateUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  ntpManagedByNameUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CustomizeChromePageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setModulesSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CustomizeChromePage_SetModulesSettings_ParamsSpec.$,
        null,
        this.setModulesSettings.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setMostVisitedSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CustomizeChromePage_SetMostVisitedSettings_ParamsSpec.$,
        null,
        this.setMostVisitedSettings.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setFooterSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CustomizeChromePage_SetFooterSettings_ParamsSpec.$,
        null,
        this.setFooterSettings.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setTheme =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        CustomizeChromePage_SetTheme_ParamsSpec.$,
        null,
        this.setTheme.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setThemeEditable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        CustomizeChromePage_SetThemeEditable_ParamsSpec.$,
        null,
        this.setThemeEditable.createReceiverHandler(false /* expectsResponse */),
        false);
    this.scrollToSection =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        CustomizeChromePage_ScrollToSection_ParamsSpec.$,
        null,
        this.scrollToSection.createReceiverHandler(false /* expectsResponse */),
        false);
    this.attachedTabStateUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        CustomizeChromePage_AttachedTabStateUpdated_ParamsSpec.$,
        null,
        this.attachedTabStateUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.ntpManagedByNameUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        CustomizeChromePage_NtpManagedByNameUpdated_ParamsSpec.$,
        null,
        this.ntpManagedByNameUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const BackgroundImageSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ThirdPartyThemeInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ThemeSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const BackgroundCollectionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CollectionImageSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ModuleSettingsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ManagementNoticeStateSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_SetMostVisitedSettings_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_UpdateMostVisitedSettings_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_GetBackgroundCollections_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_GetBackgroundCollections_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_GetBackgroundImages_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_GetBackgroundImages_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_UpdateModulesSettings_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_UpdateTheme_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_UpdateThemeEditable_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_SetDefaultColor_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_SetFollowDeviceTheme_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_RemoveBackgroundImage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_ChooseLocalCustomBackground_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_SetBackgroundImage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_SetDailyRefreshCollectionId_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_OpenChromeWebStore_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_OpenChromeWebStoreHomePage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_OpenThirdPartyThemePage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_OpenNtpManagedByPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_SetModulesVisible_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_SetModuleDisabled_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_UpdateScrollToSection_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_UpdateAttachedTabState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_UpdateNtpManagedByName_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_SetFooterVisible_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePageHandler_UpdateFooterSettings_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePage_SetModulesSettings_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePage_SetMostVisitedSettings_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePage_SetFooterSettings_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePage_SetTheme_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePage_SetThemeEditable_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePage_ScrollToSection_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePage_AttachedTabStateUpdated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const CustomizeChromePage_NtpManagedByNameUpdated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface BackgroundImageMojoType {
  url: url_mojom_Url;
  snapshotUrl: url_mojom_Url;
  isUploadedImage: boolean;
  dailyRefreshEnabled: boolean;
  localBackgroundId: (mojoBase_mojom_Token | null);
  title: string;
  collectionId: string;
}


export type BackgroundImage = BackgroundImageMojoType;
mojo.internal.Struct<BackgroundImageMojoType>(
    BackgroundImageSpec.$,
    'BackgroundImage',
    [
      mojo.internal.StructField<BackgroundImageMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageMojoType, url_mojom_Url>(
        'snapshotUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageMojoType, boolean>(
        'isUploadedImage', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageMojoType, mojoBase_mojom_Token>(
        'localBackgroundId', 24,
        0,
        mojoBase_mojom_TokenSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageMojoType, string>(
        'title', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageMojoType, string>(
        'collectionId', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundImageMojoType, boolean>(
        'dailyRefreshEnabled', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface ThirdPartyThemeInfoMojoType {
  id: string;
  name: string;
}


export type ThirdPartyThemeInfo = ThirdPartyThemeInfoMojoType;
mojo.internal.Struct<ThirdPartyThemeInfoMojoType>(
    ThirdPartyThemeInfoSpec.$,
    'ThirdPartyThemeInfo',
    [
      mojo.internal.StructField<ThirdPartyThemeInfoMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThirdPartyThemeInfoMojoType, string>(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ThemeMojoType {
  backgroundImage: (BackgroundImage | null);
  thirdPartyThemeInfo: (ThirdPartyThemeInfo | null);
  backgroundColor: skia_mojom_SkColor;
  foregroundColor: (skia_mojom_SkColor | null);
  backgroundManagedByPolicy: boolean;
  followDeviceTheme: boolean;
}


export type Theme = ThemeMojoType;
mojo.internal.Struct<ThemeMojoType>(
    ThemeSpec.$,
    'Theme',
    [
      mojo.internal.StructField<ThemeMojoType, BackgroundImage>(
        'backgroundImage', 0,
        0,
        BackgroundImageSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, ThirdPartyThemeInfo>(
        'thirdPartyThemeInfo', 8,
        0,
        ThirdPartyThemeInfoSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, skia_mojom_SkColor>(
        'backgroundColor', 16,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, skia_mojom_SkColor>(
        'foregroundColor', 24,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, boolean>(
        'backgroundManagedByPolicy', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ThemeMojoType, boolean>(
        'followDeviceTheme', 32,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);





export interface BackgroundCollectionMojoType {
  id: string;
  label: string;
  previewImageUrl: url_mojom_Url;
  imageVerified: boolean;
}


export type BackgroundCollection = BackgroundCollectionMojoType;
mojo.internal.Struct<BackgroundCollectionMojoType>(
    BackgroundCollectionSpec.$,
    'BackgroundCollection',
    [
      mojo.internal.StructField<BackgroundCollectionMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundCollectionMojoType, string>(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundCollectionMojoType, url_mojom_Url>(
        'previewImageUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<BackgroundCollectionMojoType, boolean>(
        'imageVerified', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface CollectionImageMojoType {
  attribution1: string;
  attribution2: string;
  attributionUrl: url_mojom_Url;
  imageUrl: url_mojom_Url;
  previewImageUrl: url_mojom_Url;
  collectionId: string;
  imageVerified: boolean;
}


export type CollectionImage = CollectionImageMojoType;
mojo.internal.Struct<CollectionImageMojoType>(
    CollectionImageSpec.$,
    'CollectionImage',
    [
      mojo.internal.StructField<CollectionImageMojoType, string>(
        'attribution1', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CollectionImageMojoType, string>(
        'attribution2', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CollectionImageMojoType, url_mojom_Url>(
        'attributionUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CollectionImageMojoType, url_mojom_Url>(
        'imageUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CollectionImageMojoType, url_mojom_Url>(
        'previewImageUrl', 32,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CollectionImageMojoType, string>(
        'collectionId', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CollectionImageMojoType, boolean>(
        'imageVerified', 48,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 64],]);





export interface ModuleSettingsMojoType {
  id: string;
  name: string;
  description: (string | null);
  enabled: boolean;
  visible: boolean;
}


export type ModuleSettings = ModuleSettingsMojoType;
mojo.internal.Struct<ModuleSettingsMojoType>(
    ModuleSettingsSpec.$,
    'ModuleSettings',
    [
      mojo.internal.StructField<ModuleSettingsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ModuleSettingsMojoType, string>(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ModuleSettingsMojoType, string>(
        'description', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ModuleSettingsMojoType, boolean>(
        'enabled', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ModuleSettingsMojoType, boolean>(
        'visible', 24,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface ManagementNoticeStateMojoType {
  canBeShown: boolean;
  enabledByPolicy: boolean;
}


export type ManagementNoticeState = ManagementNoticeStateMojoType;
mojo.internal.Struct<ManagementNoticeStateMojoType>(
    ManagementNoticeStateSpec.$,
    'ManagementNoticeState',
    [
      mojo.internal.StructField<ManagementNoticeStateMojoType, boolean>(
        'canBeShown', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ManagementNoticeStateMojoType, boolean>(
        'enabledByPolicy', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: CustomizeChromePageRemote;
  handler: CustomizeChromePageHandlerPendingReceiver;
}


export type CustomizeChromePageHandlerFactory_CreatePageHandler_Params = CustomizeChromePageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    CustomizeChromePageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'CustomizeChromePageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<CustomizeChromePageHandlerFactory_CreatePageHandler_ParamsMojoType, CustomizeChromePageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(CustomizeChromePageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeChromePageHandlerFactory_CreatePageHandler_ParamsMojoType, CustomizeChromePageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(CustomizeChromePageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface CustomizeChromePageHandler_SetMostVisitedSettings_ParamsMojoType {
  shortcutsType: ntpTiles_mojom_TileType;
  shortcutsVisible: boolean;
}


export type CustomizeChromePageHandler_SetMostVisitedSettings_Params = CustomizeChromePageHandler_SetMostVisitedSettings_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_SetMostVisitedSettings_ParamsMojoType>(
    CustomizeChromePageHandler_SetMostVisitedSettings_ParamsSpec.$,
    'CustomizeChromePageHandler_SetMostVisitedSettings_Params',
    [
      mojo.internal.StructField<CustomizeChromePageHandler_SetMostVisitedSettings_ParamsMojoType, ntpTiles_mojom_TileType>(
        'shortcutsType', 0,
        0,
        ntpTiles_mojom_TileTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeChromePageHandler_SetMostVisitedSettings_ParamsMojoType, boolean>(
        'shortcutsVisible', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePageHandler_UpdateMostVisitedSettings_ParamsMojoType {
}


export type CustomizeChromePageHandler_UpdateMostVisitedSettings_Params = CustomizeChromePageHandler_UpdateMostVisitedSettings_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_UpdateMostVisitedSettings_ParamsMojoType>(
    CustomizeChromePageHandler_UpdateMostVisitedSettings_ParamsSpec.$,
    'CustomizeChromePageHandler_UpdateMostVisitedSettings_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeChromePageHandler_GetBackgroundCollections_ParamsMojoType {
}


export type CustomizeChromePageHandler_GetBackgroundCollections_Params = CustomizeChromePageHandler_GetBackgroundCollections_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_GetBackgroundCollections_ParamsMojoType>(
    CustomizeChromePageHandler_GetBackgroundCollections_ParamsSpec.$,
    'CustomizeChromePageHandler_GetBackgroundCollections_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeChromePageHandler_GetBackgroundCollections_ResponseParamsMojoType {
  collections: BackgroundCollection[];
}


export type CustomizeChromePageHandler_GetBackgroundCollections_ResponseParams = CustomizeChromePageHandler_GetBackgroundCollections_ResponseParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_GetBackgroundCollections_ResponseParamsMojoType>(
    CustomizeChromePageHandler_GetBackgroundCollections_ResponseParamsSpec.$,
    'CustomizeChromePageHandler_GetBackgroundCollections_ResponseParams',
    [
      mojo.internal.StructField<CustomizeChromePageHandler_GetBackgroundCollections_ResponseParamsMojoType, BackgroundCollection[]>(
        'collections', 0,
        0,
        mojo.internal.Array(BackgroundCollectionSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ParamsMojoType {
  collectionId: string;
}


export type CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_Params = CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ParamsMojoType>(
    CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ParamsSpec.$,
    'CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_Params',
    [
      mojo.internal.StructField<CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ParamsMojoType, string>(
        'collectionId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParamsMojoType {
  previewImageUrl: (url_mojom_Url | null);
}


export type CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParams = CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParamsMojoType>(
    CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParamsSpec.$,
    'CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParams',
    [
      mojo.internal.StructField<CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParamsMojoType, url_mojom_Url>(
        'previewImageUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePageHandler_GetBackgroundImages_ParamsMojoType {
  collectionId: string;
}


export type CustomizeChromePageHandler_GetBackgroundImages_Params = CustomizeChromePageHandler_GetBackgroundImages_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_GetBackgroundImages_ParamsMojoType>(
    CustomizeChromePageHandler_GetBackgroundImages_ParamsSpec.$,
    'CustomizeChromePageHandler_GetBackgroundImages_Params',
    [
      mojo.internal.StructField<CustomizeChromePageHandler_GetBackgroundImages_ParamsMojoType, string>(
        'collectionId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePageHandler_GetBackgroundImages_ResponseParamsMojoType {
  images: CollectionImage[];
}


export type CustomizeChromePageHandler_GetBackgroundImages_ResponseParams = CustomizeChromePageHandler_GetBackgroundImages_ResponseParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_GetBackgroundImages_ResponseParamsMojoType>(
    CustomizeChromePageHandler_GetBackgroundImages_ResponseParamsSpec.$,
    'CustomizeChromePageHandler_GetBackgroundImages_ResponseParams',
    [
      mojo.internal.StructField<CustomizeChromePageHandler_GetBackgroundImages_ResponseParamsMojoType, CollectionImage[]>(
        'images', 0,
        0,
        mojo.internal.Array(CollectionImageSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePageHandler_UpdateModulesSettings_ParamsMojoType {
}


export type CustomizeChromePageHandler_UpdateModulesSettings_Params = CustomizeChromePageHandler_UpdateModulesSettings_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_UpdateModulesSettings_ParamsMojoType>(
    CustomizeChromePageHandler_UpdateModulesSettings_ParamsSpec.$,
    'CustomizeChromePageHandler_UpdateModulesSettings_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeChromePageHandler_UpdateTheme_ParamsMojoType {
}


export type CustomizeChromePageHandler_UpdateTheme_Params = CustomizeChromePageHandler_UpdateTheme_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_UpdateTheme_ParamsMojoType>(
    CustomizeChromePageHandler_UpdateTheme_ParamsSpec.$,
    'CustomizeChromePageHandler_UpdateTheme_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeChromePageHandler_UpdateThemeEditable_ParamsMojoType {
  isThemeEditable: boolean;
}


export type CustomizeChromePageHandler_UpdateThemeEditable_Params = CustomizeChromePageHandler_UpdateThemeEditable_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_UpdateThemeEditable_ParamsMojoType>(
    CustomizeChromePageHandler_UpdateThemeEditable_ParamsSpec.$,
    'CustomizeChromePageHandler_UpdateThemeEditable_Params',
    [
      mojo.internal.StructField<CustomizeChromePageHandler_UpdateThemeEditable_ParamsMojoType, boolean>(
        'isThemeEditable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePageHandler_SetDefaultColor_ParamsMojoType {
}


export type CustomizeChromePageHandler_SetDefaultColor_Params = CustomizeChromePageHandler_SetDefaultColor_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_SetDefaultColor_ParamsMojoType>(
    CustomizeChromePageHandler_SetDefaultColor_ParamsSpec.$,
    'CustomizeChromePageHandler_SetDefaultColor_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeChromePageHandler_SetFollowDeviceTheme_ParamsMojoType {
  follow: boolean;
}


export type CustomizeChromePageHandler_SetFollowDeviceTheme_Params = CustomizeChromePageHandler_SetFollowDeviceTheme_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_SetFollowDeviceTheme_ParamsMojoType>(
    CustomizeChromePageHandler_SetFollowDeviceTheme_ParamsSpec.$,
    'CustomizeChromePageHandler_SetFollowDeviceTheme_Params',
    [
      mojo.internal.StructField<CustomizeChromePageHandler_SetFollowDeviceTheme_ParamsMojoType, boolean>(
        'follow', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePageHandler_RemoveBackgroundImage_ParamsMojoType {
}


export type CustomizeChromePageHandler_RemoveBackgroundImage_Params = CustomizeChromePageHandler_RemoveBackgroundImage_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_RemoveBackgroundImage_ParamsMojoType>(
    CustomizeChromePageHandler_RemoveBackgroundImage_ParamsSpec.$,
    'CustomizeChromePageHandler_RemoveBackgroundImage_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeChromePageHandler_ChooseLocalCustomBackground_ParamsMojoType {
}


export type CustomizeChromePageHandler_ChooseLocalCustomBackground_Params = CustomizeChromePageHandler_ChooseLocalCustomBackground_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_ChooseLocalCustomBackground_ParamsMojoType>(
    CustomizeChromePageHandler_ChooseLocalCustomBackground_ParamsSpec.$,
    'CustomizeChromePageHandler_ChooseLocalCustomBackground_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParamsMojoType {
  success: boolean;
}


export type CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParams = CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParamsMojoType>(
    CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParamsSpec.$,
    'CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParams',
    [
      mojo.internal.StructField<CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePageHandler_SetBackgroundImage_ParamsMojoType {
  attribution1: string;
  attribution2: string;
  attributionUrl: url_mojom_Url;
  imageUrl: url_mojom_Url;
  thumbnailUrl: url_mojom_Url;
  collectionId: string;
}


export type CustomizeChromePageHandler_SetBackgroundImage_Params = CustomizeChromePageHandler_SetBackgroundImage_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_SetBackgroundImage_ParamsMojoType>(
    CustomizeChromePageHandler_SetBackgroundImage_ParamsSpec.$,
    'CustomizeChromePageHandler_SetBackgroundImage_Params',
    [
      mojo.internal.StructField<CustomizeChromePageHandler_SetBackgroundImage_ParamsMojoType, string>(
        'attribution1', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeChromePageHandler_SetBackgroundImage_ParamsMojoType, string>(
        'attribution2', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeChromePageHandler_SetBackgroundImage_ParamsMojoType, url_mojom_Url>(
        'attributionUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeChromePageHandler_SetBackgroundImage_ParamsMojoType, url_mojom_Url>(
        'imageUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeChromePageHandler_SetBackgroundImage_ParamsMojoType, url_mojom_Url>(
        'thumbnailUrl', 32,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeChromePageHandler_SetBackgroundImage_ParamsMojoType, string>(
        'collectionId', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface CustomizeChromePageHandler_SetDailyRefreshCollectionId_ParamsMojoType {
  collectionId: string;
}


export type CustomizeChromePageHandler_SetDailyRefreshCollectionId_Params = CustomizeChromePageHandler_SetDailyRefreshCollectionId_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_SetDailyRefreshCollectionId_ParamsMojoType>(
    CustomizeChromePageHandler_SetDailyRefreshCollectionId_ParamsSpec.$,
    'CustomizeChromePageHandler_SetDailyRefreshCollectionId_Params',
    [
      mojo.internal.StructField<CustomizeChromePageHandler_SetDailyRefreshCollectionId_ParamsMojoType, string>(
        'collectionId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePageHandler_OpenChromeWebStore_ParamsMojoType {
}


export type CustomizeChromePageHandler_OpenChromeWebStore_Params = CustomizeChromePageHandler_OpenChromeWebStore_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_OpenChromeWebStore_ParamsMojoType>(
    CustomizeChromePageHandler_OpenChromeWebStore_ParamsSpec.$,
    'CustomizeChromePageHandler_OpenChromeWebStore_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeChromePageHandler_OpenChromeWebStoreHomePage_ParamsMojoType {
}


export type CustomizeChromePageHandler_OpenChromeWebStoreHomePage_Params = CustomizeChromePageHandler_OpenChromeWebStoreHomePage_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_OpenChromeWebStoreHomePage_ParamsMojoType>(
    CustomizeChromePageHandler_OpenChromeWebStoreHomePage_ParamsSpec.$,
    'CustomizeChromePageHandler_OpenChromeWebStoreHomePage_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeChromePageHandler_OpenThirdPartyThemePage_ParamsMojoType {
  themeId: string;
}


export type CustomizeChromePageHandler_OpenThirdPartyThemePage_Params = CustomizeChromePageHandler_OpenThirdPartyThemePage_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_OpenThirdPartyThemePage_ParamsMojoType>(
    CustomizeChromePageHandler_OpenThirdPartyThemePage_ParamsSpec.$,
    'CustomizeChromePageHandler_OpenThirdPartyThemePage_Params',
    [
      mojo.internal.StructField<CustomizeChromePageHandler_OpenThirdPartyThemePage_ParamsMojoType, string>(
        'themeId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_ParamsMojoType {
  category: ChromeWebStoreCategory;
}


export type CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_Params = CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_ParamsMojoType>(
    CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_ParamsSpec.$,
    'CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_Params',
    [
      mojo.internal.StructField<CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_ParamsMojoType, ChromeWebStoreCategory>(
        'category', 0,
        0,
        ChromeWebStoreCategorySpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_ParamsMojoType {
  collection: ChromeWebStoreCollection;
}


export type CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_Params = CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_ParamsMojoType>(
    CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_ParamsSpec.$,
    'CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_Params',
    [
      mojo.internal.StructField<CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_ParamsMojoType, ChromeWebStoreCollection>(
        'collection', 0,
        0,
        ChromeWebStoreCollectionSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePageHandler_OpenNtpManagedByPage_ParamsMojoType {
}


export type CustomizeChromePageHandler_OpenNtpManagedByPage_Params = CustomizeChromePageHandler_OpenNtpManagedByPage_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_OpenNtpManagedByPage_ParamsMojoType>(
    CustomizeChromePageHandler_OpenNtpManagedByPage_ParamsSpec.$,
    'CustomizeChromePageHandler_OpenNtpManagedByPage_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeChromePageHandler_SetModulesVisible_ParamsMojoType {
  visible: boolean;
}


export type CustomizeChromePageHandler_SetModulesVisible_Params = CustomizeChromePageHandler_SetModulesVisible_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_SetModulesVisible_ParamsMojoType>(
    CustomizeChromePageHandler_SetModulesVisible_ParamsSpec.$,
    'CustomizeChromePageHandler_SetModulesVisible_Params',
    [
      mojo.internal.StructField<CustomizeChromePageHandler_SetModulesVisible_ParamsMojoType, boolean>(
        'visible', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePageHandler_SetModuleDisabled_ParamsMojoType {
  moduleId: string;
  disabled: boolean;
}


export type CustomizeChromePageHandler_SetModuleDisabled_Params = CustomizeChromePageHandler_SetModuleDisabled_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_SetModuleDisabled_ParamsMojoType>(
    CustomizeChromePageHandler_SetModuleDisabled_ParamsSpec.$,
    'CustomizeChromePageHandler_SetModuleDisabled_Params',
    [
      mojo.internal.StructField<CustomizeChromePageHandler_SetModuleDisabled_ParamsMojoType, string>(
        'moduleId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeChromePageHandler_SetModuleDisabled_ParamsMojoType, boolean>(
        'disabled', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface CustomizeChromePageHandler_UpdateScrollToSection_ParamsMojoType {
}


export type CustomizeChromePageHandler_UpdateScrollToSection_Params = CustomizeChromePageHandler_UpdateScrollToSection_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_UpdateScrollToSection_ParamsMojoType>(
    CustomizeChromePageHandler_UpdateScrollToSection_ParamsSpec.$,
    'CustomizeChromePageHandler_UpdateScrollToSection_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeChromePageHandler_UpdateAttachedTabState_ParamsMojoType {
}


export type CustomizeChromePageHandler_UpdateAttachedTabState_Params = CustomizeChromePageHandler_UpdateAttachedTabState_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_UpdateAttachedTabState_ParamsMojoType>(
    CustomizeChromePageHandler_UpdateAttachedTabState_ParamsSpec.$,
    'CustomizeChromePageHandler_UpdateAttachedTabState_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeChromePageHandler_UpdateNtpManagedByName_ParamsMojoType {
}


export type CustomizeChromePageHandler_UpdateNtpManagedByName_Params = CustomizeChromePageHandler_UpdateNtpManagedByName_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_UpdateNtpManagedByName_ParamsMojoType>(
    CustomizeChromePageHandler_UpdateNtpManagedByName_ParamsSpec.$,
    'CustomizeChromePageHandler_UpdateNtpManagedByName_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeChromePageHandler_SetFooterVisible_ParamsMojoType {
  visible: boolean;
}


export type CustomizeChromePageHandler_SetFooterVisible_Params = CustomizeChromePageHandler_SetFooterVisible_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_SetFooterVisible_ParamsMojoType>(
    CustomizeChromePageHandler_SetFooterVisible_ParamsSpec.$,
    'CustomizeChromePageHandler_SetFooterVisible_Params',
    [
      mojo.internal.StructField<CustomizeChromePageHandler_SetFooterVisible_ParamsMojoType, boolean>(
        'visible', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePageHandler_UpdateFooterSettings_ParamsMojoType {
}


export type CustomizeChromePageHandler_UpdateFooterSettings_Params = CustomizeChromePageHandler_UpdateFooterSettings_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePageHandler_UpdateFooterSettings_ParamsMojoType>(
    CustomizeChromePageHandler_UpdateFooterSettings_ParamsSpec.$,
    'CustomizeChromePageHandler_UpdateFooterSettings_Params',
    [
    ],
    [[0, 8],]);





export interface CustomizeChromePage_SetModulesSettings_ParamsMojoType {
  modulesSettings: ModuleSettings[];
  managed: boolean;
  visible: boolean;
}


export type CustomizeChromePage_SetModulesSettings_Params = CustomizeChromePage_SetModulesSettings_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePage_SetModulesSettings_ParamsMojoType>(
    CustomizeChromePage_SetModulesSettings_ParamsSpec.$,
    'CustomizeChromePage_SetModulesSettings_Params',
    [
      mojo.internal.StructField<CustomizeChromePage_SetModulesSettings_ParamsMojoType, ModuleSettings[]>(
        'modulesSettings', 0,
        0,
        mojo.internal.Array(ModuleSettingsSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeChromePage_SetModulesSettings_ParamsMojoType, boolean>(
        'managed', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeChromePage_SetModulesSettings_ParamsMojoType, boolean>(
        'visible', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface CustomizeChromePage_SetMostVisitedSettings_ParamsMojoType {
  shortcutsType: ntpTiles_mojom_TileType;
  visible: boolean;
  disabledShortcuts: ntpTiles_mojom_TileType[];
}


export type CustomizeChromePage_SetMostVisitedSettings_Params = CustomizeChromePage_SetMostVisitedSettings_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePage_SetMostVisitedSettings_ParamsMojoType>(
    CustomizeChromePage_SetMostVisitedSettings_ParamsSpec.$,
    'CustomizeChromePage_SetMostVisitedSettings_Params',
    [
      mojo.internal.StructField<CustomizeChromePage_SetMostVisitedSettings_ParamsMojoType, ntpTiles_mojom_TileType>(
        'shortcutsType', 0,
        0,
        ntpTiles_mojom_TileTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeChromePage_SetMostVisitedSettings_ParamsMojoType, boolean>(
        'visible', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeChromePage_SetMostVisitedSettings_ParamsMojoType, ntpTiles_mojom_TileType[]>(
        'disabledShortcuts', 8,
        0,
        mojo.internal.Array(ntpTiles_mojom_TileTypeSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface CustomizeChromePage_SetFooterSettings_ParamsMojoType {
  visible: boolean;
  extensionPolicyEnabled: boolean;
  managementNoticeState: ManagementNoticeState;
}


export type CustomizeChromePage_SetFooterSettings_Params = CustomizeChromePage_SetFooterSettings_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePage_SetFooterSettings_ParamsMojoType>(
    CustomizeChromePage_SetFooterSettings_ParamsSpec.$,
    'CustomizeChromePage_SetFooterSettings_Params',
    [
      mojo.internal.StructField<CustomizeChromePage_SetFooterSettings_ParamsMojoType, boolean>(
        'visible', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeChromePage_SetFooterSettings_ParamsMojoType, boolean>(
        'extensionPolicyEnabled', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeChromePage_SetFooterSettings_ParamsMojoType, ManagementNoticeState>(
        'managementNoticeState', 8,
        0,
        ManagementNoticeStateSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface CustomizeChromePage_SetTheme_ParamsMojoType {
  theme: Theme;
}


export type CustomizeChromePage_SetTheme_Params = CustomizeChromePage_SetTheme_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePage_SetTheme_ParamsMojoType>(
    CustomizeChromePage_SetTheme_ParamsSpec.$,
    'CustomizeChromePage_SetTheme_Params',
    [
      mojo.internal.StructField<CustomizeChromePage_SetTheme_ParamsMojoType, Theme>(
        'theme', 0,
        0,
        ThemeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePage_SetThemeEditable_ParamsMojoType {
  isThemeEditable: boolean;
}


export type CustomizeChromePage_SetThemeEditable_Params = CustomizeChromePage_SetThemeEditable_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePage_SetThemeEditable_ParamsMojoType>(
    CustomizeChromePage_SetThemeEditable_ParamsSpec.$,
    'CustomizeChromePage_SetThemeEditable_Params',
    [
      mojo.internal.StructField<CustomizeChromePage_SetThemeEditable_ParamsMojoType, boolean>(
        'isThemeEditable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePage_ScrollToSection_ParamsMojoType {
  section: CustomizeChromeSection;
}


export type CustomizeChromePage_ScrollToSection_Params = CustomizeChromePage_ScrollToSection_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePage_ScrollToSection_ParamsMojoType>(
    CustomizeChromePage_ScrollToSection_ParamsSpec.$,
    'CustomizeChromePage_ScrollToSection_Params',
    [
      mojo.internal.StructField<CustomizeChromePage_ScrollToSection_ParamsMojoType, CustomizeChromeSection>(
        'section', 0,
        0,
        CustomizeChromeSectionSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePage_AttachedTabStateUpdated_ParamsMojoType {
  ntpType: NewTabPageType;
}


export type CustomizeChromePage_AttachedTabStateUpdated_Params = CustomizeChromePage_AttachedTabStateUpdated_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePage_AttachedTabStateUpdated_ParamsMojoType>(
    CustomizeChromePage_AttachedTabStateUpdated_ParamsSpec.$,
    'CustomizeChromePage_AttachedTabStateUpdated_Params',
    [
      mojo.internal.StructField<CustomizeChromePage_AttachedTabStateUpdated_ParamsMojoType, NewTabPageType>(
        'ntpType', 0,
        0,
        NewTabPageTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface CustomizeChromePage_NtpManagedByNameUpdated_ParamsMojoType {
  name: string;
  description: string;
}


export type CustomizeChromePage_NtpManagedByNameUpdated_Params = CustomizeChromePage_NtpManagedByNameUpdated_ParamsMojoType;
mojo.internal.Struct<CustomizeChromePage_NtpManagedByNameUpdated_ParamsMojoType>(
    CustomizeChromePage_NtpManagedByNameUpdated_ParamsSpec.$,
    'CustomizeChromePage_NtpManagedByNameUpdated_Params',
    [
      mojo.internal.StructField<CustomizeChromePage_NtpManagedByNameUpdated_ParamsMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<CustomizeChromePage_NtpManagedByNameUpdated_ParamsMojoType, string>(
        'description', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);



