// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://customize-chrome-side-panel.top-chrome/shared/sp_heading.js";import"chrome://resources/cr_components/help_bubble/new_badge.js";import"chrome://resources/cr_elements/cr_chip/cr_chip.js";import"chrome://resources/cr_elements/cr_icon/cr_icon.js";import"chrome://resources/cr_elements/cr_page_selector/cr_page_selector.js";import"chrome://resources/cr_elements/icons.html.js";import"./appearance.js";import"./cards.js";import"./categories.js";import"./customize_toolbar/toolbar.js";import"./footer.js";import"./shortcuts.js";import"./themes.js";import"./wallpaper_search/wallpaper_search.js";import{ColorChangeUpdater}from"chrome://resources/cr_components/color_change_listener/colors_css_updater.js";import{HelpBubbleMixinLit}from"chrome://resources/cr_components/help_bubble/help_bubble_mixin_lit.js";import{assert}from"chrome://resources/js/assert.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{getCss}from"./app.css.js";import{getHtml}from"./app.html.js";import{CustomizeChromeImpression,recordCustomizeChromeImpression}from"./common.js";import{ChromeWebStoreCategory,ChromeWebStoreCollection,CustomizeChromeSection,NewTabPageType}from"./customize_chrome.mojom-webui.js";import{CustomizeChromeApiProxy}from"./customize_chrome_api_proxy.js";const SECTION_TO_SELECTOR={[CustomizeChromeSection.kAppearance]:"#appearance",[CustomizeChromeSection.kShortcuts]:"#shortcuts",[CustomizeChromeSection.kModules]:"#modules",[CustomizeChromeSection.kFooter]:"#footer"};const CHANGE_CHROME_THEME_BUTTON_ELEMENT_ID="CustomizeChromeUI::kChangeChromeThemeButtonElementId";export var CustomizeChromePage;(function(CustomizeChromePage){CustomizeChromePage["OVERVIEW"]="overview";CustomizeChromePage["CATEGORIES"]="categories";CustomizeChromePage["THEMES"]="themes";CustomizeChromePage["TOOLBAR"]="toolbar";CustomizeChromePage["WALLPAPER_SEARCH"]="wallpaper-search"})(CustomizeChromePage||(CustomizeChromePage={}));const AppElementBase=HelpBubbleMixinLit(CrLitElement);export class AppElement extends AppElementBase{static get is(){return"customize-chrome-app"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{page_:{type:String},modulesEnabled_:{type:Boolean},selectedCollection_:{type:Object},extensionPolicyEnabled_:{type:Boolean},extensionsCardEnabled_:{type:Boolean},footerEnabled_:{type:Boolean},wallpaperSearchEnabled_:{type:Boolean},newTabPageType_:{type:NewTabPageType},showEditTheme_:{type:Boolean},showFooter_:{type:Boolean},showFooterForManagedBrowser_:{type:Boolean}}}firstUpdated(){ColorChangeUpdater.forDocument().start();this.registerHelpBubble(CHANGE_CHROME_THEME_BUTTON_ELEMENT_ID,["#appearanceElement","#editThemeButton"])}#page__accessor_storage=CustomizeChromePage.OVERVIEW;get page_(){return this.#page__accessor_storage}set page_(value){this.#page__accessor_storage=value}#modulesEnabled__accessor_storage=loadTimeData.getBoolean("modulesEnabled");get modulesEnabled_(){return this.#modulesEnabled__accessor_storage}set modulesEnabled_(value){this.#modulesEnabled__accessor_storage=value}#selectedCollection__accessor_storage=null;get selectedCollection_(){return this.#selectedCollection__accessor_storage}set selectedCollection_(value){this.#selectedCollection__accessor_storage=value}#extensionsCardEnabled__accessor_storage=loadTimeData.getBoolean("extensionsCardEnabled");get extensionsCardEnabled_(){return this.#extensionsCardEnabled__accessor_storage}set extensionsCardEnabled_(value){this.#extensionsCardEnabled__accessor_storage=value}#extensionPolicyEnabled__accessor_storage=false;get extensionPolicyEnabled_(){return this.#extensionPolicyEnabled__accessor_storage}set extensionPolicyEnabled_(value){this.#extensionPolicyEnabled__accessor_storage=value}#footerEnabled__accessor_storage=loadTimeData.getBoolean("footerEnabled");get footerEnabled_(){return this.#footerEnabled__accessor_storage}set footerEnabled_(value){this.#footerEnabled__accessor_storage=value}#wallpaperSearchEnabled__accessor_storage=loadTimeData.getBoolean("wallpaperSearchEnabled");get wallpaperSearchEnabled_(){return this.#wallpaperSearchEnabled__accessor_storage}set wallpaperSearchEnabled_(value){this.#wallpaperSearchEnabled__accessor_storage=value}#newTabPageType__accessor_storage=NewTabPageType.kFirstPartyWebUI;get newTabPageType_(){return this.#newTabPageType__accessor_storage}set newTabPageType_(value){this.#newTabPageType__accessor_storage=value}#showEditTheme__accessor_storage=true;get showEditTheme_(){return this.#showEditTheme__accessor_storage}set showEditTheme_(value){this.#showEditTheme__accessor_storage=value}#showFooter__accessor_storage=false;get showFooter_(){return this.#showFooter__accessor_storage}set showFooter_(value){this.#showFooter__accessor_storage=value}#showFooterForManagedBrowser__accessor_storage=false;get showFooterForManagedBrowser_(){return this.#showFooterForManagedBrowser__accessor_storage}set showFooterForManagedBrowser_(value){this.#showFooterForManagedBrowser__accessor_storage=value}scrollToSectionListenerId_=null;attachedTabStateUpdatedId_=null;setFooterSettingsListenerId_=null;setThemeEditableId_=null;pageHandler_=CustomizeChromeApiProxy.getInstance().handler;connectedCallback(){super.connectedCallback();this.scrollToSectionListenerId_=CustomizeChromeApiProxy.getInstance().callbackRouter.scrollToSection.addListener((section=>{if(section===CustomizeChromeSection.kWallpaperSearch){this.onWallpaperSearchSelect_();return}else if(section===CustomizeChromeSection.kToolbar){this.openToolbarCustomizationPage();chrome.metricsPrivate.recordUserAction("Actions.CustomizeToolbarSidePanel"+".OpenedFromOutsideCustomizeChrome");return}const selector=SECTION_TO_SELECTOR[section];const element=this.shadowRoot.querySelector(selector);if(!element){return}this.page_=CustomizeChromePage.OVERVIEW;element.scrollIntoView({behavior:"auto"})}));this.attachedTabStateUpdatedId_=CustomizeChromeApiProxy.getInstance().callbackRouter.attachedTabStateUpdated.addListener((newTabPageType=>{if(this.newTabPageType_===newTabPageType){return}this.newTabPageType_=newTabPageType;if(!this.isSourceTabFirstPartyNtp_()&&!this.pageSupportedOnNonFirstPartyNtps()){this.page_=CustomizeChromePage.OVERVIEW}}));this.pageHandler_.updateAttachedTabState();this.setThemeEditableId_=CustomizeChromeApiProxy.getInstance().callbackRouter.setThemeEditable.addListener((isThemeEditable=>{this.showEditTheme_=isThemeEditable}));this.setFooterSettingsListenerId_=CustomizeChromeApiProxy.getInstance().callbackRouter.setFooterSettings.addListener(((_,extensionPolicyEnabled,managementNoticeState)=>{this.showFooterForManagedBrowser_=managementNoticeState.canBeShown;this.extensionPolicyEnabled_=extensionPolicyEnabled}));this.pageHandler_.updateFooterSettings();window.addEventListener("load",(()=>{CustomizeChromeApiProxy.getInstance().handler.updateScrollToSection();const extensionsCardSectionObserver=new IntersectionObserver((entries=>{assert(entries.length>=1);if(entries[0].intersectionRatio>=.8){extensionsCardSectionObserver.disconnect();this.dispatchEvent(new Event("detect-extensions-card-section-impression"));recordCustomizeChromeImpression(CustomizeChromeImpression.EXTENSIONS_CARD_SECTION_DISPLAYED)}}),{threshold:1});if(this.shadowRoot&&this.shadowRoot.querySelector("#extensions")){extensionsCardSectionObserver.observe(this.shadowRoot.querySelector("#extensions"))}}),{once:true})}disconnectedCallback(){super.disconnectedCallback();assert(this.scrollToSectionListenerId_);CustomizeChromeApiProxy.getInstance().callbackRouter.removeListener(this.scrollToSectionListenerId_);assert(this.attachedTabStateUpdatedId_);CustomizeChromeApiProxy.getInstance().callbackRouter.removeListener(this.attachedTabStateUpdatedId_);assert(this.setThemeEditableId_);CustomizeChromeApiProxy.getInstance().callbackRouter.removeListener(this.setThemeEditableId_);assert(this.setFooterSettingsListenerId_);CustomizeChromeApiProxy.getInstance().callbackRouter.removeListener(this.setFooterSettingsListenerId_)}willUpdate(changedProperties){super.willUpdate(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("footerEnabled_")||changedPrivateProperties.has("newTabPageType_")||changedPrivateProperties.has("showFooterForManagedBrowser_")||changedPrivateProperties.has("extensionPolicyEnabled_")){this.showFooter_=this.computeShowFooter_()}}computeShowFooter_(){return this.footerEnabled_&&(this.extensionPolicyEnabled_&&this.newTabPageType_===NewTabPageType.kExtension||this.showFooterForManagedBrowser_)}isSourceTabFirstPartyNtp_(){return this.newTabPageType_===NewTabPageType.kFirstPartyWebUI}async onBackClick_(){switch(this.page_){case CustomizeChromePage.CATEGORIES:case CustomizeChromePage.TOOLBAR:this.page_=CustomizeChromePage.OVERVIEW;await this.updateComplete;this.$.appearanceElement.focusOnThemeButton();break;case CustomizeChromePage.THEMES:case CustomizeChromePage.WALLPAPER_SEARCH:this.page_=CustomizeChromePage.CATEGORIES;await this.updateComplete;this.$.categoriesPage.focusOnBackButton();break}}async onEditThemeClick_(){this.page_=CustomizeChromePage.CATEGORIES;await this.updateComplete;this.$.categoriesPage.focusOnBackButton()}async onCollectionSelect_(event){this.selectedCollection_=event.detail;this.page_=CustomizeChromePage.THEMES;await this.updateComplete;this.$.themesPage.focusOnBackButton()}async onLocalImageUpload_(){this.page_=CustomizeChromePage.OVERVIEW;await this.updateComplete;this.$.appearanceElement.focusOnThemeButton()}onWallpaperSearchSelect_(){this.page_=CustomizeChromePage.WALLPAPER_SEARCH;const page=this.shadowRoot.querySelector("customize-chrome-wallpaper-search");assert(page);page.focusOnBackButton()}onCouponsButtonClick_(){this.pageHandler_.openChromeWebStoreCategoryPage(ChromeWebStoreCategory.kShopping)}onWritingButtonClick_(){this.pageHandler_.openChromeWebStoreCollectionPage(ChromeWebStoreCollection.kWritingEssentials)}onProductivityButtonClick_(){this.pageHandler_.openChromeWebStoreCategoryPage(ChromeWebStoreCategory.kWorkflowPlanning)}onChromeWebStoreLinkClick_(e){if(e.target.id!=="chromeWebstoreLink"){return}this.pageHandler_.openChromeWebStoreHomePage()}onToolbarCustomizationButtonClick_(){this.openToolbarCustomizationPage();chrome.metricsPrivate.recordUserAction("Actions.CustomizeToolbarSidePanel.OpenedFromCustomizeChrome")}async openToolbarCustomizationPage(){this.page_=CustomizeChromePage.TOOLBAR;const page=this.shadowRoot.querySelector("customize-chrome-toolbar");assert(page);await this.updateComplete;page.focusOnBackButton()}pageSupportedOnNonFirstPartyNtps(){return this.page_===CustomizeChromePage.TOOLBAR}}customElements.define(AppElement.is,AppElement);