import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style include="cr-hidden-style cr-icons sp-shared-style">.section{flex-direction:column;display:flex;padding:16px}.sp-card{padding:16px}.panel-title{color:var(--cr-primary-text-color);font-size:16px;font-weight:500;line-height:24px;max-width:100%;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;margin:0;padding:0}.panel-subtitle{color:var(--cr-primary-text-color);margin-top:4px;font-size:12px;font-weight:400;line-height:16px}.section-title{color:var(--cr-primary-text-color);font-size:14px;font-weight:500;line-height:20px}.history-subtitle{color:var(--cr-secondary-text-color);font-size:12px;line-height:16px;margin-top:8px}#titleSection>.section-details{margin-top:8px}#historySection>.section-details{margin-top:0px}.panel-subtitle,.section-title,.history-subtitle{max-width:100%}#priceRange{overflow:hidden}</style>

<div id="insightsContainer">
  <div class="sp-cards-separator"></div>
  <div class="section sp-card" id="titleSection">
    <h1 class="panel-title">[[productInfo.clusterTitle]]</h1>
    <div id="priceRange" class="panel-subtitle"
        hidden="[[!priceInsightsInfo.typicalLowPrice.length]]">
      [[getRangeDescription_(priceInsightsInfo)]]
    </div>
    <catalog-attributes-row class="panel-subtitle"
        price-insights-info="[[priceInsightsInfo]]"
        hidden="[[priceInsightsInfo.typicalLowPrice.length]]">
    </catalog-attributes-row>
    <insights-comment-row class="section-details"
        hidden="[[priceInsightsInfo.history.length]]">
    </insights-comment-row>
  </div>
  <template is="dom-if" if="[[priceInsightsInfo.history.length]]" restamp>
    <div class="sp-cards-separator"></div>
    <div class="section sp-card" id="historySection">
      <div class="section-title" id="historyTitle">
        [[getHistoryTitle_(priceInsightsInfo)]]
      </div>
      <catalog-attributes-row class="history-subtitle"
          price-insights-info="[[priceInsightsInfo]]"
          hidden="[[!priceInsightsInfo.typicalLowPrice.length]]">
      </catalog-attributes-row>
      <shopping-insights-history-graph data="[[priceInsightsInfo.history]]"
          locale="[[priceInsightsInfo.locale]]"
          currency="[[priceInsightsInfo.currencyCode]]">
      </shopping-insights-history-graph>
      <insights-comment-row class="section-details">
      </insights-comment-row>
    </div>
  </template>
  <template is="dom-if" if="[[isProductTrackable_]]" restamp>
    <div class="sp-cards-separator"></div>
    <price-tracking-section class="section sp-card"
        id="priceTrackingSection"
        product-info="[[productInfo]]"
        price-insights-info="[[priceInsightsInfo]]"
        is-product-tracked="[[isProductTracked_]]">
    </price-tracking-section>
  </template>
</div><!--_html_template_end_-->`}