import '//resources/cr_elements/cr_icon/cr_iconset.js';
import {getTrustedHTML} from '//resources/js/static_types.js';

const div = document.createElement('div');
div.innerHTML = getTrustedHTML`<cr-iconset name="bookmarks" size="24">
  <svg>
    <defs>
      <g id="add-tab" viewBox="0 0 16 16">
        <path fill-rule="evenodd" d="M8 1.333A6.67 6.67 0 0 0 1.333 8 6.67 6.67 0 0 0 8 14.667 6.67 6.67 0 0 0 14.666 8 6.67 6.67 0 0 0 8 1.333Zm-.667 3.334v2.666H4.666v1.334h2.667v2.666h1.333V8.667h2.667V7.333H8.666V4.667H7.333ZM2.666 8A5.34 5.34 0 0 0 8 13.333 5.34 5.34 0 0 0 13.333 8 5.34 5.34 0 0 0 8 2.667 5.34 5.34 0 0 0 2.666 8Z"></path>
      </g>
      <g id="bookmarks-bar" viewBox="0 0 20 20">
        <path d="M4.457 17.168c-.469 0-.86-.152-1.164-.461-.309-.305-.461-.695-.461-1.164V4.457c0-.484.152-.875.461-1.176.305-.3.695-.449 1.164-.449h11.086c.484 0 .875.148 1.176.45.3.3.449.69.449 1.175v11.086c0 .469-.148.86-.45 1.164-.3.309-.69.461-1.175.461Zm.102-10.7H15.44v-1.91H4.56ZM15.44 8.2H4.56v7.242H15.44ZM4.56 6.47v1.73Zm0 0v-1.91Zm0 1.73v7.242Zm0 0"></path>
      </g>
      <g id="check">
        <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"></path>
      </g>
      <g id="create-new-folder">
        <path fill-rule="evenodd" d="M22 8v10c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2l.01-12c0-1.1.89-2 1.99-2h6l2 2h8c1.1 0 2 .9 2 2Zm-10 4h2v-2h2v2h2v2h-2v2h-2v-2h-2v-2ZM4 8h16v10H4V8Z"></path>
      </g>
      <g id="delete">
        <path d="M15 3v1h5v2h-1v13c0 1.1-.9 2-2 2H7c-1.1 0-2-.9-2-2V6H4V4h5V3h6ZM7 19h10V6H7v13ZM9 8h2v9H9V8Zm6 0h-2v9h2V8Z"></path>
      </g>
      <g id="edit">
        <path d="m20.41 4.94-1.35-1.35c-.78-.78-2.05-.78-2.83 0L13.4 6.41 3 16.82V21h4.18l10.46-10.46 2.77-2.77c.79-.78.79-2.05 0-2.83zm-14 14.12L5 19v-1.36l9.82-9.82 1.41 1.41-9.82 9.83z"></path>
      </g>
      <g id="format-list">
        <path d="M3 6c0-.83.67-1.5 1.5-1.5S6 5.17 6 6s-.67 1.5-1.5 1.5S3 6.83 3 6Zm0 6c0-.83.67-1.5 1.5-1.5S6 11.17 6 12s-.67 1.5-1.5 1.5S3 12.83 3 12Zm1.5 4.5c-.83 0-1.5.68-1.5 1.5s.68 1.5 1.5 1.5S6 18.82 6 18s-.67-1.5-1.5-1.5ZM21 19H8v-2h13v2ZM8 13h13v-2H8v2Zm0-6V5h13v2H8Z"></path>
      </g>
      <g id="move">
        <path d="M20 6h-8l-2-2H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2Zm0 12H4V8h16v10Zm-8.01-9-1.41 1.41L12.16 12H8v2h4.16l-1.59 1.59L11.99 17 16 13.01 11.99 9Z"></path>
      </g>
      <g id="price-tracking" viewBox="0 0 16 16">
        <path d="M12 11.333v-4c0-2.046-1.087-3.76-3-4.213v-.453c0-.554-.447-1-1-1-.554 0-1 .446-1 1v.453c-1.907.453-3 2.16-3 4.213v4H2.666v1.334h10.667v-1.334H12Zm-1.334 0H5.333v-4c0-1.653 1.007-3 2.667-3s2.666 1.347 2.666 3v4ZM8 14.667c.733 0 1.333-.6 1.333-1.334H6.666c0 .734.6 1.334 1.334 1.334Zm6.666-7.334h-1.333c0-1.826-.82-3.46-2.107-4.56l.94-.94c1.527 1.347 2.5 3.307 2.5 5.5Zm-9.893-4.56-.94-.94c-1.527 1.347-2.5 3.307-2.5 5.5h1.333c0-1.826.82-3.46 2.107-4.56Z"></path>
      </g>
      <g id="compact-view">
        <path d="M9 18h11v-2.675H9V18ZM4 8.675h3V6H4v2.675Zm0 4.675h3v-2.675H4v2.675ZM4 18h3v-2.675H4V18Zm5-4.65h11v-2.675H9v2.675Zm0-4.675h11V6H9v2.675ZM4 20a1.99 1.99 0 0 1-1.425-.575A1.99 1.99 0 0 1 2 18V6c0-.55.192-1.017.575-1.4.4-.4.875-.6 1.425-.6h16c.55 0 1.017.2 1.4.6.4.383.6.85.6 1.4v12c0 .55-.2 1.025-.6 1.425-.383.383-.85.575-1.4.575H4Z"></path>
      </g>
      <g id="visual-view">
        <path d="M4 17c-.283 0-.525-.092-.725-.275A1.035 1.035 0 0 1 3 16c0-.283.092-.517.275-.7.2-.2.442-.3.725-.3s.517.1.7.3c.2.183.3.417.3.7s-.1.525-.3.725A.948.948 0 0 1 4 17Zm0-4c-.283 0-.525-.092-.725-.275A1.035 1.035 0 0 1 3 12c0-.283.092-.517.275-.7.2-.2.442-.3.725-.3s.517.1.7.3c.2.183.3.417.3.7s-.1.525-.3.725A.948.948 0 0 1 4 13Zm0-4c-.283 0-.525-.092-.725-.275A1.035 1.035 0 0 1 3 8c0-.283.092-.517.275-.7.2-.2.442-.3.725-.3s.517.1.7.3c.2.183.3.417.3.7s-.1.525-.3.725A.948.948 0 0 1 4 9Zm3 8v-2h14v2H7Zm0-4v-2h14v2H7Zm0-4V7h14v2H7Z"></path>
      </g>
      <g id="shopping-collection" viewBox="0 0 16 20">
        <path d="M2 20a1.99 1.99 0 0 1-1.425-.575A1.99 1.99 0 0 1 0 18V6c0-.55.192-1.017.575-1.4C.975 4.2 1.45 4 2 4h2c0-1.1.392-2.042 1.175-2.825C5.958.392 6.9 0 8 0s2.042.392 2.825 1.175C11.608 1.958 12 2.9 12 4h2c.55 0 1.017.2 1.4.6.4.383.6.85.6 1.4v12c0 .55-.2 1.025-.6 1.425-.383.383-.85.575-1.4.575H2Zm0-2h12V6h-2v2c0 .283-.1.525-.3.725A.948.948 0 0 1 11 9c-.283 0-.525-.092-.725-.275A1.035 1.035 0 0 1 10 8V6H6v2c0 .283-.1.525-.3.725A.948.948 0 0 1 5 9c-.283 0-.525-.092-.725-.275A1.035 1.035 0 0 1 4 8V6H2v12ZM6 4h4c0-.55-.2-1.017-.6-1.4C9.017 2.2 8.55 2 8 2c-.55 0-1.025.2-1.425.6C6.192 2.983 6 3.45 6 4ZM2 18V6v12Z"></path>
      </g>
    </defs>
  </svg>
</cr-iconset>
`;
const iconsets = div.querySelectorAll('cr-iconset');
for (const iconset of iconsets) {
  document.head.appendChild(iconset);
}
