import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="mwb-element-shared-style cr-hidden-style cr-icons">:host{display:block;user-select:none;white-space:nowrap;--icon-color:var(--google-grey-700);--price-chip-background:var(--google-green-50);--price-chip-text-color:var(--google-green-700);--product-image-background:none}@media (prefers-color-scheme:dark){:host{--icon-color:var(--google-grey-100);--price-chip-background:linear-gradient(0deg,rgba(var(--google-green-300-rgb),0.12),rgba(var(--google-green-300-rgb),0.12)),var(--google-grey-900);--price-chip-text-color:var(--google-green-300);--product-image-background:var(--google-grey-100)}}.row{align-items:center;appearance:none;background:transparent;border:none;box-sizing:border-box;color:currentColor;display:grid;grid-template-areas:'arrow icon title';grid-template-columns:20px 20px auto;height:40px;line-height:40px;padding-block-end:0;padding-block-start:0;padding-inline-start:0;text-align:start;width:100%}.row:hover{background-color:var(--mwb-list-item-hover-background-color)}.product-item:hover{background-color:var(--mwb-list-item-hover-background-color)}:host-context(.focus-outline-visible) .row:focus,:host-context(.focus-outline-visible) .row:focus:hover,:host-context(.focus-outline-visible) .product-item:focus,:host-context(.focus-outline-visible) .product-item:focus:hover{background-color:var(--mwb-list-item-selected-background-color);outline:none}.row:focus-visible:focus{outline:none}:host-context(.focus-outline-visible) .row:active,:host-context(.focus-outline-visible) .product-item:active{background-color:var(--cr-active-background-color)}#arrow{grid-area:arrow;justify-self:center}#arrowIcon{--cr-icon-button-hover-background-color:transparent;--cr-icon-button-active-background-color:transparent;margin:0;transform:rotate(-90deg);transition:transform 100ms cubic-bezier(0.4,0,0.2,1)}#arrowIcon[open]{transform:rotate(0)}#arrowIcon:focus,#arrowIcon:hover{background:none;box-shadow:none}:host-context([dir='rtl']) #arrowIcon:not([open]){transform:rotate(90deg)}.icon{background-position:left center;background-repeat:no-repeat;grid-area:icon;height:16px;justify-self:center;width:16px;--iron-icon-fill-color:var(---icon-color)}.title{grid-area:title;overflow:hidden;padding:0 10px;text-overflow:ellipsis}.product-item{align-items:center;appearance:none;background:transparent;border:none;display:flex;height:76px;justify-content:center;padding:10px 0;width:100%}.item-image{border-radius:4px;display:flex;height:100%;margin-inline-start:16px;min-width:56px;width:56px}.product-image{background:var(--product-image-background);border-radius:4px;height:100%;margin:auto;object-fit:contain;width:100%}.favicon-image{background:var(--google-grey-100);background-position:center center;background-repeat:no-repeat}.product-image-container{position:relative}.product-image-container::before{background:rgba(0,0,0,0.03);content:'';height:100%;left:0;position:absolute;top:0;width:100%;z-index:1}.product-info{align-items:flex-start;display:flex;flex-direction:column;gap:2px;height:56px;margin:0 12px;overflow:hidden}.product-title{color:var(--cr-primary-text-color);line-height:20px;max-width:100%;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.product-domain,.price{color:var(--cr-secondary-text-color);font-size:13px;font-weight:400;line-height:20px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.price-container{background:var(--price-chip-background);border-radius:16px;display:inline-block;width:fit-content}.new-price{color:var(--price-chip-text-color);font-weight:500;margin-inline-start:7px}.old-price{margin-inline-end:7px;margin-inline-start:4px;text-decoration:line-through}.action-button{background:transparent;margin-inline-end:16px;margin-inline-start:auto;--cr-icon-button-fill-color:var(--icon-color)}.action-button:focus-visible{background-color:var(--mwb-list-item-selected-background-color);box-shadow:none}.action-button:focus{box-shadow:none}cr-toast{justify-content:space-between;margin:8px}</style>

<div id="container" role="treeitem" aria-expanded="[[open_]]">
  <button class="row" title="$i18n{shoppingListFolderTitle}"
      draggable="false" on-click="onFolderClick_">
    <div id="arrow">
      <cr-icon-button
          id="arrowIcon" iron-icon="cr:arrow-drop-down"
          open$="[[open_]]" tabindex="-1">
      </cr-icon-button>
    </div>
    <cr-icon class="icon" icon="shopping-list:shopping-list-icon"></cr-icon>
    <div class="title">$i18n{shoppingListFolderTitle}</div>
  </button>
  <template is="dom-if" if="[[open_]]" restamp>
    <template is="dom-repeat" items="[[productInfos]]">
      <button class="product-item" role="treeitem"
          aria-labelledby$="productInfo-[[index]]"
          on-click="onProductClick_"
          on-auxclick="onProductAuxClick_"
          on-contextmenu="onProductContextMenu_">
        <template is="dom-if" if="[[item.info.imageUrl.url.length]]" restamp>
          <div class="product-image-container item-image">
              <img class="product-image" is="cr-auto-img"
                  auto-src="[[item.info.imageUrl.url]]"
                  on-load="onImageLoadSuccess_"
                  on-error="onImageLoadError_"></img>
          </div>
        </template>
        <template is="dom-if" if="[[!item.info.imageUrl.url.length]]" restamp>
          <div class="favicon-image item-image"
              style="background-image:
                  [[getFaviconUrl_(item.info.productUrl.url)]]">
          </div>
        </template>
        <div class="product-info" id="productInfo-[[index]]">
          <span class="product-title">[[item.info.title]]</span>
          <span class="product-domain">[[item.info.domain]]</span>
          <template is="dom-if" if="[[!item.info.previousPrice]]" restamp>
            <span class="price">[[item.info.currentPrice]]</span>
          </template>
          <template is="dom-if" if="[[item.info.previousPrice]]" restamp>
            <div class="price-container">
              <span class="price new-price">[[item.info.currentPrice]]</span>
              <span class="price old-price">[[item.info.previousPrice]]</span>
            </div>
          </template>
        </div>
        <cr-icon-button class="action-button" on-click="onActionButtonClick_"
            iron-icon="[[getIconForItem_(item, untrackedItems_.*)]]"
            title="[[getButtonDescriptionForItem_(item, untrackedItems_.*)]]">
        </cr-icon-button>
      </button>
    </template>
  </template>
  <cr-toast id="errorToast" duration="5000">
    <div>$i18n{shoppingListErrorMessage}</div>
    <cr-button on-click="onErrorRetryClicked_">
      $i18n{shoppingListErrorButton}
    </cr-button>
  </cr-toast>
</div>
<!--_html_template_end_-->`;
}