/**
 * @fileoverview
 * 'privacy-guide-history-sync-fragment' is the fragment in a privacy guide
 * card that contains the history sync setting and its description.
 */
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import '/shared/settings/prefs/prefs.js';
import './privacy_guide_fragment_shared.css.js';
import './privacy_guide_fragment_shared.css.js';
import '../../controls/settings_toggle_button.js';
import '../../icons.html.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsToggleButtonElement } from '../../controls/settings_toggle_button.js';
import type { Route } from '../../router.js';
export interface PrivacyGuideHistorySyncFragmentElement {
    $: {
        historyToggle: SettingsToggleButtonElement;
    };
}
declare const PrivacyGuideHistorySyncFragmentElementBase: typeof PolymerElement & (new (...args: any[]) => import("../../base_mixin.js").BaseMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../../router.js").RouteObserverMixinInterface);
export declare class PrivacyGuideHistorySyncFragmentElement extends PrivacyGuideHistorySyncFragmentElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /** Virtual pref to drive the settings-toggle from syncPrefs. */
        historySyncVirtualPref_: {
            type: ObjectConstructor;
            notify: boolean;
            value(): {
                type: chrome.settingsPrivate.PrefType;
                value: boolean;
            };
        };
    };
    private syncBrowserProxy_;
    private syncPrefs_;
    private syncAllCache_;
    private historySyncVirtualPref_;
    private metricsBrowserProxy_;
    private startStateHistorySyncOn_;
    private firstSyncPrefUpdate_;
    ready(): void;
    focus(): void;
    private onViewEnterStart_;
    private onViewExitFinish_;
    currentRouteChanged(newRoute: Route): void;
    private onSyncPrefsChange_;
    private onToggleClick_;
    /**
     * If sync all was on when the user reached the history sync card, then
     * disabling and re-enabling history sync while on the card should also
     * re-enable sync all in case all other sync datatypes are also still on.
     */
    private shouldSyncAllBeOn_;
}
declare global {
    interface HTMLElementTagNameMap {
        'privacy-guide-history-sync-fragment': PrivacyGuideHistorySyncFragmentElement;
    }
}
export {};
