/**
 * @fileoverview
 * 'privacy-guide-cookies-fragment' is the fragment in a privacy
 * guide card that contains the cookie settings and their descriptions.
 */
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import '/shared/settings/prefs/prefs.js';
import './privacy_guide_fragment_shared.css.js';
import '../../controls/settings_radio_group.js';
import '../../icons.html.js';
import '../../privacy_page/collapse_radio_button.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { CookieControlsMode } from '../../site_settings/constants.js';
import { ThirdPartyCookieBlockingSetting } from '../../site_settings/site_settings_prefs_browser_proxy.js';
declare const PrivacyGuideCookiesFragmentBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface);
export declare class PrivacyGuideCookiesFragmentElement extends PrivacyGuideCookiesFragmentBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /** Cookie control modes for use in bindings. */
        cookieControlsModeEnum_: {
            type: ObjectConstructor;
            value: typeof CookieControlsMode;
        };
        thirdPartyCookieBlockingSettingEnum_: {
            type: ObjectConstructor;
            value: typeof ThirdPartyCookieBlockingSetting;
        };
    };
    private metricsBrowserProxy_;
    private startStateBlock3PIncognito_;
    ready(): void;
    focus(): void;
    private onViewEnterStart_;
    private onViewExitFinish_;
    private onCookies3pIncognitoClick_;
    private onCookies3pClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'privacy-guide-cookies-fragment': PrivacyGuideCookiesFragmentElement;
    }
}
export {};
