import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import '../controls/settings_toggle_button.js';
import '../icons.html.js';
import '../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsToggleButtonElement } from '../controls/settings_toggle_button.js';
export interface SettingsDoNotTrackToggleElement {
    $: {
        toggle: SettingsToggleButtonElement;
    };
}
export declare class SettingsDoNotTrackToggleElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * Preferences state.
         */
        prefs: {
            type: ObjectConstructor;
            notify: boolean;
        };
        showDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    prefs: {
        enable_do_not_track: chrome.settingsPrivate.PrefObject;
    };
    private showDialog_;
    private onDomChange_;
    /**
     * Handles the change event for the do-not-track toggle. Shows a
     * confirmation dialog when enabling the setting.
     */
    private onToggleChange_;
    private closeDialog_;
    private onDialogClosed_;
    /**
     * Handles the shared proxy confirmation dialog 'Confirm' button.
     */
    private onDialogConfirm_;
    /**
     * Handles the shared proxy confirmation dialog 'Cancel' button or a cancel
     * event.
     */
    private onDialogCancel_;
    private get toggle_();
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-do-not-track-toggle': SettingsDoNotTrackToggleElement;
    }
}
