import '../controls/settings_radio_group.js';
import '../controls/settings_toggle_button.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '/shared/settings/prefs/prefs.js';
import 'chrome://resources/cr_elements/cr_collapse/cr_collapse.js';
import '../privacy_page/collapse_radio_button.js';
import '../settings_columned_section.css.js';
import '../settings_page/settings_section.js';
import '../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsRadioGroupElement } from '../controls/settings_radio_group.js';
import type { SettingsToggleButtonElement } from '../controls/settings_toggle_button.js';
import type { SettingsCollapseRadioButtonElement } from '../privacy_page/collapse_radio_button.js';
import { NetworkPredictionOptions } from './constants.js';
export interface SpeedPageElement {
    $: {
        preloadingToggle: SettingsToggleButtonElement;
        preloadingExtended: SettingsCollapseRadioButtonElement;
        preloadingRadioGroup: SettingsRadioGroupElement;
        preloadingStandard: SettingsCollapseRadioButtonElement;
    };
}
declare const SpeedPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface);
export declare class SpeedPageElement extends SpeedPageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /** Valid network prediction options state. */
        networkPredictionOptionsEnum_: {
            type: ObjectConstructor;
            value: typeof NetworkPredictionOptions;
        };
        numericUncheckedValues_: {
            type: ArrayConstructor;
            value: () => NetworkPredictionOptions[];
        };
    };
    private numericUncheckedValues_;
    ready(): void;
    private isPreloadingEnabled_;
    private onPreloadingStateChange_;
    private onPreloadingLearnMoreLinkClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-speed-page': SpeedPageElement;
    }
}
export {};
