import '../controls/controlled_radio_button.js';
import '../controls/settings_radio_group.js';
import '../controls/settings_toggle_button.js';
import 'chrome://resources/cr_elements/cr_collapse/cr_collapse.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '../settings_page/settings_section.js';
import '../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsToggleButtonElement } from '../controls/settings_toggle_button.js';
import { MemorySaverModeAggressiveness, MemorySaverModeState } from './performance_metrics_proxy.js';
export declare const MEMORY_SAVER_MODE_PREF = "performance_tuning.high_efficiency_mode.state";
export declare const MEMORY_SAVER_MODE_AGGRESSIVENESS_PREF = "performance_tuning.high_efficiency_mode.aggressiveness";
declare const SettingsMemoryPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface);
export interface SettingsMemoryPageElement {
    $: {
        toggleButton: SettingsToggleButtonElement;
    };
}
export declare class SettingsMemoryPageElement extends SettingsMemoryPageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        memorySaverModeAggressivenessEnum_: {
            readOnly: boolean;
            type: ObjectConstructor;
            value: typeof MemorySaverModeAggressiveness;
        };
        numericUncheckedValues_: {
            type: ArrayConstructor;
            value: () => MemorySaverModeState[];
        };
        numericCheckedValue_: {
            type: NumberConstructor;
            value: () => MemorySaverModeState;
        };
    };
    private numericUncheckedValues_;
    private numericCheckedValue_;
    private metricsProxy_;
    private onMemorySaverModeChange_;
    private onMemorySaverModeAggressivenessChange_;
    private isMemorySaverModeEnabled_;
    private onMemorySaverLearnMoreLinkClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-memory-page': SettingsMemoryPageElement;
    }
}
export {};
