import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_collapse/cr_collapse.js';
import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import '../controls/controlled_radio_button.js';
import '../controls/settings_radio_group.js';
import '../controls/settings_toggle_button.js';
import '../settings_page/settings_section.js';
import '../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { ControlledRadioButtonElement } from '../controls/controlled_radio_button.js';
import type { SettingsRadioGroupElement } from '../controls/settings_radio_group.js';
import type { SettingsToggleButtonElement } from '../controls/settings_toggle_button.js';
import { BatterySaverModeState } from './performance_metrics_proxy.js';
export declare const BATTERY_SAVER_MODE_PREF = "performance_tuning.battery_saver_mode.state";
export interface SettingsBatteryPageElement {
    $: {
        enabledOnBatteryButton: ControlledRadioButtonElement;
        radioGroup: SettingsRadioGroupElement;
        toggleButton: SettingsToggleButtonElement;
    };
}
declare const SettingsBatteryPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface);
export declare class SettingsBatteryPageElement extends SettingsBatteryPageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        batterySaverModeStateEnum_: {
            readOnly: boolean;
            type: ObjectConstructor;
            value: typeof BatterySaverModeState;
        };
        isBatterySaverModeManagedByOs_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        numericUncheckedValues_: {
            type: ArrayConstructor;
            value: () => BatterySaverModeState[];
        };
    };
    private isBatterySaverModeManagedByOs_;
    private numericUncheckedValues_;
    private metricsProxy_;
    private isBatterySaverModeEnabled_;
    private onChange_;
    private onBatterySaverLearnMoreLinkClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-battery-page': SettingsBatteryPageElement;
    }
}
export {};
