import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">:host{--shown-avatar-size:40px;--sync-icon-border-size:2px;--sync-icon-size:16px}:host([promo-type_="sync"]){h3{font-size:inherit;margin:0;font-weight:normal}#banner{background:url(chrome://settings/images/sync_banner.svg) no-repeat;background-size:100% auto;display:none;padding-top:calc(120 / 680 * 100%);display:block}@media (prefers-color-scheme:dark){#banner{background-image:url(chrome://settings/images/sync_banner_dark.svg)}}}:host([promo-type_="signin"]){h3{margin-top:4px;margin-bottom:4px;font-size:1rem;font-weight:500;letter-spacing:.25px}#banner{background:url(chrome://settings/images/signin_banner.svg) no-repeat;background-size:100% auto;display:none;padding-top:calc(120 / 680 * 100%);display:block}@media (prefers-color-scheme:dark){#banner{background-image:url(chrome://settings/images/signin_banner_dark.svg)}}}.account-icon{border-radius:50%;flex-shrink:0;height:var(--shown-avatar-size);width:var(--shown-avatar-size)}.account-icon.small{height:20px;width:20px}#menu .dropdown-item{padding:12px}#menu .dropdown-item span{margin-inline-start:8px}.flex{display:flex;flex:1;flex-direction:column}#avatar-container{height:var(--shown-avatar-size);position:relative}#sync-icon-container{align-items:center;background:var(--google-green-700);border:var(--sync-icon-border-size) solid white;border-radius:50%;display:flex;height:var(--sync-icon-size);position:absolute;right:-6px;top:calc(var(--shown-avatar-size) - var(--sync-icon-size) - var(--sync-icon-border-size));width:var(--sync-icon-size)}:host-context([dir='rtl']) #sync-icon-container{left:-6px;right:initial}@media (prefers-color-scheme:dark){#sync-icon-container{background:var(--google-green-300);border-color:var(--google-grey-900)}}#sync-icon-container.sync-problem{background:var(--settings-error-color)}#sync-icon-container.sync-paused{background:var(--google-blue-500)}@media (prefers-color-scheme:dark){#sync-icon-container.sync-paused{background:var(--google-blue-300)}}#sync-icon-container.sync-disabled{background:var(--google-grey-400)}@media (prefers-color-scheme:dark){#sync-icon-container.sync-disabled{background:var(--google-grey-500)}}#sync-icon-container cr-icon{fill:white;height:12px;margin:auto;width:12px}#signIn{min-width:100px}

    </style>
    <div id="banner" hidden="[[shouldHideBanner_(syncStatus.signedInState)]]"
        part="banner"></div>
    <div class="cr-row first"
        id="promo-header" hidden="[[shouldHideBanner_(
              syncStatus.signedInState)]]">
      <div class="flex cr-padded-text">
        <h3 id="promo-title" part="title">
          [[getLabel_(promoLabelWithAccount,
              promoLabelWithNoAccount, shownAccount_)]]
        </h3>
        <div class="secondary">[[subLabel_]]</div>
      </div>
      <cr-button class="action-button cr-button-gap" on-click="onSigninClick_"
          id="signIn"
          disabled="[[shouldDisableSyncButton_(showSetupButtons_,
                  syncStatus.firstSetupInProgress,
                  prefs.signin.allowed_on_next_startup.value)]]"
          hidden="[[shouldShowAvatarRow_]]">
        $i18n{peopleSignInNoAccountAwareness}
      </cr-button>
    </div>
    <template is="dom-if" if="[[shouldShowAvatarRow_]]">
      <div class="cr-row first two-line" id="avatar-row">
        <div id="avatar-container">
          <img class="account-icon" alt=""
              src="[[getProfileImageSrc_(
                shownAccount_.avatarImage,
                profileAvatarURL_)]]">
          <div id="sync-icon-container"
              hidden="[[!isSyncing_(syncStatus.signedInState)]]"
              class$="[[getSyncIconStyle_(
                  syncStatus.hasError, syncStatus.statusAction,
                  syncStatus.disabled)]]">
            <cr-icon icon$="[[getSyncIcon_(
                syncStatus.hasError, syncStatus.statusAction,
                syncStatus.disabled)]]"></cr-icon>
          </div>
        </div>
        <div class="cr-row-gap cr-padded-text flex no-min-width" id="user-info">
          <div class="text-elide">
            [[getAvatarRowTitle_(shownAccount_.fullName,
                '$i18nPolymer{syncNotWorking}',
                '$i18nPolymer{syncPasswordsNotWorking}',
                '$i18nPolymer{syncPaused}',
                '$i18nPolymer{syncDisabled}',
                '$i18nPolymer{accountAwareRowTitle}',
                syncStatus.hasError,
                syncStatus.statusAction, syncStatus.disabled)]]
          </div>
          <div class="secondary text-elide"
              hidden="[[shouldHideSubtitleWithAccountInfoText_(syncStatus)]]">
            [[getAccountLabel_(
                '$i18nPolymer{signedInTo}',
                '$i18nPolymer{syncingTo}',
                shownAccount_.email, syncStatus.hasError,
                syncStatus.signedInState, syncStatus.disabled,
                syncStatus.firstSetupInProgress,
                shownAccount_.isPrimaryAccount)]]
          </div>
          <div class="secondary"
              hidden="[[!shouldHideSubtitleWithAccountInfoText_(syncStatus)]]">
            [[getAvatarSubtitleLabel_(
              '$i18nPolymer{accountAwareRowSubtitle}',
              '$i18nPolymer{pendingStateAvatarRowSubtitle}',
              shownAccount_.email,
              this.syncStatus.signedInState)]]
          </div>
        </div>
        <cr-icon-button class="icon-arrow-dropdown cr-button-gap"
            hidden="[[!shouldAllowAccountSwitch_(syncStatus.signedInState,
                syncStatus.domain, syncStatus.signinPaused)]]"
            on-click="onMenuButtonClick_" id="dropdown-arrow"
            aria-label="$i18n{changeAccount}"
            aria-expanded="false">
        </cr-icon-button>
        <div class="separator"
            hidden="[[!shouldAllowAccountSwitch_(syncStatus.signedInState,
                syncStatus.domain, syncStatus.signinPaused)]]">
        </div>
        <cr-button id="signout-button" class="cr-button-gap"
            hidden="[[shouldHideSignoutButton_(syncStatus.signedInState)]]"
            on-click="onSignoutClick_">
          $i18n{signOutOfChrome}
        </cr-button>
        <cr-button id="sync-button" class="action-button cr-button-gap"
            hidden="[[shouldHideSyncButton_(syncStatus.signedInState,
                syncStatus.signinPaused)]]"
            on-click="onSyncButtonClick_"
            disabled="[[shouldDisableSyncButton_(showSetupButtons_,
                syncStatus.firstSetupInProgress,
                prefs.signin.allowed_on_next_startup.value)]]">
          $i18nPolymer{turnOnSync}
        </cr-button>
        <cr-button id="turn-off"
            class="cr-button-gap"
            hidden="[[!shouldShowTurnOffButton_(syncStatus.signedInState,
                syncStatus.domain, showSetupButtons_)]]"
            on-click="onTurnOffButtonClick_"
            disabled="[[syncStatus.firstSetupInProgress]]">
          [[getTurnOffSyncLabel_(
            '$i18nPolymer{turnOffSync}',
            syncStatus.secondaryButtonActionText)]]
        </cr-button>
        <cr-button id="sync-error-button" class="action-button cr-button-gap"
            hidden="[[!shouldShowErrorActionButton_(syncStatus,
            showSetupButtons_, syncStatus.statusAction)]]"
            on-click="onErrorButtonClick_"
            disabled="[[syncStatus.firstSetupInProgress]]">
          [[syncStatus.statusActionText]]
        </cr-button>
        <cr-button class="action-button cr-button-gap"
            on-click="onSyncButtonClick_" id="account-aware"
            hidden="[[!shouldShowAccountAwareSigninButton_(
                syncStatus.signedInState)]]">
        <img class="account-icon small" alt=""
        src="[[getAccountImageSrc_(shownAccount_.avatarImage)]]"
        slot="prefix-icon">
        [[getAccountAwareSigninButtonLabel_(
          '$i18nPolymer{accountAwareSigninButtonLabel}',
          shownAccount_.givenName)]]
        </cr-button>
        <div id="setup-buttons" hidden="[[!showSetupButtons_]]"
            class="cr-button-gap">
          <cr-button on-click="onSetupCancel_">$i18n{cancel}</cr-button>
          <cr-button class="action-button cr-button-gap"
              on-click="onSetupConfirm_">
            $i18n{confirm}
          </cr-button>
        </div>
        <div id="signin-paused-buttons"
            hidden="[[!shouldShowSigninPausedButtons_(
                syncStatus.signinPaused)]]">
          <cr-button class="cr-button-gap" id="remove-account-button"
              hidden="[[shouldHideRemoveAccountButton_(
                  syncStatus.signedInState)]]"
              on-click="onSignoutClick_">
            $i18n{pendingSecondaryButton}
          </cr-button>
          <cr-button class="action-button cr-button-gap"
              on-click="onSigninClick_">
            $i18n{verifyAccount}
          </cr-button>
        </div>

      </div>
      <template is="dom-if"
          if="[[shouldAllowAccountSwitch_(syncStatus.signedInState,
              syncStatus.domain, syncStatus.signinPaused)]]" restamp>
        <cr-action-menu id="menu" auto-reposition
            role-description="$i18n{menu}" on-close="onDropdownClose_">
          <template is="dom-repeat" items="[[storedAccounts_]]">
            <button class="dropdown-item" on-click="onAccountClick_">
              <img class="account-icon small" alt=""
                  src="[[getAccountImageSrc_(item.avatarImage)]]">
              <span>[[item.email]]</span>
            </button>
          </template>
          <button class="dropdown-item" on-click="onSigninClick_"
                  disabled="[[syncStatus.firstSetupInProgress]]"
                  id="sign-in-item">
            <cr-icon icon="cr:add" class="account-icon small" alt=""></cr-icon>
            <span>$i18n{useAnotherAccount}</span>
          </button>
        </cr-action-menu>
      </template>
    </template>
<!--_html_template_end_-->`;
}
