/**
 * @fileoverview 'settings-signout-dialog' is a dialog that allows the
 * user to turn off sync and sign out of Chromium.
 */
import '//resources/cr_elements/cr_button/cr_button.js';
import '//resources/cr_elements/cr_checkbox/cr_checkbox.js';
import '//resources/cr_elements/cr_collapse/cr_collapse.js';
import '//resources/cr_elements/cr_dialog/cr_dialog.js';
import '//resources/cr_elements/cr_expand_button/cr_expand_button.js';
import '//resources/cr_elements/cr_shared_style.css.js';
import '//resources/cr_elements/cr_shared_vars.css.js';
import '../settings_shared.css.js';
import type { CrDialogElement } from '//resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SyncStatus } from '/shared/settings/people_page/sync_browser_proxy.js';
export interface SettingsSignoutDialogElement {
    $: {
        dialog: CrDialogElement;
        disconnectConfirm: HTMLElement;
    };
}
declare const SettingsSignoutDialogElementBase: typeof PolymerElement & (new (...args: any[]) => import("//resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export declare class SettingsSignoutDialogElement extends SettingsSignoutDialogElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * The current sync status, supplied by the parent.
         */
        syncStatus: {
            type: ObjectConstructor;
            observer: string;
        };
        /**
         * True if the checkbox to delete the profile has been checked.
         */
        deleteProfile_: BooleanConstructor;
        /**
         * True if the profile deletion warning is visible.
         */
        deleteProfileWarningVisible_: BooleanConstructor;
        /**
         * The profile deletion warning. The message indicates the number of
         * profile stats that will be deleted if a non-zero count for the profile
         * stats is returned from the browser.
         */
        deleteProfileWarning_: StringConstructor;
    };
    syncStatus: SyncStatus | null;
    private deleteProfile_;
    private deleteProfileWarningVisible_;
    private deleteProfileWarning_;
    connectedCallback(): void;
    /**
     * @return true when the user selected 'Confirm'.
     */
    wasConfirmed(): boolean;
    /**
     * Handler for when the profile stats count is pushed from the browser.
     */
    private handleProfileStatsCount_;
    /**
     * Polymer observer for syncStatus.
     */
    private syncStatusChanged_;
    private getDisconnectExplanationHtml_;
    private onDisconnectCancel_;
    private onDisconnectConfirm_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-signout-dialog': SettingsSignoutDialogElement;
    }
}
export {};
