import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-icons cr-shared-style settings-columned-section settings-shared">.keyboard-shortcut-setting{align-items:start}#mainShortcutSetting{border-top:none}.shortcut-input{margin-top:2px}.section{padding:0 var(--cr-section-padding)}.separator{margin-inline-end:4px;margin-inline-start:0}.toggle-actions-container{display:flex;align-items:center}.learn-more-label[href='']{display:none}</style>

<settings-subpage page-title="$i18n{glicPageTitle}" route-path$="[[routePath]]">
  <template is="dom-if" if="[[disallowedByAdmin_]]" restamp>
    <div class="section">
      <cr-icon icon="cr:domain"></cr-icon>
      $i18n{glicPolicyDisabledMessage}
    </div>
  </template>
  <div class="section">
    <h2 class="cr-title-text">$i18n{glicPreferencesSection}</h2>
    <!-- Glic Policy Disabled - show disabled controls -->
    <template is="dom-if" if="[[disallowedByAdmin_]]" restamp>
      <settings-toggle-button id="launcherToggle" pref="[[fakePref_]]"
          disabled label="$i18n{glicOsWidgetToggle}">
      </settings-toggle-button>
    </template>

    <!-- Glic Policy Enabled -->
    <template is="dom-if"
        on-dom-change="onEnabledTemplateDomChange_"
        if="[[!disallowedByAdmin_]]"
        restamp>
      <settings-toggle-button
          id="tabstripButtonToggle"
          pref="{{prefs.glic.pinned_to_tabstrip}}"
          label="$i18n{glicTabstripButtonToggle}"
          sub-label="$i18n{glicTabstripButtonToggleSublabel}"
          on-settings-boolean-control-change="onTabstripButtonToggleChange_">
      </settings-toggle-button>
      <settings-toggle-button
          id="launcherToggle" pref="{{prefs.glic.launcher_enabled}}"
          label="$i18n{glicOsWidgetToggle}"
          sub-label="$i18n{glicOsWidgetToggleSublabel}"
          learn-more-url="$i18n{glicLauncherToggleLearnMoreUrl}"
          on-learn-more-clicked="onLauncherToggleLearnMoreClick_"
          checked="{{launcherToggleOn_}}"
          on-settings-boolean-control-change="onLauncherToggleChange_">
      </settings-toggle-button>
      <cr-collapse opened="[[launcherToggleOn_]]">
        <div class="cr-row keyboard-shortcut-setting"
             id="mainShortcutSetting">
          <div class="flex cr-padded-text">
            <div class="shortcut-label" aria-hidden>
              $i18n{glicKeyboardShortcut}
            </div>
            <div class="secondary"
                learn-more-url="$i18n{glicKeyboardShortcutLearnMoreUrl}">
              $i18n{glicKeyboardShortcutSublabel}
              <a id="shortcutsLearnMoreLabel" class="learn-more-label"
                  href="$i18n{glicKeyboardShortcutLearnMoreUrl}"
                  aria-label="$i18n{glicKeyboardShortcutLearnMoreLabel}"
                  aria-description="$i18n{opensInNewTab}"
                  on-click="onShortcutsLearnMoreClick_" target="_blank">
                $i18n{glicKeyboardShortcutLearnMoreLabel}
              </a>
            </div>
          </div>
          <cr-shortcut-input class="cr-padded-text shortcut-input"
              input-aria-label="$i18n{glicKeyboardShortcut}"
              shortcut="[[registeredShortcut_]]"
              allow-ctrl-alt-shortcuts
              on-input-capture-change="onInputCaptureChange_"
              on-shortcut-updated="onShortcutUpdated_">
          </cr-shortcut-input>
        </div>
      </cr-collapse>
      <div class="cr-row keyboard-shortcut-setting"
           id="focusToggleShortcutSetting">
        <div class="flex cr-padded-text">
          <div class="shortcut-label" aria-hidden>
            $i18n{glicNavigationShortcut}
          </div>
          <div class="secondary">$i18n{glicNavigationShortcutSublabel}
              <a id="shortcutsNavigationLearnMoreLabel"
                  class="learn-more-label"
                  href="$i18n{glicKeyboardShortcutLearnMoreUrl}"
                  aria-label="$i18n{glicKeyboardShortcutLearnMoreLabel}"
                  aria-description="$i18n{opensInNewTab}"
                  on-click="onShortcutsLearnMoreClick_" target="_blank">
                $i18n{glicKeyboardShortcutLearnMoreLabel}
              </a>
          </div>
        </div>
        <cr-shortcut-input class="cr-padded-text shortcut-input"
            input-aria-label="$i18n{glicNavigationShortcut}"
            shortcut="[[registeredFocusToggleShortcut_]]"
            allow-ctrl-alt-shortcuts
            on-shortcut-updated="onFocusToggleShortcutUpdated_">
        </cr-shortcut-input>
      </div>
      <settings-toggle-button class="hr"
          id="closedCaptionsToggle"
          hidden="[[!closedCaptionsFeatureEnabled_]]"
          pref="{{prefs.glic.closed_captioning_enabled}}"
          label="$i18n{glicClosedCaptionsToggle}"
          sub-label="$i18n{glicClosedCaptionsToggleSublabel}"
          on-settings-boolean-control-change="onClosedCaptionsToggleChange_">
      </settings-toggle-button>
    </template>
  </div>
  <div class="section">
    <h2 class="cr-title-text">$i18n{glicDataSection}</h2>
    <!-- Glic Policy Disabled - show disabled controls -->
    <template is="dom-if" if="[[disallowedByAdmin_]]" restamp>
      <settings-toggle-button
          id="geolocationToggle" pref="[[fakePref_]]" disabled
          label="$i18n{glicLocationToggle}"
          sub-label="[[locationSubLabel_]]">
      </settings-toggle-button>
      <settings-toggle-button
          id="microphoneToggle" pref="[[fakePref_]]" disabled
          label="$i18n{glicMicrophoneToggle}"
          sub-label="[[microphoneSubLabel_]]">
      </settings-toggle-button>
      <settings-toggle-button
          id="tabAccessToggle" pref="[[fakePref_]]" disabled
          label="$i18n{glicTabAccessToggle}"
          sub-label="[[tabAccessSubLabel_]]"
          hidden="[[showGlicDefaultTabContextSetting_]]">
      </settings-toggle-button>
      <settings-toggle-button
          id="defaultTabAccessToggle" pref="[[fakePref_]]" disabled
          label="$i18n{glicDefaultTabAccessToggle}"
          sub-label-with-link="[[defaultTabAccessSubLabel_]]"
          on-sub-label-link-clicked="onDefaultTabAccessToggleLearnMoreClick_"
          hidden="[[!showGlicDefaultTabContextSetting_]]">
      </settings-toggle-button>
    </template>

    <!-- Glic Policy Enabled -->
    <template is="dom-if" if="[[!disallowedByAdmin_]]" restamp>
      <settings-toggle-button
          id="geolocationToggle" pref="{{prefs.glic.geolocation_enabled}}"
          label="$i18n{glicLocationToggle}"
          sub-label="[[locationSubLabel_]]"
          learn-more-url="[[locationLearnMoreUrl_]]"
          on-learn-more-clicked="onLocationToggleLearnMoreClick_"
          on-settings-boolean-control-change="onGeolocationToggleChange_">
      </settings-toggle-button>
      <settings-toggle-button
          id="microphoneToggle" pref="{{prefs.glic.microphone_enabled}}"
          label="$i18n{glicMicrophoneToggle}"
          sub-label="[[microphoneSubLabel_]]"
          on-settings-boolean-control-change="onMicrophoneToggleChange_">
      </settings-toggle-button>
      <div hidden="[[showGlicDefaultTabContextSetting_]]">
      <settings-toggle-button
          id="tabAccessToggle" pref="{{prefs.glic.tab_context_enabled}}"
          label="$i18n{glicTabAccessToggle}"
          sub-label="[[tabAccessSubLabel_]]"
          learn-more-url="[[tabAccessLearnMoreUrl_]]"
          on-learn-more-clicked="onTabAccessToggleLearnMoreClick_"
          on-settings-boolean-control-change="onTabAccessToggleChange_"
          no-toggle-on-host-click on-click="onTabAccessExpand_"
          hidden="[[showGlicDefaultTabContextSetting_]]">
        <div id="tabAccessToggleActions" class="toggle-actions-container"
            slot="more-actions">
          <cr-expand-button id="tabAccessExpandButton" no-hover
              expanded="{{tabAccessToggleExpanded_}}">
          </cr-expand-button>
          <div class="separator"></div>
        </div>
      </settings-toggle-button>
      <cr-collapse id="tabAccessInfoCollapse"
          opened="[[tabAccessToggleExpanded_]]"
          hidden="[[showGlicDefaultTabContextSetting_]]">
        <div class="settings-columned-section">
          <div class="column">
            <h2 class="description-header">$i18n{columnHeadingWhenOn}</h2>
            <ul class="icon-bulleted-list">
              <li>
                <cr-icon aria-hidden="true"

                      icon="settings20:edit-square">


                  </cr-icon>
                  <div class="secondary">$i18n{glicTabAccessWhenOn1}</div>
                </li>
              </ul>
            </div>
            <div class="column">
              <h2 class="description-header">$i18n{columnHeadingConsider}</h2>
              <ul class="icon-bulleted-list">
                <li>
                  <cr-icon aria-hidden="true"

                      icon="settings20:web">


                  </cr-icon>
                  <div class="secondary">$i18n{glicTabAccessConsider1}
                    <a id="shortcutTabAccessConsider1LearnMoreLabel"
                        class="learn-more-label"
                        href="[[tabAccessLearnMoreUrl_]]"
                        on-click="onTabAccessToggleLearnMoreClick_"
                        aria-label=
                           "$i18n{glicTabAccessConsider1LearnMoreLabel}"
                        aria-description="$i18n{opensInNewTab}"
                        target="_blank">
                    $i18n{glicTabAccessConsider1LearnMoreLabel}
                  </a>
                  </div>
                </li>
              </ul>
            </div>
          </div>
        </cr-collapse>
      </div>
      <div hidden="[[!showGlicDefaultTabContextSetting_]]">
        <settings-toggle-button
            id="defaultTabAccessToggle"
            pref="{{prefs.glic.default_tab_context_enabled}}"
            label="$i18n{glicDefaultTabAccessToggle}"
            sub-label-with-link="[[defaultTabAccessSubLabel_]]"
            on-sub-label-link-clicked="onDefaultTabAccessToggleLearnMoreClick_"
            on-settings-boolean-control-change="onDefaultTabAccessToggleChange_"
            no-toggle-on-host-click on-click="onDefaultTabAccessExpand_">
          <div id="defaultTabAccessToggleActions"
              class="toggle-actions-container"
              slot="more-actions">
            <cr-expand-button id="defaultTabAccessExpandButton" no-hover
                expanded="{{defaultTabAccessToggleExpanded_}}">
            </cr-expand-button>
            <div class="separator"></div>
          </div>
        </settings-toggle-button>
        <cr-collapse id="defaultTabAccessInfoCollapse"
            opened="[[defaultTabAccessToggleExpanded_]]">
          <div class="settings-columned-section">
            <div class="column">
              <h2 class="description-header">$i18n{columnHeadingWhenOn}</h2>
              <ul class="icon-bulleted-list">
                <li>
                  <cr-icon aria-hidden="true"

                      icon="settings20:edit-square">


                  </cr-icon>
                  <div class="secondary">
                    $i18n{glicDefaultTabAccessWhenOn1}
                  </div>
                </li>
              </ul>
            </div>
            <div class="column">
              <h2 class="description-header">$i18n{columnHeadingConsider}</h2>
              <ul class="icon-bulleted-list">
                <li>
                  <cr-icon aria-hidden="true"

                      icon="settings20:web">


                  </cr-icon>
                  <div class="secondary">
                    $i18n{glicDefaultTabAccessConsider1}
                  </div>
                </li>
                <li hidden="[[isEnterpriseAccountDataProtected_]]">
                  <cr-icon aria-hidden="true" 
                    icon="settings20:web">
                    
                    
                  </cr-icon>
                  <div class="secondary">
                    $i18n{glicDefaultTabAccessConsider2}
                  </div>
                </li>
              </ul>
            </div>
          </div>
        </cr-collapse>
      </div>
      <cr-link-row id="activityButton" on-click="onActivityRowClick_"
          label="$i18n{glicActivityButton}"
          sub-label="$i18n{glicActivityButtonSublabel}" external>
      </cr-link-row>
      <cr-link-row id="extensionsButton"
          hidden="[[!glicExtensionsFeatureEnabled_]]"
          on-click="onExtensionsRowClick_"
          label="$i18n{glicExtensionsButton}"
          sub-label="$i18n{glicExtensionsButtonSublabel}" external>
      </cr-link-row>
      <cr-link-row id="geminiPersonalContextLink" class="hr"
          hidden="[[!showGlicPersonalContextLink_]]"
          on-click="onGeminiPersonalContextClick_"
          label="$i18n{glicPersonalContextSettingLabel}"
          sub-label="$i18n{glicPersonalContextSettingSublabel}" external>
      </cr-link-row>
    </template>
  </div>
</settings-subpage>
<!--_html_template_end_-->`;
}
