import 'chrome://resources/cr_elements/cr_collapse/cr_collapse.js';
import 'chrome://resources/cr_elements/cr_icons.css.js';
import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import 'chrome://resources/cr_components/cr_shortcut_input/cr_shortcut_input.js';
import '../controls/settings_toggle_button.js';
import 'chrome://resources/cr_elements/cr_expand_button/cr_expand_button.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import '../icons.html.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export declare enum SettingsGlicPageFeaturePrefName {
    CLOSED_CAPTIONS_ENABLED = "glic.closed_captioning_enabled",
    GEOLOCATION_ENABLED = "glic.geolocation_enabled",
    LAUNCHER_ENABLED = "glic.launcher_enabled",
    MICROPHONE_ENABLED = "glic.microphone_enabled",
    SETTINGS_POLICY = "browser.gemini_settings",
    TAB_CONTEXT_ENABLED = "glic.tab_context_enabled",
    TABSTRIP_BUTTON_ENABLED = "glic.pinned_to_tabstrip",
    USER_STATUS = "glic.user_status",
    DEFAULT_TAB_CONTEXT_ENABLED = "glic.default_tab_context_enabled"
}
declare const SettingsGlicSubpageElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_components/help_bubble/help_bubble_mixin.js").HelpBubbleMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsGlicSubpageElement extends SettingsGlicSubpageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        disallowedByAdmin_: {
            type: BooleanConstructor;
            value: boolean;
        };
        registeredShortcut_: {
            type: StringConstructor;
            value: string;
        };
        registeredFocusToggleShortcut_: {
            type: StringConstructor;
            value: string;
        };
        tabAccessToggleExpanded_: {
            type: BooleanConstructor;
            value: boolean;
        };
        fakePref_: {
            type: ObjectConstructor;
            value: {
                key: string;
                type: chrome.settingsPrivate.PrefType;
                value: number;
            };
        };
        closedCaptionsFeatureEnabled_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        glicExtensionsFeatureEnabled_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        glicUserStatusCheckFeatureEnabled_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        showGlicDefaultTabContextSetting_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        showGlicPersonalContextLink_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        locationSubLabel_: {
            type: StringConstructor;
            computed: string;
        };
        locationLearnMoreUrl_: {
            type: StringConstructor;
            computed: string;
        };
        microphoneSubLabel_: {
            type: StringConstructor;
            computed: string;
        };
        tabAccessSubLabel_: {
            type: StringConstructor;
            computed: string;
        };
        tabAccessLearnMoreUrl_: {
            type: StringConstructor;
            computed: string;
        };
        defaultTabAccessToggleExpanded_: {
            type: BooleanConstructor;
            value: boolean;
        };
        defaultTabAccessSubLabel_: {
            type: StringConstructor;
            computed: string;
        };
        defaultTabAccessLearnMoreUrl_: {
            type: StringConstructor;
            computed: string;
        };
        spark_: {
            type: StringConstructor;
            computed: string;
        };
        isEnterpriseAccountDataProtected_: {
            type: BooleanConstructor;
            computed: string;
        };
    };
    static get observers(): string[];
    private shortcutInput_;
    private focusToggleShortcutInput_;
    private removedShortcut_;
    private disallowedByAdmin_;
    private registeredShortcut_;
    private registeredFocusToggleShortcut_;
    private fakePref_;
    private browserProxy_;
    private metricsBrowserProxy_;
    private tabAccessToggleExpanded_;
    private defaultTabAccessToggleExpanded_;
    private closedCaptionsFeatureEnabled_;
    private glicExtensionsFeatureEnabled_;
    private glicUserStatusCheckFeatureEnabled_;
    private showGlicDefaultTabContextSetting_;
    private showGlicPersonalContextLink_;
    private locationSubLabel_;
    private locationLearnMoreUrl_;
    private microphoneSubLabel_;
    private tabAccessSubLabel_;
    private tabAccessLearnMoreUrl_;
    private defaultTabAccessSubLabel_;
    private defaultTabAccessLearnMoreUrl_;
    private spark_;
    private isEnterpriseAccountDataProtected_;
    connectedCallback(): Promise<void>;
    private onEnabledTemplateDomChange_;
    private onLauncherToggleChange_;
    private onGeolocationToggleChange_;
    private onMicrophoneToggleChange_;
    private onShortcutUpdated_;
    private onFocusToggleShortcutUpdated_;
    private recordShortcutEnablement;
    private onInputCaptureChange_;
    private onTabContextEnabledChanged_;
    private onDefaultTabContextEnabledChanged_;
    private onTabAccessToggleChange_;
    private onTabAccessExpand_;
    private onDefaultTabAccessExpand_;
    private onDefaultTabAccessToggleChange_;
    private onActivityRowClick_;
    private onExtensionsRowClick_;
    private onShortcutsLearnMoreClick_;
    private onLauncherToggleLearnMoreClick_;
    private onLocationToggleLearnMoreClick_;
    private onTabAccessToggleLearnMoreClick_;
    private onDefaultTabAccessToggleLearnMoreClick_;
    private onGeminiPersonalContextClick_;
    private disallowedByAdminChanged_;
    private onClosedCaptionsToggleChange_;
    private onTabstripButtonToggleChange_;
    private computeIsEnterpriseAccountDataProtected_;
    private computeLocationSubLabel_;
    private computeLocationLearnMoreUrl_;
    private computeMicrophoneSubLabel_;
    private computeTabAccessSubLabel_;
    private computeTabAccessLearnMoreUrl_;
    private computeDefaultTabAccessSubLabel_;
    private computeDefaultTabAccessLearnMoreUrl_;
    private computeSpark_;
    focusBackButton(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-glic-subpage': SettingsGlicSubpageElement;
    }
}
export {};
