/**
 * @fileoverview
 * 'settings-downloads-page' is the settings page containing downloads
 * settings.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '../controls/controlled_button.js';
import '../controls/settings_toggle_button.js';
import '../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsPlugin } from '../settings_main/settings_plugin.js';
declare const SettingsDownloadsPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export declare class SettingsDownloadsPageElement extends SettingsDownloadsPageElementBase implements SettingsPlugin {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        autoOpenDownloads_: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
         * Whether the user can toggle the option to display downloads when
         * they're done.
         */
        downloadBubblePartialViewControlledByPref_: {
            type: BooleanConstructor;
            value(): boolean;
        };
    };
    private autoOpenDownloads_;
    private downloadBubblePartialViewControlledByPref_;
    private browserProxy_;
    ready(): void;
    private selectDownloadLocation_;
    private onClearAutoOpenFileTypesClick_;
    searchContents(query: string): Promise<import("../search_settings.js").SearchResult>;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-downloads-page': SettingsDownloadsPageElement;
    }
}
export {};
