/**
 * @fileoverview 'settings-clear-browsing-data-account-indicator' is an
 * indicator that informs users of the primary signed-in account.
 */
import '//resources/cr_elements/cr_shared_style.css.js';
import '//resources/cr_elements/cr_shared_vars.css.js';
import '../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
declare const SettingsClearBrowsingDataAccountIndicatorBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export declare class SettingsClearBrowsingDataAccountIndicator extends SettingsClearBrowsingDataAccountIndicatorBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        shouldShowAccountIndicator_: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
        };
        /**
         * The primary signed-in account.
         */
        shownAccount_: StringConstructor;
        /**
         * The current sync status, supplied by SyncBrowserProxy.
         */
        syncStatus_: ObjectConstructor;
    };
    private shouldShowAccountIndicator_;
    private shownAccount_;
    private syncStatus_;
    private syncBrowserProxy_;
    ready(): void;
    /**
     * Computes the shown account from the StoredAccounts list. The shown account
     * is the primary account which is the first element in the StoredAccounts
     * list.
     */
    private handleStoredAccounts_;
    private handleSyncStatus_;
    /**
     * Determines when the account indicator should be shown, in the case where
     * account data would be deleted.
     */
    private computeShouldShowAvatarRow_;
    private getProfileImageSrc_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-clear-browsing-data-account-indicator': SettingsClearBrowsingDataAccountIndicator;
    }
}
export {};
