// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
export class EntityDataManagerProxyImpl {
    addOrUpdateEntityInstance(entityInstance) {
        return chrome.autofillPrivate.addOrUpdateEntityInstance(entityInstance);
    }
    removeEntityInstance(guid) {
        return chrome.autofillPrivate.removeEntityInstance(guid);
    }
    loadEntityInstances() {
        return chrome.autofillPrivate.loadEntityInstances();
    }
    getEntityInstanceByGuid(guid) {
        return chrome.autofillPrivate.getEntityInstanceByGuid(guid);
    }
    getAllEntityTypes() {
        return chrome.autofillPrivate.getAllEntityTypes();
    }
    getAllAttributeTypesForEntityTypeName(entityTypeName) {
        return chrome.autofillPrivate.getAllAttributeTypesForEntityTypeName(entityTypeName);
    }
    addEntityInstancesChangedListener(listener) {
        chrome.autofillPrivate.onEntityInstancesChanged.addListener(listener);
    }
    removeEntityInstancesChangedListener(listener) {
        chrome.autofillPrivate.onEntityInstancesChanged.removeListener(listener);
    }
    getOptInStatus() {
        return chrome.autofillPrivate.getAutofillAiOptInStatus();
    }
    setOptInStatus(optedIn) {
        return chrome.autofillPrivate.setAutofillAiOptInStatus(optedIn);
    }
    static getInstance() {
        return instance || (instance = new EntityDataManagerProxyImpl());
    }
    static setInstance(obj) {
        instance = obj;
    }
}
let instance = null;
